/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.snapshots;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import org.jetbrains.kotlin.TestWithWorkingDir;
import org.jetbrains.kotlin.incremental.snapshots.FileSnapshot;
import org.jetbrains.kotlin.incremental.snapshots.FileSnapshotExternalizer;
import org.jetbrains.kotlin.incremental.snapshots.FileSnapshotProvider;
import org.jetbrains.kotlin.incremental.snapshots.SimpleFileSnapshotProviderImpl;
import org.junit.Assert;
import org.junit.Test;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\b\u0010\n\u001a\u00020\u000bH\u0007J\b\u0010\f\u001a\u00020\u000bH\u0007J\b\u0010\r\u001a\u00020\u000bH\u0007J\b\u0010\u000e\u001a\u00020\u000bH\u0007J\b\u0010\u000f\u001a\u00020\u000bH\u0007J\b\u0010\u0010\u001a\u00020\u000bH\u0007R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/incremental/snapshots/FileSnapshotTest;", "Lorg/jetbrains/kotlin/TestWithWorkingDir;", "()V", "fileSnapshotProvider", "Lorg/jetbrains/kotlin/incremental/snapshots/FileSnapshotProvider;", "getFileSnapshotProvider", "()Lorg/jetbrains/kotlin/incremental/snapshots/FileSnapshotProvider;", "saveAndReadBack", "Lorg/jetbrains/kotlin/incremental/snapshots/FileSnapshot;", "snapshot", "testEqualityDifferentFile", "", "testEqualityDifferentHash", "testEqualityDifferentSize", "testEqualityDifferentTimestamp", "testEqualityNoChanges", "testExternalizer", "kotlin-build-common"})
public final class FileSnapshotTest
extends TestWithWorkingDir {
    private final FileSnapshotProvider getFileSnapshotProvider() {
        return (FileSnapshotProvider)new SimpleFileSnapshotProviderImpl();
    }

    @Test
    public final void testExternalizer() {
        File file = new File(this.getWorkingDir(), "1.txt");
        FilesKt.writeText$default((File)file, (String)"test", null, (int)2, null);
        FileSnapshot snapshot = this.getFileSnapshotProvider().get(file);
        FileSnapshot deserializedSnapshot = this.saveAndReadBack(snapshot);
        Assert.assertEquals((Object)snapshot, (Object)deserializedSnapshot);
    }

    @Test
    public final void testEqualityNoChanges() {
        File file;
        File $receiver = file = new File(this.getWorkingDir(), "1.txt");
        FilesKt.writeText$default((File)$receiver, (String)"file", null, (int)2, null);
        File file2 = file;
        FileSnapshot oldSnapshot = this.getFileSnapshotProvider().get(file2);
        FileSnapshot newSnapshot = this.getFileSnapshotProvider().get(file2);
        Assert.assertEquals((Object)oldSnapshot, (Object)newSnapshot);
    }

    @Test
    public final void testEqualityDifferentFile() {
        File file;
        File $receiver = file = new File(this.getWorkingDir(), "1.txt");
        FilesKt.writeText$default((File)$receiver, (String)"file1", null, (int)2, null);
        File file1 = file;
        File $receiver2 = $receiver = new File(this.getWorkingDir(), "2.txt");
        FilesKt.writeText$default((File)$receiver2, (String)FilesKt.readText$default((File)file1, null, (int)1, null), null, (int)2, null);
        $receiver2.setLastModified(file1.lastModified());
        File file2 = $receiver;
        FileSnapshot oldSnapshot = this.getFileSnapshotProvider().get(file1);
        FileSnapshot newSnapshot = this.getFileSnapshotProvider().get(file2);
        Assert.assertNotEquals((Object)oldSnapshot, (Object)newSnapshot);
    }

    @Test
    public final void testEqualityDifferentTimestamp() {
        File file;
        String text = "file";
        File $receiver = file = new File(this.getWorkingDir(), "1.txt");
        FilesKt.writeText$default((File)$receiver, (String)text, null, (int)2, null);
        File file2 = file;
        FileSnapshot oldSnapshot = this.getFileSnapshotProvider().get(file2);
        Thread.sleep(1000L);
        FilesKt.writeText$default((File)file2, (String)text, null, (int)2, null);
        FileSnapshot newSnapshot = this.getFileSnapshotProvider().get(file2);
        Assert.assertEquals((Object)oldSnapshot, (Object)newSnapshot);
    }

    @Test
    public final void testEqualityDifferentSize() {
        File file;
        File $receiver = file = new File(this.getWorkingDir(), "1.txt");
        FilesKt.writeText$default((File)$receiver, (String)"file", null, (int)2, null);
        File file2 = file;
        FileSnapshot oldSnapshot = this.getFileSnapshotProvider().get(file2);
        FilesKt.writeText$default((File)file2, (String)"file modified", null, (int)2, null);
        FileSnapshot newSnapshot = this.getFileSnapshotProvider().get(file2);
        Assert.assertNotEquals((Object)oldSnapshot, (Object)newSnapshot);
    }

    @Test
    public final void testEqualityDifferentHash() {
        File file;
        File $receiver = file = new File(this.getWorkingDir(), "1.txt");
        FilesKt.writeText$default((File)$receiver, (String)"file", null, (int)2, null);
        File file2 = file;
        FileSnapshot oldSnapshot = this.getFileSnapshotProvider().get(file2);
        FilesKt.writeText$default((File)file2, (String)"main", null, (int)2, null);
        FileSnapshot newSnapshot = this.getFileSnapshotProvider().get(file2);
        Assert.assertNotEquals((Object)oldSnapshot, (Object)newSnapshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final FileSnapshot saveAndReadBack(FileSnapshot snapshot) {
        FileSnapshot fileSnapshot;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        Closeable closeable = new DataOutputStream(byteOut);
        boolean bl = false;
        try {
            DataOutputStream it = (DataOutputStream)closeable;
            FileSnapshotExternalizer.INSTANCE.save((DataOutput)it, snapshot);
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception exception) {
            bl = true;
            try {
                closeable.close();
            }
            catch (Exception $i$a$1$use) {
                // empty catch block
            }
            throw (Throwable)exception;
        }
        finally {
            if (!bl) {
                closeable.close();
            }
        }
        ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
        Closeable closeable2 = new DataInputStream(byteIn);
        boolean bl2 = false;
        try {
            DataInputStream it = (DataInputStream)closeable2;
            fileSnapshot = FileSnapshotExternalizer.INSTANCE.read((DataInput)it);
        }
        catch (Exception exception) {
            bl2 = true;
            try {
                closeable2.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw (Throwable)exception;
        }
        finally {
            if (!bl2) {
                closeable2.close();
            }
        }
        return fileSnapshot;
    }
}

