/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.plugins.resolver.BasicResolver;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.plugins.resolver.util.ResourceMDParser;
import org.apache.ivy.util.Message;

public abstract class AbstractPatternsBasedResolver
extends BasicResolver {
    private List ivyPatterns = new ArrayList();
    private List artifactPatterns = new ArrayList();
    private boolean m2compatible = false;

    @Override
    public ResolvedResource findIvyFileRef(DependencyDescriptor dependencyDescriptor, ResolveData resolveData) {
        ModuleRevisionId moduleRevisionId = dependencyDescriptor.getDependencyRevisionId();
        if (this.m2compatible) {
            moduleRevisionId = AbstractPatternsBasedResolver.convertM2IdForResourceSearch(moduleRevisionId);
        }
        return this.findResourceUsingPatterns(moduleRevisionId, this.ivyPatterns, DefaultArtifact.newIvyArtifact(moduleRevisionId, resolveData.getDate()), this.getRMDParser(dependencyDescriptor, resolveData), resolveData.getDate());
    }

    @Override
    public ResolvedResource findArtifactRef(Artifact artifact, Date date) {
        ModuleRevisionId moduleRevisionId = artifact.getModuleRevisionId();
        if (this.m2compatible) {
            moduleRevisionId = AbstractPatternsBasedResolver.convertM2IdForResourceSearch(moduleRevisionId);
        }
        return this.findResourceUsingPatterns(moduleRevisionId, this.artifactPatterns, artifact, this.getDefaultRMDParser(artifact.getModuleRevisionId().getModuleId()), date);
    }

    @Override
    public final ResolvedResource findResource(ResolvedResource[] resolvedResourceArray, ResourceMDParser resourceMDParser, ModuleRevisionId moduleRevisionId, Date date) {
        if (this.m2compatible) {
            ModuleRevisionId moduleRevisionId2 = moduleRevisionId;
            moduleRevisionId = moduleRevisionId2.getOrganisation() == null || moduleRevisionId2.getOrganisation().indexOf(47) == -1 ? moduleRevisionId2 : ModuleRevisionId.newInstance(moduleRevisionId2.getOrganisation().replace('/', '.'), moduleRevisionId2.getName(), moduleRevisionId2.getBranch(), moduleRevisionId2.getRevision(), moduleRevisionId2.getQualifiedExtraAttributes());
        }
        return super.findResource(resolvedResourceArray, resourceMDParser, moduleRevisionId, date);
    }

    protected final ResolvedResource findResourceUsingPatterns(ModuleRevisionId moduleRevisionId, List list, Artifact artifact, ResourceMDParser resourceMDParser, Date date) {
        ArrayList<ResolvedResource> arrayList = new ArrayList<ResolvedResource>();
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = this.getSettings().getVersionMatcher().isDynamic(moduleRevisionId);
        boolean bl2 = false;
        ResolvedResource[] resolvedResourceArray = list.iterator();
        while (resolvedResourceArray.hasNext() && !bl2) {
            String string = (String)resolvedResourceArray.next();
            ResolvedResource resolvedResource = this.findResourceUsingPattern(moduleRevisionId, string, artifact, resourceMDParser, date);
            if (resolvedResource == null || hashSet.contains(resolvedResource.getRevision())) continue;
            hashSet.add(resolvedResource.getRevision());
            arrayList.add(resolvedResource);
            bl2 = !bl;
        }
        if (arrayList.size() > 1) {
            resolvedResourceArray = arrayList.toArray(new ResolvedResource[arrayList.size()]);
            return this.findResource(resolvedResourceArray, resourceMDParser, moduleRevisionId, date);
        }
        if (arrayList.size() == 1) {
            return (ResolvedResource)arrayList.get(0);
        }
        return null;
    }

    protected abstract ResolvedResource findResourceUsingPattern(ModuleRevisionId var1, String var2, Artifact var3, ResourceMDParser var4, Date var5);

    public void addIvyPattern(String string) {
        this.ivyPatterns.add(string);
    }

    public void addArtifactPattern(String string) {
        this.artifactPatterns.add(string);
    }

    public final List getIvyPatterns() {
        return Collections.unmodifiableList(this.ivyPatterns);
    }

    public List getArtifactPatterns() {
        return Collections.unmodifiableList(this.artifactPatterns);
    }

    protected final void setIvyPatterns(List list) {
        this.ivyPatterns = list;
    }

    protected final void setArtifactPatterns(List list) {
        this.artifactPatterns = list;
    }

    @Override
    public void dumpSettings() {
        String string;
        super.dumpSettings();
        Message.debug("\t\tm2compatible: " + this.m2compatible);
        Message.debug("\t\tivy patterns:");
        ListIterator<Object> listIterator = Collections.unmodifiableList(this.ivyPatterns).listIterator();
        while (listIterator.hasNext()) {
            string = (String)listIterator.next();
            Message.debug("\t\t\t" + string);
        }
        Message.debug("\t\tartifact patterns:");
        listIterator = this.getArtifactPatterns().listIterator();
        while (listIterator.hasNext()) {
            string = (String)listIterator.next();
            Message.debug("\t\t\t" + string);
        }
    }

    public final boolean isM2compatible() {
        return this.m2compatible;
    }

    public void setM2compatible(boolean bl) {
        this.m2compatible = bl;
    }

    protected static ModuleRevisionId convertM2IdForResourceSearch(ModuleRevisionId moduleRevisionId) {
        if (moduleRevisionId.getOrganisation() == null || moduleRevisionId.getOrganisation().indexOf(46) == -1) {
            return moduleRevisionId;
        }
        return ModuleRevisionId.newInstance(moduleRevisionId.getOrganisation().replace('.', '/'), moduleRevisionId.getName(), moduleRevisionId.getBranch(), moduleRevisionId.getRevision(), moduleRevisionId.getQualifiedExtraAttributes());
    }
}

