/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.Action;
import org.netbeans.lib.profiler.common.CommonUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.monitor.VMTelemetryDataManager;
import org.netbeans.lib.profiler.ui.ResultsView;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.graphs.GraphPanel;
import org.netbeans.lib.profiler.ui.graphs.MemoryGraphPanel;
import org.netbeans.lib.profiler.ui.graphs.SurvivingGenerationsGraphPanel;
import org.netbeans.lib.profiler.ui.graphs.ThreadsGraphPanel;
import org.netbeans.lib.profiler.ui.monitor.VMTelemetryModels;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.ExportAction;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ProfilerTopComponent;
import org.netbeans.modules.profiler.SaveViewAction;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.openide.util.HelpCtx;

public final class TelemetryWindow
extends ProfilerTopComponent {
    private static final String HELP_CTX_KEY = "TelemetryWindow.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("TelemetryWindow.HelpCtx");
    private static TelemetryWindow defaultInstance;
    private static final Image windowIcon;
    private final GraphTab generationsPanel;
    private final GraphTab heapPanel;
    private final GraphTab threadsStatsPanel;
    private final ResultsView telemetryView;
    private final MemoryGraphPanel heapGraph;
    private final SurvivingGenerationsGraphPanel generationsGraph;
    private final ThreadsGraphPanel threadsStatsGraph;

    public TelemetryWindow() {
        this.setName(Bundle.LAB_TelemetryWindowName());
        this.setIcon(windowIcon);
        this.getAccessibleContext().setAccessibleDescription(Bundle.TelemetryWindow_TelemetryAccessDescr());
        this.setLayout(new BorderLayout());
        this.telemetryView = new ResultsView();
        this.add((Component)this.telemetryView, "Center");
        this.heapGraph = MemoryGraphPanel.createBigPanel((VMTelemetryModels)NetBeansProfiler.getDefaultNB().getVMTelemetryModels());
        this.generationsGraph = SurvivingGenerationsGraphPanel.createBigPanel((VMTelemetryModels)NetBeansProfiler.getDefaultNB().getVMTelemetryModels());
        this.threadsStatsGraph = ThreadsGraphPanel.createBigPanel((VMTelemetryModels)NetBeansProfiler.getDefaultNB().getVMTelemetryModels());
        this.heapPanel = new GraphTab((GraphPanel)this.heapGraph);
        this.generationsPanel = new GraphTab((GraphPanel)this.generationsGraph);
        this.threadsStatsPanel = new GraphTab((GraphPanel)this.threadsStatsGraph);
        this.telemetryView.addView(Bundle.TelemetryWindow_MemoryHeapTabName(), null, Bundle.TelemetryWindow_MemoryHeapTabDescr(), this.heapPanel.getComponent(), this.heapPanel.getToolbar());
        this.telemetryView.addView(Bundle.TelemetryWindow_MemoryGCTabName(), null, Bundle.TelemetryWindow_MemoryGCTabDescr(), this.generationsPanel.getComponent(), this.generationsPanel.getToolbar());
        this.telemetryView.addView(Bundle.TelemetryWindow_ThreadsStatisticsTabName(), null, Bundle.TelemetryWindow_ThreadsStatisticsTabDescr(), this.threadsStatsPanel.getComponent(), this.threadsStatsPanel.getToolbar());
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
    }

    public static TelemetryWindow getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new TelemetryWindow();
        }
        return defaultInstance;
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public static void closeIfOpened() {
        if (defaultInstance != null) {
            CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (defaultInstance.isOpened()) {
                        defaultInstance.close();
                    }
                }
            });
        }
    }

    public int getPersistenceType() {
        return 2;
    }

    @Override
    protected Component defaultFocusOwner() {
        return this.threadsStatsGraph;
    }

    public void showGC() {
        this.telemetryView.selectView(this.generationsPanel.getComponent());
        this.open();
        this.requestActive();
    }

    public void showHeap() {
        this.telemetryView.selectView(this.heapPanel.getComponent());
        this.open();
        this.requestActive();
    }

    public void showThreads() {
        this.telemetryView.selectView(this.threadsStatsPanel.getComponent());
        this.open();
        this.requestActive();
    }

    protected String preferredID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    static {
        windowIcon = Icons.getImage((String)"ProfilerIcons.WindowTelemetry");
    }

    private static final class GraphTab
    implements SaveViewAction.ViewProvider,
    ExportAction.ExportProvider {
        private final GraphPanel panel;
        private final ProfilerToolbar toolBar;
        private final ExportAction exportActionButton;

        public GraphTab(GraphPanel graphPanel) {
            this.panel = graphPanel;
            this.toolBar = ProfilerToolbar.create((boolean)true);
            this.exportActionButton = new ExportAction(this, null);
            this.toolBar.add((Action)this.exportActionButton);
            this.toolBar.add((Action)new SaveViewAction(this));
            this.toolBar.addSeparator();
            for (Action action : graphPanel.getActions()) {
                this.toolBar.add(action);
            }
        }

        public Component getToolbar() {
            return this.toolBar.getComponent();
        }

        public Component getComponent() {
            return this.panel;
        }

        @Override
        public BufferedImage getViewImage(boolean bl) {
            return UIUtils.createScreenshot((Component)this.panel);
        }

        @Override
        public String getViewName() {
            if (this.panel instanceof MemoryGraphPanel) {
                return "memory-heap";
            }
            if (this.panel instanceof SurvivingGenerationsGraphPanel) {
                return "memory-gc";
            }
            if (this.panel instanceof ThreadsGraphPanel) {
                return "threads-statistics";
            }
            return null;
        }

        @Override
        public boolean fitsVisibleArea() {
            return true;
        }

        @Override
        public boolean hasView() {
            return true;
        }

        private void exportCSVData(String string, ExportDataDumper exportDataDumper) {
            VMTelemetryDataManager vMTelemetryDataManager = Profiler.getDefault().getVMTelemetryManager();
            String string2 = "\r\n";
            String string3 = "\"";
            int n = vMTelemetryDataManager.getItemCount();
            long[] lArray = new long[n];
            long[] lArray2 = new long[n];
            long[] lArray3 = new long[n];
            String string4 = Bundle.Timestamp();
            String string5 = "";
            String string6 = "";
            System.arraycopy(vMTelemetryDataManager.timeStamps, 0, lArray, 0, n);
            if (this.panel instanceof MemoryGraphPanel) {
                System.arraycopy(vMTelemetryDataManager.totalMemory, 0, lArray2, 0, n);
                System.arraycopy(vMTelemetryDataManager.usedMemory, 0, lArray3, 0, n);
                string5 = Bundle.Heap_Size_in_Bytes();
                string6 = Bundle.Used_Heap_in_Bytes();
            } else if (this.panel instanceof SurvivingGenerationsGraphPanel) {
                System.arraycopy(vMTelemetryDataManager.nSurvivingGenerations, 0, lArray2, 0, n);
                System.arraycopy(vMTelemetryDataManager.relativeGCTimeInPerMil, 0, lArray3, 0, n);
                string5 = Bundle.Surviving_Generations();
                string6 = Bundle.Relative_Time_Spent_in_GC();
            } else if (this.panel instanceof ThreadsGraphPanel) {
                System.arraycopy(vMTelemetryDataManager.nTotalThreads, 0, lArray2, 0, n);
                System.arraycopy(vMTelemetryDataManager.loadedClassesCount, 0, lArray3, 0, n);
                string5 = Bundle.Number_of_Threads();
                string6 = Bundle.Loaded_Classes_Count();
            }
            exportDataDumper.dumpData((CharSequence)new StringBuffer(string3 + string4 + string3 + string + string3 + string5 + string3 + string + string3 + string6 + string3 + string2));
            Date date = new Date();
            for (int i = 0; i < n; ++i) {
                date.setTime(lArray[i]);
                exportDataDumper.dumpData((CharSequence)new StringBuffer(string3 + DateFormat.getDateTimeInstance().format(date) + string3 + string + string3 + lArray2[i] + string3 + string + string3 + lArray3[i] + string3 + string2));
            }
            exportDataDumper.close();
        }

        private void exportHTMLData(ExportDataDumper exportDataDumper) {
            VMTelemetryDataManager vMTelemetryDataManager = Profiler.getDefault().getVMTelemetryManager();
            int n = vMTelemetryDataManager.getItemCount();
            long[] lArray = new long[n];
            long[] lArray2 = new long[n];
            long[] lArray3 = new long[n];
            String string = Bundle.Timestamp();
            String string2 = new String();
            String string3 = new String();
            String string4 = new String();
            System.arraycopy(vMTelemetryDataManager.timeStamps, 0, lArray, 0, n);
            if (this.panel instanceof MemoryGraphPanel) {
                System.arraycopy(vMTelemetryDataManager.totalMemory, 0, lArray2, 0, n);
                System.arraycopy(vMTelemetryDataManager.usedMemory, 0, lArray3, 0, n);
                string4 = Bundle.TelemetryWindow_MemoryHeapTabName();
                string2 = Bundle.Heap_Size_in_Bytes();
                string3 = Bundle.Used_Heap_in_Bytes();
            } else if (this.panel instanceof SurvivingGenerationsGraphPanel) {
                System.arraycopy(vMTelemetryDataManager.nSurvivingGenerations, 0, lArray2, 0, n);
                System.arraycopy(vMTelemetryDataManager.relativeGCTimeInPerMil, 0, lArray3, 0, n);
                string4 = Bundle.TelemetryWindow_MemoryGCTabName();
                string2 = Bundle.Surviving_Generations();
                string3 = Bundle.Relative_Time_Spent_in_GC();
            } else if (this.panel instanceof ThreadsGraphPanel) {
                System.arraycopy(vMTelemetryDataManager.nTotalThreads, 0, lArray2, 0, n);
                System.arraycopy(vMTelemetryDataManager.loadedClassesCount, 0, lArray3, 0, n);
                string4 = Bundle.TelemetryWindow_ThreadsStatisticsTabName();
                string2 = Bundle.Number_of_Threads();
                string3 = Bundle.Loaded_Classes_Count();
            }
            StringBuffer stringBuffer = new StringBuffer("<HTML><HEAD><meta http-equiv=\"Content-type\" content=\"text/html; charset=utf-8\" /><TITLE>" + string4 + "</TITLE></HEAD><BODY><table border=\"1\"><tr>");
            stringBuffer.append("<th>").append(string).append("</th><th>").append(string2).append("</th><th>").append(string3).append("</th></tr>");
            exportDataDumper.dumpData((CharSequence)stringBuffer);
            Date date = new Date();
            for (int i = 0; i < n; ++i) {
                date.setTime(lArray[i]);
                exportDataDumper.dumpData((CharSequence)new StringBuffer("<tr><td>" + DateFormat.getDateTimeInstance().format(date) + "</td><td align=right>" + lArray2[i] + "</td><td align=right>" + lArray3[i] + "</td></tr>"));
            }
            exportDataDumper.dumpDataAndClose(new StringBuffer("</table></BODY></HTML>"));
        }

        private void exportXMLData(ExportDataDumper exportDataDumper) {
            VMTelemetryDataManager vMTelemetryDataManager = Profiler.getDefault().getVMTelemetryManager();
            int n = vMTelemetryDataManager.getItemCount();
            long[] lArray = new long[n];
            long[] lArray2 = new long[n];
            long[] lArray3 = new long[n];
            String string = Bundle.Timestamp();
            String string2 = new String();
            String string3 = new String();
            String string4 = new String();
            System.arraycopy(vMTelemetryDataManager.timeStamps, 0, lArray, 0, n);
            if (this.panel instanceof MemoryGraphPanel) {
                System.arraycopy(vMTelemetryDataManager.totalMemory, 0, lArray2, 0, n);
                System.arraycopy(vMTelemetryDataManager.usedMemory, 0, lArray3, 0, n);
                string4 = Bundle.TelemetryWindow_MemoryHeapTabName();
                string2 = Bundle.Heap_Size_in_Bytes();
                string3 = Bundle.Used_Heap_in_Bytes();
            } else if (this.panel instanceof SurvivingGenerationsGraphPanel) {
                System.arraycopy(vMTelemetryDataManager.nSurvivingGenerations, 0, lArray2, 0, n);
                System.arraycopy(vMTelemetryDataManager.relativeGCTimeInPerMil, 0, lArray3, 0, n);
                string4 = Bundle.TelemetryWindow_MemoryGCTabName();
                string2 = Bundle.Surviving_Generations();
                string3 = Bundle.Relative_Time_Spent_in_GC();
            } else if (this.panel instanceof ThreadsGraphPanel) {
                System.arraycopy(vMTelemetryDataManager.nTotalThreads, 0, lArray2, 0, n);
                System.arraycopy(vMTelemetryDataManager.loadedClassesCount, 0, lArray3, 0, n);
                string4 = Bundle.TelemetryWindow_ThreadsStatisticsTabName();
                string2 = Bundle.Number_of_Threads();
                string3 = Bundle.Loaded_Classes_Count();
            }
            String string5 = System.getProperty("line.separator");
            StringBuffer stringBuffer = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + string5 + "<ExportedView Name=\"" + string4 + "\">" + string5);
            stringBuffer.append("<TableData NumRows=\"").append(n).append("\" NumColumns=\"3\">").append(string5).append(" <TableHeader>");
            stringBuffer.append(" <TableColumn>").append(string).append(" </TableColumn>").append(string5).append(" <TableColumn>").append(string2).append(" </TableColumn>").append(string5).append(" <TableColumn>").append(string3).append(" </TableColumn>").append(string5);
            stringBuffer.append(" </TableHeader>").append(string5).append(" <TableBody>").append(string5);
            exportDataDumper.dumpData((CharSequence)stringBuffer);
            Date date = new Date();
            for (int i = 0; i < n; ++i) {
                date.setTime(lArray[i]);
                stringBuffer = new StringBuffer("  <TableRow>" + string5 + "   <TableCell>" + DateFormat.getDateTimeInstance().format(date) + "</TableCell>" + string5);
                stringBuffer.append("   <TableCell>").append(lArray2[i]).append("</TableCell>").append(string5);
                stringBuffer.append("   <TableCell>").append(lArray3[i]).append("</TableCell>").append(string5).append("  </TableRow>").append(string5);
                exportDataDumper.dumpData((CharSequence)stringBuffer);
            }
            exportDataDumper.dumpDataAndClose(new StringBuffer(" </TableBody>" + string5 + "</TableData>" + string5 + "</ExportedView>"));
        }

        @Override
        public void exportData(int n, ExportDataDumper exportDataDumper) {
            if (this.panel instanceof MemoryGraphPanel || this.panel instanceof SurvivingGenerationsGraphPanel || this.panel instanceof ThreadsGraphPanel) {
                switch (n) {
                    case 1: {
                        this.exportCSVData(",", exportDataDumper);
                        break;
                    }
                    case 2: {
                        this.exportCSVData(";", exportDataDumper);
                        break;
                    }
                    case 3: {
                        this.exportXMLData(exportDataDumper);
                        break;
                    }
                    case 4: {
                        this.exportHTMLData(exportDataDumper);
                    }
                }
            }
        }

        @Override
        public boolean hasExportableView() {
            return Profiler.getDefault().getVMTelemetryManager().getItemCount() > 0;
        }

        @Override
        public boolean hasLoadedSnapshot() {
            return false;
        }
    }
}

