/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.exif;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.fibs.geotag.Settings;
import org.fibs.geotag.util.InputStreamGobbler;

public final class Exiftool {
    private static boolean available = false;
    private static String version = null;

    private Exiftool() {
    }

    public static boolean isAvailable() {
        return available;
    }

    public static String getVersion() {
        return version;
    }

    public static void checkExiftoolAvailable() {
        boolean found = true;
        ArrayList<String> command = new ArrayList<String>();
        String exiftool = Settings.get(Settings.SETTING.EXIFTOOL_PATH, "exiftool");
        command.add(exiftool);
        command.add("-ver");
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        try {
            Process process = processBuilder.redirectErrorStream(true).start();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            new InputStreamGobbler(process, (OutputStream)outputStream).start();
            process.waitFor();
            byte[] output = outputStream.toByteArray();
            String outputText = new String(output);
            version = outputText.trim();
            System.out.println("Exiftool " + version);
        }
        catch (IOException e) {
            e.printStackTrace();
            found = false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            found = false;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            found = false;
        }
        available = found;
    }
}

