/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.subphase.DocValueFieldsContext;
import org.elasticsearch.search.internal.SearchContext;

public final class DocValueFieldsFetchSubPhase
implements FetchSubPhase {
    @Override
    public void hitExecute(SearchContext context, FetchSubPhase.HitContext hitContext) {
        if (context.collapse() != null) {
            String name = context.collapse().getFieldType().name();
            if (context.docValueFieldsContext() == null) {
                context.docValueFieldsContext(new DocValueFieldsContext(Collections.singletonList(name)));
            } else if (!context.docValueFieldsContext().fields().contains(name)) {
                context.docValueFieldsContext().fields().add(name);
            }
        }
        if (context.docValueFieldsContext() == null) {
            return;
        }
        for (String field : context.docValueFieldsContext().fields()) {
            MappedFieldType fieldType;
            SearchHitField hitField;
            if (hitContext.hit().fieldsOrNull() == null) {
                hitContext.hit().fields(new HashMap<String, SearchHitField>(2));
            }
            if ((hitField = hitContext.hit().fields().get(field)) == null) {
                hitField = new SearchHitField(field, new ArrayList<Object>(2));
                hitContext.hit().fields().put(field, hitField);
            }
            if ((fieldType = context.mapperService().fullName(field)) == null) continue;
            Object data = context.fieldData().getForField(fieldType).load(hitContext.readerContext());
            ScriptDocValues values = data.getScriptValues();
            values.setNextDocId(hitContext.docId());
            hitField.values().addAll(values.getValues());
        }
    }
}

