/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.internal.DefaultActionConfiguration;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.internal.DefaultJavaForkOptions;
import org.gradle.util.GUtil;
import org.gradle.workers.ForkMode;
import org.gradle.workers.IsolationMode;
import org.gradle.workers.WorkerConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWorkerConfiguration
extends DefaultActionConfiguration
implements WorkerConfiguration {
    private final JavaForkOptions forkOptions;
    private IsolationMode isolationMode = IsolationMode.AUTO;
    private List<File> classpath = Lists.newArrayList();
    private String displayName;

    public DefaultWorkerConfiguration(FileResolver fileResolver) {
        this.forkOptions = new DefaultJavaForkOptions(fileResolver);
        this.forkOptions.workingDir((Object)new File("").getAbsoluteFile());
    }

    @Override
    public Iterable<File> getClasspath() {
        return this.classpath;
    }

    @Override
    public void setClasspath(Iterable<File> classpath) {
        this.classpath = Lists.newArrayList(classpath);
    }

    @Override
    public IsolationMode getIsolationMode() {
        return this.isolationMode;
    }

    @Override
    public void setIsolationMode(IsolationMode isolationMode) {
        this.isolationMode = isolationMode == null ? IsolationMode.AUTO : isolationMode;
    }

    @Override
    public ForkMode getForkMode() {
        switch (this.isolationMode) {
            case AUTO: {
                return ForkMode.AUTO;
            }
            case NONE: 
            case CLASSLOADER: {
                return ForkMode.NEVER;
            }
            case PROCESS: {
                return ForkMode.ALWAYS;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void setForkMode(ForkMode forkMode) {
        switch (forkMode) {
            case AUTO: {
                this.setIsolationMode(IsolationMode.AUTO);
                break;
            }
            case NEVER: {
                this.setIsolationMode(IsolationMode.CLASSLOADER);
                break;
            }
            case ALWAYS: {
                this.setIsolationMode(IsolationMode.PROCESS);
            }
        }
    }

    @Override
    public JavaForkOptions getForkOptions() {
        return this.forkOptions;
    }

    @Override
    public void classpath(Iterable<File> files) {
        GUtil.addToCollection(this.classpath, (Iterable[])new Iterable[]{files});
    }

    @Override
    public void forkOptions(Action<? super JavaForkOptions> forkOptionsAction) {
        forkOptionsAction.execute((Object)this.forkOptions);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }
}

