/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.nullCheck;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeInliner;
import org.jetbrains.kotlin.codegen.optimization.DeadCodeEliminationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.common.OptimizationBasicInterpreter;
import org.jetbrains.kotlin.codegen.optimization.fixStack.StackTransformationUtilsKt;
import org.jetbrains.kotlin.codegen.optimization.nullCheck.Nullability;
import org.jetbrains.kotlin.codegen.optimization.nullCheck.NullabilityInterpreter;
import org.jetbrains.kotlin.codegen.optimization.nullCheck.NullabilityValuesKt;
import org.jetbrains.kotlin.codegen.optimization.nullCheck.RedundantNullCheckV2MethodTransformerKt;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.kotlin.utils.SmartList;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.InsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/nullCheck/RedundantNullCheckV2MethodTransformer;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "()V", "transform", "", "internalClassName", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "TransformerPass", "kotlin-compiler"})
public final class RedundantNullCheckV2MethodTransformer
extends MethodTransformer {
    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        Intrinsics.checkParameterIsNotNull(internalClassName, "internalClassName");
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        while (new TransformerPass(internalClassName, methodNode).run()) {
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0002%&B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eH\u0002J\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00120\u000eH\u0002J\u001c\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00120\u000eH\u0002J \u0010\u0016\u001a\u00060\u0017R\u00020\u00002\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00120\u000eH\u0002J\u0006\u0010\u0018\u001a\u00020\bJ\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u0010H\u0002J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J\u001c\u0010\u001e\u001a\u00020\u00142\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eH\u0002J\u0018\u0010 \u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020!2\u0006\u0010\"\u001a\u00020\bH\u0002J\f\u0010#\u001a\u00020$*\u00020\u000fH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/nullCheck/RedundantNullCheckV2MethodTransformer$TransformerPass;", "", "internalClassName", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;)V", "changes", "", "getInternalClassName", "()Ljava/lang/String;", "getMethodNode", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "analyzeNullabilities", "", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "Lorg/jetbrains/kotlin/codegen/optimization/nullCheck/Nullability;", "analyzeTypesAndRemoveDeadCode", "Lorg/jetbrains/org/objectweb/asm/Type;", "eliminateRedundantChecks", "", "checkedReferenceTypes", "injectNullabilityAssumptions", "Lorg/jetbrains/kotlin/codegen/optimization/nullCheck/RedundantNullCheckV2MethodTransformer$TransformerPass$NullabilityAssumptions;", "run", "transformInstanceOf", "insn", "nullability", "transformNullInstanceOf", "transformNullInstanceOfWithJump", "transformTrivialChecks", "nullabilityMap", "transformTrivialNullJump", "Lorg/jetbrains/org/objectweb/asm/tree/JumpInsnNode;", "alwaysTrue", "getIndex", "", "NullabilityAssumptions", "NullabilityAssumptionsBuilder", "kotlin-compiler"})
    private static final class TransformerPass {
        private boolean changes;
        @NotNull
        private final String internalClassName;
        @NotNull
        private final MethodNode methodNode;

        private final int getIndex(@NotNull AbstractInsnNode $receiver) {
            return this.methodNode.instructions.indexOf($receiver);
        }

        public final boolean run() {
            Map<AbstractInsnNode, Type> checkedReferenceTypes = this.analyzeTypesAndRemoveDeadCode();
            this.eliminateRedundantChecks(checkedReferenceTypes);
            return this.changes;
        }

        /*
         * WARNING - void declaration
         */
        private final Map<AbstractInsnNode, Type> analyzeTypesAndRemoveDeadCode() {
            AbstractInsnNode[] insns = this.methodNode.instructions.toArray();
            Frame<V>[] frames2 = MethodTransformer.analyze(this.internalClassName, this.methodNode, new OptimizationBasicInterpreter());
            HashMap checkedReferenceTypes = new HashMap();
            int n = 0;
            int n2 = insns.length - 1;
            if (n <= n2) {
                while (true) {
                    AbstractInsnNode abstractInsnNode;
                    Frame frame;
                    Map map2;
                    void i;
                    AbstractInsnNode insn = insns[i];
                    Frame frame2 = frames2[i];
                    if (RedundantNullCheckV2MethodTransformerKt.isInstanceOfOrNullCheck(insn)) {
                        map2 = checkedReferenceTypes;
                        Intrinsics.checkExpressionValueIsNotNull(insn, "insn");
                        Frame frame3 = frame2;
                        if (frame3 == null || (frame3 = (BasicValue)StackTransformationUtilsKt.top(frame3)) == null || (frame3 = ((BasicValue)((Object)frame3)).getType()) == null) {
                        } else {
                            frame = frame3;
                            map2.put(abstractInsnNode, frame);
                        }
                    } else if (RedundantNullCheckV2MethodTransformerKt.isCheckParameterNotNull(insn)) {
                        map2 = checkedReferenceTypes;
                        Intrinsics.checkExpressionValueIsNotNull(insn, "insn");
                        Frame frame4 = frame2;
                        if (frame4 == null || (frame4 = (BasicValue)StackTransformationUtilsKt.peek(frame4, 1)) == null || (frame4 = ((BasicValue)((Object)frame4)).getType()) == null) {
                        } else {
                            frame = frame4;
                            map2.put(abstractInsnNode, frame);
                        }
                    }
                    if (i == n2) break;
                    ++i;
                }
            }
            DeadCodeEliminationMethodTransformer deadCodeEliminationMethodTransformer = new DeadCodeEliminationMethodTransformer();
            Intrinsics.checkExpressionValueIsNotNull(frames2, "frames");
            DeadCodeEliminationMethodTransformer.Result dceResult = deadCodeEliminationMethodTransformer.removeDeadCodeByFrames(this.methodNode, frames2);
            if (dceResult.hasRemovedAnything()) {
                this.changes = true;
            }
            return checkedReferenceTypes;
        }

        private final void eliminateRedundantChecks(Map<AbstractInsnNode, ? extends Type> checkedReferenceTypes) {
            NullabilityAssumptions nullabilityAssumptions = this.injectNullabilityAssumptions(checkedReferenceTypes);
            Map<AbstractInsnNode, Nullability> nullabilityMap = this.analyzeNullabilities();
            nullabilityAssumptions.revert();
            this.transformTrivialChecks(nullabilityMap);
        }

        private final NullabilityAssumptions injectNullabilityAssumptions(Map<AbstractInsnNode, ? extends Type> checkedReferenceTypes) {
            return new NullabilityAssumptionsBuilder(checkedReferenceTypes).injectNullabilityAssumptions();
        }

        /*
         * WARNING - void declaration
         */
        private final Map<AbstractInsnNode, Nullability> analyzeNullabilities() {
            Frame<V>[] frames2 = MethodTransformer.analyze(this.internalClassName, this.methodNode, new NullabilityInterpreter());
            AbstractInsnNode[] insns = this.methodNode.instructions.toArray();
            HashMap nullabilityMap = new HashMap();
            int n = 0;
            int n2 = insns.length - 1;
            if (n <= n2) {
                while (true) {
                    void i;
                    Object object;
                    if ((object = frames2[i]) == null || (object = (BasicValue)StackTransformationUtilsKt.top(object)) == null || (object = NullabilityValuesKt.getNullability((BasicValue)object)) == null) {
                    } else {
                        AbstractInsnNode insn;
                        Object nullability = object;
                        if (!Intrinsics.areEqual(nullability, (Object)Nullability.NULLABLE) && RedundantNullCheckV2MethodTransformerKt.isInstanceOfOrNullCheck(insn = insns[i])) {
                            AbstractInsnNode abstractInsnNode;
                            Map map2 = nullabilityMap;
                            Intrinsics.checkExpressionValueIsNotNull(insn, "insn");
                            Object object2 = nullability;
                            map2.put(abstractInsnNode, object2);
                        }
                    }
                    if (i == n2) break;
                    ++i;
                }
            }
            return nullabilityMap;
        }

        private final void transformTrivialChecks(Map<AbstractInsnNode, ? extends Nullability> nullabilityMap) {
            Map<AbstractInsnNode, ? extends Nullability> map2 = nullabilityMap;
            Iterator<Map.Entry<AbstractInsnNode, ? extends Nullability>> iterator2 = map2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<AbstractInsnNode, ? extends Nullability> entry;
                Map.Entry<AbstractInsnNode, ? extends Nullability> entry2 = entry = iterator2.next();
                AbstractInsnNode insn = entry2.getKey();
                entry2 = entry;
                Nullability nullability = entry2.getValue();
                switch (insn.getOpcode()) {
                    case 198: {
                        AbstractInsnNode abstractInsnNode = insn;
                        if (abstractInsnNode == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
                        }
                        this.transformTrivialNullJump((JumpInsnNode)abstractInsnNode, Intrinsics.areEqual((Object)nullability, (Object)Nullability.NULL));
                        break;
                    }
                    case 199: {
                        AbstractInsnNode abstractInsnNode = insn;
                        if (abstractInsnNode == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
                        }
                        this.transformTrivialNullJump((JumpInsnNode)abstractInsnNode, Intrinsics.areEqual((Object)nullability, (Object)Nullability.NOT_NULL));
                        break;
                    }
                    case 193: {
                        this.transformInstanceOf(insn, nullability);
                    }
                }
            }
        }

        private final void transformTrivialNullJump(JumpInsnNode insn, boolean alwaysTrue) {
            InsnList insnList;
            this.changes = true;
            InsnList $receiver = insnList = this.methodNode.instructions;
            RedundantNullCheckV2MethodTransformerKt.popReferenceValueBefore($receiver, insn);
            if (alwaysTrue) {
                $receiver.set(insn, new JumpInsnNode(167, insn.label));
            } else {
                $receiver.remove(insn);
            }
        }

        private final void transformInstanceOf(AbstractInsnNode insn, Nullability nullability) {
            Integer nextOpcode;
            if (Intrinsics.areEqual((Object)nullability, (Object)Nullability.NULL) ^ true) {
                return;
            }
            AbstractInsnNode abstractInsnNode = insn.getPrevious();
            Intrinsics.checkExpressionValueIsNotNull(abstractInsnNode, "insn.previous");
            if (ReifiedTypeInliner.Companion.isOperationReifiedMarker(abstractInsnNode)) {
                return;
            }
            this.changes = true;
            AbstractInsnNode abstractInsnNode2 = insn.getNext();
            Integer n = nextOpcode = abstractInsnNode2 != null ? Integer.valueOf(abstractInsnNode2.getOpcode()) : null;
            if (Intrinsics.areEqual(nextOpcode, (Object)153) || Intrinsics.areEqual(nextOpcode, (Object)154)) {
                this.transformNullInstanceOfWithJump(insn);
            } else {
                this.transformNullInstanceOf(insn);
            }
        }

        private final void transformNullInstanceOf(AbstractInsnNode insn) {
            InsnList insnList;
            InsnList $receiver = insnList = this.methodNode.instructions;
            RedundantNullCheckV2MethodTransformerKt.popReferenceValueBefore($receiver, insn);
            $receiver.set(insn, new InsnNode(3));
        }

        private final void transformNullInstanceOfWithJump(AbstractInsnNode insn) {
            InsnList insnList;
            InsnList $receiver = insnList = this.methodNode.instructions;
            RedundantNullCheckV2MethodTransformerKt.popReferenceValueBefore($receiver, insn);
            AbstractInsnNode $receiver$iv = insn.getNext();
            AbstractInsnNode abstractInsnNode = $receiver$iv;
            if (!(abstractInsnNode instanceof JumpInsnNode)) {
                abstractInsnNode = null;
            }
            JumpInsnNode jumpInsnNode = (JumpInsnNode)abstractInsnNode;
            if (jumpInsnNode == null) {
                AssertionError assertionError;
                AssertionError assertionError2 = assertionError;
                AssertionError assertionError3 = assertionError;
                String string = "JumpInsnNode expected";
                assertionError2((Object)string);
                throw (Throwable)((Object)assertionError3);
            }
            JumpInsnNode jump = jumpInsnNode;
            $receiver.remove(insn);
            if (jump.getOpcode() == 153) {
                $receiver.set(jump, new JumpInsnNode(167, jump.label));
            } else {
                $receiver.remove(jump);
            }
        }

        @NotNull
        public final String getInternalClassName() {
            return this.internalClassName;
        }

        @NotNull
        public final MethodNode getMethodNode() {
            return this.methodNode;
        }

        public TransformerPass(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
            Intrinsics.checkParameterIsNotNull(internalClassName, "internalClassName");
            Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
            this.internalClassName = internalClassName;
            this.methodNode = methodNode;
        }

        @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u000fH\u0002J\f\u0010\u0014\u001a\u00060\u0015R\u00020\u0016H\u0002J\n\u0010\u0017\u001a\u00060\u0015R\u00020\u0016J(\u0010\u0018\u001a\u00020\u000f*\u00060\u0015R\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J(\u0010\u001b\u001a\u00020\u000f*\u00060\u0015R\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J(\u0010\u001c\u001a\u00020\u000f*\u00060\u0015R\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J(\u0010\u001e\u001a\u00020\u000f*\u00060\u0015R\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0005H\u0002R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR6\u0010\t\u001a*\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\f0\nj\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/nullCheck/RedundantNullCheckV2MethodTransformer$TransformerPass$NullabilityAssumptionsBuilder;", "", "checkedReferenceTypes", "", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "Lorg/jetbrains/org/objectweb/asm/Type;", "(Lorg/jetbrains/kotlin/codegen/optimization/nullCheck/RedundantNullCheckV2MethodTransformer$TransformerPass;Ljava/util/Map;)V", "getCheckedReferenceTypes", "()Ljava/util/Map;", "checksDependingOnVariable", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "addDependentCheck", "", "insn", "aLoadInsn", "Lorg/jetbrains/org/objectweb/asm/tree/VarInsnNode;", "collectVariableDependentChecks", "injectAssumptions", "Lorg/jetbrains/kotlin/codegen/optimization/nullCheck/RedundantNullCheckV2MethodTransformer$TransformerPass$NullabilityAssumptions;", "Lorg/jetbrains/kotlin/codegen/optimization/nullCheck/RedundantNullCheckV2MethodTransformer$TransformerPass;", "injectNullabilityAssumptions", "injectAssumptionsForCheck", "varIndex", "varType", "injectAssumptionsForInstanceOfCheck", "injectAssumptionsForNullCheck", "Lorg/jetbrains/org/objectweb/asm/tree/JumpInsnNode;", "injectAssumptionsForParameterNotNullCheck", "kotlin-compiler"})
        private final class NullabilityAssumptionsBuilder {
            private final HashMap<Integer, List<AbstractInsnNode>> checksDependingOnVariable;
            @NotNull
            private final Map<AbstractInsnNode, Type> checkedReferenceTypes;

            @NotNull
            public final NullabilityAssumptions injectNullabilityAssumptions() {
                this.collectVariableDependentChecks();
                return this.injectAssumptions();
            }

            private final void collectVariableDependentChecks() {
                ListIterator<AbstractInsnNode> listIterator = TransformerPass.this.getMethodNode().instructions.iterator();
                while (listIterator.hasNext()) {
                    AbstractInsnNode aLoadInsn;
                    AbstractInsnNode ldcInsn;
                    AbstractInsnNode insn = listIterator.next();
                    if (RedundantNullCheckV2MethodTransformerKt.isInstanceOfOrNullCheck(insn)) {
                        AbstractInsnNode previous2;
                        AbstractInsnNode previous;
                        if (insn.getPrevious() == null) {
                            continue;
                        }
                        if (previous.getOpcode() == 25) {
                            AbstractInsnNode abstractInsnNode = insn;
                            Intrinsics.checkExpressionValueIsNotNull(abstractInsnNode, "insn");
                            AbstractInsnNode abstractInsnNode2 = previous;
                            if (abstractInsnNode2 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
                            }
                            this.addDependentCheck(abstractInsnNode, (VarInsnNode)abstractInsnNode2);
                            continue;
                        }
                        if (previous.getOpcode() != 89) continue;
                        if (previous.getPrevious() == null) {
                            continue;
                        }
                        if (previous2.getOpcode() != 25) continue;
                        AbstractInsnNode abstractInsnNode = insn;
                        Intrinsics.checkExpressionValueIsNotNull(abstractInsnNode, "insn");
                        AbstractInsnNode abstractInsnNode3 = previous2;
                        if (abstractInsnNode3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
                        }
                        this.addDependentCheck(abstractInsnNode, (VarInsnNode)abstractInsnNode3);
                        continue;
                    }
                    if (!RedundantNullCheckV2MethodTransformerKt.isCheckParameterNotNull(insn)) continue;
                    if (insn.getPrevious() == null) {
                        continue;
                    }
                    if (ldcInsn.getOpcode() != 18) continue;
                    if (ldcInsn.getPrevious() == null) {
                        continue;
                    }
                    if (aLoadInsn.getOpcode() != 25) continue;
                    AbstractInsnNode abstractInsnNode = insn;
                    Intrinsics.checkExpressionValueIsNotNull(abstractInsnNode, "insn");
                    AbstractInsnNode abstractInsnNode4 = aLoadInsn;
                    if (abstractInsnNode4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
                    }
                    this.addDependentCheck(abstractInsnNode, (VarInsnNode)abstractInsnNode4);
                }
            }

            /*
             * WARNING - void declaration
             */
            private final void addDependentCheck(AbstractInsnNode insn, VarInsnNode aLoadInsn) {
                Object object;
                void $receiver$iv;
                Map map2 = this.checksDependingOnVariable;
                Integer key$iv = aLoadInsn.var;
                Object value$iv = $receiver$iv.get(key$iv);
                if (value$iv == null) {
                    SmartList answer$iv = new SmartList();
                    $receiver$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(insn);
            }

            private final NullabilityAssumptions injectAssumptions() {
                NullabilityAssumptions nullabilityAssumptions = new NullabilityAssumptions();
                Map map2 = this.checksDependingOnVariable;
                Iterator iterator2 = map2.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry entry;
                    Map.Entry entry2 = entry = iterator2.next();
                    int varIndex = ((Number)entry2.getKey()).intValue();
                    entry2 = entry;
                    List dependentChecks = (List)entry2.getValue();
                    for (AbstractInsnNode checkInsn : dependentChecks) {
                        Type varType;
                        if (this.checkedReferenceTypes.get(checkInsn) == null) {
                            throw (Throwable)((Object)new AssertionError((Object)("No var type @" + TransformerPass.this.getIndex(checkInsn))));
                        }
                        this.injectAssumptionsForCheck(nullabilityAssumptions, varIndex, checkInsn, varType);
                    }
                }
                return nullabilityAssumptions;
            }

            private final void injectAssumptionsForCheck(@NotNull NullabilityAssumptions $receiver, int varIndex, AbstractInsnNode insn, Type varType) {
                switch (insn.getOpcode()) {
                    case 198: 
                    case 199: {
                        AbstractInsnNode abstractInsnNode = insn;
                        if (abstractInsnNode == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
                        }
                        this.injectAssumptionsForNullCheck($receiver, varIndex, (JumpInsnNode)abstractInsnNode, varType);
                        break;
                    }
                    case 184: {
                        boolean bl = RedundantNullCheckV2MethodTransformerKt.isCheckParameterNotNull(insn);
                        if (_Assertions.ENABLED && !bl) {
                            String string = "Expected non-null parameter check @" + TransformerPass.this.getIndex(insn);
                            throw (Throwable)((Object)new AssertionError((Object)string));
                        }
                        this.injectAssumptionsForParameterNotNullCheck($receiver, varIndex, insn, varType);
                        break;
                    }
                    case 193: {
                        this.injectAssumptionsForInstanceOfCheck($receiver, varIndex, insn, varType);
                    }
                }
            }

            private final void injectAssumptionsForNullCheck(@NotNull NullabilityAssumptions $receiver, int varIndex, JumpInsnNode insn, Type varType) {
                NullabilityAssumptions this_$iv;
                AbstractInsnNode insn$iv;
                InsnList insnList;
                boolean jumpsIfNull = insn.getOpcode() == 198;
                LabelNode originalLabel = insn.label;
                Map map2 = $receiver.getOriginalLabels();
                LabelNode labelNode = originalLabel;
                Intrinsics.checkExpressionValueIsNotNull(labelNode, "originalLabel");
                LabelNode labelNode2 = labelNode;
                map2.put(insn, labelNode2);
                insn.label = (LabelNode)$receiver.synthetic((AbstractInsnNode)new LabelNode(new Label()));
                AbstractInsnNode insertAfterNull = jumpsIfNull ? (AbstractInsnNode)insn.label : (AbstractInsnNode)insn;
                AbstractInsnNode insertAfterNonNull = jumpsIfNull ? (AbstractInsnNode)insn : (AbstractInsnNode)insn.label;
                InsnList $receiver2 = insnList = TransformerPass.this.getMethodNode().instructions;
                $receiver2.add(insn.label);
                NullabilityAssumptions nullabilityAssumptions = $receiver;
                AbstractInsnNode abstractInsnNode = insertAfterNull;
                InsnList insnList2 = $receiver2;
                MethodNode tmpMethodNode$iv$iv = new MethodNode();
                ListIterator<AbstractInsnNode> listIterator = new InstructionAdapter(tmpMethodNode$iv$iv);
                Object $receiver3 = listIterator;
                ((InstructionAdapter)$receiver3).aconst(null);
                ((InstructionAdapter)$receiver3).store(varIndex, varType);
                if (jumpsIfNull) {
                    ((InstructionAdapter)$receiver3).goTo(originalLabel.getLabel());
                }
                InsnList insnList3 = tmpMethodNode$iv$iv.instructions;
                Intrinsics.checkExpressionValueIsNotNull(insnList3, "tmpMethodNode.instructions");
                InsnList insnList$iv = insnList3;
                listIterator = insnList$iv.iterator();
                while (listIterator.hasNext()) {
                    insn$iv = (AbstractInsnNode)listIterator.next();
                    this_$iv.synthetic(insn$iv);
                }
                InsnList insnList4 = insnList$iv;
                insnList2.insert(abstractInsnNode, insnList4);
                this_$iv = $receiver;
                abstractInsnNode = insertAfterNonNull;
                insnList2 = $receiver2;
                tmpMethodNode$iv$iv = new MethodNode();
                listIterator = new InstructionAdapter(tmpMethodNode$iv$iv);
                $receiver3 = listIterator;
                ((InstructionAdapter)$receiver3).anew(varType);
                ((InstructionAdapter)$receiver3).store(varIndex, varType);
                if (!jumpsIfNull) {
                    ((InstructionAdapter)$receiver3).goTo(originalLabel.getLabel());
                }
                InsnList insnList5 = tmpMethodNode$iv$iv.instructions;
                Intrinsics.checkExpressionValueIsNotNull(insnList5, "tmpMethodNode.instructions");
                insnList$iv = insnList5;
                listIterator = insnList$iv.iterator();
                while (listIterator.hasNext()) {
                    insn$iv = listIterator.next();
                    this_$iv.synthetic(insn$iv);
                }
                insnList4 = insnList$iv;
                insnList2.insert(abstractInsnNode, insnList4);
            }

            /*
             * WARNING - void declaration
             */
            private final void injectAssumptionsForParameterNotNullCheck(@NotNull NullabilityAssumptions $receiver, int varIndex, AbstractInsnNode insn, Type varType) {
                NullabilityAssumptions nullabilityAssumptions = $receiver;
                AbstractInsnNode abstractInsnNode = insn;
                InsnList insnList = TransformerPass.this.getMethodNode().instructions;
                MethodNode tmpMethodNode$iv$iv = new MethodNode();
                Object object = new InstructionAdapter(tmpMethodNode$iv$iv);
                InstructionAdapter $receiver2 = object;
                $receiver2.anew(varType);
                $receiver2.store(varIndex, varType);
                InsnList insnList2 = tmpMethodNode$iv$iv.instructions;
                Intrinsics.checkExpressionValueIsNotNull(insnList2, "tmpMethodNode.instructions");
                InsnList insnList$iv = insnList2;
                object = insnList$iv.iterator();
                while (object.hasNext()) {
                    void this_$iv;
                    AbstractInsnNode insn$iv = (AbstractInsnNode)object.next();
                    this_$iv.synthetic(insn$iv);
                }
                InsnList insnList3 = insnList$iv;
                insnList.insert(abstractInsnNode, insnList3);
            }

            /*
             * WARNING - void declaration
             */
            private final void injectAssumptionsForInstanceOfCheck(@NotNull NullabilityAssumptions $receiver, int varIndex, AbstractInsnNode insn, Type varType) {
                AbstractInsnNode insertAfterNotNull;
                Object object;
                LabelNode originalLabel;
                boolean jumpsIfInstance;
                AbstractInsnNode abstractInsnNode = insn.getNext();
                if (abstractInsnNode == null) {
                    return;
                }
                AbstractInsnNode next = abstractInsnNode;
                if (next.getOpcode() != 153 && next.getOpcode() != 154) {
                    return;
                }
                if (!(next instanceof JumpInsnNode)) {
                    return;
                }
                boolean bl = jumpsIfInstance = ((JumpInsnNode)next).getOpcode() == 154;
                if (jumpsIfInstance) {
                    originalLabel = ((JumpInsnNode)next).label;
                    object = $receiver.getOriginalLabels();
                    LabelNode labelNode = ((JumpInsnNode)next).label;
                    Intrinsics.checkExpressionValueIsNotNull(labelNode, "next.label");
                    LabelNode labelNode2 = labelNode;
                    object.put(next, labelNode2);
                    LabelNode newLabel = (LabelNode)$receiver.synthetic((AbstractInsnNode)new LabelNode(new Label()));
                    TransformerPass.this.getMethodNode().instructions.add(newLabel);
                    ((JumpInsnNode)next).label = newLabel;
                    insertAfterNotNull = newLabel;
                } else {
                    originalLabel = null;
                    insertAfterNotNull = next;
                }
                Object $receiver2 = object = TransformerPass.this.getMethodNode().instructions;
                NullabilityAssumptions nullabilityAssumptions = $receiver;
                AbstractInsnNode abstractInsnNode2 = insertAfterNotNull;
                Object object2 = $receiver2;
                MethodNode tmpMethodNode$iv$iv = new MethodNode();
                Object object3 = new InstructionAdapter(tmpMethodNode$iv$iv);
                InstructionAdapter $receiver3 = object3;
                $receiver3.anew(varType);
                $receiver3.store(varIndex, varType);
                if (originalLabel != null) {
                    $receiver3.goTo(originalLabel.getLabel());
                }
                InsnList insnList = tmpMethodNode$iv$iv.instructions;
                Intrinsics.checkExpressionValueIsNotNull(insnList, "tmpMethodNode.instructions");
                InsnList insnList$iv = insnList;
                object3 = insnList$iv.iterator();
                while (object3.hasNext()) {
                    void this_$iv;
                    AbstractInsnNode insn$iv = (AbstractInsnNode)object3.next();
                    this_$iv.synthetic(insn$iv);
                }
                InsnList insnList2 = insnList$iv;
                ((InsnList)object2).insert(abstractInsnNode2, insnList2);
            }

            @NotNull
            public final Map<AbstractInsnNode, Type> getCheckedReferenceTypes() {
                return this.checkedReferenceTypes;
            }

            public NullabilityAssumptionsBuilder(@NotNull Map<AbstractInsnNode, ? extends Type> checkedReferenceTypes) {
                Intrinsics.checkParameterIsNotNull(checkedReferenceTypes, "checkedReferenceTypes");
                this.checkedReferenceTypes = checkedReferenceTypes;
                this.checksDependingOnVariable = new HashMap();
            }
        }

        @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0010\u001a\u00020\u00112\u0017\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013\u00a2\u0006\u0002\b\u0016H\u0086\bJ\u0006\u0010\u0017\u001a\u00020\u0015J\u001d\u0010\u0018\u001a\u0002H\u0019\"\b\b\u0000\u0010\u0019*\u00020\f2\u0006\u0010\u001a\u001a\u0002H\u0019\u00a2\u0006\u0002\u0010\u001bR-\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/nullCheck/RedundantNullCheckV2MethodTransformer$TransformerPass$NullabilityAssumptions;", "", "(Lorg/jetbrains/kotlin/codegen/optimization/nullCheck/RedundantNullCheckV2MethodTransformer$TransformerPass;)V", "originalLabels", "Ljava/util/HashMap;", "Lorg/jetbrains/org/objectweb/asm/tree/JumpInsnNode;", "Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;", "Lkotlin/collections/HashMap;", "getOriginalLabels", "()Ljava/util/HashMap;", "syntheticInstructions", "Ljava/util/ArrayList;", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "Lkotlin/collections/ArrayList;", "getSyntheticInstructions", "()Ljava/util/ArrayList;", "listOfSynthetics", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "block", "Lkotlin/Function1;", "Lorg/jetbrains/org/objectweb/asm/commons/InstructionAdapter;", "", "Lkotlin/ExtensionFunctionType;", "revert", "synthetic", "T", "insn", "(Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;)Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "kotlin-compiler"})
        public final class NullabilityAssumptions {
            @NotNull
            private final HashMap<JumpInsnNode, LabelNode> originalLabels = new HashMap();
            @NotNull
            private final ArrayList<AbstractInsnNode> syntheticInstructions = new ArrayList();

            @NotNull
            public final HashMap<JumpInsnNode, LabelNode> getOriginalLabels() {
                return this.originalLabels;
            }

            @NotNull
            public final ArrayList<AbstractInsnNode> getSyntheticInstructions() {
                return this.syntheticInstructions;
            }

            @NotNull
            public final <T extends AbstractInsnNode> T synthetic(@NotNull T insn) {
                Intrinsics.checkParameterIsNotNull(insn, "insn");
                this.syntheticInstructions.add(insn);
                return insn;
            }

            @NotNull
            public final InsnList listOfSynthetics(@NotNull Function1<? super InstructionAdapter, Unit> block) {
                Intrinsics.checkParameterIsNotNull(block, "block");
                MethodNode tmpMethodNode$iv = new MethodNode();
                Object object = new InstructionAdapter(tmpMethodNode$iv);
                block.invoke((InstructionAdapter)object);
                InsnList insnList = tmpMethodNode$iv.instructions;
                Intrinsics.checkExpressionValueIsNotNull(insnList, "tmpMethodNode.instructions");
                InsnList insnList2 = insnList;
                object = insnList2.iterator();
                while (object.hasNext()) {
                    AbstractInsnNode insn = (AbstractInsnNode)object.next();
                    this.synthetic(insn);
                }
                return insnList2;
            }

            public final void revert() {
                Object object = TransformerPass.this.getMethodNode().instructions;
                InsnList $receiver = object;
                Object $receiver$iv = this.syntheticInstructions;
                Iterator iterator2 = $receiver$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv = iterator2.next();
                    AbstractInsnNode it = (AbstractInsnNode)element$iv;
                    $receiver.remove(it);
                }
                $receiver$iv = this.originalLabels;
                Iterator iterator3 = $receiver$iv.entrySet().iterator();
                while (iterator3.hasNext()) {
                    LabelNode originalLabel;
                    Object object2 = object = iterator3.next();
                    JumpInsnNode jumpInsn = (JumpInsnNode)object2.getKey();
                    object2 = object;
                    jumpInsn.label = originalLabel = (LabelNode)object2.getValue();
                }
            }
        }
    }
}

