/**
 * Roundcube List Widget
 *
 * This file is part of the Roundcube Webmail client
 *
 * @licstart  The following is the entire license notice for the
 * JavaScript code in this file.
 *
 * Copyright (c) 2005-2014, The Roundcube Dev Team
 *
 * The JavaScript code in this page is free software: you can
 * redistribute it and/or modify it under the terms of the GNU
 * General Public License (GNU GPL) as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option)
 * any later version.  The code is distributed WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU GPL for more details.
 *
 * As additional permission under GNU GPL version 3 section 7, you
 * may distribute non-source (e.g., minimized or compacted) forms of
 * that code without the copy of the GNU GPL normally required by
 * section 4, provided you include this license notice and a URL
 * through which recipients can access the Corresponding Source.
 *
 * @licend  The above is the entire license notice
 * for the JavaScript code in this file.
 *
 * @author Thomas Bruederli <roundcube@gmail.com>
 * @author Charles McNulty <charles@charlesmcnulty.com>
 *
 * @requires jquery.js, common.js
 */
function rcube_list_widget(a,b){this.ENTER_KEY=13;this.DELETE_KEY=46;this.BACKSPACE_KEY=8;this.tagname=(this.list=a?a:null)?this.list.nodeName.toLowerCase():"table";this.id_regexp=/^rcmrow([a-z0-9\-_=\+\/]+)/i;this.rows={};this.selection=[];this.modkey=this.subject_col=this.colcount=this.rowcount=0;this.aria_listbox=this.toggleselect=this.keyboard=this.column_movable=this.draggable=this.multi_selecting=this.multiexpand=this.multiselect=!1;this.parent_focus=!0;this.col_drag_active=this.drag_active=
!1;this.shift_start=this.last_selected=this.column_fixed=null;this.focused=!1;this.drag_mouse_start=null;this.dblclick_time=500;this.row_init=function(){};if(b&&"object"===typeof b)for(var c in b)this[c]=b[c];rcube_list_widget._instances.push(this)}
rcube_list_widget.prototype={init:function(){"table"==this.tagname&&this.list&&this.list.tBodies[0]?(this.thead=this.list.tHead,this.tbody=this.list.tBodies[0]):"table"!=this.tagname&&this.list&&(this.tbody=this.list);"listbox"==$(this.list).attr("role")&&(this.aria_listbox=!0,this.multiselect&&$(this.list).attr("aria-multiselectable","true"));var a=this;if(this.tbody){this.rows={};this.rowcount=0;var b,c=this.tbody.childNodes;var d=0;for(b=c.length;d<b;d++)1==c[d].nodeType&&(this.rowcount+=this.init_row(c[d])?
1:0);this.init_header();this.frame=this.list.parentNode;this.keyboard&&(rcube_event.add_listener({event:"keydown",object:this,method:"key_press"}),$(this.list).attr("tabindex","0").on("focus",function(b){a.focus(b)}))}this.parent_focus&&(this.list.parentNode.onclick=function(b){a.focus()});return this},init_row:function(a){a.uid=this.get_row_uid(a);if(a&&a.uid){var b=this,c=a.uid;this.rows[c]={uid:c,id:a.id,obj:a};$(a).data("uid",c).mousedown(function(a){return b.drag_row(a,this.uid)}).mouseup(function(a){return 1!=
a.which||b.drag_active?!0:b.click_row(a,this.uid)});bw.touch&&a.addEventListener&&(a.addEventListener("touchstart",function(a){1==a.touches.length&&(b.touchmoved=!1,b.drag_row(rcube_event.touchevent(a.touches[0]),this.uid))},!1),a.addEventListener("touchend",function(a){1==a.changedTouches.length&&(b.touchmoved||b.click_row(rcube_event.touchevent(a.changedTouches[0]),this.uid)||a.preventDefault())},!1),a.addEventListener("touchmove",function(a){1==a.changedTouches.length&&(b.touchmoved=!0,b.drag_active&&
a.preventDefault())},!1));if(this.aria_listbox){var d="l:"+a.id;$(a).attr("role","option").attr("aria-labelledby",d).find(this.col_tagname()).eq(this.subject_col).attr("id",d)}document.all&&(a.onselectstart=function(){return!1});this.row_init(this.rows[c]);this.triggerEvent("initrow",this.rows[c]);return!0}},init_header:function(){if(this.thead){this.colcount=0;this.fixed_header?($(this.list.tHead).replaceWith($(this.fixed_header).find("thead").clone()),$(this.list.tHead).find("th,td").attr("style",
"").find("a").attr("tabindex","-1")):!bw.touch&&0<=this.list.className.indexOf("fixedheader")&&this.init_fixed_header();var a,b=this;if(this.column_movable&&this.thead&&this.thead.rows)for(a=0;a<this.thead.rows[0].cells.length;a++)if(this.column_fixed!=a){var c=this.thead.rows[0].cells[a];c.onmousedown=function(a){return b.drag_column(a,this)};this.colcount++}}},init_fixed_header:function(){var a=$(this.list.tHead).clone();if(this.fixed_header)$(this.fixed_header).find("thead").replaceWith(a);else{this.fixed_header=
$("<table>").attr("class",this.list.className+" fixedcopy").attr("role","presentation").css({position:"fixed"}).append(a).append("<tbody></tbody>");$(this.list).before(this.fixed_header);var b=this;$(window).resize(function(){b.resize()});$(window).scroll(function(){var a=$(window);b.fixed_header.css({marginLeft:-a.scrollLeft()+"px",marginTop:-a.scrollTop()+"px"})})}$(this.list.tHead).find("a.sortcol").attr("tabindex","-1");a.find("a.sortcol").attr("tabindex","0");this.thead=a.get(0);this.resize()},
resize:function(){if(this.fixed_header){var a=[];$(this.tbody).parent().find("thead th,thead td").each(function(b){a[b]=$(this).width()});$(this.thead).parent().width($(this.tbody).parent().width());$(this.thead).find("th,td").each(function(b){$(this).width(a[b])});$(window).scroll()}},clear:function(a){if("table"==this.tagname){var b=document.createElement("tbody");this.list.insertBefore(b,this.tbody);this.list.removeChild(this.list.tBodies[1]);this.tbody=b}else $(this.row_tagname()+":not(.thead)",
this.tbody).remove();this.rows={};this.rowcount=0;this.last_selected=null;a&&this.clear_selection();this.frame&&(this.frame.scrollTop=0);this.resize()},remove_row:function(a,b){var c=this,d=this.rows[a]?this.rows[a].obj:null;d&&(d.style.display="none",b&&this.select_next(),delete this.rows[a],this.rowcount--,clearTimeout(this.resize_timeout),this.resize_timeout=setTimeout(function(){c.resize()},50))},insert_row:function(a,b){var c=this,d=this.tbody;if(void 0===a.nodeName){var e,f,g=document.createElement(this.row_tagname());
a.id&&(g.id=a.id);a.uid&&(g.uid=a.uid);a.className&&(g.className=a.className);a.style&&$.extend(g.style,a.style);for(e=0;a.cols&&e<a.cols.length;e++){var h=a.cols[e];var k=h.dom;if(!k)for(f in k=document.createElement(this.col_tagname()),h.className&&(k.className=h.className),h.innerHTML&&(k.innerHTML=h.innerHTML),h.events)k["on"+f]=h.events[f];g.appendChild(k)}a=g}b&&d.childNodes.length?d.insertBefore(a,"object"==typeof b&&b.parentNode==d?b:d.firstChild):d.appendChild(a);this.init_row(a);this.rowcount++;
clearTimeout(this.resize_timeout);this.resize_timeout=setTimeout(function(){c.resize()},50)},update_row:function(a,b,c,d){var e=this.rows[a];if(!e)return!1;for(var f=e.obj,e=0;b&&e<b.length;e++)this.get_cell(f,e).html(b[e]);c&&(delete this.rows[a],f.uid=c,f.id="rcmrow"+c,this.init_row(f),d&&(this.selection[0]=c),this.last_selected==a&&(this.last_selected=c))},focus:function(a){this.focused||(this.focused=!0,a&&rcube_event.cancel(a),a=null,this.last_selected&&this.rows[this.last_selected]&&(a=$(this.rows[this.last_selected].obj).find(this.col_tagname()).eq(this.subject_col).attr("tabindex",
"0")),a&&a.length?this.focus_noscroll(a):($("iframe,:focus:not(body)").blur(),window.focus()),$(this.list).addClass("focus").removeAttr("tabindex"),this.last_selected||this.select_first(CONTROL_KEY))},blur:function(a){this.focused=!1;var b=this;setTimeout(function(){$(b.list).attr("tabindex","0")},20);this.last_selected&&this.rows[this.last_selected]&&$(this.rows[this.last_selected].obj).find(this.col_tagname()).eq(this.subject_col).removeAttr("tabindex");$(this.list).removeClass("focus")},focus_noscroll:function(a){var b=
this.frame.scrollTop||this.frame.scrollY;a.focus();this.frame.scrollTop=b},hide_column:function(a,b){b=b?"addClass":"removeClass";if(this.fixed_header)$(this.row_tagname()+" "+this.col_tagname()+"."+a,this.fixed_header)[b]("hidden");$(this.row_tagname()+" "+this.col_tagname()+"."+a,this.list)[b]("hidden")},drag_column:function(a,b){if(1<this.colcount)for(this.drag_start=!0,this.drag_mouse_start=rcube_event.get_mouse_pos(a),rcube_event.add_listener({event:"mousemove",object:this,method:"column_drag_mouse_move"}),
rcube_event.add_listener({event:"mouseup",object:this,method:"column_drag_mouse_up"}),this.add_dragfix(),a=0;a<this.thead.rows[0].cells.length;a++)if(b==this.thead.rows[0].cells[a]){this.selected_column=a;break}return!1},drag_row:function(a,b){if(!this.is_event_target(a)||2==rcube_event.get_button(a))return!0;this.in_selection_before=a&&a.istouch||this.in_selection(b)?b:!1;if(!this.in_selection_before){var c=rcube_event.get_modifier(a);this.select_row(b,c,!0)}this.draggable&&this.selection.length&&
this.in_selection(b)&&(this.drag_start=!0,this.drag_mouse_start=rcube_event.get_mouse_pos(a),rcube_event.add_listener({event:"mousemove",object:this,method:"drag_mouse_move"}),rcube_event.add_listener({event:"mouseup",object:this,method:"drag_mouse_up"}),bw.touch&&(rcube_event.add_listener({event:"touchmove",object:this,method:"drag_mouse_move"}),rcube_event.add_listener({event:"touchend",object:this,method:"drag_mouse_up"})),this.add_dragfix());return!1},click_row:function(a,b){if(!b||!this.rows[b])return!1;
if(!this.is_event_target(a))return!0;var c=(new Date).getTime(),d=c-this.rows[b].clicked<this.dblclick_time;this.drag_active||d||this.in_selection_before!=b||this.select_row(b,rcube_event.get_modifier(a),!0);this.in_selection_before=this.drag_start=!1;this.rowcount&&d&&this.in_selection(b)?(this.triggerEvent("dblclick"),c=0):this.triggerEvent("click");this.drag_active||(this.del_dragfix(),rcube_event.cancel(a));this.rows[b].clicked=c;this.focus();return!1},is_event_target:function(a){a=rcube_event.get_target(a);
var b=a.tagName.toLowerCase();return!(a&&("input"==b||"img"==b||"a"!=b&&a.onclick))},find_root:function(a){var b=this.rows[a];return b&&b.parent_uid?this.find_root(b.parent_uid):a},expand_row:function(a,b){b=this.rows[b];var c=rcube_event.get_target(a);a=rcube_event.get_modifier(a);b.clicked=0;b.expanded?(c.className="collapsed",a==CONTROL_KEY||this.multiexpand?this.collapse_all(b):this.collapse(b)):(c.className="expanded",a==CONTROL_KEY||this.multiexpand?this.expand_all(b):this.expand(b))},collapse:function(a){var b=
a.depth,c=a?a.obj.nextSibling:null;a.expanded=!1;for(this.triggerEvent("expandcollapse",{uid:a.uid,expanded:a.expanded,obj:a.obj});c;){if(1==c.nodeType){if((a=this.rows[c.uid])&&a.depth<=b)break;$(c).css("display","none");a.expanded&&(a.expanded=!1,this.triggerEvent("expandcollapse",{uid:a.uid,expanded:a.expanded,obj:c}))}c=c.nextSibling}this.resize();this.triggerEvent("listupdate");return!1},expand:function(a){var b,c;if(a){a.expanded=!0;var d=a.depth;var e=a.obj.nextSibling;this.update_expando(a.id,
!0);this.triggerEvent("expandcollapse",{uid:a.uid,expanded:a.expanded,obj:a.obj})}else{e=this.tbody.firstChild;var f=d=0}for(;e;){if(1==e.nodeType&&(b=this.rows[e.uid])){if(a&&(!b.depth||b.depth<=d))break;if(b.parent_uid)if((c=this.rows[b.parent_uid])&&c.expanded){if(a&&c==a||f>=c.depth-1)f=c.depth,$(e).css("display",""),b.expanded=!0,this.triggerEvent("expandcollapse",{uid:b.uid,expanded:b.expanded,obj:e})}else if(a&&(!c||c.depth<=d))break}e=e.nextSibling}this.resize();this.triggerEvent("listupdate");
return!1},collapse_all:function(a){var b;if(a){a.expanded=!1;var c=a.depth;var d=a.obj.nextSibling;this.update_expando(a.id);this.triggerEvent("expandcollapse",{uid:a.uid,expanded:a.expanded,obj:a.obj});if(c&&this.multiexpand)return!1}else d=this.tbody.firstChild,c=0;for(;d;){if(1==d.nodeType&&(b=this.rows[d.uid])){if(a&&(!b.depth||b.depth<=c))break;(a||b.depth)&&$(d).css("display","none");b.has_children&&b.expanded&&(b.expanded=!1,this.update_expando(b.id,!1),this.triggerEvent("expandcollapse",{uid:b.uid,
expanded:b.expanded,obj:d}))}d=d.nextSibling}this.resize();this.triggerEvent("listupdate");return!1},expand_all:function(a){var b;if(a){a.expanded=!0;var c=a.depth;var d=a.obj.nextSibling;this.update_expando(a.id,!0);this.triggerEvent("expandcollapse",{uid:a.uid,expanded:a.expanded,obj:a.obj})}else d=this.tbody.firstChild,c=0;for(;d;){if(1==d.nodeType&&(b=this.rows[d.uid])){if(a&&b.depth<=c)break;$(d).css("display","");b.has_children&&!b.expanded&&(b.expanded=!0,this.update_expando(b.id,!0),this.triggerEvent("expandcollapse",
{uid:b.uid,expanded:b.expanded,obj:d}))}d=d.nextSibling}this.resize();this.triggerEvent("listupdate");return!1},update_expando:function(a,b){if(a=document.getElementById("rcmexpando"+a))a.className=b?"expanded":"collapsed"},get_row_uid:function(a){if(a){if(!a.uid){var b=$(a).data("uid");b?a.uid=b:String(a.id).match(this.id_regexp)&&(a.uid=RegExp.$1)}return a.uid}},get_next_row:function(){if(!this.rowcount)return!1;for(var a=this.rows[this.last_selected],a=a?a.obj.nextSibling:null;a&&(1!=a.nodeType||
"none"==a.style.display);)a=a.nextSibling;return a},get_prev_row:function(){if(!this.rowcount)return!1;for(var a=this.rows[this.last_selected],a=a?a.obj.previousSibling:null;a&&(1!=a.nodeType||"none"==a.style.display);)a=a.previousSibling;return a},get_first_row:function(){if(this.rowcount){var a,b,c=this.tbody.childNodes;for(a=0;a<c.length;a++)if(c[a].id&&(b=this.get_row_uid(c[a])))return b}return null},get_last_row:function(){if(this.rowcount){var a,b,c=this.tbody.childNodes;for(a=c.length-1;0<=
a;a--)if(c[a].id&&(b=this.get_row_uid(c[a])))return b}return null},row_tagname:function(){var a={table:"tr",ul:"li","*":"div"};return a[this.tagname]||a["*"]},col_tagname:function(){var a={table:"td","*":"span"};return a[this.tagname]||a["*"]},get_cell:function(a,b){return $(this.col_tagname(),a).eq(b)},select_row:function(a,b,c){var d=this.selection.join(","),e=this.in_selection(a);!this.multiselect&&c&&(b=0);this.shift_start||(this.shift_start=a);if(b){switch(b){case SHIFT_KEY:this.shift_select(a,
!1);break;case CONTROL_KEY:c&&(this.shift_start=a,this.highlight_row(a,!0));break;case CONTROL_SHIFT_KEY:this.shift_select(a,!0);break;default:this.highlight_row(a,!1)}this.multi_selecting=!0}else this.shift_start=a,this.highlight_row(a,!1),this.multi_selecting=!1;this.last_selected&&this.rows[this.last_selected]&&$(this.rows[this.last_selected].obj).removeClass("focused").find(this.col_tagname()).eq(this.subject_col).removeAttr("tabindex");this.toggleselect&&e&&!b?this.clear_selection():this.selection.join(",")!=
d&&this.triggerEvent("select");this.rows[a]&&($(this.rows[a].obj).addClass("focused"),this.focused&&this.focus_noscroll($(this.rows[a].obj).find(this.col_tagname()).eq(this.subject_col).attr("tabindex","0")));this.selection.length||(this.shift_start=null);this.last_selected=a},select:function(a){this.select_row(a,!1);this.scrollto(a)},select_next:function(){var a=this.get_next_row(),b=this.get_prev_row();(a=a?a:b)&&this.select_row(a.uid,!1,!1)},select_first:function(a){var b=this.get_first_row();
b&&(this.select_row(b,a,!1),this.scrollto(b))},select_last:function(a){var b=this.get_last_row();b&&(this.select_row(b,a,!1),this.scrollto(b))},select_children:function(a){var b=this.row_children(a),c=b.length;for(a=0;a<c;a++)this.in_selection(b[a])||this.select_row(b[a],CONTROL_KEY,!0)},shift_select:function(a,b){this.rows[this.shift_start]&&this.selection.length||(this.shift_start=a);var c,d=this.rows[a];var e=this._rowIndex(this.rows[this.shift_start].obj);var f=this._rowIndex(d.obj);e<f&&!d.expanded&&
d.has_children&&(d=this.rows[this.row_children(a).pop()])&&(f=this._rowIndex(d.obj));a=e<f?e:f;e=e>f?e:f;for(c in this.rows)this._rowIndex(this.rows[c].obj)>=a&&this._rowIndex(this.rows[c].obj)<=e?this.in_selection(c)||this.highlight_row(c,!0):this.in_selection(c)&&!b&&this.highlight_row(c,!0)},_rowIndex:function(a){return void 0!==a.rowIndex?a.rowIndex:$(a).prevAll().length},in_selection:function(a,b){for(var c in this.selection)if(this.selection[c]==a)return b?parseInt(c):!0;return!1},select_all:function(a){if(!this.rowcount)return!1;
var b,c=this.selection.join(",");this.selection=[];for(b in this.rows)a&&1!=this.rows[b][a]?$(this.rows[b].obj).removeClass("selected").removeAttr("aria-selected"):(this.last_selected=b,this.highlight_row(b,!0,!0));this.selection.join(",")!=c&&this.triggerEvent("select");this.focus();return!0},invert_selection:function(){if(!this.rowcount)return!1;var a,b=this.selection.join(",");for(a in this.rows)this.highlight_row(a,!0);this.selection.join(",")!=b&&this.triggerEvent("select");this.focus();return!0},
clear_selection:function(a,b){var c,d=this.selection.length;if(a)for(c in this.selection){if(this.selection[c]==a){this.selection.splice(c,1);break}}else{for(c in this.selection)this.rows[this.selection[c]]&&$(this.rows[this.selection[c]].obj).removeClass("selected").removeAttr("aria-selected");this.selection=[]}!d||this.selection.length||b||(this.triggerEvent("select"),this.last_selected=null)},get_selection:function(a){var b=$.merge([],this.selection);if(!1!==a&&b.length)for(var c,d=0,e=b.length;d<
e;d++)if(a=b[d],this.rows[a]&&this.rows[a].has_children&&!this.rows[a].expanded){c=this.row_children(a);for(var f=0,g=c.length;f<g;f++)a=c[f],this.in_selection(a)||b.push(a)}return b},get_single_selection:function(){return 1==this.selection.length?this.selection[0]:null},highlight_row:function(a,b,c){if(this.rows[a])if(b){var d=this.in_selection(a,!0);!1===d?(this.selection.push(a),$(this.rows[a].obj).addClass("selected").attr("aria-selected","true"),c||this.rows[a].expanded||this.highlight_children(a,
!0)):(b=this.selection.slice(0,d),d=this.selection.slice(d+1,this.selection.length),this.selection=b.concat(d),$(this.rows[a].obj).removeClass("selected").removeAttr("aria-selected"),c||this.rows[a].expanded||this.highlight_children(a,!1))}else if(1<this.selection.length||!this.in_selection(a))this.clear_selection(null,!0),this.selection[0]=a,$(this.rows[a].obj).addClass("selected").attr("aria-selected","true")},highlight_children:function(a,b){var c=this.row_children(a),d=c.length;for(a=0;a<d;a++){var e=
this.in_selection(c[a]);(b&&!e||!b&&e)&&this.highlight_row(c[a],!0,!0)}},key_press:function(a){var b=a.target||{};if(!this.focused||"INPUT"==b.nodeName||"TEXTAREA"==b.nodeName||"SELECT"==b.nodeName)return!0;var b=rcube_event.get_keycode(a),c=rcube_event.get_modifier(a);switch(b){case 40:case 38:case 63233:case 63232:return rcube_event.cancel(a),this.use_arrow_key(b,c);case 32:return rcube_event.cancel(a),this.select_row(this.last_selected,c,!0);case 37:case 39:return rcube_event.cancel(a),a=this.use_arrow_key(b,
c),this.key_pressed=b,this.modkey=c,this.triggerEvent("keypress"),this.modkey=0,a;case 36:return this.select_first(c),rcube_event.cancel(a);case 35:return this.select_last(c),rcube_event.cancel(a);case 27:return this.drag_active?this.drag_mouse_up(a):this.col_drag_active?(this.selected_column=null,this.column_drag_mouse_up(a)):rcube_event.cancel(a);case 9:this.blur();break;case 13:this.selection.length||this.select_row(this.last_selected,c,!1);default:if(this.key_pressed=b,this.modkey=c,this.triggerEvent("keypress"),
this.modkey=0,this.key_pressed==this.BACKSPACE_KEY)return rcube_event.cancel(a)}return!0},use_arrow_key:function(a,b){var c=this.rows[this.last_selected];if(40==a||63233==a)a=this.get_next_row();else if(38==a||63232==a)a=this.get_prev_row();else{if(!c||!c.has_children)return;if(39==a){if(c.expanded)return;b==CONTROL_KEY||this.multiexpand?this.expand_all(c):this.expand(c)}else{if(!c.expanded)return;b==CONTROL_KEY||this.multiexpand?this.collapse_all(c):this.collapse(c)}this.update_expando(c.id,c.expanded);
return!1}a?(b||this.selection.length||(b=CONTROL_KEY),this.select_row(a.uid,b,!1),this.scrollto(a.uid)):a||c||this.select_first(CONTROL_KEY);return!1},scrollto:function(a){var b=this.rows[a]?this.rows[a].obj:null;if(b&&this.frame){var c=Number(b.offsetTop),d=0;!c&&this.rows[a].parent_uid&&(a=this.find_root(this.rows[a].uid),this.expand_all(this.rows[a]),c=Number(b.offsetTop));this.fixed_header&&(d=Number(this.thead.offsetHeight));c<Number(this.frame.scrollTop)+d?this.frame.scrollTop=c-d:c+Number(b.offsetHeight)>
Number(this.frame.scrollTop)+Number(this.frame.offsetHeight)&&(this.frame.scrollTop=c+Number(b.offsetHeight)-Number(this.frame.offsetHeight))}},drag_mouse_move:function(a){if("touchmove"==a.type)if(1==a.touches.length&&1==a.changedTouches.length)a=rcube_event.touchevent(a.changedTouches[0]);else return rcube_event.cancel(a);if(this.drag_start){var b=rcube_event.get_mouse_pos(a),c=[],d=this;if(!this.drag_mouse_start||3>Math.abs(b.x-this.drag_mouse_start.x)&&3>Math.abs(b.y-this.drag_mouse_start.y))return!1;
this.drag_start_pos={left:b.x,top:b.y};this.draglayer?this.draglayer.html(""):this.draglayer=$("<div>").attr("id","rcmdraglayer").css({position:"absolute",display:"none","z-index":2E3}).appendTo(document.body);$(this.row_tagname()+".selected",this.tbody).each(function(){var a=d.get_row_uid(this),b=d.rows[a];if(b&&!(-1<$.inArray(a,c))&&(c.push(a),b.has_children&&!b.expanded&&$.each(d.row_children(a),function(){-1<$.inArray(this,c)||c.push(this)}),11<c.length))return!1});$.each(c,function(a,b){if(10<
a)return d.draglayer.append("..."),!1;$("> "+d.col_tagname(),d.rows[b].obj).each(function(a,b){if(0>d.subject_col||0<=d.subject_col&&d.subject_col==a)if(b=$(b).clone(),$(b).find(".skip-on-drag").remove(),a=b.text())return a=$.trim(a),a=50<a.length?a.substring(0,50)+"...":a,d.draglayer.append($("<div>").text(a)),!1})});this.draglayer.show();this.drag_active=!0;this.triggerEvent("dragstart")}this.drag_active&&this.draglayer&&(b=rcube_event.get_mouse_pos(a),this.draglayer.css({left:b.x+20+"px",top:b.y-
5+(bw.ie?document.documentElement.scrollTop:0)+"px"}),this.triggerEvent("dragmove",a?a:window.event));return this.drag_start=!1},drag_mouse_up:function(a){document.onmousemove=null;if("touchend"==a.type&&1!=a.changedTouches.length)return rcube_event.cancel(a);this.draglayer&&this.draglayer.is(":visible")&&(this.drag_start_pos?this.draglayer.animate(this.drag_start_pos,300,"swing").hide(20):this.draglayer.hide());this.drag_active&&this.focus();this.drag_active=!1;rcube_event.remove_listener({event:"mousemove",
object:this,method:"drag_mouse_move"});rcube_event.remove_listener({event:"mouseup",object:this,method:"drag_mouse_up"});bw.touch&&(rcube_event.remove_listener({event:"touchmove",object:this,method:"drag_mouse_move"}),rcube_event.remove_listener({event:"touchend",object:this,method:"drag_mouse_up"}));this.del_dragfix();this.triggerEvent("dragend",a);return rcube_event.cancel(a)},column_drag_mouse_move:function(a){if(this.drag_start){var b=rcube_event.get_mouse_pos(a);if(!this.drag_mouse_start||3>
Math.abs(b.x-this.drag_mouse_start.x)&&3>Math.abs(b.y-this.drag_mouse_start.y))return!1;if(!this.col_draglayer){b=$(this.list).offset();var c=this.thead.rows[0].cells;b.top+=this.list.scrollTop+this.list.parentNode.scrollTop;this.col_draglayer=$("<div>").attr("id","rcmcoldraglayer").css(b).css({position:"absolute","z-index":2001,"background-color":"white",opacity:.75,height:this.frame.offsetHeight-2+"px",width:this.frame.offsetWidth-2+"px"}).appendTo(document.body).append($("<div>").attr("id","rcmcolumnindicator").css({position:"absolute",
"border-right":"2px dotted #555","z-index":2002,height:this.frame.offsetHeight-2+"px"}));this.cols=[];this.list_pos=this.list_min_pos=b.left;for(b=0;b<c.length;b++)this.cols[b]=c[b].offsetWidth,null!==this.column_fixed&&b<=this.column_fixed&&(this.list_min_pos+=this.cols[b])}this.col_draglayer.show();this.col_drag_active=!0;this.triggerEvent("column_dragstart")}if(this.col_drag_active&&this.col_draglayer){var c=0,d=rcube_event.get_mouse_pos(a);for(b=0;b<this.cols.length;b++)if(d.x>=this.cols[b]/2+
this.list_pos+c)c+=this.cols[b];else break;0==b&&this.list_min_pos>d.x?c=this.list_min_pos-this.list_pos:this.list.rowcount||b!=this.cols.length||(c-=2);$("#rcmcolumnindicator").css({width:c+"px"});this.triggerEvent("column_dragmove",a?a:window.event)}return this.drag_start=!1},column_drag_mouse_up:function(a){document.onmousemove=null;this.col_draglayer&&(this.col_draglayer.remove(),this.col_draglayer=null);rcube_event.remove_listener({event:"mousemove",object:this,method:"column_drag_mouse_move"});
rcube_event.remove_listener({event:"mouseup",object:this,method:"column_drag_mouse_up"});this.del_dragfix();if(this.col_drag_active&&(this.col_drag_active=!1,this.focus(),this.triggerEvent("column_dragend",a),null!==this.selected_column&&this.cols&&this.cols.length)){var b,c=0,d=rcube_event.get_mouse_pos(a);for(b=0;b<this.cols.length;b++)if(d.x>=this.cols[b]/2+this.list_pos+c)c+=this.cols[b];else break;b!=this.selected_column&&b!=this.selected_column+1&&this.column_replace(this.selected_column,b)}return rcube_event.cancel(a)},
row_children:function(a){if(!this.rows[a]||!this.rows[a].has_children)return[];var b=[],c=this.rows[a].depth;for(a=this.rows[a].obj.nextSibling;a;){if(1==a.nodeType&&(r=this.rows[a.uid])){if(!r.depth||r.depth<=c)break;b.push(r.uid)}a=a.nextSibling}return b},add_dragfix:function(){$("iframe").each(function(){$('<div class="iframe-dragdrop-fix"></div>').css({background:"#fff",width:this.offsetWidth+"px",height:this.offsetHeight+"px",position:"absolute",opacity:"0.001",zIndex:1E3}).css($(this).offset()).appendTo(document.body)})},
del_dragfix:function(){$("div.iframe-dragdrop-fix").remove()},column_replace:function(a,b){if(this.thead&&this.thead.rows){var c=this.thead.rows[0].cells;var d=c[a],e=c[b],f=document.createElement("td");e?c[0].parentNode.insertBefore(f,e):c[0].parentNode.appendChild(f);c[0].parentNode.replaceChild(d,f);r=0;for(c=this.tbody.rows.length;r<c;r++)row=this.tbody.rows[r],d=row.cells[a],e=row.cells[b],f=document.createElement("td"),e?row.insertBefore(f,e):row.appendChild(f),row.replaceChild(d,f);this.subject_col==
a?this.subject_col=b>a?b-1:b:this.subject_col<a&&b<=this.subject_col?this.subject_col++:this.subject_col>a&&b>=this.subject_col&&this.subject_col--;this.fixed_header&&this.init_header();this.triggerEvent("column_replace")}}};rcube_list_widget.prototype.addEventListener=rcube_event_engine.prototype.addEventListener;rcube_list_widget.prototype.removeEventListener=rcube_event_engine.prototype.removeEventListener;rcube_list_widget.prototype.triggerEvent=rcube_event_engine.prototype.triggerEvent;
rcube_list_widget._instances=[];
