/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.gui.command;

import com.baselet.control.HandlerElementMap;
import com.baselet.diagram.DiagramHandler;
import com.baselet.diagram.DrawPanel;
import com.baselet.element.interfaces.GridElement;
import com.baselet.gui.command.Command;
import com.baselet.gui.command.RemoveElement;
import java.awt.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddElement
extends Command {
    private static final Logger log = LoggerFactory.getLogger(AddElement.class);
    private boolean firstCall = true;
    private Point origin;
    private GridElement _entity;
    private int _x;
    private int _y;
    private boolean _zoom;

    private int getX() {
        if (this._zoom) {
            return this._x * 10;
        }
        return this._x;
    }

    private int getY() {
        if (this._zoom) {
            return this._y * 10;
        }
        return this._y;
    }

    public AddElement(GridElement e, int x, int y) {
        this(e, x, y, true);
    }

    public AddElement(GridElement e, int x, int y, boolean zoom) {
        this._entity = e;
        this._zoom = zoom;
        if (this._zoom) {
            this._x = x / HandlerElementMap.getHandlerForElement(e).getGridSize();
            this._y = y / HandlerElementMap.getHandlerForElement(e).getGridSize();
            DiagramHandler.zoomEntity(HandlerElementMap.getHandlerForElement(e).getGridSize(), 10, e);
        } else {
            this._x = x;
            this._y = y;
        }
    }

    private void addentity(GridElement e, DrawPanel panel, int x, int y) {
        panel.getHandler().setHandlerAndInitListeners(e);
        panel.addElement(e);
        e.setLocation(x, y);
    }

    @Override
    public void execute(DiagramHandler handler) {
        super.execute(handler);
        if (this.origin == null) {
            this.origin = handler.getDrawPanel().getOriginAtDefaultZoom();
        }
        int offsetX = this.origin.x - handler.getDrawPanel().getOriginAtDefaultZoom().x;
        int offsetY = this.origin.y - handler.getDrawPanel().getOriginAtDefaultZoom().y;
        log.debug("Add Entity at " + this.getX() + "/" + this.getY());
        this.addentity(this._entity, handler.getDrawPanel(), this.getX() + offsetX, this.getY() + offsetY);
        if (this._zoom) {
            DiagramHandler.zoomEntity(10, handler.getGridSize(), this._entity);
        }
        handler.getDrawPanel().getSelector().selectOnly(this._entity);
        if (!this.firstCall) {
            handler.getDrawPanel().updatePanelAndScrollbars();
        }
        this.firstCall = false;
    }

    @Override
    public void undo(DiagramHandler handler) {
        super.undo(handler);
        if (this._zoom) {
            DiagramHandler.zoomEntity(handler.getGridSize(), 10, this._entity);
        }
        handler.getDrawPanel().removeElement(this._entity);
        new RemoveElement(this._entity, false).execute(handler);
        handler.getDrawPanel().repaint();
        handler.getDrawPanel().updatePanelAndScrollbars();
    }
}

