/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.env.Environment;
import org.elasticsearch.plugins.Platforms;
import org.elasticsearch.plugins.PluginInfo;

final class Spawner
implements Closeable {
    private final List<Process> processes = new ArrayList<Process>();
    private AtomicBoolean spawned = new AtomicBoolean();

    Spawner() {
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(() -> this.processes.stream().map(s -> s::destroy).iterator());
    }

    void spawnNativePluginControllers(Environment environment) throws IOException {
        Logger logger = Loggers.getLogger(this.getClass(), environment.settings(), new String[0]);
        if (!this.spawned.compareAndSet(false, true)) {
            throw new IllegalStateException("native controllers already spawned");
        }
        Path pluginsFile = environment.pluginsFile();
        if (!Files.exists(pluginsFile, new LinkOption[0])) {
            throw new IllegalStateException("plugins directory [" + pluginsFile + "] not found");
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(pluginsFile);){
            for (Path plugin : stream) {
                PluginInfo info = PluginInfo.readFromProperties(plugin);
                Path spawnPath = Platforms.nativeControllerPath(plugin);
                if (!Files.isRegularFile(spawnPath, new LinkOption[0])) continue;
                if (!info.hasNativeController()) {
                    String message = String.format(Locale.ROOT, "plugin [%s] does not have permission to fork native controller", plugin.getFileName());
                    throw new IllegalArgumentException(message);
                }
                Process process = this.spawnNativePluginController(spawnPath, environment.tmpFile());
                this.processes.add(process);
            }
        }
    }

    private Process spawnNativePluginController(Path spawnPath, Path tmpPath) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(spawnPath.toString());
        pb.environment().clear();
        pb.environment().put("TMPDIR", tmpPath.toString());
        return pb.start();
    }

    List<Process> getProcesses() {
        return Collections.unmodifiableList(this.processes);
    }
}

