

  {extends file="main.tpl"}
    <!DOCTYPE head PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><head xmlns="http://www.w3.org/1999/xhtml">
  {block name=title}GPSBabel development:Transform waypoints into a route, tracks into routes, ... (transform){/block}
  {block name=body}{literal}
                       
  <div xmlns="http://www.w3.org/1999/xhtml" class="navheader"><table width="100%" summary="Navigation header"><tr><th colspan="3" align="center">Transform waypoints into a route, tracks into routes, ... (transform)</th></tr><tr><td width="20%" align="left"><a accesskey="p" href="filter_swap.html">Prev</a> </td><th width="60%" align="center">Chapter 4. Data Filters</th><td width="20%" align="right"> <a accesskey="n" href="filter_validate.html">Next</a></td></tr></table><hr /></div><div xmlns="http://www.w3.org/1999/xhtml" class="section"><div class="titlepage"><div><div><h2 class="title" ><a id="filter_transform"></a>Transform waypoints into a route, tracks into routes, ... (transform)</h2></div></div></div><p>
  This filter can be used to convert GPS data between different data types.
</p><p>
  Some GPS data formats support only some subset of waypoints, tracks,
  and routes.  The transform filter allows you to convert between these
  types.  For example, it can be used to convert a pile of waypoints (such
  as those from a CSV file) into a track or vice versa.
</p><p>
  The following example show you how to create a route from a waypoint table.
</p><p><strong class="userinput"><code>gpsbabel -i csv -f waypts.txt -x transform,rte=wpt -o gpx -F route.gpx</code></strong></p><p>
  Only the first letter of option value decides which transformation will be done.
  Depending on the used option it can be only 'W' for waypoints, 'R' for routes or
  'T' for tracks.
</p><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_transform_o_wpt"></a>wpt option</h3></div></div></div><p>
      Transform track(s) or route(s) into waypoint(s) [R/T].
    </p><p>
This option selects the destination type of this filter to be waypoints.  
Choose this when you want to convert tracks or routes into waypoints.
</p><div class="example"><a id="transform_to_wpt"></a><p class="title"><strong>Example 4.22. Converting a track to a sequence of waypoints</strong></p><div class="example-contents"><p>
Say you you have a KML file that contains a track but you want to convert it to a CSV file that can contain only waypoints, perhaps to import into a spreadsheet.  Use the following command:
</p><p><strong class="userinput"><code>gpsbabel -i kml -f blah.kml -x transform,wpt=trk -o csv -F blah.txt</code></strong></p></div></div><br class="example-break" /></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_transform_o_rte"></a>rte option</h3></div></div></div><p>
      Transform waypoint(s) or track(s) into route(s) [W/T].
    </p><p>
This option selects the destination type of this filter to be routes.  Choose this when you want to convert tracks into waypoints routes.  A single route will be created in the sequence they appear in the input.
</p><div class="example"><a id="transform_to_rte"></a><p class="title"><strong>Example 4.23. Converting a pile of waypoints to a GPX route</strong></p><div class="example-contents"><p>
Say you you have a data file that came from CSV file that you want to convert  
to a GPX route that can be loaded into Mapsource.  Use the following command:
</p><p><strong class="userinput"><code>gpsbabel -i csv -f blah.txt -x transform,rte=wpt -o gdb -F blah.gdb</code></strong></p></div></div><br class="example-break" /></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_transform_o_trk"></a>trk option</h3></div></div></div><p>
      Transform waypoint(s) or route(s) into tracks(s) [W/R].
    </p><p>
This option selects the destination type of this filter to be tracks.  
Choose this when you want to create tracks from a list of waypoints or routes. 
A single track will be created in the sequence they appear in the input.
</p><div class="example"><a id="transform_to_trk"></a><p class="title"><strong>Example 4.24. Converting a pile of waypoints to a GPX track</strong></p><div class="example-contents"><p>
Say you you have a data file that came from CSV file that you want to convert  
to a GPX track that can be loaded into Mapsource.  Use the following command:
</p><p><strong class="userinput"><code>gpsbabel -i csv -f blah.txt -x transform,trk=wpt -o gdb -F blah.gdb</code></strong></p></div></div><br class="example-break" /></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_transform_o_rptdigits"></a>rptdigits option</h3></div></div></div><p>
      Number of digits in generated names.
    </p><p>
This option lets you configure how many digits GPSBabel uses for numbering generated route point names.
</p><p>
When GPSBabel creates route points during the transformation process these points are sequentially numbered and named "RPTxxx" where xxx represent the number. By default GPSBabel uses 3 digits for these numbers. Rationale: This way a large number of route points can be uniquely named while the generated names are limited to 6 characters. This limitation is imposed by specific GPS-devices.
</p><p>
Using this option GPSBabel can be configured to use less or more digits for the generated names. This option is best used in conjunction with the rptname option.
</p><div class="example"><a id="transform_rptdigits"></a><p class="title"><strong>Example 4.25. Convert a GPX track to a GPX route, deleting the original track, using 2 digits for the generated numbers.</strong></p><div class="example-contents"><p><strong class="userinput"><code>gpsbabel -i gpx -f track.gpx -x transform,wpt=trk,del,rptdigits=2 -o gpx -F route.gpx</code></strong></p></div></div><br class="example-break" /></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_transform_o_rptname"></a>rptname option</h3></div></div></div><p>
      Use source name for route point names.
    </p><p>
With this option you can decide to let GPSBabel name generated route points according to their source track name.
</p><p>
GPSBabel creates route points during the transformation process named "RPTxxx" where xxx is a numeric part.</p><p>
Using this option GPSBabel can be configured to replace the "RPT" part of the generated names by the name of the source track during the transformation process. This is especially usefull if several differently named tracks are contained in the source file which should each be transformed into routes.
</p><div class="example"><a id="transform_rptname"></a><p class="title"><strong>Example 4.26. Convert a GPX track to a GPX route, deleting the original track, naming the generated points like the original track name.</strong></p><div class="example-contents"><p><strong class="userinput"><code>gpsbabel -i gpx -f track.gpx -x transform,wpt=trk,del,rptname=y -o gpx -F route.gpx</code></strong></p></div></div><br class="example-break" /></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_transform_o_del"></a>del option</h3></div></div></div><p>
      Delete source data after transformation.
    </p><p>
This option, when used in connection with the wpt, rte, or trk options, tells
GPSBabel to delete the source data after conversion.  This is most useful if 
you are trying to avoid duplicated data in the output.
</p><div class="example"><a id="transform_del"></a><p class="title"><strong>Example 4.27. Convert a GPX track to GPX waypoints, tossing the original track</strong></p><div class="example-contents"><p><strong class="userinput"><code>gpsbabel -i gpx -f blah.gpx -x transform,wpt=trk,del -o gpx -F converted.gpx</code></strong></p></div></div><br class="example-break" /></div></div><div xmlns="http://www.w3.org/1999/xhtml" class="navfooter"><hr /><table width="100%" summary="Navigation footer"><tr><td width="40%" align="left"><a accesskey="p" href="filter_swap.html">Prev</a> </td><td width="20%" align="center"><a accesskey="u" href="Data_Filters.html">Up</a></td><td width="40%" align="right"> <a accesskey="n" href="filter_validate.html">Next</a></td></tr><tr><td width="40%" align="left" valign="top">Swap latitude and longitude of all loaded points (swap) </td><td width="20%" align="center"><a accesskey="h" href="index.html">Home</a></td><td width="40%" align="right" valign="top"> Validate internal data structures (validate)</td></tr></table></div>
  
      {/literal}{/block}
  