/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.weather;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;
import tim.prune.function.weather.SingleForecast;
import tim.prune.gui.DisplayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeatherResults {
    private ArrayList<SingleForecast> _forecastList = new ArrayList();
    private boolean _tempsCelsius = true;
    private String _locationName = null;
    private String _updateTime = null;
    private String _sunriseTime = null;
    private String _sunsetTime = null;

    public void setForecast(SingleForecast singleForecast) {
        this._forecastList.clear();
        if (singleForecast != null) {
            this._forecastList.add(singleForecast);
        }
    }

    public void setForecasts(ArrayList<SingleForecast> arrayList) {
        this._forecastList.clear();
        if (arrayList != null && arrayList.size() > 0) {
            this._forecastList.addAll(arrayList);
        }
    }

    public int getNumForecasts() {
        return this._forecastList.size();
    }

    public SingleForecast getForecast(int n) {
        if (n < 0 || n >= this.getNumForecasts()) {
            return null;
        }
        return this._forecastList.get(n);
    }

    public void clear() {
        this._forecastList.clear();
        this._sunsetTime = null;
        this._sunriseTime = null;
        this._updateTime = null;
    }

    public void setTempsCelsius(boolean bl) {
        this._tempsCelsius = bl;
    }

    public boolean isCelsius() {
        return this._tempsCelsius;
    }

    public void setSunriseSunsetTimes(String string, String string2) {
        this._sunsetTime = null;
        this._sunriseTime = null;
        if (string != null && string.length() == 19 && string2 != null && string2.length() == 19) {
            this._sunriseTime = WeatherResults.convertToLocalTimezone(string.substring(11, 16));
            this._sunsetTime = WeatherResults.convertToLocalTimezone(string2.substring(11, 16));
        }
    }

    public String getSunriseTime() {
        return this._sunriseTime;
    }

    public String getSunsetTime() {
        return this._sunsetTime;
    }

    public void setLocationName(String string) {
        this._locationName = string;
    }

    public String getLocationName() {
        return this._locationName;
    }

    public void setUpdateTime(String string) {
        this._updateTime = string;
    }

    public String getUpdateTime() {
        return this._updateTime;
    }

    private static String convertToLocalTimezone(String string) {
        if (string != null && string.length() == 5) {
            try {
                int n = Integer.parseInt(string.substring(0, 2));
                int n2 = Integer.parseInt(string.substring(3));
                Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                calendar.set(11, n);
                calendar.set(12, n2);
                Calendar calendar2 = Calendar.getInstance();
                calendar2.setTimeInMillis(calendar.getTimeInMillis());
                return DisplayUtils.makeTimeString(calendar2.get(11), calendar2.get(12));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return string;
    }
}

