/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.run;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.play.internal.run.PlayAppLifecycleUpdate;
import org.gradle.play.internal.run.PlayApplicationRunnerToken;
import org.gradle.play.internal.run.PlayRunSpec;
import org.gradle.play.internal.run.PlayRunWorkerClientProtocol;
import org.gradle.play.internal.run.PlayRunWorkerServerProtocol;
import org.gradle.play.internal.run.PlayWorkerClient;
import org.gradle.play.internal.run.PlayWorkerServer;
import org.gradle.play.internal.run.VersionedPlayRunAdapter;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.process.internal.worker.WorkerProcess;
import org.gradle.process.internal.worker.WorkerProcessBuilder;
import org.gradle.process.internal.worker.WorkerProcessFactory;

public class PlayApplicationRunner {
    private final WorkerProcessFactory workerFactory;
    private final VersionedPlayRunAdapter adapter;

    public PlayApplicationRunner(WorkerProcessFactory workerFactory, VersionedPlayRunAdapter adapter) {
        this.workerFactory = workerFactory;
        this.adapter = adapter;
    }

    public PlayApplicationRunnerToken start(PlayRunSpec spec) {
        WorkerProcess process = PlayApplicationRunner.createWorkerProcess(spec.getProjectPath(), this.workerFactory, spec, this.adapter);
        process.start();
        PlayWorkerClient clientCallBack = new PlayWorkerClient();
        process.getConnection().addIncoming(PlayRunWorkerClientProtocol.class, (Object)clientCallBack);
        PlayRunWorkerServerProtocol workerServer = (PlayRunWorkerServerProtocol)process.getConnection().addOutgoing(PlayRunWorkerServerProtocol.class);
        process.getConnection().connect();
        PlayAppLifecycleUpdate result = clientCallBack.waitForRunning();
        if (result.isRunning()) {
            return new PlayApplicationRunnerToken(workerServer, clientCallBack, process);
        }
        throw new GradleException("Unable to start Play application.", (Throwable)result.getException());
    }

    private static WorkerProcess createWorkerProcess(File workingDir, WorkerProcessFactory workerFactory, PlayRunSpec spec, VersionedPlayRunAdapter adapter) {
        WorkerProcessBuilder builder = workerFactory.create((Action)new PlayWorkerServer(spec, adapter));
        builder.setBaseName("Gradle Play Worker");
        builder.sharedPackages(new String[]{"org.gradle.play.internal.run"});
        JavaExecHandleBuilder javaCommand = builder.getJavaCommand();
        javaCommand.setWorkingDir(workingDir);
        javaCommand.setMinHeapSize(spec.getForkOptions().getMemoryInitialSize());
        javaCommand.setMaxHeapSize(spec.getForkOptions().getMemoryMaximumSize());
        javaCommand.setJvmArgs(spec.getForkOptions().getJvmArgs());
        return builder.build();
    }
}

