/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.asm;

import org.gradle.internal.Cast;
import org.gradle.internal.reflect.JavaMethod;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsmClassGenerator {
    private static final JavaMethod<ClassLoader, ?> DEFINE_CLASS_METHOD = JavaReflectionUtil.method(ClassLoader.class, Class.class, (String)"defineClass", (Class[])new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE});
    private final ClassWriter visitor;
    private final String generatedTypeName;
    private final Type generatedType;
    private final Class<?> targetType;

    public AsmClassGenerator(Class<?> targetType, String classNameSuffix) {
        this.targetType = targetType;
        this.visitor = new ClassWriter(3);
        this.generatedTypeName = targetType.getName() + classNameSuffix;
        this.generatedType = Type.getType((String)("L" + this.generatedTypeName.replaceAll("\\.", "/") + ";"));
    }

    public ClassWriter getVisitor() {
        return this.visitor;
    }

    public Class<?> getTargetType() {
        return this.targetType;
    }

    public String getGeneratedTypeName() {
        return this.generatedTypeName;
    }

    public Type getGeneratedType() {
        return this.generatedType;
    }

    public <T> Class<T> define() {
        return this.define(this.targetType.getClassLoader());
    }

    public <T> Class<T> define(ClassLoader targetClassLoader) {
        byte[] generatedByteCode = this.visitor.toByteArray();
        return (Class)Cast.uncheckedCast((Object)DEFINE_CLASS_METHOD.invoke((Object)targetClassLoader, new Object[]{this.generatedTypeName, generatedByteCode, 0, generatedByteCode.length}));
    }
}

