/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import com.google.common.base.Charsets;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import org.gradle.api.Action;
import org.gradle.api.artifacts.repositories.RepositoryResourceAccessor;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.LocallyAvailableExternalResource;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.internal.resource.transfer.CacheAwareExternalResourceAccessor;

public class ExternalRepositoryResourceAccessor
implements RepositoryResourceAccessor {
    private final URI rootUri;
    private final CacheAwareExternalResourceAccessor resourceAccessor;
    private final FileStore<String> fileStore;

    public ExternalRepositoryResourceAccessor(URI rootUri, CacheAwareExternalResourceAccessor cacheAwareExternalResourceAccessor, FileStore<String> searchableFileStore) {
        this.rootUri = rootUri;
        this.resourceAccessor = cacheAwareExternalResourceAccessor;
        this.fileStore = searchableFileStore;
    }

    public void withResource(String relativePath, Action<? super InputStream> action) {
        try {
            ExternalResourceName location = new ExternalResourceName(this.rootUri, relativePath);
            Hasher hasher = Hashing.sha1().newHasher().putString((CharSequence)location.getUri().toASCIIString(), Charsets.UTF_8);
            final String key = hasher.hash().toString();
            LocallyAvailableExternalResource resource = this.resourceAccessor.getResource(location, new CacheAwareExternalResourceAccessor.ResourceFileStore(){

                @Override
                public LocallyAvailableResource moveIntoCache(File downloadedResource) {
                    return ExternalRepositoryResourceAccessor.this.fileStore.move((Object)key, downloadedResource);
                }
            }, null);
            if (resource != null) {
                resource.withContent(action);
            }
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

