/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.util.List;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.transform.ArtifactTransform;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.util.BiFunction;

class ArtifactTransformBackedTransformer
implements BiFunction<List<File>, File, File> {
    private final Class<? extends ArtifactTransform> implementationClass;
    private final Object[] parameters;
    private final Instantiator instantiator;

    ArtifactTransformBackedTransformer(Class<? extends ArtifactTransform> implementationClass, Object[] parameters, Instantiator instantiator) {
        this.implementationClass = implementationClass;
        this.parameters = parameters;
        this.instantiator = instantiator;
    }

    public List<File> apply(File file, File outputDir) {
        ArtifactTransform artifactTransform = (ArtifactTransform)this.instantiator.newInstance(this.implementationClass, this.parameters);
        artifactTransform.setOutputDirectory(outputDir);
        List outputs = artifactTransform.transform(file);
        if (outputs == null) {
            throw new InvalidUserDataException("Transform returned null result.");
        }
        String inputFilePrefix = file.getPath() + File.separator;
        String outputDirPrefix = outputDir.getPath() + File.separator;
        for (File output : outputs) {
            if (!output.exists()) {
                throw new InvalidUserDataException("Transform output file " + output.getPath() + " does not exist.");
            }
            if (output.equals(file) || output.equals(outputDir) || output.getPath().startsWith(outputDirPrefix) || output.getPath().startsWith(inputFilePrefix)) continue;
            throw new InvalidUserDataException("Transform output file " + output.getPath() + " is not a child of the transform's input file or output directory.");
        }
        return outputs;
    }
}

