/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.internal.Cast;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.text.TreeFormatter;

public class AmbiguousConfigurationSelectionException
extends RuntimeException {
    private static final Function<ConfigurationMetadata, String> CONFIG_NAME = new Function<ConfigurationMetadata, String>(){

        public String apply(ConfigurationMetadata input) {
            return input.getName();
        }
    };

    public AmbiguousConfigurationSelectionException(AttributeContainer fromConfigurationAttributes, AttributeMatcher attributeMatcher, List<? extends ConfigurationMetadata> matches, ComponentResolveMetadata targetComponent) {
        super(AmbiguousConfigurationSelectionException.generateMessage(fromConfigurationAttributes, attributeMatcher, matches, targetComponent));
    }

    private static String generateMessage(AttributeContainer fromConfigurationAttributes, AttributeMatcher attributeMatcher, List<? extends ConfigurationMetadata> matches, ComponentResolveMetadata targetComponent) {
        TreeSet ambiguousConfigurations = Sets.newTreeSet((Iterable)Lists.transform(matches, CONFIG_NAME));
        TreeFormatter formatter = new TreeFormatter();
        formatter.node("Cannot choose between the following configurations of ");
        formatter.append((CharSequence)targetComponent.getComponentId().getDisplayName());
        formatter.startChildren();
        for (String configuration : ambiguousConfigurations) {
            formatter.node(configuration);
        }
        formatter.endChildren();
        formatter.node("All of them match the consumer attributes");
        formatter.startChildren();
        for (String ambiguousConf : ambiguousConfigurations) {
            AmbiguousConfigurationSelectionException.formatConfiguration(formatter, fromConfigurationAttributes, attributeMatcher, matches, ambiguousConf);
        }
        formatter.endChildren();
        return formatter.toString();
    }

    static void formatConfiguration(TreeFormatter formatter, AttributeContainer consumerAttributes, AttributeMatcher attributeMatcher, List<? extends ConfigurationMetadata> matches, final String conf) {
        Optional match = Iterables.tryFind(matches, (Predicate)new Predicate<ConfigurationMetadata>(){

            public boolean apply(ConfigurationMetadata input) {
                return conf.equals(input.getName());
            }
        });
        if (match.isPresent()) {
            AttributeContainerInternal producerAttributes = ((ConfigurationMetadata)match.get()).getAttributes();
            formatter.node("Configuration '");
            formatter.append((CharSequence)conf);
            formatter.append((CharSequence)"'");
            AmbiguousConfigurationSelectionException.formatAttributeMatches(formatter, consumerAttributes, attributeMatcher, (AttributeContainer)producerAttributes);
        }
    }

    public static void formatAttributeMatches(TreeFormatter formatter, AttributeContainer consumerAttributes, AttributeMatcher attributeMatcher, AttributeContainer producerAttributes) {
        Sets.SetView allAttributes = Sets.union((Set)consumerAttributes.keySet(), (Set)producerAttributes.keySet());
        List sortedAttributes = Ordering.usingToString().sortedCopy((Iterable)allAttributes);
        formatter.startChildren();
        for (Attribute attribute : sortedAttributes) {
            String attributeName = attribute.getName();
            if (consumerAttributes.contains(attribute) && producerAttributes.contains(attribute)) {
                Object consumerValue = consumerAttributes.getAttribute(attribute);
                Object producerValue = producerAttributes.getAttribute(attribute);
                Attribute untyped = (Attribute)Cast.uncheckedCast((Object)attribute);
                if (attributeMatcher.isMatching(untyped, producerValue, consumerValue)) {
                    formatter.node("Required " + attributeName + " '" + consumerValue + "' and found compatible value '" + producerValue + "'.");
                    continue;
                }
                formatter.node("Required " + attributeName + " '" + consumerValue + "' and found incompatible value '" + producerValue + "'.");
                continue;
            }
            if (consumerAttributes.contains(attribute)) {
                formatter.node("Required " + attributeName + " '" + consumerAttributes.getAttribute(attribute) + "' but no value provided.");
                continue;
            }
            formatter.node("Found " + attributeName + " '" + producerAttributes.getAttribute(attribute) + "' but wasn't required.");
        }
        formatter.endChildren();
    }
}

