/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.cached;

import java.io.File;
import org.gradle.api.Transformer;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.internal.resource.local.GroupedAndNamedUniqueFileStore;
import org.gradle.internal.resource.local.PathKeyFileStore;

public class ExternalResourceFileStore
extends GroupedAndNamedUniqueFileStore<String> {
    private static final Transformer<String, String> GROUPER = new Transformer<String, String>(){

        public String transform(String s) {
            return "" + Math.abs(s.hashCode()) % 10;
        }
    };
    private static final Transformer<String, String> NAMER = new Transformer<String, String>(){

        public String transform(String s) {
            return "" + Math.abs(s.substring(0, 8).hashCode()) % 10;
        }
    };

    public ExternalResourceFileStore(File baseDir, TemporaryFileProvider tmpProvider) {
        super(new PathKeyFileStore(baseDir), tmpProvider, GROUPER, NAMER);
    }

    protected String toPath(String key, String checksumPart) {
        String group = (String)GROUPER.transform((Object)key);
        String name = (String)NAMER.transform((Object)key);
        return group + "/" + name + "/" + key;
    }
}

