/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.file;

import java.io.IOException;
import org.gradle.api.Nullable;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ExternalResourceRepository;
import org.gradle.internal.resource.local.FileResourceRepository;
import org.gradle.internal.resource.local.LocallyAvailableExternalResource;
import org.gradle.internal.resource.local.LocallyAvailableResourceCandidates;
import org.gradle.internal.resource.transfer.CacheAwareExternalResourceAccessor;
import org.gradle.internal.resource.transport.AbstractRepositoryTransport;

public class FileTransport
extends AbstractRepositoryTransport {
    private final FileResourceRepository repository;
    private final NoOpCacheAwareExternalResourceAccessor resourceAccessor;

    public FileTransport(String name, FileResourceRepository repository) {
        super(name);
        this.repository = repository;
        this.resourceAccessor = new NoOpCacheAwareExternalResourceAccessor();
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public ExternalResourceRepository getRepository() {
        return this.repository;
    }

    @Override
    public CacheAwareExternalResourceAccessor getResourceAccessor() {
        return this.resourceAccessor;
    }

    private class NoOpCacheAwareExternalResourceAccessor
    implements CacheAwareExternalResourceAccessor {
        private NoOpCacheAwareExternalResourceAccessor() {
        }

        @Override
        public LocallyAvailableExternalResource getResource(ExternalResourceName source, CacheAwareExternalResourceAccessor.ResourceFileStore fileStore, @Nullable LocallyAvailableResourceCandidates additionalCandidates) throws IOException {
            LocallyAvailableExternalResource resource = FileTransport.this.repository.resource(source);
            if (resource.getFile().exists()) {
                return resource;
            }
            return null;
        }
    }
}

