/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.progress;

import org.gradle.api.Nullable;
import org.gradle.internal.progress.BuildOperationCategory;
import org.gradle.internal.progress.BuildOperationState;

public final class BuildOperationDescriptor {
    private final Object id;
    private final Object parentId;
    private final String displayName;
    private final String name;
    private final String progressDisplayName;
    private final Object details;
    private final BuildOperationCategory operationType;

    private BuildOperationDescriptor(Object id, Object parentId, String name, String displayName, String progressDisplayName, Object details, BuildOperationCategory operationType) {
        this.id = id;
        this.parentId = parentId;
        this.name = name;
        this.displayName = displayName;
        this.progressDisplayName = progressDisplayName;
        this.details = details;
        this.operationType = operationType;
    }

    public Object getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Nullable
    public String getProgressDisplayName() {
        return this.progressDisplayName;
    }

    @Nullable
    public Object getDetails() {
        return this.details;
    }

    @Nullable
    public Object getParentId() {
        return this.parentId;
    }

    public BuildOperationCategory getOperationType() {
        return this.operationType;
    }

    public static Builder displayName(String displayName) {
        return new Builder(displayName);
    }

    public static final class Builder {
        private final String displayName;
        private String name;
        private String progressDisplayName;
        private Object details;
        private BuildOperationState parent;
        private BuildOperationCategory operationType = BuildOperationCategory.UNCATEGORIZED;

        private Builder(String displayName) {
            this.displayName = displayName;
            this.name = displayName;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder progressDisplayName(String progressDisplayName) {
            this.progressDisplayName = progressDisplayName;
            return this;
        }

        public Builder details(Object details) {
            this.details = details;
            return this;
        }

        public Builder operationType(BuildOperationCategory operationType) {
            this.operationType = operationType;
            return this;
        }

        public Builder parent(BuildOperationState parent) {
            this.parent = parent;
            return this;
        }

        public BuildOperationDescriptor build() {
            return this.build(null, null);
        }

        BuildOperationState getParentState() {
            return this.parent;
        }

        BuildOperationDescriptor build(@Nullable Object id, @Nullable Object defaultParentId) {
            return new BuildOperationDescriptor(id, this.parent == null ? defaultParentId : this.parent.getId(), this.name, this.displayName, this.progressDisplayName, this.details, this.operationType);
        }
    }
}

