/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheEntryWriter;
import org.gradle.caching.BuildCacheException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.AbstractRoleAwareBuildCacheServiceDecorator;
import org.gradle.caching.internal.RoleAwareBuildCacheService;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.progress.BuildOperationDescriptor;

public class BuildOperationFiringBuildCacheServiceDecorator
extends AbstractRoleAwareBuildCacheServiceDecorator {
    private final BuildOperationExecutor buildOperationExecutor;

    public BuildOperationFiringBuildCacheServiceDecorator(BuildOperationExecutor buildOperationExecutor, RoleAwareBuildCacheService delegate) {
        super(delegate);
        this.buildOperationExecutor = buildOperationExecutor;
    }

    public boolean load(BuildCacheKey key, BuildCacheEntryReader reader) throws BuildCacheException {
        return super.load(key, new BuildOperationFiringBuildCacheEntryReader(reader, key));
    }

    public void store(BuildCacheKey key, BuildCacheEntryWriter writer) throws BuildCacheException {
        super.store(key, new BuildOperationFiringBuildCacheEntryWriter(writer, key));
    }

    private class BuildOperationFiringBuildCacheEntryWriter
    implements BuildCacheEntryWriter {
        private final BuildCacheEntryWriter delegate;
        private final BuildCacheKey key;

        private BuildOperationFiringBuildCacheEntryWriter(BuildCacheEntryWriter delegate, BuildCacheKey key) {
            this.delegate = delegate;
            this.key = key;
        }

        public void writeTo(final OutputStream output) throws IOException {
            BuildOperationFiringBuildCacheServiceDecorator.this.buildOperationExecutor.run(new RunnableBuildOperation(){

                public void run(BuildOperationContext buildOperationContext) {
                    try {
                        BuildOperationFiringBuildCacheEntryWriter.this.delegate.writeTo(output);
                    }
                    catch (IOException e) {
                        buildOperationContext.failed((Throwable)e);
                    }
                }

                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName((String)("Store entry " + BuildOperationFiringBuildCacheEntryWriter.this.key + " in " + BuildOperationFiringBuildCacheServiceDecorator.this.getRole() + " build cache"));
                }
            });
        }
    }

    private class BuildOperationFiringBuildCacheEntryReader
    implements BuildCacheEntryReader {
        private final BuildCacheEntryReader delegate;
        private final BuildCacheKey key;

        private BuildOperationFiringBuildCacheEntryReader(BuildCacheEntryReader delegate, BuildCacheKey key) {
            this.delegate = delegate;
            this.key = key;
        }

        public void readFrom(final InputStream input) throws IOException {
            BuildOperationFiringBuildCacheServiceDecorator.this.buildOperationExecutor.run(new RunnableBuildOperation(){

                public void run(BuildOperationContext buildOperationContext) {
                    try {
                        BuildOperationFiringBuildCacheEntryReader.this.delegate.readFrom(input);
                    }
                    catch (IOException e) {
                        buildOperationContext.failed((Throwable)e);
                    }
                }

                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName((String)("Load entry " + BuildOperationFiringBuildCacheEntryReader.this.key + " from " + BuildOperationFiringBuildCacheServiceDecorator.this.getRole() + " build cache"));
                }
            });
        }
    }
}

