/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.internal.tasks.SimpleWorkResult;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.BuildOperationWorker;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.nativeplatform.internal.LinkerSpec;
import org.gradle.nativeplatform.internal.SharedLibraryLinkerSpec;
import org.gradle.nativeplatform.toolchain.internal.ArgsTransformer;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolContext;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolInvocation;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolInvocationWorker;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.EscapeUserArgs;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.VisualCppOptionsFileArgsWriter;

class LinkExeLinker
implements Compiler<LinkerSpec> {
    private final CommandLineToolInvocationWorker commandLineToolInvocationWorker;
    private final Transformer<LinkerSpec, LinkerSpec> specTransformer;
    private final ArgsTransformer<LinkerSpec> argsTransformer;
    private final CommandLineToolContext invocationContext;
    private final BuildOperationExecutor buildOperationExecutor;

    LinkExeLinker(BuildOperationExecutor buildOperationExecutor, CommandLineToolInvocationWorker commandLineToolInvocationWorker, CommandLineToolContext invocationContext, Transformer<LinkerSpec, LinkerSpec> specTransformer) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.argsTransformer = new LinkerArgsTransformer();
        this.commandLineToolInvocationWorker = commandLineToolInvocationWorker;
        this.invocationContext = invocationContext;
        this.specTransformer = specTransformer;
    }

    public WorkResult execute(final LinkerSpec spec) {
        LinkerSpec transformedSpec = (LinkerSpec)this.specTransformer.transform((Object)spec);
        List args = (List)this.argsTransformer.transform(transformedSpec);
        this.invocationContext.getArgAction().execute((Object)args);
        new VisualCppOptionsFileArgsWriter(spec.getTempDir()).execute(args);
        final CommandLineToolInvocation invocation = this.invocationContext.createInvocation("linking " + spec.getOutputFile().getName(), args, spec.getOperationLogger());
        this.buildOperationExecutor.runAll((BuildOperationWorker)this.commandLineToolInvocationWorker, (Action)new Action<BuildOperationQueue<CommandLineToolInvocation>>(){

            public void execute(BuildOperationQueue<CommandLineToolInvocation> buildQueue) {
                buildQueue.setLogLocation(spec.getOperationLogger().getLogLocation());
                buildQueue.add((BuildOperation)invocation);
            }
        });
        return new SimpleWorkResult(true);
    }

    private static class LinkerArgsTransformer
    implements ArgsTransformer<LinkerSpec> {
        private LinkerArgsTransformer() {
        }

        public List<String> transform(LinkerSpec spec) {
            ArrayList<String> args = new ArrayList<String>();
            args.addAll(EscapeUserArgs.escapeUserArgs(spec.getAllArgs()));
            args.add("/OUT:" + spec.getOutputFile().getAbsolutePath());
            args.add("/NOLOGO");
            if (spec instanceof SharedLibraryLinkerSpec) {
                args.add("/DLL");
            }
            for (File pathEntry : spec.getLibraryPath()) {
                args.add("/LIBPATH:" + pathEntry.getAbsolutePath());
            }
            for (File file : spec.getObjectFiles()) {
                args.add(file.getAbsolutePath());
            }
            for (File file : spec.getLibraries()) {
                args.add(file.getAbsolutePath());
            }
            return args;
        }
    }
}

