/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import com.google.common.collect.Iterables;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.nativeplatform.internal.CompilerOutputFileNamingSchemeFactory;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolContext;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolInvocationWorker;
import org.gradle.nativeplatform.toolchain.internal.compilespec.WindowsResourceCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.VisualCppCompilerArgsTransformer;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.VisualCppNativeCompiler;

class WindowsResourceCompiler
extends VisualCppNativeCompiler<WindowsResourceCompileSpec> {
    WindowsResourceCompiler(BuildOperationExecutor buildOperationExecutor, CompilerOutputFileNamingSchemeFactory compilerOutputFileNamingSchemeFactory, CommandLineToolInvocationWorker commandLineTool, CommandLineToolContext invocationContext, Transformer<WindowsResourceCompileSpec, WindowsResourceCompileSpec> specTransformer, String objectFileExtension, boolean useCommandFile) {
        super(buildOperationExecutor, compilerOutputFileNamingSchemeFactory, commandLineTool, invocationContext, new RcCompilerArgsTransformer(), specTransformer, objectFileExtension, useCommandFile);
    }

    @Override
    protected Iterable<String> buildPerFileArgs(List<String> genericArgs, List<String> sourceArgs, List<String> outputArgs, List<String> pchArgs) {
        if (pchArgs != null && !pchArgs.isEmpty()) {
            throw new UnsupportedOperationException("Precompiled header arguments cannot be specified for a Windows Resource compiler.");
        }
        return Iterables.concat(genericArgs, outputArgs, sourceArgs);
    }

    private static class RcCompilerArgsTransformer
    extends VisualCppCompilerArgsTransformer<WindowsResourceCompileSpec> {
        private RcCompilerArgsTransformer() {
        }

        @Override
        protected void addToolSpecificArgs(WindowsResourceCompileSpec spec, List<String> args) {
            args.add(this.getLanguageOption());
            args.add("/nologo");
        }

        @Override
        protected String getLanguageOption() {
            return "/r";
        }
    }
}

