/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.http.internal;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.credentials.Credentials;
import org.gradle.caching.BuildCacheService;
import org.gradle.caching.BuildCacheServiceFactory;
import org.gradle.caching.http.HttpBuildCache;
import org.gradle.caching.http.internal.HttpBuildCacheService;
import org.gradle.internal.authentication.DefaultBasicAuthentication;
import org.gradle.internal.resource.transport.http.DefaultHttpSettings;
import org.gradle.internal.resource.transport.http.HttpClientHelper;
import org.gradle.internal.resource.transport.http.HttpSettings;
import org.gradle.internal.resource.transport.http.SslContextFactory;

public class DefaultHttpBuildCacheServiceFactory
implements BuildCacheServiceFactory<HttpBuildCache> {
    private final SslContextFactory sslContextFactory;

    @Inject
    public DefaultHttpBuildCacheServiceFactory(SslContextFactory sslContextFactory) {
        this.sslContextFactory = sslContextFactory;
    }

    public BuildCacheService createBuildCacheService(HttpBuildCache configuration, BuildCacheServiceFactory.Describer describer) {
        URI url = configuration.getUrl();
        if (url == null) {
            throw new IllegalStateException("HTTP build cache has no URL configured");
        }
        URI noUserInfoUrl = DefaultHttpBuildCacheServiceFactory.stripUserInfo(url);
        Collection<Object> authentications = Collections.emptyList();
        if (configuration.getCredentials().getUsername() != null && configuration.getCredentials().getPassword() != null) {
            url = noUserInfoUrl;
            DefaultBasicAuthentication basicAuthentication = new DefaultBasicAuthentication("basic");
            basicAuthentication.setCredentials((Credentials)configuration.getCredentials());
            authentications = Collections.singleton(basicAuthentication);
        }
        boolean authenticated = !authentications.isEmpty() || url.getUserInfo() != null;
        describer.type("HTTP").config("url", noUserInfoUrl.toASCIIString()).config("authenticated", Boolean.toString(authenticated));
        HttpClientHelper httpClientHelper = new HttpClientHelper((HttpSettings)new DefaultHttpSettings(authentications, this.sslContextFactory));
        return new HttpBuildCacheService(httpClientHelper, url);
    }

    private static URI stripUserInfo(URI uri) {
        try {
            return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new GradleException("Error constructing URL for http build cache", (Throwable)e);
        }
    }
}

