/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.converters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.gradle.tooling.internal.gradle.DefaultGradleBuild;
import org.gradle.tooling.internal.gradle.PartialBasicGradleProject;
import org.gradle.tooling.model.GradleProject;

public class GradleBuildConverter {
    public DefaultGradleBuild convert(GradleProject project) {
        DefaultGradleBuild gradleBuild = new DefaultGradleBuild();
        PartialBasicGradleProject rootProject = this.toPartialGradleProject(project);
        gradleBuild.setRootProject(rootProject);
        gradleBuild.addProject(rootProject);
        this.convertChildren(gradleBuild, rootProject, project);
        return gradleBuild;
    }

    private void convertChildren(DefaultGradleBuild gradleBuild, PartialBasicGradleProject rootProject, GradleProject project) {
        ArrayList<? extends GradleProject> childProjects = new ArrayList<GradleProject>(project.getChildren());
        Collections.sort(childProjects, new Comparator<GradleProject>(){

            @Override
            public int compare(GradleProject gp1, GradleProject gp2) {
                return gp1.getName().compareTo(gp2.getName());
            }
        });
        for (GradleProject gradleProject : childProjects) {
            PartialBasicGradleProject basicGradleProject = this.toPartialGradleProject(gradleProject);
            gradleBuild.addProject(basicGradleProject);
            basicGradleProject.setParent(rootProject);
            rootProject.addChild(basicGradleProject);
            this.convertChildren(gradleBuild, basicGradleProject, gradleProject);
        }
    }

    private PartialBasicGradleProject toPartialGradleProject(GradleProject childProject) {
        PartialBasicGradleProject basicGradleProject = new PartialBasicGradleProject();
        basicGradleProject.setPath(childProject.getPath());
        basicGradleProject.setName(childProject.getName());
        return basicGradleProject;
    }
}

