/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import com.intellij.openapi.Disposable;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.ArraysKt;
import org.fusesource.jansi.AnsiConsole;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.Usage;
import org.jetbrains.kotlin.cli.common.arguments.ArgumentParseErrors;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.ParseCommandLineArgumentsKt;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.OutputMessageUtil;
import org.jetbrains.kotlin.cli.common.messages.PlainTextMessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.PrintingMessageCollector;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentException;
import org.jetbrains.kotlin.cli.jvm.compiler.CompilerJarLocator;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.utils.StringsKt;

public abstract class CLICompiler<A extends CommonCompilerArguments> {
    @NotNull
    public ExitCode exec(@NotNull PrintStream errStream, String ... args) {
        if (errStream == null) {
            CLICompiler.$$$reportNull$$$0(0);
        }
        if (args == null) {
            CLICompiler.$$$reportNull$$$0(1);
        }
        ExitCode exitCode = this.exec(errStream, Services.EMPTY, MessageRenderer.PLAIN_RELATIVE_PATHS, args);
        if (exitCode == null) {
            CLICompiler.$$$reportNull$$$0(2);
        }
        return exitCode;
    }

    @NotNull
    public ExitCode execAndOutputXml(@NotNull PrintStream errStream, @NotNull Services services, String ... args) {
        if (errStream == null) {
            CLICompiler.$$$reportNull$$$0(3);
        }
        if (services == null) {
            CLICompiler.$$$reportNull$$$0(4);
        }
        if (args == null) {
            CLICompiler.$$$reportNull$$$0(5);
        }
        ExitCode exitCode = this.exec(errStream, services, MessageRenderer.XML, args);
        if (exitCode == null) {
            CLICompiler.$$$reportNull$$$0(6);
        }
        return exitCode;
    }

    @NotNull
    public ExitCode execFullPathsInMessages(@NotNull PrintStream errStream, @NotNull String[] args) {
        if (errStream == null) {
            CLICompiler.$$$reportNull$$$0(7);
        }
        if (args == null) {
            CLICompiler.$$$reportNull$$$0(8);
        }
        ExitCode exitCode = this.exec(errStream, Services.EMPTY, MessageRenderer.PLAIN_FULL_PATHS, args);
        if (exitCode == null) {
            CLICompiler.$$$reportNull$$$0(9);
        }
        return exitCode;
    }

    @Nullable
    private A parseArguments(@NotNull MessageCollector messageCollector2, @NotNull String[] args) {
        if (messageCollector2 == null) {
            CLICompiler.$$$reportNull$$$0(10);
        }
        if (args == null) {
            CLICompiler.$$$reportNull$$$0(11);
        }
        try {
            A arguments2 = this.createArguments();
            this.parseArguments(args, arguments2);
            return arguments2;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Throwable t) {
            messageCollector2.report(CompilerMessageSeverity.EXCEPTION, OutputMessageUtil.renderException(t), null);
            return null;
        }
    }

    public void parseArguments(@NotNull String[] args, @NotNull A arguments2) {
        if (args == null) {
            CLICompiler.$$$reportNull$$$0(12);
        }
        if (arguments2 == null) {
            CLICompiler.$$$reportNull$$$0(13);
        }
        ParseCommandLineArgumentsKt.parseCommandLineArguments(args, arguments2);
        String message = ParseCommandLineArgumentsKt.validateArguments(((CommonCompilerArguments)arguments2).errors);
        if (message != null) {
            throw new IllegalArgumentException(message);
        }
    }

    @NotNull
    protected abstract A createArguments();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private ExitCode exec(@NotNull PrintStream errStream, @NotNull Services services, @NotNull MessageRenderer messageRenderer, @NotNull String[] args) {
        A arguments2;
        block16: {
            ExitCode exitCode;
            if (errStream == null) {
                CLICompiler.$$$reportNull$$$0(14);
            }
            if (services == null) {
                CLICompiler.$$$reportNull$$$0(15);
            }
            if (messageRenderer == null) {
                CLICompiler.$$$reportNull$$$0(16);
            }
            if (args == null) {
                CLICompiler.$$$reportNull$$$0(17);
            }
            K2JVMCompiler.Companion.resetInitStartTime();
            PrintingMessageCollector parseArgumentsCollector = new PrintingMessageCollector(errStream, messageRenderer, false);
            try {
                arguments2 = this.parseArguments(parseArgumentsCollector, args);
                if (arguments2 != null) break block16;
                exitCode = ExitCode.INTERNAL_ERROR;
            }
            catch (IllegalArgumentException e) {
                parseArgumentsCollector.report(CompilerMessageSeverity.ERROR, e.getMessage(), null);
                parseArgumentsCollector.report(CompilerMessageSeverity.INFO, "Use -help for more information", null);
                ExitCode exitCode2 = ExitCode.COMPILATION_ERROR;
                if (exitCode2 == null) {
                    CLICompiler.$$$reportNull$$$0(19);
                }
                return exitCode2;
            }
            if (exitCode == null) {
                CLICompiler.$$$reportNull$$$0(18);
            }
            return exitCode;
        }
        if (((CommonCompilerArguments)arguments2).help || ((CommonCompilerArguments)arguments2).extraHelp) {
            Usage.print(errStream, this, arguments2);
            ExitCode exitCode = ExitCode.OK;
            if (exitCode == null) {
                CLICompiler.$$$reportNull$$$0(20);
            }
            return exitCode;
        }
        PrintingMessageCollector collector2 = new PrintingMessageCollector(errStream, messageRenderer, ((CommonCompilerArguments)arguments2).verbose);
        if (PlainTextMessageRenderer.COLOR_ENABLED) {
            AnsiConsole.systemInstall();
        }
        errStream.print(messageRenderer.renderPreamble());
        ExitCode exitCode = this.exec(collector2, services, arguments2);
        ExitCode exitCode3 = exitCode;
        if (exitCode3 == null) {
            CLICompiler.$$$reportNull$$$0(21);
        }
        return exitCode3;
        finally {
            errStream.print(messageRenderer.renderConclusion());
            if (PlainTextMessageRenderer.COLOR_ENABLED) {
                AnsiConsole.systemUninstall();
            }
        }
    }

    /*
     * Exception decompiling
     */
    @NotNull
    public ExitCode exec(@NotNull MessageCollector messageCollector, @NotNull Services services, @NotNull A arguments) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void setupCommonArgumentsAndServices(@NotNull CompilerConfiguration configuration, @NotNull CommonCompilerArguments arguments2, @NotNull Services services) {
        CompilerJarLocator locator;
        if (configuration == null) {
            CLICompiler.$$$reportNull$$$0(29);
        }
        if (arguments2 == null) {
            CLICompiler.$$$reportNull$$$0(30);
        }
        if (services == null) {
            CLICompiler.$$$reportNull$$$0(31);
        }
        if (arguments2.noInline) {
            configuration.put(CommonConfigurationKeys.DISABLE_INLINE, true);
        }
        if (arguments2.intellijPluginRoot != null) {
            configuration.put(CLIConfigurationKeys.INTELLIJ_PLUGIN_ROOT, arguments2.intellijPluginRoot);
        }
        if (arguments2.reportOutputFiles) {
            configuration.put(CommonConfigurationKeys.REPORT_OUTPUT_FILES, true);
        }
        if ((locator = services.get(CompilerJarLocator.class)) != null) {
            configuration.put(CLIConfigurationKeys.COMPILER_JAR_LOCATOR, locator);
        }
        CLICompiler.setupLanguageVersionSettings(configuration, arguments2);
    }

    private static void setupLanguageVersionSettings(@NotNull CompilerConfiguration configuration, @NotNull CommonCompilerArguments arguments2) {
        LanguageFeature.State coroutinesState;
        if (configuration == null) {
            CLICompiler.$$$reportNull$$$0(32);
        }
        if (arguments2 == null) {
            CLICompiler.$$$reportNull$$$0(33);
        }
        LanguageVersion languageVersion = CLICompiler.parseVersion(configuration, arguments2.languageVersion, "language");
        LanguageVersion apiVersion = CLICompiler.parseVersion(configuration, arguments2.apiVersion, "API");
        if (languageVersion == null) {
            languageVersion = LanguageVersion.LATEST_STABLE;
        }
        if (apiVersion == null) {
            apiVersion = languageVersion;
        } else {
            configuration.put(CLIConfigurationKeys.IS_API_VERSION_EXPLICIT, true);
        }
        if (apiVersion.compareTo(languageVersion) > 0) {
            configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY).report(CompilerMessageSeverity.ERROR, "-api-version (" + apiVersion.getVersionString() + ") cannot be greater than -language-version (" + languageVersion.getVersionString() + ")", null);
        }
        if (!languageVersion.isStable()) {
            configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY).report(CompilerMessageSeverity.STRONG_WARNING, "Language version " + languageVersion.getVersionString() + " is experimental, there are no backwards compatibility guarantees for new language and library features", null);
        }
        HashMap<LanguageFeature, LanguageFeature.State> extraLanguageFeatures = new HashMap<LanguageFeature, LanguageFeature.State>(0);
        if (arguments2.multiPlatform) {
            extraLanguageFeatures.put(LanguageFeature.MultiPlatformProjects, LanguageFeature.State.ENABLED);
        }
        if ((coroutinesState = CLICompiler.chooseCoroutinesApplicabilityLevel(configuration, arguments2)) != null) {
            extraLanguageFeatures.put(LanguageFeature.Coroutines, coroutinesState);
        }
        LanguageVersionSettingsImpl settings2 = new LanguageVersionSettingsImpl(languageVersion, ApiVersion.createByLanguageVersion(apiVersion), extraLanguageFeatures);
        settings2.switchFlag(AnalysisFlags.getSkipMetadataVersionCheck(), arguments2.skipMetadataVersionCheck);
        settings2.switchFlag(AnalysisFlags.getMultiPlatformDoNotCheckImpl(), arguments2.noCheckImpl);
        CommonConfigurationKeysKt.setLanguageVersionSettings(configuration, settings2);
    }

    @Nullable
    private static LanguageFeature.State chooseCoroutinesApplicabilityLevel(@NotNull CompilerConfiguration configuration, @NotNull CommonCompilerArguments arguments2) {
        if (configuration == null) {
            CLICompiler.$$$reportNull$$$0(34);
        }
        if (arguments2 == null) {
            CLICompiler.$$$reportNull$$$0(35);
        }
        switch (arguments2.coroutinesState) {
            case "error": {
                return LanguageFeature.State.ENABLED_WITH_ERROR;
            }
            case "enable": {
                return LanguageFeature.State.ENABLED;
            }
            case "warn": {
                return null;
            }
        }
        String message = "Invalid value of -Xcoroutines (should be: enable, warn or error): " + arguments2.coroutinesState;
        configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY).report(CompilerMessageSeverity.ERROR, message, null);
        return null;
    }

    @Nullable
    private static LanguageVersion parseVersion(@NotNull CompilerConfiguration configuration, @Nullable String value, @NotNull String versionOf) {
        if (configuration == null) {
            CLICompiler.$$$reportNull$$$0(36);
        }
        if (versionOf == null) {
            CLICompiler.$$$reportNull$$$0(37);
        }
        if (value == null) {
            return null;
        }
        LanguageVersion version = LanguageVersion.fromVersionString(value);
        if (version != null) {
            return version;
        }
        List<String> versionStrings = ArraysKt.map(LanguageVersion.values(), LanguageVersion::getDescription);
        String message = "Unknown " + versionOf + " version: " + value + "\nSupported " + versionOf + " versions: " + StringsKt.join(versionStrings, ", ");
        configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY).report(CompilerMessageSeverity.ERROR, message, null);
        return null;
    }

    protected abstract void setupPlatformSpecificArgumentsAndServices(@NotNull CompilerConfiguration var1, @NotNull A var2, @NotNull Services var3);

    private static void reportArgumentParseProblems(@NotNull MessageCollector collector2, @NotNull ArgumentParseErrors errors) {
        if (collector2 == null) {
            CLICompiler.$$$reportNull$$$0(38);
        }
        if (errors == null) {
            CLICompiler.$$$reportNull$$$0(39);
        }
        for (String string : errors.getUnknownExtraFlags()) {
            collector2.report(CompilerMessageSeverity.STRONG_WARNING, "Flag is not supported by this version of the compiler: " + string, null);
        }
        for (String string : errors.getExtraArgumentsPassedInObsoleteForm()) {
            collector2.report(CompilerMessageSeverity.STRONG_WARNING, "Advanced option value is passed in an obsolete form. Please use the '=' character to specify the value: " + string + "=...", null);
        }
        for (Map.Entry entry : errors.getDuplicateArguments().entrySet()) {
            collector2.report(CompilerMessageSeverity.STRONG_WARNING, "Argument " + (String)entry.getKey() + " is passed multiple times. Only the last value will be used: " + (String)entry.getValue(), null);
        }
    }

    @NotNull
    protected abstract ExitCode doExecute(@NotNull A var1, @NotNull CompilerConfiguration var2, @NotNull Disposable var3);

    private void printVersionIfNeeded(@NotNull MessageCollector messageCollector2, @NotNull A arguments2) {
        if (messageCollector2 == null) {
            CLICompiler.$$$reportNull$$$0(40);
        }
        if (arguments2 == null) {
            CLICompiler.$$$reportNull$$$0(41);
        }
        if (((CommonCompilerArguments)arguments2).version) {
            messageCollector2.report(CompilerMessageSeverity.INFO, this.executableScriptFileName() + " " + "1.1.3" + " (JRE " + System.getProperty("java.runtime.version") + ")", null);
        }
    }

    @NotNull
    public abstract String executableScriptFileName();

    public static void doMain(@NotNull CLICompiler compiler2, @NotNull String[] args) {
        if (compiler2 == null) {
            CLICompiler.$$$reportNull$$$0(42);
        }
        if (args == null) {
            CLICompiler.$$$reportNull$$$0(43);
        }
        System.setProperty("java.awt.headless", "true");
        ExitCode exitCode = CLICompiler.doMainNoExit(compiler2, args);
        if (exitCode != ExitCode.OK) {
            System.exit(exitCode.getCode());
        }
    }

    @NotNull
    public static ExitCode doMainNoExit(@NotNull CLICompiler compiler2, @NotNull String[] args) {
        ExitCode exitCode;
        if (compiler2 == null) {
            CLICompiler.$$$reportNull$$$0(44);
        }
        if (args == null) {
            CLICompiler.$$$reportNull$$$0(45);
        }
        try {
            exitCode = compiler2.exec(System.err, args);
        }
        catch (CompileEnvironmentException e) {
            System.err.println(e.getMessage());
            ExitCode exitCode2 = ExitCode.INTERNAL_ERROR;
            if (exitCode2 == null) {
                CLICompiler.$$$reportNull$$$0(47);
            }
            return exitCode2;
        }
        if (exitCode == null) {
            CLICompiler.$$$reportNull$$$0(46);
        }
        return exitCode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 46: 
            case 47: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 46: 
            case 47: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errStream";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 17: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/cli/common/CLICompiler";
                break;
            }
            case 4: 
            case 15: 
            case 23: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "services";
                break;
            }
            case 10: 
            case 22: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageCollector";
                break;
            }
            case 13: 
            case 24: 
            case 30: 
            case 33: 
            case 35: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageRenderer";
                break;
            }
            case 29: 
            case 32: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionOf";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compiler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/cli/common/CLICompiler";
                break;
            }
            case 2: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "exec";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "execAndOutputXml";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "execFullPathsInMessages";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "doMainNoExit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "exec";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 46: 
            case 47: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "execAndOutputXml";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "execFullPathsInMessages";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseArguments";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "setupCommonArgumentsAndServices";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "setupLanguageVersionSettings";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "chooseCoroutinesApplicabilityLevel";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "parseVersion";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "reportArgumentParseProblems";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "printVersionIfNeeded";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "doMain";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "doMainNoExit";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 46: 
            case 47: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

