/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwnerStub;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.resolve.inline.InlineAnalyzerExtension;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.inline.ReasonableInlineRule;

public class AnalyzerExtensions {
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final Iterable<ReasonableInlineRule> reasonableInlineRules;

    public AnalyzerExtensions(@NotNull BindingTrace trace, @NotNull Iterable<ReasonableInlineRule> reasonableInlineRules) {
        if (trace == null) {
            AnalyzerExtensions.$$$reportNull$$$0(0);
        }
        if (reasonableInlineRules == null) {
            AnalyzerExtensions.$$$reportNull$$$0(1);
        }
        this.trace = trace;
        this.reasonableInlineRules = reasonableInlineRules;
    }

    public void process(@NotNull BodiesResolveContext bodiesResolveContext) {
        if (bodiesResolveContext == null) {
            AnalyzerExtensions.$$$reportNull$$$0(2);
        }
        for (Map.Entry<KtNamedFunction, SimpleFunctionDescriptor> entry : bodiesResolveContext.getFunctions().entrySet()) {
            KtNamedFunction function2 = entry.getKey();
            SimpleFunctionDescriptor functionDescriptor = entry.getValue();
            for (AnalyzerExtension analyzerExtension : this.getFunctionExtensions(functionDescriptor)) {
                analyzerExtension.process(functionDescriptor, function2, this.trace);
            }
        }
        for (Map.Entry<KtTypeParameterListOwnerStub, CallableMemberDescriptor> entry : bodiesResolveContext.getProperties().entrySet()) {
            KtProperty function2 = (KtProperty)entry.getKey();
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)entry.getValue();
            for (AnalyzerExtension analyzerExtension : this.getPropertyExtensions(propertyDescriptor)) {
                analyzerExtension.process(propertyDescriptor, function2, this.trace);
            }
        }
    }

    @NotNull
    private List<InlineAnalyzerExtension> getFunctionExtensions(@NotNull FunctionDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            AnalyzerExtensions.$$$reportNull$$$0(3);
        }
        if (InlineUtil.isInline(functionDescriptor)) {
            List<InlineAnalyzerExtension> list2 = Collections.singletonList(new InlineAnalyzerExtension(this.reasonableInlineRules));
            if (list2 == null) {
                AnalyzerExtensions.$$$reportNull$$$0(4);
            }
            return list2;
        }
        List<InlineAnalyzerExtension> list3 = Collections.emptyList();
        if (list3 == null) {
            AnalyzerExtensions.$$$reportNull$$$0(5);
        }
        return list3;
    }

    @NotNull
    private List<InlineAnalyzerExtension> getPropertyExtensions(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            AnalyzerExtensions.$$$reportNull$$$0(6);
        }
        if (InlineUtil.hasInlineAccessors(propertyDescriptor)) {
            List<InlineAnalyzerExtension> list2 = Collections.singletonList(new InlineAnalyzerExtension(this.reasonableInlineRules));
            if (list2 == null) {
                AnalyzerExtensions.$$$reportNull$$$0(7);
            }
            return list2;
        }
        List<InlineAnalyzerExtension> list3 = Collections.emptyList();
        if (list3 == null) {
            AnalyzerExtensions.$$$reportNull$$$0(8);
        }
        return list3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reasonableInlineRules";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bodiesResolveContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptor";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/AnalyzerExtensions";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/AnalyzerExtensions";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionExtensions";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionExtensions";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyExtensions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface AnalyzerExtension {
        public void process(@NotNull CallableMemberDescriptor var1, @NotNull KtCallableDeclaration var2, @NotNull BindingTrace var3);
    }
}

