/* retro-gtk-0.10.vapi generated by valac 0.35.5, do not modify. */

[CCode (gir_namespace = "Retro", gir_version = "0.8")]
namespace Retro {
	[CCode (cheader_filename = "retro-gtk.h")]
	public class CairoDisplay : Gtk.DrawingArea {
		public CairoDisplay ();
		public override bool draw (Cairo.Context cr);
		public void hide_video ();
		public void set_core (Retro.Core core);
		public void set_filter (Retro.VideoFilter filter);
		public void show_video ();
		public Gdk.Pixbuf pixbuf { get; set; }
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public class Core : GLib.Object {
		public Core (string file_name);
		public void deserialize_state ([CCode (array_length_type = "gsize")] uint8[] data) throws GLib.Error;
		public uint8[] get_memory (Retro.MemoryType id);
		public size_t get_memory_size (Retro.MemoryType id);
		public bool load_game (Retro.GameInfo game);
		public bool prepare ();
		public void reset ();
		public void run ();
		[CCode (array_length_type = "gsize")]
		public uint8[] serialize_state () throws GLib.Error;
		public void set_controller_port_device (uint port, Retro.DeviceType device);
		public void set_memory (Retro.MemoryType id, uint8[] data);
		public bool supports_serialization ();
		public uint api_version { get; }
		public string content_directory { get; set; }
		public Retro.DiskControl disk_control_interface { get; internal set; }
		public string file_name { get; construct; }
		public double frames_per_second { get; }
		public bool game_loaded { get; private set; }
		public Retro.Input input_interface { get; set construct; }
		public bool is_initiated { get; private set; }
		public string libretro_path { get; set; }
		public Retro.Rumble rumble_interface { get; set; }
		public string save_directory { get; set; }
		public bool support_no_game { get; internal set; }
		public string system_directory { get; set; }
		public Retro.SystemInfo system_info { get; }
		public signal void audio_output (int16[] frames, double sample_rate);
		public virtual signal void init ();
		public signal bool message (string message, uint frames);
		public signal bool shutdown ();
		public signal void video_output (uint8[] data, uint width, uint height, size_t pitch, Retro.PixelFormat pixel_format, float aspect_ratio);
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public class CoreDescriptor : GLib.Object {
		public class Platform : GLib.Object {
		}
		public CoreDescriptor (string filename) throws Retro.CoreDescriptorError, GLib.KeyFileError, GLib.FileError;
		public string get_firmware_md5 (string firmware) throws GLib.KeyFileError;
		public string get_firmware_path (string firmware) throws GLib.KeyFileError;
		public string get_firmware_sha512 (string firmware) throws GLib.KeyFileError;
		public string[] get_firmwares (string platform) throws GLib.KeyFileError;
		public GLib.Icon get_icon () throws GLib.KeyFileError;
		public string get_id ();
		public bool get_is_emulator () throws GLib.KeyFileError;
		public bool get_is_firmware_mandatory (string firmware) throws GLib.KeyFileError;
		public bool get_is_game () throws GLib.KeyFileError;
		public string[] get_mime_type (string platform) throws GLib.KeyFileError;
		public string get_module () throws GLib.KeyFileError;
		public GLib.File? get_module_file () throws GLib.KeyFileError;
		public string get_name () throws GLib.KeyFileError;
		public bool get_platform_supports_mime_types (string platform, string[] mime_types) throws GLib.KeyFileError;
		public bool has_firmware_md5 (string firmware) throws GLib.KeyFileError;
		public bool has_firmware_sha512 (string firmware) throws GLib.KeyFileError;
		public bool has_firmwares (string platform) throws GLib.KeyFileError;
		public bool has_icon () throws GLib.KeyFileError;
		public bool has_platform (string platform);
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public class DiskControl : GLib.Object {
		public bool add_image_index () throws Retro.CbError;
		public bool get_eject_state () throws Retro.CbError;
		public uint get_image_index () throws Retro.CbError;
		public uint get_num_images () throws Retro.CbError;
		public bool remove_image_index (uint index) throws Retro.CbError;
		public bool replace_image_index (uint index, Retro.GameInfo info) throws Retro.CbError;
		public bool set_eject_state (bool ejected) throws Retro.CbError;
		public bool set_image_index (uint image_index) throws Retro.CbError;
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public class FileStreamLog : GLib.Object, Retro.Log {
		public FileStreamLog (GLib.FileStream stream = GLib.stderr);
		public GLib.FileStream stream { get; set construct; }
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public class GamepadConfiguration : GLib.Object {
		public GamepadConfiguration ();
		public uint16 get_button_key (Retro.GamepadButtonType button);
		public void set_button_key (Retro.GamepadButtonType button, uint16 key);
		public void set_to_default ();
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public class InputDeviceManager : GLib.Object, Retro.Input {
		public InputDeviceManager ();
		public void remove_controller_device (uint port);
		public void set_controller_device (uint port, Retro.InputDevice device);
		public void set_keyboard (Retro.Keyboard keyboard);
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public class Keyboard : GLib.Object {
		public Keyboard (Gtk.Widget widget);
		public Gtk.Widget widget { get; construct; }
		public signal void key_event (bool down, Retro.KeyboardKey keycode, uint32 character, Retro.KeyboardModifierKey key_modifiers);
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public class KeyboardState : GLib.Object {
		public KeyboardState (Gtk.Widget widget);
		public bool get_key_state (uint16 hardware_keycode);
		public Gtk.Widget widget { get; construct; }
		public signal void key_state_changed ();
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public class MainLoop : GLib.Object {
		public MainLoop (Retro.Core core);
		public void reset ();
		public void start ();
		public void stop ();
		public Retro.Core core { get; set construct; }
		public double speed_rate { get; set construct; }
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public class ModuleIterator {
		public new Retro.CoreDescriptor? @get ();
		public bool next ();
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public class ModuleQuery {
		public ModuleQuery (bool recursive);
		public Retro.ModuleIterator iterator ();
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public class Mouse : GLib.Object, Retro.InputDevice {
		public Mouse (Gtk.Widget widget);
		public bool get_button_state (uint button);
		public bool parse { get; set; }
		public Gtk.Widget widget { get; construct; }
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public class PaPlayer : GLib.Object {
		public PaPlayer ();
		public void set_core (Retro.Core core);
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public class VirtualGamepad : GLib.Object, Retro.InputDevice {
		public VirtualGamepad (Gtk.Widget widget);
		public bool get_button_pressed (Retro.GamepadButtonType button);
		public VirtualGamepad.with_configuration (Gtk.Widget widget, Retro.GamepadConfiguration configuration);
		public Retro.GamepadConfiguration configuration { get; set construct; }
		public Gtk.Widget widget { get; construct; }
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public interface Input : GLib.Object {
		public delegate void ControllerCallback (uint port, Retro.InputDevice device);
		public abstract void foreach_controller (Retro.Input.ControllerCallback callback);
		public abstract uint64 get_device_capabilities ();
		public abstract int16 get_state (uint port, Retro.DeviceType device, uint index, uint id);
		public abstract void poll ();
		public abstract void set_descriptors (Retro.InputDescriptor[] input_descriptors);
		public signal void controller_connected (uint port, Retro.InputDevice device);
		public signal void controller_disconnected (uint port);
		public signal void key_event (bool down, Retro.KeyboardKey keycode, uint32 character, Retro.KeyboardModifierKey key_modifiers);
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public interface InputDevice : GLib.Object {
		public abstract uint64 get_device_capabilities ();
		public abstract Retro.DeviceType get_device_type ();
		public abstract int16 get_input_state (Retro.DeviceType device, uint index, uint id);
		public abstract void poll ();
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public interface Log : GLib.Object {
		public abstract bool log (Retro.LogLevel level, string message);
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public interface Rumble : GLib.Object {
		public abstract bool set_rumble_state (uint port, Retro.RumbleEffect effect, uint16 strength);
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public struct GameInfo {
		public string path;
		[CCode (array_length_type = "gsize")]
		public uint8[] data;
		public string meta;
		public GameInfo (string file_name);
		public GameInfo.with_data (string file_name) throws GLib.FileError;
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public struct InputDescriptor {
		public uint port;
		public Retro.DeviceType device;
		public uint index;
		public uint id;
		public string description;
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public struct SystemInfo {
		public string library_name;
		public string library_version;
		public string valid_extensions;
		public bool need_fullpath;
		public bool block_extract;
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public enum AnalogId {
		X,
		Y
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public enum AnalogIndex {
		LEFT,
		RIGHT
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public enum DeviceType {
		TYPE_MASK,
		NONE,
		JOYPAD,
		MOUSE,
		KEYBOARD,
		LIGHTGUN,
		ANALOG,
		POINTER;
		public Retro.DeviceType get_basic_type ();
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public enum GamepadButtonType {
		ACTION_DOWN,
		ACTION_LEFT,
		SELECT,
		START,
		DIRECTION_UP,
		DIRECTION_DOWN,
		DIRECTION_LEFT,
		DIRECTION_RIGHT,
		ACTION_RIGHT,
		ACTION_UP,
		SHOULDER_L,
		SHOULDER_R,
		SHOULDER_L2,
		SHOULDER_R2,
		STICK_L,
		STICK_R,
		HOME;
		public static size_t size ();
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public enum JoypadId {
		B,
		Y,
		SELECT,
		START,
		UP,
		DOWN,
		LEFT,
		RIGHT,
		A,
		X,
		L,
		R,
		L2,
		R2,
		L3,
		R3
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public enum KeyboardKey {
		UNKNOWN,
		FIRST,
		BACKSPACE,
		TAB,
		CLEAR,
		RETURN,
		PAUSE,
		ESCAPE,
		SPACE,
		EXCLAIM,
		QUOTEDBL,
		HASH,
		DOLLAR,
		AMPERSAND,
		QUOTE,
		LEFTPAREN,
		RIGHTPAREN,
		ASTERISK,
		PLUS,
		COMMA,
		MINUS,
		PERIOD,
		SLASH,
		ZERO,
		ONE,
		TWO,
		THREE,
		FOUR,
		FINE,
		SIX,
		SEVEN,
		HEIGHT,
		NINE,
		COLON,
		SEMICOLON,
		LESS,
		EQUALS,
		GREATER,
		QUESTION,
		AT,
		LEFTBRACKET,
		BACKSLASH,
		RIGHTBRACKET,
		CARET,
		UNDERSCORE,
		BACKQUOTE,
		a,
		b,
		c,
		d,
		e,
		f,
		g,
		h,
		i,
		j,
		k,
		l,
		m,
		n,
		o,
		p,
		q,
		r,
		s,
		t,
		u,
		v,
		w,
		x,
		y,
		z,
		DELETE,
		KP0,
		KP1,
		KP2,
		KP3,
		KP4,
		KP5,
		KP6,
		KP7,
		KP8,
		KP9,
		KP_PERIOD,
		KP_DIVIDE,
		KP_MULTIPLY,
		KP_MINUS,
		KP_PLUS,
		KP_ENTER,
		KP_EQUALS,
		UP,
		DOWN,
		RIGHT,
		LEFT,
		INSERT,
		HOME,
		END,
		PAGEUP,
		PAGEDOWN,
		F1,
		F2,
		F3,
		F4,
		F5,
		F6,
		F7,
		F8,
		F9,
		F10,
		F11,
		F12,
		F13,
		F14,
		F15,
		NUMLOCK,
		CAPSLOCK,
		SCROLLOCK,
		RSHIFT,
		LSHIFT,
		RCTRL,
		LCTRL,
		RALT,
		LALT,
		RMETA,
		LMETA,
		LSUPER,
		RSUPER,
		MODE,
		COMPOSE,
		HELP,
		PRINT,
		SYSREQ,
		BREAK,
		MENU,
		POWER,
		EURO,
		UNDO,
		LAST
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	[Flags]
	public enum KeyboardModifierKey {
		NONE,
		SHIFT,
		CTRL,
		ALT,
		META,
		NUMLOCK,
		CAPSLOCK,
		SCROLLOCK
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public enum LightgunId {
		X,
		Y,
		TRIGGER,
		CURSOR,
		TURBO,
		PAUSE,
		START
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public enum LogLevel {
		DEBUG,
		INFO,
		WARN,
		ERROR
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public enum MemoryType {
		TYPE_MASK,
		SAVE_RAM,
		RTC,
		SYSTEM_RAM,
		VIDEO_RAM,
		SNES_BSX_RAM,
		SNES_BSX_PRAM,
		SNES_SUFAMI_TURBO_A_RAM,
		SNES_SUFAMI_TURBO_B_RAM,
		SNES_GAME_BOY_RAM,
		SNES_GAME_BOY_RTC;
		public Retro.MemoryType get_basic_type ();
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public enum MouseId {
		X,
		Y,
		LEFT,
		RIGHT,
		WHEELUP,
		WHEELDOWN,
		MIDDLE,
		HORIZ_WHEELUP,
		HORIZ_WHEELDOWN
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public enum PixelFormat {
		XRGB1555,
		XRGB8888,
		RGB565,
		UNKNOWN
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public enum PointerId {
		X,
		Y,
		PRESSED
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public enum Rotation {
		NONE,
		COUNTERCLOCKWISE,
		UPSIDEDOWN,
		CLOCKWISE
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public enum RumbleEffect {
		STRONG,
		WEAK
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public enum VideoFilter {
		SMOOTH,
		SHARP;
		public static Retro.VideoFilter from_string (string filter);
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public errordomain CbError {
		NO_CORE,
		NO_CALLBACK
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public errordomain CoreDescriptorError {
		REQUIRED_GROUP_NOT_FOUND,
		REQUIRED_KEY_NOT_FOUND,
		FIRMWARE_NOT_FOUND
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public errordomain CoreError {
		COULDNT_SERIALIZE,
		COULDNT_DESERIALIZE,
		SERIALIZATION_NOT_SUPPORTED
	}
	[CCode (cheader_filename = "retro-gtk.h")]
	public const uint API_VERSION;
	[CCode (cheader_filename = "retro-gtk.h")]
	public static Retro.SystemInfo? get_system_info (string module_name);
}
