/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.vncviewer;

import com.tigervnc.network.TcpListener;
import com.tigervnc.network.TcpSocket;
import com.tigervnc.rfb.Configuration;
import com.tigervnc.rfb.Exception;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.SecurityClient;
import com.tigervnc.rfb.StringParameter;
import com.tigervnc.vncviewer.CConn;
import com.tigervnc.vncviewer.DesktopWindow;
import com.tigervnc.vncviewer.ExtProcess;
import com.tigervnc.vncviewer.Parameters;
import com.tigervnc.vncviewer.ServerDialog;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.CharBuffer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class VncViewer
extends JApplet
implements Runnable,
ActionListener {
    public static final String aboutText = new String("TigerVNC Java Viewer v%s (%s)%nBuilt on %s at %s%nCopyright (C) 1999-2017 TigerVNC Team and many others (see README.txt)%nSee http://www.tigervnc.org for information on TigerVNC.");
    public static String version = null;
    public static String build = null;
    public static String buildDate = null;
    public static String buildTime = null;
    static ImageIcon frameIconSrc = new ImageIcon(VncViewer.class.getResource("tigervnc.ico"));
    public static final Image frameIcon = frameIconSrc.getImage();
    public static final ImageIcon logoIcon = new ImageIcon(VncViewer.class.getResource("tigervnc.png"));
    public static final Image logoImage = logoIcon.getImage();
    public static final InputStream timestamp = VncViewer.class.getResourceAsStream("timestamp");
    public static final String os = System.getProperty("os.name").toLowerCase();
    private static VncViewer applet;
    private String defaultServerName;
    int VNCSERVERNAMELEN = 64;
    CharBuffer vncServerName = CharBuffer.allocate(this.VNCSERVERNAMELEN);
    public static CConn cc;
    public static StringParameter config;
    Thread thread;
    static LogWriter vlog;

    public static void setLookAndFeel() {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            if (os.startsWith("mac os x")) {
                object5 = Class.forName("com.apple.eawt.Application");
                object4 = ((Class)object5).getMethod("getApplication", null);
                object3 = ((Method)object4).invoke(object5, new Object[0]);
                object2 = new Class[]{Image.class};
                object = ((Class)object5).getMethod("setDockIconImage", (Class<?>)object2);
                ((Method)object).invoke(object3, logoImage);
            }
            if ((object5 = System.getProperty("swing.defaultlaf")) == null) {
                object4 = UIManager.getInstalledLookAndFeels();
                for (int i = 0; i < ((UIManager.LookAndFeelInfo[])object4).length; ++i) {
                    if (!((UIManager.LookAndFeelInfo)object4[i]).getName().equals("Nimbus")) continue;
                    object5 = ((UIManager.LookAndFeelInfo)object4[i]).getClassName();
                }
                if (object5 == null) {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
            }
            UIManager.setLookAndFeel((String)object5);
            if (UIManager.getLookAndFeel().getName().equals("Metal")) {
                UIManager.put("swing.boldMetal", Boolean.FALSE);
                object4 = UIManager.getDefaults().keys();
                while (object4.hasMoreElements()) {
                    object3 = object4.nextElement();
                    object2 = UIManager.get(object3);
                    if (!(object2 instanceof FontUIResource)) continue;
                    object = ((FontUIResource)object2).getName();
                    int n = ((FontUIResource)object2).getStyle();
                    int n2 = ((FontUIResource)object2).getSize() - 1;
                    FontUIResource fontUIResource = new FontUIResource((String)object, n, n2);
                    UIManager.put(object3, fontUIResource);
                }
            } else if (UIManager.getLookAndFeel().getName().equals("Nimbus")) {
                object4 = UIManager.getFont("TitledBorder.font");
                object3 = ((Font)object4).getName();
                int n = ((Font)object4).getStyle();
                int n3 = ((Font)object4).getSize() - 2;
                FontUIResource fontUIResource = new FontUIResource((String)object3, n, n3);
                UIManager.put("TitledBorder.font", fontUIResource);
            }
        }
        catch (java.lang.Exception exception) {
            vlog.info(exception.toString());
        }
    }

    public static void main(String[] stringArray) {
        VncViewer.setLookAndFeel();
        VncViewer vncViewer = new VncViewer(stringArray);
        vncViewer.start();
    }

    public VncViewer() {
        this(new String[0]);
    }

    public VncViewer(String[] stringArray) {
        SecurityClient.setDefaults();
        VncViewer.getTimestamp();
        System.err.format("%n", new Object[0]);
        System.err.format(aboutText, version, build, buildDate, buildTime);
        System.err.format("%n", new Object[0]);
        Configuration.enableViewerParams();
        try {
            this.defaultServerName = Parameters.loadViewerParameters(null);
        }
        catch (Exception exception) {
            this.defaultServerName = "";
            vlog.info(exception.getMessage());
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() == 0) continue;
            if (stringArray[i].equalsIgnoreCase("-config")) {
                if (++i >= stringArray.length) {
                    VncViewer.usage();
                }
                this.defaultServerName = Parameters.loadViewerParameters(stringArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-log")) {
                if (++i >= stringArray.length) {
                    VncViewer.usage();
                }
                System.err.println("Log setting: " + stringArray[i]);
                LogWriter.setLogParams(stringArray[i]);
                continue;
            }
            if (Configuration.setParam(stringArray[i])) continue;
            if (stringArray[i].charAt(0) == '-') {
                if (i + 1 < stringArray.length && Configuration.setParam(stringArray[i].substring(1), stringArray[i + 1])) {
                    ++i;
                    continue;
                }
                VncViewer.usage();
            }
            this.vncServerName.put(stringArray[i].toCharArray()).flip();
        }
    }

    public static void usage() {
        String string = "\nusage: vncviewer [options/parameters] [host:displayNum]\n       vncviewer [options/parameters] -listen [port] [options/parameters]\n\nOptions:\n  -log <level>    configure logging level\n\nParameters can be turned on with -<param> or off with -<param>=0\nParameters which take a value can be specified as -<param> <value>\nOther valid forms are <param>=<value> -<param>=<value> --<param>=<value>\nParameter names are case-insensitive.  The parameters are:\n\n";
        System.err.print(string);
        Configuration.listParams(79, 14);
        String string2 = "\nSystem Properties (adapted from the TurboVNC vncviewer man page)\n  When started with the -via option, vncviewer reads the VNC_VIA_CMD\n  System property, expands patterns beginning with the \"%\" character,\n  and uses the resulting command line to establish the secure tunnel\n  to the VNC gateway.  If VNC_VIA_CMD is not set, this command line\n  defaults to \"/usr/bin/ssh -f -L %L:%H:%R %G sleep 20\".\n\n  The following patterns are recognized in the VNC_VIA_CMD property\n  (note that all of the patterns %G, %H, %L and %R must be present in \n  the command template):\n\n  \t%%     A literal \"%\";\n\n  \t%G     gateway machine name;\n\n  \t%H     remote VNC machine name, (as known to the gateway);\n\n  \t%L     local TCP port number;\n\n  \t%R     remote TCP port number.\n\n  When started with the -tunnel option, vncviewer reads the VNC_TUNNEL_CMD\n  System property, expands patterns beginning with the \"%\" character, and\n  uses the resulting command line to establish the secure tunnel to the\n  VNC server.  If VNC_TUNNEL_CMD is not set, this command line defaults\n  to \"/usr/bin/ssh -f -L %L:localhost:%R %H sleep 20\".\n\n  The following patterns are recognized in the VNC_TUNNEL_CMD property\n  (note that all of the patterns %H, %L and %R must be present in \n  the command template):\n\n  \t%%     A literal \"%\";\n\n  \t%H     remote VNC machine name (as known to the client);\n\n  \t%L     local TCP port number;\n\n  \t%R     remote TCP port number.\n\n";
        System.err.print(string2);
        System.exit(1);
    }

    public static void newViewer() {
        String string = "java -jar ";
        try {
            URL uRL = VncViewer.class.getProtectionDomain().getCodeSource().getLocation();
            File file = new File(uRL.toURI());
            if (!file.exists() || !file.canRead()) {
                String string2 = new String("The jar file " + file.getAbsolutePath() + " does not exist or cannot be read.");
                JOptionPane.showMessageDialog(null, string2, "ERROR", 0);
                return;
            }
            string = string.concat(file.getAbsolutePath());
            Thread thread = new Thread(new ExtProcess(string, vlog));
            thread.start();
        }
        catch (URISyntaxException uRISyntaxException) {
            vlog.info(uRISyntaxException.getMessage());
        }
        catch (java.lang.Exception exception) {
            vlog.info(exception.getMessage());
        }
    }

    public boolean isAppletDragStart(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 506) {
            if (os.startsWith("mac os x")) {
                return false;
            }
            if (os.startsWith("windows")) {
                return (mouseEvent.getModifiersEx() & 0x200) != 0;
            }
            return (mouseEvent.getModifiersEx() & 0x40) != 0;
        }
        return false;
    }

    public void appletDragStarted() {
        Parameters.embed.setParam(false);
        JFrame jFrame = (JFrame)JOptionPane.getFrameForComponent(this);
        if (jFrame != null) {
            jFrame.setSize(0, 0);
        }
    }

    public void appletDragFinished() {
        JFrame jFrame = (JFrame)JOptionPane.getFrameForComponent(this);
        if (jFrame != null) {
            jFrame.dispose();
        }
    }

    public void setAppletCloseListener(ActionListener actionListener) {
        cc.setCloseListener(actionListener);
    }

    public void appletRestored() {
        cc.setCloseListener(null);
    }

    public static void setupEmbeddedFrame(JScrollPane jScrollPane) {
        InputMap inputMap = jScrollPane.getInputMap(2);
        int n = 11;
        if (inputMap != null) {
            inputMap.put(KeyStroke.getKeyStroke(38, n), "unitScrollUp");
            inputMap.put(KeyStroke.getKeyStroke(40, n), "unitScrollDown");
            inputMap.put(KeyStroke.getKeyStroke(37, n), "unitScrollLeft");
            inputMap.put(KeyStroke.getKeyStroke(39, n), "unitScrollRight");
            inputMap.put(KeyStroke.getKeyStroke(33, n), "scrollUp");
            inputMap.put(KeyStroke.getKeyStroke(34, n), "scrollDown");
            inputMap.put(KeyStroke.getKeyStroke(36, n), "scrollLeft");
            inputMap.put(KeyStroke.getKeyStroke(35, n), "scrollRight");
        }
        applet.getContentPane().removeAll();
        applet.getContentPane().add(jScrollPane);
        applet.validate();
    }

    @Override
    public void init() {
        VncViewer.setLookAndFeel();
        this.setBackground(Color.white);
        applet = this;
        this.vncServerName.put(Parameters.loadAppletParameters(applet).toCharArray()).flip();
        if (Parameters.embed.getValue()) {
            Parameters.fullScreen.setParam(false);
            Parameters.remoteResize.setParam(false);
            Parameters.maximize.setParam(false);
            Parameters.scalingFactor.setParam("100");
        }
        this.setFocusTraversalKeysEnabled(false);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (cc != null && VncViewer.cc.desktop != null) {
                    VncViewer.cc.desktop.viewport.requestFocusInWindow();
                }
            }
        });
        Frame frame = (Frame)this.getFocusCycleRootAncestor();
        frame.setFocusTraversalKeysEnabled(false);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                if (cc != null && VncViewer.cc.desktop != null) {
                    VncViewer.cc.desktop.viewport.requestFocusInWindow();
                }
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
                if (cc != null) {
                    cc.releaseDownKeys();
                }
            }
        });
    }

    private static void getTimestamp() {
        if (version == null || build == null) {
            try {
                Manifest manifest = new Manifest(timestamp);
                Attributes attributes = manifest.getMainAttributes();
                version = attributes.getValue("Version");
                build = attributes.getValue("Build");
                buildDate = attributes.getValue("Package-Date");
                buildTime = attributes.getValue("Package-Time");
            }
            catch (java.lang.Exception exception) {
                // empty catch block
            }
        }
    }

    public static void showAbout(Container container) {
        Object object;
        Object object2;
        String string = "";
        String string2 = "";
        try {
            object2 = new Manifest(timestamp);
            object = ((Manifest)object2).getMainAttributes();
            string = ((Attributes)object).getValue("Package-Date");
            string2 = ((Attributes)object).getValue("Package-Time");
        }
        catch (java.lang.Exception exception) {
            // empty catch block
        }
        object2 = DesktopWindow.getFullScreenWindow();
        if (object2 != null) {
            DesktopWindow.setFullScreenWindow(null);
        }
        object = String.format(aboutText, version, build, buildDate, buildTime);
        Object[] objectArray = new Object[]{"Close  \u21b5"};
        JOptionPane jOptionPane = new JOptionPane(object, 1, -1, logoIcon, objectArray);
        JDialog jDialog = jOptionPane.createDialog(container, "About TigerVNC Viewer for Java");
        jDialog.setIconImage(frameIcon);
        jDialog.setAlwaysOnTop(true);
        jDialog.setVisible(true);
        if (object2 != null) {
            DesktopWindow.setFullScreenWindow((Window)object2);
        }
    }

    @Override
    public void start() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void exit(int n) {
        if (Parameters.embed.getValue()) {
            this.destroy();
        } else {
            System.exit(n);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.getContentPane().removeAll();
        this.start();
    }

    void reportException(java.lang.Exception exception) {
        String string = exception.getMessage();
        int n = 0;
        String string2 = "TigerVNC Viewer : Error";
        exception.printStackTrace();
        if (Parameters.embed.getValue()) {
            this.getContentPane().removeAll();
            JLabel jLabel = new JLabel("<html><center><b>" + string2 + "</b><p><i>" + string + "</i></center></html>", 0);
            jLabel.setFont(new Font("Helvetica", 0, 24));
            jLabel.setMaximumSize(new Dimension(this.getSize().width, 100));
            jLabel.setVerticalAlignment(0);
            jLabel.setAlignmentX(0.5f);
            JButton jButton = new JButton("Reconnect");
            jButton.addActionListener(this);
            jButton.setMaximumSize(new Dimension(200, 30));
            jButton.setAlignmentX(0.5f);
            this.setLayout(new BoxLayout(this.getContentPane(), 1));
            this.add(jLabel);
            this.add(jButton);
            this.validate();
            this.repaint();
        } else {
            JOptionPane.showMessageDialog(null, string, string2, n);
        }
    }

    @Override
    public void run() {
        cc = null;
        TcpSocket tcpSocket = null;
        if (Parameters.listenMode.getValue() && !Parameters.via.getValueStr().isEmpty()) {
            vlog.error("Parameters -listen and -via are incompatible");
            String string = new String("Parameters -listen and -via are incompatible");
            JOptionPane.showMessageDialog(null, string, "ERROR", 0);
            this.exit(1);
        }
        if (Parameters.listenMode.getValue()) {
            int n = 5500;
            if (this.vncServerName.charAt(0) != '\u0000' && Character.isDigit(this.vncServerName.charAt(0))) {
                n = Integer.parseInt(this.vncServerName.toString());
            }
            TcpListener tcpListener = null;
            try {
                tcpListener = new TcpListener(null, n);
            }
            catch (java.lang.Exception exception) {
                this.reportException(exception);
                this.exit(1);
            }
            vlog.info("Listening on port " + n);
            while (tcpSocket == null) {
                tcpSocket = tcpListener.accept();
            }
        } else if (this.vncServerName.charAt(0) == '\u0000') {
            try {
                SwingUtilities.invokeAndWait(new ServerDialog(this.defaultServerName, this.vncServerName));
            }
            catch (InvocationTargetException invocationTargetException) {
                this.reportException(invocationTargetException);
            }
            catch (InterruptedException interruptedException) {
                this.reportException(interruptedException);
            }
            if (this.vncServerName.charAt(0) == '\u0000') {
                this.exit(0);
            }
        }
        try {
            cc = new CConn(this.vncServerName.toString(), tcpSocket);
            while (!VncViewer.cc.shuttingDown) {
                cc.processMsg();
            }
            this.exit(0);
        }
        catch (java.lang.Exception exception) {
            if (cc == null || !VncViewer.cc.shuttingDown) {
                this.reportException(exception);
                if (cc != null) {
                    cc.close();
                }
            } else if (Parameters.embed.getValue()) {
                this.reportException(new java.lang.Exception("Connection closed"));
                this.exit(0);
            }
            this.exit(1);
        }
    }

    static {
        config = new StringParameter("Config", "Specifies a configuration file to load.", null);
        vlog = new LogWriter("VncViewer");
    }
}

