/*
 *  utf_16.h  --  include for UTF-16 (Unicode) characters database
 */

#ifndef _TUTF_UTF_16_H
#define _TUTF_UTF_16_H


#define T_UTF_16_NULL	0x0000
#define T_UTF_16_START_OF_HEADING	0x0001
#define T_UTF_16_START_OF_TEXT	0x0002
#define T_UTF_16_END_OF_TEXT	0x0003
#define T_UTF_16_END_OF_TRANSMISSION	0x0004
#define T_UTF_16_ENQUIRY	0x0005
#define T_UTF_16_ACKNOWLEDGE	0x0006
#define T_UTF_16_BELL	0x0007
#define T_UTF_16_BACKSPACE	0x0008
#define T_UTF_16_HORIZONTAL_TABULATION	0x0009
#define T_UTF_16_LINE_FEED	0x000A
#define T_UTF_16_VERTICAL_TABULATION	0x000B
#define T_UTF_16_FORM_FEED	0x000C
#define T_UTF_16_CARRIAGE_RETURN	0x000D
#define T_UTF_16_SHIFT_OUT	0x000E
#define T_UTF_16_SHIFT_IN	0x000F
#define T_UTF_16_DATA_LINK_ESCAPE	0x0010
#define T_UTF_16_DEVICE_CONTROL_ONE	0x0011
#define T_UTF_16_DEVICE_CONTROL_TWO	0x0012
#define T_UTF_16_DEVICE_CONTROL_THREE	0x0013
#define T_UTF_16_DEVICE_CONTROL_FOUR	0x0014
#define T_UTF_16_NEGATIVE_ACKNOWLEDGE	0x0015
#define T_UTF_16_SYNCHRONOUS_IDLE	0x0016
#define T_UTF_16_END_OF_TRANSMISSION_BLOCK	0x0017
#define T_UTF_16_CANCEL	0x0018
#define T_UTF_16_END_OF_MEDIUM	0x0019
#define T_UTF_16_SUBSTITUTE	0x001A
#define T_UTF_16_ESCAPE	0x001B
#define T_UTF_16_FILE_SEPARATOR	0x001C
#define T_UTF_16_GROUP_SEPARATOR	0x001D
#define T_UTF_16_RECORD_SEPARATOR	0x001E
#define T_UTF_16_UNIT_SEPARATOR	0x001F
#define T_UTF_16_SPACE	0x0020
#define T_UTF_16_EXCLAMATION_MARK	0x0021
#define T_UTF_16_QUOTATION_MARK	0x0022
#define T_UTF_16_NUMBER_SIGN	0x0023
#define T_UTF_16_DOLLAR_SIGN	0x0024
#define T_UTF_16_PERCENT_SIGN	0x0025
#define T_UTF_16_AMPERSAND	0x0026
#define T_UTF_16_APOSTROPHE	0x0027
#define T_UTF_16_LEFT_PARENTHESIS	0x0028
#define T_UTF_16_RIGHT_PARENTHESIS	0x0029
#define T_UTF_16_ASTERISK	0x002A
#define T_UTF_16_PLUS_SIGN	0x002B
#define T_UTF_16_COMMA	0x002C
#define T_UTF_16_HYPHEN_MINUS	0x002D
#define T_UTF_16_FULL_STOP	0x002E
#define T_UTF_16_SOLIDUS	0x002F
#define T_UTF_16_DIGIT_ZERO	0x0030
#define T_UTF_16_DIGIT_ONE	0x0031
#define T_UTF_16_DIGIT_TWO	0x0032
#define T_UTF_16_DIGIT_THREE	0x0033
#define T_UTF_16_DIGIT_FOUR	0x0034
#define T_UTF_16_DIGIT_FIVE	0x0035
#define T_UTF_16_DIGIT_SIX	0x0036
#define T_UTF_16_DIGIT_SEVEN	0x0037
#define T_UTF_16_DIGIT_EIGHT	0x0038
#define T_UTF_16_DIGIT_NINE	0x0039
#define T_UTF_16_COLON	0x003A
#define T_UTF_16_SEMICOLON	0x003B
#define T_UTF_16_LESS_THAN_SIGN	0x003C
#define T_UTF_16_EQUALS_SIGN	0x003D
#define T_UTF_16_GREATER_THAN_SIGN	0x003E
#define T_UTF_16_QUESTION_MARK	0x003F
#define T_UTF_16_COMMERCIAL_AT	0x0040
#define T_UTF_16_LATIN_CAPITAL_LETTER_A	0x0041
#define T_UTF_16_LATIN_CAPITAL_LETTER_B	0x0042
#define T_UTF_16_LATIN_CAPITAL_LETTER_C	0x0043
#define T_UTF_16_LATIN_CAPITAL_LETTER_D	0x0044
#define T_UTF_16_LATIN_CAPITAL_LETTER_E	0x0045
#define T_UTF_16_LATIN_CAPITAL_LETTER_F	0x0046
#define T_UTF_16_LATIN_CAPITAL_LETTER_G	0x0047
#define T_UTF_16_LATIN_CAPITAL_LETTER_H	0x0048
#define T_UTF_16_LATIN_CAPITAL_LETTER_I	0x0049
#define T_UTF_16_LATIN_CAPITAL_LETTER_J	0x004A
#define T_UTF_16_LATIN_CAPITAL_LETTER_K	0x004B
#define T_UTF_16_LATIN_CAPITAL_LETTER_L	0x004C
#define T_UTF_16_LATIN_CAPITAL_LETTER_M	0x004D
#define T_UTF_16_LATIN_CAPITAL_LETTER_N	0x004E
#define T_UTF_16_LATIN_CAPITAL_LETTER_O	0x004F
#define T_UTF_16_LATIN_CAPITAL_LETTER_P	0x0050
#define T_UTF_16_LATIN_CAPITAL_LETTER_Q	0x0051
#define T_UTF_16_LATIN_CAPITAL_LETTER_R	0x0052
#define T_UTF_16_LATIN_CAPITAL_LETTER_S	0x0053
#define T_UTF_16_LATIN_CAPITAL_LETTER_T	0x0054
#define T_UTF_16_LATIN_CAPITAL_LETTER_U	0x0055
#define T_UTF_16_LATIN_CAPITAL_LETTER_V	0x0056
#define T_UTF_16_LATIN_CAPITAL_LETTER_W	0x0057
#define T_UTF_16_LATIN_CAPITAL_LETTER_X	0x0058
#define T_UTF_16_LATIN_CAPITAL_LETTER_Y	0x0059
#define T_UTF_16_LATIN_CAPITAL_LETTER_Z	0x005A
#define T_UTF_16_LEFT_SQUARE_BRACKET	0x005B
#define T_UTF_16_REVERSE_SOLIDUS	0x005C
#define T_UTF_16_RIGHT_SQUARE_BRACKET	0x005D
#define T_UTF_16_CIRCUMFLEX_ACCENT	0x005E
#define T_UTF_16_LOW_LINE	0x005F
#define T_UTF_16_GRAVE_ACCENT	0x0060
#define T_UTF_16_LATIN_SMALL_LETTER_A	0x0061
#define T_UTF_16_LATIN_SMALL_LETTER_B	0x0062
#define T_UTF_16_LATIN_SMALL_LETTER_C	0x0063
#define T_UTF_16_LATIN_SMALL_LETTER_D	0x0064
#define T_UTF_16_LATIN_SMALL_LETTER_E	0x0065
#define T_UTF_16_LATIN_SMALL_LETTER_F	0x0066
#define T_UTF_16_LATIN_SMALL_LETTER_G	0x0067
#define T_UTF_16_LATIN_SMALL_LETTER_H	0x0068
#define T_UTF_16_LATIN_SMALL_LETTER_I	0x0069
#define T_UTF_16_LATIN_SMALL_LETTER_J	0x006A
#define T_UTF_16_LATIN_SMALL_LETTER_K	0x006B
#define T_UTF_16_LATIN_SMALL_LETTER_L	0x006C
#define T_UTF_16_LATIN_SMALL_LETTER_M	0x006D
#define T_UTF_16_LATIN_SMALL_LETTER_N	0x006E
#define T_UTF_16_LATIN_SMALL_LETTER_O	0x006F
#define T_UTF_16_LATIN_SMALL_LETTER_P	0x0070
#define T_UTF_16_LATIN_SMALL_LETTER_Q	0x0071
#define T_UTF_16_LATIN_SMALL_LETTER_R	0x0072
#define T_UTF_16_LATIN_SMALL_LETTER_S	0x0073
#define T_UTF_16_LATIN_SMALL_LETTER_T	0x0074
#define T_UTF_16_LATIN_SMALL_LETTER_U	0x0075
#define T_UTF_16_LATIN_SMALL_LETTER_V	0x0076
#define T_UTF_16_LATIN_SMALL_LETTER_W	0x0077
#define T_UTF_16_LATIN_SMALL_LETTER_X	0x0078
#define T_UTF_16_LATIN_SMALL_LETTER_Y	0x0079
#define T_UTF_16_LATIN_SMALL_LETTER_Z	0x007A
#define T_UTF_16_LEFT_CURLY_BRACKET	0x007B
#define T_UTF_16_VERTICAL_LINE	0x007C
#define T_UTF_16_RIGHT_CURLY_BRACKET	0x007D
#define T_UTF_16_TILDE	0x007E

#define T_UTF_16_UNDEFINED_007F	0x007F
#define T_UTF_16_UNDEFINED_0080	0x0080
#define T_UTF_16_UNDEFINED_0081	0x0081
#define T_UTF_16_UNDEFINED_0082	0x0082
#define T_UTF_16_UNDEFINED_0083	0x0083
#define T_UTF_16_UNDEFINED_0084	0x0084
#define T_UTF_16_UNDEFINED_0085	0x0085
#define T_UTF_16_UNDEFINED_0086	0x0086
#define T_UTF_16_UNDEFINED_0087	0x0087
#define T_UTF_16_UNDEFINED_0088	0x0088
#define T_UTF_16_UNDEFINED_0089	0x0089
#define T_UTF_16_UNDEFINED_008A	0x008A
#define T_UTF_16_UNDEFINED_008B	0x008B
#define T_UTF_16_UNDEFINED_008C	0x008C
#define T_UTF_16_UNDEFINED_008D	0x008D
#define T_UTF_16_UNDEFINED_008E	0x008E
#define T_UTF_16_UNDEFINED_008F	0x008F
#define T_UTF_16_UNDEFINED_0090	0x0090
#define T_UTF_16_UNDEFINED_0091	0x0091
#define T_UTF_16_UNDEFINED_0092	0x0092
#define T_UTF_16_UNDEFINED_0093	0x0093
#define T_UTF_16_UNDEFINED_0094	0x0094
#define T_UTF_16_UNDEFINED_0095	0x0095
#define T_UTF_16_UNDEFINED_0096	0x0096
#define T_UTF_16_UNDEFINED_0097	0x0097
#define T_UTF_16_UNDEFINED_0098	0x0098
#define T_UTF_16_UNDEFINED_0099	0x0099
#define T_UTF_16_UNDEFINED_009A	0x009A
#define T_UTF_16_UNDEFINED_009B	0x009B
#define T_UTF_16_UNDEFINED_009C	0x009C
#define T_UTF_16_UNDEFINED_009D	0x009D
#define T_UTF_16_UNDEFINED_009E	0x009E
#define T_UTF_16_UNDEFINED_009F	0x009F

#define T_UTF_16_UNDEFINED_00A0	0x00A0
#define T_UTF_16_UNDEFINED_00A1	0x00A1
#define T_UTF_16_UNDEFINED_00A2	0x00A2
#define T_UTF_16_UNDEFINED_00A3	0x00A3
#define T_UTF_16_UNDEFINED_00A4	0x00A4
#define T_UTF_16_UNDEFINED_00A5	0x00A5
#define T_UTF_16_UNDEFINED_00A6	0x00A6
#define T_UTF_16_UNDEFINED_00A7	0x00A7
#define T_UTF_16_UNDEFINED_00A8	0x00A8
#define T_UTF_16_UNDEFINED_00A9	0x00A9
#define T_UTF_16_UNDEFINED_00AA	0x00AA
#define T_UTF_16_UNDEFINED_00AB	0x00AB
#define T_UTF_16_UNDEFINED_00AC	0x00AC
#define T_UTF_16_UNDEFINED_00AD	0x00AD
#define T_UTF_16_UNDEFINED_00AE	0x00AE
#define T_UTF_16_UNDEFINED_00AF	0x00AF
#define T_UTF_16_UNDEFINED_00B0	0x00B0
#define T_UTF_16_UNDEFINED_00B1	0x00B1
#define T_UTF_16_UNDEFINED_00B2	0x00B2
#define T_UTF_16_UNDEFINED_00B3	0x00B3
#define T_UTF_16_UNDEFINED_00B4	0x00B4
#define T_UTF_16_UNDEFINED_00B5	0x00B5
#define T_UTF_16_UNDEFINED_00B6	0x00B6
#define T_UTF_16_UNDEFINED_00B7	0x00B7
#define T_UTF_16_UNDEFINED_00B8	0x00B8
#define T_UTF_16_UNDEFINED_00B9	0x00B9
#define T_UTF_16_UNDEFINED_00BA	0x00BA
#define T_UTF_16_UNDEFINED_00BB	0x00BB
#define T_UTF_16_UNDEFINED_00BC	0x00BC
#define T_UTF_16_UNDEFINED_00BD	0x00BD
#define T_UTF_16_UNDEFINED_00BE	0x00BE
#define T_UTF_16_UNDEFINED_00BF	0x00BF

#define T_UTF_16_UNDEFINED_00C0	0x00C0
#define T_UTF_16_UNDEFINED_00C1	0x00C1
#define T_UTF_16_UNDEFINED_00C2	0x00C2
#define T_UTF_16_UNDEFINED_00C3	0x00C3
#define T_UTF_16_UNDEFINED_00C4	0x00C4
#define T_UTF_16_UNDEFINED_00C5	0x00C5
#define T_UTF_16_UNDEFINED_00C6	0x00C6
#define T_UTF_16_UNDEFINED_00C7	0x00C7
#define T_UTF_16_UNDEFINED_00C8	0x00C8
#define T_UTF_16_UNDEFINED_00C9	0x00C9
#define T_UTF_16_UNDEFINED_00CA	0x00CA
#define T_UTF_16_UNDEFINED_00CB	0x00CB
#define T_UTF_16_UNDEFINED_00CC	0x00CC
#define T_UTF_16_UNDEFINED_00CD	0x00CD
#define T_UTF_16_UNDEFINED_00CE	0x00CE
#define T_UTF_16_UNDEFINED_00CF	0x00CF
#define T_UTF_16_UNDEFINED_00D0	0x00D0
#define T_UTF_16_UNDEFINED_00D1	0x00D1
#define T_UTF_16_UNDEFINED_00D2	0x00D2
#define T_UTF_16_UNDEFINED_00D3	0x00D3
#define T_UTF_16_UNDEFINED_00D4	0x00D4
#define T_UTF_16_UNDEFINED_00D5	0x00D5
#define T_UTF_16_UNDEFINED_00D6	0x00D6
#define T_UTF_16_UNDEFINED_00D7	0x00D7
#define T_UTF_16_UNDEFINED_00D8	0x00D8
#define T_UTF_16_UNDEFINED_00D9	0x00D9
#define T_UTF_16_UNDEFINED_00DA	0x00DA
#define T_UTF_16_UNDEFINED_00DB	0x00DB
#define T_UTF_16_UNDEFINED_00DC	0x00DC
#define T_UTF_16_UNDEFINED_00DD	0x00DD
#define T_UTF_16_UNDEFINED_00DE	0x00DE
#define T_UTF_16_UNDEFINED_00DF	0x00DF

#define T_UTF_16_UNDEFINED_00E0	0x00E0
#define T_UTF_16_UNDEFINED_00E1	0x00E1
#define T_UTF_16_UNDEFINED_00E2	0x00E2
#define T_UTF_16_UNDEFINED_00E3	0x00E3
#define T_UTF_16_UNDEFINED_00E4	0x00E4
#define T_UTF_16_UNDEFINED_00E5	0x00E5
#define T_UTF_16_UNDEFINED_00E6	0x00E6
#define T_UTF_16_UNDEFINED_00E7	0x00E7
#define T_UTF_16_UNDEFINED_00E8	0x00E8
#define T_UTF_16_UNDEFINED_00E9	0x00E9
#define T_UTF_16_UNDEFINED_00EA	0x00EA
#define T_UTF_16_UNDEFINED_00EB	0x00EB
#define T_UTF_16_UNDEFINED_00EC	0x00EC
#define T_UTF_16_UNDEFINED_00ED	0x00ED
#define T_UTF_16_UNDEFINED_00EE	0x00EE
#define T_UTF_16_UNDEFINED_00EF	0x00EF
#define T_UTF_16_UNDEFINED_00F0	0x00F0
#define T_UTF_16_UNDEFINED_00F1	0x00F1
#define T_UTF_16_UNDEFINED_00F2	0x00F2
#define T_UTF_16_UNDEFINED_00F3	0x00F3
#define T_UTF_16_UNDEFINED_00F4	0x00F4
#define T_UTF_16_UNDEFINED_00F5	0x00F5
#define T_UTF_16_UNDEFINED_00F6	0x00F6
#define T_UTF_16_UNDEFINED_00F7	0x00F7
#define T_UTF_16_UNDEFINED_00F8	0x00F8
#define T_UTF_16_UNDEFINED_00F9	0x00F9
#define T_UTF_16_UNDEFINED_00FA	0x00FA
#define T_UTF_16_UNDEFINED_00FB	0x00FB
#define T_UTF_16_UNDEFINED_00FC	0x00FC
#define T_UTF_16_UNDEFINED_00FD	0x00FD
#define T_UTF_16_UNDEFINED_00FE	0x00FE
#define T_UTF_16_UNDEFINED_00FF	0x00FF

#define T_UTF_16_NO_BREAK_SPACE	0x00A0
#define T_UTF_16_INVERTED_EXCLAMATION_MARK	0x00A1
#define T_UTF_16_CENT_SIGN	0x00A2
#define T_UTF_16_POUND_SIGN	0x00A3
#define T_UTF_16_CURRENCY_SIGN	0x00A4
#define T_UTF_16_YEN_SIGN	0x00A5
#define T_UTF_16_BROKEN_BAR	0x00A6
#define T_UTF_16_SECTION_SIGN	0x00A7
#define T_UTF_16_DIAERESIS	0x00A8
#define T_UTF_16_COPYRIGHT_SIGN	0x00A9
#define T_UTF_16_FEMININE_ORDINAL_INDICATOR	0x00AA
#define T_UTF_16_LEFT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK	0x00AB
#define T_UTF_16_NOT_SIGN	0x00AC
#define T_UTF_16_SOFT_HYPHEN	0x00AD
#define T_UTF_16_REGISTERED_SIGN	0x00AE
#define T_UTF_16_MACRON	0x00AF
#define T_UTF_16_DEGREE_SIGN	0x00B0
#define T_UTF_16_PLUS_MINUS_SIGN	0x00B1
#define T_UTF_16_SUPERSCRIPT_TWO	0x00B2
#define T_UTF_16_SUPERSCRIPT_THREE	0x00B3
#define T_UTF_16_ACUTE_ACCENT	0x00B4
#define T_UTF_16_MICRO_SIGN	0x00B5
#define T_UTF_16_PILCROW_SIGN	0x00B6
#define T_UTF_16_MIDDLE_DOT	0x00B7
#define T_UTF_16_CEDILLA	0x00B8
#define T_UTF_16_SUPERSCRIPT_ONE	0x00B9
#define T_UTF_16_MASCULINE_ORDINAL_INDICATOR	0x00BA
#define T_UTF_16_RIGHT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK	0x00BB
#define T_UTF_16_VULGAR_FRACTION_ONE_QUARTER	0x00BC
#define T_UTF_16_VULGAR_FRACTION_ONE_HALF	0x00BD
#define T_UTF_16_VULGAR_FRACTION_THREE_QUARTERS	0x00BE
#define T_UTF_16_INVERTED_QUESTION_MARK	0x00BF
#define T_UTF_16_LATIN_CAPITAL_LETTER_A_WITH_GRAVE	0x00C0
#define T_UTF_16_LATIN_CAPITAL_LETTER_A_WITH_ACUTE	0x00C1
#define T_UTF_16_LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX	0x00C2
#define T_UTF_16_LATIN_CAPITAL_LETTER_A_WITH_TILDE	0x00C3
#define T_UTF_16_LATIN_CAPITAL_LETTER_A_WITH_DIAERESIS	0x00C4
#define T_UTF_16_LATIN_CAPITAL_LETTER_A_WITH_RING_ABOVE	0x00C5
#define T_UTF_16_LATIN_CAPITAL_LETTER_AE	0x00C6
#define T_UTF_16_LATIN_CAPITAL_LETTER_C_WITH_CEDILLA	0x00C7
#define T_UTF_16_LATIN_CAPITAL_LETTER_E_WITH_GRAVE	0x00C8
#define T_UTF_16_LATIN_CAPITAL_LETTER_E_WITH_ACUTE	0x00C9
#define T_UTF_16_LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX	0x00CA
#define T_UTF_16_LATIN_CAPITAL_LETTER_E_WITH_DIAERESIS	0x00CB
#define T_UTF_16_LATIN_CAPITAL_LETTER_I_WITH_GRAVE	0x00CC
#define T_UTF_16_LATIN_CAPITAL_LETTER_I_WITH_ACUTE	0x00CD
#define T_UTF_16_LATIN_CAPITAL_LETTER_I_WITH_CIRCUMFLEX	0x00CE
#define T_UTF_16_LATIN_CAPITAL_LETTER_I_WITH_DIAERESIS	0x00CF
#define T_UTF_16_LATIN_CAPITAL_LETTER_ETH	0x00D0
#define T_UTF_16_LATIN_CAPITAL_LETTER_N_WITH_TILDE	0x00D1
#define T_UTF_16_LATIN_CAPITAL_LETTER_O_WITH_GRAVE	0x00D2
#define T_UTF_16_LATIN_CAPITAL_LETTER_O_WITH_ACUTE	0x00D3
#define T_UTF_16_LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX	0x00D4
#define T_UTF_16_LATIN_CAPITAL_LETTER_O_WITH_TILDE	0x00D5
#define T_UTF_16_LATIN_CAPITAL_LETTER_O_WITH_DIAERESIS	0x00D6
#define T_UTF_16_MULTIPLICATION_SIGN	0x00D7
#define T_UTF_16_LATIN_CAPITAL_LETTER_O_WITH_STROKE	0x00D8
#define T_UTF_16_LATIN_CAPITAL_LETTER_U_WITH_GRAVE	0x00D9
#define T_UTF_16_LATIN_CAPITAL_LETTER_U_WITH_ACUTE	0x00DA
#define T_UTF_16_LATIN_CAPITAL_LETTER_U_WITH_CIRCUMFLEX	0x00DB
#define T_UTF_16_LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS	0x00DC
#define T_UTF_16_LATIN_CAPITAL_LETTER_Y_WITH_ACUTE	0x00DD
#define T_UTF_16_LATIN_CAPITAL_LETTER_THORN	0x00DE
#define T_UTF_16_LATIN_SMALL_LETTER_SHARP_S	0x00DF
#define T_UTF_16_LATIN_SMALL_LETTER_A_WITH_GRAVE	0x00E0
#define T_UTF_16_LATIN_SMALL_LETTER_A_WITH_ACUTE	0x00E1
#define T_UTF_16_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX	0x00E2
#define T_UTF_16_LATIN_SMALL_LETTER_A_WITH_TILDE	0x00E3
#define T_UTF_16_LATIN_SMALL_LETTER_A_WITH_DIAERESIS	0x00E4
#define T_UTF_16_LATIN_SMALL_LETTER_A_WITH_RING_ABOVE	0x00E5
#define T_UTF_16_LATIN_SMALL_LETTER_AE	0x00E6
#define T_UTF_16_LATIN_SMALL_LETTER_C_WITH_CEDILLA	0x00E7
#define T_UTF_16_LATIN_SMALL_LETTER_E_WITH_GRAVE	0x00E8
#define T_UTF_16_LATIN_SMALL_LETTER_E_WITH_ACUTE	0x00E9
#define T_UTF_16_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX	0x00EA
#define T_UTF_16_LATIN_SMALL_LETTER_E_WITH_DIAERESIS	0x00EB
#define T_UTF_16_LATIN_SMALL_LETTER_I_WITH_GRAVE	0x00EC
#define T_UTF_16_LATIN_SMALL_LETTER_I_WITH_ACUTE	0x00ED
#define T_UTF_16_LATIN_SMALL_LETTER_I_WITH_CIRCUMFLEX	0x00EE
#define T_UTF_16_LATIN_SMALL_LETTER_I_WITH_DIAERESIS	0x00EF
#define T_UTF_16_LATIN_SMALL_LETTER_ETH	0x00F0
#define T_UTF_16_LATIN_SMALL_LETTER_N_WITH_TILDE	0x00F1
#define T_UTF_16_LATIN_SMALL_LETTER_O_WITH_GRAVE	0x00F2
#define T_UTF_16_LATIN_SMALL_LETTER_O_WITH_ACUTE	0x00F3
#define T_UTF_16_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX	0x00F4
#define T_UTF_16_LATIN_SMALL_LETTER_O_WITH_TILDE	0x00F5
#define T_UTF_16_LATIN_SMALL_LETTER_O_WITH_DIAERESIS	0x00F6
#define T_UTF_16_DIVISION_SIGN	0x00F7
#define T_UTF_16_LATIN_SMALL_LETTER_O_WITH_STROKE	0x00F8
#define T_UTF_16_LATIN_SMALL_LETTER_U_WITH_GRAVE	0x00F9
#define T_UTF_16_LATIN_SMALL_LETTER_U_WITH_ACUTE	0x00FA
#define T_UTF_16_LATIN_SMALL_LETTER_U_WITH_CIRCUMFLEX	0x00FB
#define T_UTF_16_LATIN_SMALL_LETTER_U_WITH_DIAERESIS	0x00FC
#define T_UTF_16_LATIN_SMALL_LETTER_Y_WITH_ACUTE	0x00FD
#define T_UTF_16_LATIN_SMALL_LETTER_THORN	0x00FE
#define T_UTF_16_LATIN_SMALL_LETTER_Y_WITH_DIAERESIS	0x00FF

#define T_UTF_16_LATIN_CAPITAL_LETTER_A_WITH_MACRON	0x0100
#define T_UTF_16_LATIN_SMALL_LETTER_A_WITH_MACRON	0x0101
#define T_UTF_16_LATIN_CAPITAL_LETTER_A_WITH_BREVE	0x0102
#define T_UTF_16_LATIN_SMALL_LETTER_A_WITH_BREVE	0x0103
#define T_UTF_16_LATIN_CAPITAL_LETTER_A_WITH_OGONEK	0x0104
#define T_UTF_16_LATIN_SMALL_LETTER_A_WITH_OGONEK	0x0105
#define T_UTF_16_LATIN_CAPITAL_LETTER_C_WITH_ACUTE	0x0106
#define T_UTF_16_LATIN_SMALL_LETTER_C_WITH_ACUTE	0x0107
#define T_UTF_16_LATIN_CAPITAL_LETTER_C_WITH_CIRCUMFLEX	0x0108
#define T_UTF_16_LATIN_SMALL_LETTER_C_WITH_CIRCUMFLEX	0x0109
#define T_UTF_16_LATIN_CAPITAL_LETTER_C_WITH_DOT_ABOVE	0x010A
#define T_UTF_16_LATIN_SMALL_LETTER_C_WITH_DOT_ABOVE	0x010B
#define T_UTF_16_LATIN_CAPITAL_LETTER_C_WITH_CARON	0x010C
#define T_UTF_16_LATIN_SMALL_LETTER_C_WITH_CARON	0x010D
#define T_UTF_16_LATIN_CAPITAL_LETTER_D_WITH_CARON	0x010E
#define T_UTF_16_LATIN_SMALL_LETTER_D_WITH_CARON	0x010F
#define T_UTF_16_LATIN_CAPITAL_LETTER_D_WITH_STROKE	0x0110
#define T_UTF_16_LATIN_SMALL_LETTER_D_WITH_STROKE	0x0111
#define T_UTF_16_LATIN_CAPITAL_LETTER_E_WITH_MACRON	0x0112
#define T_UTF_16_LATIN_SMALL_LETTER_E_WITH_MACRON	0x0113
#define T_UTF_16_LATIN_CAPITAL_LETTER_E_WITH_BREVE	0x0114
#define T_UTF_16_LATIN_SMALL_LETTER_E_WITH_BREVE	0x0115
#define T_UTF_16_LATIN_CAPITAL_LETTER_E_WITH_DOT_ABOVE	0x0116
#define T_UTF_16_LATIN_SMALL_LETTER_E_WITH_DOT_ABOVE	0x0117
#define T_UTF_16_LATIN_CAPITAL_LETTER_E_WITH_OGONEK	0x0118
#define T_UTF_16_LATIN_SMALL_LETTER_E_WITH_OGONEK	0x0119
#define T_UTF_16_LATIN_CAPITAL_LETTER_E_WITH_CARON	0x011A
#define T_UTF_16_LATIN_SMALL_LETTER_E_WITH_CARON	0x011B
#define T_UTF_16_LATIN_CAPITAL_LETTER_G_WITH_CIRCUMFLEX	0x011C
#define T_UTF_16_LATIN_SMALL_LETTER_G_WITH_CIRCUMFLEX	0x011D
#define T_UTF_16_LATIN_CAPITAL_LETTER_G_WITH_BREVE	0x011E
#define T_UTF_16_LATIN_SMALL_LETTER_G_WITH_BREVE	0x011F
#define T_UTF_16_LATIN_CAPITAL_LETTER_G_WITH_DOT_ABOVE	0x0120
#define T_UTF_16_LATIN_SMALL_LETTER_G_WITH_DOT_ABOVE	0x0121
#define T_UTF_16_LATIN_CAPITAL_LETTER_G_WITH_CEDILLA	0x0122
#define T_UTF_16_LATIN_SMALL_LETTER_G_WITH_CEDILLA	0x0123
#define T_UTF_16_LATIN_CAPITAL_LETTER_H_WITH_CIRCUMFLEX	0x0124
#define T_UTF_16_LATIN_SMALL_LETTER_H_WITH_CIRCUMFLEX	0x0125
#define T_UTF_16_LATIN_CAPITAL_LETTER_H_WITH_STROKE	0x0126
#define T_UTF_16_LATIN_SMALL_LETTER_H_WITH_STROKE	0x0127
#define T_UTF_16_LATIN_CAPITAL_LETTER_I_WITH_TILDE	0x0128
#define T_UTF_16_LATIN_SMALL_LETTER_I_WITH_TILDE	0x0129
#define T_UTF_16_LATIN_CAPITAL_LETTER_I_WITH_MACRON	0x012A
#define T_UTF_16_LATIN_SMALL_LETTER_I_WITH_MACRON	0x012B
#define T_UTF_16_LATIN_CAPITAL_LETTER_I_WITH_BREVE	0x012C
#define T_UTF_16_LATIN_SMALL_LETTER_I_WITH_BREVE	0x012D
#define T_UTF_16_LATIN_CAPITAL_LETTER_I_WITH_OGONEK	0x012E
#define T_UTF_16_LATIN_SMALL_LETTER_I_WITH_OGONEK	0x012F
#define T_UTF_16_LATIN_CAPITAL_LETTER_I_WITH_DOT_ABOVE	0x0130
#define T_UTF_16_LATIN_SMALL_LETTER_DOTLESS_I	0x0131
#define T_UTF_16_LATIN_CAPITAL_LIGATURE_IJ	0x0132
#define T_UTF_16_LATIN_SMALL_LIGATURE_IJ	0x0133
#define T_UTF_16_LATIN_CAPITAL_LETTER_J_WITH_CIRCUMFLEX	0x0134
#define T_UTF_16_LATIN_SMALL_LETTER_J_WITH_CIRCUMFLEX	0x0135
#define T_UTF_16_LATIN_CAPITAL_LETTER_K_WITH_CEDILLA	0x0136
#define T_UTF_16_LATIN_SMALL_LETTER_K_WITH_CEDILLA	0x0137
#define T_UTF_16_LATIN_SMALL_LETTER_KRA	0x0138
#define T_UTF_16_LATIN_CAPITAL_LETTER_L_WITH_ACUTE	0x0139
#define T_UTF_16_LATIN_SMALL_LETTER_L_WITH_ACUTE	0x013A
#define T_UTF_16_LATIN_CAPITAL_LETTER_L_WITH_CEDILLA	0x013B
#define T_UTF_16_LATIN_SMALL_LETTER_L_WITH_CEDILLA	0x013C
#define T_UTF_16_LATIN_CAPITAL_LETTER_L_WITH_CARON	0x013D
#define T_UTF_16_LATIN_SMALL_LETTER_L_WITH_CARON	0x013E
#define T_UTF_16_LATIN_CAPITAL_LETTER_L_WITH_MIDDLE_DOT	0x013F
#define T_UTF_16_LATIN_SMALL_LETTER_L_WITH_MIDDLE_DOT	0x0140
#define T_UTF_16_LATIN_CAPITAL_LETTER_L_WITH_STROKE	0x0141
#define T_UTF_16_LATIN_SMALL_LETTER_L_WITH_STROKE	0x0142
#define T_UTF_16_LATIN_CAPITAL_LETTER_N_WITH_ACUTE	0x0143
#define T_UTF_16_LATIN_SMALL_LETTER_N_WITH_ACUTE	0x0144
#define T_UTF_16_LATIN_CAPITAL_LETTER_N_WITH_CEDILLA	0x0145
#define T_UTF_16_LATIN_SMALL_LETTER_N_WITH_CEDILLA	0x0146
#define T_UTF_16_LATIN_CAPITAL_LETTER_N_WITH_CARON	0x0147
#define T_UTF_16_LATIN_SMALL_LETTER_N_WITH_CARON	0x0148
#define T_UTF_16_LATIN_SMALL_LETTER_N_PRECEDED_BY_APOSTROPHE	0x0149
#define T_UTF_16_LATIN_CAPITAL_LETTER_ENG	0x014A
#define T_UTF_16_LATIN_SMALL_LETTER_ENG	0x014B
#define T_UTF_16_LATIN_CAPITAL_LETTER_O_WITH_MACRON	0x014C
#define T_UTF_16_LATIN_SMALL_LETTER_O_WITH_MACRON	0x014D
#define T_UTF_16_LATIN_CAPITAL_LETTER_O_WITH_BREVE	0x014E
#define T_UTF_16_LATIN_SMALL_LETTER_O_WITH_BREVE	0x014F
#define T_UTF_16_LATIN_CAPITAL_LETTER_O_WITH_DOUBLE_ACUTE	0x0150
#define T_UTF_16_LATIN_SMALL_LETTER_O_WITH_DOUBLE_ACUTE	0x0151
#define T_UTF_16_LATIN_CAPITAL_LIGATURE_OE	0x0152
#define T_UTF_16_LATIN_SMALL_LIGATURE_OE	0x0153
#define T_UTF_16_LATIN_CAPITAL_LETTER_R_WITH_ACUTE	0x0154
#define T_UTF_16_LATIN_SMALL_LETTER_R_WITH_ACUTE	0x0155
#define T_UTF_16_LATIN_CAPITAL_LETTER_R_WITH_CEDILLA	0x0156
#define T_UTF_16_LATIN_SMALL_LETTER_R_WITH_CEDILLA	0x0157
#define T_UTF_16_LATIN_CAPITAL_LETTER_R_WITH_CARON	0x0158
#define T_UTF_16_LATIN_SMALL_LETTER_R_WITH_CARON	0x0159
#define T_UTF_16_LATIN_CAPITAL_LETTER_S_WITH_ACUTE	0x015A
#define T_UTF_16_LATIN_SMALL_LETTER_S_WITH_ACUTE	0x015B
#define T_UTF_16_LATIN_CAPITAL_LETTER_S_WITH_CIRCUMFLEX	0x015C
#define T_UTF_16_LATIN_SMALL_LETTER_S_WITH_CIRCUMFLEX	0x015D
#define T_UTF_16_LATIN_CAPITAL_LETTER_S_WITH_CEDILLA	0x015E
#define T_UTF_16_LATIN_SMALL_LETTER_S_WITH_CEDILLA	0x015F
#define T_UTF_16_LATIN_CAPITAL_LETTER_S_WITH_CARON	0x0160
#define T_UTF_16_LATIN_SMALL_LETTER_S_WITH_CARON	0x0161
#define T_UTF_16_LATIN_CAPITAL_LETTER_T_WITH_CEDILLA	0x0162
#define T_UTF_16_LATIN_SMALL_LETTER_T_WITH_CEDILLA	0x0163
#define T_UTF_16_LATIN_CAPITAL_LETTER_T_WITH_CARON	0x0164
#define T_UTF_16_LATIN_SMALL_LETTER_T_WITH_CARON	0x0165
#define T_UTF_16_LATIN_CAPITAL_LETTER_T_WITH_STROKE	0x0166
#define T_UTF_16_LATIN_SMALL_LETTER_T_WITH_STROKE	0x0167
#define T_UTF_16_LATIN_CAPITAL_LETTER_U_WITH_TILDE	0x0168
#define T_UTF_16_LATIN_SMALL_LETTER_U_WITH_TILDE	0x0169
#define T_UTF_16_LATIN_CAPITAL_LETTER_U_WITH_MACRON	0x016A
#define T_UTF_16_LATIN_SMALL_LETTER_U_WITH_MACRON	0x016B
#define T_UTF_16_LATIN_CAPITAL_LETTER_U_WITH_BREVE	0x016C
#define T_UTF_16_LATIN_SMALL_LETTER_U_WITH_BREVE	0x016D
#define T_UTF_16_LATIN_CAPITAL_LETTER_U_WITH_RING_ABOVE	0x016E
#define T_UTF_16_LATIN_SMALL_LETTER_U_WITH_RING_ABOVE	0x016F
#define T_UTF_16_LATIN_CAPITAL_LETTER_U_WITH_DOUBLE_ACUTE	0x0170
#define T_UTF_16_LATIN_SMALL_LETTER_U_WITH_DOUBLE_ACUTE	0x0171
#define T_UTF_16_LATIN_CAPITAL_LETTER_U_WITH_OGONEK	0x0172
#define T_UTF_16_LATIN_SMALL_LETTER_U_WITH_OGONEK	0x0173
#define T_UTF_16_LATIN_CAPITAL_LETTER_W_WITH_CIRCUMFLEX	0x0174
#define T_UTF_16_LATIN_SMALL_LETTER_W_WITH_CIRCUMFLEX	0x0175
#define T_UTF_16_LATIN_CAPITAL_LETTER_Y_WITH_CIRCUMFLEX	0x0176
#define T_UTF_16_LATIN_SMALL_LETTER_Y_WITH_CIRCUMFLEX	0x0177
#define T_UTF_16_LATIN_CAPITAL_LETTER_Y_WITH_DIAERESIS	0x0178
#define T_UTF_16_LATIN_CAPITAL_LETTER_Z_WITH_ACUTE	0x0179
#define T_UTF_16_LATIN_SMALL_LETTER_Z_WITH_ACUTE	0x017A
#define T_UTF_16_LATIN_CAPITAL_LETTER_Z_WITH_DOT_ABOVE	0x017B
#define T_UTF_16_LATIN_SMALL_LETTER_Z_WITH_DOT_ABOVE	0x017C
#define T_UTF_16_LATIN_CAPITAL_LETTER_Z_WITH_CARON	0x017D
#define T_UTF_16_LATIN_SMALL_LETTER_Z_WITH_CARON	0x017E
#define T_UTF_16_LATIN_SMALL_LETTER_LONG_S	0x017F
#define T_UTF_16_LATIN_SMALL_LETTER_B_WITH_STROKE	0x0180
#define T_UTF_16_LATIN_CAPITAL_LETTER_B_WITH_HOOK	0x0181
#define T_UTF_16_LATIN_CAPITAL_LETTER_B_WITH_TOPBAR	0x0182
#define T_UTF_16_LATIN_SMALL_LETTER_B_WITH_TOPBAR	0x0183
#define T_UTF_16_LATIN_CAPITAL_LETTER_TONE_SIX	0x0184
#define T_UTF_16_LATIN_SMALL_LETTER_TONE_SIX	0x0185
#define T_UTF_16_LATIN_CAPITAL_LETTER_OPEN_O	0x0186
#define T_UTF_16_LATIN_CAPITAL_LETTER_C_WITH_HOOK	0x0187
#define T_UTF_16_LATIN_SMALL_LETTER_C_WITH_HOOK	0x0188
#define T_UTF_16_LATIN_CAPITAL_LETTER_AFRICAN_D	0x0189
#define T_UTF_16_LATIN_CAPITAL_LETTER_D_WITH_HOOK	0x018A
#define T_UTF_16_LATIN_CAPITAL_LETTER_D_WITH_TOPBAR	0x018B
#define T_UTF_16_LATIN_SMALL_LETTER_D_WITH_TOPBAR	0x018C
#define T_UTF_16_LATIN_SMALL_LETTER_TURNED_DELTA	0x018D
#define T_UTF_16_LATIN_CAPITAL_LETTER_REVERSED_E	0x018E
#define T_UTF_16_LATIN_CAPITAL_LETTER_SCHWA	0x018F
#define T_UTF_16_LATIN_CAPITAL_LETTER_OPEN_E	0x0190
#define T_UTF_16_LATIN_CAPITAL_LETTER_F_WITH_HOOK	0x0191
#define T_UTF_16_LATIN_SMALL_LETTER_F_WITH_HOOK	0x0192
#define T_UTF_16_LATIN_CAPITAL_LETTER_G_WITH_HOOK	0x0193
#define T_UTF_16_LATIN_CAPITAL_LETTER_GAMMA	0x0194
#define T_UTF_16_LATIN_SMALL_LETTER_HV	0x0195
#define T_UTF_16_LATIN_CAPITAL_LETTER_IOTA	0x0196
#define T_UTF_16_LATIN_CAPITAL_LETTER_I_WITH_STROKE	0x0197
#define T_UTF_16_LATIN_CAPITAL_LETTER_K_WITH_HOOK	0x0198
#define T_UTF_16_LATIN_SMALL_LETTER_K_WITH_HOOK	0x0199
#define T_UTF_16_LATIN_SMALL_LETTER_L_WITH_BAR	0x019A
#define T_UTF_16_LATIN_SMALL_LETTER_LAMBDA_WITH_STROKE	0x019B
#define T_UTF_16_LATIN_CAPITAL_LETTER_TURNED_M	0x019C
#define T_UTF_16_LATIN_CAPITAL_LETTER_N_WITH_LEFT_HOOK	0x019D
#define T_UTF_16_LATIN_SMALL_LETTER_N_WITH_LONG_RIGHT_LEG	0x019E
#define T_UTF_16_LATIN_CAPITAL_LETTER_O_WITH_MIDDLE_TILDE	0x019F
#define T_UTF_16_LATIN_CAPITAL_LETTER_O_WITH_HORN	0x01A0
#define T_UTF_16_LATIN_SMALL_LETTER_O_WITH_HORN	0x01A1
#define T_UTF_16_LATIN_CAPITAL_LETTER_OI	0x01A2
#define T_UTF_16_LATIN_SMALL_LETTER_OI	0x01A3
#define T_UTF_16_LATIN_CAPITAL_LETTER_P_WITH_HOOK	0x01A4
#define T_UTF_16_LATIN_SMALL_LETTER_P_WITH_HOOK	0x01A5
#define T_UTF_16_LATIN_LETTER_YR	0x01A6
#define T_UTF_16_LATIN_CAPITAL_LETTER_TONE_TWO	0x01A7
#define T_UTF_16_LATIN_SMALL_LETTER_TONE_TWO	0x01A8
#define T_UTF_16_LATIN_CAPITAL_LETTER_ESH	0x01A9
#define T_UTF_16_LATIN_LETTER_REVERSED_ESH_LOOP	0x01AA
#define T_UTF_16_LATIN_SMALL_LETTER_T_WITH_PALATAL_HOOK	0x01AB
#define T_UTF_16_LATIN_CAPITAL_LETTER_T_WITH_HOOK	0x01AC
#define T_UTF_16_LATIN_SMALL_LETTER_T_WITH_HOOK	0x01AD
#define T_UTF_16_LATIN_CAPITAL_LETTER_T_WITH_RETROFLEX_HOOK	0x01AE
#define T_UTF_16_LATIN_CAPITAL_LETTER_U_WITH_HORN	0x01AF
#define T_UTF_16_LATIN_SMALL_LETTER_U_WITH_HORN	0x01B0
#define T_UTF_16_LATIN_CAPITAL_LETTER_UPSILON	0x01B1
#define T_UTF_16_LATIN_CAPITAL_LETTER_V_WITH_HOOK	0x01B2
#define T_UTF_16_LATIN_CAPITAL_LETTER_Y_WITH_HOOK	0x01B3
#define T_UTF_16_LATIN_SMALL_LETTER_Y_WITH_HOOK	0x01B4
#define T_UTF_16_LATIN_CAPITAL_LETTER_Z_WITH_STROKE	0x01B5
#define T_UTF_16_LATIN_SMALL_LETTER_Z_WITH_STROKE	0x01B6
#define T_UTF_16_LATIN_CAPITAL_LETTER_EZH	0x01B7
#define T_UTF_16_LATIN_CAPITAL_LETTER_EZH_REVERSED	0x01B8
#define T_UTF_16_LATIN_SMALL_LETTER_EZH_REVERSED	0x01B9
#define T_UTF_16_LATIN_SMALL_LETTER_EZH_WITH_TAIL	0x01BA
#define T_UTF_16_LATIN_LETTER_TWO_WITH_STROKE	0x01BB
#define T_UTF_16_LATIN_CAPITAL_LETTER_TONE_FIVE	0x01BC
#define T_UTF_16_LATIN_SMALL_LETTER_TONE_FIVE	0x01BD
#define T_UTF_16_LATIN_LETTER_INVERTED_GLOTTAL_STOP_WITH_STROKE	0x01BE
#define T_UTF_16_LATIN_LETTER_WYNN	0x01BF
#define T_UTF_16_LATIN_LETTER_DENTAL_CLICK	0x01C0
#define T_UTF_16_LATIN_LETTER_LATERAL_CLICK	0x01C1
#define T_UTF_16_LATIN_LETTER_ALVEOLAR_CLICK	0x01C2
#define T_UTF_16_LATIN_LETTER_RETROFLEX_CLICK	0x01C3
#define T_UTF_16_LATIN_CAPITAL_LETTER_DZ_WITH_CARON	0x01C4
#define T_UTF_16_LATIN_CAPITAL_LETTER_D_WITH_SMALL_LETTER_Z_WITH_CARON	0x01C5
#define T_UTF_16_LATIN_SMALL_LETTER_DZ_WITH_CARON	0x01C6
#define T_UTF_16_LATIN_CAPITAL_LETTER_LJ	0x01C7
#define T_UTF_16_LATIN_CAPITAL_LETTER_L_WITH_SMALL_LETTER_J	0x01C8
#define T_UTF_16_LATIN_SMALL_LETTER_LJ	0x01C9
#define T_UTF_16_LATIN_CAPITAL_LETTER_NJ	0x01CA
#define T_UTF_16_LATIN_CAPITAL_LETTER_N_WITH_SMALL_LETTER_J	0x01CB
#define T_UTF_16_LATIN_SMALL_LETTER_NJ	0x01CC
#define T_UTF_16_LATIN_CAPITAL_LETTER_A_WITH_CARON	0x01CD
#define T_UTF_16_LATIN_SMALL_LETTER_A_WITH_CARON	0x01CE
#define T_UTF_16_LATIN_CAPITAL_LETTER_I_WITH_CARON	0x01CF
#define T_UTF_16_LATIN_SMALL_LETTER_I_WITH_CARON	0x01D0
#define T_UTF_16_LATIN_CAPITAL_LETTER_O_WITH_CARON	0x01D1
#define T_UTF_16_LATIN_SMALL_LETTER_O_WITH_CARON	0x01D2
#define T_UTF_16_LATIN_CAPITAL_LETTER_U_WITH_CARON	0x01D3
#define T_UTF_16_LATIN_SMALL_LETTER_U_WITH_CARON	0x01D4
#define T_UTF_16_LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS_AND_MACRON	0x01D5
#define T_UTF_16_LATIN_SMALL_LETTER_U_WITH_DIAERESIS_AND_MACRON	0x01D6
#define T_UTF_16_LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS_AND_ACUTE	0x01D7
#define T_UTF_16_LATIN_SMALL_LETTER_U_WITH_DIAERESIS_AND_ACUTE	0x01D8
#define T_UTF_16_LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS_AND_CARON	0x01D9
#define T_UTF_16_LATIN_SMALL_LETTER_U_WITH_DIAERESIS_AND_CARON	0x01DA
#define T_UTF_16_LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS_AND_GRAVE	0x01DB
#define T_UTF_16_LATIN_SMALL_LETTER_U_WITH_DIAERESIS_AND_GRAVE	0x01DC
#define T_UTF_16_LATIN_SMALL_LETTER_TURNED_E	0x01DD
#define T_UTF_16_LATIN_CAPITAL_LETTER_A_WITH_DIAERESIS_AND_MACRON	0x01DE
#define T_UTF_16_LATIN_SMALL_LETTER_A_WITH_DIAERESIS_AND_MACRON	0x01DF
#define T_UTF_16_LATIN_CAPITAL_LETTER_A_WITH_DOT_ABOVE_AND_MACRON	0x01E0
#define T_UTF_16_LATIN_SMALL_LETTER_A_WITH_DOT_ABOVE_AND_MACRON	0x01E1
#define T_UTF_16_LATIN_CAPITAL_LETTER_AE_WITH_MACRON	0x01E2
#define T_UTF_16_LATIN_SMALL_LETTER_AE_WITH_MACRON	0x01E3
#define T_UTF_16_LATIN_CAPITAL_LETTER_G_WITH_STROKE	0x01E4
#define T_UTF_16_LATIN_SMALL_LETTER_G_WITH_STROKE	0x01E5
#define T_UTF_16_LATIN_CAPITAL_LETTER_G_WITH_CARON	0x01E6
#define T_UTF_16_LATIN_SMALL_LETTER_G_WITH_CARON	0x01E7
#define T_UTF_16_LATIN_CAPITAL_LETTER_K_WITH_CARON	0x01E8
#define T_UTF_16_LATIN_SMALL_LETTER_K_WITH_CARON	0x01E9
#define T_UTF_16_LATIN_CAPITAL_LETTER_O_WITH_OGONEK	0x01EA
#define T_UTF_16_LATIN_SMALL_LETTER_O_WITH_OGONEK	0x01EB
#define T_UTF_16_LATIN_CAPITAL_LETTER_O_WITH_OGONEK_AND_MACRON	0x01EC
#define T_UTF_16_LATIN_SMALL_LETTER_O_WITH_OGONEK_AND_MACRON	0x01ED
#define T_UTF_16_LATIN_CAPITAL_LETTER_EZH_WITH_CARON	0x01EE
#define T_UTF_16_LATIN_SMALL_LETTER_EZH_WITH_CARON	0x01EF
#define T_UTF_16_LATIN_SMALL_LETTER_J_WITH_CARON	0x01F0
#define T_UTF_16_LATIN_CAPITAL_LETTER_DZ	0x01F1
#define T_UTF_16_LATIN_CAPITAL_LETTER_D_WITH_SMALL_LETTER_Z	0x01F2
#define T_UTF_16_LATIN_SMALL_LETTER_DZ	0x01F3
#define T_UTF_16_LATIN_CAPITAL_LETTER_G_WITH_ACUTE	0x01F4
#define T_UTF_16_LATIN_SMALL_LETTER_G_WITH_ACUTE	0x01F5
#define T_UTF_16_LATIN_CAPITAL_LETTER_HWAIR	0x01F6
#define T_UTF_16_LATIN_CAPITAL_LETTER_WYNN	0x01F7
#define T_UTF_16_LATIN_CAPITAL_LETTER_N_WITH_GRAVE	0x01F8
#define T_UTF_16_LATIN_SMALL_LETTER_N_WITH_GRAVE	0x01F9
#define T_UTF_16_LATIN_CAPITAL_LETTER_A_WITH_RING_ABOVE_AND_ACUTE	0x01FA
#define T_UTF_16_LATIN_SMALL_LETTER_A_WITH_RING_ABOVE_AND_ACUTE	0x01FB
#define T_UTF_16_LATIN_CAPITAL_LETTER_AE_WITH_ACUTE	0x01FC
#define T_UTF_16_LATIN_SMALL_LETTER_AE_WITH_ACUTE	0x01FD
#define T_UTF_16_LATIN_CAPITAL_LETTER_O_WITH_STROKE_AND_ACUTE	0x01FE
#define T_UTF_16_LATIN_SMALL_LETTER_O_WITH_STROKE_AND_ACUTE	0x01FF
#define T_UTF_16_LATIN_CAPITAL_LETTER_A_WITH_DOUBLE_GRAVE	0x0200
#define T_UTF_16_LATIN_SMALL_LETTER_A_WITH_DOUBLE_GRAVE	0x0201
#define T_UTF_16_LATIN_CAPITAL_LETTER_A_WITH_INVERTED_BREVE	0x0202
#define T_UTF_16_LATIN_SMALL_LETTER_A_WITH_INVERTED_BREVE	0x0203
#define T_UTF_16_LATIN_CAPITAL_LETTER_E_WITH_DOUBLE_GRAVE	0x0204
#define T_UTF_16_LATIN_SMALL_LETTER_E_WITH_DOUBLE_GRAVE	0x0205
#define T_UTF_16_LATIN_CAPITAL_LETTER_E_WITH_INVERTED_BREVE	0x0206
#define T_UTF_16_LATIN_SMALL_LETTER_E_WITH_INVERTED_BREVE	0x0207
#define T_UTF_16_LATIN_CAPITAL_LETTER_I_WITH_DOUBLE_GRAVE	0x0208
#define T_UTF_16_LATIN_SMALL_LETTER_I_WITH_DOUBLE_GRAVE	0x0209
#define T_UTF_16_LATIN_CAPITAL_LETTER_I_WITH_INVERTED_BREVE	0x020A
#define T_UTF_16_LATIN_SMALL_LETTER_I_WITH_INVERTED_BREVE	0x020B
#define T_UTF_16_LATIN_CAPITAL_LETTER_O_WITH_DOUBLE_GRAVE	0x020C
#define T_UTF_16_LATIN_SMALL_LETTER_O_WITH_DOUBLE_GRAVE	0x020D
#define T_UTF_16_LATIN_CAPITAL_LETTER_O_WITH_INVERTED_BREVE	0x020E
#define T_UTF_16_LATIN_SMALL_LETTER_O_WITH_INVERTED_BREVE	0x020F
#define T_UTF_16_LATIN_CAPITAL_LETTER_R_WITH_DOUBLE_GRAVE	0x0210
#define T_UTF_16_LATIN_SMALL_LETTER_R_WITH_DOUBLE_GRAVE	0x0211
#define T_UTF_16_LATIN_CAPITAL_LETTER_R_WITH_INVERTED_BREVE	0x0212
#define T_UTF_16_LATIN_SMALL_LETTER_R_WITH_INVERTED_BREVE	0x0213
#define T_UTF_16_LATIN_CAPITAL_LETTER_U_WITH_DOUBLE_GRAVE	0x0214
#define T_UTF_16_LATIN_SMALL_LETTER_U_WITH_DOUBLE_GRAVE	0x0215
#define T_UTF_16_LATIN_CAPITAL_LETTER_U_WITH_INVERTED_BREVE	0x0216
#define T_UTF_16_LATIN_SMALL_LETTER_U_WITH_INVERTED_BREVE	0x0217
#define T_UTF_16_LATIN_CAPITAL_LETTER_S_WITH_COMMA_BELOW	0x0218
#define T_UTF_16_LATIN_SMALL_LETTER_S_WITH_COMMA_BELOW	0x0219
#define T_UTF_16_LATIN_CAPITAL_LETTER_T_WITH_COMMA_BELOW	0x021A
#define T_UTF_16_LATIN_SMALL_LETTER_T_WITH_COMMA_BELOW	0x021B
#define T_UTF_16_LATIN_CAPITAL_LETTER_YOGH	0x021C
#define T_UTF_16_LATIN_SMALL_LETTER_YOGH	0x021D
#define T_UTF_16_LATIN_CAPITAL_LETTER_H_WITH_CARON	0x021E
#define T_UTF_16_LATIN_SMALL_LETTER_H_WITH_CARON	0x021F
#define T_UTF_16_LATIN_CAPITAL_LETTER_OU	0x0222
#define T_UTF_16_LATIN_SMALL_LETTER_OU	0x0223
#define T_UTF_16_LATIN_CAPITAL_LETTER_Z_WITH_HOOK	0x0224
#define T_UTF_16_LATIN_SMALL_LETTER_Z_WITH_HOOK	0x0225
#define T_UTF_16_LATIN_CAPITAL_LETTER_A_WITH_DOT_ABOVE	0x0226
#define T_UTF_16_LATIN_SMALL_LETTER_A_WITH_DOT_ABOVE	0x0227
#define T_UTF_16_LATIN_CAPITAL_LETTER_E_WITH_CEDILLA	0x0228
#define T_UTF_16_LATIN_SMALL_LETTER_E_WITH_CEDILLA	0x0229
#define T_UTF_16_LATIN_CAPITAL_LETTER_O_WITH_DIAERESIS_AND_MACRON	0x022A
#define T_UTF_16_LATIN_SMALL_LETTER_O_WITH_DIAERESIS_AND_MACRON	0x022B
#define T_UTF_16_LATIN_CAPITAL_LETTER_O_WITH_TILDE_AND_MACRON	0x022C
#define T_UTF_16_LATIN_SMALL_LETTER_O_WITH_TILDE_AND_MACRON	0x022D
#define T_UTF_16_LATIN_CAPITAL_LETTER_O_WITH_DOT_ABOVE	0x022E
#define T_UTF_16_LATIN_SMALL_LETTER_O_WITH_DOT_ABOVE	0x022F
#define T_UTF_16_LATIN_CAPITAL_LETTER_O_WITH_DOT_ABOVE_AND_MACRON	0x0230
#define T_UTF_16_LATIN_SMALL_LETTER_O_WITH_DOT_ABOVE_AND_MACRON	0x0231
#define T_UTF_16_LATIN_CAPITAL_LETTER_Y_WITH_MACRON	0x0232
#define T_UTF_16_LATIN_SMALL_LETTER_Y_WITH_MACRON	0x0233
#define T_UTF_16_LATIN_SMALL_LETTER_TURNED_A	0x0250
#define T_UTF_16_LATIN_SMALL_LETTER_ALPHA	0x0251
#define T_UTF_16_LATIN_SMALL_LETTER_TURNED_ALPHA	0x0252
#define T_UTF_16_LATIN_SMALL_LETTER_B_WITH_HOOK	0x0253
#define T_UTF_16_LATIN_SMALL_LETTER_OPEN_O	0x0254
#define T_UTF_16_LATIN_SMALL_LETTER_C_WITH_CURL	0x0255
#define T_UTF_16_LATIN_SMALL_LETTER_D_WITH_TAIL	0x0256
#define T_UTF_16_LATIN_SMALL_LETTER_D_WITH_HOOK	0x0257
#define T_UTF_16_LATIN_SMALL_LETTER_REVERSED_E	0x0258
#define T_UTF_16_LATIN_SMALL_LETTER_SCHWA	0x0259
#define T_UTF_16_LATIN_SMALL_LETTER_SCHWA_WITH_HOOK	0x025A
#define T_UTF_16_LATIN_SMALL_LETTER_OPEN_E	0x025B
#define T_UTF_16_LATIN_SMALL_LETTER_REVERSED_OPEN_E	0x025C
#define T_UTF_16_LATIN_SMALL_LETTER_REVERSED_OPEN_E_WITH_HOOK	0x025D
#define T_UTF_16_LATIN_SMALL_LETTER_CLOSED_REVERSED_OPEN_E	0x025E
#define T_UTF_16_LATIN_SMALL_LETTER_DOTLESS_J_WITH_STROKE	0x025F
#define T_UTF_16_LATIN_SMALL_LETTER_G_WITH_HOOK	0x0260
#define T_UTF_16_LATIN_SMALL_LETTER_SCRIPT_G	0x0261
#define T_UTF_16_LATIN_LETTER_SMALL_CAPITAL_G	0x0262
#define T_UTF_16_LATIN_SMALL_LETTER_GAMMA	0x0263
#define T_UTF_16_LATIN_SMALL_LETTER_RAMS_HORN	0x0264
#define T_UTF_16_LATIN_SMALL_LETTER_TURNED_H	0x0265
#define T_UTF_16_LATIN_SMALL_LETTER_H_WITH_HOOK	0x0266
#define T_UTF_16_LATIN_SMALL_LETTER_HENG_WITH_HOOK	0x0267
#define T_UTF_16_LATIN_SMALL_LETTER_I_WITH_STROKE	0x0268
#define T_UTF_16_LATIN_SMALL_LETTER_IOTA	0x0269
#define T_UTF_16_LATIN_LETTER_SMALL_CAPITAL_I	0x026A
#define T_UTF_16_LATIN_SMALL_LETTER_L_WITH_MIDDLE_TILDE	0x026B
#define T_UTF_16_LATIN_SMALL_LETTER_L_WITH_BELT	0x026C
#define T_UTF_16_LATIN_SMALL_LETTER_L_WITH_RETROFLEX_HOOK	0x026D
#define T_UTF_16_LATIN_SMALL_LETTER_LEZH	0x026E
#define T_UTF_16_LATIN_SMALL_LETTER_TURNED_M	0x026F
#define T_UTF_16_LATIN_SMALL_LETTER_TURNED_M_WITH_LONG_LEG	0x0270
#define T_UTF_16_LATIN_SMALL_LETTER_M_WITH_HOOK	0x0271
#define T_UTF_16_LATIN_SMALL_LETTER_N_WITH_LEFT_HOOK	0x0272
#define T_UTF_16_LATIN_SMALL_LETTER_N_WITH_RETROFLEX_HOOK	0x0273
#define T_UTF_16_LATIN_LETTER_SMALL_CAPITAL_N	0x0274
#define T_UTF_16_LATIN_SMALL_LETTER_BARRED_O	0x0275
#define T_UTF_16_LATIN_LETTER_SMALL_CAPITAL_OE	0x0276
#define T_UTF_16_LATIN_SMALL_LETTER_CLOSED_OMEGA	0x0277
#define T_UTF_16_LATIN_SMALL_LETTER_PHI	0x0278
#define T_UTF_16_LATIN_SMALL_LETTER_TURNED_R	0x0279
#define T_UTF_16_LATIN_SMALL_LETTER_TURNED_R_WITH_LONG_LEG	0x027A
#define T_UTF_16_LATIN_SMALL_LETTER_TURNED_R_WITH_HOOK	0x027B
#define T_UTF_16_LATIN_SMALL_LETTER_R_WITH_LONG_LEG	0x027C
#define T_UTF_16_LATIN_SMALL_LETTER_R_WITH_TAIL	0x027D
#define T_UTF_16_LATIN_SMALL_LETTER_R_WITH_FISHHOOK	0x027E
#define T_UTF_16_LATIN_SMALL_LETTER_REVERSED_R_WITH_FISHHOOK	0x027F
#define T_UTF_16_LATIN_LETTER_SMALL_CAPITAL_R	0x0280
#define T_UTF_16_LATIN_LETTER_SMALL_CAPITAL_INVERTED_R	0x0281
#define T_UTF_16_LATIN_SMALL_LETTER_S_WITH_HOOK	0x0282
#define T_UTF_16_LATIN_SMALL_LETTER_ESH	0x0283
#define T_UTF_16_LATIN_SMALL_LETTER_DOTLESS_J_WITH_STROKE_AND_HOOK	0x0284
#define T_UTF_16_LATIN_SMALL_LETTER_SQUAT_REVERSED_ESH	0x0285
#define T_UTF_16_LATIN_SMALL_LETTER_ESH_WITH_CURL	0x0286
#define T_UTF_16_LATIN_SMALL_LETTER_TURNED_T	0x0287
#define T_UTF_16_LATIN_SMALL_LETTER_T_WITH_RETROFLEX_HOOK	0x0288
#define T_UTF_16_LATIN_SMALL_LETTER_U_BAR	0x0289
#define T_UTF_16_LATIN_SMALL_LETTER_UPSILON	0x028A
#define T_UTF_16_LATIN_SMALL_LETTER_V_WITH_HOOK	0x028B
#define T_UTF_16_LATIN_SMALL_LETTER_TURNED_V	0x028C
#define T_UTF_16_LATIN_SMALL_LETTER_TURNED_W	0x028D
#define T_UTF_16_LATIN_SMALL_LETTER_TURNED_Y	0x028E
#define T_UTF_16_LATIN_LETTER_SMALL_CAPITAL_Y	0x028F
#define T_UTF_16_LATIN_SMALL_LETTER_Z_WITH_RETROFLEX_HOOK	0x0290
#define T_UTF_16_LATIN_SMALL_LETTER_Z_WITH_CURL	0x0291
#define T_UTF_16_LATIN_SMALL_LETTER_EZH	0x0292
#define T_UTF_16_LATIN_SMALL_LETTER_EZH_WITH_CURL	0x0293
#define T_UTF_16_LATIN_LETTER_GLOTTAL_STOP	0x0294
#define T_UTF_16_LATIN_LETTER_PHARYNGEAL_VOICED_FRICATIVE	0x0295
#define T_UTF_16_LATIN_LETTER_INVERTED_GLOTTAL_STOP	0x0296
#define T_UTF_16_LATIN_LETTER_STRETCHED_C	0x0297
#define T_UTF_16_LATIN_LETTER_BILABIAL_CLICK	0x0298
#define T_UTF_16_LATIN_LETTER_SMALL_CAPITAL_B	0x0299
#define T_UTF_16_LATIN_SMALL_LETTER_CLOSED_OPEN_E	0x029A
#define T_UTF_16_LATIN_LETTER_SMALL_CAPITAL_G_WITH_HOOK	0x029B
#define T_UTF_16_LATIN_LETTER_SMALL_CAPITAL_H	0x029C
#define T_UTF_16_LATIN_SMALL_LETTER_J_WITH_CROSSED_TAIL	0x029D
#define T_UTF_16_LATIN_SMALL_LETTER_TURNED_K	0x029E
#define T_UTF_16_LATIN_LETTER_SMALL_CAPITAL_L	0x029F
#define T_UTF_16_LATIN_SMALL_LETTER_Q_WITH_HOOK	0x02A0
#define T_UTF_16_LATIN_LETTER_GLOTTAL_STOP_WITH_STROKE	0x02A1
#define T_UTF_16_LATIN_LETTER_REVERSED_GLOTTAL_STOP_WITH_STROKE	0x02A2
#define T_UTF_16_LATIN_SMALL_LETTER_DZ_DIGRAPH	0x02A3
#define T_UTF_16_LATIN_SMALL_LETTER_DEZH_DIGRAPH	0x02A4
#define T_UTF_16_LATIN_SMALL_LETTER_DZ_DIGRAPH_WITH_CURL	0x02A5
#define T_UTF_16_LATIN_SMALL_LETTER_TS_DIGRAPH	0x02A6
#define T_UTF_16_LATIN_SMALL_LETTER_TESH_DIGRAPH	0x02A7
#define T_UTF_16_LATIN_SMALL_LETTER_TC_DIGRAPH_WITH_CURL	0x02A8
#define T_UTF_16_LATIN_SMALL_LETTER_FENG_DIGRAPH	0x02A9
#define T_UTF_16_LATIN_SMALL_LETTER_LS_DIGRAPH	0x02AA
#define T_UTF_16_LATIN_SMALL_LETTER_LZ_DIGRAPH	0x02AB
#define T_UTF_16_LATIN_LETTER_BILABIAL_PERCUSSIVE	0x02AC
#define T_UTF_16_LATIN_LETTER_BIDENTAL_PERCUSSIVE	0x02AD
#define T_UTF_16_MODIFIER_LETTER_SMALL_H	0x02B0
#define T_UTF_16_MODIFIER_LETTER_SMALL_H_WITH_HOOK	0x02B1
#define T_UTF_16_MODIFIER_LETTER_SMALL_J	0x02B2
#define T_UTF_16_MODIFIER_LETTER_SMALL_R	0x02B3
#define T_UTF_16_MODIFIER_LETTER_SMALL_TURNED_R	0x02B4
#define T_UTF_16_MODIFIER_LETTER_SMALL_TURNED_R_WITH_HOOK	0x02B5
#define T_UTF_16_MODIFIER_LETTER_SMALL_CAPITAL_INVERTED_R	0x02B6
#define T_UTF_16_MODIFIER_LETTER_SMALL_W	0x02B7
#define T_UTF_16_MODIFIER_LETTER_SMALL_Y	0x02B8
#define T_UTF_16_MODIFIER_LETTER_PRIME	0x02B9
#define T_UTF_16_MODIFIER_LETTER_DOUBLE_PRIME	0x02BA
#define T_UTF_16_MODIFIER_LETTER_TURNED_COMMA	0x02BB
#define T_UTF_16_MODIFIER_LETTER_APOSTROPHE	0x02BC
#define T_UTF_16_MODIFIER_LETTER_REVERSED_COMMA	0x02BD
#define T_UTF_16_MODIFIER_LETTER_RIGHT_HALF_RING	0x02BE
#define T_UTF_16_MODIFIER_LETTER_LEFT_HALF_RING	0x02BF
#define T_UTF_16_MODIFIER_LETTER_GLOTTAL_STOP	0x02C0
#define T_UTF_16_MODIFIER_LETTER_REVERSED_GLOTTAL_STOP	0x02C1
#define T_UTF_16_MODIFIER_LETTER_LEFT_ARROWHEAD	0x02C2
#define T_UTF_16_MODIFIER_LETTER_RIGHT_ARROWHEAD	0x02C3
#define T_UTF_16_MODIFIER_LETTER_UP_ARROWHEAD	0x02C4
#define T_UTF_16_MODIFIER_LETTER_DOWN_ARROWHEAD	0x02C5
#define T_UTF_16_MODIFIER_LETTER_CIRCUMFLEX_ACCENT	0x02C6
#define T_UTF_16_CARON	0x02C7
#define T_UTF_16_MODIFIER_LETTER_VERTICAL_LINE	0x02C8
#define T_UTF_16_MODIFIER_LETTER_MACRON	0x02C9
#define T_UTF_16_MODIFIER_LETTER_ACUTE_ACCENT	0x02CA
#define T_UTF_16_MODIFIER_LETTER_GRAVE_ACCENT	0x02CB
#define T_UTF_16_MODIFIER_LETTER_LOW_VERTICAL_LINE	0x02CC
#define T_UTF_16_MODIFIER_LETTER_LOW_MACRON	0x02CD
#define T_UTF_16_MODIFIER_LETTER_LOW_GRAVE_ACCENT	0x02CE
#define T_UTF_16_MODIFIER_LETTER_LOW_ACUTE_ACCENT	0x02CF
#define T_UTF_16_MODIFIER_LETTER_TRIANGULAR_COLON	0x02D0
#define T_UTF_16_MODIFIER_LETTER_HALF_TRIANGULAR_COLON	0x02D1
#define T_UTF_16_MODIFIER_LETTER_CENTRED_RIGHT_HALF_RING	0x02D2
#define T_UTF_16_MODIFIER_LETTER_CENTRED_LEFT_HALF_RING	0x02D3
#define T_UTF_16_MODIFIER_LETTER_UP_TACK	0x02D4
#define T_UTF_16_MODIFIER_LETTER_DOWN_TACK	0x02D5
#define T_UTF_16_MODIFIER_LETTER_PLUS_SIGN	0x02D6
#define T_UTF_16_MODIFIER_LETTER_MINUS_SIGN	0x02D7
#define T_UTF_16_BREVE	0x02D8
#define T_UTF_16_DOT_ABOVE	0x02D9
#define T_UTF_16_RING_ABOVE	0x02DA
#define T_UTF_16_OGONEK	0x02DB
#define T_UTF_16_SMALL_TILDE	0x02DC
#define T_UTF_16_DOUBLE_ACUTE_ACCENT	0x02DD
#define T_UTF_16_MODIFIER_LETTER_RHOTIC_HOOK	0x02DE
#define T_UTF_16_MODIFIER_LETTER_CROSS_ACCENT	0x02DF
#define T_UTF_16_MODIFIER_LETTER_SMALL_GAMMA	0x02E0
#define T_UTF_16_MODIFIER_LETTER_SMALL_L	0x02E1
#define T_UTF_16_MODIFIER_LETTER_SMALL_S	0x02E2
#define T_UTF_16_MODIFIER_LETTER_SMALL_X	0x02E3
#define T_UTF_16_MODIFIER_LETTER_SMALL_REVERSED_GLOTTAL_STOP	0x02E4
#define T_UTF_16_MODIFIER_LETTER_EXTRA_HIGH_TONE_BAR	0x02E5
#define T_UTF_16_MODIFIER_LETTER_HIGH_TONE_BAR	0x02E6
#define T_UTF_16_MODIFIER_LETTER_MID_TONE_BAR	0x02E7
#define T_UTF_16_MODIFIER_LETTER_LOW_TONE_BAR	0x02E8
#define T_UTF_16_MODIFIER_LETTER_EXTRA_LOW_TONE_BAR	0x02E9
#define T_UTF_16_MODIFIER_LETTER_YIN_DEPARTING_TONE_MARK	0x02EA
#define T_UTF_16_MODIFIER_LETTER_YANG_DEPARTING_TONE_MARK	0x02EB
#define T_UTF_16_MODIFIER_LETTER_VOICING	0x02EC
#define T_UTF_16_MODIFIER_LETTER_UNASPIRATED	0x02ED
#define T_UTF_16_MODIFIER_LETTER_DOUBLE_APOSTROPHE	0x02EE
#define T_UTF_16_COMBINING_GRAVE_ACCENT	0x0300
#define T_UTF_16_COMBINING_ACUTE_ACCENT	0x0301
#define T_UTF_16_COMBINING_CIRCUMFLEX_ACCENT	0x0302
#define T_UTF_16_COMBINING_TILDE	0x0303
#define T_UTF_16_COMBINING_MACRON	0x0304
#define T_UTF_16_COMBINING_OVERLINE	0x0305
#define T_UTF_16_COMBINING_BREVE	0x0306
#define T_UTF_16_COMBINING_DOT_ABOVE	0x0307
#define T_UTF_16_COMBINING_DIAERESIS	0x0308
#define T_UTF_16_COMBINING_HOOK_ABOVE	0x0309
#define T_UTF_16_COMBINING_RING_ABOVE	0x030A
#define T_UTF_16_COMBINING_DOUBLE_ACUTE_ACCENT	0x030B
#define T_UTF_16_COMBINING_CARON	0x030C
#define T_UTF_16_COMBINING_VERTICAL_LINE_ABOVE	0x030D
#define T_UTF_16_COMBINING_DOUBLE_VERTICAL_LINE_ABOVE	0x030E
#define T_UTF_16_COMBINING_DOUBLE_GRAVE_ACCENT	0x030F
#define T_UTF_16_COMBINING_CANDRABINDU	0x0310
#define T_UTF_16_COMBINING_INVERTED_BREVE	0x0311
#define T_UTF_16_COMBINING_TURNED_COMMA_ABOVE	0x0312
#define T_UTF_16_COMBINING_COMMA_ABOVE	0x0313
#define T_UTF_16_COMBINING_REVERSED_COMMA_ABOVE	0x0314
#define T_UTF_16_COMBINING_COMMA_ABOVE_RIGHT	0x0315
#define T_UTF_16_COMBINING_GRAVE_ACCENT_BELOW	0x0316
#define T_UTF_16_COMBINING_ACUTE_ACCENT_BELOW	0x0317
#define T_UTF_16_COMBINING_LEFT_TACK_BELOW	0x0318
#define T_UTF_16_COMBINING_RIGHT_TACK_BELOW	0x0319
#define T_UTF_16_COMBINING_LEFT_ANGLE_ABOVE	0x031A
#define T_UTF_16_COMBINING_HORN	0x031B
#define T_UTF_16_COMBINING_LEFT_HALF_RING_BELOW	0x031C
#define T_UTF_16_COMBINING_UP_TACK_BELOW	0x031D
#define T_UTF_16_COMBINING_DOWN_TACK_BELOW	0x031E
#define T_UTF_16_COMBINING_PLUS_SIGN_BELOW	0x031F
#define T_UTF_16_COMBINING_MINUS_SIGN_BELOW	0x0320
#define T_UTF_16_COMBINING_PALATALIZED_HOOK_BELOW	0x0321
#define T_UTF_16_COMBINING_RETROFLEX_HOOK_BELOW	0x0322
#define T_UTF_16_COMBINING_DOT_BELOW	0x0323
#define T_UTF_16_COMBINING_DIAERESIS_BELOW	0x0324
#define T_UTF_16_COMBINING_RING_BELOW	0x0325
#define T_UTF_16_COMBINING_COMMA_BELOW	0x0326
#define T_UTF_16_COMBINING_CEDILLA	0x0327
#define T_UTF_16_COMBINING_OGONEK	0x0328
#define T_UTF_16_COMBINING_VERTICAL_LINE_BELOW	0x0329
#define T_UTF_16_COMBINING_BRIDGE_BELOW	0x032A
#define T_UTF_16_COMBINING_INVERTED_DOUBLE_ARCH_BELOW	0x032B
#define T_UTF_16_COMBINING_CARON_BELOW	0x032C
#define T_UTF_16_COMBINING_CIRCUMFLEX_ACCENT_BELOW	0x032D
#define T_UTF_16_COMBINING_BREVE_BELOW	0x032E
#define T_UTF_16_COMBINING_INVERTED_BREVE_BELOW	0x032F
#define T_UTF_16_COMBINING_TILDE_BELOW	0x0330
#define T_UTF_16_COMBINING_MACRON_BELOW	0x0331
#define T_UTF_16_COMBINING_LOW_LINE	0x0332
#define T_UTF_16_COMBINING_DOUBLE_LOW_LINE	0x0333
#define T_UTF_16_COMBINING_TILDE_OVERLAY	0x0334
#define T_UTF_16_COMBINING_SHORT_STROKE_OVERLAY	0x0335
#define T_UTF_16_COMBINING_LONG_STROKE_OVERLAY	0x0336
#define T_UTF_16_COMBINING_SHORT_SOLIDUS_OVERLAY	0x0337
#define T_UTF_16_COMBINING_LONG_SOLIDUS_OVERLAY	0x0338
#define T_UTF_16_COMBINING_RIGHT_HALF_RING_BELOW	0x0339
#define T_UTF_16_COMBINING_INVERTED_BRIDGE_BELOW	0x033A
#define T_UTF_16_COMBINING_SQUARE_BELOW	0x033B
#define T_UTF_16_COMBINING_SEAGULL_BELOW	0x033C
#define T_UTF_16_COMBINING_X_ABOVE	0x033D
#define T_UTF_16_COMBINING_VERTICAL_TILDE	0x033E
#define T_UTF_16_COMBINING_DOUBLE_OVERLINE	0x033F
#define T_UTF_16_COMBINING_GRAVE_TONE_MARK	0x0340
#define T_UTF_16_COMBINING_ACUTE_TONE_MARK	0x0341
#define T_UTF_16_COMBINING_GREEK_PERISPOMENI	0x0342
#define T_UTF_16_COMBINING_GREEK_KORONIS	0x0343
#define T_UTF_16_COMBINING_GREEK_DIALYTIKA_TONOS	0x0344
#define T_UTF_16_COMBINING_GREEK_YPOGEGRAMMENI	0x0345
#define T_UTF_16_COMBINING_BRIDGE_ABOVE	0x0346
#define T_UTF_16_COMBINING_EQUALS_SIGN_BELOW	0x0347
#define T_UTF_16_COMBINING_DOUBLE_VERTICAL_LINE_BELOW	0x0348
#define T_UTF_16_COMBINING_LEFT_ANGLE_BELOW	0x0349
#define T_UTF_16_COMBINING_NOT_TILDE_ABOVE	0x034A
#define T_UTF_16_COMBINING_HOMOTHETIC_ABOVE	0x034B
#define T_UTF_16_COMBINING_ALMOST_EQUAL_TO_ABOVE	0x034C
#define T_UTF_16_COMBINING_LEFT_RIGHT_ARROW_BELOW	0x034D
#define T_UTF_16_COMBINING_UPWARDS_ARROW_BELOW	0x034E
#define T_UTF_16_COMBINING_DOUBLE_TILDE	0x0360
#define T_UTF_16_COMBINING_DOUBLE_INVERTED_BREVE	0x0361
#define T_UTF_16_COMBINING_DOUBLE_RIGHTWARDS_ARROW_BELOW	0x0362
#define T_UTF_16_GREEK_NUMERAL_SIGN	0x0374
#define T_UTF_16_GREEK_LOWER_NUMERAL_SIGN	0x0375
#define T_UTF_16_GREEK_YPOGEGRAMMENI	0x037A
#define T_UTF_16_GREEK_QUESTION_MARK	0x037E
#define T_UTF_16_GREEK_TONOS	0x0384
#define T_UTF_16_GREEK_DIALYTIKA_TONOS	0x0385
#define T_UTF_16_GREEK_CAPITAL_LETTER_ALPHA_WITH_TONOS	0x0386
#define T_UTF_16_GREEK_ANO_TELEIA	0x0387
#define T_UTF_16_GREEK_CAPITAL_LETTER_EPSILON_WITH_TONOS	0x0388
#define T_UTF_16_GREEK_CAPITAL_LETTER_ETA_WITH_TONOS	0x0389
#define T_UTF_16_GREEK_CAPITAL_LETTER_IOTA_WITH_TONOS	0x038A
#define T_UTF_16_GREEK_CAPITAL_LETTER_OMICRON_WITH_TONOS	0x038C
#define T_UTF_16_GREEK_CAPITAL_LETTER_UPSILON_WITH_TONOS	0x038E
#define T_UTF_16_GREEK_CAPITAL_LETTER_OMEGA_WITH_TONOS	0x038F
#define T_UTF_16_GREEK_SMALL_LETTER_IOTA_WITH_DIALYTIKA_AND_TONOS	0x0390
#define T_UTF_16_GREEK_CAPITAL_LETTER_ALPHA	0x0391
#define T_UTF_16_GREEK_CAPITAL_LETTER_BETA	0x0392
#define T_UTF_16_GREEK_CAPITAL_LETTER_GAMMA	0x0393
#define T_UTF_16_GREEK_CAPITAL_LETTER_DELTA	0x0394
#define T_UTF_16_GREEK_CAPITAL_LETTER_EPSILON	0x0395
#define T_UTF_16_GREEK_CAPITAL_LETTER_ZETA	0x0396
#define T_UTF_16_GREEK_CAPITAL_LETTER_ETA	0x0397
#define T_UTF_16_GREEK_CAPITAL_LETTER_THETA	0x0398
#define T_UTF_16_GREEK_CAPITAL_LETTER_IOTA	0x0399
#define T_UTF_16_GREEK_CAPITAL_LETTER_KAPPA	0x039A
#define T_UTF_16_GREEK_CAPITAL_LETTER_LAMDA	0x039B
#define T_UTF_16_GREEK_CAPITAL_LETTER_MU	0x039C
#define T_UTF_16_GREEK_CAPITAL_LETTER_NU	0x039D
#define T_UTF_16_GREEK_CAPITAL_LETTER_XI	0x039E
#define T_UTF_16_GREEK_CAPITAL_LETTER_OMICRON	0x039F
#define T_UTF_16_GREEK_CAPITAL_LETTER_PI	0x03A0
#define T_UTF_16_GREEK_CAPITAL_LETTER_RHO	0x03A1
#define T_UTF_16_GREEK_CAPITAL_LETTER_SIGMA	0x03A3
#define T_UTF_16_GREEK_CAPITAL_LETTER_TAU	0x03A4
#define T_UTF_16_GREEK_CAPITAL_LETTER_UPSILON	0x03A5
#define T_UTF_16_GREEK_CAPITAL_LETTER_PHI	0x03A6
#define T_UTF_16_GREEK_CAPITAL_LETTER_CHI	0x03A7
#define T_UTF_16_GREEK_CAPITAL_LETTER_PSI	0x03A8
#define T_UTF_16_GREEK_CAPITAL_LETTER_OMEGA	0x03A9
#define T_UTF_16_GREEK_CAPITAL_LETTER_IOTA_WITH_DIALYTIKA	0x03AA
#define T_UTF_16_GREEK_CAPITAL_LETTER_UPSILON_WITH_DIALYTIKA	0x03AB
#define T_UTF_16_GREEK_SMALL_LETTER_ALPHA_WITH_TONOS	0x03AC
#define T_UTF_16_GREEK_SMALL_LETTER_EPSILON_WITH_TONOS	0x03AD
#define T_UTF_16_GREEK_SMALL_LETTER_ETA_WITH_TONOS	0x03AE
#define T_UTF_16_GREEK_SMALL_LETTER_IOTA_WITH_TONOS	0x03AF
#define T_UTF_16_GREEK_SMALL_LETTER_UPSILON_WITH_DIALYTIKA_AND_TONOS	0x03B0
#define T_UTF_16_GREEK_SMALL_LETTER_ALPHA	0x03B1
#define T_UTF_16_GREEK_SMALL_LETTER_BETA	0x03B2
#define T_UTF_16_GREEK_SMALL_LETTER_GAMMA	0x03B3
#define T_UTF_16_GREEK_SMALL_LETTER_DELTA	0x03B4
#define T_UTF_16_GREEK_SMALL_LETTER_EPSILON	0x03B5
#define T_UTF_16_GREEK_SMALL_LETTER_ZETA	0x03B6
#define T_UTF_16_GREEK_SMALL_LETTER_ETA	0x03B7
#define T_UTF_16_GREEK_SMALL_LETTER_THETA	0x03B8
#define T_UTF_16_GREEK_SMALL_LETTER_IOTA	0x03B9
#define T_UTF_16_GREEK_SMALL_LETTER_KAPPA	0x03BA
#define T_UTF_16_GREEK_SMALL_LETTER_LAMDA	0x03BB
#define T_UTF_16_GREEK_SMALL_LETTER_MU	0x03BC
#define T_UTF_16_GREEK_SMALL_LETTER_NU	0x03BD
#define T_UTF_16_GREEK_SMALL_LETTER_XI	0x03BE
#define T_UTF_16_GREEK_SMALL_LETTER_OMICRON	0x03BF
#define T_UTF_16_GREEK_SMALL_LETTER_PI	0x03C0
#define T_UTF_16_GREEK_SMALL_LETTER_RHO	0x03C1
#define T_UTF_16_GREEK_SMALL_LETTER_FINAL_SIGMA	0x03C2
#define T_UTF_16_GREEK_SMALL_LETTER_SIGMA	0x03C3
#define T_UTF_16_GREEK_SMALL_LETTER_TAU	0x03C4
#define T_UTF_16_GREEK_SMALL_LETTER_UPSILON	0x03C5
#define T_UTF_16_GREEK_SMALL_LETTER_PHI	0x03C6
#define T_UTF_16_GREEK_SMALL_LETTER_CHI	0x03C7
#define T_UTF_16_GREEK_SMALL_LETTER_PSI	0x03C8
#define T_UTF_16_GREEK_SMALL_LETTER_OMEGA	0x03C9
#define T_UTF_16_GREEK_SMALL_LETTER_IOTA_WITH_DIALYTIKA	0x03CA
#define T_UTF_16_GREEK_SMALL_LETTER_UPSILON_WITH_DIALYTIKA	0x03CB
#define T_UTF_16_GREEK_SMALL_LETTER_OMICRON_WITH_TONOS	0x03CC
#define T_UTF_16_GREEK_SMALL_LETTER_UPSILON_WITH_TONOS	0x03CD
#define T_UTF_16_GREEK_SMALL_LETTER_OMEGA_WITH_TONOS	0x03CE
#define T_UTF_16_GREEK_BETA_SYMBOL	0x03D0
#define T_UTF_16_GREEK_THETA_SYMBOL	0x03D1
#define T_UTF_16_GREEK_UPSILON_WITH_HOOK_SYMBOL	0x03D2
#define T_UTF_16_GREEK_UPSILON_WITH_ACUTE_AND_HOOK_SYMBOL	0x03D3
#define T_UTF_16_GREEK_UPSILON_WITH_DIAERESIS_AND_HOOK_SYMBOL	0x03D4
#define T_UTF_16_GREEK_PHI_SYMBOL	0x03D5
#define T_UTF_16_GREEK_PI_SYMBOL	0x03D6
#define T_UTF_16_GREEK_KAI_SYMBOL	0x03D7
#define T_UTF_16_GREEK_LETTER_STIGMA	0x03DA
#define T_UTF_16_GREEK_SMALL_LETTER_STIGMA	0x03DB
#define T_UTF_16_GREEK_LETTER_DIGAMMA	0x03DC
#define T_UTF_16_GREEK_SMALL_LETTER_DIGAMMA	0x03DD
#define T_UTF_16_GREEK_LETTER_KOPPA	0x03DE
#define T_UTF_16_GREEK_SMALL_LETTER_KOPPA	0x03DF
#define T_UTF_16_GREEK_LETTER_SAMPI	0x03E0
#define T_UTF_16_GREEK_SMALL_LETTER_SAMPI	0x03E1
#define T_UTF_16_COPTIC_CAPITAL_LETTER_SHEI	0x03E2
#define T_UTF_16_COPTIC_SMALL_LETTER_SHEI	0x03E3
#define T_UTF_16_COPTIC_CAPITAL_LETTER_FEI	0x03E4
#define T_UTF_16_COPTIC_SMALL_LETTER_FEI	0x03E5
#define T_UTF_16_COPTIC_CAPITAL_LETTER_KHEI	0x03E6
#define T_UTF_16_COPTIC_SMALL_LETTER_KHEI	0x03E7
#define T_UTF_16_COPTIC_CAPITAL_LETTER_HORI	0x03E8
#define T_UTF_16_COPTIC_SMALL_LETTER_HORI	0x03E9
#define T_UTF_16_COPTIC_CAPITAL_LETTER_GANGIA	0x03EA
#define T_UTF_16_COPTIC_SMALL_LETTER_GANGIA	0x03EB
#define T_UTF_16_COPTIC_CAPITAL_LETTER_SHIMA	0x03EC
#define T_UTF_16_COPTIC_SMALL_LETTER_SHIMA	0x03ED
#define T_UTF_16_COPTIC_CAPITAL_LETTER_DEI	0x03EE
#define T_UTF_16_COPTIC_SMALL_LETTER_DEI	0x03EF
#define T_UTF_16_GREEK_KAPPA_SYMBOL	0x03F0
#define T_UTF_16_GREEK_RHO_SYMBOL	0x03F1
#define T_UTF_16_GREEK_LUNATE_SIGMA_SYMBOL	0x03F2
#define T_UTF_16_GREEK_LETTER_YOT	0x03F3
#define T_UTF_16_GREEK_CAPITAL_THETA_SYMBOL	0x03F4
#define T_UTF_16_GREEK_LUNATE_EPSILON_SYMBOL	0x03F5
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_IE_WITH_GRAVE	0x0400
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_IO	0x0401
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_DJE	0x0402
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_GJE	0x0403
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_UKRAINIAN_IE	0x0404
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_DZE	0x0405
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_BYELORUSSIAN_UKRAINIAN_I	0x0406
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_YI	0x0407
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_JE	0x0408
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_LJE	0x0409
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_NJE	0x040A
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_TSHE	0x040B
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_KJE	0x040C
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_I_WITH_GRAVE	0x040D
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_SHORT_U	0x040E
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_DZHE	0x040F
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_A	0x0410
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_BE	0x0411
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_VE	0x0412
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_GHE	0x0413
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_DE	0x0414
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_IE	0x0415
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_ZHE	0x0416
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_ZE	0x0417
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_I	0x0418
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_SHORT_I	0x0419
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_KA	0x041A
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_EL	0x041B
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_EM	0x041C
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_EN	0x041D
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_O	0x041E
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_PE	0x041F
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_ER	0x0420
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_ES	0x0421
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_TE	0x0422
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_U	0x0423
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_EF	0x0424
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_HA	0x0425
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_TSE	0x0426
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_CHE	0x0427
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_SHA	0x0428
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_SHCHA	0x0429
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_HARD_SIGN	0x042A
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_YERU	0x042B
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_SOFT_SIGN	0x042C
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_E	0x042D
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_YU	0x042E
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_YA	0x042F
#define T_UTF_16_CYRILLIC_SMALL_LETTER_A	0x0430
#define T_UTF_16_CYRILLIC_SMALL_LETTER_BE	0x0431
#define T_UTF_16_CYRILLIC_SMALL_LETTER_VE	0x0432
#define T_UTF_16_CYRILLIC_SMALL_LETTER_GHE	0x0433
#define T_UTF_16_CYRILLIC_SMALL_LETTER_DE	0x0434
#define T_UTF_16_CYRILLIC_SMALL_LETTER_IE	0x0435
#define T_UTF_16_CYRILLIC_SMALL_LETTER_ZHE	0x0436
#define T_UTF_16_CYRILLIC_SMALL_LETTER_ZE	0x0437
#define T_UTF_16_CYRILLIC_SMALL_LETTER_I	0x0438
#define T_UTF_16_CYRILLIC_SMALL_LETTER_SHORT_I	0x0439
#define T_UTF_16_CYRILLIC_SMALL_LETTER_KA	0x043A
#define T_UTF_16_CYRILLIC_SMALL_LETTER_EL	0x043B
#define T_UTF_16_CYRILLIC_SMALL_LETTER_EM	0x043C
#define T_UTF_16_CYRILLIC_SMALL_LETTER_EN	0x043D
#define T_UTF_16_CYRILLIC_SMALL_LETTER_O	0x043E
#define T_UTF_16_CYRILLIC_SMALL_LETTER_PE	0x043F
#define T_UTF_16_CYRILLIC_SMALL_LETTER_ER	0x0440
#define T_UTF_16_CYRILLIC_SMALL_LETTER_ES	0x0441
#define T_UTF_16_CYRILLIC_SMALL_LETTER_TE	0x0442
#define T_UTF_16_CYRILLIC_SMALL_LETTER_U	0x0443
#define T_UTF_16_CYRILLIC_SMALL_LETTER_EF	0x0444
#define T_UTF_16_CYRILLIC_SMALL_LETTER_HA	0x0445
#define T_UTF_16_CYRILLIC_SMALL_LETTER_TSE	0x0446
#define T_UTF_16_CYRILLIC_SMALL_LETTER_CHE	0x0447
#define T_UTF_16_CYRILLIC_SMALL_LETTER_SHA	0x0448
#define T_UTF_16_CYRILLIC_SMALL_LETTER_SHCHA	0x0449
#define T_UTF_16_CYRILLIC_SMALL_LETTER_HARD_SIGN	0x044A
#define T_UTF_16_CYRILLIC_SMALL_LETTER_YERU	0x044B
#define T_UTF_16_CYRILLIC_SMALL_LETTER_SOFT_SIGN	0x044C
#define T_UTF_16_CYRILLIC_SMALL_LETTER_E	0x044D
#define T_UTF_16_CYRILLIC_SMALL_LETTER_YU	0x044E
#define T_UTF_16_CYRILLIC_SMALL_LETTER_YA	0x044F
#define T_UTF_16_CYRILLIC_SMALL_LETTER_IE_WITH_GRAVE	0x0450
#define T_UTF_16_CYRILLIC_SMALL_LETTER_IO	0x0451
#define T_UTF_16_CYRILLIC_SMALL_LETTER_DJE	0x0452
#define T_UTF_16_CYRILLIC_SMALL_LETTER_GJE	0x0453
#define T_UTF_16_CYRILLIC_SMALL_LETTER_UKRAINIAN_IE	0x0454
#define T_UTF_16_CYRILLIC_SMALL_LETTER_DZE	0x0455
#define T_UTF_16_CYRILLIC_SMALL_LETTER_BYELORUSSIAN_UKRAINIAN_I	0x0456
#define T_UTF_16_CYRILLIC_SMALL_LETTER_YI	0x0457
#define T_UTF_16_CYRILLIC_SMALL_LETTER_JE	0x0458
#define T_UTF_16_CYRILLIC_SMALL_LETTER_LJE	0x0459
#define T_UTF_16_CYRILLIC_SMALL_LETTER_NJE	0x045A
#define T_UTF_16_CYRILLIC_SMALL_LETTER_TSHE	0x045B
#define T_UTF_16_CYRILLIC_SMALL_LETTER_KJE	0x045C
#define T_UTF_16_CYRILLIC_SMALL_LETTER_I_WITH_GRAVE	0x045D
#define T_UTF_16_CYRILLIC_SMALL_LETTER_SHORT_U	0x045E
#define T_UTF_16_CYRILLIC_SMALL_LETTER_DZHE	0x045F
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_OMEGA	0x0460
#define T_UTF_16_CYRILLIC_SMALL_LETTER_OMEGA	0x0461
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_YAT	0x0462
#define T_UTF_16_CYRILLIC_SMALL_LETTER_YAT	0x0463
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_IOTIFIED_E	0x0464
#define T_UTF_16_CYRILLIC_SMALL_LETTER_IOTIFIED_E	0x0465
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_LITTLE_YUS	0x0466
#define T_UTF_16_CYRILLIC_SMALL_LETTER_LITTLE_YUS	0x0467
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_IOTIFIED_LITTLE_YUS	0x0468
#define T_UTF_16_CYRILLIC_SMALL_LETTER_IOTIFIED_LITTLE_YUS	0x0469
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_BIG_YUS	0x046A
#define T_UTF_16_CYRILLIC_SMALL_LETTER_BIG_YUS	0x046B
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_IOTIFIED_BIG_YUS	0x046C
#define T_UTF_16_CYRILLIC_SMALL_LETTER_IOTIFIED_BIG_YUS	0x046D
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_KSI	0x046E
#define T_UTF_16_CYRILLIC_SMALL_LETTER_KSI	0x046F
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_PSI	0x0470
#define T_UTF_16_CYRILLIC_SMALL_LETTER_PSI	0x0471
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_FITA	0x0472
#define T_UTF_16_CYRILLIC_SMALL_LETTER_FITA	0x0473
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_IZHITSA	0x0474
#define T_UTF_16_CYRILLIC_SMALL_LETTER_IZHITSA	0x0475
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_IZHITSA_WITH_DOUBLE_GRAVE_ACCENT	0x0476
#define T_UTF_16_CYRILLIC_SMALL_LETTER_IZHITSA_WITH_DOUBLE_GRAVE_ACCENT	0x0477
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_UK	0x0478
#define T_UTF_16_CYRILLIC_SMALL_LETTER_UK	0x0479
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_ROUND_OMEGA	0x047A
#define T_UTF_16_CYRILLIC_SMALL_LETTER_ROUND_OMEGA	0x047B
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_OMEGA_WITH_TITLO	0x047C
#define T_UTF_16_CYRILLIC_SMALL_LETTER_OMEGA_WITH_TITLO	0x047D
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_OT	0x047E
#define T_UTF_16_CYRILLIC_SMALL_LETTER_OT	0x047F
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_KOPPA	0x0480
#define T_UTF_16_CYRILLIC_SMALL_LETTER_KOPPA	0x0481
#define T_UTF_16_CYRILLIC_THOUSANDS_SIGN	0x0482
#define T_UTF_16_COMBINING_CYRILLIC_TITLO	0x0483
#define T_UTF_16_COMBINING_CYRILLIC_PALATALIZATION	0x0484
#define T_UTF_16_COMBINING_CYRILLIC_DASIA_PNEUMATA	0x0485
#define T_UTF_16_COMBINING_CYRILLIC_PSILI_PNEUMATA	0x0486
#define T_UTF_16_COMBINING_CYRILLIC_HUNDRED_THOUSANDS_SIGN	0x0488
#define T_UTF_16_COMBINING_CYRILLIC_MILLIONS_SIGN	0x0489
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_SEMISOFT_SIGN	0x048C
#define T_UTF_16_CYRILLIC_SMALL_LETTER_SEMISOFT_SIGN	0x048D
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_ER_WITH_TICK	0x048E
#define T_UTF_16_CYRILLIC_SMALL_LETTER_ER_WITH_TICK	0x048F
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_GHE_WITH_UPTURN	0x0490
#define T_UTF_16_CYRILLIC_SMALL_LETTER_GHE_WITH_UPTURN	0x0491
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_GHE_WITH_STROKE	0x0492
#define T_UTF_16_CYRILLIC_SMALL_LETTER_GHE_WITH_STROKE	0x0493
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_GHE_WITH_MIDDLE_HOOK	0x0494
#define T_UTF_16_CYRILLIC_SMALL_LETTER_GHE_WITH_MIDDLE_HOOK	0x0495
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_ZHE_WITH_DESCENDER	0x0496
#define T_UTF_16_CYRILLIC_SMALL_LETTER_ZHE_WITH_DESCENDER	0x0497
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_ZE_WITH_DESCENDER	0x0498
#define T_UTF_16_CYRILLIC_SMALL_LETTER_ZE_WITH_DESCENDER	0x0499
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_KA_WITH_DESCENDER	0x049A
#define T_UTF_16_CYRILLIC_SMALL_LETTER_KA_WITH_DESCENDER	0x049B
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_KA_WITH_VERTICAL_STROKE	0x049C
#define T_UTF_16_CYRILLIC_SMALL_LETTER_KA_WITH_VERTICAL_STROKE	0x049D
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_KA_WITH_STROKE	0x049E
#define T_UTF_16_CYRILLIC_SMALL_LETTER_KA_WITH_STROKE	0x049F
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_BASHKIR_KA	0x04A0
#define T_UTF_16_CYRILLIC_SMALL_LETTER_BASHKIR_KA	0x04A1
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_EN_WITH_DESCENDER	0x04A2
#define T_UTF_16_CYRILLIC_SMALL_LETTER_EN_WITH_DESCENDER	0x04A3
#define T_UTF_16_CYRILLIC_CAPITAL_LIGATURE_EN_GHE	0x04A4
#define T_UTF_16_CYRILLIC_SMALL_LIGATURE_EN_GHE	0x04A5
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_PE_WITH_MIDDLE_HOOK	0x04A6
#define T_UTF_16_CYRILLIC_SMALL_LETTER_PE_WITH_MIDDLE_HOOK	0x04A7
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_ABKHASIAN_HA	0x04A8
#define T_UTF_16_CYRILLIC_SMALL_LETTER_ABKHASIAN_HA	0x04A9
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_ES_WITH_DESCENDER	0x04AA
#define T_UTF_16_CYRILLIC_SMALL_LETTER_ES_WITH_DESCENDER	0x04AB
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_TE_WITH_DESCENDER	0x04AC
#define T_UTF_16_CYRILLIC_SMALL_LETTER_TE_WITH_DESCENDER	0x04AD
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_STRAIGHT_U	0x04AE
#define T_UTF_16_CYRILLIC_SMALL_LETTER_STRAIGHT_U	0x04AF
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_STRAIGHT_U_WITH_STROKE	0x04B0
#define T_UTF_16_CYRILLIC_SMALL_LETTER_STRAIGHT_U_WITH_STROKE	0x04B1
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_HA_WITH_DESCENDER	0x04B2
#define T_UTF_16_CYRILLIC_SMALL_LETTER_HA_WITH_DESCENDER	0x04B3
#define T_UTF_16_CYRILLIC_CAPITAL_LIGATURE_TE_TSE	0x04B4
#define T_UTF_16_CYRILLIC_SMALL_LIGATURE_TE_TSE	0x04B5
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_CHE_WITH_DESCENDER	0x04B6
#define T_UTF_16_CYRILLIC_SMALL_LETTER_CHE_WITH_DESCENDER	0x04B7
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_CHE_WITH_VERTICAL_STROKE	0x04B8
#define T_UTF_16_CYRILLIC_SMALL_LETTER_CHE_WITH_VERTICAL_STROKE	0x04B9
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_SHHA	0x04BA
#define T_UTF_16_CYRILLIC_SMALL_LETTER_SHHA	0x04BB
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_ABKHASIAN_CHE	0x04BC
#define T_UTF_16_CYRILLIC_SMALL_LETTER_ABKHASIAN_CHE	0x04BD
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_ABKHASIAN_CHE_WITH_DESCENDER	0x04BE
#define T_UTF_16_CYRILLIC_SMALL_LETTER_ABKHASIAN_CHE_WITH_DESCENDER	0x04BF
#define T_UTF_16_CYRILLIC_LETTER_PALOCHKA	0x04C0
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_ZHE_WITH_BREVE	0x04C1
#define T_UTF_16_CYRILLIC_SMALL_LETTER_ZHE_WITH_BREVE	0x04C2
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_KA_WITH_HOOK	0x04C3
#define T_UTF_16_CYRILLIC_SMALL_LETTER_KA_WITH_HOOK	0x04C4
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_EN_WITH_HOOK	0x04C7
#define T_UTF_16_CYRILLIC_SMALL_LETTER_EN_WITH_HOOK	0x04C8
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_KHAKASSIAN_CHE	0x04CB
#define T_UTF_16_CYRILLIC_SMALL_LETTER_KHAKASSIAN_CHE	0x04CC
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_A_WITH_BREVE	0x04D0
#define T_UTF_16_CYRILLIC_SMALL_LETTER_A_WITH_BREVE	0x04D1
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_A_WITH_DIAERESIS	0x04D2
#define T_UTF_16_CYRILLIC_SMALL_LETTER_A_WITH_DIAERESIS	0x04D3
#define T_UTF_16_CYRILLIC_CAPITAL_LIGATURE_A_IE	0x04D4
#define T_UTF_16_CYRILLIC_SMALL_LIGATURE_A_IE	0x04D5
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_IE_WITH_BREVE	0x04D6
#define T_UTF_16_CYRILLIC_SMALL_LETTER_IE_WITH_BREVE	0x04D7
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_SCHWA	0x04D8
#define T_UTF_16_CYRILLIC_SMALL_LETTER_SCHWA	0x04D9
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_SCHWA_WITH_DIAERESIS	0x04DA
#define T_UTF_16_CYRILLIC_SMALL_LETTER_SCHWA_WITH_DIAERESIS	0x04DB
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_ZHE_WITH_DIAERESIS	0x04DC
#define T_UTF_16_CYRILLIC_SMALL_LETTER_ZHE_WITH_DIAERESIS	0x04DD
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_ZE_WITH_DIAERESIS	0x04DE
#define T_UTF_16_CYRILLIC_SMALL_LETTER_ZE_WITH_DIAERESIS	0x04DF
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_ABKHASIAN_DZE	0x04E0
#define T_UTF_16_CYRILLIC_SMALL_LETTER_ABKHASIAN_DZE	0x04E1
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_I_WITH_MACRON	0x04E2
#define T_UTF_16_CYRILLIC_SMALL_LETTER_I_WITH_MACRON	0x04E3
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_I_WITH_DIAERESIS	0x04E4
#define T_UTF_16_CYRILLIC_SMALL_LETTER_I_WITH_DIAERESIS	0x04E5
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_O_WITH_DIAERESIS	0x04E6
#define T_UTF_16_CYRILLIC_SMALL_LETTER_O_WITH_DIAERESIS	0x04E7
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_BARRED_O	0x04E8
#define T_UTF_16_CYRILLIC_SMALL_LETTER_BARRED_O	0x04E9
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_BARRED_O_WITH_DIAERESIS	0x04EA
#define T_UTF_16_CYRILLIC_SMALL_LETTER_BARRED_O_WITH_DIAERESIS	0x04EB
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_E_WITH_DIAERESIS	0x04EC
#define T_UTF_16_CYRILLIC_SMALL_LETTER_E_WITH_DIAERESIS	0x04ED
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_U_WITH_MACRON	0x04EE
#define T_UTF_16_CYRILLIC_SMALL_LETTER_U_WITH_MACRON	0x04EF
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_U_WITH_DIAERESIS	0x04F0
#define T_UTF_16_CYRILLIC_SMALL_LETTER_U_WITH_DIAERESIS	0x04F1
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_U_WITH_DOUBLE_ACUTE	0x04F2
#define T_UTF_16_CYRILLIC_SMALL_LETTER_U_WITH_DOUBLE_ACUTE	0x04F3
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_CHE_WITH_DIAERESIS	0x04F4
#define T_UTF_16_CYRILLIC_SMALL_LETTER_CHE_WITH_DIAERESIS	0x04F5
#define T_UTF_16_CYRILLIC_CAPITAL_LETTER_YERU_WITH_DIAERESIS	0x04F8
#define T_UTF_16_CYRILLIC_SMALL_LETTER_YERU_WITH_DIAERESIS	0x04F9
#define T_UTF_16_ARMENIAN_CAPITAL_LETTER_AYB	0x0531
#define T_UTF_16_ARMENIAN_CAPITAL_LETTER_BEN	0x0532
#define T_UTF_16_ARMENIAN_CAPITAL_LETTER_GIM	0x0533
#define T_UTF_16_ARMENIAN_CAPITAL_LETTER_DA	0x0534
#define T_UTF_16_ARMENIAN_CAPITAL_LETTER_ECH	0x0535
#define T_UTF_16_ARMENIAN_CAPITAL_LETTER_ZA	0x0536
#define T_UTF_16_ARMENIAN_CAPITAL_LETTER_EH	0x0537
#define T_UTF_16_ARMENIAN_CAPITAL_LETTER_ET	0x0538
#define T_UTF_16_ARMENIAN_CAPITAL_LETTER_TO	0x0539
#define T_UTF_16_ARMENIAN_CAPITAL_LETTER_ZHE	0x053A
#define T_UTF_16_ARMENIAN_CAPITAL_LETTER_INI	0x053B
#define T_UTF_16_ARMENIAN_CAPITAL_LETTER_LIWN	0x053C
#define T_UTF_16_ARMENIAN_CAPITAL_LETTER_XEH	0x053D
#define T_UTF_16_ARMENIAN_CAPITAL_LETTER_CA	0x053E
#define T_UTF_16_ARMENIAN_CAPITAL_LETTER_KEN	0x053F
#define T_UTF_16_ARMENIAN_CAPITAL_LETTER_HO	0x0540
#define T_UTF_16_ARMENIAN_CAPITAL_LETTER_JA	0x0541
#define T_UTF_16_ARMENIAN_CAPITAL_LETTER_GHAD	0x0542
#define T_UTF_16_ARMENIAN_CAPITAL_LETTER_CHEH	0x0543
#define T_UTF_16_ARMENIAN_CAPITAL_LETTER_MEN	0x0544
#define T_UTF_16_ARMENIAN_CAPITAL_LETTER_YI	0x0545
#define T_UTF_16_ARMENIAN_CAPITAL_LETTER_NOW	0x0546
#define T_UTF_16_ARMENIAN_CAPITAL_LETTER_SHA	0x0547
#define T_UTF_16_ARMENIAN_CAPITAL_LETTER_VO	0x0548
#define T_UTF_16_ARMENIAN_CAPITAL_LETTER_CHA	0x0549
#define T_UTF_16_ARMENIAN_CAPITAL_LETTER_PEH	0x054A
#define T_UTF_16_ARMENIAN_CAPITAL_LETTER_JHEH	0x054B
#define T_UTF_16_ARMENIAN_CAPITAL_LETTER_RA	0x054C
#define T_UTF_16_ARMENIAN_CAPITAL_LETTER_SEH	0x054D
#define T_UTF_16_ARMENIAN_CAPITAL_LETTER_VEW	0x054E
#define T_UTF_16_ARMENIAN_CAPITAL_LETTER_TIWN	0x054F
#define T_UTF_16_ARMENIAN_CAPITAL_LETTER_REH	0x0550
#define T_UTF_16_ARMENIAN_CAPITAL_LETTER_CO	0x0551
#define T_UTF_16_ARMENIAN_CAPITAL_LETTER_YIWN	0x0552
#define T_UTF_16_ARMENIAN_CAPITAL_LETTER_PIWR	0x0553
#define T_UTF_16_ARMENIAN_CAPITAL_LETTER_KEH	0x0554
#define T_UTF_16_ARMENIAN_CAPITAL_LETTER_OH	0x0555
#define T_UTF_16_ARMENIAN_CAPITAL_LETTER_FEH	0x0556
#define T_UTF_16_ARMENIAN_MODIFIER_LETTER_LEFT_HALF_RING	0x0559
#define T_UTF_16_ARMENIAN_APOSTROPHE	0x055A
#define T_UTF_16_ARMENIAN_EMPHASIS_MARK	0x055B
#define T_UTF_16_ARMENIAN_EXCLAMATION_MARK	0x055C
#define T_UTF_16_ARMENIAN_COMMA	0x055D
#define T_UTF_16_ARMENIAN_QUESTION_MARK	0x055E
#define T_UTF_16_ARMENIAN_ABBREVIATION_MARK	0x055F
#define T_UTF_16_ARMENIAN_SMALL_LETTER_AYB	0x0561
#define T_UTF_16_ARMENIAN_SMALL_LETTER_BEN	0x0562
#define T_UTF_16_ARMENIAN_SMALL_LETTER_GIM	0x0563
#define T_UTF_16_ARMENIAN_SMALL_LETTER_DA	0x0564
#define T_UTF_16_ARMENIAN_SMALL_LETTER_ECH	0x0565
#define T_UTF_16_ARMENIAN_SMALL_LETTER_ZA	0x0566
#define T_UTF_16_ARMENIAN_SMALL_LETTER_EH	0x0567
#define T_UTF_16_ARMENIAN_SMALL_LETTER_ET	0x0568
#define T_UTF_16_ARMENIAN_SMALL_LETTER_TO	0x0569
#define T_UTF_16_ARMENIAN_SMALL_LETTER_ZHE	0x056A
#define T_UTF_16_ARMENIAN_SMALL_LETTER_INI	0x056B
#define T_UTF_16_ARMENIAN_SMALL_LETTER_LIWN	0x056C
#define T_UTF_16_ARMENIAN_SMALL_LETTER_XEH	0x056D
#define T_UTF_16_ARMENIAN_SMALL_LETTER_CA	0x056E
#define T_UTF_16_ARMENIAN_SMALL_LETTER_KEN	0x056F
#define T_UTF_16_ARMENIAN_SMALL_LETTER_HO	0x0570
#define T_UTF_16_ARMENIAN_SMALL_LETTER_JA	0x0571
#define T_UTF_16_ARMENIAN_SMALL_LETTER_GHAD	0x0572
#define T_UTF_16_ARMENIAN_SMALL_LETTER_CHEH	0x0573
#define T_UTF_16_ARMENIAN_SMALL_LETTER_MEN	0x0574
#define T_UTF_16_ARMENIAN_SMALL_LETTER_YI	0x0575
#define T_UTF_16_ARMENIAN_SMALL_LETTER_NOW	0x0576
#define T_UTF_16_ARMENIAN_SMALL_LETTER_SHA	0x0577
#define T_UTF_16_ARMENIAN_SMALL_LETTER_VO	0x0578
#define T_UTF_16_ARMENIAN_SMALL_LETTER_CHA	0x0579
#define T_UTF_16_ARMENIAN_SMALL_LETTER_PEH	0x057A
#define T_UTF_16_ARMENIAN_SMALL_LETTER_JHEH	0x057B
#define T_UTF_16_ARMENIAN_SMALL_LETTER_RA	0x057C
#define T_UTF_16_ARMENIAN_SMALL_LETTER_SEH	0x057D
#define T_UTF_16_ARMENIAN_SMALL_LETTER_VEW	0x057E
#define T_UTF_16_ARMENIAN_SMALL_LETTER_TIWN	0x057F
#define T_UTF_16_ARMENIAN_SMALL_LETTER_REH	0x0580
#define T_UTF_16_ARMENIAN_SMALL_LETTER_CO	0x0581
#define T_UTF_16_ARMENIAN_SMALL_LETTER_YIWN	0x0582
#define T_UTF_16_ARMENIAN_SMALL_LETTER_PIWR	0x0583
#define T_UTF_16_ARMENIAN_SMALL_LETTER_KEH	0x0584
#define T_UTF_16_ARMENIAN_SMALL_LETTER_OH	0x0585
#define T_UTF_16_ARMENIAN_SMALL_LETTER_FEH	0x0586
#define T_UTF_16_ARMENIAN_SMALL_LIGATURE_ECH_YIWN	0x0587
#define T_UTF_16_ARMENIAN_FULL_STOP	0x0589
#define T_UTF_16_ARMENIAN_HYPHEN	0x058A
#define T_UTF_16_HEBREW_ACCENT_ETNAHTA	0x0591
#define T_UTF_16_HEBREW_ACCENT_SEGOL	0x0592
#define T_UTF_16_HEBREW_ACCENT_SHALSHELET	0x0593
#define T_UTF_16_HEBREW_ACCENT_ZAQEF_QATAN	0x0594
#define T_UTF_16_HEBREW_ACCENT_ZAQEF_GADOL	0x0595
#define T_UTF_16_HEBREW_ACCENT_TIPEHA	0x0596
#define T_UTF_16_HEBREW_ACCENT_REVIA	0x0597
#define T_UTF_16_HEBREW_ACCENT_ZARQA	0x0598
#define T_UTF_16_HEBREW_ACCENT_PASHTA	0x0599
#define T_UTF_16_HEBREW_ACCENT_YETIV	0x059A
#define T_UTF_16_HEBREW_ACCENT_TEVIR	0x059B
#define T_UTF_16_HEBREW_ACCENT_GERESH	0x059C
#define T_UTF_16_HEBREW_ACCENT_GERESH_MUQDAM	0x059D
#define T_UTF_16_HEBREW_ACCENT_GERSHAYIM	0x059E
#define T_UTF_16_HEBREW_ACCENT_QARNEY_PARA	0x059F
#define T_UTF_16_HEBREW_ACCENT_TELISHA_GEDOLA	0x05A0
#define T_UTF_16_HEBREW_ACCENT_PAZER	0x05A1
#define T_UTF_16_HEBREW_ACCENT_MUNAH	0x05A3
#define T_UTF_16_HEBREW_ACCENT_MAHAPAKH	0x05A4
#define T_UTF_16_HEBREW_ACCENT_MERKHA	0x05A5
#define T_UTF_16_HEBREW_ACCENT_MERKHA_KEFULA	0x05A6
#define T_UTF_16_HEBREW_ACCENT_DARGA	0x05A7
#define T_UTF_16_HEBREW_ACCENT_QADMA	0x05A8
#define T_UTF_16_HEBREW_ACCENT_TELISHA_QETANA	0x05A9
#define T_UTF_16_HEBREW_ACCENT_YERAH_BEN_YOMO	0x05AA
#define T_UTF_16_HEBREW_ACCENT_OLE	0x05AB
#define T_UTF_16_HEBREW_ACCENT_ILUY	0x05AC
#define T_UTF_16_HEBREW_ACCENT_DEHI	0x05AD
#define T_UTF_16_HEBREW_ACCENT_ZINOR	0x05AE
#define T_UTF_16_HEBREW_MARK_MASORA_CIRCLE	0x05AF
#define T_UTF_16_HEBREW_POINT_SHEVA	0x05B0
#define T_UTF_16_HEBREW_POINT_HATAF_SEGOL	0x05B1
#define T_UTF_16_HEBREW_POINT_HATAF_PATAH	0x05B2
#define T_UTF_16_HEBREW_POINT_HATAF_QAMATS	0x05B3
#define T_UTF_16_HEBREW_POINT_HIRIQ	0x05B4
#define T_UTF_16_HEBREW_POINT_TSERE	0x05B5
#define T_UTF_16_HEBREW_POINT_SEGOL	0x05B6
#define T_UTF_16_HEBREW_POINT_PATAH	0x05B7
#define T_UTF_16_HEBREW_POINT_QAMATS	0x05B8
#define T_UTF_16_HEBREW_POINT_HOLAM	0x05B9
#define T_UTF_16_HEBREW_POINT_QUBUTS	0x05BB
#define T_UTF_16_HEBREW_POINT_DAGESH_OR_MAPIQ	0x05BC
#define T_UTF_16_HEBREW_POINT_METEG	0x05BD
#define T_UTF_16_HEBREW_PUNCTUATION_MAQAF	0x05BE
#define T_UTF_16_HEBREW_POINT_RAFE	0x05BF
#define T_UTF_16_HEBREW_PUNCTUATION_PASEQ	0x05C0
#define T_UTF_16_HEBREW_POINT_SHIN_DOT	0x05C1
#define T_UTF_16_HEBREW_POINT_SIN_DOT	0x05C2
#define T_UTF_16_HEBREW_PUNCTUATION_SOF_PASUQ	0x05C3
#define T_UTF_16_HEBREW_MARK_UPPER_DOT	0x05C4
#define T_UTF_16_HEBREW_LETTER_ALEF	0x05D0
#define T_UTF_16_HEBREW_LETTER_BET	0x05D1
#define T_UTF_16_HEBREW_LETTER_GIMEL	0x05D2
#define T_UTF_16_HEBREW_LETTER_DALET	0x05D3
#define T_UTF_16_HEBREW_LETTER_HE	0x05D4
#define T_UTF_16_HEBREW_LETTER_VAV	0x05D5
#define T_UTF_16_HEBREW_LETTER_ZAYIN	0x05D6
#define T_UTF_16_HEBREW_LETTER_HET	0x05D7
#define T_UTF_16_HEBREW_LETTER_TET	0x05D8
#define T_UTF_16_HEBREW_LETTER_YOD	0x05D9
#define T_UTF_16_HEBREW_LETTER_FINAL_KAF	0x05DA
#define T_UTF_16_HEBREW_LETTER_KAF	0x05DB
#define T_UTF_16_HEBREW_LETTER_LAMED	0x05DC
#define T_UTF_16_HEBREW_LETTER_FINAL_MEM	0x05DD
#define T_UTF_16_HEBREW_LETTER_MEM	0x05DE
#define T_UTF_16_HEBREW_LETTER_FINAL_NUN	0x05DF
#define T_UTF_16_HEBREW_LETTER_NUN	0x05E0
#define T_UTF_16_HEBREW_LETTER_SAMEKH	0x05E1
#define T_UTF_16_HEBREW_LETTER_AYIN	0x05E2
#define T_UTF_16_HEBREW_LETTER_FINAL_PE	0x05E3
#define T_UTF_16_HEBREW_LETTER_PE	0x05E4
#define T_UTF_16_HEBREW_LETTER_FINAL_TSADI	0x05E5
#define T_UTF_16_HEBREW_LETTER_TSADI	0x05E6
#define T_UTF_16_HEBREW_LETTER_QOF	0x05E7
#define T_UTF_16_HEBREW_LETTER_RESH	0x05E8
#define T_UTF_16_HEBREW_LETTER_SHIN	0x05E9
#define T_UTF_16_HEBREW_LETTER_TAV	0x05EA
#define T_UTF_16_HEBREW_LIGATURE_YIDDISH_DOUBLE_VAV	0x05F0
#define T_UTF_16_HEBREW_LIGATURE_YIDDISH_VAV_YOD	0x05F1
#define T_UTF_16_HEBREW_LIGATURE_YIDDISH_DOUBLE_YOD	0x05F2
#define T_UTF_16_HEBREW_PUNCTUATION_GERESH	0x05F3
#define T_UTF_16_HEBREW_PUNCTUATION_GERSHAYIM	0x05F4
#define T_UTF_16_ARABIC_COMMA	0x060C
#define T_UTF_16_ARABIC_SEMICOLON	0x061B
#define T_UTF_16_ARABIC_QUESTION_MARK	0x061F
#define T_UTF_16_ARABIC_LETTER_HAMZA	0x0621
#define T_UTF_16_ARABIC_LETTER_ALEF_WITH_MADDA_ABOVE	0x0622
#define T_UTF_16_ARABIC_LETTER_ALEF_WITH_HAMZA_ABOVE	0x0623
#define T_UTF_16_ARABIC_LETTER_WAW_WITH_HAMZA_ABOVE	0x0624
#define T_UTF_16_ARABIC_LETTER_ALEF_WITH_HAMZA_BELOW	0x0625
#define T_UTF_16_ARABIC_LETTER_YEH_WITH_HAMZA_ABOVE	0x0626
#define T_UTF_16_ARABIC_LETTER_ALEF	0x0627
#define T_UTF_16_ARABIC_LETTER_BEH	0x0628
#define T_UTF_16_ARABIC_LETTER_TEH_MARBUTA	0x0629
#define T_UTF_16_ARABIC_LETTER_TEH	0x062A
#define T_UTF_16_ARABIC_LETTER_THEH	0x062B
#define T_UTF_16_ARABIC_LETTER_JEEM	0x062C
#define T_UTF_16_ARABIC_LETTER_HAH	0x062D
#define T_UTF_16_ARABIC_LETTER_KHAH	0x062E
#define T_UTF_16_ARABIC_LETTER_DAL	0x062F
#define T_UTF_16_ARABIC_LETTER_THAL	0x0630
#define T_UTF_16_ARABIC_LETTER_REH	0x0631
#define T_UTF_16_ARABIC_LETTER_ZAIN	0x0632
#define T_UTF_16_ARABIC_LETTER_SEEN	0x0633
#define T_UTF_16_ARABIC_LETTER_SHEEN	0x0634
#define T_UTF_16_ARABIC_LETTER_SAD	0x0635
#define T_UTF_16_ARABIC_LETTER_DAD	0x0636
#define T_UTF_16_ARABIC_LETTER_TAH	0x0637
#define T_UTF_16_ARABIC_LETTER_ZAH	0x0638
#define T_UTF_16_ARABIC_LETTER_AIN	0x0639
#define T_UTF_16_ARABIC_LETTER_GHAIN	0x063A
#define T_UTF_16_ARABIC_TATWEEL	0x0640
#define T_UTF_16_ARABIC_LETTER_FEH	0x0641
#define T_UTF_16_ARABIC_LETTER_QAF	0x0642
#define T_UTF_16_ARABIC_LETTER_KAF	0x0643
#define T_UTF_16_ARABIC_LETTER_LAM	0x0644
#define T_UTF_16_ARABIC_LETTER_MEEM	0x0645
#define T_UTF_16_ARABIC_LETTER_NOON	0x0646
#define T_UTF_16_ARABIC_LETTER_HEH	0x0647
#define T_UTF_16_ARABIC_LETTER_WAW	0x0648
#define T_UTF_16_ARABIC_LETTER_ALEF_MAKSURA	0x0649
#define T_UTF_16_ARABIC_LETTER_YEH	0x064A
#define T_UTF_16_ARABIC_FATHATAN	0x064B
#define T_UTF_16_ARABIC_DAMMATAN	0x064C
#define T_UTF_16_ARABIC_KASRATAN	0x064D
#define T_UTF_16_ARABIC_FATHA	0x064E
#define T_UTF_16_ARABIC_DAMMA	0x064F
#define T_UTF_16_ARABIC_KASRA	0x0650
#define T_UTF_16_ARABIC_SHADDA	0x0651
#define T_UTF_16_ARABIC_SUKUN	0x0652
#define T_UTF_16_ARABIC_MADDAH_ABOVE	0x0653
#define T_UTF_16_ARABIC_HAMZA_ABOVE	0x0654
#define T_UTF_16_ARABIC_HAMZA_BELOW	0x0655
#define T_UTF_16_ARABIC_INDIC_DIGIT_ZERO	0x0660
#define T_UTF_16_ARABIC_INDIC_DIGIT_ONE	0x0661
#define T_UTF_16_ARABIC_INDIC_DIGIT_TWO	0x0662
#define T_UTF_16_ARABIC_INDIC_DIGIT_THREE	0x0663
#define T_UTF_16_ARABIC_INDIC_DIGIT_FOUR	0x0664
#define T_UTF_16_ARABIC_INDIC_DIGIT_FIVE	0x0665
#define T_UTF_16_ARABIC_INDIC_DIGIT_SIX	0x0666
#define T_UTF_16_ARABIC_INDIC_DIGIT_SEVEN	0x0667
#define T_UTF_16_ARABIC_INDIC_DIGIT_EIGHT	0x0668
#define T_UTF_16_ARABIC_INDIC_DIGIT_NINE	0x0669
#define T_UTF_16_ARABIC_PERCENT_SIGN	0x066A
#define T_UTF_16_ARABIC_DECIMAL_SEPARATOR	0x066B
#define T_UTF_16_ARABIC_THOUSANDS_SEPARATOR	0x066C
#define T_UTF_16_ARABIC_FIVE_POINTED_STAR	0x066D
#define T_UTF_16_ARABIC_LETTER_SUPERSCRIPT_ALEF	0x0670
#define T_UTF_16_ARABIC_LETTER_ALEF_WASLA	0x0671
#define T_UTF_16_ARABIC_LETTER_ALEF_WITH_WAVY_HAMZA_ABOVE	0x0672
#define T_UTF_16_ARABIC_LETTER_ALEF_WITH_WAVY_HAMZA_BELOW	0x0673
#define T_UTF_16_ARABIC_LETTER_HIGH_HAMZA	0x0674
#define T_UTF_16_ARABIC_LETTER_HIGH_HAMZA_ALEF	0x0675
#define T_UTF_16_ARABIC_LETTER_HIGH_HAMZA_WAW	0x0676
#define T_UTF_16_ARABIC_LETTER_U_WITH_HAMZA_ABOVE	0x0677
#define T_UTF_16_ARABIC_LETTER_HIGH_HAMZA_YEH	0x0678
#define T_UTF_16_ARABIC_LETTER_TTEH	0x0679
#define T_UTF_16_ARABIC_LETTER_TTEHEH	0x067A
#define T_UTF_16_ARABIC_LETTER_BEEH	0x067B
#define T_UTF_16_ARABIC_LETTER_TEH_WITH_RING	0x067C
#define T_UTF_16_ARABIC_LETTER_TEH_WITH_THREE_DOTS_ABOVE_DOWNWARDS	0x067D
#define T_UTF_16_ARABIC_LETTER_PEH	0x067E
#define T_UTF_16_ARABIC_LETTER_TEHEH	0x067F
#define T_UTF_16_ARABIC_LETTER_BEHEH	0x0680
#define T_UTF_16_ARABIC_LETTER_HAH_WITH_HAMZA_ABOVE	0x0681
#define T_UTF_16_ARABIC_LETTER_HAH_WITH_TWO_DOTS_VERTICAL_ABOVE	0x0682
#define T_UTF_16_ARABIC_LETTER_NYEH	0x0683
#define T_UTF_16_ARABIC_LETTER_DYEH	0x0684
#define T_UTF_16_ARABIC_LETTER_HAH_WITH_THREE_DOTS_ABOVE	0x0685
#define T_UTF_16_ARABIC_LETTER_TCHEH	0x0686
#define T_UTF_16_ARABIC_LETTER_TCHEHEH	0x0687
#define T_UTF_16_ARABIC_LETTER_DDAL	0x0688
#define T_UTF_16_ARABIC_LETTER_DAL_WITH_RING	0x0689
#define T_UTF_16_ARABIC_LETTER_DAL_WITH_DOT_BELOW	0x068A
#define T_UTF_16_ARABIC_LETTER_DAL_WITH_DOT_BELOW_AND_SMALL_TAH	0x068B
#define T_UTF_16_ARABIC_LETTER_DAHAL	0x068C
#define T_UTF_16_ARABIC_LETTER_DDAHAL	0x068D
#define T_UTF_16_ARABIC_LETTER_DUL	0x068E
#define T_UTF_16_ARABIC_LETTER_DAL_WITH_THREE_DOTS_ABOVE_DOWNWARDS	0x068F
#define T_UTF_16_ARABIC_LETTER_DAL_WITH_FOUR_DOTS_ABOVE	0x0690
#define T_UTF_16_ARABIC_LETTER_RREH	0x0691
#define T_UTF_16_ARABIC_LETTER_REH_WITH_SMALL_V	0x0692
#define T_UTF_16_ARABIC_LETTER_REH_WITH_RING	0x0693
#define T_UTF_16_ARABIC_LETTER_REH_WITH_DOT_BELOW	0x0694
#define T_UTF_16_ARABIC_LETTER_REH_WITH_SMALL_V_BELOW	0x0695
#define T_UTF_16_ARABIC_LETTER_REH_WITH_DOT_BELOW_AND_DOT_ABOVE	0x0696
#define T_UTF_16_ARABIC_LETTER_REH_WITH_TWO_DOTS_ABOVE	0x0697
#define T_UTF_16_ARABIC_LETTER_JEH	0x0698
#define T_UTF_16_ARABIC_LETTER_REH_WITH_FOUR_DOTS_ABOVE	0x0699
#define T_UTF_16_ARABIC_LETTER_SEEN_WITH_DOT_BELOW_AND_DOT_ABOVE	0x069A
#define T_UTF_16_ARABIC_LETTER_SEEN_WITH_THREE_DOTS_BELOW	0x069B
#define T_UTF_16_ARABIC_LETTER_SEEN_WITH_THREE_DOTS_BELOW_AND_THREE_DOTS_ABOVE	0x069C
#define T_UTF_16_ARABIC_LETTER_SAD_WITH_TWO_DOTS_BELOW	0x069D
#define T_UTF_16_ARABIC_LETTER_SAD_WITH_THREE_DOTS_ABOVE	0x069E
#define T_UTF_16_ARABIC_LETTER_TAH_WITH_THREE_DOTS_ABOVE	0x069F
#define T_UTF_16_ARABIC_LETTER_AIN_WITH_THREE_DOTS_ABOVE	0x06A0
#define T_UTF_16_ARABIC_LETTER_DOTLESS_FEH	0x06A1
#define T_UTF_16_ARABIC_LETTER_FEH_WITH_DOT_MOVED_BELOW	0x06A2
#define T_UTF_16_ARABIC_LETTER_FEH_WITH_DOT_BELOW	0x06A3
#define T_UTF_16_ARABIC_LETTER_VEH	0x06A4
#define T_UTF_16_ARABIC_LETTER_FEH_WITH_THREE_DOTS_BELOW	0x06A5
#define T_UTF_16_ARABIC_LETTER_PEHEH	0x06A6
#define T_UTF_16_ARABIC_LETTER_QAF_WITH_DOT_ABOVE	0x06A7
#define T_UTF_16_ARABIC_LETTER_QAF_WITH_THREE_DOTS_ABOVE	0x06A8
#define T_UTF_16_ARABIC_LETTER_KEHEH	0x06A9
#define T_UTF_16_ARABIC_LETTER_SWASH_KAF	0x06AA
#define T_UTF_16_ARABIC_LETTER_KAF_WITH_RING	0x06AB
#define T_UTF_16_ARABIC_LETTER_KAF_WITH_DOT_ABOVE	0x06AC
#define T_UTF_16_ARABIC_LETTER_NG	0x06AD
#define T_UTF_16_ARABIC_LETTER_KAF_WITH_THREE_DOTS_BELOW	0x06AE
#define T_UTF_16_ARABIC_LETTER_GAF	0x06AF
#define T_UTF_16_ARABIC_LETTER_GAF_WITH_RING	0x06B0
#define T_UTF_16_ARABIC_LETTER_NGOEH	0x06B1
#define T_UTF_16_ARABIC_LETTER_GAF_WITH_TWO_DOTS_BELOW	0x06B2
#define T_UTF_16_ARABIC_LETTER_GUEH	0x06B3
#define T_UTF_16_ARABIC_LETTER_GAF_WITH_THREE_DOTS_ABOVE	0x06B4
#define T_UTF_16_ARABIC_LETTER_LAM_WITH_SMALL_V	0x06B5
#define T_UTF_16_ARABIC_LETTER_LAM_WITH_DOT_ABOVE	0x06B6
#define T_UTF_16_ARABIC_LETTER_LAM_WITH_THREE_DOTS_ABOVE	0x06B7
#define T_UTF_16_ARABIC_LETTER_LAM_WITH_THREE_DOTS_BELOW	0x06B8
#define T_UTF_16_ARABIC_LETTER_NOON_WITH_DOT_BELOW	0x06B9
#define T_UTF_16_ARABIC_LETTER_NOON_GHUNNA	0x06BA
#define T_UTF_16_ARABIC_LETTER_RNOON	0x06BB
#define T_UTF_16_ARABIC_LETTER_NOON_WITH_RING	0x06BC
#define T_UTF_16_ARABIC_LETTER_NOON_WITH_THREE_DOTS_ABOVE	0x06BD
#define T_UTF_16_ARABIC_LETTER_HEH_DOACHASHMEE	0x06BE
#define T_UTF_16_ARABIC_LETTER_TCHEH_WITH_DOT_ABOVE	0x06BF
#define T_UTF_16_ARABIC_LETTER_HEH_WITH_YEH_ABOVE	0x06C0
#define T_UTF_16_ARABIC_LETTER_HEH_GOAL	0x06C1
#define T_UTF_16_ARABIC_LETTER_HEH_GOAL_WITH_HAMZA_ABOVE	0x06C2
#define T_UTF_16_ARABIC_LETTER_TEH_MARBUTA_GOAL	0x06C3
#define T_UTF_16_ARABIC_LETTER_WAW_WITH_RING	0x06C4
#define T_UTF_16_ARABIC_LETTER_KIRGHIZ_OE	0x06C5
#define T_UTF_16_ARABIC_LETTER_OE	0x06C6
#define T_UTF_16_ARABIC_LETTER_U	0x06C7
#define T_UTF_16_ARABIC_LETTER_YU	0x06C8
#define T_UTF_16_ARABIC_LETTER_KIRGHIZ_YU	0x06C9
#define T_UTF_16_ARABIC_LETTER_WAW_WITH_TWO_DOTS_ABOVE	0x06CA
#define T_UTF_16_ARABIC_LETTER_VE	0x06CB
#define T_UTF_16_ARABIC_LETTER_FARSI_YEH	0x06CC
#define T_UTF_16_ARABIC_LETTER_YEH_WITH_TAIL	0x06CD
#define T_UTF_16_ARABIC_LETTER_YEH_WITH_SMALL_V	0x06CE
#define T_UTF_16_ARABIC_LETTER_WAW_WITH_DOT_ABOVE	0x06CF
#define T_UTF_16_ARABIC_LETTER_E	0x06D0
#define T_UTF_16_ARABIC_LETTER_YEH_WITH_THREE_DOTS_BELOW	0x06D1
#define T_UTF_16_ARABIC_LETTER_YEH_BARREE	0x06D2
#define T_UTF_16_ARABIC_LETTER_YEH_BARREE_WITH_HAMZA_ABOVE	0x06D3
#define T_UTF_16_ARABIC_FULL_STOP	0x06D4
#define T_UTF_16_ARABIC_LETTER_AE	0x06D5
#define T_UTF_16_ARABIC_SMALL_HIGH_LIGATURE_SAD_WITH_LAM_WITH_ALEF_MAKSURA	0x06D6
#define T_UTF_16_ARABIC_SMALL_HIGH_LIGATURE_QAF_WITH_LAM_WITH_ALEF_MAKSURA	0x06D7
#define T_UTF_16_ARABIC_SMALL_HIGH_MEEM_INITIAL_FORM	0x06D8
#define T_UTF_16_ARABIC_SMALL_HIGH_LAM_ALEF	0x06D9
#define T_UTF_16_ARABIC_SMALL_HIGH_JEEM	0x06DA
#define T_UTF_16_ARABIC_SMALL_HIGH_THREE_DOTS	0x06DB
#define T_UTF_16_ARABIC_SMALL_HIGH_SEEN	0x06DC
#define T_UTF_16_ARABIC_END_OF_AYAH	0x06DD
#define T_UTF_16_ARABIC_START_OF_RUB_EL_HIZB	0x06DE
#define T_UTF_16_ARABIC_SMALL_HIGH_ROUNDED_ZERO	0x06DF
#define T_UTF_16_ARABIC_SMALL_HIGH_UPRIGHT_RECTANGULAR_ZERO	0x06E0
#define T_UTF_16_ARABIC_SMALL_HIGH_DOTLESS_HEAD_OF_KHAH	0x06E1
#define T_UTF_16_ARABIC_SMALL_HIGH_MEEM_ISOLATED_FORM	0x06E2
#define T_UTF_16_ARABIC_SMALL_LOW_SEEN	0x06E3
#define T_UTF_16_ARABIC_SMALL_HIGH_MADDA	0x06E4
#define T_UTF_16_ARABIC_SMALL_WAW	0x06E5
#define T_UTF_16_ARABIC_SMALL_YEH	0x06E6
#define T_UTF_16_ARABIC_SMALL_HIGH_YEH	0x06E7
#define T_UTF_16_ARABIC_SMALL_HIGH_NOON	0x06E8
#define T_UTF_16_ARABIC_PLACE_OF_SAJDAH	0x06E9
#define T_UTF_16_ARABIC_EMPTY_CENTRE_LOW_STOP	0x06EA
#define T_UTF_16_ARABIC_EMPTY_CENTRE_HIGH_STOP	0x06EB
#define T_UTF_16_ARABIC_ROUNDED_HIGH_STOP_WITH_FILLED_CENTRE	0x06EC
#define T_UTF_16_ARABIC_SMALL_LOW_MEEM	0x06ED
#define T_UTF_16_EXTENDED_ARABIC_INDIC_DIGIT_ZERO	0x06F0
#define T_UTF_16_EXTENDED_ARABIC_INDIC_DIGIT_ONE	0x06F1
#define T_UTF_16_EXTENDED_ARABIC_INDIC_DIGIT_TWO	0x06F2
#define T_UTF_16_EXTENDED_ARABIC_INDIC_DIGIT_THREE	0x06F3
#define T_UTF_16_EXTENDED_ARABIC_INDIC_DIGIT_FOUR	0x06F4
#define T_UTF_16_EXTENDED_ARABIC_INDIC_DIGIT_FIVE	0x06F5
#define T_UTF_16_EXTENDED_ARABIC_INDIC_DIGIT_SIX	0x06F6
#define T_UTF_16_EXTENDED_ARABIC_INDIC_DIGIT_SEVEN	0x06F7
#define T_UTF_16_EXTENDED_ARABIC_INDIC_DIGIT_EIGHT	0x06F8
#define T_UTF_16_EXTENDED_ARABIC_INDIC_DIGIT_NINE	0x06F9
#define T_UTF_16_ARABIC_LETTER_SHEEN_WITH_DOT_BELOW	0x06FA
#define T_UTF_16_ARABIC_LETTER_DAD_WITH_DOT_BELOW	0x06FB
#define T_UTF_16_ARABIC_LETTER_GHAIN_WITH_DOT_BELOW	0x06FC
#define T_UTF_16_ARABIC_SIGN_SINDHI_AMPERSAND	0x06FD
#define T_UTF_16_ARABIC_SIGN_SINDHI_POSTPOSITION_MEN	0x06FE
#define T_UTF_16_SYRIAC_END_OF_PARAGRAPH	0x0700
#define T_UTF_16_SYRIAC_SUPRALINEAR_FULL_STOP	0x0701
#define T_UTF_16_SYRIAC_SUBLINEAR_FULL_STOP	0x0702
#define T_UTF_16_SYRIAC_SUPRALINEAR_COLON	0x0703
#define T_UTF_16_SYRIAC_SUBLINEAR_COLON	0x0704
#define T_UTF_16_SYRIAC_HORIZONTAL_COLON	0x0705
#define T_UTF_16_SYRIAC_COLON_SKEWED_LEFT	0x0706
#define T_UTF_16_SYRIAC_COLON_SKEWED_RIGHT	0x0707
#define T_UTF_16_SYRIAC_SUPRALINEAR_COLON_SKEWED_LEFT	0x0708
#define T_UTF_16_SYRIAC_SUBLINEAR_COLON_SKEWED_RIGHT	0x0709
#define T_UTF_16_SYRIAC_CONTRACTION	0x070A
#define T_UTF_16_SYRIAC_HARKLEAN_OBELUS	0x070B
#define T_UTF_16_SYRIAC_HARKLEAN_METOBELUS	0x070C
#define T_UTF_16_SYRIAC_HARKLEAN_ASTERISCUS	0x070D
#define T_UTF_16_SYRIAC_ABBREVIATION_MARK	0x070F
#define T_UTF_16_SYRIAC_LETTER_ALAPH	0x0710
#define T_UTF_16_SYRIAC_LETTER_SUPERSCRIPT_ALAPH	0x0711
#define T_UTF_16_SYRIAC_LETTER_BETH	0x0712
#define T_UTF_16_SYRIAC_LETTER_GAMAL	0x0713
#define T_UTF_16_SYRIAC_LETTER_GAMAL_GARSHUNI	0x0714
#define T_UTF_16_SYRIAC_LETTER_DALATH	0x0715
#define T_UTF_16_SYRIAC_LETTER_DOTLESS_DALATH_RISH	0x0716
#define T_UTF_16_SYRIAC_LETTER_HE	0x0717
#define T_UTF_16_SYRIAC_LETTER_WAW	0x0718
#define T_UTF_16_SYRIAC_LETTER_ZAIN	0x0719
#define T_UTF_16_SYRIAC_LETTER_HETH	0x071A
#define T_UTF_16_SYRIAC_LETTER_TETH	0x071B
#define T_UTF_16_SYRIAC_LETTER_TETH_GARSHUNI	0x071C
#define T_UTF_16_SYRIAC_LETTER_YUDH	0x071D
#define T_UTF_16_SYRIAC_LETTER_YUDH_HE	0x071E
#define T_UTF_16_SYRIAC_LETTER_KAPH	0x071F
#define T_UTF_16_SYRIAC_LETTER_LAMADH	0x0720
#define T_UTF_16_SYRIAC_LETTER_MIM	0x0721
#define T_UTF_16_SYRIAC_LETTER_NUN	0x0722
#define T_UTF_16_SYRIAC_LETTER_SEMKATH	0x0723
#define T_UTF_16_SYRIAC_LETTER_FINAL_SEMKATH	0x0724
#define T_UTF_16_SYRIAC_LETTER_E	0x0725
#define T_UTF_16_SYRIAC_LETTER_PE	0x0726
#define T_UTF_16_SYRIAC_LETTER_REVERSED_PE	0x0727
#define T_UTF_16_SYRIAC_LETTER_SADHE	0x0728
#define T_UTF_16_SYRIAC_LETTER_QAPH	0x0729
#define T_UTF_16_SYRIAC_LETTER_RISH	0x072A
#define T_UTF_16_SYRIAC_LETTER_SHIN	0x072B
#define T_UTF_16_SYRIAC_LETTER_TAW	0x072C
#define T_UTF_16_SYRIAC_PTHAHA_ABOVE	0x0730
#define T_UTF_16_SYRIAC_PTHAHA_BELOW	0x0731
#define T_UTF_16_SYRIAC_PTHAHA_DOTTED	0x0732
#define T_UTF_16_SYRIAC_ZQAPHA_ABOVE	0x0733
#define T_UTF_16_SYRIAC_ZQAPHA_BELOW	0x0734
#define T_UTF_16_SYRIAC_ZQAPHA_DOTTED	0x0735
#define T_UTF_16_SYRIAC_RBASA_ABOVE	0x0736
#define T_UTF_16_SYRIAC_RBASA_BELOW	0x0737
#define T_UTF_16_SYRIAC_DOTTED_ZLAMA_HORIZONTAL	0x0738
#define T_UTF_16_SYRIAC_DOTTED_ZLAMA_ANGULAR	0x0739
#define T_UTF_16_SYRIAC_HBASA_ABOVE	0x073A
#define T_UTF_16_SYRIAC_HBASA_BELOW	0x073B
#define T_UTF_16_SYRIAC_HBASA_ESASA_DOTTED	0x073C
#define T_UTF_16_SYRIAC_ESASA_ABOVE	0x073D
#define T_UTF_16_SYRIAC_ESASA_BELOW	0x073E
#define T_UTF_16_SYRIAC_RWAHA	0x073F
#define T_UTF_16_SYRIAC_FEMININE_DOT	0x0740
#define T_UTF_16_SYRIAC_QUSHSHAYA	0x0741
#define T_UTF_16_SYRIAC_RUKKAKHA	0x0742
#define T_UTF_16_SYRIAC_TWO_VERTICAL_DOTS_ABOVE	0x0743
#define T_UTF_16_SYRIAC_TWO_VERTICAL_DOTS_BELOW	0x0744
#define T_UTF_16_SYRIAC_THREE_DOTS_ABOVE	0x0745
#define T_UTF_16_SYRIAC_THREE_DOTS_BELOW	0x0746
#define T_UTF_16_SYRIAC_OBLIQUE_LINE_ABOVE	0x0747
#define T_UTF_16_SYRIAC_OBLIQUE_LINE_BELOW	0x0748
#define T_UTF_16_SYRIAC_MUSIC	0x0749
#define T_UTF_16_SYRIAC_BARREKH	0x074A
#define T_UTF_16_THAANA_LETTER_HAA	0x0780
#define T_UTF_16_THAANA_LETTER_SHAVIYANI	0x0781
#define T_UTF_16_THAANA_LETTER_NOONU	0x0782
#define T_UTF_16_THAANA_LETTER_RAA	0x0783
#define T_UTF_16_THAANA_LETTER_BAA	0x0784
#define T_UTF_16_THAANA_LETTER_LHAVIYANI	0x0785
#define T_UTF_16_THAANA_LETTER_KAAFU	0x0786
#define T_UTF_16_THAANA_LETTER_ALIFU	0x0787
#define T_UTF_16_THAANA_LETTER_VAAVU	0x0788
#define T_UTF_16_THAANA_LETTER_MEEMU	0x0789
#define T_UTF_16_THAANA_LETTER_FAAFU	0x078A
#define T_UTF_16_THAANA_LETTER_DHAALU	0x078B
#define T_UTF_16_THAANA_LETTER_THAA	0x078C
#define T_UTF_16_THAANA_LETTER_LAAMU	0x078D
#define T_UTF_16_THAANA_LETTER_GAAFU	0x078E
#define T_UTF_16_THAANA_LETTER_GNAVIYANI	0x078F
#define T_UTF_16_THAANA_LETTER_SEENU	0x0790
#define T_UTF_16_THAANA_LETTER_DAVIYANI	0x0791
#define T_UTF_16_THAANA_LETTER_ZAVIYANI	0x0792
#define T_UTF_16_THAANA_LETTER_TAVIYANI	0x0793
#define T_UTF_16_THAANA_LETTER_YAA	0x0794
#define T_UTF_16_THAANA_LETTER_PAVIYANI	0x0795
#define T_UTF_16_THAANA_LETTER_JAVIYANI	0x0796
#define T_UTF_16_THAANA_LETTER_CHAVIYANI	0x0797
#define T_UTF_16_THAANA_LETTER_TTAA	0x0798
#define T_UTF_16_THAANA_LETTER_HHAA	0x0799
#define T_UTF_16_THAANA_LETTER_KHAA	0x079A
#define T_UTF_16_THAANA_LETTER_THAALU	0x079B
#define T_UTF_16_THAANA_LETTER_ZAA	0x079C
#define T_UTF_16_THAANA_LETTER_SHEENU	0x079D
#define T_UTF_16_THAANA_LETTER_SAADHU	0x079E
#define T_UTF_16_THAANA_LETTER_DAADHU	0x079F
#define T_UTF_16_THAANA_LETTER_TO	0x07A0
#define T_UTF_16_THAANA_LETTER_ZO	0x07A1
#define T_UTF_16_THAANA_LETTER_AINU	0x07A2
#define T_UTF_16_THAANA_LETTER_GHAINU	0x07A3
#define T_UTF_16_THAANA_LETTER_QAAFU	0x07A4
#define T_UTF_16_THAANA_LETTER_WAAVU	0x07A5
#define T_UTF_16_THAANA_ABAFILI	0x07A6
#define T_UTF_16_THAANA_AABAAFILI	0x07A7
#define T_UTF_16_THAANA_IBIFILI	0x07A8
#define T_UTF_16_THAANA_EEBEEFILI	0x07A9
#define T_UTF_16_THAANA_UBUFILI	0x07AA
#define T_UTF_16_THAANA_OOBOOFILI	0x07AB
#define T_UTF_16_THAANA_EBEFILI	0x07AC
#define T_UTF_16_THAANA_EYBEYFILI	0x07AD
#define T_UTF_16_THAANA_OBOFILI	0x07AE
#define T_UTF_16_THAANA_OABOAFILI	0x07AF
#define T_UTF_16_THAANA_SUKUN	0x07B0
#define T_UTF_16_DEVANAGARI_SIGN_CANDRABINDU	0x0901
#define T_UTF_16_DEVANAGARI_SIGN_ANUSVARA	0x0902
#define T_UTF_16_DEVANAGARI_SIGN_VISARGA	0x0903
#define T_UTF_16_DEVANAGARI_LETTER_A	0x0905
#define T_UTF_16_DEVANAGARI_LETTER_AA	0x0906
#define T_UTF_16_DEVANAGARI_LETTER_I	0x0907
#define T_UTF_16_DEVANAGARI_LETTER_II	0x0908
#define T_UTF_16_DEVANAGARI_LETTER_U	0x0909
#define T_UTF_16_DEVANAGARI_LETTER_UU	0x090A
#define T_UTF_16_DEVANAGARI_LETTER_VOCALIC_R	0x090B
#define T_UTF_16_DEVANAGARI_LETTER_VOCALIC_L	0x090C
#define T_UTF_16_DEVANAGARI_LETTER_CANDRA_E	0x090D
#define T_UTF_16_DEVANAGARI_LETTER_SHORT_E	0x090E
#define T_UTF_16_DEVANAGARI_LETTER_E	0x090F
#define T_UTF_16_DEVANAGARI_LETTER_AI	0x0910
#define T_UTF_16_DEVANAGARI_LETTER_CANDRA_O	0x0911
#define T_UTF_16_DEVANAGARI_LETTER_SHORT_O	0x0912
#define T_UTF_16_DEVANAGARI_LETTER_O	0x0913
#define T_UTF_16_DEVANAGARI_LETTER_AU	0x0914
#define T_UTF_16_DEVANAGARI_LETTER_KA	0x0915
#define T_UTF_16_DEVANAGARI_LETTER_KHA	0x0916
#define T_UTF_16_DEVANAGARI_LETTER_GA	0x0917
#define T_UTF_16_DEVANAGARI_LETTER_GHA	0x0918
#define T_UTF_16_DEVANAGARI_LETTER_NGA	0x0919
#define T_UTF_16_DEVANAGARI_LETTER_CA	0x091A
#define T_UTF_16_DEVANAGARI_LETTER_CHA	0x091B
#define T_UTF_16_DEVANAGARI_LETTER_JA	0x091C
#define T_UTF_16_DEVANAGARI_LETTER_JHA	0x091D
#define T_UTF_16_DEVANAGARI_LETTER_NYA	0x091E
#define T_UTF_16_DEVANAGARI_LETTER_TTA	0x091F
#define T_UTF_16_DEVANAGARI_LETTER_TTHA	0x0920
#define T_UTF_16_DEVANAGARI_LETTER_DDA	0x0921
#define T_UTF_16_DEVANAGARI_LETTER_DDHA	0x0922
#define T_UTF_16_DEVANAGARI_LETTER_NNA	0x0923
#define T_UTF_16_DEVANAGARI_LETTER_TA	0x0924
#define T_UTF_16_DEVANAGARI_LETTER_THA	0x0925
#define T_UTF_16_DEVANAGARI_LETTER_DA	0x0926
#define T_UTF_16_DEVANAGARI_LETTER_DHA	0x0927
#define T_UTF_16_DEVANAGARI_LETTER_NA	0x0928
#define T_UTF_16_DEVANAGARI_LETTER_NNNA	0x0929
#define T_UTF_16_DEVANAGARI_LETTER_PA	0x092A
#define T_UTF_16_DEVANAGARI_LETTER_PHA	0x092B
#define T_UTF_16_DEVANAGARI_LETTER_BA	0x092C
#define T_UTF_16_DEVANAGARI_LETTER_BHA	0x092D
#define T_UTF_16_DEVANAGARI_LETTER_MA	0x092E
#define T_UTF_16_DEVANAGARI_LETTER_YA	0x092F
#define T_UTF_16_DEVANAGARI_LETTER_RA	0x0930
#define T_UTF_16_DEVANAGARI_LETTER_RRA	0x0931
#define T_UTF_16_DEVANAGARI_LETTER_LA	0x0932
#define T_UTF_16_DEVANAGARI_LETTER_LLA	0x0933
#define T_UTF_16_DEVANAGARI_LETTER_LLLA	0x0934
#define T_UTF_16_DEVANAGARI_LETTER_VA	0x0935
#define T_UTF_16_DEVANAGARI_LETTER_SHA	0x0936
#define T_UTF_16_DEVANAGARI_LETTER_SSA	0x0937
#define T_UTF_16_DEVANAGARI_LETTER_SA	0x0938
#define T_UTF_16_DEVANAGARI_LETTER_HA	0x0939
#define T_UTF_16_DEVANAGARI_SIGN_NUKTA	0x093C
#define T_UTF_16_DEVANAGARI_SIGN_AVAGRAHA	0x093D
#define T_UTF_16_DEVANAGARI_VOWEL_SIGN_AA	0x093E
#define T_UTF_16_DEVANAGARI_VOWEL_SIGN_I	0x093F
#define T_UTF_16_DEVANAGARI_VOWEL_SIGN_II	0x0940
#define T_UTF_16_DEVANAGARI_VOWEL_SIGN_U	0x0941
#define T_UTF_16_DEVANAGARI_VOWEL_SIGN_UU	0x0942
#define T_UTF_16_DEVANAGARI_VOWEL_SIGN_VOCALIC_R	0x0943
#define T_UTF_16_DEVANAGARI_VOWEL_SIGN_VOCALIC_RR	0x0944
#define T_UTF_16_DEVANAGARI_VOWEL_SIGN_CANDRA_E	0x0945
#define T_UTF_16_DEVANAGARI_VOWEL_SIGN_SHORT_E	0x0946
#define T_UTF_16_DEVANAGARI_VOWEL_SIGN_E	0x0947
#define T_UTF_16_DEVANAGARI_VOWEL_SIGN_AI	0x0948
#define T_UTF_16_DEVANAGARI_VOWEL_SIGN_CANDRA_O	0x0949
#define T_UTF_16_DEVANAGARI_VOWEL_SIGN_SHORT_O	0x094A
#define T_UTF_16_DEVANAGARI_VOWEL_SIGN_O	0x094B
#define T_UTF_16_DEVANAGARI_VOWEL_SIGN_AU	0x094C
#define T_UTF_16_DEVANAGARI_SIGN_VIRAMA	0x094D
#define T_UTF_16_DEVANAGARI_OM	0x0950
#define T_UTF_16_DEVANAGARI_STRESS_SIGN_UDATTA	0x0951
#define T_UTF_16_DEVANAGARI_STRESS_SIGN_ANUDATTA	0x0952
#define T_UTF_16_DEVANAGARI_GRAVE_ACCENT	0x0953
#define T_UTF_16_DEVANAGARI_ACUTE_ACCENT	0x0954
#define T_UTF_16_DEVANAGARI_LETTER_QA	0x0958
#define T_UTF_16_DEVANAGARI_LETTER_KHHA	0x0959
#define T_UTF_16_DEVANAGARI_LETTER_GHHA	0x095A
#define T_UTF_16_DEVANAGARI_LETTER_ZA	0x095B
#define T_UTF_16_DEVANAGARI_LETTER_DDDHA	0x095C
#define T_UTF_16_DEVANAGARI_LETTER_RHA	0x095D
#define T_UTF_16_DEVANAGARI_LETTER_FA	0x095E
#define T_UTF_16_DEVANAGARI_LETTER_YYA	0x095F
#define T_UTF_16_DEVANAGARI_LETTER_VOCALIC_RR	0x0960
#define T_UTF_16_DEVANAGARI_LETTER_VOCALIC_LL	0x0961
#define T_UTF_16_DEVANAGARI_VOWEL_SIGN_VOCALIC_L	0x0962
#define T_UTF_16_DEVANAGARI_VOWEL_SIGN_VOCALIC_LL	0x0963
#define T_UTF_16_DEVANAGARI_DANDA	0x0964
#define T_UTF_16_DEVANAGARI_DOUBLE_DANDA	0x0965
#define T_UTF_16_DEVANAGARI_DIGIT_ZERO	0x0966
#define T_UTF_16_DEVANAGARI_DIGIT_ONE	0x0967
#define T_UTF_16_DEVANAGARI_DIGIT_TWO	0x0968
#define T_UTF_16_DEVANAGARI_DIGIT_THREE	0x0969
#define T_UTF_16_DEVANAGARI_DIGIT_FOUR	0x096A
#define T_UTF_16_DEVANAGARI_DIGIT_FIVE	0x096B
#define T_UTF_16_DEVANAGARI_DIGIT_SIX	0x096C
#define T_UTF_16_DEVANAGARI_DIGIT_SEVEN	0x096D
#define T_UTF_16_DEVANAGARI_DIGIT_EIGHT	0x096E
#define T_UTF_16_DEVANAGARI_DIGIT_NINE	0x096F
#define T_UTF_16_DEVANAGARI_ABBREVIATION_SIGN	0x0970
#define T_UTF_16_BENGALI_SIGN_CANDRABINDU	0x0981
#define T_UTF_16_BENGALI_SIGN_ANUSVARA	0x0982
#define T_UTF_16_BENGALI_SIGN_VISARGA	0x0983
#define T_UTF_16_BENGALI_LETTER_A	0x0985
#define T_UTF_16_BENGALI_LETTER_AA	0x0986
#define T_UTF_16_BENGALI_LETTER_I	0x0987
#define T_UTF_16_BENGALI_LETTER_II	0x0988
#define T_UTF_16_BENGALI_LETTER_U	0x0989
#define T_UTF_16_BENGALI_LETTER_UU	0x098A
#define T_UTF_16_BENGALI_LETTER_VOCALIC_R	0x098B
#define T_UTF_16_BENGALI_LETTER_VOCALIC_L	0x098C
#define T_UTF_16_BENGALI_LETTER_E	0x098F
#define T_UTF_16_BENGALI_LETTER_AI	0x0990
#define T_UTF_16_BENGALI_LETTER_O	0x0993
#define T_UTF_16_BENGALI_LETTER_AU	0x0994
#define T_UTF_16_BENGALI_LETTER_KA	0x0995
#define T_UTF_16_BENGALI_LETTER_KHA	0x0996
#define T_UTF_16_BENGALI_LETTER_GA	0x0997
#define T_UTF_16_BENGALI_LETTER_GHA	0x0998
#define T_UTF_16_BENGALI_LETTER_NGA	0x0999
#define T_UTF_16_BENGALI_LETTER_CA	0x099A
#define T_UTF_16_BENGALI_LETTER_CHA	0x099B
#define T_UTF_16_BENGALI_LETTER_JA	0x099C
#define T_UTF_16_BENGALI_LETTER_JHA	0x099D
#define T_UTF_16_BENGALI_LETTER_NYA	0x099E
#define T_UTF_16_BENGALI_LETTER_TTA	0x099F
#define T_UTF_16_BENGALI_LETTER_TTHA	0x09A0
#define T_UTF_16_BENGALI_LETTER_DDA	0x09A1
#define T_UTF_16_BENGALI_LETTER_DDHA	0x09A2
#define T_UTF_16_BENGALI_LETTER_NNA	0x09A3
#define T_UTF_16_BENGALI_LETTER_TA	0x09A4
#define T_UTF_16_BENGALI_LETTER_THA	0x09A5
#define T_UTF_16_BENGALI_LETTER_DA	0x09A6
#define T_UTF_16_BENGALI_LETTER_DHA	0x09A7
#define T_UTF_16_BENGALI_LETTER_NA	0x09A8
#define T_UTF_16_BENGALI_LETTER_PA	0x09AA
#define T_UTF_16_BENGALI_LETTER_PHA	0x09AB
#define T_UTF_16_BENGALI_LETTER_BA	0x09AC
#define T_UTF_16_BENGALI_LETTER_BHA	0x09AD
#define T_UTF_16_BENGALI_LETTER_MA	0x09AE
#define T_UTF_16_BENGALI_LETTER_YA	0x09AF
#define T_UTF_16_BENGALI_LETTER_RA	0x09B0
#define T_UTF_16_BENGALI_LETTER_LA	0x09B2
#define T_UTF_16_BENGALI_LETTER_SHA	0x09B6
#define T_UTF_16_BENGALI_LETTER_SSA	0x09B7
#define T_UTF_16_BENGALI_LETTER_SA	0x09B8
#define T_UTF_16_BENGALI_LETTER_HA	0x09B9
#define T_UTF_16_BENGALI_SIGN_NUKTA	0x09BC
#define T_UTF_16_BENGALI_VOWEL_SIGN_AA	0x09BE
#define T_UTF_16_BENGALI_VOWEL_SIGN_I	0x09BF
#define T_UTF_16_BENGALI_VOWEL_SIGN_II	0x09C0
#define T_UTF_16_BENGALI_VOWEL_SIGN_U	0x09C1
#define T_UTF_16_BENGALI_VOWEL_SIGN_UU	0x09C2
#define T_UTF_16_BENGALI_VOWEL_SIGN_VOCALIC_R	0x09C3
#define T_UTF_16_BENGALI_VOWEL_SIGN_VOCALIC_RR	0x09C4
#define T_UTF_16_BENGALI_VOWEL_SIGN_E	0x09C7
#define T_UTF_16_BENGALI_VOWEL_SIGN_AI	0x09C8
#define T_UTF_16_BENGALI_VOWEL_SIGN_O	0x09CB
#define T_UTF_16_BENGALI_VOWEL_SIGN_AU	0x09CC
#define T_UTF_16_BENGALI_SIGN_VIRAMA	0x09CD
#define T_UTF_16_BENGALI_AU_LENGTH_MARK	0x09D7
#define T_UTF_16_BENGALI_LETTER_RRA	0x09DC
#define T_UTF_16_BENGALI_LETTER_RHA	0x09DD
#define T_UTF_16_BENGALI_LETTER_YYA	0x09DF
#define T_UTF_16_BENGALI_LETTER_VOCALIC_RR	0x09E0
#define T_UTF_16_BENGALI_LETTER_VOCALIC_LL	0x09E1
#define T_UTF_16_BENGALI_VOWEL_SIGN_VOCALIC_L	0x09E2
#define T_UTF_16_BENGALI_VOWEL_SIGN_VOCALIC_LL	0x09E3
#define T_UTF_16_BENGALI_DIGIT_ZERO	0x09E6
#define T_UTF_16_BENGALI_DIGIT_ONE	0x09E7
#define T_UTF_16_BENGALI_DIGIT_TWO	0x09E8
#define T_UTF_16_BENGALI_DIGIT_THREE	0x09E9
#define T_UTF_16_BENGALI_DIGIT_FOUR	0x09EA
#define T_UTF_16_BENGALI_DIGIT_FIVE	0x09EB
#define T_UTF_16_BENGALI_DIGIT_SIX	0x09EC
#define T_UTF_16_BENGALI_DIGIT_SEVEN	0x09ED
#define T_UTF_16_BENGALI_DIGIT_EIGHT	0x09EE
#define T_UTF_16_BENGALI_DIGIT_NINE	0x09EF
#define T_UTF_16_BENGALI_LETTER_RA_WITH_MIDDLE_DIAGONAL	0x09F0
#define T_UTF_16_BENGALI_LETTER_RA_WITH_LOWER_DIAGONAL	0x09F1
#define T_UTF_16_BENGALI_RUPEE_MARK	0x09F2
#define T_UTF_16_BENGALI_RUPEE_SIGN	0x09F3
#define T_UTF_16_BENGALI_CURRENCY_NUMERATOR_ONE	0x09F4
#define T_UTF_16_BENGALI_CURRENCY_NUMERATOR_TWO	0x09F5
#define T_UTF_16_BENGALI_CURRENCY_NUMERATOR_THREE	0x09F6
#define T_UTF_16_BENGALI_CURRENCY_NUMERATOR_FOUR	0x09F7
#define T_UTF_16_BENGALI_CURRENCY_NUMERATOR_ONE_LESS_THAN_THE_DENOMINATOR	0x09F8
#define T_UTF_16_BENGALI_CURRENCY_DENOMINATOR_SIXTEEN	0x09F9
#define T_UTF_16_BENGALI_ISSHAR	0x09FA
#define T_UTF_16_GURMUKHI_SIGN_BINDI	0x0A02
#define T_UTF_16_GURMUKHI_LETTER_A	0x0A05
#define T_UTF_16_GURMUKHI_LETTER_AA	0x0A06
#define T_UTF_16_GURMUKHI_LETTER_I	0x0A07
#define T_UTF_16_GURMUKHI_LETTER_II	0x0A08
#define T_UTF_16_GURMUKHI_LETTER_U	0x0A09
#define T_UTF_16_GURMUKHI_LETTER_UU	0x0A0A
#define T_UTF_16_GURMUKHI_LETTER_EE	0x0A0F
#define T_UTF_16_GURMUKHI_LETTER_AI	0x0A10
#define T_UTF_16_GURMUKHI_LETTER_OO	0x0A13
#define T_UTF_16_GURMUKHI_LETTER_AU	0x0A14
#define T_UTF_16_GURMUKHI_LETTER_KA	0x0A15
#define T_UTF_16_GURMUKHI_LETTER_KHA	0x0A16
#define T_UTF_16_GURMUKHI_LETTER_GA	0x0A17
#define T_UTF_16_GURMUKHI_LETTER_GHA	0x0A18
#define T_UTF_16_GURMUKHI_LETTER_NGA	0x0A19
#define T_UTF_16_GURMUKHI_LETTER_CA	0x0A1A
#define T_UTF_16_GURMUKHI_LETTER_CHA	0x0A1B
#define T_UTF_16_GURMUKHI_LETTER_JA	0x0A1C
#define T_UTF_16_GURMUKHI_LETTER_JHA	0x0A1D
#define T_UTF_16_GURMUKHI_LETTER_NYA	0x0A1E
#define T_UTF_16_GURMUKHI_LETTER_TTA	0x0A1F
#define T_UTF_16_GURMUKHI_LETTER_TTHA	0x0A20
#define T_UTF_16_GURMUKHI_LETTER_DDA	0x0A21
#define T_UTF_16_GURMUKHI_LETTER_DDHA	0x0A22
#define T_UTF_16_GURMUKHI_LETTER_NNA	0x0A23
#define T_UTF_16_GURMUKHI_LETTER_TA	0x0A24
#define T_UTF_16_GURMUKHI_LETTER_THA	0x0A25
#define T_UTF_16_GURMUKHI_LETTER_DA	0x0A26
#define T_UTF_16_GURMUKHI_LETTER_DHA	0x0A27
#define T_UTF_16_GURMUKHI_LETTER_NA	0x0A28
#define T_UTF_16_GURMUKHI_LETTER_PA	0x0A2A
#define T_UTF_16_GURMUKHI_LETTER_PHA	0x0A2B
#define T_UTF_16_GURMUKHI_LETTER_BA	0x0A2C
#define T_UTF_16_GURMUKHI_LETTER_BHA	0x0A2D
#define T_UTF_16_GURMUKHI_LETTER_MA	0x0A2E
#define T_UTF_16_GURMUKHI_LETTER_YA	0x0A2F
#define T_UTF_16_GURMUKHI_LETTER_RA	0x0A30
#define T_UTF_16_GURMUKHI_LETTER_LA	0x0A32
#define T_UTF_16_GURMUKHI_LETTER_LLA	0x0A33
#define T_UTF_16_GURMUKHI_LETTER_VA	0x0A35
#define T_UTF_16_GURMUKHI_LETTER_SHA	0x0A36
#define T_UTF_16_GURMUKHI_LETTER_SA	0x0A38
#define T_UTF_16_GURMUKHI_LETTER_HA	0x0A39
#define T_UTF_16_GURMUKHI_SIGN_NUKTA	0x0A3C
#define T_UTF_16_GURMUKHI_VOWEL_SIGN_AA	0x0A3E
#define T_UTF_16_GURMUKHI_VOWEL_SIGN_I	0x0A3F
#define T_UTF_16_GURMUKHI_VOWEL_SIGN_II	0x0A40
#define T_UTF_16_GURMUKHI_VOWEL_SIGN_U	0x0A41
#define T_UTF_16_GURMUKHI_VOWEL_SIGN_UU	0x0A42
#define T_UTF_16_GURMUKHI_VOWEL_SIGN_EE	0x0A47
#define T_UTF_16_GURMUKHI_VOWEL_SIGN_AI	0x0A48
#define T_UTF_16_GURMUKHI_VOWEL_SIGN_OO	0x0A4B
#define T_UTF_16_GURMUKHI_VOWEL_SIGN_AU	0x0A4C
#define T_UTF_16_GURMUKHI_SIGN_VIRAMA	0x0A4D
#define T_UTF_16_GURMUKHI_LETTER_KHHA	0x0A59
#define T_UTF_16_GURMUKHI_LETTER_GHHA	0x0A5A
#define T_UTF_16_GURMUKHI_LETTER_ZA	0x0A5B
#define T_UTF_16_GURMUKHI_LETTER_RRA	0x0A5C
#define T_UTF_16_GURMUKHI_LETTER_FA	0x0A5E
#define T_UTF_16_GURMUKHI_DIGIT_ZERO	0x0A66
#define T_UTF_16_GURMUKHI_DIGIT_ONE	0x0A67
#define T_UTF_16_GURMUKHI_DIGIT_TWO	0x0A68
#define T_UTF_16_GURMUKHI_DIGIT_THREE	0x0A69
#define T_UTF_16_GURMUKHI_DIGIT_FOUR	0x0A6A
#define T_UTF_16_GURMUKHI_DIGIT_FIVE	0x0A6B
#define T_UTF_16_GURMUKHI_DIGIT_SIX	0x0A6C
#define T_UTF_16_GURMUKHI_DIGIT_SEVEN	0x0A6D
#define T_UTF_16_GURMUKHI_DIGIT_EIGHT	0x0A6E
#define T_UTF_16_GURMUKHI_DIGIT_NINE	0x0A6F
#define T_UTF_16_GURMUKHI_TIPPI	0x0A70
#define T_UTF_16_GURMUKHI_ADDAK	0x0A71
#define T_UTF_16_GURMUKHI_IRI	0x0A72
#define T_UTF_16_GURMUKHI_URA	0x0A73
#define T_UTF_16_GURMUKHI_EK_ONKAR	0x0A74
#define T_UTF_16_GUJARATI_SIGN_CANDRABINDU	0x0A81
#define T_UTF_16_GUJARATI_SIGN_ANUSVARA	0x0A82
#define T_UTF_16_GUJARATI_SIGN_VISARGA	0x0A83
#define T_UTF_16_GUJARATI_LETTER_A	0x0A85
#define T_UTF_16_GUJARATI_LETTER_AA	0x0A86
#define T_UTF_16_GUJARATI_LETTER_I	0x0A87
#define T_UTF_16_GUJARATI_LETTER_II	0x0A88
#define T_UTF_16_GUJARATI_LETTER_U	0x0A89
#define T_UTF_16_GUJARATI_LETTER_UU	0x0A8A
#define T_UTF_16_GUJARATI_LETTER_VOCALIC_R	0x0A8B
#define T_UTF_16_GUJARATI_VOWEL_CANDRA_E	0x0A8D
#define T_UTF_16_GUJARATI_LETTER_E	0x0A8F
#define T_UTF_16_GUJARATI_LETTER_AI	0x0A90
#define T_UTF_16_GUJARATI_VOWEL_CANDRA_O	0x0A91
#define T_UTF_16_GUJARATI_LETTER_O	0x0A93
#define T_UTF_16_GUJARATI_LETTER_AU	0x0A94
#define T_UTF_16_GUJARATI_LETTER_KA	0x0A95
#define T_UTF_16_GUJARATI_LETTER_KHA	0x0A96
#define T_UTF_16_GUJARATI_LETTER_GA	0x0A97
#define T_UTF_16_GUJARATI_LETTER_GHA	0x0A98
#define T_UTF_16_GUJARATI_LETTER_NGA	0x0A99
#define T_UTF_16_GUJARATI_LETTER_CA	0x0A9A
#define T_UTF_16_GUJARATI_LETTER_CHA	0x0A9B
#define T_UTF_16_GUJARATI_LETTER_JA	0x0A9C
#define T_UTF_16_GUJARATI_LETTER_JHA	0x0A9D
#define T_UTF_16_GUJARATI_LETTER_NYA	0x0A9E
#define T_UTF_16_GUJARATI_LETTER_TTA	0x0A9F
#define T_UTF_16_GUJARATI_LETTER_TTHA	0x0AA0
#define T_UTF_16_GUJARATI_LETTER_DDA	0x0AA1
#define T_UTF_16_GUJARATI_LETTER_DDHA	0x0AA2
#define T_UTF_16_GUJARATI_LETTER_NNA	0x0AA3
#define T_UTF_16_GUJARATI_LETTER_TA	0x0AA4
#define T_UTF_16_GUJARATI_LETTER_THA	0x0AA5
#define T_UTF_16_GUJARATI_LETTER_DA	0x0AA6
#define T_UTF_16_GUJARATI_LETTER_DHA	0x0AA7
#define T_UTF_16_GUJARATI_LETTER_NA	0x0AA8
#define T_UTF_16_GUJARATI_LETTER_PA	0x0AAA
#define T_UTF_16_GUJARATI_LETTER_PHA	0x0AAB
#define T_UTF_16_GUJARATI_LETTER_BA	0x0AAC
#define T_UTF_16_GUJARATI_LETTER_BHA	0x0AAD
#define T_UTF_16_GUJARATI_LETTER_MA	0x0AAE
#define T_UTF_16_GUJARATI_LETTER_YA	0x0AAF
#define T_UTF_16_GUJARATI_LETTER_RA	0x0AB0
#define T_UTF_16_GUJARATI_LETTER_LA	0x0AB2
#define T_UTF_16_GUJARATI_LETTER_LLA	0x0AB3
#define T_UTF_16_GUJARATI_LETTER_VA	0x0AB5
#define T_UTF_16_GUJARATI_LETTER_SHA	0x0AB6
#define T_UTF_16_GUJARATI_LETTER_SSA	0x0AB7
#define T_UTF_16_GUJARATI_LETTER_SA	0x0AB8
#define T_UTF_16_GUJARATI_LETTER_HA	0x0AB9
#define T_UTF_16_GUJARATI_SIGN_NUKTA	0x0ABC
#define T_UTF_16_GUJARATI_SIGN_AVAGRAHA	0x0ABD
#define T_UTF_16_GUJARATI_VOWEL_SIGN_AA	0x0ABE
#define T_UTF_16_GUJARATI_VOWEL_SIGN_I	0x0ABF
#define T_UTF_16_GUJARATI_VOWEL_SIGN_II	0x0AC0
#define T_UTF_16_GUJARATI_VOWEL_SIGN_U	0x0AC1
#define T_UTF_16_GUJARATI_VOWEL_SIGN_UU	0x0AC2
#define T_UTF_16_GUJARATI_VOWEL_SIGN_VOCALIC_R	0x0AC3
#define T_UTF_16_GUJARATI_VOWEL_SIGN_VOCALIC_RR	0x0AC4
#define T_UTF_16_GUJARATI_VOWEL_SIGN_CANDRA_E	0x0AC5
#define T_UTF_16_GUJARATI_VOWEL_SIGN_E	0x0AC7
#define T_UTF_16_GUJARATI_VOWEL_SIGN_AI	0x0AC8
#define T_UTF_16_GUJARATI_VOWEL_SIGN_CANDRA_O	0x0AC9
#define T_UTF_16_GUJARATI_VOWEL_SIGN_O	0x0ACB
#define T_UTF_16_GUJARATI_VOWEL_SIGN_AU	0x0ACC
#define T_UTF_16_GUJARATI_SIGN_VIRAMA	0x0ACD
#define T_UTF_16_GUJARATI_OM	0x0AD0
#define T_UTF_16_GUJARATI_LETTER_VOCALIC_RR	0x0AE0
#define T_UTF_16_GUJARATI_DIGIT_ZERO	0x0AE6
#define T_UTF_16_GUJARATI_DIGIT_ONE	0x0AE7
#define T_UTF_16_GUJARATI_DIGIT_TWO	0x0AE8
#define T_UTF_16_GUJARATI_DIGIT_THREE	0x0AE9
#define T_UTF_16_GUJARATI_DIGIT_FOUR	0x0AEA
#define T_UTF_16_GUJARATI_DIGIT_FIVE	0x0AEB
#define T_UTF_16_GUJARATI_DIGIT_SIX	0x0AEC
#define T_UTF_16_GUJARATI_DIGIT_SEVEN	0x0AED
#define T_UTF_16_GUJARATI_DIGIT_EIGHT	0x0AEE
#define T_UTF_16_GUJARATI_DIGIT_NINE	0x0AEF
#define T_UTF_16_ORIYA_SIGN_CANDRABINDU	0x0B01
#define T_UTF_16_ORIYA_SIGN_ANUSVARA	0x0B02
#define T_UTF_16_ORIYA_SIGN_VISARGA	0x0B03
#define T_UTF_16_ORIYA_LETTER_A	0x0B05
#define T_UTF_16_ORIYA_LETTER_AA	0x0B06
#define T_UTF_16_ORIYA_LETTER_I	0x0B07
#define T_UTF_16_ORIYA_LETTER_II	0x0B08
#define T_UTF_16_ORIYA_LETTER_U	0x0B09
#define T_UTF_16_ORIYA_LETTER_UU	0x0B0A
#define T_UTF_16_ORIYA_LETTER_VOCALIC_R	0x0B0B
#define T_UTF_16_ORIYA_LETTER_VOCALIC_L	0x0B0C
#define T_UTF_16_ORIYA_LETTER_E	0x0B0F
#define T_UTF_16_ORIYA_LETTER_AI	0x0B10
#define T_UTF_16_ORIYA_LETTER_O	0x0B13
#define T_UTF_16_ORIYA_LETTER_AU	0x0B14
#define T_UTF_16_ORIYA_LETTER_KA	0x0B15
#define T_UTF_16_ORIYA_LETTER_KHA	0x0B16
#define T_UTF_16_ORIYA_LETTER_GA	0x0B17
#define T_UTF_16_ORIYA_LETTER_GHA	0x0B18
#define T_UTF_16_ORIYA_LETTER_NGA	0x0B19
#define T_UTF_16_ORIYA_LETTER_CA	0x0B1A
#define T_UTF_16_ORIYA_LETTER_CHA	0x0B1B
#define T_UTF_16_ORIYA_LETTER_JA	0x0B1C
#define T_UTF_16_ORIYA_LETTER_JHA	0x0B1D
#define T_UTF_16_ORIYA_LETTER_NYA	0x0B1E
#define T_UTF_16_ORIYA_LETTER_TTA	0x0B1F
#define T_UTF_16_ORIYA_LETTER_TTHA	0x0B20
#define T_UTF_16_ORIYA_LETTER_DDA	0x0B21
#define T_UTF_16_ORIYA_LETTER_DDHA	0x0B22
#define T_UTF_16_ORIYA_LETTER_NNA	0x0B23
#define T_UTF_16_ORIYA_LETTER_TA	0x0B24
#define T_UTF_16_ORIYA_LETTER_THA	0x0B25
#define T_UTF_16_ORIYA_LETTER_DA	0x0B26
#define T_UTF_16_ORIYA_LETTER_DHA	0x0B27
#define T_UTF_16_ORIYA_LETTER_NA	0x0B28
#define T_UTF_16_ORIYA_LETTER_PA	0x0B2A
#define T_UTF_16_ORIYA_LETTER_PHA	0x0B2B
#define T_UTF_16_ORIYA_LETTER_BA	0x0B2C
#define T_UTF_16_ORIYA_LETTER_BHA	0x0B2D
#define T_UTF_16_ORIYA_LETTER_MA	0x0B2E
#define T_UTF_16_ORIYA_LETTER_YA	0x0B2F
#define T_UTF_16_ORIYA_LETTER_RA	0x0B30
#define T_UTF_16_ORIYA_LETTER_LA	0x0B32
#define T_UTF_16_ORIYA_LETTER_LLA	0x0B33
#define T_UTF_16_ORIYA_LETTER_SHA	0x0B36
#define T_UTF_16_ORIYA_LETTER_SSA	0x0B37
#define T_UTF_16_ORIYA_LETTER_SA	0x0B38
#define T_UTF_16_ORIYA_LETTER_HA	0x0B39
#define T_UTF_16_ORIYA_SIGN_NUKTA	0x0B3C
#define T_UTF_16_ORIYA_SIGN_AVAGRAHA	0x0B3D
#define T_UTF_16_ORIYA_VOWEL_SIGN_AA	0x0B3E
#define T_UTF_16_ORIYA_VOWEL_SIGN_I	0x0B3F
#define T_UTF_16_ORIYA_VOWEL_SIGN_II	0x0B40
#define T_UTF_16_ORIYA_VOWEL_SIGN_U	0x0B41
#define T_UTF_16_ORIYA_VOWEL_SIGN_UU	0x0B42
#define T_UTF_16_ORIYA_VOWEL_SIGN_VOCALIC_R	0x0B43
#define T_UTF_16_ORIYA_VOWEL_SIGN_E	0x0B47
#define T_UTF_16_ORIYA_VOWEL_SIGN_AI	0x0B48
#define T_UTF_16_ORIYA_VOWEL_SIGN_O	0x0B4B
#define T_UTF_16_ORIYA_VOWEL_SIGN_AU	0x0B4C
#define T_UTF_16_ORIYA_SIGN_VIRAMA	0x0B4D
#define T_UTF_16_ORIYA_AI_LENGTH_MARK	0x0B56
#define T_UTF_16_ORIYA_AU_LENGTH_MARK	0x0B57
#define T_UTF_16_ORIYA_LETTER_RRA	0x0B5C
#define T_UTF_16_ORIYA_LETTER_RHA	0x0B5D
#define T_UTF_16_ORIYA_LETTER_YYA	0x0B5F
#define T_UTF_16_ORIYA_LETTER_VOCALIC_RR	0x0B60
#define T_UTF_16_ORIYA_LETTER_VOCALIC_LL	0x0B61
#define T_UTF_16_ORIYA_DIGIT_ZERO	0x0B66
#define T_UTF_16_ORIYA_DIGIT_ONE	0x0B67
#define T_UTF_16_ORIYA_DIGIT_TWO	0x0B68
#define T_UTF_16_ORIYA_DIGIT_THREE	0x0B69
#define T_UTF_16_ORIYA_DIGIT_FOUR	0x0B6A
#define T_UTF_16_ORIYA_DIGIT_FIVE	0x0B6B
#define T_UTF_16_ORIYA_DIGIT_SIX	0x0B6C
#define T_UTF_16_ORIYA_DIGIT_SEVEN	0x0B6D
#define T_UTF_16_ORIYA_DIGIT_EIGHT	0x0B6E
#define T_UTF_16_ORIYA_DIGIT_NINE	0x0B6F
#define T_UTF_16_ORIYA_ISSHAR	0x0B70
#define T_UTF_16_TAMIL_SIGN_ANUSVARA	0x0B82
#define T_UTF_16_TAMIL_SIGN_VISARGA	0x0B83
#define T_UTF_16_TAMIL_LETTER_A	0x0B85
#define T_UTF_16_TAMIL_LETTER_AA	0x0B86
#define T_UTF_16_TAMIL_LETTER_I	0x0B87
#define T_UTF_16_TAMIL_LETTER_II	0x0B88
#define T_UTF_16_TAMIL_LETTER_U	0x0B89
#define T_UTF_16_TAMIL_LETTER_UU	0x0B8A
#define T_UTF_16_TAMIL_LETTER_E	0x0B8E
#define T_UTF_16_TAMIL_LETTER_EE	0x0B8F
#define T_UTF_16_TAMIL_LETTER_AI	0x0B90
#define T_UTF_16_TAMIL_LETTER_O	0x0B92
#define T_UTF_16_TAMIL_LETTER_OO	0x0B93
#define T_UTF_16_TAMIL_LETTER_AU	0x0B94
#define T_UTF_16_TAMIL_LETTER_KA	0x0B95
#define T_UTF_16_TAMIL_LETTER_NGA	0x0B99
#define T_UTF_16_TAMIL_LETTER_CA	0x0B9A
#define T_UTF_16_TAMIL_LETTER_JA	0x0B9C
#define T_UTF_16_TAMIL_LETTER_NYA	0x0B9E
#define T_UTF_16_TAMIL_LETTER_TTA	0x0B9F
#define T_UTF_16_TAMIL_LETTER_NNA	0x0BA3
#define T_UTF_16_TAMIL_LETTER_TA	0x0BA4
#define T_UTF_16_TAMIL_LETTER_NA	0x0BA8
#define T_UTF_16_TAMIL_LETTER_NNNA	0x0BA9
#define T_UTF_16_TAMIL_LETTER_PA	0x0BAA
#define T_UTF_16_TAMIL_LETTER_MA	0x0BAE
#define T_UTF_16_TAMIL_LETTER_YA	0x0BAF
#define T_UTF_16_TAMIL_LETTER_RA	0x0BB0
#define T_UTF_16_TAMIL_LETTER_RRA	0x0BB1
#define T_UTF_16_TAMIL_LETTER_LA	0x0BB2
#define T_UTF_16_TAMIL_LETTER_LLA	0x0BB3
#define T_UTF_16_TAMIL_LETTER_LLLA	0x0BB4
#define T_UTF_16_TAMIL_LETTER_VA	0x0BB5
#define T_UTF_16_TAMIL_LETTER_SSA	0x0BB7
#define T_UTF_16_TAMIL_LETTER_SA	0x0BB8
#define T_UTF_16_TAMIL_LETTER_HA	0x0BB9
#define T_UTF_16_TAMIL_VOWEL_SIGN_AA	0x0BBE
#define T_UTF_16_TAMIL_VOWEL_SIGN_I	0x0BBF
#define T_UTF_16_TAMIL_VOWEL_SIGN_II	0x0BC0
#define T_UTF_16_TAMIL_VOWEL_SIGN_U	0x0BC1
#define T_UTF_16_TAMIL_VOWEL_SIGN_UU	0x0BC2
#define T_UTF_16_TAMIL_VOWEL_SIGN_E	0x0BC6
#define T_UTF_16_TAMIL_VOWEL_SIGN_EE	0x0BC7
#define T_UTF_16_TAMIL_VOWEL_SIGN_AI	0x0BC8
#define T_UTF_16_TAMIL_VOWEL_SIGN_O	0x0BCA
#define T_UTF_16_TAMIL_VOWEL_SIGN_OO	0x0BCB
#define T_UTF_16_TAMIL_VOWEL_SIGN_AU	0x0BCC
#define T_UTF_16_TAMIL_SIGN_VIRAMA	0x0BCD
#define T_UTF_16_TAMIL_AU_LENGTH_MARK	0x0BD7
#define T_UTF_16_TAMIL_DIGIT_ONE	0x0BE7
#define T_UTF_16_TAMIL_DIGIT_TWO	0x0BE8
#define T_UTF_16_TAMIL_DIGIT_THREE	0x0BE9
#define T_UTF_16_TAMIL_DIGIT_FOUR	0x0BEA
#define T_UTF_16_TAMIL_DIGIT_FIVE	0x0BEB
#define T_UTF_16_TAMIL_DIGIT_SIX	0x0BEC
#define T_UTF_16_TAMIL_DIGIT_SEVEN	0x0BED
#define T_UTF_16_TAMIL_DIGIT_EIGHT	0x0BEE
#define T_UTF_16_TAMIL_DIGIT_NINE	0x0BEF
#define T_UTF_16_TAMIL_NUMBER_TEN	0x0BF0
#define T_UTF_16_TAMIL_NUMBER_ONE_HUNDRED	0x0BF1
#define T_UTF_16_TAMIL_NUMBER_ONE_THOUSAND	0x0BF2
#define T_UTF_16_TELUGU_SIGN_CANDRABINDU	0x0C01
#define T_UTF_16_TELUGU_SIGN_ANUSVARA	0x0C02
#define T_UTF_16_TELUGU_SIGN_VISARGA	0x0C03
#define T_UTF_16_TELUGU_LETTER_A	0x0C05
#define T_UTF_16_TELUGU_LETTER_AA	0x0C06
#define T_UTF_16_TELUGU_LETTER_I	0x0C07
#define T_UTF_16_TELUGU_LETTER_II	0x0C08
#define T_UTF_16_TELUGU_LETTER_U	0x0C09
#define T_UTF_16_TELUGU_LETTER_UU	0x0C0A
#define T_UTF_16_TELUGU_LETTER_VOCALIC_R	0x0C0B
#define T_UTF_16_TELUGU_LETTER_VOCALIC_L	0x0C0C
#define T_UTF_16_TELUGU_LETTER_E	0x0C0E
#define T_UTF_16_TELUGU_LETTER_EE	0x0C0F
#define T_UTF_16_TELUGU_LETTER_AI	0x0C10
#define T_UTF_16_TELUGU_LETTER_O	0x0C12
#define T_UTF_16_TELUGU_LETTER_OO	0x0C13
#define T_UTF_16_TELUGU_LETTER_AU	0x0C14
#define T_UTF_16_TELUGU_LETTER_KA	0x0C15
#define T_UTF_16_TELUGU_LETTER_KHA	0x0C16
#define T_UTF_16_TELUGU_LETTER_GA	0x0C17
#define T_UTF_16_TELUGU_LETTER_GHA	0x0C18
#define T_UTF_16_TELUGU_LETTER_NGA	0x0C19
#define T_UTF_16_TELUGU_LETTER_CA	0x0C1A
#define T_UTF_16_TELUGU_LETTER_CHA	0x0C1B
#define T_UTF_16_TELUGU_LETTER_JA	0x0C1C
#define T_UTF_16_TELUGU_LETTER_JHA	0x0C1D
#define T_UTF_16_TELUGU_LETTER_NYA	0x0C1E
#define T_UTF_16_TELUGU_LETTER_TTA	0x0C1F
#define T_UTF_16_TELUGU_LETTER_TTHA	0x0C20
#define T_UTF_16_TELUGU_LETTER_DDA	0x0C21
#define T_UTF_16_TELUGU_LETTER_DDHA	0x0C22
#define T_UTF_16_TELUGU_LETTER_NNA	0x0C23
#define T_UTF_16_TELUGU_LETTER_TA	0x0C24
#define T_UTF_16_TELUGU_LETTER_THA	0x0C25
#define T_UTF_16_TELUGU_LETTER_DA	0x0C26
#define T_UTF_16_TELUGU_LETTER_DHA	0x0C27
#define T_UTF_16_TELUGU_LETTER_NA	0x0C28
#define T_UTF_16_TELUGU_LETTER_PA	0x0C2A
#define T_UTF_16_TELUGU_LETTER_PHA	0x0C2B
#define T_UTF_16_TELUGU_LETTER_BA	0x0C2C
#define T_UTF_16_TELUGU_LETTER_BHA	0x0C2D
#define T_UTF_16_TELUGU_LETTER_MA	0x0C2E
#define T_UTF_16_TELUGU_LETTER_YA	0x0C2F
#define T_UTF_16_TELUGU_LETTER_RA	0x0C30
#define T_UTF_16_TELUGU_LETTER_RRA	0x0C31
#define T_UTF_16_TELUGU_LETTER_LA	0x0C32
#define T_UTF_16_TELUGU_LETTER_LLA	0x0C33
#define T_UTF_16_TELUGU_LETTER_VA	0x0C35
#define T_UTF_16_TELUGU_LETTER_SHA	0x0C36
#define T_UTF_16_TELUGU_LETTER_SSA	0x0C37
#define T_UTF_16_TELUGU_LETTER_SA	0x0C38
#define T_UTF_16_TELUGU_LETTER_HA	0x0C39
#define T_UTF_16_TELUGU_VOWEL_SIGN_AA	0x0C3E
#define T_UTF_16_TELUGU_VOWEL_SIGN_I	0x0C3F
#define T_UTF_16_TELUGU_VOWEL_SIGN_II	0x0C40
#define T_UTF_16_TELUGU_VOWEL_SIGN_U	0x0C41
#define T_UTF_16_TELUGU_VOWEL_SIGN_UU	0x0C42
#define T_UTF_16_TELUGU_VOWEL_SIGN_VOCALIC_R	0x0C43
#define T_UTF_16_TELUGU_VOWEL_SIGN_VOCALIC_RR	0x0C44
#define T_UTF_16_TELUGU_VOWEL_SIGN_E	0x0C46
#define T_UTF_16_TELUGU_VOWEL_SIGN_EE	0x0C47
#define T_UTF_16_TELUGU_VOWEL_SIGN_AI	0x0C48
#define T_UTF_16_TELUGU_VOWEL_SIGN_O	0x0C4A
#define T_UTF_16_TELUGU_VOWEL_SIGN_OO	0x0C4B
#define T_UTF_16_TELUGU_VOWEL_SIGN_AU	0x0C4C
#define T_UTF_16_TELUGU_SIGN_VIRAMA	0x0C4D
#define T_UTF_16_TELUGU_LENGTH_MARK	0x0C55
#define T_UTF_16_TELUGU_AI_LENGTH_MARK	0x0C56
#define T_UTF_16_TELUGU_LETTER_VOCALIC_RR	0x0C60
#define T_UTF_16_TELUGU_LETTER_VOCALIC_LL	0x0C61
#define T_UTF_16_TELUGU_DIGIT_ZERO	0x0C66
#define T_UTF_16_TELUGU_DIGIT_ONE	0x0C67
#define T_UTF_16_TELUGU_DIGIT_TWO	0x0C68
#define T_UTF_16_TELUGU_DIGIT_THREE	0x0C69
#define T_UTF_16_TELUGU_DIGIT_FOUR	0x0C6A
#define T_UTF_16_TELUGU_DIGIT_FIVE	0x0C6B
#define T_UTF_16_TELUGU_DIGIT_SIX	0x0C6C
#define T_UTF_16_TELUGU_DIGIT_SEVEN	0x0C6D
#define T_UTF_16_TELUGU_DIGIT_EIGHT	0x0C6E
#define T_UTF_16_TELUGU_DIGIT_NINE	0x0C6F
#define T_UTF_16_KANNADA_SIGN_ANUSVARA	0x0C82
#define T_UTF_16_KANNADA_SIGN_VISARGA	0x0C83
#define T_UTF_16_KANNADA_LETTER_A	0x0C85
#define T_UTF_16_KANNADA_LETTER_AA	0x0C86
#define T_UTF_16_KANNADA_LETTER_I	0x0C87
#define T_UTF_16_KANNADA_LETTER_II	0x0C88
#define T_UTF_16_KANNADA_LETTER_U	0x0C89
#define T_UTF_16_KANNADA_LETTER_UU	0x0C8A
#define T_UTF_16_KANNADA_LETTER_VOCALIC_R	0x0C8B
#define T_UTF_16_KANNADA_LETTER_VOCALIC_L	0x0C8C
#define T_UTF_16_KANNADA_LETTER_E	0x0C8E
#define T_UTF_16_KANNADA_LETTER_EE	0x0C8F
#define T_UTF_16_KANNADA_LETTER_AI	0x0C90
#define T_UTF_16_KANNADA_LETTER_O	0x0C92
#define T_UTF_16_KANNADA_LETTER_OO	0x0C93
#define T_UTF_16_KANNADA_LETTER_AU	0x0C94
#define T_UTF_16_KANNADA_LETTER_KA	0x0C95
#define T_UTF_16_KANNADA_LETTER_KHA	0x0C96
#define T_UTF_16_KANNADA_LETTER_GA	0x0C97
#define T_UTF_16_KANNADA_LETTER_GHA	0x0C98
#define T_UTF_16_KANNADA_LETTER_NGA	0x0C99
#define T_UTF_16_KANNADA_LETTER_CA	0x0C9A
#define T_UTF_16_KANNADA_LETTER_CHA	0x0C9B
#define T_UTF_16_KANNADA_LETTER_JA	0x0C9C
#define T_UTF_16_KANNADA_LETTER_JHA	0x0C9D
#define T_UTF_16_KANNADA_LETTER_NYA	0x0C9E
#define T_UTF_16_KANNADA_LETTER_TTA	0x0C9F
#define T_UTF_16_KANNADA_LETTER_TTHA	0x0CA0
#define T_UTF_16_KANNADA_LETTER_DDA	0x0CA1
#define T_UTF_16_KANNADA_LETTER_DDHA	0x0CA2
#define T_UTF_16_KANNADA_LETTER_NNA	0x0CA3
#define T_UTF_16_KANNADA_LETTER_TA	0x0CA4
#define T_UTF_16_KANNADA_LETTER_THA	0x0CA5
#define T_UTF_16_KANNADA_LETTER_DA	0x0CA6
#define T_UTF_16_KANNADA_LETTER_DHA	0x0CA7
#define T_UTF_16_KANNADA_LETTER_NA	0x0CA8
#define T_UTF_16_KANNADA_LETTER_PA	0x0CAA
#define T_UTF_16_KANNADA_LETTER_PHA	0x0CAB
#define T_UTF_16_KANNADA_LETTER_BA	0x0CAC
#define T_UTF_16_KANNADA_LETTER_BHA	0x0CAD
#define T_UTF_16_KANNADA_LETTER_MA	0x0CAE
#define T_UTF_16_KANNADA_LETTER_YA	0x0CAF
#define T_UTF_16_KANNADA_LETTER_RA	0x0CB0
#define T_UTF_16_KANNADA_LETTER_RRA	0x0CB1
#define T_UTF_16_KANNADA_LETTER_LA	0x0CB2
#define T_UTF_16_KANNADA_LETTER_LLA	0x0CB3
#define T_UTF_16_KANNADA_LETTER_VA	0x0CB5
#define T_UTF_16_KANNADA_LETTER_SHA	0x0CB6
#define T_UTF_16_KANNADA_LETTER_SSA	0x0CB7
#define T_UTF_16_KANNADA_LETTER_SA	0x0CB8
#define T_UTF_16_KANNADA_LETTER_HA	0x0CB9
#define T_UTF_16_KANNADA_VOWEL_SIGN_AA	0x0CBE
#define T_UTF_16_KANNADA_VOWEL_SIGN_I	0x0CBF
#define T_UTF_16_KANNADA_VOWEL_SIGN_II	0x0CC0
#define T_UTF_16_KANNADA_VOWEL_SIGN_U	0x0CC1
#define T_UTF_16_KANNADA_VOWEL_SIGN_UU	0x0CC2
#define T_UTF_16_KANNADA_VOWEL_SIGN_VOCALIC_R	0x0CC3
#define T_UTF_16_KANNADA_VOWEL_SIGN_VOCALIC_RR	0x0CC4
#define T_UTF_16_KANNADA_VOWEL_SIGN_E	0x0CC6
#define T_UTF_16_KANNADA_VOWEL_SIGN_EE	0x0CC7
#define T_UTF_16_KANNADA_VOWEL_SIGN_AI	0x0CC8
#define T_UTF_16_KANNADA_VOWEL_SIGN_O	0x0CCA
#define T_UTF_16_KANNADA_VOWEL_SIGN_OO	0x0CCB
#define T_UTF_16_KANNADA_VOWEL_SIGN_AU	0x0CCC
#define T_UTF_16_KANNADA_SIGN_VIRAMA	0x0CCD
#define T_UTF_16_KANNADA_LENGTH_MARK	0x0CD5
#define T_UTF_16_KANNADA_AI_LENGTH_MARK	0x0CD6
#define T_UTF_16_KANNADA_LETTER_FA	0x0CDE
#define T_UTF_16_KANNADA_LETTER_VOCALIC_RR	0x0CE0
#define T_UTF_16_KANNADA_LETTER_VOCALIC_LL	0x0CE1
#define T_UTF_16_KANNADA_DIGIT_ZERO	0x0CE6
#define T_UTF_16_KANNADA_DIGIT_ONE	0x0CE7
#define T_UTF_16_KANNADA_DIGIT_TWO	0x0CE8
#define T_UTF_16_KANNADA_DIGIT_THREE	0x0CE9
#define T_UTF_16_KANNADA_DIGIT_FOUR	0x0CEA
#define T_UTF_16_KANNADA_DIGIT_FIVE	0x0CEB
#define T_UTF_16_KANNADA_DIGIT_SIX	0x0CEC
#define T_UTF_16_KANNADA_DIGIT_SEVEN	0x0CED
#define T_UTF_16_KANNADA_DIGIT_EIGHT	0x0CEE
#define T_UTF_16_KANNADA_DIGIT_NINE	0x0CEF
#define T_UTF_16_MALAYALAM_SIGN_ANUSVARA	0x0D02
#define T_UTF_16_MALAYALAM_SIGN_VISARGA	0x0D03
#define T_UTF_16_MALAYALAM_LETTER_A	0x0D05
#define T_UTF_16_MALAYALAM_LETTER_AA	0x0D06
#define T_UTF_16_MALAYALAM_LETTER_I	0x0D07
#define T_UTF_16_MALAYALAM_LETTER_II	0x0D08
#define T_UTF_16_MALAYALAM_LETTER_U	0x0D09
#define T_UTF_16_MALAYALAM_LETTER_UU	0x0D0A
#define T_UTF_16_MALAYALAM_LETTER_VOCALIC_R	0x0D0B
#define T_UTF_16_MALAYALAM_LETTER_VOCALIC_L	0x0D0C
#define T_UTF_16_MALAYALAM_LETTER_E	0x0D0E
#define T_UTF_16_MALAYALAM_LETTER_EE	0x0D0F
#define T_UTF_16_MALAYALAM_LETTER_AI	0x0D10
#define T_UTF_16_MALAYALAM_LETTER_O	0x0D12
#define T_UTF_16_MALAYALAM_LETTER_OO	0x0D13
#define T_UTF_16_MALAYALAM_LETTER_AU	0x0D14
#define T_UTF_16_MALAYALAM_LETTER_KA	0x0D15
#define T_UTF_16_MALAYALAM_LETTER_KHA	0x0D16
#define T_UTF_16_MALAYALAM_LETTER_GA	0x0D17
#define T_UTF_16_MALAYALAM_LETTER_GHA	0x0D18
#define T_UTF_16_MALAYALAM_LETTER_NGA	0x0D19
#define T_UTF_16_MALAYALAM_LETTER_CA	0x0D1A
#define T_UTF_16_MALAYALAM_LETTER_CHA	0x0D1B
#define T_UTF_16_MALAYALAM_LETTER_JA	0x0D1C
#define T_UTF_16_MALAYALAM_LETTER_JHA	0x0D1D
#define T_UTF_16_MALAYALAM_LETTER_NYA	0x0D1E
#define T_UTF_16_MALAYALAM_LETTER_TTA	0x0D1F
#define T_UTF_16_MALAYALAM_LETTER_TTHA	0x0D20
#define T_UTF_16_MALAYALAM_LETTER_DDA	0x0D21
#define T_UTF_16_MALAYALAM_LETTER_DDHA	0x0D22
#define T_UTF_16_MALAYALAM_LETTER_NNA	0x0D23
#define T_UTF_16_MALAYALAM_LETTER_TA	0x0D24
#define T_UTF_16_MALAYALAM_LETTER_THA	0x0D25
#define T_UTF_16_MALAYALAM_LETTER_DA	0x0D26
#define T_UTF_16_MALAYALAM_LETTER_DHA	0x0D27
#define T_UTF_16_MALAYALAM_LETTER_NA	0x0D28
#define T_UTF_16_MALAYALAM_LETTER_PA	0x0D2A
#define T_UTF_16_MALAYALAM_LETTER_PHA	0x0D2B
#define T_UTF_16_MALAYALAM_LETTER_BA	0x0D2C
#define T_UTF_16_MALAYALAM_LETTER_BHA	0x0D2D
#define T_UTF_16_MALAYALAM_LETTER_MA	0x0D2E
#define T_UTF_16_MALAYALAM_LETTER_YA	0x0D2F
#define T_UTF_16_MALAYALAM_LETTER_RA	0x0D30
#define T_UTF_16_MALAYALAM_LETTER_RRA	0x0D31
#define T_UTF_16_MALAYALAM_LETTER_LA	0x0D32
#define T_UTF_16_MALAYALAM_LETTER_LLA	0x0D33
#define T_UTF_16_MALAYALAM_LETTER_LLLA	0x0D34
#define T_UTF_16_MALAYALAM_LETTER_VA	0x0D35
#define T_UTF_16_MALAYALAM_LETTER_SHA	0x0D36
#define T_UTF_16_MALAYALAM_LETTER_SSA	0x0D37
#define T_UTF_16_MALAYALAM_LETTER_SA	0x0D38
#define T_UTF_16_MALAYALAM_LETTER_HA	0x0D39
#define T_UTF_16_MALAYALAM_VOWEL_SIGN_AA	0x0D3E
#define T_UTF_16_MALAYALAM_VOWEL_SIGN_I	0x0D3F
#define T_UTF_16_MALAYALAM_VOWEL_SIGN_II	0x0D40
#define T_UTF_16_MALAYALAM_VOWEL_SIGN_U	0x0D41
#define T_UTF_16_MALAYALAM_VOWEL_SIGN_UU	0x0D42
#define T_UTF_16_MALAYALAM_VOWEL_SIGN_VOCALIC_R	0x0D43
#define T_UTF_16_MALAYALAM_VOWEL_SIGN_E	0x0D46
#define T_UTF_16_MALAYALAM_VOWEL_SIGN_EE	0x0D47
#define T_UTF_16_MALAYALAM_VOWEL_SIGN_AI	0x0D48
#define T_UTF_16_MALAYALAM_VOWEL_SIGN_O	0x0D4A
#define T_UTF_16_MALAYALAM_VOWEL_SIGN_OO	0x0D4B
#define T_UTF_16_MALAYALAM_VOWEL_SIGN_AU	0x0D4C
#define T_UTF_16_MALAYALAM_SIGN_VIRAMA	0x0D4D
#define T_UTF_16_MALAYALAM_AU_LENGTH_MARK	0x0D57
#define T_UTF_16_MALAYALAM_LETTER_VOCALIC_RR	0x0D60
#define T_UTF_16_MALAYALAM_LETTER_VOCALIC_LL	0x0D61
#define T_UTF_16_MALAYALAM_DIGIT_ZERO	0x0D66
#define T_UTF_16_MALAYALAM_DIGIT_ONE	0x0D67
#define T_UTF_16_MALAYALAM_DIGIT_TWO	0x0D68
#define T_UTF_16_MALAYALAM_DIGIT_THREE	0x0D69
#define T_UTF_16_MALAYALAM_DIGIT_FOUR	0x0D6A
#define T_UTF_16_MALAYALAM_DIGIT_FIVE	0x0D6B
#define T_UTF_16_MALAYALAM_DIGIT_SIX	0x0D6C
#define T_UTF_16_MALAYALAM_DIGIT_SEVEN	0x0D6D
#define T_UTF_16_MALAYALAM_DIGIT_EIGHT	0x0D6E
#define T_UTF_16_MALAYALAM_DIGIT_NINE	0x0D6F
#define T_UTF_16_SINHALA_SIGN_ANUSVARAYA	0x0D82
#define T_UTF_16_SINHALA_SIGN_VISARGAYA	0x0D83
#define T_UTF_16_SINHALA_LETTER_AYANNA	0x0D85
#define T_UTF_16_SINHALA_LETTER_AAYANNA	0x0D86
#define T_UTF_16_SINHALA_LETTER_AEYANNA	0x0D87
#define T_UTF_16_SINHALA_LETTER_AEEYANNA	0x0D88
#define T_UTF_16_SINHALA_LETTER_IYANNA	0x0D89
#define T_UTF_16_SINHALA_LETTER_IIYANNA	0x0D8A
#define T_UTF_16_SINHALA_LETTER_UYANNA	0x0D8B
#define T_UTF_16_SINHALA_LETTER_UUYANNA	0x0D8C
#define T_UTF_16_SINHALA_LETTER_IRUYANNA	0x0D8D
#define T_UTF_16_SINHALA_LETTER_IRUUYANNA	0x0D8E
#define T_UTF_16_SINHALA_LETTER_ILUYANNA	0x0D8F
#define T_UTF_16_SINHALA_LETTER_ILUUYANNA	0x0D90
#define T_UTF_16_SINHALA_LETTER_EYANNA	0x0D91
#define T_UTF_16_SINHALA_LETTER_EEYANNA	0x0D92
#define T_UTF_16_SINHALA_LETTER_AIYANNA	0x0D93
#define T_UTF_16_SINHALA_LETTER_OYANNA	0x0D94
#define T_UTF_16_SINHALA_LETTER_OOYANNA	0x0D95
#define T_UTF_16_SINHALA_LETTER_AUYANNA	0x0D96
#define T_UTF_16_SINHALA_LETTER_ALPAPRAANA_KAYANNA	0x0D9A
#define T_UTF_16_SINHALA_LETTER_MAHAAPRAANA_KAYANNA	0x0D9B
#define T_UTF_16_SINHALA_LETTER_ALPAPRAANA_GAYANNA	0x0D9C
#define T_UTF_16_SINHALA_LETTER_MAHAAPRAANA_GAYANNA	0x0D9D
#define T_UTF_16_SINHALA_LETTER_KANTAJA_NAASIKYAYA	0x0D9E
#define T_UTF_16_SINHALA_LETTER_SANYAKA_GAYANNA	0x0D9F
#define T_UTF_16_SINHALA_LETTER_ALPAPRAANA_CAYANNA	0x0DA0
#define T_UTF_16_SINHALA_LETTER_MAHAAPRAANA_CAYANNA	0x0DA1
#define T_UTF_16_SINHALA_LETTER_ALPAPRAANA_JAYANNA	0x0DA2
#define T_UTF_16_SINHALA_LETTER_MAHAAPRAANA_JAYANNA	0x0DA3
#define T_UTF_16_SINHALA_LETTER_TAALUJA_NAASIKYAYA	0x0DA4
#define T_UTF_16_SINHALA_LETTER_TAALUJA_SANYOOGA_NAAKSIKYAYA	0x0DA5
#define T_UTF_16_SINHALA_LETTER_SANYAKA_JAYANNA	0x0DA6
#define T_UTF_16_SINHALA_LETTER_ALPAPRAANA_TTAYANNA	0x0DA7
#define T_UTF_16_SINHALA_LETTER_MAHAAPRAANA_TTAYANNA	0x0DA8
#define T_UTF_16_SINHALA_LETTER_ALPAPRAANA_DDAYANNA	0x0DA9
#define T_UTF_16_SINHALA_LETTER_MAHAAPRAANA_DDAYANNA	0x0DAA
#define T_UTF_16_SINHALA_LETTER_MUURDHAJA_NAYANNA	0x0DAB
#define T_UTF_16_SINHALA_LETTER_SANYAKA_DDAYANNA	0x0DAC
#define T_UTF_16_SINHALA_LETTER_ALPAPRAANA_TAYANNA	0x0DAD
#define T_UTF_16_SINHALA_LETTER_MAHAAPRAANA_TAYANNA	0x0DAE
#define T_UTF_16_SINHALA_LETTER_ALPAPRAANA_DAYANNA	0x0DAF
#define T_UTF_16_SINHALA_LETTER_MAHAAPRAANA_DAYANNA	0x0DB0
#define T_UTF_16_SINHALA_LETTER_DANTAJA_NAYANNA	0x0DB1
#define T_UTF_16_SINHALA_LETTER_SANYAKA_DAYANNA	0x0DB3
#define T_UTF_16_SINHALA_LETTER_ALPAPRAANA_PAYANNA	0x0DB4
#define T_UTF_16_SINHALA_LETTER_MAHAAPRAANA_PAYANNA	0x0DB5
#define T_UTF_16_SINHALA_LETTER_ALPAPRAANA_BAYANNA	0x0DB6
#define T_UTF_16_SINHALA_LETTER_MAHAAPRAANA_BAYANNA	0x0DB7
#define T_UTF_16_SINHALA_LETTER_MAYANNA	0x0DB8
#define T_UTF_16_SINHALA_LETTER_AMBA_BAYANNA	0x0DB9
#define T_UTF_16_SINHALA_LETTER_YAYANNA	0x0DBA
#define T_UTF_16_SINHALA_LETTER_RAYANNA	0x0DBB
#define T_UTF_16_SINHALA_LETTER_DANTAJA_LAYANNA	0x0DBD
#define T_UTF_16_SINHALA_LETTER_VAYANNA	0x0DC0
#define T_UTF_16_SINHALA_LETTER_TAALUJA_SAYANNA	0x0DC1
#define T_UTF_16_SINHALA_LETTER_MUURDHAJA_SAYANNA	0x0DC2
#define T_UTF_16_SINHALA_LETTER_DANTAJA_SAYANNA	0x0DC3
#define T_UTF_16_SINHALA_LETTER_HAYANNA	0x0DC4
#define T_UTF_16_SINHALA_LETTER_MUURDHAJA_LAYANNA	0x0DC5
#define T_UTF_16_SINHALA_LETTER_FAYANNA	0x0DC6
#define T_UTF_16_SINHALA_SIGN_AL_LAKUNA	0x0DCA
#define T_UTF_16_SINHALA_VOWEL_SIGN_AELA_PILLA	0x0DCF
#define T_UTF_16_SINHALA_VOWEL_SIGN_KETTI_AEDA_PILLA	0x0DD0
#define T_UTF_16_SINHALA_VOWEL_SIGN_DIGA_AEDA_PILLA	0x0DD1
#define T_UTF_16_SINHALA_VOWEL_SIGN_KETTI_IS_PILLA	0x0DD2
#define T_UTF_16_SINHALA_VOWEL_SIGN_DIGA_IS_PILLA	0x0DD3
#define T_UTF_16_SINHALA_VOWEL_SIGN_KETTI_PAA_PILLA	0x0DD4
#define T_UTF_16_SINHALA_VOWEL_SIGN_DIGA_PAA_PILLA	0x0DD6
#define T_UTF_16_SINHALA_VOWEL_SIGN_GAETTA_PILLA	0x0DD8
#define T_UTF_16_SINHALA_VOWEL_SIGN_KOMBUVA	0x0DD9
#define T_UTF_16_SINHALA_VOWEL_SIGN_DIGA_KOMBUVA	0x0DDA
#define T_UTF_16_SINHALA_VOWEL_SIGN_KOMBU_DEKA	0x0DDB
#define T_UTF_16_SINHALA_VOWEL_SIGN_KOMBUVA_HAA_AELA_PILLA	0x0DDC
#define T_UTF_16_SINHALA_VOWEL_SIGN_KOMBUVA_HAA_DIGA_AELA_PILLA	0x0DDD
#define T_UTF_16_SINHALA_VOWEL_SIGN_KOMBUVA_HAA_GAYANUKITTA	0x0DDE
#define T_UTF_16_SINHALA_VOWEL_SIGN_GAYANUKITTA	0x0DDF
#define T_UTF_16_SINHALA_VOWEL_SIGN_DIGA_GAETTA_PILLA	0x0DF2
#define T_UTF_16_SINHALA_VOWEL_SIGN_DIGA_GAYANUKITTA	0x0DF3
#define T_UTF_16_SINHALA_PUNCTUATION_KUNDDALIYA	0x0DF4
#define T_UTF_16_THAI_CHARACTER_KO_KAI	0x0E01
#define T_UTF_16_THAI_CHARACTER_KHO_KHAI	0x0E02
#define T_UTF_16_THAI_CHARACTER_KHO_KHUAT	0x0E03
#define T_UTF_16_THAI_CHARACTER_KHO_KHWAI	0x0E04
#define T_UTF_16_THAI_CHARACTER_KHO_KHON	0x0E05
#define T_UTF_16_THAI_CHARACTER_KHO_RAKHANG	0x0E06
#define T_UTF_16_THAI_CHARACTER_NGO_NGU	0x0E07
#define T_UTF_16_THAI_CHARACTER_CHO_CHAN	0x0E08
#define T_UTF_16_THAI_CHARACTER_CHO_CHING	0x0E09
#define T_UTF_16_THAI_CHARACTER_CHO_CHANG	0x0E0A
#define T_UTF_16_THAI_CHARACTER_SO_SO	0x0E0B
#define T_UTF_16_THAI_CHARACTER_CHO_CHOE	0x0E0C
#define T_UTF_16_THAI_CHARACTER_YO_YING	0x0E0D
#define T_UTF_16_THAI_CHARACTER_DO_CHADA	0x0E0E
#define T_UTF_16_THAI_CHARACTER_TO_PATAK	0x0E0F
#define T_UTF_16_THAI_CHARACTER_THO_THAN	0x0E10
#define T_UTF_16_THAI_CHARACTER_THO_NANGMONTHO	0x0E11
#define T_UTF_16_THAI_CHARACTER_THO_PHUTHAO	0x0E12
#define T_UTF_16_THAI_CHARACTER_NO_NEN	0x0E13
#define T_UTF_16_THAI_CHARACTER_DO_DEK	0x0E14
#define T_UTF_16_THAI_CHARACTER_TO_TAO	0x0E15
#define T_UTF_16_THAI_CHARACTER_THO_THUNG	0x0E16
#define T_UTF_16_THAI_CHARACTER_THO_THAHAN	0x0E17
#define T_UTF_16_THAI_CHARACTER_THO_THONG	0x0E18
#define T_UTF_16_THAI_CHARACTER_NO_NU	0x0E19
#define T_UTF_16_THAI_CHARACTER_BO_BAIMAI	0x0E1A
#define T_UTF_16_THAI_CHARACTER_PO_PLA	0x0E1B
#define T_UTF_16_THAI_CHARACTER_PHO_PHUNG	0x0E1C
#define T_UTF_16_THAI_CHARACTER_FO_FA	0x0E1D
#define T_UTF_16_THAI_CHARACTER_PHO_PHAN	0x0E1E
#define T_UTF_16_THAI_CHARACTER_FO_FAN	0x0E1F
#define T_UTF_16_THAI_CHARACTER_PHO_SAMPHAO	0x0E20
#define T_UTF_16_THAI_CHARACTER_MO_MA	0x0E21
#define T_UTF_16_THAI_CHARACTER_YO_YAK	0x0E22
#define T_UTF_16_THAI_CHARACTER_RO_RUA	0x0E23
#define T_UTF_16_THAI_CHARACTER_RU	0x0E24
#define T_UTF_16_THAI_CHARACTER_LO_LING	0x0E25
#define T_UTF_16_THAI_CHARACTER_LU	0x0E26
#define T_UTF_16_THAI_CHARACTER_WO_WAEN	0x0E27
#define T_UTF_16_THAI_CHARACTER_SO_SALA	0x0E28
#define T_UTF_16_THAI_CHARACTER_SO_RUSI	0x0E29
#define T_UTF_16_THAI_CHARACTER_SO_SUA	0x0E2A
#define T_UTF_16_THAI_CHARACTER_HO_HIP	0x0E2B
#define T_UTF_16_THAI_CHARACTER_LO_CHULA	0x0E2C
#define T_UTF_16_THAI_CHARACTER_O_ANG	0x0E2D
#define T_UTF_16_THAI_CHARACTER_HO_NOKHUK	0x0E2E
#define T_UTF_16_THAI_CHARACTER_PAIYANNOI	0x0E2F
#define T_UTF_16_THAI_CHARACTER_SARA_A	0x0E30
#define T_UTF_16_THAI_CHARACTER_MAI_HAN_AKAT	0x0E31
#define T_UTF_16_THAI_CHARACTER_SARA_AA	0x0E32
#define T_UTF_16_THAI_CHARACTER_SARA_AM	0x0E33
#define T_UTF_16_THAI_CHARACTER_SARA_I	0x0E34
#define T_UTF_16_THAI_CHARACTER_SARA_II	0x0E35
#define T_UTF_16_THAI_CHARACTER_SARA_UE	0x0E36
#define T_UTF_16_THAI_CHARACTER_SARA_UEE	0x0E37
#define T_UTF_16_THAI_CHARACTER_SARA_U	0x0E38
#define T_UTF_16_THAI_CHARACTER_SARA_UU	0x0E39
#define T_UTF_16_THAI_CHARACTER_PHINTHU	0x0E3A
#define T_UTF_16_THAI_CURRENCY_SYMBOL_BAHT	0x0E3F
#define T_UTF_16_THAI_CHARACTER_SARA_E	0x0E40
#define T_UTF_16_THAI_CHARACTER_SARA_AE	0x0E41
#define T_UTF_16_THAI_CHARACTER_SARA_O	0x0E42
#define T_UTF_16_THAI_CHARACTER_SARA_AI_MAIMUAN	0x0E43
#define T_UTF_16_THAI_CHARACTER_SARA_AI_MAIMALAI	0x0E44
#define T_UTF_16_THAI_CHARACTER_LAKKHANGYAO	0x0E45
#define T_UTF_16_THAI_CHARACTER_MAIYAMOK	0x0E46
#define T_UTF_16_THAI_CHARACTER_MAITAIKHU	0x0E47
#define T_UTF_16_THAI_CHARACTER_MAI_EK	0x0E48
#define T_UTF_16_THAI_CHARACTER_MAI_THO	0x0E49
#define T_UTF_16_THAI_CHARACTER_MAI_TRI	0x0E4A
#define T_UTF_16_THAI_CHARACTER_MAI_CHATTAWA	0x0E4B
#define T_UTF_16_THAI_CHARACTER_THANTHAKHAT	0x0E4C
#define T_UTF_16_THAI_CHARACTER_NIKHAHIT	0x0E4D
#define T_UTF_16_THAI_CHARACTER_YAMAKKAN	0x0E4E
#define T_UTF_16_THAI_CHARACTER_FONGMAN	0x0E4F
#define T_UTF_16_THAI_DIGIT_ZERO	0x0E50
#define T_UTF_16_THAI_DIGIT_ONE	0x0E51
#define T_UTF_16_THAI_DIGIT_TWO	0x0E52
#define T_UTF_16_THAI_DIGIT_THREE	0x0E53
#define T_UTF_16_THAI_DIGIT_FOUR	0x0E54
#define T_UTF_16_THAI_DIGIT_FIVE	0x0E55
#define T_UTF_16_THAI_DIGIT_SIX	0x0E56
#define T_UTF_16_THAI_DIGIT_SEVEN	0x0E57
#define T_UTF_16_THAI_DIGIT_EIGHT	0x0E58
#define T_UTF_16_THAI_DIGIT_NINE	0x0E59
#define T_UTF_16_THAI_CHARACTER_ANGKHANKHU	0x0E5A
#define T_UTF_16_THAI_CHARACTER_KHOMUT	0x0E5B
#define T_UTF_16_LAO_LETTER_KO	0x0E81
#define T_UTF_16_LAO_LETTER_KHO_SUNG	0x0E82
#define T_UTF_16_LAO_LETTER_KHO_TAM	0x0E84
#define T_UTF_16_LAO_LETTER_NGO	0x0E87
#define T_UTF_16_LAO_LETTER_CO	0x0E88
#define T_UTF_16_LAO_LETTER_SO_TAM	0x0E8A
#define T_UTF_16_LAO_LETTER_NYO	0x0E8D
#define T_UTF_16_LAO_LETTER_DO	0x0E94
#define T_UTF_16_LAO_LETTER_TO	0x0E95
#define T_UTF_16_LAO_LETTER_THO_SUNG	0x0E96
#define T_UTF_16_LAO_LETTER_THO_TAM	0x0E97
#define T_UTF_16_LAO_LETTER_NO	0x0E99
#define T_UTF_16_LAO_LETTER_BO	0x0E9A
#define T_UTF_16_LAO_LETTER_PO	0x0E9B
#define T_UTF_16_LAO_LETTER_PHO_SUNG	0x0E9C
#define T_UTF_16_LAO_LETTER_FO_TAM	0x0E9D
#define T_UTF_16_LAO_LETTER_PHO_TAM	0x0E9E
#define T_UTF_16_LAO_LETTER_FO_SUNG	0x0E9F
#define T_UTF_16_LAO_LETTER_MO	0x0EA1
#define T_UTF_16_LAO_LETTER_YO	0x0EA2
#define T_UTF_16_LAO_LETTER_LO_LING	0x0EA3
#define T_UTF_16_LAO_LETTER_LO_LOOT	0x0EA5
#define T_UTF_16_LAO_LETTER_WO	0x0EA7
#define T_UTF_16_LAO_LETTER_SO_SUNG	0x0EAA
#define T_UTF_16_LAO_LETTER_HO_SUNG	0x0EAB
#define T_UTF_16_LAO_LETTER_O	0x0EAD
#define T_UTF_16_LAO_LETTER_HO_TAM	0x0EAE
#define T_UTF_16_LAO_ELLIPSIS	0x0EAF
#define T_UTF_16_LAO_VOWEL_SIGN_A	0x0EB0
#define T_UTF_16_LAO_VOWEL_SIGN_MAI_KAN	0x0EB1
#define T_UTF_16_LAO_VOWEL_SIGN_AA	0x0EB2
#define T_UTF_16_LAO_VOWEL_SIGN_AM	0x0EB3
#define T_UTF_16_LAO_VOWEL_SIGN_I	0x0EB4
#define T_UTF_16_LAO_VOWEL_SIGN_II	0x0EB5
#define T_UTF_16_LAO_VOWEL_SIGN_Y	0x0EB6
#define T_UTF_16_LAO_VOWEL_SIGN_YY	0x0EB7
#define T_UTF_16_LAO_VOWEL_SIGN_U	0x0EB8
#define T_UTF_16_LAO_VOWEL_SIGN_UU	0x0EB9
#define T_UTF_16_LAO_VOWEL_SIGN_MAI_KON	0x0EBB
#define T_UTF_16_LAO_SEMIVOWEL_SIGN_LO	0x0EBC
#define T_UTF_16_LAO_SEMIVOWEL_SIGN_NYO	0x0EBD
#define T_UTF_16_LAO_VOWEL_SIGN_E	0x0EC0
#define T_UTF_16_LAO_VOWEL_SIGN_EI	0x0EC1
#define T_UTF_16_LAO_VOWEL_SIGN_O	0x0EC2
#define T_UTF_16_LAO_VOWEL_SIGN_AY	0x0EC3
#define T_UTF_16_LAO_VOWEL_SIGN_AI	0x0EC4
#define T_UTF_16_LAO_KO_LA	0x0EC6
#define T_UTF_16_LAO_TONE_MAI_EK	0x0EC8
#define T_UTF_16_LAO_TONE_MAI_THO	0x0EC9
#define T_UTF_16_LAO_TONE_MAI_TI	0x0ECA
#define T_UTF_16_LAO_TONE_MAI_CATAWA	0x0ECB
#define T_UTF_16_LAO_CANCELLATION_MARK	0x0ECC
#define T_UTF_16_LAO_NIGGAHITA	0x0ECD
#define T_UTF_16_LAO_DIGIT_ZERO	0x0ED0
#define T_UTF_16_LAO_DIGIT_ONE	0x0ED1
#define T_UTF_16_LAO_DIGIT_TWO	0x0ED2
#define T_UTF_16_LAO_DIGIT_THREE	0x0ED3
#define T_UTF_16_LAO_DIGIT_FOUR	0x0ED4
#define T_UTF_16_LAO_DIGIT_FIVE	0x0ED5
#define T_UTF_16_LAO_DIGIT_SIX	0x0ED6
#define T_UTF_16_LAO_DIGIT_SEVEN	0x0ED7
#define T_UTF_16_LAO_DIGIT_EIGHT	0x0ED8
#define T_UTF_16_LAO_DIGIT_NINE	0x0ED9
#define T_UTF_16_LAO_HO_NO	0x0EDC
#define T_UTF_16_LAO_HO_MO	0x0EDD
#define T_UTF_16_TIBETAN_SYLLABLE_OM	0x0F00
#define T_UTF_16_TIBETAN_MARK_GTER_YIG_MGO_TRUNCATED_A	0x0F01
#define T_UTF_16_TIBETAN_MARK_GTER_YIG_MGO__UM_RNAM_BCAD_MA	0x0F02
#define T_UTF_16_TIBETAN_MARK_GTER_YIG_MGO__UM_GTER_TSHEG_MA	0x0F03
#define T_UTF_16_TIBETAN_MARK_INITIAL_YIG_MGO_MDUN_MA	0x0F04
#define T_UTF_16_TIBETAN_MARK_CLOSING_YIG_MGO_SGAB_MA	0x0F05
#define T_UTF_16_TIBETAN_MARK_CARET_YIG_MGO_PHUR_SHAD_MA	0x0F06
#define T_UTF_16_TIBETAN_MARK_YIG_MGO_TSHEG_SHAD_MA	0x0F07
#define T_UTF_16_TIBETAN_MARK_SBRUL_SHAD	0x0F08
#define T_UTF_16_TIBETAN_MARK_BSKUR_YIG_MGO	0x0F09
#define T_UTF_16_TIBETAN_MARK_BKA__SHOG_YIG_MGO	0x0F0A
#define T_UTF_16_TIBETAN_MARK_INTERSYLLABIC_TSHEG	0x0F0B
#define T_UTF_16_TIBETAN_MARK_DELIMITER_TSHEG_BSTAR	0x0F0C
#define T_UTF_16_TIBETAN_MARK_SHAD	0x0F0D
#define T_UTF_16_TIBETAN_MARK_NYIS_SHAD	0x0F0E
#define T_UTF_16_TIBETAN_MARK_TSHEG_SHAD	0x0F0F
#define T_UTF_16_TIBETAN_MARK_NYIS_TSHEG_SHAD	0x0F10
#define T_UTF_16_TIBETAN_MARK_RIN_CHEN_SPUNGS_SHAD	0x0F11
#define T_UTF_16_TIBETAN_MARK_RGYA_GRAM_SHAD	0x0F12
#define T_UTF_16_TIBETAN_MARK_CARET__DZUD_RTAGS_ME_LONG_CAN	0x0F13
#define T_UTF_16_TIBETAN_MARK_GTER_TSHEG	0x0F14
#define T_UTF_16_TIBETAN_LOGOTYPE_SIGN_CHAD_RTAGS	0x0F15
#define T_UTF_16_TIBETAN_LOGOTYPE_SIGN_LHAG_RTAGS	0x0F16
#define T_UTF_16_TIBETAN_ASTROLOGICAL_SIGN_SGRA_GCAN__CHAR_RTAGS	0x0F17
#define T_UTF_16_TIBETAN_ASTROLOGICAL_SIGN__KHYUD_PA	0x0F18
#define T_UTF_16_TIBETAN_ASTROLOGICAL_SIGN_SDONG_TSHUGS	0x0F19
#define T_UTF_16_TIBETAN_SIGN_RDEL_DKAR_GCIG	0x0F1A
#define T_UTF_16_TIBETAN_SIGN_RDEL_DKAR_GNYIS	0x0F1B
#define T_UTF_16_TIBETAN_SIGN_RDEL_DKAR_GSUM	0x0F1C
#define T_UTF_16_TIBETAN_SIGN_RDEL_NAG_GCIG	0x0F1D
#define T_UTF_16_TIBETAN_SIGN_RDEL_NAG_GNYIS	0x0F1E
#define T_UTF_16_TIBETAN_SIGN_RDEL_DKAR_RDEL_NAG	0x0F1F
#define T_UTF_16_TIBETAN_DIGIT_ZERO	0x0F20
#define T_UTF_16_TIBETAN_DIGIT_ONE	0x0F21
#define T_UTF_16_TIBETAN_DIGIT_TWO	0x0F22
#define T_UTF_16_TIBETAN_DIGIT_THREE	0x0F23
#define T_UTF_16_TIBETAN_DIGIT_FOUR	0x0F24
#define T_UTF_16_TIBETAN_DIGIT_FIVE	0x0F25
#define T_UTF_16_TIBETAN_DIGIT_SIX	0x0F26
#define T_UTF_16_TIBETAN_DIGIT_SEVEN	0x0F27
#define T_UTF_16_TIBETAN_DIGIT_EIGHT	0x0F28
#define T_UTF_16_TIBETAN_DIGIT_NINE	0x0F29
#define T_UTF_16_TIBETAN_DIGIT_HALF_ONE	0x0F2A
#define T_UTF_16_TIBETAN_DIGIT_HALF_TWO	0x0F2B
#define T_UTF_16_TIBETAN_DIGIT_HALF_THREE	0x0F2C
#define T_UTF_16_TIBETAN_DIGIT_HALF_FOUR	0x0F2D
#define T_UTF_16_TIBETAN_DIGIT_HALF_FIVE	0x0F2E
#define T_UTF_16_TIBETAN_DIGIT_HALF_SIX	0x0F2F
#define T_UTF_16_TIBETAN_DIGIT_HALF_SEVEN	0x0F30
#define T_UTF_16_TIBETAN_DIGIT_HALF_EIGHT	0x0F31
#define T_UTF_16_TIBETAN_DIGIT_HALF_NINE	0x0F32
#define T_UTF_16_TIBETAN_DIGIT_HALF_ZERO	0x0F33
#define T_UTF_16_TIBETAN_MARK_BSDUS_RTAGS	0x0F34
#define T_UTF_16_TIBETAN_MARK_NGAS_BZUNG_NYI_ZLA	0x0F35
#define T_UTF_16_TIBETAN_MARK_CARET__DZUD_RTAGS_BZHI_MIG_CAN	0x0F36
#define T_UTF_16_TIBETAN_MARK_NGAS_BZUNG_SGOR_RTAGS	0x0F37
#define T_UTF_16_TIBETAN_MARK_CHE_MGO	0x0F38
#define T_UTF_16_TIBETAN_MARK_TSA__PHRU	0x0F39
#define T_UTF_16_TIBETAN_MARK_GUG_RTAGS_GYON	0x0F3A
#define T_UTF_16_TIBETAN_MARK_GUG_RTAGS_GYAS	0x0F3B
#define T_UTF_16_TIBETAN_MARK_ANG_KHANG_GYON	0x0F3C
#define T_UTF_16_TIBETAN_MARK_ANG_KHANG_GYAS	0x0F3D
#define T_UTF_16_TIBETAN_SIGN_YAR_TSHES	0x0F3E
#define T_UTF_16_TIBETAN_SIGN_MAR_TSHES	0x0F3F
#define T_UTF_16_TIBETAN_LETTER_KA	0x0F40
#define T_UTF_16_TIBETAN_LETTER_KHA	0x0F41
#define T_UTF_16_TIBETAN_LETTER_GA	0x0F42
#define T_UTF_16_TIBETAN_LETTER_GHA	0x0F43
#define T_UTF_16_TIBETAN_LETTER_NGA	0x0F44
#define T_UTF_16_TIBETAN_LETTER_CA	0x0F45
#define T_UTF_16_TIBETAN_LETTER_CHA	0x0F46
#define T_UTF_16_TIBETAN_LETTER_JA	0x0F47
#define T_UTF_16_TIBETAN_LETTER_NYA	0x0F49
#define T_UTF_16_TIBETAN_LETTER_TTA	0x0F4A
#define T_UTF_16_TIBETAN_LETTER_TTHA	0x0F4B
#define T_UTF_16_TIBETAN_LETTER_DDA	0x0F4C
#define T_UTF_16_TIBETAN_LETTER_DDHA	0x0F4D
#define T_UTF_16_TIBETAN_LETTER_NNA	0x0F4E
#define T_UTF_16_TIBETAN_LETTER_TA	0x0F4F
#define T_UTF_16_TIBETAN_LETTER_THA	0x0F50
#define T_UTF_16_TIBETAN_LETTER_DA	0x0F51
#define T_UTF_16_TIBETAN_LETTER_DHA	0x0F52
#define T_UTF_16_TIBETAN_LETTER_NA	0x0F53
#define T_UTF_16_TIBETAN_LETTER_PA	0x0F54
#define T_UTF_16_TIBETAN_LETTER_PHA	0x0F55
#define T_UTF_16_TIBETAN_LETTER_BA	0x0F56
#define T_UTF_16_TIBETAN_LETTER_BHA	0x0F57
#define T_UTF_16_TIBETAN_LETTER_MA	0x0F58
#define T_UTF_16_TIBETAN_LETTER_TSA	0x0F59
#define T_UTF_16_TIBETAN_LETTER_TSHA	0x0F5A
#define T_UTF_16_TIBETAN_LETTER_DZA	0x0F5B
#define T_UTF_16_TIBETAN_LETTER_DZHA	0x0F5C
#define T_UTF_16_TIBETAN_LETTER_WA	0x0F5D
#define T_UTF_16_TIBETAN_LETTER_ZHA	0x0F5E
#define T_UTF_16_TIBETAN_LETTER_ZA	0x0F5F
#define T_UTF_16_TIBETAN_LETTER__A	0x0F60
#define T_UTF_16_TIBETAN_LETTER_YA	0x0F61
#define T_UTF_16_TIBETAN_LETTER_RA	0x0F62
#define T_UTF_16_TIBETAN_LETTER_LA	0x0F63
#define T_UTF_16_TIBETAN_LETTER_SHA	0x0F64
#define T_UTF_16_TIBETAN_LETTER_SSA	0x0F65
#define T_UTF_16_TIBETAN_LETTER_SA	0x0F66
#define T_UTF_16_TIBETAN_LETTER_HA	0x0F67
#define T_UTF_16_TIBETAN_LETTER_A	0x0F68
#define T_UTF_16_TIBETAN_LETTER_KSSA	0x0F69
#define T_UTF_16_TIBETAN_LETTER_FIXED_FORM_RA	0x0F6A
#define T_UTF_16_TIBETAN_VOWEL_SIGN_AA	0x0F71
#define T_UTF_16_TIBETAN_VOWEL_SIGN_I	0x0F72
#define T_UTF_16_TIBETAN_VOWEL_SIGN_II	0x0F73
#define T_UTF_16_TIBETAN_VOWEL_SIGN_U	0x0F74
#define T_UTF_16_TIBETAN_VOWEL_SIGN_UU	0x0F75
#define T_UTF_16_TIBETAN_VOWEL_SIGN_VOCALIC_R	0x0F76
#define T_UTF_16_TIBETAN_VOWEL_SIGN_VOCALIC_RR	0x0F77
#define T_UTF_16_TIBETAN_VOWEL_SIGN_VOCALIC_L	0x0F78
#define T_UTF_16_TIBETAN_VOWEL_SIGN_VOCALIC_LL	0x0F79
#define T_UTF_16_TIBETAN_VOWEL_SIGN_E	0x0F7A
#define T_UTF_16_TIBETAN_VOWEL_SIGN_EE	0x0F7B
#define T_UTF_16_TIBETAN_VOWEL_SIGN_O	0x0F7C
#define T_UTF_16_TIBETAN_VOWEL_SIGN_OO	0x0F7D
#define T_UTF_16_TIBETAN_SIGN_RJES_SU_NGA_RO	0x0F7E
#define T_UTF_16_TIBETAN_SIGN_RNAM_BCAD	0x0F7F
#define T_UTF_16_TIBETAN_VOWEL_SIGN_REVERSED_I	0x0F80
#define T_UTF_16_TIBETAN_VOWEL_SIGN_REVERSED_II	0x0F81
#define T_UTF_16_TIBETAN_SIGN_NYI_ZLA_NAA_DA	0x0F82
#define T_UTF_16_TIBETAN_SIGN_SNA_LDAN	0x0F83
#define T_UTF_16_TIBETAN_MARK_HALANTA	0x0F84
#define T_UTF_16_TIBETAN_MARK_PALUTA	0x0F85
#define T_UTF_16_TIBETAN_SIGN_LCI_RTAGS	0x0F86
#define T_UTF_16_TIBETAN_SIGN_YANG_RTAGS	0x0F87
#define T_UTF_16_TIBETAN_SIGN_LCE_TSA_CAN	0x0F88
#define T_UTF_16_TIBETAN_SIGN_MCHU_CAN	0x0F89
#define T_UTF_16_TIBETAN_SIGN_GRU_CAN_RGYINGS	0x0F8A
#define T_UTF_16_TIBETAN_SIGN_GRU_MED_RGYINGS	0x0F8B
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_KA	0x0F90
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_KHA	0x0F91
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_GA	0x0F92
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_GHA	0x0F93
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_NGA	0x0F94
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_CA	0x0F95
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_CHA	0x0F96
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_JA	0x0F97
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_NYA	0x0F99
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_TTA	0x0F9A
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_TTHA	0x0F9B
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_DDA	0x0F9C
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_DDHA	0x0F9D
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_NNA	0x0F9E
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_TA	0x0F9F
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_THA	0x0FA0
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_DA	0x0FA1
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_DHA	0x0FA2
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_NA	0x0FA3
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_PA	0x0FA4
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_PHA	0x0FA5
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_BA	0x0FA6
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_BHA	0x0FA7
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_MA	0x0FA8
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_TSA	0x0FA9
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_TSHA	0x0FAA
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_DZA	0x0FAB
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_DZHA	0x0FAC
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_WA	0x0FAD
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_ZHA	0x0FAE
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_ZA	0x0FAF
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER__A	0x0FB0
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_YA	0x0FB1
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_RA	0x0FB2
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_LA	0x0FB3
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_SHA	0x0FB4
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_SSA	0x0FB5
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_SA	0x0FB6
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_HA	0x0FB7
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_A	0x0FB8
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_KSSA	0x0FB9
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_FIXED_FORM_WA	0x0FBA
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_FIXED_FORM_YA	0x0FBB
#define T_UTF_16_TIBETAN_SUBJOINED_LETTER_FIXED_FORM_RA	0x0FBC
#define T_UTF_16_TIBETAN_KU_RU_KHA	0x0FBE
#define T_UTF_16_TIBETAN_KU_RU_KHA_BZHI_MIG_CAN	0x0FBF
#define T_UTF_16_TIBETAN_CANTILLATION_SIGN_HEAVY_BEAT	0x0FC0
#define T_UTF_16_TIBETAN_CANTILLATION_SIGN_LIGHT_BEAT	0x0FC1
#define T_UTF_16_TIBETAN_CANTILLATION_SIGN_CANG_TE_U	0x0FC2
#define T_UTF_16_TIBETAN_CANTILLATION_SIGN_SBUB__CHAL	0x0FC3
#define T_UTF_16_TIBETAN_SYMBOL_DRIL_BU	0x0FC4
#define T_UTF_16_TIBETAN_SYMBOL_RDO_RJE	0x0FC5
#define T_UTF_16_TIBETAN_SYMBOL_PADMA_GDAN	0x0FC6
#define T_UTF_16_TIBETAN_SYMBOL_RDO_RJE_RGYA_GRAM	0x0FC7
#define T_UTF_16_TIBETAN_SYMBOL_PHUR_PA	0x0FC8
#define T_UTF_16_TIBETAN_SYMBOL_NOR_BU	0x0FC9
#define T_UTF_16_TIBETAN_SYMBOL_NOR_BU_NYIS__KHYIL	0x0FCA
#define T_UTF_16_TIBETAN_SYMBOL_NOR_BU_GSUM__KHYIL	0x0FCB
#define T_UTF_16_TIBETAN_SYMBOL_NOR_BU_BZHI__KHYIL	0x0FCC
#define T_UTF_16_TIBETAN_SIGN_RDEL_NAG_GSUM	0x0FCF
#define T_UTF_16_MYANMAR_LETTER_KA	0x1000
#define T_UTF_16_MYANMAR_LETTER_KHA	0x1001
#define T_UTF_16_MYANMAR_LETTER_GA	0x1002
#define T_UTF_16_MYANMAR_LETTER_GHA	0x1003
#define T_UTF_16_MYANMAR_LETTER_NGA	0x1004
#define T_UTF_16_MYANMAR_LETTER_CA	0x1005
#define T_UTF_16_MYANMAR_LETTER_CHA	0x1006
#define T_UTF_16_MYANMAR_LETTER_JA	0x1007
#define T_UTF_16_MYANMAR_LETTER_JHA	0x1008
#define T_UTF_16_MYANMAR_LETTER_NYA	0x1009
#define T_UTF_16_MYANMAR_LETTER_NNYA	0x100A
#define T_UTF_16_MYANMAR_LETTER_TTA	0x100B
#define T_UTF_16_MYANMAR_LETTER_TTHA	0x100C
#define T_UTF_16_MYANMAR_LETTER_DDA	0x100D
#define T_UTF_16_MYANMAR_LETTER_DDHA	0x100E
#define T_UTF_16_MYANMAR_LETTER_NNA	0x100F
#define T_UTF_16_MYANMAR_LETTER_TA	0x1010
#define T_UTF_16_MYANMAR_LETTER_THA	0x1011
#define T_UTF_16_MYANMAR_LETTER_DA	0x1012
#define T_UTF_16_MYANMAR_LETTER_DHA	0x1013
#define T_UTF_16_MYANMAR_LETTER_NA	0x1014
#define T_UTF_16_MYANMAR_LETTER_PA	0x1015
#define T_UTF_16_MYANMAR_LETTER_PHA	0x1016
#define T_UTF_16_MYANMAR_LETTER_BA	0x1017
#define T_UTF_16_MYANMAR_LETTER_BHA	0x1018
#define T_UTF_16_MYANMAR_LETTER_MA	0x1019
#define T_UTF_16_MYANMAR_LETTER_YA	0x101A
#define T_UTF_16_MYANMAR_LETTER_RA	0x101B
#define T_UTF_16_MYANMAR_LETTER_LA	0x101C
#define T_UTF_16_MYANMAR_LETTER_WA	0x101D
#define T_UTF_16_MYANMAR_LETTER_SA	0x101E
#define T_UTF_16_MYANMAR_LETTER_HA	0x101F
#define T_UTF_16_MYANMAR_LETTER_LLA	0x1020
#define T_UTF_16_MYANMAR_LETTER_A	0x1021
#define T_UTF_16_MYANMAR_LETTER_I	0x1023
#define T_UTF_16_MYANMAR_LETTER_II	0x1024
#define T_UTF_16_MYANMAR_LETTER_U	0x1025
#define T_UTF_16_MYANMAR_LETTER_UU	0x1026
#define T_UTF_16_MYANMAR_LETTER_E	0x1027
#define T_UTF_16_MYANMAR_LETTER_O	0x1029
#define T_UTF_16_MYANMAR_LETTER_AU	0x102A
#define T_UTF_16_MYANMAR_VOWEL_SIGN_AA	0x102C
#define T_UTF_16_MYANMAR_VOWEL_SIGN_I	0x102D
#define T_UTF_16_MYANMAR_VOWEL_SIGN_II	0x102E
#define T_UTF_16_MYANMAR_VOWEL_SIGN_U	0x102F
#define T_UTF_16_MYANMAR_VOWEL_SIGN_UU	0x1030
#define T_UTF_16_MYANMAR_VOWEL_SIGN_E	0x1031
#define T_UTF_16_MYANMAR_VOWEL_SIGN_AI	0x1032
#define T_UTF_16_MYANMAR_SIGN_ANUSVARA	0x1036
#define T_UTF_16_MYANMAR_SIGN_DOT_BELOW	0x1037
#define T_UTF_16_MYANMAR_SIGN_VISARGA	0x1038
#define T_UTF_16_MYANMAR_SIGN_VIRAMA	0x1039
#define T_UTF_16_MYANMAR_DIGIT_ZERO	0x1040
#define T_UTF_16_MYANMAR_DIGIT_ONE	0x1041
#define T_UTF_16_MYANMAR_DIGIT_TWO	0x1042
#define T_UTF_16_MYANMAR_DIGIT_THREE	0x1043
#define T_UTF_16_MYANMAR_DIGIT_FOUR	0x1044
#define T_UTF_16_MYANMAR_DIGIT_FIVE	0x1045
#define T_UTF_16_MYANMAR_DIGIT_SIX	0x1046
#define T_UTF_16_MYANMAR_DIGIT_SEVEN	0x1047
#define T_UTF_16_MYANMAR_DIGIT_EIGHT	0x1048
#define T_UTF_16_MYANMAR_DIGIT_NINE	0x1049
#define T_UTF_16_MYANMAR_SIGN_LITTLE_SECTION	0x104A
#define T_UTF_16_MYANMAR_SIGN_SECTION	0x104B
#define T_UTF_16_MYANMAR_SYMBOL_LOCATIVE	0x104C
#define T_UTF_16_MYANMAR_SYMBOL_COMPLETED	0x104D
#define T_UTF_16_MYANMAR_SYMBOL_AFOREMENTIONED	0x104E
#define T_UTF_16_MYANMAR_SYMBOL_GENITIVE	0x104F
#define T_UTF_16_MYANMAR_LETTER_SHA	0x1050
#define T_UTF_16_MYANMAR_LETTER_SSA	0x1051
#define T_UTF_16_MYANMAR_LETTER_VOCALIC_R	0x1052
#define T_UTF_16_MYANMAR_LETTER_VOCALIC_RR	0x1053
#define T_UTF_16_MYANMAR_LETTER_VOCALIC_L	0x1054
#define T_UTF_16_MYANMAR_LETTER_VOCALIC_LL	0x1055
#define T_UTF_16_MYANMAR_VOWEL_SIGN_VOCALIC_R	0x1056
#define T_UTF_16_MYANMAR_VOWEL_SIGN_VOCALIC_RR	0x1057
#define T_UTF_16_MYANMAR_VOWEL_SIGN_VOCALIC_L	0x1058
#define T_UTF_16_MYANMAR_VOWEL_SIGN_VOCALIC_LL	0x1059
#define T_UTF_16_GEORGIAN_CAPITAL_LETTER_AN	0x10A0
#define T_UTF_16_GEORGIAN_CAPITAL_LETTER_BAN	0x10A1
#define T_UTF_16_GEORGIAN_CAPITAL_LETTER_GAN	0x10A2
#define T_UTF_16_GEORGIAN_CAPITAL_LETTER_DON	0x10A3
#define T_UTF_16_GEORGIAN_CAPITAL_LETTER_EN	0x10A4
#define T_UTF_16_GEORGIAN_CAPITAL_LETTER_VIN	0x10A5
#define T_UTF_16_GEORGIAN_CAPITAL_LETTER_ZEN	0x10A6
#define T_UTF_16_GEORGIAN_CAPITAL_LETTER_TAN	0x10A7
#define T_UTF_16_GEORGIAN_CAPITAL_LETTER_IN	0x10A8
#define T_UTF_16_GEORGIAN_CAPITAL_LETTER_KAN	0x10A9
#define T_UTF_16_GEORGIAN_CAPITAL_LETTER_LAS	0x10AA
#define T_UTF_16_GEORGIAN_CAPITAL_LETTER_MAN	0x10AB
#define T_UTF_16_GEORGIAN_CAPITAL_LETTER_NAR	0x10AC
#define T_UTF_16_GEORGIAN_CAPITAL_LETTER_ON	0x10AD
#define T_UTF_16_GEORGIAN_CAPITAL_LETTER_PAR	0x10AE
#define T_UTF_16_GEORGIAN_CAPITAL_LETTER_ZHAR	0x10AF
#define T_UTF_16_GEORGIAN_CAPITAL_LETTER_RAE	0x10B0
#define T_UTF_16_GEORGIAN_CAPITAL_LETTER_SAN	0x10B1
#define T_UTF_16_GEORGIAN_CAPITAL_LETTER_TAR	0x10B2
#define T_UTF_16_GEORGIAN_CAPITAL_LETTER_UN	0x10B3
#define T_UTF_16_GEORGIAN_CAPITAL_LETTER_PHAR	0x10B4
#define T_UTF_16_GEORGIAN_CAPITAL_LETTER_KHAR	0x10B5
#define T_UTF_16_GEORGIAN_CAPITAL_LETTER_GHAN	0x10B6
#define T_UTF_16_GEORGIAN_CAPITAL_LETTER_QAR	0x10B7
#define T_UTF_16_GEORGIAN_CAPITAL_LETTER_SHIN	0x10B8
#define T_UTF_16_GEORGIAN_CAPITAL_LETTER_CHIN	0x10B9
#define T_UTF_16_GEORGIAN_CAPITAL_LETTER_CAN	0x10BA
#define T_UTF_16_GEORGIAN_CAPITAL_LETTER_JIL	0x10BB
#define T_UTF_16_GEORGIAN_CAPITAL_LETTER_CIL	0x10BC
#define T_UTF_16_GEORGIAN_CAPITAL_LETTER_CHAR	0x10BD
#define T_UTF_16_GEORGIAN_CAPITAL_LETTER_XAN	0x10BE
#define T_UTF_16_GEORGIAN_CAPITAL_LETTER_JHAN	0x10BF
#define T_UTF_16_GEORGIAN_CAPITAL_LETTER_HAE	0x10C0
#define T_UTF_16_GEORGIAN_CAPITAL_LETTER_HE	0x10C1
#define T_UTF_16_GEORGIAN_CAPITAL_LETTER_HIE	0x10C2
#define T_UTF_16_GEORGIAN_CAPITAL_LETTER_WE	0x10C3
#define T_UTF_16_GEORGIAN_CAPITAL_LETTER_HAR	0x10C4
#define T_UTF_16_GEORGIAN_CAPITAL_LETTER_HOE	0x10C5
#define T_UTF_16_GEORGIAN_LETTER_AN	0x10D0
#define T_UTF_16_GEORGIAN_LETTER_BAN	0x10D1
#define T_UTF_16_GEORGIAN_LETTER_GAN	0x10D2
#define T_UTF_16_GEORGIAN_LETTER_DON	0x10D3
#define T_UTF_16_GEORGIAN_LETTER_EN	0x10D4
#define T_UTF_16_GEORGIAN_LETTER_VIN	0x10D5
#define T_UTF_16_GEORGIAN_LETTER_ZEN	0x10D6
#define T_UTF_16_GEORGIAN_LETTER_TAN	0x10D7
#define T_UTF_16_GEORGIAN_LETTER_IN	0x10D8
#define T_UTF_16_GEORGIAN_LETTER_KAN	0x10D9
#define T_UTF_16_GEORGIAN_LETTER_LAS	0x10DA
#define T_UTF_16_GEORGIAN_LETTER_MAN	0x10DB
#define T_UTF_16_GEORGIAN_LETTER_NAR	0x10DC
#define T_UTF_16_GEORGIAN_LETTER_ON	0x10DD
#define T_UTF_16_GEORGIAN_LETTER_PAR	0x10DE
#define T_UTF_16_GEORGIAN_LETTER_ZHAR	0x10DF
#define T_UTF_16_GEORGIAN_LETTER_RAE	0x10E0
#define T_UTF_16_GEORGIAN_LETTER_SAN	0x10E1
#define T_UTF_16_GEORGIAN_LETTER_TAR	0x10E2
#define T_UTF_16_GEORGIAN_LETTER_UN	0x10E3
#define T_UTF_16_GEORGIAN_LETTER_PHAR	0x10E4
#define T_UTF_16_GEORGIAN_LETTER_KHAR	0x10E5
#define T_UTF_16_GEORGIAN_LETTER_GHAN	0x10E6
#define T_UTF_16_GEORGIAN_LETTER_QAR	0x10E7
#define T_UTF_16_GEORGIAN_LETTER_SHIN	0x10E8
#define T_UTF_16_GEORGIAN_LETTER_CHIN	0x10E9
#define T_UTF_16_GEORGIAN_LETTER_CAN	0x10EA
#define T_UTF_16_GEORGIAN_LETTER_JIL	0x10EB
#define T_UTF_16_GEORGIAN_LETTER_CIL	0x10EC
#define T_UTF_16_GEORGIAN_LETTER_CHAR	0x10ED
#define T_UTF_16_GEORGIAN_LETTER_XAN	0x10EE
#define T_UTF_16_GEORGIAN_LETTER_JHAN	0x10EF
#define T_UTF_16_GEORGIAN_LETTER_HAE	0x10F0
#define T_UTF_16_GEORGIAN_LETTER_HE	0x10F1
#define T_UTF_16_GEORGIAN_LETTER_HIE	0x10F2
#define T_UTF_16_GEORGIAN_LETTER_WE	0x10F3
#define T_UTF_16_GEORGIAN_LETTER_HAR	0x10F4
#define T_UTF_16_GEORGIAN_LETTER_HOE	0x10F5
#define T_UTF_16_GEORGIAN_LETTER_FI	0x10F6
#define T_UTF_16_GEORGIAN_PARAGRAPH_SEPARATOR	0x10FB
#define T_UTF_16_HANGUL_CHOSEONG_KIYEOK	0x1100
#define T_UTF_16_HANGUL_CHOSEONG_SSANGKIYEOK	0x1101
#define T_UTF_16_HANGUL_CHOSEONG_NIEUN	0x1102
#define T_UTF_16_HANGUL_CHOSEONG_TIKEUT	0x1103
#define T_UTF_16_HANGUL_CHOSEONG_SSANGTIKEUT	0x1104
#define T_UTF_16_HANGUL_CHOSEONG_RIEUL	0x1105
#define T_UTF_16_HANGUL_CHOSEONG_MIEUM	0x1106
#define T_UTF_16_HANGUL_CHOSEONG_PIEUP	0x1107
#define T_UTF_16_HANGUL_CHOSEONG_SSANGPIEUP	0x1108
#define T_UTF_16_HANGUL_CHOSEONG_SIOS	0x1109
#define T_UTF_16_HANGUL_CHOSEONG_SSANGSIOS	0x110A
#define T_UTF_16_HANGUL_CHOSEONG_IEUNG	0x110B
#define T_UTF_16_HANGUL_CHOSEONG_CIEUC	0x110C
#define T_UTF_16_HANGUL_CHOSEONG_SSANGCIEUC	0x110D
#define T_UTF_16_HANGUL_CHOSEONG_CHIEUCH	0x110E
#define T_UTF_16_HANGUL_CHOSEONG_KHIEUKH	0x110F
#define T_UTF_16_HANGUL_CHOSEONG_THIEUTH	0x1110
#define T_UTF_16_HANGUL_CHOSEONG_PHIEUPH	0x1111
#define T_UTF_16_HANGUL_CHOSEONG_HIEUH	0x1112
#define T_UTF_16_HANGUL_CHOSEONG_NIEUN_KIYEOK	0x1113
#define T_UTF_16_HANGUL_CHOSEONG_SSANGNIEUN	0x1114
#define T_UTF_16_HANGUL_CHOSEONG_NIEUN_TIKEUT	0x1115
#define T_UTF_16_HANGUL_CHOSEONG_NIEUN_PIEUP	0x1116
#define T_UTF_16_HANGUL_CHOSEONG_TIKEUT_KIYEOK	0x1117
#define T_UTF_16_HANGUL_CHOSEONG_RIEUL_NIEUN	0x1118
#define T_UTF_16_HANGUL_CHOSEONG_SSANGRIEUL	0x1119
#define T_UTF_16_HANGUL_CHOSEONG_RIEUL_HIEUH	0x111A
#define T_UTF_16_HANGUL_CHOSEONG_KAPYEOUNRIEUL	0x111B
#define T_UTF_16_HANGUL_CHOSEONG_MIEUM_PIEUP	0x111C
#define T_UTF_16_HANGUL_CHOSEONG_KAPYEOUNMIEUM	0x111D
#define T_UTF_16_HANGUL_CHOSEONG_PIEUP_KIYEOK	0x111E
#define T_UTF_16_HANGUL_CHOSEONG_PIEUP_NIEUN	0x111F
#define T_UTF_16_HANGUL_CHOSEONG_PIEUP_TIKEUT	0x1120
#define T_UTF_16_HANGUL_CHOSEONG_PIEUP_SIOS	0x1121
#define T_UTF_16_HANGUL_CHOSEONG_PIEUP_SIOS_KIYEOK	0x1122
#define T_UTF_16_HANGUL_CHOSEONG_PIEUP_SIOS_TIKEUT	0x1123
#define T_UTF_16_HANGUL_CHOSEONG_PIEUP_SIOS_PIEUP	0x1124
#define T_UTF_16_HANGUL_CHOSEONG_PIEUP_SSANGSIOS	0x1125
#define T_UTF_16_HANGUL_CHOSEONG_PIEUP_SIOS_CIEUC	0x1126
#define T_UTF_16_HANGUL_CHOSEONG_PIEUP_CIEUC	0x1127
#define T_UTF_16_HANGUL_CHOSEONG_PIEUP_CHIEUCH	0x1128
#define T_UTF_16_HANGUL_CHOSEONG_PIEUP_THIEUTH	0x1129
#define T_UTF_16_HANGUL_CHOSEONG_PIEUP_PHIEUPH	0x112A
#define T_UTF_16_HANGUL_CHOSEONG_KAPYEOUNPIEUP	0x112B
#define T_UTF_16_HANGUL_CHOSEONG_KAPYEOUNSSANGPIEUP	0x112C
#define T_UTF_16_HANGUL_CHOSEONG_SIOS_KIYEOK	0x112D
#define T_UTF_16_HANGUL_CHOSEONG_SIOS_NIEUN	0x112E
#define T_UTF_16_HANGUL_CHOSEONG_SIOS_TIKEUT	0x112F
#define T_UTF_16_HANGUL_CHOSEONG_SIOS_RIEUL	0x1130
#define T_UTF_16_HANGUL_CHOSEONG_SIOS_MIEUM	0x1131
#define T_UTF_16_HANGUL_CHOSEONG_SIOS_PIEUP	0x1132
#define T_UTF_16_HANGUL_CHOSEONG_SIOS_PIEUP_KIYEOK	0x1133
#define T_UTF_16_HANGUL_CHOSEONG_SIOS_SSANGSIOS	0x1134
#define T_UTF_16_HANGUL_CHOSEONG_SIOS_IEUNG	0x1135
#define T_UTF_16_HANGUL_CHOSEONG_SIOS_CIEUC	0x1136
#define T_UTF_16_HANGUL_CHOSEONG_SIOS_CHIEUCH	0x1137
#define T_UTF_16_HANGUL_CHOSEONG_SIOS_KHIEUKH	0x1138
#define T_UTF_16_HANGUL_CHOSEONG_SIOS_THIEUTH	0x1139
#define T_UTF_16_HANGUL_CHOSEONG_SIOS_PHIEUPH	0x113A
#define T_UTF_16_HANGUL_CHOSEONG_SIOS_HIEUH	0x113B
#define T_UTF_16_HANGUL_CHOSEONG_CHITUEUMSIOS	0x113C
#define T_UTF_16_HANGUL_CHOSEONG_CHITUEUMSSANGSIOS	0x113D
#define T_UTF_16_HANGUL_CHOSEONG_CEONGCHIEUMSIOS	0x113E
#define T_UTF_16_HANGUL_CHOSEONG_CEONGCHIEUMSSANGSIOS	0x113F
#define T_UTF_16_HANGUL_CHOSEONG_PANSIOS	0x1140
#define T_UTF_16_HANGUL_CHOSEONG_IEUNG_KIYEOK	0x1141
#define T_UTF_16_HANGUL_CHOSEONG_IEUNG_TIKEUT	0x1142
#define T_UTF_16_HANGUL_CHOSEONG_IEUNG_MIEUM	0x1143
#define T_UTF_16_HANGUL_CHOSEONG_IEUNG_PIEUP	0x1144
#define T_UTF_16_HANGUL_CHOSEONG_IEUNG_SIOS	0x1145
#define T_UTF_16_HANGUL_CHOSEONG_IEUNG_PANSIOS	0x1146
#define T_UTF_16_HANGUL_CHOSEONG_SSANGIEUNG	0x1147
#define T_UTF_16_HANGUL_CHOSEONG_IEUNG_CIEUC	0x1148
#define T_UTF_16_HANGUL_CHOSEONG_IEUNG_CHIEUCH	0x1149
#define T_UTF_16_HANGUL_CHOSEONG_IEUNG_THIEUTH	0x114A
#define T_UTF_16_HANGUL_CHOSEONG_IEUNG_PHIEUPH	0x114B
#define T_UTF_16_HANGUL_CHOSEONG_YESIEUNG	0x114C
#define T_UTF_16_HANGUL_CHOSEONG_CIEUC_IEUNG	0x114D
#define T_UTF_16_HANGUL_CHOSEONG_CHITUEUMCIEUC	0x114E
#define T_UTF_16_HANGUL_CHOSEONG_CHITUEUMSSANGCIEUC	0x114F
#define T_UTF_16_HANGUL_CHOSEONG_CEONGCHIEUMCIEUC	0x1150
#define T_UTF_16_HANGUL_CHOSEONG_CEONGCHIEUMSSANGCIEUC	0x1151
#define T_UTF_16_HANGUL_CHOSEONG_CHIEUCH_KHIEUKH	0x1152
#define T_UTF_16_HANGUL_CHOSEONG_CHIEUCH_HIEUH	0x1153
#define T_UTF_16_HANGUL_CHOSEONG_CHITUEUMCHIEUCH	0x1154
#define T_UTF_16_HANGUL_CHOSEONG_CEONGCHIEUMCHIEUCH	0x1155
#define T_UTF_16_HANGUL_CHOSEONG_PHIEUPH_PIEUP	0x1156
#define T_UTF_16_HANGUL_CHOSEONG_KAPYEOUNPHIEUPH	0x1157
#define T_UTF_16_HANGUL_CHOSEONG_SSANGHIEUH	0x1158
#define T_UTF_16_HANGUL_CHOSEONG_YEORINHIEUH	0x1159
#define T_UTF_16_HANGUL_CHOSEONG_FILLER	0x115F
#define T_UTF_16_HANGUL_JUNGSEONG_FILLER	0x1160
#define T_UTF_16_HANGUL_JUNGSEONG_A	0x1161
#define T_UTF_16_HANGUL_JUNGSEONG_AE	0x1162
#define T_UTF_16_HANGUL_JUNGSEONG_YA	0x1163
#define T_UTF_16_HANGUL_JUNGSEONG_YAE	0x1164
#define T_UTF_16_HANGUL_JUNGSEONG_EO	0x1165
#define T_UTF_16_HANGUL_JUNGSEONG_E	0x1166
#define T_UTF_16_HANGUL_JUNGSEONG_YEO	0x1167
#define T_UTF_16_HANGUL_JUNGSEONG_YE	0x1168
#define T_UTF_16_HANGUL_JUNGSEONG_O	0x1169
#define T_UTF_16_HANGUL_JUNGSEONG_WA	0x116A
#define T_UTF_16_HANGUL_JUNGSEONG_WAE	0x116B
#define T_UTF_16_HANGUL_JUNGSEONG_OE	0x116C
#define T_UTF_16_HANGUL_JUNGSEONG_YO	0x116D
#define T_UTF_16_HANGUL_JUNGSEONG_U	0x116E
#define T_UTF_16_HANGUL_JUNGSEONG_WEO	0x116F
#define T_UTF_16_HANGUL_JUNGSEONG_WE	0x1170
#define T_UTF_16_HANGUL_JUNGSEONG_WI	0x1171
#define T_UTF_16_HANGUL_JUNGSEONG_YU	0x1172
#define T_UTF_16_HANGUL_JUNGSEONG_EU	0x1173
#define T_UTF_16_HANGUL_JUNGSEONG_YI	0x1174
#define T_UTF_16_HANGUL_JUNGSEONG_I	0x1175
#define T_UTF_16_HANGUL_JUNGSEONG_A_O	0x1176
#define T_UTF_16_HANGUL_JUNGSEONG_A_U	0x1177
#define T_UTF_16_HANGUL_JUNGSEONG_YA_O	0x1178
#define T_UTF_16_HANGUL_JUNGSEONG_YA_YO	0x1179
#define T_UTF_16_HANGUL_JUNGSEONG_EO_O	0x117A
#define T_UTF_16_HANGUL_JUNGSEONG_EO_U	0x117B
#define T_UTF_16_HANGUL_JUNGSEONG_EO_EU	0x117C
#define T_UTF_16_HANGUL_JUNGSEONG_YEO_O	0x117D
#define T_UTF_16_HANGUL_JUNGSEONG_YEO_U	0x117E
#define T_UTF_16_HANGUL_JUNGSEONG_O_EO	0x117F
#define T_UTF_16_HANGUL_JUNGSEONG_O_E	0x1180
#define T_UTF_16_HANGUL_JUNGSEONG_O_YE	0x1181
#define T_UTF_16_HANGUL_JUNGSEONG_O_O	0x1182
#define T_UTF_16_HANGUL_JUNGSEONG_O_U	0x1183
#define T_UTF_16_HANGUL_JUNGSEONG_YO_YA	0x1184
#define T_UTF_16_HANGUL_JUNGSEONG_YO_YAE	0x1185
#define T_UTF_16_HANGUL_JUNGSEONG_YO_YEO	0x1186
#define T_UTF_16_HANGUL_JUNGSEONG_YO_O	0x1187
#define T_UTF_16_HANGUL_JUNGSEONG_YO_I	0x1188
#define T_UTF_16_HANGUL_JUNGSEONG_U_A	0x1189
#define T_UTF_16_HANGUL_JUNGSEONG_U_AE	0x118A
#define T_UTF_16_HANGUL_JUNGSEONG_U_EO_EU	0x118B
#define T_UTF_16_HANGUL_JUNGSEONG_U_YE	0x118C
#define T_UTF_16_HANGUL_JUNGSEONG_U_U	0x118D
#define T_UTF_16_HANGUL_JUNGSEONG_YU_A	0x118E
#define T_UTF_16_HANGUL_JUNGSEONG_YU_EO	0x118F
#define T_UTF_16_HANGUL_JUNGSEONG_YU_E	0x1190
#define T_UTF_16_HANGUL_JUNGSEONG_YU_YEO	0x1191
#define T_UTF_16_HANGUL_JUNGSEONG_YU_YE	0x1192
#define T_UTF_16_HANGUL_JUNGSEONG_YU_U	0x1193
#define T_UTF_16_HANGUL_JUNGSEONG_YU_I	0x1194
#define T_UTF_16_HANGUL_JUNGSEONG_EU_U	0x1195
#define T_UTF_16_HANGUL_JUNGSEONG_EU_EU	0x1196
#define T_UTF_16_HANGUL_JUNGSEONG_YI_U	0x1197
#define T_UTF_16_HANGUL_JUNGSEONG_I_A	0x1198
#define T_UTF_16_HANGUL_JUNGSEONG_I_YA	0x1199
#define T_UTF_16_HANGUL_JUNGSEONG_I_O	0x119A
#define T_UTF_16_HANGUL_JUNGSEONG_I_U	0x119B
#define T_UTF_16_HANGUL_JUNGSEONG_I_EU	0x119C
#define T_UTF_16_HANGUL_JUNGSEONG_I_ARAEA	0x119D
#define T_UTF_16_HANGUL_JUNGSEONG_ARAEA	0x119E
#define T_UTF_16_HANGUL_JUNGSEONG_ARAEA_EO	0x119F
#define T_UTF_16_HANGUL_JUNGSEONG_ARAEA_U	0x11A0
#define T_UTF_16_HANGUL_JUNGSEONG_ARAEA_I	0x11A1
#define T_UTF_16_HANGUL_JUNGSEONG_SSANGARAEA	0x11A2
#define T_UTF_16_HANGUL_JONGSEONG_KIYEOK	0x11A8
#define T_UTF_16_HANGUL_JONGSEONG_SSANGKIYEOK	0x11A9
#define T_UTF_16_HANGUL_JONGSEONG_KIYEOK_SIOS	0x11AA
#define T_UTF_16_HANGUL_JONGSEONG_NIEUN	0x11AB
#define T_UTF_16_HANGUL_JONGSEONG_NIEUN_CIEUC	0x11AC
#define T_UTF_16_HANGUL_JONGSEONG_NIEUN_HIEUH	0x11AD
#define T_UTF_16_HANGUL_JONGSEONG_TIKEUT	0x11AE
#define T_UTF_16_HANGUL_JONGSEONG_RIEUL	0x11AF
#define T_UTF_16_HANGUL_JONGSEONG_RIEUL_KIYEOK	0x11B0
#define T_UTF_16_HANGUL_JONGSEONG_RIEUL_MIEUM	0x11B1
#define T_UTF_16_HANGUL_JONGSEONG_RIEUL_PIEUP	0x11B2
#define T_UTF_16_HANGUL_JONGSEONG_RIEUL_SIOS	0x11B3
#define T_UTF_16_HANGUL_JONGSEONG_RIEUL_THIEUTH	0x11B4
#define T_UTF_16_HANGUL_JONGSEONG_RIEUL_PHIEUPH	0x11B5
#define T_UTF_16_HANGUL_JONGSEONG_RIEUL_HIEUH	0x11B6
#define T_UTF_16_HANGUL_JONGSEONG_MIEUM	0x11B7
#define T_UTF_16_HANGUL_JONGSEONG_PIEUP	0x11B8
#define T_UTF_16_HANGUL_JONGSEONG_PIEUP_SIOS	0x11B9
#define T_UTF_16_HANGUL_JONGSEONG_SIOS	0x11BA
#define T_UTF_16_HANGUL_JONGSEONG_SSANGSIOS	0x11BB
#define T_UTF_16_HANGUL_JONGSEONG_IEUNG	0x11BC
#define T_UTF_16_HANGUL_JONGSEONG_CIEUC	0x11BD
#define T_UTF_16_HANGUL_JONGSEONG_CHIEUCH	0x11BE
#define T_UTF_16_HANGUL_JONGSEONG_KHIEUKH	0x11BF
#define T_UTF_16_HANGUL_JONGSEONG_THIEUTH	0x11C0
#define T_UTF_16_HANGUL_JONGSEONG_PHIEUPH	0x11C1
#define T_UTF_16_HANGUL_JONGSEONG_HIEUH	0x11C2
#define T_UTF_16_HANGUL_JONGSEONG_KIYEOK_RIEUL	0x11C3
#define T_UTF_16_HANGUL_JONGSEONG_KIYEOK_SIOS_KIYEOK	0x11C4
#define T_UTF_16_HANGUL_JONGSEONG_NIEUN_KIYEOK	0x11C5
#define T_UTF_16_HANGUL_JONGSEONG_NIEUN_TIKEUT	0x11C6
#define T_UTF_16_HANGUL_JONGSEONG_NIEUN_SIOS	0x11C7
#define T_UTF_16_HANGUL_JONGSEONG_NIEUN_PANSIOS	0x11C8
#define T_UTF_16_HANGUL_JONGSEONG_NIEUN_THIEUTH	0x11C9
#define T_UTF_16_HANGUL_JONGSEONG_TIKEUT_KIYEOK	0x11CA
#define T_UTF_16_HANGUL_JONGSEONG_TIKEUT_RIEUL	0x11CB
#define T_UTF_16_HANGUL_JONGSEONG_RIEUL_KIYEOK_SIOS	0x11CC
#define T_UTF_16_HANGUL_JONGSEONG_RIEUL_NIEUN	0x11CD
#define T_UTF_16_HANGUL_JONGSEONG_RIEUL_TIKEUT	0x11CE
#define T_UTF_16_HANGUL_JONGSEONG_RIEUL_TIKEUT_HIEUH	0x11CF
#define T_UTF_16_HANGUL_JONGSEONG_SSANGRIEUL	0x11D0
#define T_UTF_16_HANGUL_JONGSEONG_RIEUL_MIEUM_KIYEOK	0x11D1
#define T_UTF_16_HANGUL_JONGSEONG_RIEUL_MIEUM_SIOS	0x11D2
#define T_UTF_16_HANGUL_JONGSEONG_RIEUL_PIEUP_SIOS	0x11D3
#define T_UTF_16_HANGUL_JONGSEONG_RIEUL_PIEUP_HIEUH	0x11D4
#define T_UTF_16_HANGUL_JONGSEONG_RIEUL_KAPYEOUNPIEUP	0x11D5
#define T_UTF_16_HANGUL_JONGSEONG_RIEUL_SSANGSIOS	0x11D6
#define T_UTF_16_HANGUL_JONGSEONG_RIEUL_PANSIOS	0x11D7
#define T_UTF_16_HANGUL_JONGSEONG_RIEUL_KHIEUKH	0x11D8
#define T_UTF_16_HANGUL_JONGSEONG_RIEUL_YEORINHIEUH	0x11D9
#define T_UTF_16_HANGUL_JONGSEONG_MIEUM_KIYEOK	0x11DA
#define T_UTF_16_HANGUL_JONGSEONG_MIEUM_RIEUL	0x11DB
#define T_UTF_16_HANGUL_JONGSEONG_MIEUM_PIEUP	0x11DC
#define T_UTF_16_HANGUL_JONGSEONG_MIEUM_SIOS	0x11DD
#define T_UTF_16_HANGUL_JONGSEONG_MIEUM_SSANGSIOS	0x11DE
#define T_UTF_16_HANGUL_JONGSEONG_MIEUM_PANSIOS	0x11DF
#define T_UTF_16_HANGUL_JONGSEONG_MIEUM_CHIEUCH	0x11E0
#define T_UTF_16_HANGUL_JONGSEONG_MIEUM_HIEUH	0x11E1
#define T_UTF_16_HANGUL_JONGSEONG_KAPYEOUNMIEUM	0x11E2
#define T_UTF_16_HANGUL_JONGSEONG_PIEUP_RIEUL	0x11E3
#define T_UTF_16_HANGUL_JONGSEONG_PIEUP_PHIEUPH	0x11E4
#define T_UTF_16_HANGUL_JONGSEONG_PIEUP_HIEUH	0x11E5
#define T_UTF_16_HANGUL_JONGSEONG_KAPYEOUNPIEUP	0x11E6
#define T_UTF_16_HANGUL_JONGSEONG_SIOS_KIYEOK	0x11E7
#define T_UTF_16_HANGUL_JONGSEONG_SIOS_TIKEUT	0x11E8
#define T_UTF_16_HANGUL_JONGSEONG_SIOS_RIEUL	0x11E9
#define T_UTF_16_HANGUL_JONGSEONG_SIOS_PIEUP	0x11EA
#define T_UTF_16_HANGUL_JONGSEONG_PANSIOS	0x11EB
#define T_UTF_16_HANGUL_JONGSEONG_IEUNG_KIYEOK	0x11EC
#define T_UTF_16_HANGUL_JONGSEONG_IEUNG_SSANGKIYEOK	0x11ED
#define T_UTF_16_HANGUL_JONGSEONG_SSANGIEUNG	0x11EE
#define T_UTF_16_HANGUL_JONGSEONG_IEUNG_KHIEUKH	0x11EF
#define T_UTF_16_HANGUL_JONGSEONG_YESIEUNG	0x11F0
#define T_UTF_16_HANGUL_JONGSEONG_YESIEUNG_SIOS	0x11F1
#define T_UTF_16_HANGUL_JONGSEONG_YESIEUNG_PANSIOS	0x11F2
#define T_UTF_16_HANGUL_JONGSEONG_PHIEUPH_PIEUP	0x11F3
#define T_UTF_16_HANGUL_JONGSEONG_KAPYEOUNPHIEUPH	0x11F4
#define T_UTF_16_HANGUL_JONGSEONG_HIEUH_NIEUN	0x11F5
#define T_UTF_16_HANGUL_JONGSEONG_HIEUH_RIEUL	0x11F6
#define T_UTF_16_HANGUL_JONGSEONG_HIEUH_MIEUM	0x11F7
#define T_UTF_16_HANGUL_JONGSEONG_HIEUH_PIEUP	0x11F8
#define T_UTF_16_HANGUL_JONGSEONG_YEORINHIEUH	0x11F9
#define T_UTF_16_ETHIOPIC_SYLLABLE_HA	0x1200
#define T_UTF_16_ETHIOPIC_SYLLABLE_HU	0x1201
#define T_UTF_16_ETHIOPIC_SYLLABLE_HI	0x1202
#define T_UTF_16_ETHIOPIC_SYLLABLE_HAA	0x1203
#define T_UTF_16_ETHIOPIC_SYLLABLE_HEE	0x1204
#define T_UTF_16_ETHIOPIC_SYLLABLE_HE	0x1205
#define T_UTF_16_ETHIOPIC_SYLLABLE_HO	0x1206
#define T_UTF_16_ETHIOPIC_SYLLABLE_LA	0x1208
#define T_UTF_16_ETHIOPIC_SYLLABLE_LU	0x1209
#define T_UTF_16_ETHIOPIC_SYLLABLE_LI	0x120A
#define T_UTF_16_ETHIOPIC_SYLLABLE_LAA	0x120B
#define T_UTF_16_ETHIOPIC_SYLLABLE_LEE	0x120C
#define T_UTF_16_ETHIOPIC_SYLLABLE_LE	0x120D
#define T_UTF_16_ETHIOPIC_SYLLABLE_LO	0x120E
#define T_UTF_16_ETHIOPIC_SYLLABLE_LWA	0x120F
#define T_UTF_16_ETHIOPIC_SYLLABLE_HHA	0x1210
#define T_UTF_16_ETHIOPIC_SYLLABLE_HHU	0x1211
#define T_UTF_16_ETHIOPIC_SYLLABLE_HHI	0x1212
#define T_UTF_16_ETHIOPIC_SYLLABLE_HHAA	0x1213
#define T_UTF_16_ETHIOPIC_SYLLABLE_HHEE	0x1214
#define T_UTF_16_ETHIOPIC_SYLLABLE_HHE	0x1215
#define T_UTF_16_ETHIOPIC_SYLLABLE_HHO	0x1216
#define T_UTF_16_ETHIOPIC_SYLLABLE_HHWA	0x1217
#define T_UTF_16_ETHIOPIC_SYLLABLE_MA	0x1218
#define T_UTF_16_ETHIOPIC_SYLLABLE_MU	0x1219
#define T_UTF_16_ETHIOPIC_SYLLABLE_MI	0x121A
#define T_UTF_16_ETHIOPIC_SYLLABLE_MAA	0x121B
#define T_UTF_16_ETHIOPIC_SYLLABLE_MEE	0x121C
#define T_UTF_16_ETHIOPIC_SYLLABLE_ME	0x121D
#define T_UTF_16_ETHIOPIC_SYLLABLE_MO	0x121E
#define T_UTF_16_ETHIOPIC_SYLLABLE_MWA	0x121F
#define T_UTF_16_ETHIOPIC_SYLLABLE_SZA	0x1220
#define T_UTF_16_ETHIOPIC_SYLLABLE_SZU	0x1221
#define T_UTF_16_ETHIOPIC_SYLLABLE_SZI	0x1222
#define T_UTF_16_ETHIOPIC_SYLLABLE_SZAA	0x1223
#define T_UTF_16_ETHIOPIC_SYLLABLE_SZEE	0x1224
#define T_UTF_16_ETHIOPIC_SYLLABLE_SZE	0x1225
#define T_UTF_16_ETHIOPIC_SYLLABLE_SZO	0x1226
#define T_UTF_16_ETHIOPIC_SYLLABLE_SZWA	0x1227
#define T_UTF_16_ETHIOPIC_SYLLABLE_RA	0x1228
#define T_UTF_16_ETHIOPIC_SYLLABLE_RU	0x1229
#define T_UTF_16_ETHIOPIC_SYLLABLE_RI	0x122A
#define T_UTF_16_ETHIOPIC_SYLLABLE_RAA	0x122B
#define T_UTF_16_ETHIOPIC_SYLLABLE_REE	0x122C
#define T_UTF_16_ETHIOPIC_SYLLABLE_RE	0x122D
#define T_UTF_16_ETHIOPIC_SYLLABLE_RO	0x122E
#define T_UTF_16_ETHIOPIC_SYLLABLE_RWA	0x122F
#define T_UTF_16_ETHIOPIC_SYLLABLE_SA	0x1230
#define T_UTF_16_ETHIOPIC_SYLLABLE_SU	0x1231
#define T_UTF_16_ETHIOPIC_SYLLABLE_SI	0x1232
#define T_UTF_16_ETHIOPIC_SYLLABLE_SAA	0x1233
#define T_UTF_16_ETHIOPIC_SYLLABLE_SEE	0x1234
#define T_UTF_16_ETHIOPIC_SYLLABLE_SE	0x1235
#define T_UTF_16_ETHIOPIC_SYLLABLE_SO	0x1236
#define T_UTF_16_ETHIOPIC_SYLLABLE_SWA	0x1237
#define T_UTF_16_ETHIOPIC_SYLLABLE_SHA	0x1238
#define T_UTF_16_ETHIOPIC_SYLLABLE_SHU	0x1239
#define T_UTF_16_ETHIOPIC_SYLLABLE_SHI	0x123A
#define T_UTF_16_ETHIOPIC_SYLLABLE_SHAA	0x123B
#define T_UTF_16_ETHIOPIC_SYLLABLE_SHEE	0x123C
#define T_UTF_16_ETHIOPIC_SYLLABLE_SHE	0x123D
#define T_UTF_16_ETHIOPIC_SYLLABLE_SHO	0x123E
#define T_UTF_16_ETHIOPIC_SYLLABLE_SHWA	0x123F
#define T_UTF_16_ETHIOPIC_SYLLABLE_QA	0x1240
#define T_UTF_16_ETHIOPIC_SYLLABLE_QU	0x1241
#define T_UTF_16_ETHIOPIC_SYLLABLE_QI	0x1242
#define T_UTF_16_ETHIOPIC_SYLLABLE_QAA	0x1243
#define T_UTF_16_ETHIOPIC_SYLLABLE_QEE	0x1244
#define T_UTF_16_ETHIOPIC_SYLLABLE_QE	0x1245
#define T_UTF_16_ETHIOPIC_SYLLABLE_QO	0x1246
#define T_UTF_16_ETHIOPIC_SYLLABLE_QWA	0x1248
#define T_UTF_16_ETHIOPIC_SYLLABLE_QWI	0x124A
#define T_UTF_16_ETHIOPIC_SYLLABLE_QWAA	0x124B
#define T_UTF_16_ETHIOPIC_SYLLABLE_QWEE	0x124C
#define T_UTF_16_ETHIOPIC_SYLLABLE_QWE	0x124D
#define T_UTF_16_ETHIOPIC_SYLLABLE_QHA	0x1250
#define T_UTF_16_ETHIOPIC_SYLLABLE_QHU	0x1251
#define T_UTF_16_ETHIOPIC_SYLLABLE_QHI	0x1252
#define T_UTF_16_ETHIOPIC_SYLLABLE_QHAA	0x1253
#define T_UTF_16_ETHIOPIC_SYLLABLE_QHEE	0x1254
#define T_UTF_16_ETHIOPIC_SYLLABLE_QHE	0x1255
#define T_UTF_16_ETHIOPIC_SYLLABLE_QHO	0x1256
#define T_UTF_16_ETHIOPIC_SYLLABLE_QHWA	0x1258
#define T_UTF_16_ETHIOPIC_SYLLABLE_QHWI	0x125A
#define T_UTF_16_ETHIOPIC_SYLLABLE_QHWAA	0x125B
#define T_UTF_16_ETHIOPIC_SYLLABLE_QHWEE	0x125C
#define T_UTF_16_ETHIOPIC_SYLLABLE_QHWE	0x125D
#define T_UTF_16_ETHIOPIC_SYLLABLE_BA	0x1260
#define T_UTF_16_ETHIOPIC_SYLLABLE_BU	0x1261
#define T_UTF_16_ETHIOPIC_SYLLABLE_BI	0x1262
#define T_UTF_16_ETHIOPIC_SYLLABLE_BAA	0x1263
#define T_UTF_16_ETHIOPIC_SYLLABLE_BEE	0x1264
#define T_UTF_16_ETHIOPIC_SYLLABLE_BE	0x1265
#define T_UTF_16_ETHIOPIC_SYLLABLE_BO	0x1266
#define T_UTF_16_ETHIOPIC_SYLLABLE_BWA	0x1267
#define T_UTF_16_ETHIOPIC_SYLLABLE_VA	0x1268
#define T_UTF_16_ETHIOPIC_SYLLABLE_VU	0x1269
#define T_UTF_16_ETHIOPIC_SYLLABLE_VI	0x126A
#define T_UTF_16_ETHIOPIC_SYLLABLE_VAA	0x126B
#define T_UTF_16_ETHIOPIC_SYLLABLE_VEE	0x126C
#define T_UTF_16_ETHIOPIC_SYLLABLE_VE	0x126D
#define T_UTF_16_ETHIOPIC_SYLLABLE_VO	0x126E
#define T_UTF_16_ETHIOPIC_SYLLABLE_VWA	0x126F
#define T_UTF_16_ETHIOPIC_SYLLABLE_TA	0x1270
#define T_UTF_16_ETHIOPIC_SYLLABLE_TU	0x1271
#define T_UTF_16_ETHIOPIC_SYLLABLE_TI	0x1272
#define T_UTF_16_ETHIOPIC_SYLLABLE_TAA	0x1273
#define T_UTF_16_ETHIOPIC_SYLLABLE_TEE	0x1274
#define T_UTF_16_ETHIOPIC_SYLLABLE_TE	0x1275
#define T_UTF_16_ETHIOPIC_SYLLABLE_TO	0x1276
#define T_UTF_16_ETHIOPIC_SYLLABLE_TWA	0x1277
#define T_UTF_16_ETHIOPIC_SYLLABLE_CA	0x1278
#define T_UTF_16_ETHIOPIC_SYLLABLE_CU	0x1279
#define T_UTF_16_ETHIOPIC_SYLLABLE_CI	0x127A
#define T_UTF_16_ETHIOPIC_SYLLABLE_CAA	0x127B
#define T_UTF_16_ETHIOPIC_SYLLABLE_CEE	0x127C
#define T_UTF_16_ETHIOPIC_SYLLABLE_CE	0x127D
#define T_UTF_16_ETHIOPIC_SYLLABLE_CO	0x127E
#define T_UTF_16_ETHIOPIC_SYLLABLE_CWA	0x127F
#define T_UTF_16_ETHIOPIC_SYLLABLE_XA	0x1280
#define T_UTF_16_ETHIOPIC_SYLLABLE_XU	0x1281
#define T_UTF_16_ETHIOPIC_SYLLABLE_XI	0x1282
#define T_UTF_16_ETHIOPIC_SYLLABLE_XAA	0x1283
#define T_UTF_16_ETHIOPIC_SYLLABLE_XEE	0x1284
#define T_UTF_16_ETHIOPIC_SYLLABLE_XE	0x1285
#define T_UTF_16_ETHIOPIC_SYLLABLE_XO	0x1286
#define T_UTF_16_ETHIOPIC_SYLLABLE_XWA	0x1288
#define T_UTF_16_ETHIOPIC_SYLLABLE_XWI	0x128A
#define T_UTF_16_ETHIOPIC_SYLLABLE_XWAA	0x128B
#define T_UTF_16_ETHIOPIC_SYLLABLE_XWEE	0x128C
#define T_UTF_16_ETHIOPIC_SYLLABLE_XWE	0x128D
#define T_UTF_16_ETHIOPIC_SYLLABLE_NA	0x1290
#define T_UTF_16_ETHIOPIC_SYLLABLE_NU	0x1291
#define T_UTF_16_ETHIOPIC_SYLLABLE_NI	0x1292
#define T_UTF_16_ETHIOPIC_SYLLABLE_NAA	0x1293
#define T_UTF_16_ETHIOPIC_SYLLABLE_NEE	0x1294
#define T_UTF_16_ETHIOPIC_SYLLABLE_NE	0x1295
#define T_UTF_16_ETHIOPIC_SYLLABLE_NO	0x1296
#define T_UTF_16_ETHIOPIC_SYLLABLE_NWA	0x1297
#define T_UTF_16_ETHIOPIC_SYLLABLE_NYA	0x1298
#define T_UTF_16_ETHIOPIC_SYLLABLE_NYU	0x1299
#define T_UTF_16_ETHIOPIC_SYLLABLE_NYI	0x129A
#define T_UTF_16_ETHIOPIC_SYLLABLE_NYAA	0x129B
#define T_UTF_16_ETHIOPIC_SYLLABLE_NYEE	0x129C
#define T_UTF_16_ETHIOPIC_SYLLABLE_NYE	0x129D
#define T_UTF_16_ETHIOPIC_SYLLABLE_NYO	0x129E
#define T_UTF_16_ETHIOPIC_SYLLABLE_NYWA	0x129F
#define T_UTF_16_ETHIOPIC_SYLLABLE_GLOTTAL_A	0x12A0
#define T_UTF_16_ETHIOPIC_SYLLABLE_GLOTTAL_U	0x12A1
#define T_UTF_16_ETHIOPIC_SYLLABLE_GLOTTAL_I	0x12A2
#define T_UTF_16_ETHIOPIC_SYLLABLE_GLOTTAL_AA	0x12A3
#define T_UTF_16_ETHIOPIC_SYLLABLE_GLOTTAL_EE	0x12A4
#define T_UTF_16_ETHIOPIC_SYLLABLE_GLOTTAL_E	0x12A5
#define T_UTF_16_ETHIOPIC_SYLLABLE_GLOTTAL_O	0x12A6
#define T_UTF_16_ETHIOPIC_SYLLABLE_GLOTTAL_WA	0x12A7
#define T_UTF_16_ETHIOPIC_SYLLABLE_KA	0x12A8
#define T_UTF_16_ETHIOPIC_SYLLABLE_KU	0x12A9
#define T_UTF_16_ETHIOPIC_SYLLABLE_KI	0x12AA
#define T_UTF_16_ETHIOPIC_SYLLABLE_KAA	0x12AB
#define T_UTF_16_ETHIOPIC_SYLLABLE_KEE	0x12AC
#define T_UTF_16_ETHIOPIC_SYLLABLE_KE	0x12AD
#define T_UTF_16_ETHIOPIC_SYLLABLE_KO	0x12AE
#define T_UTF_16_ETHIOPIC_SYLLABLE_KWA	0x12B0
#define T_UTF_16_ETHIOPIC_SYLLABLE_KWI	0x12B2
#define T_UTF_16_ETHIOPIC_SYLLABLE_KWAA	0x12B3
#define T_UTF_16_ETHIOPIC_SYLLABLE_KWEE	0x12B4
#define T_UTF_16_ETHIOPIC_SYLLABLE_KWE	0x12B5
#define T_UTF_16_ETHIOPIC_SYLLABLE_KXA	0x12B8
#define T_UTF_16_ETHIOPIC_SYLLABLE_KXU	0x12B9
#define T_UTF_16_ETHIOPIC_SYLLABLE_KXI	0x12BA
#define T_UTF_16_ETHIOPIC_SYLLABLE_KXAA	0x12BB
#define T_UTF_16_ETHIOPIC_SYLLABLE_KXEE	0x12BC
#define T_UTF_16_ETHIOPIC_SYLLABLE_KXE	0x12BD
#define T_UTF_16_ETHIOPIC_SYLLABLE_KXO	0x12BE
#define T_UTF_16_ETHIOPIC_SYLLABLE_KXWA	0x12C0
#define T_UTF_16_ETHIOPIC_SYLLABLE_KXWI	0x12C2
#define T_UTF_16_ETHIOPIC_SYLLABLE_KXWAA	0x12C3
#define T_UTF_16_ETHIOPIC_SYLLABLE_KXWEE	0x12C4
#define T_UTF_16_ETHIOPIC_SYLLABLE_KXWE	0x12C5
#define T_UTF_16_ETHIOPIC_SYLLABLE_WA	0x12C8
#define T_UTF_16_ETHIOPIC_SYLLABLE_WU	0x12C9
#define T_UTF_16_ETHIOPIC_SYLLABLE_WI	0x12CA
#define T_UTF_16_ETHIOPIC_SYLLABLE_WAA	0x12CB
#define T_UTF_16_ETHIOPIC_SYLLABLE_WEE	0x12CC
#define T_UTF_16_ETHIOPIC_SYLLABLE_WE	0x12CD
#define T_UTF_16_ETHIOPIC_SYLLABLE_WO	0x12CE
#define T_UTF_16_ETHIOPIC_SYLLABLE_PHARYNGEAL_A	0x12D0
#define T_UTF_16_ETHIOPIC_SYLLABLE_PHARYNGEAL_U	0x12D1
#define T_UTF_16_ETHIOPIC_SYLLABLE_PHARYNGEAL_I	0x12D2
#define T_UTF_16_ETHIOPIC_SYLLABLE_PHARYNGEAL_AA	0x12D3
#define T_UTF_16_ETHIOPIC_SYLLABLE_PHARYNGEAL_EE	0x12D4
#define T_UTF_16_ETHIOPIC_SYLLABLE_PHARYNGEAL_E	0x12D5
#define T_UTF_16_ETHIOPIC_SYLLABLE_PHARYNGEAL_O	0x12D6
#define T_UTF_16_ETHIOPIC_SYLLABLE_ZA	0x12D8
#define T_UTF_16_ETHIOPIC_SYLLABLE_ZU	0x12D9
#define T_UTF_16_ETHIOPIC_SYLLABLE_ZI	0x12DA
#define T_UTF_16_ETHIOPIC_SYLLABLE_ZAA	0x12DB
#define T_UTF_16_ETHIOPIC_SYLLABLE_ZEE	0x12DC
#define T_UTF_16_ETHIOPIC_SYLLABLE_ZE	0x12DD
#define T_UTF_16_ETHIOPIC_SYLLABLE_ZO	0x12DE
#define T_UTF_16_ETHIOPIC_SYLLABLE_ZWA	0x12DF
#define T_UTF_16_ETHIOPIC_SYLLABLE_ZHA	0x12E0
#define T_UTF_16_ETHIOPIC_SYLLABLE_ZHU	0x12E1
#define T_UTF_16_ETHIOPIC_SYLLABLE_ZHI	0x12E2
#define T_UTF_16_ETHIOPIC_SYLLABLE_ZHAA	0x12E3
#define T_UTF_16_ETHIOPIC_SYLLABLE_ZHEE	0x12E4
#define T_UTF_16_ETHIOPIC_SYLLABLE_ZHE	0x12E5
#define T_UTF_16_ETHIOPIC_SYLLABLE_ZHO	0x12E6
#define T_UTF_16_ETHIOPIC_SYLLABLE_ZHWA	0x12E7
#define T_UTF_16_ETHIOPIC_SYLLABLE_YA	0x12E8
#define T_UTF_16_ETHIOPIC_SYLLABLE_YU	0x12E9
#define T_UTF_16_ETHIOPIC_SYLLABLE_YI	0x12EA
#define T_UTF_16_ETHIOPIC_SYLLABLE_YAA	0x12EB
#define T_UTF_16_ETHIOPIC_SYLLABLE_YEE	0x12EC
#define T_UTF_16_ETHIOPIC_SYLLABLE_YE	0x12ED
#define T_UTF_16_ETHIOPIC_SYLLABLE_YO	0x12EE
#define T_UTF_16_ETHIOPIC_SYLLABLE_DA	0x12F0
#define T_UTF_16_ETHIOPIC_SYLLABLE_DU	0x12F1
#define T_UTF_16_ETHIOPIC_SYLLABLE_DI	0x12F2
#define T_UTF_16_ETHIOPIC_SYLLABLE_DAA	0x12F3
#define T_UTF_16_ETHIOPIC_SYLLABLE_DEE	0x12F4
#define T_UTF_16_ETHIOPIC_SYLLABLE_DE	0x12F5
#define T_UTF_16_ETHIOPIC_SYLLABLE_DO	0x12F6
#define T_UTF_16_ETHIOPIC_SYLLABLE_DWA	0x12F7
#define T_UTF_16_ETHIOPIC_SYLLABLE_DDA	0x12F8
#define T_UTF_16_ETHIOPIC_SYLLABLE_DDU	0x12F9
#define T_UTF_16_ETHIOPIC_SYLLABLE_DDI	0x12FA
#define T_UTF_16_ETHIOPIC_SYLLABLE_DDAA	0x12FB
#define T_UTF_16_ETHIOPIC_SYLLABLE_DDEE	0x12FC
#define T_UTF_16_ETHIOPIC_SYLLABLE_DDE	0x12FD
#define T_UTF_16_ETHIOPIC_SYLLABLE_DDO	0x12FE
#define T_UTF_16_ETHIOPIC_SYLLABLE_DDWA	0x12FF
#define T_UTF_16_ETHIOPIC_SYLLABLE_JA	0x1300
#define T_UTF_16_ETHIOPIC_SYLLABLE_JU	0x1301
#define T_UTF_16_ETHIOPIC_SYLLABLE_JI	0x1302
#define T_UTF_16_ETHIOPIC_SYLLABLE_JAA	0x1303
#define T_UTF_16_ETHIOPIC_SYLLABLE_JEE	0x1304
#define T_UTF_16_ETHIOPIC_SYLLABLE_JE	0x1305
#define T_UTF_16_ETHIOPIC_SYLLABLE_JO	0x1306
#define T_UTF_16_ETHIOPIC_SYLLABLE_JWA	0x1307
#define T_UTF_16_ETHIOPIC_SYLLABLE_GA	0x1308
#define T_UTF_16_ETHIOPIC_SYLLABLE_GU	0x1309
#define T_UTF_16_ETHIOPIC_SYLLABLE_GI	0x130A
#define T_UTF_16_ETHIOPIC_SYLLABLE_GAA	0x130B
#define T_UTF_16_ETHIOPIC_SYLLABLE_GEE	0x130C
#define T_UTF_16_ETHIOPIC_SYLLABLE_GE	0x130D
#define T_UTF_16_ETHIOPIC_SYLLABLE_GO	0x130E
#define T_UTF_16_ETHIOPIC_SYLLABLE_GWA	0x1310
#define T_UTF_16_ETHIOPIC_SYLLABLE_GWI	0x1312
#define T_UTF_16_ETHIOPIC_SYLLABLE_GWAA	0x1313
#define T_UTF_16_ETHIOPIC_SYLLABLE_GWEE	0x1314
#define T_UTF_16_ETHIOPIC_SYLLABLE_GWE	0x1315
#define T_UTF_16_ETHIOPIC_SYLLABLE_GGA	0x1318
#define T_UTF_16_ETHIOPIC_SYLLABLE_GGU	0x1319
#define T_UTF_16_ETHIOPIC_SYLLABLE_GGI	0x131A
#define T_UTF_16_ETHIOPIC_SYLLABLE_GGAA	0x131B
#define T_UTF_16_ETHIOPIC_SYLLABLE_GGEE	0x131C
#define T_UTF_16_ETHIOPIC_SYLLABLE_GGE	0x131D
#define T_UTF_16_ETHIOPIC_SYLLABLE_GGO	0x131E
#define T_UTF_16_ETHIOPIC_SYLLABLE_THA	0x1320
#define T_UTF_16_ETHIOPIC_SYLLABLE_THU	0x1321
#define T_UTF_16_ETHIOPIC_SYLLABLE_THI	0x1322
#define T_UTF_16_ETHIOPIC_SYLLABLE_THAA	0x1323
#define T_UTF_16_ETHIOPIC_SYLLABLE_THEE	0x1324
#define T_UTF_16_ETHIOPIC_SYLLABLE_THE	0x1325
#define T_UTF_16_ETHIOPIC_SYLLABLE_THO	0x1326
#define T_UTF_16_ETHIOPIC_SYLLABLE_THWA	0x1327
#define T_UTF_16_ETHIOPIC_SYLLABLE_CHA	0x1328
#define T_UTF_16_ETHIOPIC_SYLLABLE_CHU	0x1329
#define T_UTF_16_ETHIOPIC_SYLLABLE_CHI	0x132A
#define T_UTF_16_ETHIOPIC_SYLLABLE_CHAA	0x132B
#define T_UTF_16_ETHIOPIC_SYLLABLE_CHEE	0x132C
#define T_UTF_16_ETHIOPIC_SYLLABLE_CHE	0x132D
#define T_UTF_16_ETHIOPIC_SYLLABLE_CHO	0x132E
#define T_UTF_16_ETHIOPIC_SYLLABLE_CHWA	0x132F
#define T_UTF_16_ETHIOPIC_SYLLABLE_PHA	0x1330
#define T_UTF_16_ETHIOPIC_SYLLABLE_PHU	0x1331
#define T_UTF_16_ETHIOPIC_SYLLABLE_PHI	0x1332
#define T_UTF_16_ETHIOPIC_SYLLABLE_PHAA	0x1333
#define T_UTF_16_ETHIOPIC_SYLLABLE_PHEE	0x1334
#define T_UTF_16_ETHIOPIC_SYLLABLE_PHE	0x1335
#define T_UTF_16_ETHIOPIC_SYLLABLE_PHO	0x1336
#define T_UTF_16_ETHIOPIC_SYLLABLE_PHWA	0x1337
#define T_UTF_16_ETHIOPIC_SYLLABLE_TSA	0x1338
#define T_UTF_16_ETHIOPIC_SYLLABLE_TSU	0x1339
#define T_UTF_16_ETHIOPIC_SYLLABLE_TSI	0x133A
#define T_UTF_16_ETHIOPIC_SYLLABLE_TSAA	0x133B
#define T_UTF_16_ETHIOPIC_SYLLABLE_TSEE	0x133C
#define T_UTF_16_ETHIOPIC_SYLLABLE_TSE	0x133D
#define T_UTF_16_ETHIOPIC_SYLLABLE_TSO	0x133E
#define T_UTF_16_ETHIOPIC_SYLLABLE_TSWA	0x133F
#define T_UTF_16_ETHIOPIC_SYLLABLE_TZA	0x1340
#define T_UTF_16_ETHIOPIC_SYLLABLE_TZU	0x1341
#define T_UTF_16_ETHIOPIC_SYLLABLE_TZI	0x1342
#define T_UTF_16_ETHIOPIC_SYLLABLE_TZAA	0x1343
#define T_UTF_16_ETHIOPIC_SYLLABLE_TZEE	0x1344
#define T_UTF_16_ETHIOPIC_SYLLABLE_TZE	0x1345
#define T_UTF_16_ETHIOPIC_SYLLABLE_TZO	0x1346
#define T_UTF_16_ETHIOPIC_SYLLABLE_FA	0x1348
#define T_UTF_16_ETHIOPIC_SYLLABLE_FU	0x1349
#define T_UTF_16_ETHIOPIC_SYLLABLE_FI	0x134A
#define T_UTF_16_ETHIOPIC_SYLLABLE_FAA	0x134B
#define T_UTF_16_ETHIOPIC_SYLLABLE_FEE	0x134C
#define T_UTF_16_ETHIOPIC_SYLLABLE_FE	0x134D
#define T_UTF_16_ETHIOPIC_SYLLABLE_FO	0x134E
#define T_UTF_16_ETHIOPIC_SYLLABLE_FWA	0x134F
#define T_UTF_16_ETHIOPIC_SYLLABLE_PA	0x1350
#define T_UTF_16_ETHIOPIC_SYLLABLE_PU	0x1351
#define T_UTF_16_ETHIOPIC_SYLLABLE_PI	0x1352
#define T_UTF_16_ETHIOPIC_SYLLABLE_PAA	0x1353
#define T_UTF_16_ETHIOPIC_SYLLABLE_PEE	0x1354
#define T_UTF_16_ETHIOPIC_SYLLABLE_PE	0x1355
#define T_UTF_16_ETHIOPIC_SYLLABLE_PO	0x1356
#define T_UTF_16_ETHIOPIC_SYLLABLE_PWA	0x1357
#define T_UTF_16_ETHIOPIC_SYLLABLE_RYA	0x1358
#define T_UTF_16_ETHIOPIC_SYLLABLE_MYA	0x1359
#define T_UTF_16_ETHIOPIC_SYLLABLE_FYA	0x135A
#define T_UTF_16_ETHIOPIC_WORDSPACE	0x1361
#define T_UTF_16_ETHIOPIC_FULL_STOP	0x1362
#define T_UTF_16_ETHIOPIC_COMMA	0x1363
#define T_UTF_16_ETHIOPIC_SEMICOLON	0x1364
#define T_UTF_16_ETHIOPIC_COLON	0x1365
#define T_UTF_16_ETHIOPIC_PREFACE_COLON	0x1366
#define T_UTF_16_ETHIOPIC_QUESTION_MARK	0x1367
#define T_UTF_16_ETHIOPIC_PARAGRAPH_SEPARATOR	0x1368
#define T_UTF_16_ETHIOPIC_DIGIT_ONE	0x1369
#define T_UTF_16_ETHIOPIC_DIGIT_TWO	0x136A
#define T_UTF_16_ETHIOPIC_DIGIT_THREE	0x136B
#define T_UTF_16_ETHIOPIC_DIGIT_FOUR	0x136C
#define T_UTF_16_ETHIOPIC_DIGIT_FIVE	0x136D
#define T_UTF_16_ETHIOPIC_DIGIT_SIX	0x136E
#define T_UTF_16_ETHIOPIC_DIGIT_SEVEN	0x136F
#define T_UTF_16_ETHIOPIC_DIGIT_EIGHT	0x1370
#define T_UTF_16_ETHIOPIC_DIGIT_NINE	0x1371
#define T_UTF_16_ETHIOPIC_NUMBER_TEN	0x1372
#define T_UTF_16_ETHIOPIC_NUMBER_TWENTY	0x1373
#define T_UTF_16_ETHIOPIC_NUMBER_THIRTY	0x1374
#define T_UTF_16_ETHIOPIC_NUMBER_FORTY	0x1375
#define T_UTF_16_ETHIOPIC_NUMBER_FIFTY	0x1376
#define T_UTF_16_ETHIOPIC_NUMBER_SIXTY	0x1377
#define T_UTF_16_ETHIOPIC_NUMBER_SEVENTY	0x1378
#define T_UTF_16_ETHIOPIC_NUMBER_EIGHTY	0x1379
#define T_UTF_16_ETHIOPIC_NUMBER_NINETY	0x137A
#define T_UTF_16_ETHIOPIC_NUMBER_HUNDRED	0x137B
#define T_UTF_16_ETHIOPIC_NUMBER_TEN_THOUSAND	0x137C
#define T_UTF_16_CHEROKEE_LETTER_A	0x13A0
#define T_UTF_16_CHEROKEE_LETTER_E	0x13A1
#define T_UTF_16_CHEROKEE_LETTER_I	0x13A2
#define T_UTF_16_CHEROKEE_LETTER_O	0x13A3
#define T_UTF_16_CHEROKEE_LETTER_U	0x13A4
#define T_UTF_16_CHEROKEE_LETTER_V	0x13A5
#define T_UTF_16_CHEROKEE_LETTER_GA	0x13A6
#define T_UTF_16_CHEROKEE_LETTER_KA	0x13A7
#define T_UTF_16_CHEROKEE_LETTER_GE	0x13A8
#define T_UTF_16_CHEROKEE_LETTER_GI	0x13A9
#define T_UTF_16_CHEROKEE_LETTER_GO	0x13AA
#define T_UTF_16_CHEROKEE_LETTER_GU	0x13AB
#define T_UTF_16_CHEROKEE_LETTER_GV	0x13AC
#define T_UTF_16_CHEROKEE_LETTER_HA	0x13AD
#define T_UTF_16_CHEROKEE_LETTER_HE	0x13AE
#define T_UTF_16_CHEROKEE_LETTER_HI	0x13AF
#define T_UTF_16_CHEROKEE_LETTER_HO	0x13B0
#define T_UTF_16_CHEROKEE_LETTER_HU	0x13B1
#define T_UTF_16_CHEROKEE_LETTER_HV	0x13B2
#define T_UTF_16_CHEROKEE_LETTER_LA	0x13B3
#define T_UTF_16_CHEROKEE_LETTER_LE	0x13B4
#define T_UTF_16_CHEROKEE_LETTER_LI	0x13B5
#define T_UTF_16_CHEROKEE_LETTER_LO	0x13B6
#define T_UTF_16_CHEROKEE_LETTER_LU	0x13B7
#define T_UTF_16_CHEROKEE_LETTER_LV	0x13B8
#define T_UTF_16_CHEROKEE_LETTER_MA	0x13B9
#define T_UTF_16_CHEROKEE_LETTER_ME	0x13BA
#define T_UTF_16_CHEROKEE_LETTER_MI	0x13BB
#define T_UTF_16_CHEROKEE_LETTER_MO	0x13BC
#define T_UTF_16_CHEROKEE_LETTER_MU	0x13BD
#define T_UTF_16_CHEROKEE_LETTER_NA	0x13BE
#define T_UTF_16_CHEROKEE_LETTER_HNA	0x13BF
#define T_UTF_16_CHEROKEE_LETTER_NAH	0x13C0
#define T_UTF_16_CHEROKEE_LETTER_NE	0x13C1
#define T_UTF_16_CHEROKEE_LETTER_NI	0x13C2
#define T_UTF_16_CHEROKEE_LETTER_NO	0x13C3
#define T_UTF_16_CHEROKEE_LETTER_NU	0x13C4
#define T_UTF_16_CHEROKEE_LETTER_NV	0x13C5
#define T_UTF_16_CHEROKEE_LETTER_QUA	0x13C6
#define T_UTF_16_CHEROKEE_LETTER_QUE	0x13C7
#define T_UTF_16_CHEROKEE_LETTER_QUI	0x13C8
#define T_UTF_16_CHEROKEE_LETTER_QUO	0x13C9
#define T_UTF_16_CHEROKEE_LETTER_QUU	0x13CA
#define T_UTF_16_CHEROKEE_LETTER_QUV	0x13CB
#define T_UTF_16_CHEROKEE_LETTER_SA	0x13CC
#define T_UTF_16_CHEROKEE_LETTER_S	0x13CD
#define T_UTF_16_CHEROKEE_LETTER_SE	0x13CE
#define T_UTF_16_CHEROKEE_LETTER_SI	0x13CF
#define T_UTF_16_CHEROKEE_LETTER_SO	0x13D0
#define T_UTF_16_CHEROKEE_LETTER_SU	0x13D1
#define T_UTF_16_CHEROKEE_LETTER_SV	0x13D2
#define T_UTF_16_CHEROKEE_LETTER_DA	0x13D3
#define T_UTF_16_CHEROKEE_LETTER_TA	0x13D4
#define T_UTF_16_CHEROKEE_LETTER_DE	0x13D5
#define T_UTF_16_CHEROKEE_LETTER_TE	0x13D6
#define T_UTF_16_CHEROKEE_LETTER_DI	0x13D7
#define T_UTF_16_CHEROKEE_LETTER_TI	0x13D8
#define T_UTF_16_CHEROKEE_LETTER_DO	0x13D9
#define T_UTF_16_CHEROKEE_LETTER_DU	0x13DA
#define T_UTF_16_CHEROKEE_LETTER_DV	0x13DB
#define T_UTF_16_CHEROKEE_LETTER_DLA	0x13DC
#define T_UTF_16_CHEROKEE_LETTER_TLA	0x13DD
#define T_UTF_16_CHEROKEE_LETTER_TLE	0x13DE
#define T_UTF_16_CHEROKEE_LETTER_TLI	0x13DF
#define T_UTF_16_CHEROKEE_LETTER_TLO	0x13E0
#define T_UTF_16_CHEROKEE_LETTER_TLU	0x13E1
#define T_UTF_16_CHEROKEE_LETTER_TLV	0x13E2
#define T_UTF_16_CHEROKEE_LETTER_TSA	0x13E3
#define T_UTF_16_CHEROKEE_LETTER_TSE	0x13E4
#define T_UTF_16_CHEROKEE_LETTER_TSI	0x13E5
#define T_UTF_16_CHEROKEE_LETTER_TSO	0x13E6
#define T_UTF_16_CHEROKEE_LETTER_TSU	0x13E7
#define T_UTF_16_CHEROKEE_LETTER_TSV	0x13E8
#define T_UTF_16_CHEROKEE_LETTER_WA	0x13E9
#define T_UTF_16_CHEROKEE_LETTER_WE	0x13EA
#define T_UTF_16_CHEROKEE_LETTER_WI	0x13EB
#define T_UTF_16_CHEROKEE_LETTER_WO	0x13EC
#define T_UTF_16_CHEROKEE_LETTER_WU	0x13ED
#define T_UTF_16_CHEROKEE_LETTER_WV	0x13EE
#define T_UTF_16_CHEROKEE_LETTER_YA	0x13EF
#define T_UTF_16_CHEROKEE_LETTER_YE	0x13F0
#define T_UTF_16_CHEROKEE_LETTER_YI	0x13F1
#define T_UTF_16_CHEROKEE_LETTER_YO	0x13F2
#define T_UTF_16_CHEROKEE_LETTER_YU	0x13F3
#define T_UTF_16_CHEROKEE_LETTER_YV	0x13F4
#define T_UTF_16_CANADIAN_SYLLABICS_E	0x1401
#define T_UTF_16_CANADIAN_SYLLABICS_AAI	0x1402
#define T_UTF_16_CANADIAN_SYLLABICS_I	0x1403
#define T_UTF_16_CANADIAN_SYLLABICS_II	0x1404
#define T_UTF_16_CANADIAN_SYLLABICS_O	0x1405
#define T_UTF_16_CANADIAN_SYLLABICS_OO	0x1406
#define T_UTF_16_CANADIAN_SYLLABICS_Y_CREE_OO	0x1407
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_EE	0x1408
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_I	0x1409
#define T_UTF_16_CANADIAN_SYLLABICS_A	0x140A
#define T_UTF_16_CANADIAN_SYLLABICS_AA	0x140B
#define T_UTF_16_CANADIAN_SYLLABICS_WE	0x140C
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_WE	0x140D
#define T_UTF_16_CANADIAN_SYLLABICS_WI	0x140E
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_WI	0x140F
#define T_UTF_16_CANADIAN_SYLLABICS_WII	0x1410
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_WII	0x1411
#define T_UTF_16_CANADIAN_SYLLABICS_WO	0x1412
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_WO	0x1413
#define T_UTF_16_CANADIAN_SYLLABICS_WOO	0x1414
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_WOO	0x1415
#define T_UTF_16_CANADIAN_SYLLABICS_NASKAPI_WOO	0x1416
#define T_UTF_16_CANADIAN_SYLLABICS_WA	0x1417
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_WA	0x1418
#define T_UTF_16_CANADIAN_SYLLABICS_WAA	0x1419
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_WAA	0x141A
#define T_UTF_16_CANADIAN_SYLLABICS_NASKAPI_WAA	0x141B
#define T_UTF_16_CANADIAN_SYLLABICS_AI	0x141C
#define T_UTF_16_CANADIAN_SYLLABICS_Y_CREE_W	0x141D
#define T_UTF_16_CANADIAN_SYLLABICS_GLOTTAL_STOP	0x141E
#define T_UTF_16_CANADIAN_SYLLABICS_FINAL_ACUTE	0x141F
#define T_UTF_16_CANADIAN_SYLLABICS_FINAL_GRAVE	0x1420
#define T_UTF_16_CANADIAN_SYLLABICS_FINAL_BOTTOM_HALF_RING	0x1421
#define T_UTF_16_CANADIAN_SYLLABICS_FINAL_TOP_HALF_RING	0x1422
#define T_UTF_16_CANADIAN_SYLLABICS_FINAL_RIGHT_HALF_RING	0x1423
#define T_UTF_16_CANADIAN_SYLLABICS_FINAL_RING	0x1424
#define T_UTF_16_CANADIAN_SYLLABICS_FINAL_DOUBLE_ACUTE	0x1425
#define T_UTF_16_CANADIAN_SYLLABICS_FINAL_DOUBLE_SHORT_VERTICAL_STROKES	0x1426
#define T_UTF_16_CANADIAN_SYLLABICS_FINAL_MIDDLE_DOT	0x1427
#define T_UTF_16_CANADIAN_SYLLABICS_FINAL_SHORT_HORIZONTAL_STROKE	0x1428
#define T_UTF_16_CANADIAN_SYLLABICS_FINAL_PLUS	0x1429
#define T_UTF_16_CANADIAN_SYLLABICS_FINAL_DOWN_TACK	0x142A
#define T_UTF_16_CANADIAN_SYLLABICS_EN	0x142B
#define T_UTF_16_CANADIAN_SYLLABICS_IN	0x142C
#define T_UTF_16_CANADIAN_SYLLABICS_ON	0x142D
#define T_UTF_16_CANADIAN_SYLLABICS_AN	0x142E
#define T_UTF_16_CANADIAN_SYLLABICS_PE	0x142F
#define T_UTF_16_CANADIAN_SYLLABICS_PAAI	0x1430
#define T_UTF_16_CANADIAN_SYLLABICS_PI	0x1431
#define T_UTF_16_CANADIAN_SYLLABICS_PII	0x1432
#define T_UTF_16_CANADIAN_SYLLABICS_PO	0x1433
#define T_UTF_16_CANADIAN_SYLLABICS_POO	0x1434
#define T_UTF_16_CANADIAN_SYLLABICS_Y_CREE_POO	0x1435
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_HEE	0x1436
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_HI	0x1437
#define T_UTF_16_CANADIAN_SYLLABICS_PA	0x1438
#define T_UTF_16_CANADIAN_SYLLABICS_PAA	0x1439
#define T_UTF_16_CANADIAN_SYLLABICS_PWE	0x143A
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_PWE	0x143B
#define T_UTF_16_CANADIAN_SYLLABICS_PWI	0x143C
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_PWI	0x143D
#define T_UTF_16_CANADIAN_SYLLABICS_PWII	0x143E
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_PWII	0x143F
#define T_UTF_16_CANADIAN_SYLLABICS_PWO	0x1440
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_PWO	0x1441
#define T_UTF_16_CANADIAN_SYLLABICS_PWOO	0x1442
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_PWOO	0x1443
#define T_UTF_16_CANADIAN_SYLLABICS_PWA	0x1444
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_PWA	0x1445
#define T_UTF_16_CANADIAN_SYLLABICS_PWAA	0x1446
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_PWAA	0x1447
#define T_UTF_16_CANADIAN_SYLLABICS_Y_CREE_PWAA	0x1448
#define T_UTF_16_CANADIAN_SYLLABICS_P	0x1449
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_P	0x144A
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_H	0x144B
#define T_UTF_16_CANADIAN_SYLLABICS_TE	0x144C
#define T_UTF_16_CANADIAN_SYLLABICS_TAAI	0x144D
#define T_UTF_16_CANADIAN_SYLLABICS_TI	0x144E
#define T_UTF_16_CANADIAN_SYLLABICS_TII	0x144F
#define T_UTF_16_CANADIAN_SYLLABICS_TO	0x1450
#define T_UTF_16_CANADIAN_SYLLABICS_TOO	0x1451
#define T_UTF_16_CANADIAN_SYLLABICS_Y_CREE_TOO	0x1452
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_DEE	0x1453
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_DI	0x1454
#define T_UTF_16_CANADIAN_SYLLABICS_TA	0x1455
#define T_UTF_16_CANADIAN_SYLLABICS_TAA	0x1456
#define T_UTF_16_CANADIAN_SYLLABICS_TWE	0x1457
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_TWE	0x1458
#define T_UTF_16_CANADIAN_SYLLABICS_TWI	0x1459
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_TWI	0x145A
#define T_UTF_16_CANADIAN_SYLLABICS_TWII	0x145B
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_TWII	0x145C
#define T_UTF_16_CANADIAN_SYLLABICS_TWO	0x145D
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_TWO	0x145E
#define T_UTF_16_CANADIAN_SYLLABICS_TWOO	0x145F
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_TWOO	0x1460
#define T_UTF_16_CANADIAN_SYLLABICS_TWA	0x1461
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_TWA	0x1462
#define T_UTF_16_CANADIAN_SYLLABICS_TWAA	0x1463
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_TWAA	0x1464
#define T_UTF_16_CANADIAN_SYLLABICS_NASKAPI_TWAA	0x1465
#define T_UTF_16_CANADIAN_SYLLABICS_T	0x1466
#define T_UTF_16_CANADIAN_SYLLABICS_TTE	0x1467
#define T_UTF_16_CANADIAN_SYLLABICS_TTI	0x1468
#define T_UTF_16_CANADIAN_SYLLABICS_TTO	0x1469
#define T_UTF_16_CANADIAN_SYLLABICS_TTA	0x146A
#define T_UTF_16_CANADIAN_SYLLABICS_KE	0x146B
#define T_UTF_16_CANADIAN_SYLLABICS_KAAI	0x146C
#define T_UTF_16_CANADIAN_SYLLABICS_KI	0x146D
#define T_UTF_16_CANADIAN_SYLLABICS_KII	0x146E
#define T_UTF_16_CANADIAN_SYLLABICS_KO	0x146F
#define T_UTF_16_CANADIAN_SYLLABICS_KOO	0x1470
#define T_UTF_16_CANADIAN_SYLLABICS_Y_CREE_KOO	0x1471
#define T_UTF_16_CANADIAN_SYLLABICS_KA	0x1472
#define T_UTF_16_CANADIAN_SYLLABICS_KAA	0x1473
#define T_UTF_16_CANADIAN_SYLLABICS_KWE	0x1474
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_KWE	0x1475
#define T_UTF_16_CANADIAN_SYLLABICS_KWI	0x1476
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_KWI	0x1477
#define T_UTF_16_CANADIAN_SYLLABICS_KWII	0x1478
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_KWII	0x1479
#define T_UTF_16_CANADIAN_SYLLABICS_KWO	0x147A
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_KWO	0x147B
#define T_UTF_16_CANADIAN_SYLLABICS_KWOO	0x147C
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_KWOO	0x147D
#define T_UTF_16_CANADIAN_SYLLABICS_KWA	0x147E
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_KWA	0x147F
#define T_UTF_16_CANADIAN_SYLLABICS_KWAA	0x1480
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_KWAA	0x1481
#define T_UTF_16_CANADIAN_SYLLABICS_NASKAPI_KWAA	0x1482
#define T_UTF_16_CANADIAN_SYLLABICS_K	0x1483
#define T_UTF_16_CANADIAN_SYLLABICS_KW	0x1484
#define T_UTF_16_CANADIAN_SYLLABICS_SOUTH_SLAVEY_KEH	0x1485
#define T_UTF_16_CANADIAN_SYLLABICS_SOUTH_SLAVEY_KIH	0x1486
#define T_UTF_16_CANADIAN_SYLLABICS_SOUTH_SLAVEY_KOH	0x1487
#define T_UTF_16_CANADIAN_SYLLABICS_SOUTH_SLAVEY_KAH	0x1488
#define T_UTF_16_CANADIAN_SYLLABICS_CE	0x1489
#define T_UTF_16_CANADIAN_SYLLABICS_CAAI	0x148A
#define T_UTF_16_CANADIAN_SYLLABICS_CI	0x148B
#define T_UTF_16_CANADIAN_SYLLABICS_CII	0x148C
#define T_UTF_16_CANADIAN_SYLLABICS_CO	0x148D
#define T_UTF_16_CANADIAN_SYLLABICS_COO	0x148E
#define T_UTF_16_CANADIAN_SYLLABICS_Y_CREE_COO	0x148F
#define T_UTF_16_CANADIAN_SYLLABICS_CA	0x1490
#define T_UTF_16_CANADIAN_SYLLABICS_CAA	0x1491
#define T_UTF_16_CANADIAN_SYLLABICS_CWE	0x1492
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_CWE	0x1493
#define T_UTF_16_CANADIAN_SYLLABICS_CWI	0x1494
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_CWI	0x1495
#define T_UTF_16_CANADIAN_SYLLABICS_CWII	0x1496
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_CWII	0x1497
#define T_UTF_16_CANADIAN_SYLLABICS_CWO	0x1498
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_CWO	0x1499
#define T_UTF_16_CANADIAN_SYLLABICS_CWOO	0x149A
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_CWOO	0x149B
#define T_UTF_16_CANADIAN_SYLLABICS_CWA	0x149C
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_CWA	0x149D
#define T_UTF_16_CANADIAN_SYLLABICS_CWAA	0x149E
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_CWAA	0x149F
#define T_UTF_16_CANADIAN_SYLLABICS_NASKAPI_CWAA	0x14A0
#define T_UTF_16_CANADIAN_SYLLABICS_C	0x14A1
#define T_UTF_16_CANADIAN_SYLLABICS_SAYISI_TH	0x14A2
#define T_UTF_16_CANADIAN_SYLLABICS_ME	0x14A3
#define T_UTF_16_CANADIAN_SYLLABICS_MAAI	0x14A4
#define T_UTF_16_CANADIAN_SYLLABICS_MI	0x14A5
#define T_UTF_16_CANADIAN_SYLLABICS_MII	0x14A6
#define T_UTF_16_CANADIAN_SYLLABICS_MO	0x14A7
#define T_UTF_16_CANADIAN_SYLLABICS_MOO	0x14A8
#define T_UTF_16_CANADIAN_SYLLABICS_Y_CREE_MOO	0x14A9
#define T_UTF_16_CANADIAN_SYLLABICS_MA	0x14AA
#define T_UTF_16_CANADIAN_SYLLABICS_MAA	0x14AB
#define T_UTF_16_CANADIAN_SYLLABICS_MWE	0x14AC
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_MWE	0x14AD
#define T_UTF_16_CANADIAN_SYLLABICS_MWI	0x14AE
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_MWI	0x14AF
#define T_UTF_16_CANADIAN_SYLLABICS_MWII	0x14B0
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_MWII	0x14B1
#define T_UTF_16_CANADIAN_SYLLABICS_MWO	0x14B2
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_MWO	0x14B3
#define T_UTF_16_CANADIAN_SYLLABICS_MWOO	0x14B4
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_MWOO	0x14B5
#define T_UTF_16_CANADIAN_SYLLABICS_MWA	0x14B6
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_MWA	0x14B7
#define T_UTF_16_CANADIAN_SYLLABICS_MWAA	0x14B8
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_MWAA	0x14B9
#define T_UTF_16_CANADIAN_SYLLABICS_NASKAPI_MWAA	0x14BA
#define T_UTF_16_CANADIAN_SYLLABICS_M	0x14BB
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_M	0x14BC
#define T_UTF_16_CANADIAN_SYLLABICS_MH	0x14BD
#define T_UTF_16_CANADIAN_SYLLABICS_ATHAPASCAN_M	0x14BE
#define T_UTF_16_CANADIAN_SYLLABICS_SAYISI_M	0x14BF
#define T_UTF_16_CANADIAN_SYLLABICS_NE	0x14C0
#define T_UTF_16_CANADIAN_SYLLABICS_NAAI	0x14C1
#define T_UTF_16_CANADIAN_SYLLABICS_NI	0x14C2
#define T_UTF_16_CANADIAN_SYLLABICS_NII	0x14C3
#define T_UTF_16_CANADIAN_SYLLABICS_NO	0x14C4
#define T_UTF_16_CANADIAN_SYLLABICS_NOO	0x14C5
#define T_UTF_16_CANADIAN_SYLLABICS_Y_CREE_NOO	0x14C6
#define T_UTF_16_CANADIAN_SYLLABICS_NA	0x14C7
#define T_UTF_16_CANADIAN_SYLLABICS_NAA	0x14C8
#define T_UTF_16_CANADIAN_SYLLABICS_NWE	0x14C9
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_NWE	0x14CA
#define T_UTF_16_CANADIAN_SYLLABICS_NWA	0x14CB
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_NWA	0x14CC
#define T_UTF_16_CANADIAN_SYLLABICS_NWAA	0x14CD
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_NWAA	0x14CE
#define T_UTF_16_CANADIAN_SYLLABICS_NASKAPI_NWAA	0x14CF
#define T_UTF_16_CANADIAN_SYLLABICS_N	0x14D0
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_NG	0x14D1
#define T_UTF_16_CANADIAN_SYLLABICS_NH	0x14D2
#define T_UTF_16_CANADIAN_SYLLABICS_LE	0x14D3
#define T_UTF_16_CANADIAN_SYLLABICS_LAAI	0x14D4
#define T_UTF_16_CANADIAN_SYLLABICS_LI	0x14D5
#define T_UTF_16_CANADIAN_SYLLABICS_LII	0x14D6
#define T_UTF_16_CANADIAN_SYLLABICS_LO	0x14D7
#define T_UTF_16_CANADIAN_SYLLABICS_LOO	0x14D8
#define T_UTF_16_CANADIAN_SYLLABICS_Y_CREE_LOO	0x14D9
#define T_UTF_16_CANADIAN_SYLLABICS_LA	0x14DA
#define T_UTF_16_CANADIAN_SYLLABICS_LAA	0x14DB
#define T_UTF_16_CANADIAN_SYLLABICS_LWE	0x14DC
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_LWE	0x14DD
#define T_UTF_16_CANADIAN_SYLLABICS_LWI	0x14DE
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_LWI	0x14DF
#define T_UTF_16_CANADIAN_SYLLABICS_LWII	0x14E0
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_LWII	0x14E1
#define T_UTF_16_CANADIAN_SYLLABICS_LWO	0x14E2
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_LWO	0x14E3
#define T_UTF_16_CANADIAN_SYLLABICS_LWOO	0x14E4
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_LWOO	0x14E5
#define T_UTF_16_CANADIAN_SYLLABICS_LWA	0x14E6
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_LWA	0x14E7
#define T_UTF_16_CANADIAN_SYLLABICS_LWAA	0x14E8
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_LWAA	0x14E9
#define T_UTF_16_CANADIAN_SYLLABICS_L	0x14EA
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_L	0x14EB
#define T_UTF_16_CANADIAN_SYLLABICS_MEDIAL_L	0x14EC
#define T_UTF_16_CANADIAN_SYLLABICS_SE	0x14ED
#define T_UTF_16_CANADIAN_SYLLABICS_SAAI	0x14EE
#define T_UTF_16_CANADIAN_SYLLABICS_SI	0x14EF
#define T_UTF_16_CANADIAN_SYLLABICS_SII	0x14F0
#define T_UTF_16_CANADIAN_SYLLABICS_SO	0x14F1
#define T_UTF_16_CANADIAN_SYLLABICS_SOO	0x14F2
#define T_UTF_16_CANADIAN_SYLLABICS_Y_CREE_SOO	0x14F3
#define T_UTF_16_CANADIAN_SYLLABICS_SA	0x14F4
#define T_UTF_16_CANADIAN_SYLLABICS_SAA	0x14F5
#define T_UTF_16_CANADIAN_SYLLABICS_SWE	0x14F6
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_SWE	0x14F7
#define T_UTF_16_CANADIAN_SYLLABICS_SWI	0x14F8
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_SWI	0x14F9
#define T_UTF_16_CANADIAN_SYLLABICS_SWII	0x14FA
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_SWII	0x14FB
#define T_UTF_16_CANADIAN_SYLLABICS_SWO	0x14FC
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_SWO	0x14FD
#define T_UTF_16_CANADIAN_SYLLABICS_SWOO	0x14FE
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_SWOO	0x14FF
#define T_UTF_16_CANADIAN_SYLLABICS_SWA	0x1500
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_SWA	0x1501
#define T_UTF_16_CANADIAN_SYLLABICS_SWAA	0x1502
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_SWAA	0x1503
#define T_UTF_16_CANADIAN_SYLLABICS_NASKAPI_SWAA	0x1504
#define T_UTF_16_CANADIAN_SYLLABICS_S	0x1505
#define T_UTF_16_CANADIAN_SYLLABICS_ATHAPASCAN_S	0x1506
#define T_UTF_16_CANADIAN_SYLLABICS_SW	0x1507
#define T_UTF_16_CANADIAN_SYLLABICS_BLACKFOOT_S	0x1508
#define T_UTF_16_CANADIAN_SYLLABICS_MOOSE_CREE_SK	0x1509
#define T_UTF_16_CANADIAN_SYLLABICS_NASKAPI_SKW	0x150A
#define T_UTF_16_CANADIAN_SYLLABICS_NASKAPI_S_W	0x150B
#define T_UTF_16_CANADIAN_SYLLABICS_NASKAPI_SPWA	0x150C
#define T_UTF_16_CANADIAN_SYLLABICS_NASKAPI_STWA	0x150D
#define T_UTF_16_CANADIAN_SYLLABICS_NASKAPI_SKWA	0x150E
#define T_UTF_16_CANADIAN_SYLLABICS_NASKAPI_SCWA	0x150F
#define T_UTF_16_CANADIAN_SYLLABICS_SHE	0x1510
#define T_UTF_16_CANADIAN_SYLLABICS_SHI	0x1511
#define T_UTF_16_CANADIAN_SYLLABICS_SHII	0x1512
#define T_UTF_16_CANADIAN_SYLLABICS_SHO	0x1513
#define T_UTF_16_CANADIAN_SYLLABICS_SHOO	0x1514
#define T_UTF_16_CANADIAN_SYLLABICS_SHA	0x1515
#define T_UTF_16_CANADIAN_SYLLABICS_SHAA	0x1516
#define T_UTF_16_CANADIAN_SYLLABICS_SHWE	0x1517
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_SHWE	0x1518
#define T_UTF_16_CANADIAN_SYLLABICS_SHWI	0x1519
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_SHWI	0x151A
#define T_UTF_16_CANADIAN_SYLLABICS_SHWII	0x151B
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_SHWII	0x151C
#define T_UTF_16_CANADIAN_SYLLABICS_SHWO	0x151D
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_SHWO	0x151E
#define T_UTF_16_CANADIAN_SYLLABICS_SHWOO	0x151F
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_SHWOO	0x1520
#define T_UTF_16_CANADIAN_SYLLABICS_SHWA	0x1521
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_SHWA	0x1522
#define T_UTF_16_CANADIAN_SYLLABICS_SHWAA	0x1523
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_SHWAA	0x1524
#define T_UTF_16_CANADIAN_SYLLABICS_SH	0x1525
#define T_UTF_16_CANADIAN_SYLLABICS_YE	0x1526
#define T_UTF_16_CANADIAN_SYLLABICS_YAAI	0x1527
#define T_UTF_16_CANADIAN_SYLLABICS_YI	0x1528
#define T_UTF_16_CANADIAN_SYLLABICS_YII	0x1529
#define T_UTF_16_CANADIAN_SYLLABICS_YO	0x152A
#define T_UTF_16_CANADIAN_SYLLABICS_YOO	0x152B
#define T_UTF_16_CANADIAN_SYLLABICS_Y_CREE_YOO	0x152C
#define T_UTF_16_CANADIAN_SYLLABICS_YA	0x152D
#define T_UTF_16_CANADIAN_SYLLABICS_YAA	0x152E
#define T_UTF_16_CANADIAN_SYLLABICS_YWE	0x152F
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_YWE	0x1530
#define T_UTF_16_CANADIAN_SYLLABICS_YWI	0x1531
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_YWI	0x1532
#define T_UTF_16_CANADIAN_SYLLABICS_YWII	0x1533
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_YWII	0x1534
#define T_UTF_16_CANADIAN_SYLLABICS_YWO	0x1535
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_YWO	0x1536
#define T_UTF_16_CANADIAN_SYLLABICS_YWOO	0x1537
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_YWOO	0x1538
#define T_UTF_16_CANADIAN_SYLLABICS_YWA	0x1539
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_YWA	0x153A
#define T_UTF_16_CANADIAN_SYLLABICS_YWAA	0x153B
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_YWAA	0x153C
#define T_UTF_16_CANADIAN_SYLLABICS_NASKAPI_YWAA	0x153D
#define T_UTF_16_CANADIAN_SYLLABICS_Y	0x153E
#define T_UTF_16_CANADIAN_SYLLABICS_BIBLE_CREE_Y	0x153F
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_Y	0x1540
#define T_UTF_16_CANADIAN_SYLLABICS_SAYISI_YI	0x1541
#define T_UTF_16_CANADIAN_SYLLABICS_RE	0x1542
#define T_UTF_16_CANADIAN_SYLLABICS_R_CREE_RE	0x1543
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_LE	0x1544
#define T_UTF_16_CANADIAN_SYLLABICS_RAAI	0x1545
#define T_UTF_16_CANADIAN_SYLLABICS_RI	0x1546
#define T_UTF_16_CANADIAN_SYLLABICS_RII	0x1547
#define T_UTF_16_CANADIAN_SYLLABICS_RO	0x1548
#define T_UTF_16_CANADIAN_SYLLABICS_ROO	0x1549
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_LO	0x154A
#define T_UTF_16_CANADIAN_SYLLABICS_RA	0x154B
#define T_UTF_16_CANADIAN_SYLLABICS_RAA	0x154C
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_LA	0x154D
#define T_UTF_16_CANADIAN_SYLLABICS_RWAA	0x154E
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_RWAA	0x154F
#define T_UTF_16_CANADIAN_SYLLABICS_R	0x1550
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_R	0x1551
#define T_UTF_16_CANADIAN_SYLLABICS_MEDIAL_R	0x1552
#define T_UTF_16_CANADIAN_SYLLABICS_FE	0x1553
#define T_UTF_16_CANADIAN_SYLLABICS_FAAI	0x1554
#define T_UTF_16_CANADIAN_SYLLABICS_FI	0x1555
#define T_UTF_16_CANADIAN_SYLLABICS_FII	0x1556
#define T_UTF_16_CANADIAN_SYLLABICS_FO	0x1557
#define T_UTF_16_CANADIAN_SYLLABICS_FOO	0x1558
#define T_UTF_16_CANADIAN_SYLLABICS_FA	0x1559
#define T_UTF_16_CANADIAN_SYLLABICS_FAA	0x155A
#define T_UTF_16_CANADIAN_SYLLABICS_FWAA	0x155B
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_FWAA	0x155C
#define T_UTF_16_CANADIAN_SYLLABICS_F	0x155D
#define T_UTF_16_CANADIAN_SYLLABICS_THE	0x155E
#define T_UTF_16_CANADIAN_SYLLABICS_N_CREE_THE	0x155F
#define T_UTF_16_CANADIAN_SYLLABICS_THI	0x1560
#define T_UTF_16_CANADIAN_SYLLABICS_N_CREE_THI	0x1561
#define T_UTF_16_CANADIAN_SYLLABICS_THII	0x1562
#define T_UTF_16_CANADIAN_SYLLABICS_N_CREE_THII	0x1563
#define T_UTF_16_CANADIAN_SYLLABICS_THO	0x1564
#define T_UTF_16_CANADIAN_SYLLABICS_THOO	0x1565
#define T_UTF_16_CANADIAN_SYLLABICS_THA	0x1566
#define T_UTF_16_CANADIAN_SYLLABICS_THAA	0x1567
#define T_UTF_16_CANADIAN_SYLLABICS_THWAA	0x1568
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_THWAA	0x1569
#define T_UTF_16_CANADIAN_SYLLABICS_TH	0x156A
#define T_UTF_16_CANADIAN_SYLLABICS_TTHE	0x156B
#define T_UTF_16_CANADIAN_SYLLABICS_TTHI	0x156C
#define T_UTF_16_CANADIAN_SYLLABICS_TTHO	0x156D
#define T_UTF_16_CANADIAN_SYLLABICS_TTHA	0x156E
#define T_UTF_16_CANADIAN_SYLLABICS_TTH	0x156F
#define T_UTF_16_CANADIAN_SYLLABICS_TYE	0x1570
#define T_UTF_16_CANADIAN_SYLLABICS_TYI	0x1571
#define T_UTF_16_CANADIAN_SYLLABICS_TYO	0x1572
#define T_UTF_16_CANADIAN_SYLLABICS_TYA	0x1573
#define T_UTF_16_CANADIAN_SYLLABICS_NUNAVIK_HE	0x1574
#define T_UTF_16_CANADIAN_SYLLABICS_NUNAVIK_HI	0x1575
#define T_UTF_16_CANADIAN_SYLLABICS_NUNAVIK_HII	0x1576
#define T_UTF_16_CANADIAN_SYLLABICS_NUNAVIK_HO	0x1577
#define T_UTF_16_CANADIAN_SYLLABICS_NUNAVIK_HOO	0x1578
#define T_UTF_16_CANADIAN_SYLLABICS_NUNAVIK_HA	0x1579
#define T_UTF_16_CANADIAN_SYLLABICS_NUNAVIK_HAA	0x157A
#define T_UTF_16_CANADIAN_SYLLABICS_NUNAVIK_H	0x157B
#define T_UTF_16_CANADIAN_SYLLABICS_NUNAVUT_H	0x157C
#define T_UTF_16_CANADIAN_SYLLABICS_HK	0x157D
#define T_UTF_16_CANADIAN_SYLLABICS_QAAI	0x157E
#define T_UTF_16_CANADIAN_SYLLABICS_QI	0x157F
#define T_UTF_16_CANADIAN_SYLLABICS_QII	0x1580
#define T_UTF_16_CANADIAN_SYLLABICS_QO	0x1581
#define T_UTF_16_CANADIAN_SYLLABICS_QOO	0x1582
#define T_UTF_16_CANADIAN_SYLLABICS_QA	0x1583
#define T_UTF_16_CANADIAN_SYLLABICS_QAA	0x1584
#define T_UTF_16_CANADIAN_SYLLABICS_Q	0x1585
#define T_UTF_16_CANADIAN_SYLLABICS_TLHE	0x1586
#define T_UTF_16_CANADIAN_SYLLABICS_TLHI	0x1587
#define T_UTF_16_CANADIAN_SYLLABICS_TLHO	0x1588
#define T_UTF_16_CANADIAN_SYLLABICS_TLHA	0x1589
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_RE	0x158A
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_RI	0x158B
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_RO	0x158C
#define T_UTF_16_CANADIAN_SYLLABICS_WEST_CREE_RA	0x158D
#define T_UTF_16_CANADIAN_SYLLABICS_NGAAI	0x158E
#define T_UTF_16_CANADIAN_SYLLABICS_NGI	0x158F
#define T_UTF_16_CANADIAN_SYLLABICS_NGII	0x1590
#define T_UTF_16_CANADIAN_SYLLABICS_NGO	0x1591
#define T_UTF_16_CANADIAN_SYLLABICS_NGOO	0x1592
#define T_UTF_16_CANADIAN_SYLLABICS_NGA	0x1593
#define T_UTF_16_CANADIAN_SYLLABICS_NGAA	0x1594
#define T_UTF_16_CANADIAN_SYLLABICS_NG	0x1595
#define T_UTF_16_CANADIAN_SYLLABICS_NNG	0x1596
#define T_UTF_16_CANADIAN_SYLLABICS_SAYISI_SHE	0x1597
#define T_UTF_16_CANADIAN_SYLLABICS_SAYISI_SHI	0x1598
#define T_UTF_16_CANADIAN_SYLLABICS_SAYISI_SHO	0x1599
#define T_UTF_16_CANADIAN_SYLLABICS_SAYISI_SHA	0x159A
#define T_UTF_16_CANADIAN_SYLLABICS_WOODS_CREE_THE	0x159B
#define T_UTF_16_CANADIAN_SYLLABICS_WOODS_CREE_THI	0x159C
#define T_UTF_16_CANADIAN_SYLLABICS_WOODS_CREE_THO	0x159D
#define T_UTF_16_CANADIAN_SYLLABICS_WOODS_CREE_THA	0x159E
#define T_UTF_16_CANADIAN_SYLLABICS_WOODS_CREE_TH	0x159F
#define T_UTF_16_CANADIAN_SYLLABICS_LHI	0x15A0
#define T_UTF_16_CANADIAN_SYLLABICS_LHII	0x15A1
#define T_UTF_16_CANADIAN_SYLLABICS_LHO	0x15A2
#define T_UTF_16_CANADIAN_SYLLABICS_LHOO	0x15A3
#define T_UTF_16_CANADIAN_SYLLABICS_LHA	0x15A4
#define T_UTF_16_CANADIAN_SYLLABICS_LHAA	0x15A5
#define T_UTF_16_CANADIAN_SYLLABICS_LH	0x15A6
#define T_UTF_16_CANADIAN_SYLLABICS_TH_CREE_THE	0x15A7
#define T_UTF_16_CANADIAN_SYLLABICS_TH_CREE_THI	0x15A8
#define T_UTF_16_CANADIAN_SYLLABICS_TH_CREE_THII	0x15A9
#define T_UTF_16_CANADIAN_SYLLABICS_TH_CREE_THO	0x15AA
#define T_UTF_16_CANADIAN_SYLLABICS_TH_CREE_THOO	0x15AB
#define T_UTF_16_CANADIAN_SYLLABICS_TH_CREE_THA	0x15AC
#define T_UTF_16_CANADIAN_SYLLABICS_TH_CREE_THAA	0x15AD
#define T_UTF_16_CANADIAN_SYLLABICS_TH_CREE_TH	0x15AE
#define T_UTF_16_CANADIAN_SYLLABICS_AIVILIK_B	0x15AF
#define T_UTF_16_CANADIAN_SYLLABICS_BLACKFOOT_E	0x15B0
#define T_UTF_16_CANADIAN_SYLLABICS_BLACKFOOT_I	0x15B1
#define T_UTF_16_CANADIAN_SYLLABICS_BLACKFOOT_O	0x15B2
#define T_UTF_16_CANADIAN_SYLLABICS_BLACKFOOT_A	0x15B3
#define T_UTF_16_CANADIAN_SYLLABICS_BLACKFOOT_WE	0x15B4
#define T_UTF_16_CANADIAN_SYLLABICS_BLACKFOOT_WI	0x15B5
#define T_UTF_16_CANADIAN_SYLLABICS_BLACKFOOT_WO	0x15B6
#define T_UTF_16_CANADIAN_SYLLABICS_BLACKFOOT_WA	0x15B7
#define T_UTF_16_CANADIAN_SYLLABICS_BLACKFOOT_NE	0x15B8
#define T_UTF_16_CANADIAN_SYLLABICS_BLACKFOOT_NI	0x15B9
#define T_UTF_16_CANADIAN_SYLLABICS_BLACKFOOT_NO	0x15BA
#define T_UTF_16_CANADIAN_SYLLABICS_BLACKFOOT_NA	0x15BB
#define T_UTF_16_CANADIAN_SYLLABICS_BLACKFOOT_KE	0x15BC
#define T_UTF_16_CANADIAN_SYLLABICS_BLACKFOOT_KI	0x15BD
#define T_UTF_16_CANADIAN_SYLLABICS_BLACKFOOT_KO	0x15BE
#define T_UTF_16_CANADIAN_SYLLABICS_BLACKFOOT_KA	0x15BF
#define T_UTF_16_CANADIAN_SYLLABICS_SAYISI_HE	0x15C0
#define T_UTF_16_CANADIAN_SYLLABICS_SAYISI_HI	0x15C1
#define T_UTF_16_CANADIAN_SYLLABICS_SAYISI_HO	0x15C2
#define T_UTF_16_CANADIAN_SYLLABICS_SAYISI_HA	0x15C3
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_GHU	0x15C4
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_GHO	0x15C5
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_GHE	0x15C6
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_GHEE	0x15C7
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_GHI	0x15C8
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_GHA	0x15C9
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_RU	0x15CA
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_RO	0x15CB
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_RE	0x15CC
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_REE	0x15CD
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_RI	0x15CE
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_RA	0x15CF
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_WU	0x15D0
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_WO	0x15D1
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_WE	0x15D2
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_WEE	0x15D3
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_WI	0x15D4
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_WA	0x15D5
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_HWU	0x15D6
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_HWO	0x15D7
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_HWE	0x15D8
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_HWEE	0x15D9
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_HWI	0x15DA
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_HWA	0x15DB
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_THU	0x15DC
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_THO	0x15DD
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_THE	0x15DE
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_THEE	0x15DF
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_THI	0x15E0
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_THA	0x15E1
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_TTU	0x15E2
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_TTO	0x15E3
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_TTE	0x15E4
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_TTEE	0x15E5
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_TTI	0x15E6
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_TTA	0x15E7
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_PU	0x15E8
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_PO	0x15E9
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_PE	0x15EA
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_PEE	0x15EB
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_PI	0x15EC
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_PA	0x15ED
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_P	0x15EE
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_GU	0x15EF
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_GO	0x15F0
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_GE	0x15F1
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_GEE	0x15F2
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_GI	0x15F3
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_GA	0x15F4
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_KHU	0x15F5
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_KHO	0x15F6
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_KHE	0x15F7
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_KHEE	0x15F8
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_KHI	0x15F9
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_KHA	0x15FA
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_KKU	0x15FB
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_KKO	0x15FC
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_KKE	0x15FD
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_KKEE	0x15FE
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_KKI	0x15FF
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_KKA	0x1600
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_KK	0x1601
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_NU	0x1602
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_NO	0x1603
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_NE	0x1604
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_NEE	0x1605
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_NI	0x1606
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_NA	0x1607
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_MU	0x1608
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_MO	0x1609
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_ME	0x160A
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_MEE	0x160B
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_MI	0x160C
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_MA	0x160D
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_YU	0x160E
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_YO	0x160F
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_YE	0x1610
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_YEE	0x1611
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_YI	0x1612
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_YA	0x1613
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_JU	0x1614
#define T_UTF_16_CANADIAN_SYLLABICS_SAYISI_JU	0x1615
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_JO	0x1616
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_JE	0x1617
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_JEE	0x1618
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_JI	0x1619
#define T_UTF_16_CANADIAN_SYLLABICS_SAYISI_JI	0x161A
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_JA	0x161B
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_JJU	0x161C
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_JJO	0x161D
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_JJE	0x161E
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_JJEE	0x161F
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_JJI	0x1620
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_JJA	0x1621
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_LU	0x1622
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_LO	0x1623
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_LE	0x1624
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_LEE	0x1625
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_LI	0x1626
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_LA	0x1627
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_DLU	0x1628
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_DLO	0x1629
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_DLE	0x162A
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_DLEE	0x162B
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_DLI	0x162C
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_DLA	0x162D
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_LHU	0x162E
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_LHO	0x162F
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_LHE	0x1630
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_LHEE	0x1631
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_LHI	0x1632
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_LHA	0x1633
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_TLHU	0x1634
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_TLHO	0x1635
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_TLHE	0x1636
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_TLHEE	0x1637
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_TLHI	0x1638
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_TLHA	0x1639
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_TLU	0x163A
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_TLO	0x163B
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_TLE	0x163C
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_TLEE	0x163D
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_TLI	0x163E
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_TLA	0x163F
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_ZU	0x1640
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_ZO	0x1641
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_ZE	0x1642
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_ZEE	0x1643
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_ZI	0x1644
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_ZA	0x1645
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_Z	0x1646
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_INITIAL_Z	0x1647
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_DZU	0x1648
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_DZO	0x1649
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_DZE	0x164A
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_DZEE	0x164B
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_DZI	0x164C
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_DZA	0x164D
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_SU	0x164E
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_SO	0x164F
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_SE	0x1650
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_SEE	0x1651
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_SI	0x1652
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_SA	0x1653
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_SHU	0x1654
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_SHO	0x1655
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_SHE	0x1656
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_SHEE	0x1657
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_SHI	0x1658
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_SHA	0x1659
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_SH	0x165A
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_TSU	0x165B
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_TSO	0x165C
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_TSE	0x165D
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_TSEE	0x165E
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_TSI	0x165F
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_TSA	0x1660
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_CHU	0x1661
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_CHO	0x1662
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_CHE	0x1663
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_CHEE	0x1664
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_CHI	0x1665
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_CHA	0x1666
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_TTSU	0x1667
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_TTSO	0x1668
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_TTSE	0x1669
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_TTSEE	0x166A
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_TTSI	0x166B
#define T_UTF_16_CANADIAN_SYLLABICS_CARRIER_TTSA	0x166C
#define T_UTF_16_CANADIAN_SYLLABICS_CHI_SIGN	0x166D
#define T_UTF_16_CANADIAN_SYLLABICS_FULL_STOP	0x166E
#define T_UTF_16_CANADIAN_SYLLABICS_QAI	0x166F
#define T_UTF_16_CANADIAN_SYLLABICS_NGAI	0x1670
#define T_UTF_16_CANADIAN_SYLLABICS_NNGI	0x1671
#define T_UTF_16_CANADIAN_SYLLABICS_NNGII	0x1672
#define T_UTF_16_CANADIAN_SYLLABICS_NNGO	0x1673
#define T_UTF_16_CANADIAN_SYLLABICS_NNGOO	0x1674
#define T_UTF_16_CANADIAN_SYLLABICS_NNGA	0x1675
#define T_UTF_16_CANADIAN_SYLLABICS_NNGAA	0x1676
#define T_UTF_16_OGHAM_SPACE_MARK	0x1680
#define T_UTF_16_OGHAM_LETTER_BEITH	0x1681
#define T_UTF_16_OGHAM_LETTER_LUIS	0x1682
#define T_UTF_16_OGHAM_LETTER_FEARN	0x1683
#define T_UTF_16_OGHAM_LETTER_SAIL	0x1684
#define T_UTF_16_OGHAM_LETTER_NION	0x1685
#define T_UTF_16_OGHAM_LETTER_UATH	0x1686
#define T_UTF_16_OGHAM_LETTER_DAIR	0x1687
#define T_UTF_16_OGHAM_LETTER_TINNE	0x1688
#define T_UTF_16_OGHAM_LETTER_COLL	0x1689
#define T_UTF_16_OGHAM_LETTER_CEIRT	0x168A
#define T_UTF_16_OGHAM_LETTER_MUIN	0x168B
#define T_UTF_16_OGHAM_LETTER_GORT	0x168C
#define T_UTF_16_OGHAM_LETTER_NGEADAL	0x168D
#define T_UTF_16_OGHAM_LETTER_STRAIF	0x168E
#define T_UTF_16_OGHAM_LETTER_RUIS	0x168F
#define T_UTF_16_OGHAM_LETTER_AILM	0x1690
#define T_UTF_16_OGHAM_LETTER_ONN	0x1691
#define T_UTF_16_OGHAM_LETTER_UR	0x1692
#define T_UTF_16_OGHAM_LETTER_EADHADH	0x1693
#define T_UTF_16_OGHAM_LETTER_IODHADH	0x1694
#define T_UTF_16_OGHAM_LETTER_EABHADH	0x1695
#define T_UTF_16_OGHAM_LETTER_OR	0x1696
#define T_UTF_16_OGHAM_LETTER_UILLEANN	0x1697
#define T_UTF_16_OGHAM_LETTER_IFIN	0x1698
#define T_UTF_16_OGHAM_LETTER_EAMHANCHOLL	0x1699
#define T_UTF_16_OGHAM_LETTER_PEITH	0x169A
#define T_UTF_16_OGHAM_FEATHER_MARK	0x169B
#define T_UTF_16_OGHAM_REVERSED_FEATHER_MARK	0x169C
#define T_UTF_16_RUNIC_LETTER_FEHU_FEOH_FE_F	0x16A0
#define T_UTF_16_RUNIC_LETTER_V	0x16A1
#define T_UTF_16_RUNIC_LETTER_URUZ_UR_U	0x16A2
#define T_UTF_16_RUNIC_LETTER_YR	0x16A3
#define T_UTF_16_RUNIC_LETTER_Y	0x16A4
#define T_UTF_16_RUNIC_LETTER_W	0x16A5
#define T_UTF_16_RUNIC_LETTER_THURISAZ_THURS_THORN	0x16A6
#define T_UTF_16_RUNIC_LETTER_ETH	0x16A7
#define T_UTF_16_RUNIC_LETTER_ANSUZ_A	0x16A8
#define T_UTF_16_RUNIC_LETTER_OS_O	0x16A9
#define T_UTF_16_RUNIC_LETTER_AC_A	0x16AA
#define T_UTF_16_RUNIC_LETTER_AESC	0x16AB
#define T_UTF_16_RUNIC_LETTER_LONG_BRANCH_OSS_O	0x16AC
#define T_UTF_16_RUNIC_LETTER_SHORT_TWIG_OSS_O	0x16AD
#define T_UTF_16_RUNIC_LETTER_O	0x16AE
#define T_UTF_16_RUNIC_LETTER_OE	0x16AF
#define T_UTF_16_RUNIC_LETTER_ON	0x16B0
#define T_UTF_16_RUNIC_LETTER_RAIDO_RAD_REID_R	0x16B1
#define T_UTF_16_RUNIC_LETTER_KAUNA	0x16B2
#define T_UTF_16_RUNIC_LETTER_CEN	0x16B3
#define T_UTF_16_RUNIC_LETTER_KAUN_K	0x16B4
#define T_UTF_16_RUNIC_LETTER_G	0x16B5
#define T_UTF_16_RUNIC_LETTER_ENG	0x16B6
#define T_UTF_16_RUNIC_LETTER_GEBO_GYFU_G	0x16B7
#define T_UTF_16_RUNIC_LETTER_GAR	0x16B8
#define T_UTF_16_RUNIC_LETTER_WUNJO_WYNN_W	0x16B9
#define T_UTF_16_RUNIC_LETTER_HAGLAZ_H	0x16BA
#define T_UTF_16_RUNIC_LETTER_HAEGL_H	0x16BB
#define T_UTF_16_RUNIC_LETTER_LONG_BRANCH_HAGALL_H	0x16BC
#define T_UTF_16_RUNIC_LETTER_SHORT_TWIG_HAGALL_H	0x16BD
#define T_UTF_16_RUNIC_LETTER_NAUDIZ_NYD_NAUD_N	0x16BE
#define T_UTF_16_RUNIC_LETTER_SHORT_TWIG_NAUD_N	0x16BF
#define T_UTF_16_RUNIC_LETTER_DOTTED_N	0x16C0
#define T_UTF_16_RUNIC_LETTER_ISAZ_IS_ISS_I	0x16C1
#define T_UTF_16_RUNIC_LETTER_E	0x16C2
#define T_UTF_16_RUNIC_LETTER_JERAN_J	0x16C3
#define T_UTF_16_RUNIC_LETTER_GER	0x16C4
#define T_UTF_16_RUNIC_LETTER_LONG_BRANCH_AR_AE	0x16C5
#define T_UTF_16_RUNIC_LETTER_SHORT_TWIG_AR_A	0x16C6
#define T_UTF_16_RUNIC_LETTER_IWAZ_EOH	0x16C7
#define T_UTF_16_RUNIC_LETTER_PERTHO_PEORTH_P	0x16C8
#define T_UTF_16_RUNIC_LETTER_ALGIZ_EOLHX	0x16C9
#define T_UTF_16_RUNIC_LETTER_SOWILO_S	0x16CA
#define T_UTF_16_RUNIC_LETTER_SIGEL_LONG_BRANCH_SOL_S	0x16CB
#define T_UTF_16_RUNIC_LETTER_SHORT_TWIG_SOL_S	0x16CC
#define T_UTF_16_RUNIC_LETTER_C	0x16CD
#define T_UTF_16_RUNIC_LETTER_Z	0x16CE
#define T_UTF_16_RUNIC_LETTER_TIWAZ_TIR_TYR_T	0x16CF
#define T_UTF_16_RUNIC_LETTER_SHORT_TWIG_TYR_T	0x16D0
#define T_UTF_16_RUNIC_LETTER_D	0x16D1
#define T_UTF_16_RUNIC_LETTER_BERKANAN_BEORC_BJARKAN_B	0x16D2
#define T_UTF_16_RUNIC_LETTER_SHORT_TWIG_BJARKAN_B	0x16D3
#define T_UTF_16_RUNIC_LETTER_DOTTED_P	0x16D4
#define T_UTF_16_RUNIC_LETTER_OPEN_P	0x16D5
#define T_UTF_16_RUNIC_LETTER_EHWAZ_EH_E	0x16D6
#define T_UTF_16_RUNIC_LETTER_MANNAZ_MAN_M	0x16D7
#define T_UTF_16_RUNIC_LETTER_LONG_BRANCH_MADR_M	0x16D8
#define T_UTF_16_RUNIC_LETTER_SHORT_TWIG_MADR_M	0x16D9
#define T_UTF_16_RUNIC_LETTER_LAUKAZ_LAGU_LOGR_L	0x16DA
#define T_UTF_16_RUNIC_LETTER_DOTTED_L	0x16DB
#define T_UTF_16_RUNIC_LETTER_INGWAZ	0x16DC
#define T_UTF_16_RUNIC_LETTER_ING	0x16DD
#define T_UTF_16_RUNIC_LETTER_DAGAZ_DAEG_D	0x16DE
#define T_UTF_16_RUNIC_LETTER_OTHALAN_ETHEL_O	0x16DF
#define T_UTF_16_RUNIC_LETTER_EAR	0x16E0
#define T_UTF_16_RUNIC_LETTER_IOR	0x16E1
#define T_UTF_16_RUNIC_LETTER_CWEORTH	0x16E2
#define T_UTF_16_RUNIC_LETTER_CALC	0x16E3
#define T_UTF_16_RUNIC_LETTER_CEALC	0x16E4
#define T_UTF_16_RUNIC_LETTER_STAN	0x16E5
#define T_UTF_16_RUNIC_LETTER_LONG_BRANCH_YR	0x16E6
#define T_UTF_16_RUNIC_LETTER_SHORT_TWIG_YR	0x16E7
#define T_UTF_16_RUNIC_LETTER_ICELANDIC_YR	0x16E8
#define T_UTF_16_RUNIC_LETTER_Q	0x16E9
#define T_UTF_16_RUNIC_LETTER_X	0x16EA
#define T_UTF_16_RUNIC_SINGLE_PUNCTUATION	0x16EB
#define T_UTF_16_RUNIC_MULTIPLE_PUNCTUATION	0x16EC
#define T_UTF_16_RUNIC_CROSS_PUNCTUATION	0x16ED
#define T_UTF_16_RUNIC_ARLAUG_SYMBOL	0x16EE
#define T_UTF_16_RUNIC_TVIMADUR_SYMBOL	0x16EF
#define T_UTF_16_RUNIC_BELGTHOR_SYMBOL	0x16F0
#define T_UTF_16_KHMER_LETTER_KA	0x1780
#define T_UTF_16_KHMER_LETTER_KHA	0x1781
#define T_UTF_16_KHMER_LETTER_KO	0x1782
#define T_UTF_16_KHMER_LETTER_KHO	0x1783
#define T_UTF_16_KHMER_LETTER_NGO	0x1784
#define T_UTF_16_KHMER_LETTER_CA	0x1785
#define T_UTF_16_KHMER_LETTER_CHA	0x1786
#define T_UTF_16_KHMER_LETTER_CO	0x1787
#define T_UTF_16_KHMER_LETTER_CHO	0x1788
#define T_UTF_16_KHMER_LETTER_NYO	0x1789
#define T_UTF_16_KHMER_LETTER_DA	0x178A
#define T_UTF_16_KHMER_LETTER_TTHA	0x178B
#define T_UTF_16_KHMER_LETTER_DO	0x178C
#define T_UTF_16_KHMER_LETTER_TTHO	0x178D
#define T_UTF_16_KHMER_LETTER_NNO	0x178E
#define T_UTF_16_KHMER_LETTER_TA	0x178F
#define T_UTF_16_KHMER_LETTER_THA	0x1790
#define T_UTF_16_KHMER_LETTER_TO	0x1791
#define T_UTF_16_KHMER_LETTER_THO	0x1792
#define T_UTF_16_KHMER_LETTER_NO	0x1793
#define T_UTF_16_KHMER_LETTER_BA	0x1794
#define T_UTF_16_KHMER_LETTER_PHA	0x1795
#define T_UTF_16_KHMER_LETTER_PO	0x1796
#define T_UTF_16_KHMER_LETTER_PHO	0x1797
#define T_UTF_16_KHMER_LETTER_MO	0x1798
#define T_UTF_16_KHMER_LETTER_YO	0x1799
#define T_UTF_16_KHMER_LETTER_RO	0x179A
#define T_UTF_16_KHMER_LETTER_LO	0x179B
#define T_UTF_16_KHMER_LETTER_VO	0x179C
#define T_UTF_16_KHMER_LETTER_SHA	0x179D
#define T_UTF_16_KHMER_LETTER_SSO	0x179E
#define T_UTF_16_KHMER_LETTER_SA	0x179F
#define T_UTF_16_KHMER_LETTER_HA	0x17A0
#define T_UTF_16_KHMER_LETTER_LA	0x17A1
#define T_UTF_16_KHMER_LETTER_QA	0x17A2
#define T_UTF_16_KHMER_INDEPENDENT_VOWEL_QAQ	0x17A3
#define T_UTF_16_KHMER_INDEPENDENT_VOWEL_QAA	0x17A4
#define T_UTF_16_KHMER_INDEPENDENT_VOWEL_QI	0x17A5
#define T_UTF_16_KHMER_INDEPENDENT_VOWEL_QII	0x17A6
#define T_UTF_16_KHMER_INDEPENDENT_VOWEL_QU	0x17A7
#define T_UTF_16_KHMER_INDEPENDENT_VOWEL_QUK	0x17A8
#define T_UTF_16_KHMER_INDEPENDENT_VOWEL_QUU	0x17A9
#define T_UTF_16_KHMER_INDEPENDENT_VOWEL_QUUV	0x17AA
#define T_UTF_16_KHMER_INDEPENDENT_VOWEL_RY	0x17AB
#define T_UTF_16_KHMER_INDEPENDENT_VOWEL_RYY	0x17AC
#define T_UTF_16_KHMER_INDEPENDENT_VOWEL_LY	0x17AD
#define T_UTF_16_KHMER_INDEPENDENT_VOWEL_LYY	0x17AE
#define T_UTF_16_KHMER_INDEPENDENT_VOWEL_QE	0x17AF
#define T_UTF_16_KHMER_INDEPENDENT_VOWEL_QAI	0x17B0
#define T_UTF_16_KHMER_INDEPENDENT_VOWEL_QOO_TYPE_ONE	0x17B1
#define T_UTF_16_KHMER_INDEPENDENT_VOWEL_QOO_TYPE_TWO	0x17B2
#define T_UTF_16_KHMER_INDEPENDENT_VOWEL_QAU	0x17B3
#define T_UTF_16_KHMER_VOWEL_INHERENT_AQ	0x17B4
#define T_UTF_16_KHMER_VOWEL_INHERENT_AA	0x17B5
#define T_UTF_16_KHMER_VOWEL_SIGN_AA	0x17B6
#define T_UTF_16_KHMER_VOWEL_SIGN_I	0x17B7
#define T_UTF_16_KHMER_VOWEL_SIGN_II	0x17B8
#define T_UTF_16_KHMER_VOWEL_SIGN_Y	0x17B9
#define T_UTF_16_KHMER_VOWEL_SIGN_YY	0x17BA
#define T_UTF_16_KHMER_VOWEL_SIGN_U	0x17BB
#define T_UTF_16_KHMER_VOWEL_SIGN_UU	0x17BC
#define T_UTF_16_KHMER_VOWEL_SIGN_UA	0x17BD
#define T_UTF_16_KHMER_VOWEL_SIGN_OE	0x17BE
#define T_UTF_16_KHMER_VOWEL_SIGN_YA	0x17BF
#define T_UTF_16_KHMER_VOWEL_SIGN_IE	0x17C0
#define T_UTF_16_KHMER_VOWEL_SIGN_E	0x17C1
#define T_UTF_16_KHMER_VOWEL_SIGN_AE	0x17C2
#define T_UTF_16_KHMER_VOWEL_SIGN_AI	0x17C3
#define T_UTF_16_KHMER_VOWEL_SIGN_OO	0x17C4
#define T_UTF_16_KHMER_VOWEL_SIGN_AU	0x17C5
#define T_UTF_16_KHMER_SIGN_NIKAHIT	0x17C6
#define T_UTF_16_KHMER_SIGN_REAHMUK	0x17C7
#define T_UTF_16_KHMER_SIGN_YUUKALEAPINTU	0x17C8
#define T_UTF_16_KHMER_SIGN_MUUSIKATOAN	0x17C9
#define T_UTF_16_KHMER_SIGN_TRIISAP	0x17CA
#define T_UTF_16_KHMER_SIGN_BANTOC	0x17CB
#define T_UTF_16_KHMER_SIGN_ROBAT	0x17CC
#define T_UTF_16_KHMER_SIGN_TOANDAKHIAT	0x17CD
#define T_UTF_16_KHMER_SIGN_KAKABAT	0x17CE
#define T_UTF_16_KHMER_SIGN_AHSDA	0x17CF
#define T_UTF_16_KHMER_SIGN_SAMYOK_SANNYA	0x17D0
#define T_UTF_16_KHMER_SIGN_VIRIAM	0x17D1
#define T_UTF_16_KHMER_SIGN_COENG	0x17D2
#define T_UTF_16_KHMER_SIGN_BATHAMASAT	0x17D3
#define T_UTF_16_KHMER_SIGN_KHAN	0x17D4
#define T_UTF_16_KHMER_SIGN_BARIYOOSAN	0x17D5
#define T_UTF_16_KHMER_SIGN_CAMNUC_PII_KUUH	0x17D6
#define T_UTF_16_KHMER_SIGN_LEK_TOO	0x17D7
#define T_UTF_16_KHMER_SIGN_BEYYAL	0x17D8
#define T_UTF_16_KHMER_SIGN_PHNAEK_MUAN	0x17D9
#define T_UTF_16_KHMER_SIGN_KOOMUUT	0x17DA
#define T_UTF_16_KHMER_CURRENCY_SYMBOL_RIEL	0x17DB
#define T_UTF_16_KHMER_SIGN_AVAKRAHASANYA	0x17DC
#define T_UTF_16_KHMER_DIGIT_ZERO	0x17E0
#define T_UTF_16_KHMER_DIGIT_ONE	0x17E1
#define T_UTF_16_KHMER_DIGIT_TWO	0x17E2
#define T_UTF_16_KHMER_DIGIT_THREE	0x17E3
#define T_UTF_16_KHMER_DIGIT_FOUR	0x17E4
#define T_UTF_16_KHMER_DIGIT_FIVE	0x17E5
#define T_UTF_16_KHMER_DIGIT_SIX	0x17E6
#define T_UTF_16_KHMER_DIGIT_SEVEN	0x17E7
#define T_UTF_16_KHMER_DIGIT_EIGHT	0x17E8
#define T_UTF_16_KHMER_DIGIT_NINE	0x17E9
#define T_UTF_16_MONGOLIAN_BIRGA	0x1800
#define T_UTF_16_MONGOLIAN_ELLIPSIS	0x1801
#define T_UTF_16_MONGOLIAN_COMMA	0x1802
#define T_UTF_16_MONGOLIAN_FULL_STOP	0x1803
#define T_UTF_16_MONGOLIAN_COLON	0x1804
#define T_UTF_16_MONGOLIAN_FOUR_DOTS	0x1805
#define T_UTF_16_MONGOLIAN_TODO_SOFT_HYPHEN	0x1806
#define T_UTF_16_MONGOLIAN_SIBE_SYLLABLE_BOUNDARY_MARKER	0x1807
#define T_UTF_16_MONGOLIAN_MANCHU_COMMA	0x1808
#define T_UTF_16_MONGOLIAN_MANCHU_FULL_STOP	0x1809
#define T_UTF_16_MONGOLIAN_NIRUGU	0x180A
#define T_UTF_16_MONGOLIAN_FREE_VARIATION_SELECTOR_ONE	0x180B
#define T_UTF_16_MONGOLIAN_FREE_VARIATION_SELECTOR_TWO	0x180C
#define T_UTF_16_MONGOLIAN_FREE_VARIATION_SELECTOR_THREE	0x180D
#define T_UTF_16_MONGOLIAN_VOWEL_SEPARATOR	0x180E
#define T_UTF_16_MONGOLIAN_DIGIT_ZERO	0x1810
#define T_UTF_16_MONGOLIAN_DIGIT_ONE	0x1811
#define T_UTF_16_MONGOLIAN_DIGIT_TWO	0x1812
#define T_UTF_16_MONGOLIAN_DIGIT_THREE	0x1813
#define T_UTF_16_MONGOLIAN_DIGIT_FOUR	0x1814
#define T_UTF_16_MONGOLIAN_DIGIT_FIVE	0x1815
#define T_UTF_16_MONGOLIAN_DIGIT_SIX	0x1816
#define T_UTF_16_MONGOLIAN_DIGIT_SEVEN	0x1817
#define T_UTF_16_MONGOLIAN_DIGIT_EIGHT	0x1818
#define T_UTF_16_MONGOLIAN_DIGIT_NINE	0x1819
#define T_UTF_16_MONGOLIAN_LETTER_A	0x1820
#define T_UTF_16_MONGOLIAN_LETTER_E	0x1821
#define T_UTF_16_MONGOLIAN_LETTER_I	0x1822
#define T_UTF_16_MONGOLIAN_LETTER_O	0x1823
#define T_UTF_16_MONGOLIAN_LETTER_U	0x1824
#define T_UTF_16_MONGOLIAN_LETTER_OE	0x1825
#define T_UTF_16_MONGOLIAN_LETTER_UE	0x1826
#define T_UTF_16_MONGOLIAN_LETTER_EE	0x1827
#define T_UTF_16_MONGOLIAN_LETTER_NA	0x1828
#define T_UTF_16_MONGOLIAN_LETTER_ANG	0x1829
#define T_UTF_16_MONGOLIAN_LETTER_BA	0x182A
#define T_UTF_16_MONGOLIAN_LETTER_PA	0x182B
#define T_UTF_16_MONGOLIAN_LETTER_QA	0x182C
#define T_UTF_16_MONGOLIAN_LETTER_GA	0x182D
#define T_UTF_16_MONGOLIAN_LETTER_MA	0x182E
#define T_UTF_16_MONGOLIAN_LETTER_LA	0x182F
#define T_UTF_16_MONGOLIAN_LETTER_SA	0x1830
#define T_UTF_16_MONGOLIAN_LETTER_SHA	0x1831
#define T_UTF_16_MONGOLIAN_LETTER_TA	0x1832
#define T_UTF_16_MONGOLIAN_LETTER_DA	0x1833
#define T_UTF_16_MONGOLIAN_LETTER_CHA	0x1834
#define T_UTF_16_MONGOLIAN_LETTER_JA	0x1835
#define T_UTF_16_MONGOLIAN_LETTER_YA	0x1836
#define T_UTF_16_MONGOLIAN_LETTER_RA	0x1837
#define T_UTF_16_MONGOLIAN_LETTER_WA	0x1838
#define T_UTF_16_MONGOLIAN_LETTER_FA	0x1839
#define T_UTF_16_MONGOLIAN_LETTER_KA	0x183A
#define T_UTF_16_MONGOLIAN_LETTER_KHA	0x183B
#define T_UTF_16_MONGOLIAN_LETTER_TSA	0x183C
#define T_UTF_16_MONGOLIAN_LETTER_ZA	0x183D
#define T_UTF_16_MONGOLIAN_LETTER_HAA	0x183E
#define T_UTF_16_MONGOLIAN_LETTER_ZRA	0x183F
#define T_UTF_16_MONGOLIAN_LETTER_LHA	0x1840
#define T_UTF_16_MONGOLIAN_LETTER_ZHI	0x1841
#define T_UTF_16_MONGOLIAN_LETTER_CHI	0x1842
#define T_UTF_16_MONGOLIAN_LETTER_TODO_LONG_VOWEL_SIGN	0x1843
#define T_UTF_16_MONGOLIAN_LETTER_TODO_E	0x1844
#define T_UTF_16_MONGOLIAN_LETTER_TODO_I	0x1845
#define T_UTF_16_MONGOLIAN_LETTER_TODO_O	0x1846
#define T_UTF_16_MONGOLIAN_LETTER_TODO_U	0x1847
#define T_UTF_16_MONGOLIAN_LETTER_TODO_OE	0x1848
#define T_UTF_16_MONGOLIAN_LETTER_TODO_UE	0x1849
#define T_UTF_16_MONGOLIAN_LETTER_TODO_ANG	0x184A
#define T_UTF_16_MONGOLIAN_LETTER_TODO_BA	0x184B
#define T_UTF_16_MONGOLIAN_LETTER_TODO_PA	0x184C
#define T_UTF_16_MONGOLIAN_LETTER_TODO_QA	0x184D
#define T_UTF_16_MONGOLIAN_LETTER_TODO_GA	0x184E
#define T_UTF_16_MONGOLIAN_LETTER_TODO_MA	0x184F
#define T_UTF_16_MONGOLIAN_LETTER_TODO_TA	0x1850
#define T_UTF_16_MONGOLIAN_LETTER_TODO_DA	0x1851
#define T_UTF_16_MONGOLIAN_LETTER_TODO_CHA	0x1852
#define T_UTF_16_MONGOLIAN_LETTER_TODO_JA	0x1853
#define T_UTF_16_MONGOLIAN_LETTER_TODO_TSA	0x1854
#define T_UTF_16_MONGOLIAN_LETTER_TODO_YA	0x1855
#define T_UTF_16_MONGOLIAN_LETTER_TODO_WA	0x1856
#define T_UTF_16_MONGOLIAN_LETTER_TODO_KA	0x1857
#define T_UTF_16_MONGOLIAN_LETTER_TODO_GAA	0x1858
#define T_UTF_16_MONGOLIAN_LETTER_TODO_HAA	0x1859
#define T_UTF_16_MONGOLIAN_LETTER_TODO_JIA	0x185A
#define T_UTF_16_MONGOLIAN_LETTER_TODO_NIA	0x185B
#define T_UTF_16_MONGOLIAN_LETTER_TODO_DZA	0x185C
#define T_UTF_16_MONGOLIAN_LETTER_SIBE_E	0x185D
#define T_UTF_16_MONGOLIAN_LETTER_SIBE_I	0x185E
#define T_UTF_16_MONGOLIAN_LETTER_SIBE_IY	0x185F
#define T_UTF_16_MONGOLIAN_LETTER_SIBE_UE	0x1860
#define T_UTF_16_MONGOLIAN_LETTER_SIBE_U	0x1861
#define T_UTF_16_MONGOLIAN_LETTER_SIBE_ANG	0x1862
#define T_UTF_16_MONGOLIAN_LETTER_SIBE_KA	0x1863
#define T_UTF_16_MONGOLIAN_LETTER_SIBE_GA	0x1864
#define T_UTF_16_MONGOLIAN_LETTER_SIBE_HA	0x1865
#define T_UTF_16_MONGOLIAN_LETTER_SIBE_PA	0x1866
#define T_UTF_16_MONGOLIAN_LETTER_SIBE_SHA	0x1867
#define T_UTF_16_MONGOLIAN_LETTER_SIBE_TA	0x1868
#define T_UTF_16_MONGOLIAN_LETTER_SIBE_DA	0x1869
#define T_UTF_16_MONGOLIAN_LETTER_SIBE_JA	0x186A
#define T_UTF_16_MONGOLIAN_LETTER_SIBE_FA	0x186B
#define T_UTF_16_MONGOLIAN_LETTER_SIBE_GAA	0x186C
#define T_UTF_16_MONGOLIAN_LETTER_SIBE_HAA	0x186D
#define T_UTF_16_MONGOLIAN_LETTER_SIBE_TSA	0x186E
#define T_UTF_16_MONGOLIAN_LETTER_SIBE_ZA	0x186F
#define T_UTF_16_MONGOLIAN_LETTER_SIBE_RAA	0x1870
#define T_UTF_16_MONGOLIAN_LETTER_SIBE_CHA	0x1871
#define T_UTF_16_MONGOLIAN_LETTER_SIBE_ZHA	0x1872
#define T_UTF_16_MONGOLIAN_LETTER_MANCHU_I	0x1873
#define T_UTF_16_MONGOLIAN_LETTER_MANCHU_KA	0x1874
#define T_UTF_16_MONGOLIAN_LETTER_MANCHU_RA	0x1875
#define T_UTF_16_MONGOLIAN_LETTER_MANCHU_FA	0x1876
#define T_UTF_16_MONGOLIAN_LETTER_MANCHU_ZHA	0x1877
#define T_UTF_16_MONGOLIAN_LETTER_ALI_GALI_ANUSVARA_ONE	0x1880
#define T_UTF_16_MONGOLIAN_LETTER_ALI_GALI_VISARGA_ONE	0x1881
#define T_UTF_16_MONGOLIAN_LETTER_ALI_GALI_DAMARU	0x1882
#define T_UTF_16_MONGOLIAN_LETTER_ALI_GALI_UBADAMA	0x1883
#define T_UTF_16_MONGOLIAN_LETTER_ALI_GALI_INVERTED_UBADAMA	0x1884
#define T_UTF_16_MONGOLIAN_LETTER_ALI_GALI_BALUDA	0x1885
#define T_UTF_16_MONGOLIAN_LETTER_ALI_GALI_THREE_BALUDA	0x1886
#define T_UTF_16_MONGOLIAN_LETTER_ALI_GALI_A	0x1887
#define T_UTF_16_MONGOLIAN_LETTER_ALI_GALI_I	0x1888
#define T_UTF_16_MONGOLIAN_LETTER_ALI_GALI_KA	0x1889
#define T_UTF_16_MONGOLIAN_LETTER_ALI_GALI_NGA	0x188A
#define T_UTF_16_MONGOLIAN_LETTER_ALI_GALI_CA	0x188B
#define T_UTF_16_MONGOLIAN_LETTER_ALI_GALI_TTA	0x188C
#define T_UTF_16_MONGOLIAN_LETTER_ALI_GALI_TTHA	0x188D
#define T_UTF_16_MONGOLIAN_LETTER_ALI_GALI_DDA	0x188E
#define T_UTF_16_MONGOLIAN_LETTER_ALI_GALI_NNA	0x188F
#define T_UTF_16_MONGOLIAN_LETTER_ALI_GALI_TA	0x1890
#define T_UTF_16_MONGOLIAN_LETTER_ALI_GALI_DA	0x1891
#define T_UTF_16_MONGOLIAN_LETTER_ALI_GALI_PA	0x1892
#define T_UTF_16_MONGOLIAN_LETTER_ALI_GALI_PHA	0x1893
#define T_UTF_16_MONGOLIAN_LETTER_ALI_GALI_SSA	0x1894
#define T_UTF_16_MONGOLIAN_LETTER_ALI_GALI_ZHA	0x1895
#define T_UTF_16_MONGOLIAN_LETTER_ALI_GALI_ZA	0x1896
#define T_UTF_16_MONGOLIAN_LETTER_ALI_GALI_AH	0x1897
#define T_UTF_16_MONGOLIAN_LETTER_TODO_ALI_GALI_TA	0x1898
#define T_UTF_16_MONGOLIAN_LETTER_TODO_ALI_GALI_ZHA	0x1899
#define T_UTF_16_MONGOLIAN_LETTER_MANCHU_ALI_GALI_GHA	0x189A
#define T_UTF_16_MONGOLIAN_LETTER_MANCHU_ALI_GALI_NGA	0x189B
#define T_UTF_16_MONGOLIAN_LETTER_MANCHU_ALI_GALI_CA	0x189C
#define T_UTF_16_MONGOLIAN_LETTER_MANCHU_ALI_GALI_JHA	0x189D
#define T_UTF_16_MONGOLIAN_LETTER_MANCHU_ALI_GALI_TTA	0x189E
#define T_UTF_16_MONGOLIAN_LETTER_MANCHU_ALI_GALI_DDHA	0x189F
#define T_UTF_16_MONGOLIAN_LETTER_MANCHU_ALI_GALI_TA	0x18A0
#define T_UTF_16_MONGOLIAN_LETTER_MANCHU_ALI_GALI_DHA	0x18A1
#define T_UTF_16_MONGOLIAN_LETTER_MANCHU_ALI_GALI_SSA	0x18A2
#define T_UTF_16_MONGOLIAN_LETTER_MANCHU_ALI_GALI_CYA	0x18A3
#define T_UTF_16_MONGOLIAN_LETTER_MANCHU_ALI_GALI_ZHA	0x18A4
#define T_UTF_16_MONGOLIAN_LETTER_MANCHU_ALI_GALI_ZA	0x18A5
#define T_UTF_16_MONGOLIAN_LETTER_ALI_GALI_HALF_U	0x18A6
#define T_UTF_16_MONGOLIAN_LETTER_ALI_GALI_HALF_YA	0x18A7
#define T_UTF_16_MONGOLIAN_LETTER_MANCHU_ALI_GALI_BHA	0x18A8
#define T_UTF_16_MONGOLIAN_LETTER_ALI_GALI_DAGALGA	0x18A9
#define T_UTF_16_LATIN_CAPITAL_LETTER_A_WITH_RING_BELOW	0x1E00
#define T_UTF_16_LATIN_SMALL_LETTER_A_WITH_RING_BELOW	0x1E01
#define T_UTF_16_LATIN_CAPITAL_LETTER_B_WITH_DOT_ABOVE	0x1E02
#define T_UTF_16_LATIN_SMALL_LETTER_B_WITH_DOT_ABOVE	0x1E03
#define T_UTF_16_LATIN_CAPITAL_LETTER_B_WITH_DOT_BELOW	0x1E04
#define T_UTF_16_LATIN_SMALL_LETTER_B_WITH_DOT_BELOW	0x1E05
#define T_UTF_16_LATIN_CAPITAL_LETTER_B_WITH_LINE_BELOW	0x1E06
#define T_UTF_16_LATIN_SMALL_LETTER_B_WITH_LINE_BELOW	0x1E07
#define T_UTF_16_LATIN_CAPITAL_LETTER_C_WITH_CEDILLA_AND_ACUTE	0x1E08
#define T_UTF_16_LATIN_SMALL_LETTER_C_WITH_CEDILLA_AND_ACUTE	0x1E09
#define T_UTF_16_LATIN_CAPITAL_LETTER_D_WITH_DOT_ABOVE	0x1E0A
#define T_UTF_16_LATIN_SMALL_LETTER_D_WITH_DOT_ABOVE	0x1E0B
#define T_UTF_16_LATIN_CAPITAL_LETTER_D_WITH_DOT_BELOW	0x1E0C
#define T_UTF_16_LATIN_SMALL_LETTER_D_WITH_DOT_BELOW	0x1E0D
#define T_UTF_16_LATIN_CAPITAL_LETTER_D_WITH_LINE_BELOW	0x1E0E
#define T_UTF_16_LATIN_SMALL_LETTER_D_WITH_LINE_BELOW	0x1E0F
#define T_UTF_16_LATIN_CAPITAL_LETTER_D_WITH_CEDILLA	0x1E10
#define T_UTF_16_LATIN_SMALL_LETTER_D_WITH_CEDILLA	0x1E11
#define T_UTF_16_LATIN_CAPITAL_LETTER_D_WITH_CIRCUMFLEX_BELOW	0x1E12
#define T_UTF_16_LATIN_SMALL_LETTER_D_WITH_CIRCUMFLEX_BELOW	0x1E13
#define T_UTF_16_LATIN_CAPITAL_LETTER_E_WITH_MACRON_AND_GRAVE	0x1E14
#define T_UTF_16_LATIN_SMALL_LETTER_E_WITH_MACRON_AND_GRAVE	0x1E15
#define T_UTF_16_LATIN_CAPITAL_LETTER_E_WITH_MACRON_AND_ACUTE	0x1E16
#define T_UTF_16_LATIN_SMALL_LETTER_E_WITH_MACRON_AND_ACUTE	0x1E17
#define T_UTF_16_LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX_BELOW	0x1E18
#define T_UTF_16_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_BELOW	0x1E19
#define T_UTF_16_LATIN_CAPITAL_LETTER_E_WITH_TILDE_BELOW	0x1E1A
#define T_UTF_16_LATIN_SMALL_LETTER_E_WITH_TILDE_BELOW	0x1E1B
#define T_UTF_16_LATIN_CAPITAL_LETTER_E_WITH_CEDILLA_AND_BREVE	0x1E1C
#define T_UTF_16_LATIN_SMALL_LETTER_E_WITH_CEDILLA_AND_BREVE	0x1E1D
#define T_UTF_16_LATIN_CAPITAL_LETTER_F_WITH_DOT_ABOVE	0x1E1E
#define T_UTF_16_LATIN_SMALL_LETTER_F_WITH_DOT_ABOVE	0x1E1F
#define T_UTF_16_LATIN_CAPITAL_LETTER_G_WITH_MACRON	0x1E20
#define T_UTF_16_LATIN_SMALL_LETTER_G_WITH_MACRON	0x1E21
#define T_UTF_16_LATIN_CAPITAL_LETTER_H_WITH_DOT_ABOVE	0x1E22
#define T_UTF_16_LATIN_SMALL_LETTER_H_WITH_DOT_ABOVE	0x1E23
#define T_UTF_16_LATIN_CAPITAL_LETTER_H_WITH_DOT_BELOW	0x1E24
#define T_UTF_16_LATIN_SMALL_LETTER_H_WITH_DOT_BELOW	0x1E25
#define T_UTF_16_LATIN_CAPITAL_LETTER_H_WITH_DIAERESIS	0x1E26
#define T_UTF_16_LATIN_SMALL_LETTER_H_WITH_DIAERESIS	0x1E27
#define T_UTF_16_LATIN_CAPITAL_LETTER_H_WITH_CEDILLA	0x1E28
#define T_UTF_16_LATIN_SMALL_LETTER_H_WITH_CEDILLA	0x1E29
#define T_UTF_16_LATIN_CAPITAL_LETTER_H_WITH_BREVE_BELOW	0x1E2A
#define T_UTF_16_LATIN_SMALL_LETTER_H_WITH_BREVE_BELOW	0x1E2B
#define T_UTF_16_LATIN_CAPITAL_LETTER_I_WITH_TILDE_BELOW	0x1E2C
#define T_UTF_16_LATIN_SMALL_LETTER_I_WITH_TILDE_BELOW	0x1E2D
#define T_UTF_16_LATIN_CAPITAL_LETTER_I_WITH_DIAERESIS_AND_ACUTE	0x1E2E
#define T_UTF_16_LATIN_SMALL_LETTER_I_WITH_DIAERESIS_AND_ACUTE	0x1E2F
#define T_UTF_16_LATIN_CAPITAL_LETTER_K_WITH_ACUTE	0x1E30
#define T_UTF_16_LATIN_SMALL_LETTER_K_WITH_ACUTE	0x1E31
#define T_UTF_16_LATIN_CAPITAL_LETTER_K_WITH_DOT_BELOW	0x1E32
#define T_UTF_16_LATIN_SMALL_LETTER_K_WITH_DOT_BELOW	0x1E33
#define T_UTF_16_LATIN_CAPITAL_LETTER_K_WITH_LINE_BELOW	0x1E34
#define T_UTF_16_LATIN_SMALL_LETTER_K_WITH_LINE_BELOW	0x1E35
#define T_UTF_16_LATIN_CAPITAL_LETTER_L_WITH_DOT_BELOW	0x1E36
#define T_UTF_16_LATIN_SMALL_LETTER_L_WITH_DOT_BELOW	0x1E37
#define T_UTF_16_LATIN_CAPITAL_LETTER_L_WITH_DOT_BELOW_AND_MACRON	0x1E38
#define T_UTF_16_LATIN_SMALL_LETTER_L_WITH_DOT_BELOW_AND_MACRON	0x1E39
#define T_UTF_16_LATIN_CAPITAL_LETTER_L_WITH_LINE_BELOW	0x1E3A
#define T_UTF_16_LATIN_SMALL_LETTER_L_WITH_LINE_BELOW	0x1E3B
#define T_UTF_16_LATIN_CAPITAL_LETTER_L_WITH_CIRCUMFLEX_BELOW	0x1E3C
#define T_UTF_16_LATIN_SMALL_LETTER_L_WITH_CIRCUMFLEX_BELOW	0x1E3D
#define T_UTF_16_LATIN_CAPITAL_LETTER_M_WITH_ACUTE	0x1E3E
#define T_UTF_16_LATIN_SMALL_LETTER_M_WITH_ACUTE	0x1E3F
#define T_UTF_16_LATIN_CAPITAL_LETTER_M_WITH_DOT_ABOVE	0x1E40
#define T_UTF_16_LATIN_SMALL_LETTER_M_WITH_DOT_ABOVE	0x1E41
#define T_UTF_16_LATIN_CAPITAL_LETTER_M_WITH_DOT_BELOW	0x1E42
#define T_UTF_16_LATIN_SMALL_LETTER_M_WITH_DOT_BELOW	0x1E43
#define T_UTF_16_LATIN_CAPITAL_LETTER_N_WITH_DOT_ABOVE	0x1E44
#define T_UTF_16_LATIN_SMALL_LETTER_N_WITH_DOT_ABOVE	0x1E45
#define T_UTF_16_LATIN_CAPITAL_LETTER_N_WITH_DOT_BELOW	0x1E46
#define T_UTF_16_LATIN_SMALL_LETTER_N_WITH_DOT_BELOW	0x1E47
#define T_UTF_16_LATIN_CAPITAL_LETTER_N_WITH_LINE_BELOW	0x1E48
#define T_UTF_16_LATIN_SMALL_LETTER_N_WITH_LINE_BELOW	0x1E49
#define T_UTF_16_LATIN_CAPITAL_LETTER_N_WITH_CIRCUMFLEX_BELOW	0x1E4A
#define T_UTF_16_LATIN_SMALL_LETTER_N_WITH_CIRCUMFLEX_BELOW	0x1E4B
#define T_UTF_16_LATIN_CAPITAL_LETTER_O_WITH_TILDE_AND_ACUTE	0x1E4C
#define T_UTF_16_LATIN_SMALL_LETTER_O_WITH_TILDE_AND_ACUTE	0x1E4D
#define T_UTF_16_LATIN_CAPITAL_LETTER_O_WITH_TILDE_AND_DIAERESIS	0x1E4E
#define T_UTF_16_LATIN_SMALL_LETTER_O_WITH_TILDE_AND_DIAERESIS	0x1E4F
#define T_UTF_16_LATIN_CAPITAL_LETTER_O_WITH_MACRON_AND_GRAVE	0x1E50
#define T_UTF_16_LATIN_SMALL_LETTER_O_WITH_MACRON_AND_GRAVE	0x1E51
#define T_UTF_16_LATIN_CAPITAL_LETTER_O_WITH_MACRON_AND_ACUTE	0x1E52
#define T_UTF_16_LATIN_SMALL_LETTER_O_WITH_MACRON_AND_ACUTE	0x1E53
#define T_UTF_16_LATIN_CAPITAL_LETTER_P_WITH_ACUTE	0x1E54
#define T_UTF_16_LATIN_SMALL_LETTER_P_WITH_ACUTE	0x1E55
#define T_UTF_16_LATIN_CAPITAL_LETTER_P_WITH_DOT_ABOVE	0x1E56
#define T_UTF_16_LATIN_SMALL_LETTER_P_WITH_DOT_ABOVE	0x1E57
#define T_UTF_16_LATIN_CAPITAL_LETTER_R_WITH_DOT_ABOVE	0x1E58
#define T_UTF_16_LATIN_SMALL_LETTER_R_WITH_DOT_ABOVE	0x1E59
#define T_UTF_16_LATIN_CAPITAL_LETTER_R_WITH_DOT_BELOW	0x1E5A
#define T_UTF_16_LATIN_SMALL_LETTER_R_WITH_DOT_BELOW	0x1E5B
#define T_UTF_16_LATIN_CAPITAL_LETTER_R_WITH_DOT_BELOW_AND_MACRON	0x1E5C
#define T_UTF_16_LATIN_SMALL_LETTER_R_WITH_DOT_BELOW_AND_MACRON	0x1E5D
#define T_UTF_16_LATIN_CAPITAL_LETTER_R_WITH_LINE_BELOW	0x1E5E
#define T_UTF_16_LATIN_SMALL_LETTER_R_WITH_LINE_BELOW	0x1E5F
#define T_UTF_16_LATIN_CAPITAL_LETTER_S_WITH_DOT_ABOVE	0x1E60
#define T_UTF_16_LATIN_SMALL_LETTER_S_WITH_DOT_ABOVE	0x1E61
#define T_UTF_16_LATIN_CAPITAL_LETTER_S_WITH_DOT_BELOW	0x1E62
#define T_UTF_16_LATIN_SMALL_LETTER_S_WITH_DOT_BELOW	0x1E63
#define T_UTF_16_LATIN_CAPITAL_LETTER_S_WITH_ACUTE_AND_DOT_ABOVE	0x1E64
#define T_UTF_16_LATIN_SMALL_LETTER_S_WITH_ACUTE_AND_DOT_ABOVE	0x1E65
#define T_UTF_16_LATIN_CAPITAL_LETTER_S_WITH_CARON_AND_DOT_ABOVE	0x1E66
#define T_UTF_16_LATIN_SMALL_LETTER_S_WITH_CARON_AND_DOT_ABOVE	0x1E67
#define T_UTF_16_LATIN_CAPITAL_LETTER_S_WITH_DOT_BELOW_AND_DOT_ABOVE	0x1E68
#define T_UTF_16_LATIN_SMALL_LETTER_S_WITH_DOT_BELOW_AND_DOT_ABOVE	0x1E69
#define T_UTF_16_LATIN_CAPITAL_LETTER_T_WITH_DOT_ABOVE	0x1E6A
#define T_UTF_16_LATIN_SMALL_LETTER_T_WITH_DOT_ABOVE	0x1E6B
#define T_UTF_16_LATIN_CAPITAL_LETTER_T_WITH_DOT_BELOW	0x1E6C
#define T_UTF_16_LATIN_SMALL_LETTER_T_WITH_DOT_BELOW	0x1E6D
#define T_UTF_16_LATIN_CAPITAL_LETTER_T_WITH_LINE_BELOW	0x1E6E
#define T_UTF_16_LATIN_SMALL_LETTER_T_WITH_LINE_BELOW	0x1E6F
#define T_UTF_16_LATIN_CAPITAL_LETTER_T_WITH_CIRCUMFLEX_BELOW	0x1E70
#define T_UTF_16_LATIN_SMALL_LETTER_T_WITH_CIRCUMFLEX_BELOW	0x1E71
#define T_UTF_16_LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS_BELOW	0x1E72
#define T_UTF_16_LATIN_SMALL_LETTER_U_WITH_DIAERESIS_BELOW	0x1E73
#define T_UTF_16_LATIN_CAPITAL_LETTER_U_WITH_TILDE_BELOW	0x1E74
#define T_UTF_16_LATIN_SMALL_LETTER_U_WITH_TILDE_BELOW	0x1E75
#define T_UTF_16_LATIN_CAPITAL_LETTER_U_WITH_CIRCUMFLEX_BELOW	0x1E76
#define T_UTF_16_LATIN_SMALL_LETTER_U_WITH_CIRCUMFLEX_BELOW	0x1E77
#define T_UTF_16_LATIN_CAPITAL_LETTER_U_WITH_TILDE_AND_ACUTE	0x1E78
#define T_UTF_16_LATIN_SMALL_LETTER_U_WITH_TILDE_AND_ACUTE	0x1E79
#define T_UTF_16_LATIN_CAPITAL_LETTER_U_WITH_MACRON_AND_DIAERESIS	0x1E7A
#define T_UTF_16_LATIN_SMALL_LETTER_U_WITH_MACRON_AND_DIAERESIS	0x1E7B
#define T_UTF_16_LATIN_CAPITAL_LETTER_V_WITH_TILDE	0x1E7C
#define T_UTF_16_LATIN_SMALL_LETTER_V_WITH_TILDE	0x1E7D
#define T_UTF_16_LATIN_CAPITAL_LETTER_V_WITH_DOT_BELOW	0x1E7E
#define T_UTF_16_LATIN_SMALL_LETTER_V_WITH_DOT_BELOW	0x1E7F
#define T_UTF_16_LATIN_CAPITAL_LETTER_W_WITH_GRAVE	0x1E80
#define T_UTF_16_LATIN_SMALL_LETTER_W_WITH_GRAVE	0x1E81
#define T_UTF_16_LATIN_CAPITAL_LETTER_W_WITH_ACUTE	0x1E82
#define T_UTF_16_LATIN_SMALL_LETTER_W_WITH_ACUTE	0x1E83
#define T_UTF_16_LATIN_CAPITAL_LETTER_W_WITH_DIAERESIS	0x1E84
#define T_UTF_16_LATIN_SMALL_LETTER_W_WITH_DIAERESIS	0x1E85
#define T_UTF_16_LATIN_CAPITAL_LETTER_W_WITH_DOT_ABOVE	0x1E86
#define T_UTF_16_LATIN_SMALL_LETTER_W_WITH_DOT_ABOVE	0x1E87
#define T_UTF_16_LATIN_CAPITAL_LETTER_W_WITH_DOT_BELOW	0x1E88
#define T_UTF_16_LATIN_SMALL_LETTER_W_WITH_DOT_BELOW	0x1E89
#define T_UTF_16_LATIN_CAPITAL_LETTER_X_WITH_DOT_ABOVE	0x1E8A
#define T_UTF_16_LATIN_SMALL_LETTER_X_WITH_DOT_ABOVE	0x1E8B
#define T_UTF_16_LATIN_CAPITAL_LETTER_X_WITH_DIAERESIS	0x1E8C
#define T_UTF_16_LATIN_SMALL_LETTER_X_WITH_DIAERESIS	0x1E8D
#define T_UTF_16_LATIN_CAPITAL_LETTER_Y_WITH_DOT_ABOVE	0x1E8E
#define T_UTF_16_LATIN_SMALL_LETTER_Y_WITH_DOT_ABOVE	0x1E8F
#define T_UTF_16_LATIN_CAPITAL_LETTER_Z_WITH_CIRCUMFLEX	0x1E90
#define T_UTF_16_LATIN_SMALL_LETTER_Z_WITH_CIRCUMFLEX	0x1E91
#define T_UTF_16_LATIN_CAPITAL_LETTER_Z_WITH_DOT_BELOW	0x1E92
#define T_UTF_16_LATIN_SMALL_LETTER_Z_WITH_DOT_BELOW	0x1E93
#define T_UTF_16_LATIN_CAPITAL_LETTER_Z_WITH_LINE_BELOW	0x1E94
#define T_UTF_16_LATIN_SMALL_LETTER_Z_WITH_LINE_BELOW	0x1E95
#define T_UTF_16_LATIN_SMALL_LETTER_H_WITH_LINE_BELOW	0x1E96
#define T_UTF_16_LATIN_SMALL_LETTER_T_WITH_DIAERESIS	0x1E97
#define T_UTF_16_LATIN_SMALL_LETTER_W_WITH_RING_ABOVE	0x1E98
#define T_UTF_16_LATIN_SMALL_LETTER_Y_WITH_RING_ABOVE	0x1E99
#define T_UTF_16_LATIN_SMALL_LETTER_A_WITH_RIGHT_HALF_RING	0x1E9A
#define T_UTF_16_LATIN_SMALL_LETTER_LONG_S_WITH_DOT_ABOVE	0x1E9B
#define T_UTF_16_LATIN_CAPITAL_LETTER_A_WITH_DOT_BELOW	0x1EA0
#define T_UTF_16_LATIN_SMALL_LETTER_A_WITH_DOT_BELOW	0x1EA1
#define T_UTF_16_LATIN_CAPITAL_LETTER_A_WITH_HOOK_ABOVE	0x1EA2
#define T_UTF_16_LATIN_SMALL_LETTER_A_WITH_HOOK_ABOVE	0x1EA3
#define T_UTF_16_LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX_AND_ACUTE	0x1EA4
#define T_UTF_16_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_ACUTE	0x1EA5
#define T_UTF_16_LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX_AND_GRAVE	0x1EA6
#define T_UTF_16_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_GRAVE	0x1EA7
#define T_UTF_16_LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX_AND_HOOK_ABOVE	0x1EA8
#define T_UTF_16_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_HOOK_ABOVE	0x1EA9
#define T_UTF_16_LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX_AND_TILDE	0x1EAA
#define T_UTF_16_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_TILDE	0x1EAB
#define T_UTF_16_LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX_AND_DOT_BELOW	0x1EAC
#define T_UTF_16_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_DOT_BELOW	0x1EAD
#define T_UTF_16_LATIN_CAPITAL_LETTER_A_WITH_BREVE_AND_ACUTE	0x1EAE
#define T_UTF_16_LATIN_SMALL_LETTER_A_WITH_BREVE_AND_ACUTE	0x1EAF
#define T_UTF_16_LATIN_CAPITAL_LETTER_A_WITH_BREVE_AND_GRAVE	0x1EB0
#define T_UTF_16_LATIN_SMALL_LETTER_A_WITH_BREVE_AND_GRAVE	0x1EB1
#define T_UTF_16_LATIN_CAPITAL_LETTER_A_WITH_BREVE_AND_HOOK_ABOVE	0x1EB2
#define T_UTF_16_LATIN_SMALL_LETTER_A_WITH_BREVE_AND_HOOK_ABOVE	0x1EB3
#define T_UTF_16_LATIN_CAPITAL_LETTER_A_WITH_BREVE_AND_TILDE	0x1EB4
#define T_UTF_16_LATIN_SMALL_LETTER_A_WITH_BREVE_AND_TILDE	0x1EB5
#define T_UTF_16_LATIN_CAPITAL_LETTER_A_WITH_BREVE_AND_DOT_BELOW	0x1EB6
#define T_UTF_16_LATIN_SMALL_LETTER_A_WITH_BREVE_AND_DOT_BELOW	0x1EB7
#define T_UTF_16_LATIN_CAPITAL_LETTER_E_WITH_DOT_BELOW	0x1EB8
#define T_UTF_16_LATIN_SMALL_LETTER_E_WITH_DOT_BELOW	0x1EB9
#define T_UTF_16_LATIN_CAPITAL_LETTER_E_WITH_HOOK_ABOVE	0x1EBA
#define T_UTF_16_LATIN_SMALL_LETTER_E_WITH_HOOK_ABOVE	0x1EBB
#define T_UTF_16_LATIN_CAPITAL_LETTER_E_WITH_TILDE	0x1EBC
#define T_UTF_16_LATIN_SMALL_LETTER_E_WITH_TILDE	0x1EBD
#define T_UTF_16_LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX_AND_ACUTE	0x1EBE
#define T_UTF_16_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_ACUTE	0x1EBF
#define T_UTF_16_LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX_AND_GRAVE	0x1EC0
#define T_UTF_16_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_GRAVE	0x1EC1
#define T_UTF_16_LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX_AND_HOOK_ABOVE	0x1EC2
#define T_UTF_16_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_HOOK_ABOVE	0x1EC3
#define T_UTF_16_LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX_AND_TILDE	0x1EC4
#define T_UTF_16_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_TILDE	0x1EC5
#define T_UTF_16_LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX_AND_DOT_BELOW	0x1EC6
#define T_UTF_16_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_DOT_BELOW	0x1EC7
#define T_UTF_16_LATIN_CAPITAL_LETTER_I_WITH_HOOK_ABOVE	0x1EC8
#define T_UTF_16_LATIN_SMALL_LETTER_I_WITH_HOOK_ABOVE	0x1EC9
#define T_UTF_16_LATIN_CAPITAL_LETTER_I_WITH_DOT_BELOW	0x1ECA
#define T_UTF_16_LATIN_SMALL_LETTER_I_WITH_DOT_BELOW	0x1ECB
#define T_UTF_16_LATIN_CAPITAL_LETTER_O_WITH_DOT_BELOW	0x1ECC
#define T_UTF_16_LATIN_SMALL_LETTER_O_WITH_DOT_BELOW	0x1ECD
#define T_UTF_16_LATIN_CAPITAL_LETTER_O_WITH_HOOK_ABOVE	0x1ECE
#define T_UTF_16_LATIN_SMALL_LETTER_O_WITH_HOOK_ABOVE	0x1ECF
#define T_UTF_16_LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX_AND_ACUTE	0x1ED0
#define T_UTF_16_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_ACUTE	0x1ED1
#define T_UTF_16_LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX_AND_GRAVE	0x1ED2
#define T_UTF_16_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_GRAVE	0x1ED3
#define T_UTF_16_LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX_AND_HOOK_ABOVE	0x1ED4
#define T_UTF_16_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_HOOK_ABOVE	0x1ED5
#define T_UTF_16_LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX_AND_TILDE	0x1ED6
#define T_UTF_16_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_TILDE	0x1ED7
#define T_UTF_16_LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX_AND_DOT_BELOW	0x1ED8
#define T_UTF_16_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_DOT_BELOW	0x1ED9
#define T_UTF_16_LATIN_CAPITAL_LETTER_O_WITH_HORN_AND_ACUTE	0x1EDA
#define T_UTF_16_LATIN_SMALL_LETTER_O_WITH_HORN_AND_ACUTE	0x1EDB
#define T_UTF_16_LATIN_CAPITAL_LETTER_O_WITH_HORN_AND_GRAVE	0x1EDC
#define T_UTF_16_LATIN_SMALL_LETTER_O_WITH_HORN_AND_GRAVE	0x1EDD
#define T_UTF_16_LATIN_CAPITAL_LETTER_O_WITH_HORN_AND_HOOK_ABOVE	0x1EDE
#define T_UTF_16_LATIN_SMALL_LETTER_O_WITH_HORN_AND_HOOK_ABOVE	0x1EDF
#define T_UTF_16_LATIN_CAPITAL_LETTER_O_WITH_HORN_AND_TILDE	0x1EE0
#define T_UTF_16_LATIN_SMALL_LETTER_O_WITH_HORN_AND_TILDE	0x1EE1
#define T_UTF_16_LATIN_CAPITAL_LETTER_O_WITH_HORN_AND_DOT_BELOW	0x1EE2
#define T_UTF_16_LATIN_SMALL_LETTER_O_WITH_HORN_AND_DOT_BELOW	0x1EE3
#define T_UTF_16_LATIN_CAPITAL_LETTER_U_WITH_DOT_BELOW	0x1EE4
#define T_UTF_16_LATIN_SMALL_LETTER_U_WITH_DOT_BELOW	0x1EE5
#define T_UTF_16_LATIN_CAPITAL_LETTER_U_WITH_HOOK_ABOVE	0x1EE6
#define T_UTF_16_LATIN_SMALL_LETTER_U_WITH_HOOK_ABOVE	0x1EE7
#define T_UTF_16_LATIN_CAPITAL_LETTER_U_WITH_HORN_AND_ACUTE	0x1EE8
#define T_UTF_16_LATIN_SMALL_LETTER_U_WITH_HORN_AND_ACUTE	0x1EE9
#define T_UTF_16_LATIN_CAPITAL_LETTER_U_WITH_HORN_AND_GRAVE	0x1EEA
#define T_UTF_16_LATIN_SMALL_LETTER_U_WITH_HORN_AND_GRAVE	0x1EEB
#define T_UTF_16_LATIN_CAPITAL_LETTER_U_WITH_HORN_AND_HOOK_ABOVE	0x1EEC
#define T_UTF_16_LATIN_SMALL_LETTER_U_WITH_HORN_AND_HOOK_ABOVE	0x1EED
#define T_UTF_16_LATIN_CAPITAL_LETTER_U_WITH_HORN_AND_TILDE	0x1EEE
#define T_UTF_16_LATIN_SMALL_LETTER_U_WITH_HORN_AND_TILDE	0x1EEF
#define T_UTF_16_LATIN_CAPITAL_LETTER_U_WITH_HORN_AND_DOT_BELOW	0x1EF0
#define T_UTF_16_LATIN_SMALL_LETTER_U_WITH_HORN_AND_DOT_BELOW	0x1EF1
#define T_UTF_16_LATIN_CAPITAL_LETTER_Y_WITH_GRAVE	0x1EF2
#define T_UTF_16_LATIN_SMALL_LETTER_Y_WITH_GRAVE	0x1EF3
#define T_UTF_16_LATIN_CAPITAL_LETTER_Y_WITH_DOT_BELOW	0x1EF4
#define T_UTF_16_LATIN_SMALL_LETTER_Y_WITH_DOT_BELOW	0x1EF5
#define T_UTF_16_LATIN_CAPITAL_LETTER_Y_WITH_HOOK_ABOVE	0x1EF6
#define T_UTF_16_LATIN_SMALL_LETTER_Y_WITH_HOOK_ABOVE	0x1EF7
#define T_UTF_16_LATIN_CAPITAL_LETTER_Y_WITH_TILDE	0x1EF8
#define T_UTF_16_LATIN_SMALL_LETTER_Y_WITH_TILDE	0x1EF9
#define T_UTF_16_GREEK_SMALL_LETTER_ALPHA_WITH_PSILI	0x1F00
#define T_UTF_16_GREEK_SMALL_LETTER_ALPHA_WITH_DASIA	0x1F01
#define T_UTF_16_GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_VARIA	0x1F02
#define T_UTF_16_GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_VARIA	0x1F03
#define T_UTF_16_GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_OXIA	0x1F04
#define T_UTF_16_GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_OXIA	0x1F05
#define T_UTF_16_GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_PERISPOMENI	0x1F06
#define T_UTF_16_GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_PERISPOMENI	0x1F07
#define T_UTF_16_GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI	0x1F08
#define T_UTF_16_GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA	0x1F09
#define T_UTF_16_GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_VARIA	0x1F0A
#define T_UTF_16_GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_VARIA	0x1F0B
#define T_UTF_16_GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_OXIA	0x1F0C
#define T_UTF_16_GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_OXIA	0x1F0D
#define T_UTF_16_GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_PERISPOMENI	0x1F0E
#define T_UTF_16_GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_PERISPOMENI	0x1F0F
#define T_UTF_16_GREEK_SMALL_LETTER_EPSILON_WITH_PSILI	0x1F10
#define T_UTF_16_GREEK_SMALL_LETTER_EPSILON_WITH_DASIA	0x1F11
#define T_UTF_16_GREEK_SMALL_LETTER_EPSILON_WITH_PSILI_AND_VARIA	0x1F12
#define T_UTF_16_GREEK_SMALL_LETTER_EPSILON_WITH_DASIA_AND_VARIA	0x1F13
#define T_UTF_16_GREEK_SMALL_LETTER_EPSILON_WITH_PSILI_AND_OXIA	0x1F14
#define T_UTF_16_GREEK_SMALL_LETTER_EPSILON_WITH_DASIA_AND_OXIA	0x1F15
#define T_UTF_16_GREEK_CAPITAL_LETTER_EPSILON_WITH_PSILI	0x1F18
#define T_UTF_16_GREEK_CAPITAL_LETTER_EPSILON_WITH_DASIA	0x1F19
#define T_UTF_16_GREEK_CAPITAL_LETTER_EPSILON_WITH_PSILI_AND_VARIA	0x1F1A
#define T_UTF_16_GREEK_CAPITAL_LETTER_EPSILON_WITH_DASIA_AND_VARIA	0x1F1B
#define T_UTF_16_GREEK_CAPITAL_LETTER_EPSILON_WITH_PSILI_AND_OXIA	0x1F1C
#define T_UTF_16_GREEK_CAPITAL_LETTER_EPSILON_WITH_DASIA_AND_OXIA	0x1F1D
#define T_UTF_16_GREEK_SMALL_LETTER_ETA_WITH_PSILI	0x1F20
#define T_UTF_16_GREEK_SMALL_LETTER_ETA_WITH_DASIA	0x1F21
#define T_UTF_16_GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_VARIA	0x1F22
#define T_UTF_16_GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_VARIA	0x1F23
#define T_UTF_16_GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_OXIA	0x1F24
#define T_UTF_16_GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_OXIA	0x1F25
#define T_UTF_16_GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_PERISPOMENI	0x1F26
#define T_UTF_16_GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_PERISPOMENI	0x1F27
#define T_UTF_16_GREEK_CAPITAL_LETTER_ETA_WITH_PSILI	0x1F28
#define T_UTF_16_GREEK_CAPITAL_LETTER_ETA_WITH_DASIA	0x1F29
#define T_UTF_16_GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_VARIA	0x1F2A
#define T_UTF_16_GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_VARIA	0x1F2B
#define T_UTF_16_GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_OXIA	0x1F2C
#define T_UTF_16_GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_OXIA	0x1F2D
#define T_UTF_16_GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_PERISPOMENI	0x1F2E
#define T_UTF_16_GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_PERISPOMENI	0x1F2F
#define T_UTF_16_GREEK_SMALL_LETTER_IOTA_WITH_PSILI	0x1F30
#define T_UTF_16_GREEK_SMALL_LETTER_IOTA_WITH_DASIA	0x1F31
#define T_UTF_16_GREEK_SMALL_LETTER_IOTA_WITH_PSILI_AND_VARIA	0x1F32
#define T_UTF_16_GREEK_SMALL_LETTER_IOTA_WITH_DASIA_AND_VARIA	0x1F33
#define T_UTF_16_GREEK_SMALL_LETTER_IOTA_WITH_PSILI_AND_OXIA	0x1F34
#define T_UTF_16_GREEK_SMALL_LETTER_IOTA_WITH_DASIA_AND_OXIA	0x1F35
#define T_UTF_16_GREEK_SMALL_LETTER_IOTA_WITH_PSILI_AND_PERISPOMENI	0x1F36
#define T_UTF_16_GREEK_SMALL_LETTER_IOTA_WITH_DASIA_AND_PERISPOMENI	0x1F37
#define T_UTF_16_GREEK_CAPITAL_LETTER_IOTA_WITH_PSILI	0x1F38
#define T_UTF_16_GREEK_CAPITAL_LETTER_IOTA_WITH_DASIA	0x1F39
#define T_UTF_16_GREEK_CAPITAL_LETTER_IOTA_WITH_PSILI_AND_VARIA	0x1F3A
#define T_UTF_16_GREEK_CAPITAL_LETTER_IOTA_WITH_DASIA_AND_VARIA	0x1F3B
#define T_UTF_16_GREEK_CAPITAL_LETTER_IOTA_WITH_PSILI_AND_OXIA	0x1F3C
#define T_UTF_16_GREEK_CAPITAL_LETTER_IOTA_WITH_DASIA_AND_OXIA	0x1F3D
#define T_UTF_16_GREEK_CAPITAL_LETTER_IOTA_WITH_PSILI_AND_PERISPOMENI	0x1F3E
#define T_UTF_16_GREEK_CAPITAL_LETTER_IOTA_WITH_DASIA_AND_PERISPOMENI	0x1F3F
#define T_UTF_16_GREEK_SMALL_LETTER_OMICRON_WITH_PSILI	0x1F40
#define T_UTF_16_GREEK_SMALL_LETTER_OMICRON_WITH_DASIA	0x1F41
#define T_UTF_16_GREEK_SMALL_LETTER_OMICRON_WITH_PSILI_AND_VARIA	0x1F42
#define T_UTF_16_GREEK_SMALL_LETTER_OMICRON_WITH_DASIA_AND_VARIA	0x1F43
#define T_UTF_16_GREEK_SMALL_LETTER_OMICRON_WITH_PSILI_AND_OXIA	0x1F44
#define T_UTF_16_GREEK_SMALL_LETTER_OMICRON_WITH_DASIA_AND_OXIA	0x1F45
#define T_UTF_16_GREEK_CAPITAL_LETTER_OMICRON_WITH_PSILI	0x1F48
#define T_UTF_16_GREEK_CAPITAL_LETTER_OMICRON_WITH_DASIA	0x1F49
#define T_UTF_16_GREEK_CAPITAL_LETTER_OMICRON_WITH_PSILI_AND_VARIA	0x1F4A
#define T_UTF_16_GREEK_CAPITAL_LETTER_OMICRON_WITH_DASIA_AND_VARIA	0x1F4B
#define T_UTF_16_GREEK_CAPITAL_LETTER_OMICRON_WITH_PSILI_AND_OXIA	0x1F4C
#define T_UTF_16_GREEK_CAPITAL_LETTER_OMICRON_WITH_DASIA_AND_OXIA	0x1F4D
#define T_UTF_16_GREEK_SMALL_LETTER_UPSILON_WITH_PSILI	0x1F50
#define T_UTF_16_GREEK_SMALL_LETTER_UPSILON_WITH_DASIA	0x1F51
#define T_UTF_16_GREEK_SMALL_LETTER_UPSILON_WITH_PSILI_AND_VARIA	0x1F52
#define T_UTF_16_GREEK_SMALL_LETTER_UPSILON_WITH_DASIA_AND_VARIA	0x1F53
#define T_UTF_16_GREEK_SMALL_LETTER_UPSILON_WITH_PSILI_AND_OXIA	0x1F54
#define T_UTF_16_GREEK_SMALL_LETTER_UPSILON_WITH_DASIA_AND_OXIA	0x1F55
#define T_UTF_16_GREEK_SMALL_LETTER_UPSILON_WITH_PSILI_AND_PERISPOMENI	0x1F56
#define T_UTF_16_GREEK_SMALL_LETTER_UPSILON_WITH_DASIA_AND_PERISPOMENI	0x1F57
#define T_UTF_16_GREEK_CAPITAL_LETTER_UPSILON_WITH_DASIA	0x1F59
#define T_UTF_16_GREEK_CAPITAL_LETTER_UPSILON_WITH_DASIA_AND_VARIA	0x1F5B
#define T_UTF_16_GREEK_CAPITAL_LETTER_UPSILON_WITH_DASIA_AND_OXIA	0x1F5D
#define T_UTF_16_GREEK_CAPITAL_LETTER_UPSILON_WITH_DASIA_AND_PERISPOMENI	0x1F5F
#define T_UTF_16_GREEK_SMALL_LETTER_OMEGA_WITH_PSILI	0x1F60
#define T_UTF_16_GREEK_SMALL_LETTER_OMEGA_WITH_DASIA	0x1F61
#define T_UTF_16_GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_VARIA	0x1F62
#define T_UTF_16_GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_VARIA	0x1F63
#define T_UTF_16_GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_OXIA	0x1F64
#define T_UTF_16_GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_OXIA	0x1F65
#define T_UTF_16_GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_PERISPOMENI	0x1F66
#define T_UTF_16_GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_PERISPOMENI	0x1F67
#define T_UTF_16_GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI	0x1F68
#define T_UTF_16_GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA	0x1F69
#define T_UTF_16_GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_VARIA	0x1F6A
#define T_UTF_16_GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_VARIA	0x1F6B
#define T_UTF_16_GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_OXIA	0x1F6C
#define T_UTF_16_GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_OXIA	0x1F6D
#define T_UTF_16_GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_PERISPOMENI	0x1F6E
#define T_UTF_16_GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_PERISPOMENI	0x1F6F
#define T_UTF_16_GREEK_SMALL_LETTER_ALPHA_WITH_VARIA	0x1F70
#define T_UTF_16_GREEK_SMALL_LETTER_ALPHA_WITH_OXIA	0x1F71
#define T_UTF_16_GREEK_SMALL_LETTER_EPSILON_WITH_VARIA	0x1F72
#define T_UTF_16_GREEK_SMALL_LETTER_EPSILON_WITH_OXIA	0x1F73
#define T_UTF_16_GREEK_SMALL_LETTER_ETA_WITH_VARIA	0x1F74
#define T_UTF_16_GREEK_SMALL_LETTER_ETA_WITH_OXIA	0x1F75
#define T_UTF_16_GREEK_SMALL_LETTER_IOTA_WITH_VARIA	0x1F76
#define T_UTF_16_GREEK_SMALL_LETTER_IOTA_WITH_OXIA	0x1F77
#define T_UTF_16_GREEK_SMALL_LETTER_OMICRON_WITH_VARIA	0x1F78
#define T_UTF_16_GREEK_SMALL_LETTER_OMICRON_WITH_OXIA	0x1F79
#define T_UTF_16_GREEK_SMALL_LETTER_UPSILON_WITH_VARIA	0x1F7A
#define T_UTF_16_GREEK_SMALL_LETTER_UPSILON_WITH_OXIA	0x1F7B
#define T_UTF_16_GREEK_SMALL_LETTER_OMEGA_WITH_VARIA	0x1F7C
#define T_UTF_16_GREEK_SMALL_LETTER_OMEGA_WITH_OXIA	0x1F7D
#define T_UTF_16_GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_YPOGEGRAMMENI	0x1F80
#define T_UTF_16_GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_YPOGEGRAMMENI	0x1F81
#define T_UTF_16_GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_VARIA_AND_YPOGEGRAMMENI	0x1F82
#define T_UTF_16_GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_VARIA_AND_YPOGEGRAMMENI	0x1F83
#define T_UTF_16_GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_OXIA_AND_YPOGEGRAMMENI	0x1F84
#define T_UTF_16_GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_OXIA_AND_YPOGEGRAMMENI	0x1F85
#define T_UTF_16_GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_PERISPOMENI_AND_YPOGEGRAMMENI	0x1F86
#define T_UTF_16_GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_PERISPOMENI_AND_YPOGEGRAMMENI	0x1F87
#define T_UTF_16_GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_PROSGEGRAMMENI	0x1F88
#define T_UTF_16_GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_PROSGEGRAMMENI	0x1F89
#define T_UTF_16_GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_VARIA_AND_PROSGEGRAMMENI	0x1F8A
#define T_UTF_16_GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_VARIA_AND_PROSGEGRAMMENI	0x1F8B
#define T_UTF_16_GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_OXIA_AND_PROSGEGRAMMENI	0x1F8C
#define T_UTF_16_GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_OXIA_AND_PROSGEGRAMMENI	0x1F8D
#define T_UTF_16_GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_PERISPOMENI_AND_PROSGEGRAMMENI	0x1F8E
#define T_UTF_16_GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_PERISPOMENI_AND_PROSGEGRAMMENI	0x1F8F
#define T_UTF_16_GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_YPOGEGRAMMENI	0x1F90
#define T_UTF_16_GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_YPOGEGRAMMENI	0x1F91
#define T_UTF_16_GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_VARIA_AND_YPOGEGRAMMENI	0x1F92
#define T_UTF_16_GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_VARIA_AND_YPOGEGRAMMENI	0x1F93
#define T_UTF_16_GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_OXIA_AND_YPOGEGRAMMENI	0x1F94
#define T_UTF_16_GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_OXIA_AND_YPOGEGRAMMENI	0x1F95
#define T_UTF_16_GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_PERISPOMENI_AND_YPOGEGRAMMENI	0x1F96
#define T_UTF_16_GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_PERISPOMENI_AND_YPOGEGRAMMENI	0x1F97
#define T_UTF_16_GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_PROSGEGRAMMENI	0x1F98
#define T_UTF_16_GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_PROSGEGRAMMENI	0x1F99
#define T_UTF_16_GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_VARIA_AND_PROSGEGRAMMENI	0x1F9A
#define T_UTF_16_GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_VARIA_AND_PROSGEGRAMMENI	0x1F9B
#define T_UTF_16_GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_OXIA_AND_PROSGEGRAMMENI	0x1F9C
#define T_UTF_16_GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_OXIA_AND_PROSGEGRAMMENI	0x1F9D
#define T_UTF_16_GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_PERISPOMENI_AND_PROSGEGRAMMENI	0x1F9E
#define T_UTF_16_GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_PERISPOMENI_AND_PROSGEGRAMMENI	0x1F9F
#define T_UTF_16_GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_YPOGEGRAMMENI	0x1FA0
#define T_UTF_16_GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_YPOGEGRAMMENI	0x1FA1
#define T_UTF_16_GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_VARIA_AND_YPOGEGRAMMENI	0x1FA2
#define T_UTF_16_GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_VARIA_AND_YPOGEGRAMMENI	0x1FA3
#define T_UTF_16_GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_OXIA_AND_YPOGEGRAMMENI	0x1FA4
#define T_UTF_16_GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_OXIA_AND_YPOGEGRAMMENI	0x1FA5
#define T_UTF_16_GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_PERISPOMENI_AND_YPOGEGRAMMENI	0x1FA6
#define T_UTF_16_GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_PERISPOMENI_AND_YPOGEGRAMMENI	0x1FA7
#define T_UTF_16_GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_PROSGEGRAMMENI	0x1FA8
#define T_UTF_16_GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_PROSGEGRAMMENI	0x1FA9
#define T_UTF_16_GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_VARIA_AND_PROSGEGRAMMENI	0x1FAA
#define T_UTF_16_GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_VARIA_AND_PROSGEGRAMMENI	0x1FAB
#define T_UTF_16_GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_OXIA_AND_PROSGEGRAMMENI	0x1FAC
#define T_UTF_16_GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_OXIA_AND_PROSGEGRAMMENI	0x1FAD
#define T_UTF_16_GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_PERISPOMENI_AND_PROSGEGRAMMENI	0x1FAE
#define T_UTF_16_GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_PERISPOMENI_AND_PROSGEGRAMMENI	0x1FAF
#define T_UTF_16_GREEK_SMALL_LETTER_ALPHA_WITH_VRACHY	0x1FB0
#define T_UTF_16_GREEK_SMALL_LETTER_ALPHA_WITH_MACRON	0x1FB1
#define T_UTF_16_GREEK_SMALL_LETTER_ALPHA_WITH_VARIA_AND_YPOGEGRAMMENI	0x1FB2
#define T_UTF_16_GREEK_SMALL_LETTER_ALPHA_WITH_YPOGEGRAMMENI	0x1FB3
#define T_UTF_16_GREEK_SMALL_LETTER_ALPHA_WITH_OXIA_AND_YPOGEGRAMMENI	0x1FB4
#define T_UTF_16_GREEK_SMALL_LETTER_ALPHA_WITH_PERISPOMENI	0x1FB6
#define T_UTF_16_GREEK_SMALL_LETTER_ALPHA_WITH_PERISPOMENI_AND_YPOGEGRAMMENI	0x1FB7
#define T_UTF_16_GREEK_CAPITAL_LETTER_ALPHA_WITH_VRACHY	0x1FB8
#define T_UTF_16_GREEK_CAPITAL_LETTER_ALPHA_WITH_MACRON	0x1FB9
#define T_UTF_16_GREEK_CAPITAL_LETTER_ALPHA_WITH_VARIA	0x1FBA
#define T_UTF_16_GREEK_CAPITAL_LETTER_ALPHA_WITH_OXIA	0x1FBB
#define T_UTF_16_GREEK_CAPITAL_LETTER_ALPHA_WITH_PROSGEGRAMMENI	0x1FBC
#define T_UTF_16_GREEK_KORONIS	0x1FBD
#define T_UTF_16_GREEK_PROSGEGRAMMENI	0x1FBE
#define T_UTF_16_GREEK_PSILI	0x1FBF
#define T_UTF_16_GREEK_PERISPOMENI	0x1FC0
#define T_UTF_16_GREEK_DIALYTIKA_AND_PERISPOMENI	0x1FC1
#define T_UTF_16_GREEK_SMALL_LETTER_ETA_WITH_VARIA_AND_YPOGEGRAMMENI	0x1FC2
#define T_UTF_16_GREEK_SMALL_LETTER_ETA_WITH_YPOGEGRAMMENI	0x1FC3
#define T_UTF_16_GREEK_SMALL_LETTER_ETA_WITH_OXIA_AND_YPOGEGRAMMENI	0x1FC4
#define T_UTF_16_GREEK_SMALL_LETTER_ETA_WITH_PERISPOMENI	0x1FC6
#define T_UTF_16_GREEK_SMALL_LETTER_ETA_WITH_PERISPOMENI_AND_YPOGEGRAMMENI	0x1FC7
#define T_UTF_16_GREEK_CAPITAL_LETTER_EPSILON_WITH_VARIA	0x1FC8
#define T_UTF_16_GREEK_CAPITAL_LETTER_EPSILON_WITH_OXIA	0x1FC9
#define T_UTF_16_GREEK_CAPITAL_LETTER_ETA_WITH_VARIA	0x1FCA
#define T_UTF_16_GREEK_CAPITAL_LETTER_ETA_WITH_OXIA	0x1FCB
#define T_UTF_16_GREEK_CAPITAL_LETTER_ETA_WITH_PROSGEGRAMMENI	0x1FCC
#define T_UTF_16_GREEK_PSILI_AND_VARIA	0x1FCD
#define T_UTF_16_GREEK_PSILI_AND_OXIA	0x1FCE
#define T_UTF_16_GREEK_PSILI_AND_PERISPOMENI	0x1FCF
#define T_UTF_16_GREEK_SMALL_LETTER_IOTA_WITH_VRACHY	0x1FD0
#define T_UTF_16_GREEK_SMALL_LETTER_IOTA_WITH_MACRON	0x1FD1
#define T_UTF_16_GREEK_SMALL_LETTER_IOTA_WITH_DIALYTIKA_AND_VARIA	0x1FD2
#define T_UTF_16_GREEK_SMALL_LETTER_IOTA_WITH_DIALYTIKA_AND_OXIA	0x1FD3
#define T_UTF_16_GREEK_SMALL_LETTER_IOTA_WITH_PERISPOMENI	0x1FD6
#define T_UTF_16_GREEK_SMALL_LETTER_IOTA_WITH_DIALYTIKA_AND_PERISPOMENI	0x1FD7
#define T_UTF_16_GREEK_CAPITAL_LETTER_IOTA_WITH_VRACHY	0x1FD8
#define T_UTF_16_GREEK_CAPITAL_LETTER_IOTA_WITH_MACRON	0x1FD9
#define T_UTF_16_GREEK_CAPITAL_LETTER_IOTA_WITH_VARIA	0x1FDA
#define T_UTF_16_GREEK_CAPITAL_LETTER_IOTA_WITH_OXIA	0x1FDB
#define T_UTF_16_GREEK_DASIA_AND_VARIA	0x1FDD
#define T_UTF_16_GREEK_DASIA_AND_OXIA	0x1FDE
#define T_UTF_16_GREEK_DASIA_AND_PERISPOMENI	0x1FDF
#define T_UTF_16_GREEK_SMALL_LETTER_UPSILON_WITH_VRACHY	0x1FE0
#define T_UTF_16_GREEK_SMALL_LETTER_UPSILON_WITH_MACRON	0x1FE1
#define T_UTF_16_GREEK_SMALL_LETTER_UPSILON_WITH_DIALYTIKA_AND_VARIA	0x1FE2
#define T_UTF_16_GREEK_SMALL_LETTER_UPSILON_WITH_DIALYTIKA_AND_OXIA	0x1FE3
#define T_UTF_16_GREEK_SMALL_LETTER_RHO_WITH_PSILI	0x1FE4
#define T_UTF_16_GREEK_SMALL_LETTER_RHO_WITH_DASIA	0x1FE5
#define T_UTF_16_GREEK_SMALL_LETTER_UPSILON_WITH_PERISPOMENI	0x1FE6
#define T_UTF_16_GREEK_SMALL_LETTER_UPSILON_WITH_DIALYTIKA_AND_PERISPOMENI	0x1FE7
#define T_UTF_16_GREEK_CAPITAL_LETTER_UPSILON_WITH_VRACHY	0x1FE8
#define T_UTF_16_GREEK_CAPITAL_LETTER_UPSILON_WITH_MACRON	0x1FE9
#define T_UTF_16_GREEK_CAPITAL_LETTER_UPSILON_WITH_VARIA	0x1FEA
#define T_UTF_16_GREEK_CAPITAL_LETTER_UPSILON_WITH_OXIA	0x1FEB
#define T_UTF_16_GREEK_CAPITAL_LETTER_RHO_WITH_DASIA	0x1FEC
#define T_UTF_16_GREEK_DIALYTIKA_AND_VARIA	0x1FED
#define T_UTF_16_GREEK_DIALYTIKA_AND_OXIA	0x1FEE
#define T_UTF_16_GREEK_VARIA	0x1FEF
#define T_UTF_16_GREEK_SMALL_LETTER_OMEGA_WITH_VARIA_AND_YPOGEGRAMMENI	0x1FF2
#define T_UTF_16_GREEK_SMALL_LETTER_OMEGA_WITH_YPOGEGRAMMENI	0x1FF3
#define T_UTF_16_GREEK_SMALL_LETTER_OMEGA_WITH_OXIA_AND_YPOGEGRAMMENI	0x1FF4
#define T_UTF_16_GREEK_SMALL_LETTER_OMEGA_WITH_PERISPOMENI	0x1FF6
#define T_UTF_16_GREEK_SMALL_LETTER_OMEGA_WITH_PERISPOMENI_AND_YPOGEGRAMMENI	0x1FF7
#define T_UTF_16_GREEK_CAPITAL_LETTER_OMICRON_WITH_VARIA	0x1FF8
#define T_UTF_16_GREEK_CAPITAL_LETTER_OMICRON_WITH_OXIA	0x1FF9
#define T_UTF_16_GREEK_CAPITAL_LETTER_OMEGA_WITH_VARIA	0x1FFA
#define T_UTF_16_GREEK_CAPITAL_LETTER_OMEGA_WITH_OXIA	0x1FFB
#define T_UTF_16_GREEK_CAPITAL_LETTER_OMEGA_WITH_PROSGEGRAMMENI	0x1FFC
#define T_UTF_16_GREEK_OXIA	0x1FFD
#define T_UTF_16_GREEK_DASIA	0x1FFE
#define T_UTF_16_EN_QUAD	0x2000
#define T_UTF_16_EM_QUAD	0x2001
#define T_UTF_16_EN_SPACE	0x2002
#define T_UTF_16_EM_SPACE	0x2003
#define T_UTF_16_THREE_PER_EM_SPACE	0x2004
#define T_UTF_16_FOUR_PER_EM_SPACE	0x2005
#define T_UTF_16_SIX_PER_EM_SPACE	0x2006
#define T_UTF_16_FIGURE_SPACE	0x2007
#define T_UTF_16_PUNCTUATION_SPACE	0x2008
#define T_UTF_16_THIN_SPACE	0x2009
#define T_UTF_16_HAIR_SPACE	0x200A
#define T_UTF_16_ZERO_WIDTH_SPACE	0x200B
#define T_UTF_16_ZERO_WIDTH_NON_JOINER	0x200C
#define T_UTF_16_ZERO_WIDTH_JOINER	0x200D
#define T_UTF_16_LEFT_TO_RIGHT_MARK	0x200E
#define T_UTF_16_RIGHT_TO_LEFT_MARK	0x200F
#define T_UTF_16_HYPHEN	0x2010
#define T_UTF_16_NON_BREAKING_HYPHEN	0x2011
#define T_UTF_16_FIGURE_DASH	0x2012
#define T_UTF_16_EN_DASH	0x2013
#define T_UTF_16_EM_DASH	0x2014
#define T_UTF_16_HORIZONTAL_BAR	0x2015
#define T_UTF_16_DOUBLE_VERTICAL_LINE	0x2016
#define T_UTF_16_DOUBLE_LOW_LINE	0x2017
#define T_UTF_16_LEFT_SINGLE_QUOTATION_MARK	0x2018
#define T_UTF_16_RIGHT_SINGLE_QUOTATION_MARK	0x2019
#define T_UTF_16_SINGLE_LOW_9_QUOTATION_MARK	0x201A
#define T_UTF_16_SINGLE_HIGH_REVERSED_9_QUOTATION_MARK	0x201B
#define T_UTF_16_LEFT_DOUBLE_QUOTATION_MARK	0x201C
#define T_UTF_16_RIGHT_DOUBLE_QUOTATION_MARK	0x201D
#define T_UTF_16_DOUBLE_LOW_9_QUOTATION_MARK	0x201E
#define T_UTF_16_DOUBLE_HIGH_REVERSED_9_QUOTATION_MARK	0x201F
#define T_UTF_16_DAGGER	0x2020
#define T_UTF_16_DOUBLE_DAGGER	0x2021
#define T_UTF_16_BULLET	0x2022
#define T_UTF_16_TRIANGULAR_BULLET	0x2023
#define T_UTF_16_ONE_DOT_LEADER	0x2024
#define T_UTF_16_TWO_DOT_LEADER	0x2025
#define T_UTF_16_HORIZONTAL_ELLIPSIS	0x2026
#define T_UTF_16_HYPHENATION_POINT	0x2027
#define T_UTF_16_LINE_SEPARATOR	0x2028
#define T_UTF_16_PARAGRAPH_SEPARATOR	0x2029
#define T_UTF_16_LEFT_TO_RIGHT_EMBEDDING	0x202A
#define T_UTF_16_RIGHT_TO_LEFT_EMBEDDING	0x202B
#define T_UTF_16_POP_DIRECTIONAL_FORMATTING	0x202C
#define T_UTF_16_LEFT_TO_RIGHT_OVERRIDE	0x202D
#define T_UTF_16_RIGHT_TO_LEFT_OVERRIDE	0x202E
#define T_UTF_16_NARROW_NO_BREAK_SPACE	0x202F
#define T_UTF_16_PER_MILLE_SIGN	0x2030
#define T_UTF_16_PER_TEN_THOUSAND_SIGN	0x2031
#define T_UTF_16_PRIME	0x2032
#define T_UTF_16_DOUBLE_PRIME	0x2033
#define T_UTF_16_TRIPLE_PRIME	0x2034
#define T_UTF_16_REVERSED_PRIME	0x2035
#define T_UTF_16_REVERSED_DOUBLE_PRIME	0x2036
#define T_UTF_16_REVERSED_TRIPLE_PRIME	0x2037
#define T_UTF_16_CARET	0x2038
#define T_UTF_16_SINGLE_LEFT_POINTING_ANGLE_QUOTATION_MARK	0x2039
#define T_UTF_16_SINGLE_RIGHT_POINTING_ANGLE_QUOTATION_MARK	0x203A
#define T_UTF_16_REFERENCE_MARK	0x203B
#define T_UTF_16_DOUBLE_EXCLAMATION_MARK	0x203C
#define T_UTF_16_INTERROBANG	0x203D
#define T_UTF_16_OVERLINE	0x203E
#define T_UTF_16_UNDERTIE	0x203F
#define T_UTF_16_CHARACTER_TIE	0x2040
#define T_UTF_16_CARET_INSERTION_POINT	0x2041
#define T_UTF_16_ASTERISM	0x2042
#define T_UTF_16_HYPHEN_BULLET	0x2043
#define T_UTF_16_FRACTION_SLASH	0x2044
#define T_UTF_16_LEFT_SQUARE_BRACKET_WITH_QUILL	0x2045
#define T_UTF_16_RIGHT_SQUARE_BRACKET_WITH_QUILL	0x2046
#define T_UTF_16_QUESTION_EXCLAMATION_MARK	0x2048
#define T_UTF_16_EXCLAMATION_QUESTION_MARK	0x2049
#define T_UTF_16_TIRONIAN_SIGN_ET	0x204A
#define T_UTF_16_REVERSED_PILCROW_SIGN	0x204B
#define T_UTF_16_BLACK_LEFTWARDS_BULLET	0x204C
#define T_UTF_16_BLACK_RIGHTWARDS_BULLET	0x204D
#define T_UTF_16_INHIBIT_SYMMETRIC_SWAPPING	0x206A
#define T_UTF_16_ACTIVATE_SYMMETRIC_SWAPPING	0x206B
#define T_UTF_16_INHIBIT_ARABIC_FORM_SHAPING	0x206C
#define T_UTF_16_ACTIVATE_ARABIC_FORM_SHAPING	0x206D
#define T_UTF_16_NATIONAL_DIGIT_SHAPES	0x206E
#define T_UTF_16_NOMINAL_DIGIT_SHAPES	0x206F
#define T_UTF_16_SUPERSCRIPT_ZERO	0x2070
#define T_UTF_16_SUPERSCRIPT_FOUR	0x2074
#define T_UTF_16_SUPERSCRIPT_FIVE	0x2075
#define T_UTF_16_SUPERSCRIPT_SIX	0x2076
#define T_UTF_16_SUPERSCRIPT_SEVEN	0x2077
#define T_UTF_16_SUPERSCRIPT_EIGHT	0x2078
#define T_UTF_16_SUPERSCRIPT_NINE	0x2079
#define T_UTF_16_SUPERSCRIPT_PLUS_SIGN	0x207A
#define T_UTF_16_SUPERSCRIPT_MINUS	0x207B
#define T_UTF_16_SUPERSCRIPT_EQUALS_SIGN	0x207C
#define T_UTF_16_SUPERSCRIPT_LEFT_PARENTHESIS	0x207D
#define T_UTF_16_SUPERSCRIPT_RIGHT_PARENTHESIS	0x207E
#define T_UTF_16_SUPERSCRIPT_LATIN_SMALL_LETTER_N	0x207F
#define T_UTF_16_SUBSCRIPT_ZERO	0x2080
#define T_UTF_16_SUBSCRIPT_ONE	0x2081
#define T_UTF_16_SUBSCRIPT_TWO	0x2082
#define T_UTF_16_SUBSCRIPT_THREE	0x2083
#define T_UTF_16_SUBSCRIPT_FOUR	0x2084
#define T_UTF_16_SUBSCRIPT_FIVE	0x2085
#define T_UTF_16_SUBSCRIPT_SIX	0x2086
#define T_UTF_16_SUBSCRIPT_SEVEN	0x2087
#define T_UTF_16_SUBSCRIPT_EIGHT	0x2088
#define T_UTF_16_SUBSCRIPT_NINE	0x2089
#define T_UTF_16_SUBSCRIPT_PLUS_SIGN	0x208A
#define T_UTF_16_SUBSCRIPT_MINUS	0x208B
#define T_UTF_16_SUBSCRIPT_EQUALS_SIGN	0x208C
#define T_UTF_16_SUBSCRIPT_LEFT_PARENTHESIS	0x208D
#define T_UTF_16_SUBSCRIPT_RIGHT_PARENTHESIS	0x208E
#define T_UTF_16_EURO_CURRENCY_SIGN	0x20A0
#define T_UTF_16_COLON_SIGN	0x20A1
#define T_UTF_16_CRUZEIRO_SIGN	0x20A2
#define T_UTF_16_FRENCH_FRANC_SIGN	0x20A3
#define T_UTF_16_LIRA_SIGN	0x20A4
#define T_UTF_16_MILL_SIGN	0x20A5
#define T_UTF_16_NAIRA_SIGN	0x20A6
#define T_UTF_16_PESETA_SIGN	0x20A7
#define T_UTF_16_RUPEE_SIGN	0x20A8
#define T_UTF_16_WON_SIGN	0x20A9
#define T_UTF_16_NEW_SHEQEL_SIGN	0x20AA
#define T_UTF_16_DONG_SIGN	0x20AB
#define T_UTF_16_EURO_SIGN	0x20AC
#define T_UTF_16_KIP_SIGN	0x20AD
#define T_UTF_16_TUGRIK_SIGN	0x20AE
#define T_UTF_16_DRACHMA_SIGN	0x20AF
#define T_UTF_16_COMBINING_LEFT_HARPOON_ABOVE	0x20D0
#define T_UTF_16_COMBINING_RIGHT_HARPOON_ABOVE	0x20D1
#define T_UTF_16_COMBINING_LONG_VERTICAL_LINE_OVERLAY	0x20D2
#define T_UTF_16_COMBINING_SHORT_VERTICAL_LINE_OVERLAY	0x20D3
#define T_UTF_16_COMBINING_ANTICLOCKWISE_ARROW_ABOVE	0x20D4
#define T_UTF_16_COMBINING_CLOCKWISE_ARROW_ABOVE	0x20D5
#define T_UTF_16_COMBINING_LEFT_ARROW_ABOVE	0x20D6
#define T_UTF_16_COMBINING_RIGHT_ARROW_ABOVE	0x20D7
#define T_UTF_16_COMBINING_RING_OVERLAY	0x20D8
#define T_UTF_16_COMBINING_CLOCKWISE_RING_OVERLAY	0x20D9
#define T_UTF_16_COMBINING_ANTICLOCKWISE_RING_OVERLAY	0x20DA
#define T_UTF_16_COMBINING_THREE_DOTS_ABOVE	0x20DB
#define T_UTF_16_COMBINING_FOUR_DOTS_ABOVE	0x20DC
#define T_UTF_16_COMBINING_ENCLOSING_CIRCLE	0x20DD
#define T_UTF_16_COMBINING_ENCLOSING_SQUARE	0x20DE
#define T_UTF_16_COMBINING_ENCLOSING_DIAMOND	0x20DF
#define T_UTF_16_COMBINING_ENCLOSING_CIRCLE_BACKSLASH	0x20E0
#define T_UTF_16_COMBINING_LEFT_RIGHT_ARROW_ABOVE	0x20E1
#define T_UTF_16_COMBINING_ENCLOSING_SCREEN	0x20E2
#define T_UTF_16_COMBINING_ENCLOSING_KEYCAP	0x20E3
#define T_UTF_16_ACCOUNT_OF	0x2100
#define T_UTF_16_ADDRESSED_TO_THE_SUBJECT	0x2101
#define T_UTF_16_DOUBLE_STRUCK_CAPITAL_C	0x2102
#define T_UTF_16_DEGREE_CELSIUS	0x2103
#define T_UTF_16_CENTRE_LINE_SYMBOL	0x2104
#define T_UTF_16_CARE_OF	0x2105
#define T_UTF_16_CADA_UNA	0x2106
#define T_UTF_16_EULER_CONSTANT	0x2107
#define T_UTF_16_SCRUPLE	0x2108
#define T_UTF_16_DEGREE_FAHRENHEIT	0x2109
#define T_UTF_16_SCRIPT_SMALL_G	0x210A
#define T_UTF_16_SCRIPT_CAPITAL_H	0x210B
#define T_UTF_16_BLACK_LETTER_CAPITAL_H	0x210C
#define T_UTF_16_DOUBLE_STRUCK_CAPITAL_H	0x210D
#define T_UTF_16_PLANCK_CONSTANT	0x210E
#define T_UTF_16_PLANCK_CONSTANT_OVER_TWO_PI	0x210F
#define T_UTF_16_SCRIPT_CAPITAL_I	0x2110
#define T_UTF_16_BLACK_LETTER_CAPITAL_I	0x2111
#define T_UTF_16_SCRIPT_CAPITAL_L	0x2112
#define T_UTF_16_SCRIPT_SMALL_L	0x2113
#define T_UTF_16_L_B_BAR_SYMBOL	0x2114
#define T_UTF_16_DOUBLE_STRUCK_CAPITAL_N	0x2115
#define T_UTF_16_NUMERO_SIGN	0x2116
#define T_UTF_16_SOUND_RECORDING_COPYRIGHT	0x2117
#define T_UTF_16_SCRIPT_CAPITAL_P	0x2118
#define T_UTF_16_DOUBLE_STRUCK_CAPITAL_P	0x2119
#define T_UTF_16_DOUBLE_STRUCK_CAPITAL_Q	0x211A
#define T_UTF_16_SCRIPT_CAPITAL_R	0x211B
#define T_UTF_16_BLACK_LETTER_CAPITAL_R	0x211C
#define T_UTF_16_DOUBLE_STRUCK_CAPITAL_R	0x211D
#define T_UTF_16_PRESCRIPTION_TAKE	0x211E
#define T_UTF_16_RESPONSE	0x211F
#define T_UTF_16_SERVICE_MARK	0x2120
#define T_UTF_16_TELEPHONE_SIGN	0x2121
#define T_UTF_16_TRADE_MARK_SIGN	0x2122
#define T_UTF_16_VERSICLE	0x2123
#define T_UTF_16_DOUBLE_STRUCK_CAPITAL_Z	0x2124
#define T_UTF_16_OUNCE_SIGN	0x2125
#define T_UTF_16_OHM_SIGN	0x2126
#define T_UTF_16_INVERTED_OHM_SIGN	0x2127
#define T_UTF_16_BLACK_LETTER_CAPITAL_Z	0x2128
#define T_UTF_16_TURNED_GREEK_SMALL_LETTER_IOTA	0x2129
#define T_UTF_16_KELVIN_SIGN	0x212A
#define T_UTF_16_ANGSTROM_SIGN	0x212B
#define T_UTF_16_SCRIPT_CAPITAL_B	0x212C
#define T_UTF_16_BLACK_LETTER_CAPITAL_C	0x212D
#define T_UTF_16_ESTIMATED_SYMBOL	0x212E
#define T_UTF_16_SCRIPT_SMALL_E	0x212F
#define T_UTF_16_SCRIPT_CAPITAL_E	0x2130
#define T_UTF_16_SCRIPT_CAPITAL_F	0x2131
#define T_UTF_16_TURNED_CAPITAL_F	0x2132
#define T_UTF_16_SCRIPT_CAPITAL_M	0x2133
#define T_UTF_16_SCRIPT_SMALL_O	0x2134
#define T_UTF_16_ALEF_SYMBOL	0x2135
#define T_UTF_16_BET_SYMBOL	0x2136
#define T_UTF_16_GIMEL_SYMBOL	0x2137
#define T_UTF_16_DALET_SYMBOL	0x2138
#define T_UTF_16_INFORMATION_SOURCE	0x2139
#define T_UTF_16_ROTATED_CAPITAL_Q	0x213A
#define T_UTF_16_VULGAR_FRACTION_ONE_THIRD	0x2153
#define T_UTF_16_VULGAR_FRACTION_TWO_THIRDS	0x2154
#define T_UTF_16_VULGAR_FRACTION_ONE_FIFTH	0x2155
#define T_UTF_16_VULGAR_FRACTION_TWO_FIFTHS	0x2156
#define T_UTF_16_VULGAR_FRACTION_THREE_FIFTHS	0x2157
#define T_UTF_16_VULGAR_FRACTION_FOUR_FIFTHS	0x2158
#define T_UTF_16_VULGAR_FRACTION_ONE_SIXTH	0x2159
#define T_UTF_16_VULGAR_FRACTION_FIVE_SIXTHS	0x215A
#define T_UTF_16_VULGAR_FRACTION_ONE_EIGHTH	0x215B
#define T_UTF_16_VULGAR_FRACTION_THREE_EIGHTHS	0x215C
#define T_UTF_16_VULGAR_FRACTION_FIVE_EIGHTHS	0x215D
#define T_UTF_16_VULGAR_FRACTION_SEVEN_EIGHTHS	0x215E
#define T_UTF_16_FRACTION_NUMERATOR_ONE	0x215F
#define T_UTF_16_ROMAN_NUMERAL_ONE	0x2160
#define T_UTF_16_ROMAN_NUMERAL_TWO	0x2161
#define T_UTF_16_ROMAN_NUMERAL_THREE	0x2162
#define T_UTF_16_ROMAN_NUMERAL_FOUR	0x2163
#define T_UTF_16_ROMAN_NUMERAL_FIVE	0x2164
#define T_UTF_16_ROMAN_NUMERAL_SIX	0x2165
#define T_UTF_16_ROMAN_NUMERAL_SEVEN	0x2166
#define T_UTF_16_ROMAN_NUMERAL_EIGHT	0x2167
#define T_UTF_16_ROMAN_NUMERAL_NINE	0x2168
#define T_UTF_16_ROMAN_NUMERAL_TEN	0x2169
#define T_UTF_16_ROMAN_NUMERAL_ELEVEN	0x216A
#define T_UTF_16_ROMAN_NUMERAL_TWELVE	0x216B
#define T_UTF_16_ROMAN_NUMERAL_FIFTY	0x216C
#define T_UTF_16_ROMAN_NUMERAL_ONE_HUNDRED	0x216D
#define T_UTF_16_ROMAN_NUMERAL_FIVE_HUNDRED	0x216E
#define T_UTF_16_ROMAN_NUMERAL_ONE_THOUSAND	0x216F
#define T_UTF_16_SMALL_ROMAN_NUMERAL_ONE	0x2170
#define T_UTF_16_SMALL_ROMAN_NUMERAL_TWO	0x2171
#define T_UTF_16_SMALL_ROMAN_NUMERAL_THREE	0x2172
#define T_UTF_16_SMALL_ROMAN_NUMERAL_FOUR	0x2173
#define T_UTF_16_SMALL_ROMAN_NUMERAL_FIVE	0x2174
#define T_UTF_16_SMALL_ROMAN_NUMERAL_SIX	0x2175
#define T_UTF_16_SMALL_ROMAN_NUMERAL_SEVEN	0x2176
#define T_UTF_16_SMALL_ROMAN_NUMERAL_EIGHT	0x2177
#define T_UTF_16_SMALL_ROMAN_NUMERAL_NINE	0x2178
#define T_UTF_16_SMALL_ROMAN_NUMERAL_TEN	0x2179
#define T_UTF_16_SMALL_ROMAN_NUMERAL_ELEVEN	0x217A
#define T_UTF_16_SMALL_ROMAN_NUMERAL_TWELVE	0x217B
#define T_UTF_16_SMALL_ROMAN_NUMERAL_FIFTY	0x217C
#define T_UTF_16_SMALL_ROMAN_NUMERAL_ONE_HUNDRED	0x217D
#define T_UTF_16_SMALL_ROMAN_NUMERAL_FIVE_HUNDRED	0x217E
#define T_UTF_16_SMALL_ROMAN_NUMERAL_ONE_THOUSAND	0x217F
#define T_UTF_16_ROMAN_NUMERAL_ONE_THOUSAND_C_D	0x2180
#define T_UTF_16_ROMAN_NUMERAL_FIVE_THOUSAND	0x2181
#define T_UTF_16_ROMAN_NUMERAL_TEN_THOUSAND	0x2182
#define T_UTF_16_ROMAN_NUMERAL_REVERSED_ONE_HUNDRED	0x2183
#define T_UTF_16_LEFTWARDS_ARROW	0x2190
#define T_UTF_16_UPWARDS_ARROW	0x2191
#define T_UTF_16_RIGHTWARDS_ARROW	0x2192
#define T_UTF_16_DOWNWARDS_ARROW	0x2193
#define T_UTF_16_LEFT_RIGHT_ARROW	0x2194
#define T_UTF_16_UP_DOWN_ARROW	0x2195
#define T_UTF_16_NORTH_WEST_ARROW	0x2196
#define T_UTF_16_NORTH_EAST_ARROW	0x2197
#define T_UTF_16_SOUTH_EAST_ARROW	0x2198
#define T_UTF_16_SOUTH_WEST_ARROW	0x2199
#define T_UTF_16_LEFTWARDS_ARROW_WITH_STROKE	0x219A
#define T_UTF_16_RIGHTWARDS_ARROW_WITH_STROKE	0x219B
#define T_UTF_16_LEFTWARDS_WAVE_ARROW	0x219C
#define T_UTF_16_RIGHTWARDS_WAVE_ARROW	0x219D
#define T_UTF_16_LEFTWARDS_TWO_HEADED_ARROW	0x219E
#define T_UTF_16_UPWARDS_TWO_HEADED_ARROW	0x219F
#define T_UTF_16_RIGHTWARDS_TWO_HEADED_ARROW	0x21A0
#define T_UTF_16_DOWNWARDS_TWO_HEADED_ARROW	0x21A1
#define T_UTF_16_LEFTWARDS_ARROW_WITH_TAIL	0x21A2
#define T_UTF_16_RIGHTWARDS_ARROW_WITH_TAIL	0x21A3
#define T_UTF_16_LEFTWARDS_ARROW_FROM_BAR	0x21A4
#define T_UTF_16_UPWARDS_ARROW_FROM_BAR	0x21A5
#define T_UTF_16_RIGHTWARDS_ARROW_FROM_BAR	0x21A6
#define T_UTF_16_DOWNWARDS_ARROW_FROM_BAR	0x21A7
#define T_UTF_16_UP_DOWN_ARROW_WITH_BASE	0x21A8
#define T_UTF_16_LEFTWARDS_ARROW_WITH_HOOK	0x21A9
#define T_UTF_16_RIGHTWARDS_ARROW_WITH_HOOK	0x21AA
#define T_UTF_16_LEFTWARDS_ARROW_WITH_LOOP	0x21AB
#define T_UTF_16_RIGHTWARDS_ARROW_WITH_LOOP	0x21AC
#define T_UTF_16_LEFT_RIGHT_WAVE_ARROW	0x21AD
#define T_UTF_16_LEFT_RIGHT_ARROW_WITH_STROKE	0x21AE
#define T_UTF_16_DOWNWARDS_ZIGZAG_ARROW	0x21AF
#define T_UTF_16_UPWARDS_ARROW_WITH_TIP_LEFTWARDS	0x21B0
#define T_UTF_16_UPWARDS_ARROW_WITH_TIP_RIGHTWARDS	0x21B1
#define T_UTF_16_DOWNWARDS_ARROW_WITH_TIP_LEFTWARDS	0x21B2
#define T_UTF_16_DOWNWARDS_ARROW_WITH_TIP_RIGHTWARDS	0x21B3
#define T_UTF_16_RIGHTWARDS_ARROW_WITH_CORNER_DOWNWARDS	0x21B4
#define T_UTF_16_DOWNWARDS_ARROW_WITH_CORNER_LEFTWARDS	0x21B5
#define T_UTF_16_ANTICLOCKWISE_TOP_SEMICIRCLE_ARROW	0x21B6
#define T_UTF_16_CLOCKWISE_TOP_SEMICIRCLE_ARROW	0x21B7
#define T_UTF_16_NORTH_WEST_ARROW_TO_LONG_BAR	0x21B8
#define T_UTF_16_LEFTWARDS_ARROW_TO_BAR_OVER_RIGHTWARDS_ARROW_TO_BAR	0x21B9
#define T_UTF_16_ANTICLOCKWISE_OPEN_CIRCLE_ARROW	0x21BA
#define T_UTF_16_CLOCKWISE_OPEN_CIRCLE_ARROW	0x21BB
#define T_UTF_16_LEFTWARDS_HARPOON_WITH_BARB_UPWARDS	0x21BC
#define T_UTF_16_LEFTWARDS_HARPOON_WITH_BARB_DOWNWARDS	0x21BD
#define T_UTF_16_UPWARDS_HARPOON_WITH_BARB_RIGHTWARDS	0x21BE
#define T_UTF_16_UPWARDS_HARPOON_WITH_BARB_LEFTWARDS	0x21BF
#define T_UTF_16_RIGHTWARDS_HARPOON_WITH_BARB_UPWARDS	0x21C0
#define T_UTF_16_RIGHTWARDS_HARPOON_WITH_BARB_DOWNWARDS	0x21C1
#define T_UTF_16_DOWNWARDS_HARPOON_WITH_BARB_RIGHTWARDS	0x21C2
#define T_UTF_16_DOWNWARDS_HARPOON_WITH_BARB_LEFTWARDS	0x21C3
#define T_UTF_16_RIGHTWARDS_ARROW_OVER_LEFTWARDS_ARROW	0x21C4
#define T_UTF_16_UPWARDS_ARROW_LEFTWARDS_OF_DOWNWARDS_ARROW	0x21C5
#define T_UTF_16_LEFTWARDS_ARROW_OVER_RIGHTWARDS_ARROW	0x21C6
#define T_UTF_16_LEFTWARDS_PAIRED_ARROWS	0x21C7
#define T_UTF_16_UPWARDS_PAIRED_ARROWS	0x21C8
#define T_UTF_16_RIGHTWARDS_PAIRED_ARROWS	0x21C9
#define T_UTF_16_DOWNWARDS_PAIRED_ARROWS	0x21CA
#define T_UTF_16_LEFTWARDS_HARPOON_OVER_RIGHTWARDS_HARPOON	0x21CB
#define T_UTF_16_RIGHTWARDS_HARPOON_OVER_LEFTWARDS_HARPOON	0x21CC
#define T_UTF_16_LEFTWARDS_DOUBLE_ARROW_WITH_STROKE	0x21CD
#define T_UTF_16_LEFT_RIGHT_DOUBLE_ARROW_WITH_STROKE	0x21CE
#define T_UTF_16_RIGHTWARDS_DOUBLE_ARROW_WITH_STROKE	0x21CF
#define T_UTF_16_LEFTWARDS_DOUBLE_ARROW	0x21D0
#define T_UTF_16_UPWARDS_DOUBLE_ARROW	0x21D1
#define T_UTF_16_RIGHTWARDS_DOUBLE_ARROW	0x21D2
#define T_UTF_16_DOWNWARDS_DOUBLE_ARROW	0x21D3
#define T_UTF_16_LEFT_RIGHT_DOUBLE_ARROW	0x21D4
#define T_UTF_16_UP_DOWN_DOUBLE_ARROW	0x21D5
#define T_UTF_16_NORTH_WEST_DOUBLE_ARROW	0x21D6
#define T_UTF_16_NORTH_EAST_DOUBLE_ARROW	0x21D7
#define T_UTF_16_SOUTH_EAST_DOUBLE_ARROW	0x21D8
#define T_UTF_16_SOUTH_WEST_DOUBLE_ARROW	0x21D9
#define T_UTF_16_LEFTWARDS_TRIPLE_ARROW	0x21DA
#define T_UTF_16_RIGHTWARDS_TRIPLE_ARROW	0x21DB
#define T_UTF_16_LEFTWARDS_SQUIGGLE_ARROW	0x21DC
#define T_UTF_16_RIGHTWARDS_SQUIGGLE_ARROW	0x21DD
#define T_UTF_16_UPWARDS_ARROW_WITH_DOUBLE_STROKE	0x21DE
#define T_UTF_16_DOWNWARDS_ARROW_WITH_DOUBLE_STROKE	0x21DF
#define T_UTF_16_LEFTWARDS_DASHED_ARROW	0x21E0
#define T_UTF_16_UPWARDS_DASHED_ARROW	0x21E1
#define T_UTF_16_RIGHTWARDS_DASHED_ARROW	0x21E2
#define T_UTF_16_DOWNWARDS_DASHED_ARROW	0x21E3
#define T_UTF_16_LEFTWARDS_ARROW_TO_BAR	0x21E4
#define T_UTF_16_RIGHTWARDS_ARROW_TO_BAR	0x21E5
#define T_UTF_16_LEFTWARDS_WHITE_ARROW	0x21E6
#define T_UTF_16_UPWARDS_WHITE_ARROW	0x21E7
#define T_UTF_16_RIGHTWARDS_WHITE_ARROW	0x21E8
#define T_UTF_16_DOWNWARDS_WHITE_ARROW	0x21E9
#define T_UTF_16_UPWARDS_WHITE_ARROW_FROM_BAR	0x21EA
#define T_UTF_16_UPWARDS_WHITE_ARROW_ON_PEDESTAL	0x21EB
#define T_UTF_16_UPWARDS_WHITE_ARROW_ON_PEDESTAL_WITH_HORIZONTAL_BAR	0x21EC
#define T_UTF_16_UPWARDS_WHITE_ARROW_ON_PEDESTAL_WITH_VERTICAL_BAR	0x21ED
#define T_UTF_16_UPWARDS_WHITE_DOUBLE_ARROW	0x21EE
#define T_UTF_16_UPWARDS_WHITE_DOUBLE_ARROW_ON_PEDESTAL	0x21EF
#define T_UTF_16_RIGHTWARDS_WHITE_ARROW_FROM_WALL	0x21F0
#define T_UTF_16_NORTH_WEST_ARROW_TO_CORNER	0x21F1
#define T_UTF_16_SOUTH_EAST_ARROW_TO_CORNER	0x21F2
#define T_UTF_16_UP_DOWN_WHITE_ARROW	0x21F3
#define T_UTF_16_FOR_ALL	0x2200
#define T_UTF_16_COMPLEMENT	0x2201
#define T_UTF_16_PARTIAL_DIFFERENTIAL	0x2202
#define T_UTF_16_THERE_EXISTS	0x2203
#define T_UTF_16_THERE_DOES_NOT_EXIST	0x2204
#define T_UTF_16_EMPTY_SET	0x2205
#define T_UTF_16_INCREMENT	0x2206
#define T_UTF_16_NABLA	0x2207
#define T_UTF_16_ELEMENT_OF	0x2208
#define T_UTF_16_NOT_AN_ELEMENT_OF	0x2209
#define T_UTF_16_SMALL_ELEMENT_OF	0x220A
#define T_UTF_16_CONTAINS_AS_MEMBER	0x220B
#define T_UTF_16_DOES_NOT_CONTAIN_AS_MEMBER	0x220C
#define T_UTF_16_SMALL_CONTAINS_AS_MEMBER	0x220D
#define T_UTF_16_END_OF_PROOF	0x220E
#define T_UTF_16_N_ARY_PRODUCT	0x220F
#define T_UTF_16_N_ARY_COPRODUCT	0x2210
#define T_UTF_16_N_ARY_SUMMATION	0x2211
#define T_UTF_16_MINUS_SIGN	0x2212
#define T_UTF_16_MINUS_OR_PLUS_SIGN	0x2213
#define T_UTF_16_DOT_PLUS	0x2214
#define T_UTF_16_DIVISION_SLASH	0x2215
#define T_UTF_16_SET_MINUS	0x2216
#define T_UTF_16_ASTERISK_OPERATOR	0x2217
#define T_UTF_16_RING_OPERATOR	0x2218
#define T_UTF_16_BULLET_OPERATOR	0x2219
#define T_UTF_16_SQUARE_ROOT	0x221A
#define T_UTF_16_CUBE_ROOT	0x221B
#define T_UTF_16_FOURTH_ROOT	0x221C
#define T_UTF_16_PROPORTIONAL_TO	0x221D
#define T_UTF_16_INFINITY	0x221E
#define T_UTF_16_RIGHT_ANGLE	0x221F
#define T_UTF_16_ANGLE	0x2220
#define T_UTF_16_MEASURED_ANGLE	0x2221
#define T_UTF_16_SPHERICAL_ANGLE	0x2222
#define T_UTF_16_DIVIDES	0x2223
#define T_UTF_16_DOES_NOT_DIVIDE	0x2224
#define T_UTF_16_PARALLEL_TO	0x2225
#define T_UTF_16_NOT_PARALLEL_TO	0x2226
#define T_UTF_16_LOGICAL_AND	0x2227
#define T_UTF_16_LOGICAL_OR	0x2228
#define T_UTF_16_INTERSECTION	0x2229
#define T_UTF_16_UNION	0x222A
#define T_UTF_16_INTEGRAL	0x222B
#define T_UTF_16_DOUBLE_INTEGRAL	0x222C
#define T_UTF_16_TRIPLE_INTEGRAL	0x222D
#define T_UTF_16_CONTOUR_INTEGRAL	0x222E
#define T_UTF_16_SURFACE_INTEGRAL	0x222F
#define T_UTF_16_VOLUME_INTEGRAL	0x2230
#define T_UTF_16_CLOCKWISE_INTEGRAL	0x2231
#define T_UTF_16_CLOCKWISE_CONTOUR_INTEGRAL	0x2232
#define T_UTF_16_ANTICLOCKWISE_CONTOUR_INTEGRAL	0x2233
#define T_UTF_16_THEREFORE	0x2234
#define T_UTF_16_BECAUSE	0x2235
#define T_UTF_16_RATIO	0x2236
#define T_UTF_16_PROPORTION	0x2237
#define T_UTF_16_DOT_MINUS	0x2238
#define T_UTF_16_EXCESS	0x2239
#define T_UTF_16_GEOMETRIC_PROPORTION	0x223A
#define T_UTF_16_HOMOTHETIC	0x223B
#define T_UTF_16_TILDE_OPERATOR	0x223C
#define T_UTF_16_REVERSED_TILDE	0x223D
#define T_UTF_16_INVERTED_LAZY_S	0x223E
#define T_UTF_16_SINE_WAVE	0x223F
#define T_UTF_16_WREATH_PRODUCT	0x2240
#define T_UTF_16_NOT_TILDE	0x2241
#define T_UTF_16_MINUS_TILDE	0x2242
#define T_UTF_16_ASYMPTOTICALLY_EQUAL_TO	0x2243
#define T_UTF_16_NOT_ASYMPTOTICALLY_EQUAL_TO	0x2244
#define T_UTF_16_APPROXIMATELY_EQUAL_TO	0x2245
#define T_UTF_16_APPROXIMATELY_BUT_NOT_ACTUALLY_EQUAL_TO	0x2246
#define T_UTF_16_NEITHER_APPROXIMATELY_NOR_ACTUALLY_EQUAL_TO	0x2247
#define T_UTF_16_ALMOST_EQUAL_TO	0x2248
#define T_UTF_16_NOT_ALMOST_EQUAL_TO	0x2249
#define T_UTF_16_ALMOST_EQUAL_OR_EQUAL_TO	0x224A
#define T_UTF_16_TRIPLE_TILDE	0x224B
#define T_UTF_16_ALL_EQUAL_TO	0x224C
#define T_UTF_16_EQUIVALENT_TO	0x224D
#define T_UTF_16_GEOMETRICALLY_EQUIVALENT_TO	0x224E
#define T_UTF_16_DIFFERENCE_BETWEEN	0x224F
#define T_UTF_16_APPROACHES_THE_LIMIT	0x2250
#define T_UTF_16_GEOMETRICALLY_EQUAL_TO	0x2251
#define T_UTF_16_APPROXIMATELY_EQUAL_TO_OR_THE_IMAGE_OF	0x2252
#define T_UTF_16_IMAGE_OF_OR_APPROXIMATELY_EQUAL_TO	0x2253
#define T_UTF_16_COLON_EQUALS	0x2254
#define T_UTF_16_EQUALS_COLON	0x2255
#define T_UTF_16_RING_IN_EQUAL_TO	0x2256
#define T_UTF_16_RING_EQUAL_TO	0x2257
#define T_UTF_16_CORRESPONDS_TO	0x2258
#define T_UTF_16_ESTIMATES	0x2259
#define T_UTF_16_EQUIANGULAR_TO	0x225A
#define T_UTF_16_STAR_EQUALS	0x225B
#define T_UTF_16_DELTA_EQUAL_TO	0x225C
#define T_UTF_16_EQUAL_TO_BY_DEFINITION	0x225D
#define T_UTF_16_MEASURED_BY	0x225E
#define T_UTF_16_QUESTIONED_EQUAL_TO	0x225F
#define T_UTF_16_NOT_EQUAL_TO	0x2260
#define T_UTF_16_IDENTICAL_TO	0x2261
#define T_UTF_16_NOT_IDENTICAL_TO	0x2262
#define T_UTF_16_STRICTLY_EQUIVALENT_TO	0x2263
#define T_UTF_16_LESS_THAN_OR_EQUAL_TO	0x2264
#define T_UTF_16_GREATER_THAN_OR_EQUAL_TO	0x2265
#define T_UTF_16_LESS_THAN_OVER_EQUAL_TO	0x2266
#define T_UTF_16_GREATER_THAN_OVER_EQUAL_TO	0x2267
#define T_UTF_16_LESS_THAN_BUT_NOT_EQUAL_TO	0x2268
#define T_UTF_16_GREATER_THAN_BUT_NOT_EQUAL_TO	0x2269
#define T_UTF_16_MUCH_LESS_THAN	0x226A
#define T_UTF_16_MUCH_GREATER_THAN	0x226B
#define T_UTF_16_BETWEEN	0x226C
#define T_UTF_16_NOT_EQUIVALENT_TO	0x226D
#define T_UTF_16_NOT_LESS_THAN	0x226E
#define T_UTF_16_NOT_GREATER_THAN	0x226F
#define T_UTF_16_NEITHER_LESS_THAN_NOR_EQUAL_TO	0x2270
#define T_UTF_16_NEITHER_GREATER_THAN_NOR_EQUAL_TO	0x2271
#define T_UTF_16_LESS_THAN_OR_EQUIVALENT_TO	0x2272
#define T_UTF_16_GREATER_THAN_OR_EQUIVALENT_TO	0x2273
#define T_UTF_16_NEITHER_LESS_THAN_NOR_EQUIVALENT_TO	0x2274
#define T_UTF_16_NEITHER_GREATER_THAN_NOR_EQUIVALENT_TO	0x2275
#define T_UTF_16_LESS_THAN_OR_GREATER_THAN	0x2276
#define T_UTF_16_GREATER_THAN_OR_LESS_THAN	0x2277
#define T_UTF_16_NEITHER_LESS_THAN_NOR_GREATER_THAN	0x2278
#define T_UTF_16_NEITHER_GREATER_THAN_NOR_LESS_THAN	0x2279
#define T_UTF_16_PRECEDES	0x227A
#define T_UTF_16_SUCCEEDS	0x227B
#define T_UTF_16_PRECEDES_OR_EQUAL_TO	0x227C
#define T_UTF_16_SUCCEEDS_OR_EQUAL_TO	0x227D
#define T_UTF_16_PRECEDES_OR_EQUIVALENT_TO	0x227E
#define T_UTF_16_SUCCEEDS_OR_EQUIVALENT_TO	0x227F
#define T_UTF_16_DOES_NOT_PRECEDE	0x2280
#define T_UTF_16_DOES_NOT_SUCCEED	0x2281
#define T_UTF_16_SUBSET_OF	0x2282
#define T_UTF_16_SUPERSET_OF	0x2283
#define T_UTF_16_NOT_A_SUBSET_OF	0x2284
#define T_UTF_16_NOT_A_SUPERSET_OF	0x2285
#define T_UTF_16_SUBSET_OF_OR_EQUAL_TO	0x2286
#define T_UTF_16_SUPERSET_OF_OR_EQUAL_TO	0x2287
#define T_UTF_16_NEITHER_A_SUBSET_OF_NOR_EQUAL_TO	0x2288
#define T_UTF_16_NEITHER_A_SUPERSET_OF_NOR_EQUAL_TO	0x2289
#define T_UTF_16_SUBSET_OF_WITH_NOT_EQUAL_TO	0x228A
#define T_UTF_16_SUPERSET_OF_WITH_NOT_EQUAL_TO	0x228B
#define T_UTF_16_MULTISET	0x228C
#define T_UTF_16_MULTISET_MULTIPLICATION	0x228D
#define T_UTF_16_MULTISET_UNION	0x228E
#define T_UTF_16_SQUARE_IMAGE_OF	0x228F
#define T_UTF_16_SQUARE_ORIGINAL_OF	0x2290
#define T_UTF_16_SQUARE_IMAGE_OF_OR_EQUAL_TO	0x2291
#define T_UTF_16_SQUARE_ORIGINAL_OF_OR_EQUAL_TO	0x2292
#define T_UTF_16_SQUARE_CAP	0x2293
#define T_UTF_16_SQUARE_CUP	0x2294
#define T_UTF_16_CIRCLED_PLUS	0x2295
#define T_UTF_16_CIRCLED_MINUS	0x2296
#define T_UTF_16_CIRCLED_TIMES	0x2297
#define T_UTF_16_CIRCLED_DIVISION_SLASH	0x2298
#define T_UTF_16_CIRCLED_DOT_OPERATOR	0x2299
#define T_UTF_16_CIRCLED_RING_OPERATOR	0x229A
#define T_UTF_16_CIRCLED_ASTERISK_OPERATOR	0x229B
#define T_UTF_16_CIRCLED_EQUALS	0x229C
#define T_UTF_16_CIRCLED_DASH	0x229D
#define T_UTF_16_SQUARED_PLUS	0x229E
#define T_UTF_16_SQUARED_MINUS	0x229F
#define T_UTF_16_SQUARED_TIMES	0x22A0
#define T_UTF_16_SQUARED_DOT_OPERATOR	0x22A1
#define T_UTF_16_RIGHT_TACK	0x22A2
#define T_UTF_16_LEFT_TACK	0x22A3
#define T_UTF_16_DOWN_TACK	0x22A4
#define T_UTF_16_UP_TACK	0x22A5
#define T_UTF_16_ASSERTION	0x22A6
#define T_UTF_16_MODELS	0x22A7
#define T_UTF_16_TRUE	0x22A8
#define T_UTF_16_FORCES	0x22A9
#define T_UTF_16_TRIPLE_VERTICAL_BAR_RIGHT_TURNSTILE	0x22AA
#define T_UTF_16_DOUBLE_VERTICAL_BAR_DOUBLE_RIGHT_TURNSTILE	0x22AB
#define T_UTF_16_DOES_NOT_PROVE	0x22AC
#define T_UTF_16_NOT_TRUE	0x22AD
#define T_UTF_16_DOES_NOT_FORCE	0x22AE
#define T_UTF_16_NEGATED_DOUBLE_VERTICAL_BAR_DOUBLE_RIGHT_TURNSTILE	0x22AF
#define T_UTF_16_PRECEDES_UNDER_RELATION	0x22B0
#define T_UTF_16_SUCCEEDS_UNDER_RELATION	0x22B1
#define T_UTF_16_NORMAL_SUBGROUP_OF	0x22B2
#define T_UTF_16_CONTAINS_AS_NORMAL_SUBGROUP	0x22B3
#define T_UTF_16_NORMAL_SUBGROUP_OF_OR_EQUAL_TO	0x22B4
#define T_UTF_16_CONTAINS_AS_NORMAL_SUBGROUP_OR_EQUAL_TO	0x22B5
#define T_UTF_16_ORIGINAL_OF	0x22B6
#define T_UTF_16_IMAGE_OF	0x22B7
#define T_UTF_16_MULTIMAP	0x22B8
#define T_UTF_16_HERMITIAN_CONJUGATE_MATRIX	0x22B9
#define T_UTF_16_INTERCALATE	0x22BA
#define T_UTF_16_XOR	0x22BB
#define T_UTF_16_NAND	0x22BC
#define T_UTF_16_NOR	0x22BD
#define T_UTF_16_RIGHT_ANGLE_WITH_ARC	0x22BE
#define T_UTF_16_RIGHT_TRIANGLE	0x22BF
#define T_UTF_16_N_ARY_LOGICAL_AND	0x22C0
#define T_UTF_16_N_ARY_LOGICAL_OR	0x22C1
#define T_UTF_16_N_ARY_INTERSECTION	0x22C2
#define T_UTF_16_N_ARY_UNION	0x22C3
#define T_UTF_16_DIAMOND_OPERATOR	0x22C4
#define T_UTF_16_DOT_OPERATOR	0x22C5
#define T_UTF_16_STAR_OPERATOR	0x22C6
#define T_UTF_16_DIVISION_TIMES	0x22C7
#define T_UTF_16_BOWTIE	0x22C8
#define T_UTF_16_LEFT_NORMAL_FACTOR_SEMIDIRECT_PRODUCT	0x22C9
#define T_UTF_16_RIGHT_NORMAL_FACTOR_SEMIDIRECT_PRODUCT	0x22CA
#define T_UTF_16_LEFT_SEMIDIRECT_PRODUCT	0x22CB
#define T_UTF_16_RIGHT_SEMIDIRECT_PRODUCT	0x22CC
#define T_UTF_16_REVERSED_TILDE_EQUALS	0x22CD
#define T_UTF_16_CURLY_LOGICAL_OR	0x22CE
#define T_UTF_16_CURLY_LOGICAL_AND	0x22CF
#define T_UTF_16_DOUBLE_SUBSET	0x22D0
#define T_UTF_16_DOUBLE_SUPERSET	0x22D1
#define T_UTF_16_DOUBLE_INTERSECTION	0x22D2
#define T_UTF_16_DOUBLE_UNION	0x22D3
#define T_UTF_16_PITCHFORK	0x22D4
#define T_UTF_16_EQUAL_AND_PARALLEL_TO	0x22D5
#define T_UTF_16_LESS_THAN_WITH_DOT	0x22D6
#define T_UTF_16_GREATER_THAN_WITH_DOT	0x22D7
#define T_UTF_16_VERY_MUCH_LESS_THAN	0x22D8
#define T_UTF_16_VERY_MUCH_GREATER_THAN	0x22D9
#define T_UTF_16_LESS_THAN_EQUAL_TO_OR_GREATER_THAN	0x22DA
#define T_UTF_16_GREATER_THAN_EQUAL_TO_OR_LESS_THAN	0x22DB
#define T_UTF_16_EQUAL_TO_OR_LESS_THAN	0x22DC
#define T_UTF_16_EQUAL_TO_OR_GREATER_THAN	0x22DD
#define T_UTF_16_EQUAL_TO_OR_PRECEDES	0x22DE
#define T_UTF_16_EQUAL_TO_OR_SUCCEEDS	0x22DF
#define T_UTF_16_DOES_NOT_PRECEDE_OR_EQUAL	0x22E0
#define T_UTF_16_DOES_NOT_SUCCEED_OR_EQUAL	0x22E1
#define T_UTF_16_NOT_SQUARE_IMAGE_OF_OR_EQUAL_TO	0x22E2
#define T_UTF_16_NOT_SQUARE_ORIGINAL_OF_OR_EQUAL_TO	0x22E3
#define T_UTF_16_SQUARE_IMAGE_OF_OR_NOT_EQUAL_TO	0x22E4
#define T_UTF_16_SQUARE_ORIGINAL_OF_OR_NOT_EQUAL_TO	0x22E5
#define T_UTF_16_LESS_THAN_BUT_NOT_EQUIVALENT_TO	0x22E6
#define T_UTF_16_GREATER_THAN_BUT_NOT_EQUIVALENT_TO	0x22E7
#define T_UTF_16_PRECEDES_BUT_NOT_EQUIVALENT_TO	0x22E8
#define T_UTF_16_SUCCEEDS_BUT_NOT_EQUIVALENT_TO	0x22E9
#define T_UTF_16_NOT_NORMAL_SUBGROUP_OF	0x22EA
#define T_UTF_16_DOES_NOT_CONTAIN_AS_NORMAL_SUBGROUP	0x22EB
#define T_UTF_16_NOT_NORMAL_SUBGROUP_OF_OR_EQUAL_TO	0x22EC
#define T_UTF_16_DOES_NOT_CONTAIN_AS_NORMAL_SUBGROUP_OR_EQUAL	0x22ED
#define T_UTF_16_VERTICAL_ELLIPSIS	0x22EE
#define T_UTF_16_MIDLINE_HORIZONTAL_ELLIPSIS	0x22EF
#define T_UTF_16_UP_RIGHT_DIAGONAL_ELLIPSIS	0x22F0
#define T_UTF_16_DOWN_RIGHT_DIAGONAL_ELLIPSIS	0x22F1
#define T_UTF_16_DIAMETER_SIGN	0x2300
#define T_UTF_16_ELECTRIC_ARROW	0x2301
#define T_UTF_16_HOUSE	0x2302
#define T_UTF_16_UP_ARROWHEAD	0x2303
#define T_UTF_16_DOWN_ARROWHEAD	0x2304
#define T_UTF_16_PROJECTIVE	0x2305
#define T_UTF_16_PERSPECTIVE	0x2306
#define T_UTF_16_WAVY_LINE	0x2307
#define T_UTF_16_LEFT_CEILING	0x2308
#define T_UTF_16_RIGHT_CEILING	0x2309
#define T_UTF_16_LEFT_FLOOR	0x230A
#define T_UTF_16_RIGHT_FLOOR	0x230B
#define T_UTF_16_BOTTOM_RIGHT_CROP	0x230C
#define T_UTF_16_BOTTOM_LEFT_CROP	0x230D
#define T_UTF_16_TOP_RIGHT_CROP	0x230E
#define T_UTF_16_TOP_LEFT_CROP	0x230F
#define T_UTF_16_REVERSED_NOT_SIGN	0x2310
#define T_UTF_16_SQUARE_LOZENGE	0x2311
#define T_UTF_16_ARC	0x2312
#define T_UTF_16_SEGMENT	0x2313
#define T_UTF_16_SECTOR	0x2314
#define T_UTF_16_TELEPHONE_RECORDER	0x2315
#define T_UTF_16_POSITION_INDICATOR	0x2316
#define T_UTF_16_VIEWDATA_SQUARE	0x2317
#define T_UTF_16_PLACE_OF_INTEREST_SIGN	0x2318
#define T_UTF_16_TURNED_NOT_SIGN	0x2319
#define T_UTF_16_WATCH	0x231A
#define T_UTF_16_HOURGLASS	0x231B
#define T_UTF_16_TOP_LEFT_CORNER	0x231C
#define T_UTF_16_TOP_RIGHT_CORNER	0x231D
#define T_UTF_16_BOTTOM_LEFT_CORNER	0x231E
#define T_UTF_16_BOTTOM_RIGHT_CORNER	0x231F
#define T_UTF_16_TOP_HALF_INTEGRAL	0x2320
#define T_UTF_16_BOTTOM_HALF_INTEGRAL	0x2321
#define T_UTF_16_FROWN	0x2322
#define T_UTF_16_SMILE	0x2323
#define T_UTF_16_UP_ARROWHEAD_BETWEEN_TWO_HORIZONTAL_BARS	0x2324
#define T_UTF_16_OPTION_KEY	0x2325
#define T_UTF_16_ERASE_TO_THE_RIGHT	0x2326
#define T_UTF_16_X_IN_A_RECTANGLE_BOX	0x2327
#define T_UTF_16_KEYBOARD	0x2328
#define T_UTF_16_LEFT_POINTING_ANGLE_BRACKET	0x2329
#define T_UTF_16_RIGHT_POINTING_ANGLE_BRACKET	0x232A
#define T_UTF_16_ERASE_TO_THE_LEFT	0x232B
#define T_UTF_16_BENZENE_RING	0x232C
#define T_UTF_16_CYLINDRICITY	0x232D
#define T_UTF_16_ALL_AROUND_PROFILE	0x232E
#define T_UTF_16_SYMMETRY	0x232F
#define T_UTF_16_TOTAL_RUNOUT	0x2330
#define T_UTF_16_DIMENSION_ORIGIN	0x2331
#define T_UTF_16_CONICAL_TAPER	0x2332
#define T_UTF_16_SLOPE	0x2333
#define T_UTF_16_COUNTERBORE	0x2334
#define T_UTF_16_COUNTERSINK	0x2335
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_I_BEAM	0x2336
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_SQUISH_QUAD	0x2337
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_QUAD_EQUAL	0x2338
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_QUAD_DIVIDE	0x2339
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_QUAD_DIAMOND	0x233A
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_QUAD_JOT	0x233B
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_QUAD_CIRCLE	0x233C
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_CIRCLE_STILE	0x233D
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_CIRCLE_JOT	0x233E
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_SLASH_BAR	0x233F
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_BACKSLASH_BAR	0x2340
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_QUAD_SLASH	0x2341
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_QUAD_BACKSLASH	0x2342
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_QUAD_LESS_THAN	0x2343
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_QUAD_GREATER_THAN	0x2344
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_LEFTWARDS_VANE	0x2345
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_RIGHTWARDS_VANE	0x2346
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_QUAD_LEFTWARDS_ARROW	0x2347
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_QUAD_RIGHTWARDS_ARROW	0x2348
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_CIRCLE_BACKSLASH	0x2349
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_DOWN_TACK_UNDERBAR	0x234A
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_DELTA_STILE	0x234B
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_QUAD_DOWN_CARET	0x234C
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_QUAD_DELTA	0x234D
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_DOWN_TACK_JOT	0x234E
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_UPWARDS_VANE	0x234F
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_QUAD_UPWARDS_ARROW	0x2350
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_UP_TACK_OVERBAR	0x2351
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_DEL_STILE	0x2352
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_QUAD_UP_CARET	0x2353
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_QUAD_DEL	0x2354
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_UP_TACK_JOT	0x2355
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_DOWNWARDS_VANE	0x2356
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_QUAD_DOWNWARDS_ARROW	0x2357
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_QUOTE_UNDERBAR	0x2358
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_DELTA_UNDERBAR	0x2359
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_DIAMOND_UNDERBAR	0x235A
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_JOT_UNDERBAR	0x235B
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_CIRCLE_UNDERBAR	0x235C
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_UP_SHOE_JOT	0x235D
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_QUOTE_QUAD	0x235E
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_CIRCLE_STAR	0x235F
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_QUAD_COLON	0x2360
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_UP_TACK_DIAERESIS	0x2361
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_DEL_DIAERESIS	0x2362
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_STAR_DIAERESIS	0x2363
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_JOT_DIAERESIS	0x2364
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_CIRCLE_DIAERESIS	0x2365
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_DOWN_SHOE_STILE	0x2366
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_LEFT_SHOE_STILE	0x2367
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_TILDE_DIAERESIS	0x2368
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_GREATER_THAN_DIAERESIS	0x2369
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_COMMA_BAR	0x236A
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_DEL_TILDE	0x236B
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_ZILDE	0x236C
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_STILE_TILDE	0x236D
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_SEMICOLON_UNDERBAR	0x236E
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_QUAD_NOT_EQUAL	0x236F
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_QUAD_QUESTION	0x2370
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_DOWN_CARET_TILDE	0x2371
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_UP_CARET_TILDE	0x2372
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_IOTA	0x2373
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_RHO	0x2374
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_OMEGA	0x2375
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_ALPHA_UNDERBAR	0x2376
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_EPSILON_UNDERBAR	0x2377
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_IOTA_UNDERBAR	0x2378
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_OMEGA_UNDERBAR	0x2379
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_ALPHA	0x237A
#define T_UTF_16_NOT_CHECK_MARK	0x237B
#define T_UTF_16_SHOULDERED_OPEN_BOX	0x237D
#define T_UTF_16_BELL_SYMBOL	0x237E
#define T_UTF_16_VERTICAL_LINE_WITH_MIDDLE_DOT	0x237F
#define T_UTF_16_INSERTION_SYMBOL	0x2380
#define T_UTF_16_CONTINUOUS_UNDERLINE_SYMBOL	0x2381
#define T_UTF_16_DISCONTINUOUS_UNDERLINE_SYMBOL	0x2382
#define T_UTF_16_EMPHASIS_SYMBOL	0x2383
#define T_UTF_16_COMPOSITION_SYMBOL	0x2384
#define T_UTF_16_WHITE_SQUARE_WITH_CENTRE_VERTICAL_LINE	0x2385
#define T_UTF_16_ENTER_SYMBOL	0x2386
#define T_UTF_16_ALTERNATIVE_KEY_SYMBOL	0x2387
#define T_UTF_16_HELM_SYMBOL	0x2388
#define T_UTF_16_CIRCLED_HORIZONTAL_BAR_WITH_NOTCH	0x2389
#define T_UTF_16_CIRCLED_TRIANGLE_DOWN	0x238A
#define T_UTF_16_BROKEN_CIRCLE_WITH_NORTHWEST_ARROW	0x238B
#define T_UTF_16_UNDO_SYMBOL	0x238C
#define T_UTF_16_MONOSTABLE_SYMBOL	0x238D
#define T_UTF_16_HYSTERESIS_SYMBOL	0x238E
#define T_UTF_16_OPEN_CIRCUIT_OUTPUT_H_TYPE_SYMBOL	0x238F
#define T_UTF_16_OPEN_CIRCUIT_OUTPUT_L_TYPE_SYMBOL	0x2390
#define T_UTF_16_PASSIVE_PULL_DOWN_OUTPUT_SYMBOL	0x2391
#define T_UTF_16_PASSIVE_PULL_UP_OUTPUT_SYMBOL	0x2392
#define T_UTF_16_DIRECT_CURRENT_SYMBOL_FORM_TWO	0x2393
#define T_UTF_16_SOFTWARE_FUNCTION_SYMBOL	0x2394
#define T_UTF_16_APL_FUNCTIONAL_SYMBOL_QUAD	0x2395
#define T_UTF_16_DECIMAL_SEPARATOR_KEY_SYMBOL	0x2396
#define T_UTF_16_PREVIOUS_PAGE	0x2397
#define T_UTF_16_NEXT_PAGE	0x2398
#define T_UTF_16_PRINT_SCREEN_SYMBOL	0x2399
#define T_UTF_16_CLEAR_SCREEN_SYMBOL	0x239A
#define T_UTF_16_SYMBOL_FOR_NULL	0x2400
#define T_UTF_16_SYMBOL_FOR_START_OF_HEADING	0x2401
#define T_UTF_16_SYMBOL_FOR_START_OF_TEXT	0x2402
#define T_UTF_16_SYMBOL_FOR_END_OF_TEXT	0x2403
#define T_UTF_16_SYMBOL_FOR_END_OF_TRANSMISSION	0x2404
#define T_UTF_16_SYMBOL_FOR_ENQUIRY	0x2405
#define T_UTF_16_SYMBOL_FOR_ACKNOWLEDGE	0x2406
#define T_UTF_16_SYMBOL_FOR_BELL	0x2407
#define T_UTF_16_SYMBOL_FOR_BACKSPACE	0x2408
#define T_UTF_16_SYMBOL_FOR_HORIZONTAL_TABULATION	0x2409
#define T_UTF_16_SYMBOL_FOR_LINE_FEED	0x240A
#define T_UTF_16_SYMBOL_FOR_VERTICAL_TABULATION	0x240B
#define T_UTF_16_SYMBOL_FOR_FORM_FEED	0x240C
#define T_UTF_16_SYMBOL_FOR_CARRIAGE_RETURN	0x240D
#define T_UTF_16_SYMBOL_FOR_SHIFT_OUT	0x240E
#define T_UTF_16_SYMBOL_FOR_SHIFT_IN	0x240F
#define T_UTF_16_SYMBOL_FOR_DATA_LINK_ESCAPE	0x2410
#define T_UTF_16_SYMBOL_FOR_DEVICE_CONTROL_ONE	0x2411
#define T_UTF_16_SYMBOL_FOR_DEVICE_CONTROL_TWO	0x2412
#define T_UTF_16_SYMBOL_FOR_DEVICE_CONTROL_THREE	0x2413
#define T_UTF_16_SYMBOL_FOR_DEVICE_CONTROL_FOUR	0x2414
#define T_UTF_16_SYMBOL_FOR_NEGATIVE_ACKNOWLEDGE	0x2415
#define T_UTF_16_SYMBOL_FOR_SYNCHRONOUS_IDLE	0x2416
#define T_UTF_16_SYMBOL_FOR_END_OF_TRANSMISSION_BLOCK	0x2417
#define T_UTF_16_SYMBOL_FOR_CANCEL	0x2418
#define T_UTF_16_SYMBOL_FOR_END_OF_MEDIUM	0x2419
#define T_UTF_16_SYMBOL_FOR_SUBSTITUTE	0x241A
#define T_UTF_16_SYMBOL_FOR_ESCAPE	0x241B
#define T_UTF_16_SYMBOL_FOR_FILE_SEPARATOR	0x241C
#define T_UTF_16_SYMBOL_FOR_GROUP_SEPARATOR	0x241D
#define T_UTF_16_SYMBOL_FOR_RECORD_SEPARATOR	0x241E
#define T_UTF_16_SYMBOL_FOR_UNIT_SEPARATOR	0x241F
#define T_UTF_16_SYMBOL_FOR_SPACE	0x2420
#define T_UTF_16_SYMBOL_FOR_DELETE	0x2421
#define T_UTF_16_BLANK_SYMBOL	0x2422
#define T_UTF_16_OPEN_BOX	0x2423
#define T_UTF_16_SYMBOL_FOR_NEWLINE	0x2424
#define T_UTF_16_SYMBOL_FOR_DELETE_FORM_TWO	0x2425
#define T_UTF_16_SYMBOL_FOR_SUBSTITUTE_FORM_TWO	0x2426
#define T_UTF_16_OCR_HOOK	0x2440
#define T_UTF_16_OCR_CHAIR	0x2441
#define T_UTF_16_OCR_FORK	0x2442
#define T_UTF_16_OCR_INVERTED_FORK	0x2443
#define T_UTF_16_OCR_BELT_BUCKLE	0x2444
#define T_UTF_16_OCR_BOW_TIE	0x2445
#define T_UTF_16_OCR_BRANCH_BANK_IDENTIFICATION	0x2446
#define T_UTF_16_OCR_AMOUNT_OF_CHECK	0x2447
#define T_UTF_16_OCR_DASH	0x2448
#define T_UTF_16_OCR_CUSTOMER_ACCOUNT_NUMBER	0x2449
#define T_UTF_16_OCR_DOUBLE_BACKSLASH	0x244A
#define T_UTF_16_CIRCLED_DIGIT_ONE	0x2460
#define T_UTF_16_CIRCLED_DIGIT_TWO	0x2461
#define T_UTF_16_CIRCLED_DIGIT_THREE	0x2462
#define T_UTF_16_CIRCLED_DIGIT_FOUR	0x2463
#define T_UTF_16_CIRCLED_DIGIT_FIVE	0x2464
#define T_UTF_16_CIRCLED_DIGIT_SIX	0x2465
#define T_UTF_16_CIRCLED_DIGIT_SEVEN	0x2466
#define T_UTF_16_CIRCLED_DIGIT_EIGHT	0x2467
#define T_UTF_16_CIRCLED_DIGIT_NINE	0x2468
#define T_UTF_16_CIRCLED_NUMBER_TEN	0x2469
#define T_UTF_16_CIRCLED_NUMBER_ELEVEN	0x246A
#define T_UTF_16_CIRCLED_NUMBER_TWELVE	0x246B
#define T_UTF_16_CIRCLED_NUMBER_THIRTEEN	0x246C
#define T_UTF_16_CIRCLED_NUMBER_FOURTEEN	0x246D
#define T_UTF_16_CIRCLED_NUMBER_FIFTEEN	0x246E
#define T_UTF_16_CIRCLED_NUMBER_SIXTEEN	0x246F
#define T_UTF_16_CIRCLED_NUMBER_SEVENTEEN	0x2470
#define T_UTF_16_CIRCLED_NUMBER_EIGHTEEN	0x2471
#define T_UTF_16_CIRCLED_NUMBER_NINETEEN	0x2472
#define T_UTF_16_CIRCLED_NUMBER_TWENTY	0x2473
#define T_UTF_16_PARENTHESIZED_DIGIT_ONE	0x2474
#define T_UTF_16_PARENTHESIZED_DIGIT_TWO	0x2475
#define T_UTF_16_PARENTHESIZED_DIGIT_THREE	0x2476
#define T_UTF_16_PARENTHESIZED_DIGIT_FOUR	0x2477
#define T_UTF_16_PARENTHESIZED_DIGIT_FIVE	0x2478
#define T_UTF_16_PARENTHESIZED_DIGIT_SIX	0x2479
#define T_UTF_16_PARENTHESIZED_DIGIT_SEVEN	0x247A
#define T_UTF_16_PARENTHESIZED_DIGIT_EIGHT	0x247B
#define T_UTF_16_PARENTHESIZED_DIGIT_NINE	0x247C
#define T_UTF_16_PARENTHESIZED_NUMBER_TEN	0x247D
#define T_UTF_16_PARENTHESIZED_NUMBER_ELEVEN	0x247E
#define T_UTF_16_PARENTHESIZED_NUMBER_TWELVE	0x247F
#define T_UTF_16_PARENTHESIZED_NUMBER_THIRTEEN	0x2480
#define T_UTF_16_PARENTHESIZED_NUMBER_FOURTEEN	0x2481
#define T_UTF_16_PARENTHESIZED_NUMBER_FIFTEEN	0x2482
#define T_UTF_16_PARENTHESIZED_NUMBER_SIXTEEN	0x2483
#define T_UTF_16_PARENTHESIZED_NUMBER_SEVENTEEN	0x2484
#define T_UTF_16_PARENTHESIZED_NUMBER_EIGHTEEN	0x2485
#define T_UTF_16_PARENTHESIZED_NUMBER_NINETEEN	0x2486
#define T_UTF_16_PARENTHESIZED_NUMBER_TWENTY	0x2487
#define T_UTF_16_DIGIT_ONE_FULL_STOP	0x2488
#define T_UTF_16_DIGIT_TWO_FULL_STOP	0x2489
#define T_UTF_16_DIGIT_THREE_FULL_STOP	0x248A
#define T_UTF_16_DIGIT_FOUR_FULL_STOP	0x248B
#define T_UTF_16_DIGIT_FIVE_FULL_STOP	0x248C
#define T_UTF_16_DIGIT_SIX_FULL_STOP	0x248D
#define T_UTF_16_DIGIT_SEVEN_FULL_STOP	0x248E
#define T_UTF_16_DIGIT_EIGHT_FULL_STOP	0x248F
#define T_UTF_16_DIGIT_NINE_FULL_STOP	0x2490
#define T_UTF_16_NUMBER_TEN_FULL_STOP	0x2491
#define T_UTF_16_NUMBER_ELEVEN_FULL_STOP	0x2492
#define T_UTF_16_NUMBER_TWELVE_FULL_STOP	0x2493
#define T_UTF_16_NUMBER_THIRTEEN_FULL_STOP	0x2494
#define T_UTF_16_NUMBER_FOURTEEN_FULL_STOP	0x2495
#define T_UTF_16_NUMBER_FIFTEEN_FULL_STOP	0x2496
#define T_UTF_16_NUMBER_SIXTEEN_FULL_STOP	0x2497
#define T_UTF_16_NUMBER_SEVENTEEN_FULL_STOP	0x2498
#define T_UTF_16_NUMBER_EIGHTEEN_FULL_STOP	0x2499
#define T_UTF_16_NUMBER_NINETEEN_FULL_STOP	0x249A
#define T_UTF_16_NUMBER_TWENTY_FULL_STOP	0x249B
#define T_UTF_16_PARENTHESIZED_LATIN_SMALL_LETTER_A	0x249C
#define T_UTF_16_PARENTHESIZED_LATIN_SMALL_LETTER_B	0x249D
#define T_UTF_16_PARENTHESIZED_LATIN_SMALL_LETTER_C	0x249E
#define T_UTF_16_PARENTHESIZED_LATIN_SMALL_LETTER_D	0x249F
#define T_UTF_16_PARENTHESIZED_LATIN_SMALL_LETTER_E	0x24A0
#define T_UTF_16_PARENTHESIZED_LATIN_SMALL_LETTER_F	0x24A1
#define T_UTF_16_PARENTHESIZED_LATIN_SMALL_LETTER_G	0x24A2
#define T_UTF_16_PARENTHESIZED_LATIN_SMALL_LETTER_H	0x24A3
#define T_UTF_16_PARENTHESIZED_LATIN_SMALL_LETTER_I	0x24A4
#define T_UTF_16_PARENTHESIZED_LATIN_SMALL_LETTER_J	0x24A5
#define T_UTF_16_PARENTHESIZED_LATIN_SMALL_LETTER_K	0x24A6
#define T_UTF_16_PARENTHESIZED_LATIN_SMALL_LETTER_L	0x24A7
#define T_UTF_16_PARENTHESIZED_LATIN_SMALL_LETTER_M	0x24A8
#define T_UTF_16_PARENTHESIZED_LATIN_SMALL_LETTER_N	0x24A9
#define T_UTF_16_PARENTHESIZED_LATIN_SMALL_LETTER_O	0x24AA
#define T_UTF_16_PARENTHESIZED_LATIN_SMALL_LETTER_P	0x24AB
#define T_UTF_16_PARENTHESIZED_LATIN_SMALL_LETTER_Q	0x24AC
#define T_UTF_16_PARENTHESIZED_LATIN_SMALL_LETTER_R	0x24AD
#define T_UTF_16_PARENTHESIZED_LATIN_SMALL_LETTER_S	0x24AE
#define T_UTF_16_PARENTHESIZED_LATIN_SMALL_LETTER_T	0x24AF
#define T_UTF_16_PARENTHESIZED_LATIN_SMALL_LETTER_U	0x24B0
#define T_UTF_16_PARENTHESIZED_LATIN_SMALL_LETTER_V	0x24B1
#define T_UTF_16_PARENTHESIZED_LATIN_SMALL_LETTER_W	0x24B2
#define T_UTF_16_PARENTHESIZED_LATIN_SMALL_LETTER_X	0x24B3
#define T_UTF_16_PARENTHESIZED_LATIN_SMALL_LETTER_Y	0x24B4
#define T_UTF_16_PARENTHESIZED_LATIN_SMALL_LETTER_Z	0x24B5
#define T_UTF_16_CIRCLED_LATIN_CAPITAL_LETTER_A	0x24B6
#define T_UTF_16_CIRCLED_LATIN_CAPITAL_LETTER_B	0x24B7
#define T_UTF_16_CIRCLED_LATIN_CAPITAL_LETTER_C	0x24B8
#define T_UTF_16_CIRCLED_LATIN_CAPITAL_LETTER_D	0x24B9
#define T_UTF_16_CIRCLED_LATIN_CAPITAL_LETTER_E	0x24BA
#define T_UTF_16_CIRCLED_LATIN_CAPITAL_LETTER_F	0x24BB
#define T_UTF_16_CIRCLED_LATIN_CAPITAL_LETTER_G	0x24BC
#define T_UTF_16_CIRCLED_LATIN_CAPITAL_LETTER_H	0x24BD
#define T_UTF_16_CIRCLED_LATIN_CAPITAL_LETTER_I	0x24BE
#define T_UTF_16_CIRCLED_LATIN_CAPITAL_LETTER_J	0x24BF
#define T_UTF_16_CIRCLED_LATIN_CAPITAL_LETTER_K	0x24C0
#define T_UTF_16_CIRCLED_LATIN_CAPITAL_LETTER_L	0x24C1
#define T_UTF_16_CIRCLED_LATIN_CAPITAL_LETTER_M	0x24C2
#define T_UTF_16_CIRCLED_LATIN_CAPITAL_LETTER_N	0x24C3
#define T_UTF_16_CIRCLED_LATIN_CAPITAL_LETTER_O	0x24C4
#define T_UTF_16_CIRCLED_LATIN_CAPITAL_LETTER_P	0x24C5
#define T_UTF_16_CIRCLED_LATIN_CAPITAL_LETTER_Q	0x24C6
#define T_UTF_16_CIRCLED_LATIN_CAPITAL_LETTER_R	0x24C7
#define T_UTF_16_CIRCLED_LATIN_CAPITAL_LETTER_S	0x24C8
#define T_UTF_16_CIRCLED_LATIN_CAPITAL_LETTER_T	0x24C9
#define T_UTF_16_CIRCLED_LATIN_CAPITAL_LETTER_U	0x24CA
#define T_UTF_16_CIRCLED_LATIN_CAPITAL_LETTER_V	0x24CB
#define T_UTF_16_CIRCLED_LATIN_CAPITAL_LETTER_W	0x24CC
#define T_UTF_16_CIRCLED_LATIN_CAPITAL_LETTER_X	0x24CD
#define T_UTF_16_CIRCLED_LATIN_CAPITAL_LETTER_Y	0x24CE
#define T_UTF_16_CIRCLED_LATIN_CAPITAL_LETTER_Z	0x24CF
#define T_UTF_16_CIRCLED_LATIN_SMALL_LETTER_A	0x24D0
#define T_UTF_16_CIRCLED_LATIN_SMALL_LETTER_B	0x24D1
#define T_UTF_16_CIRCLED_LATIN_SMALL_LETTER_C	0x24D2
#define T_UTF_16_CIRCLED_LATIN_SMALL_LETTER_D	0x24D3
#define T_UTF_16_CIRCLED_LATIN_SMALL_LETTER_E	0x24D4
#define T_UTF_16_CIRCLED_LATIN_SMALL_LETTER_F	0x24D5
#define T_UTF_16_CIRCLED_LATIN_SMALL_LETTER_G	0x24D6
#define T_UTF_16_CIRCLED_LATIN_SMALL_LETTER_H	0x24D7
#define T_UTF_16_CIRCLED_LATIN_SMALL_LETTER_I	0x24D8
#define T_UTF_16_CIRCLED_LATIN_SMALL_LETTER_J	0x24D9
#define T_UTF_16_CIRCLED_LATIN_SMALL_LETTER_K	0x24DA
#define T_UTF_16_CIRCLED_LATIN_SMALL_LETTER_L	0x24DB
#define T_UTF_16_CIRCLED_LATIN_SMALL_LETTER_M	0x24DC
#define T_UTF_16_CIRCLED_LATIN_SMALL_LETTER_N	0x24DD
#define T_UTF_16_CIRCLED_LATIN_SMALL_LETTER_O	0x24DE
#define T_UTF_16_CIRCLED_LATIN_SMALL_LETTER_P	0x24DF
#define T_UTF_16_CIRCLED_LATIN_SMALL_LETTER_Q	0x24E0
#define T_UTF_16_CIRCLED_LATIN_SMALL_LETTER_R	0x24E1
#define T_UTF_16_CIRCLED_LATIN_SMALL_LETTER_S	0x24E2
#define T_UTF_16_CIRCLED_LATIN_SMALL_LETTER_T	0x24E3
#define T_UTF_16_CIRCLED_LATIN_SMALL_LETTER_U	0x24E4
#define T_UTF_16_CIRCLED_LATIN_SMALL_LETTER_V	0x24E5
#define T_UTF_16_CIRCLED_LATIN_SMALL_LETTER_W	0x24E6
#define T_UTF_16_CIRCLED_LATIN_SMALL_LETTER_X	0x24E7
#define T_UTF_16_CIRCLED_LATIN_SMALL_LETTER_Y	0x24E8
#define T_UTF_16_CIRCLED_LATIN_SMALL_LETTER_Z	0x24E9
#define T_UTF_16_CIRCLED_DIGIT_ZERO	0x24EA
#define T_UTF_16_BOX_DRAWINGS_LIGHT_HORIZONTAL	0x2500
#define T_UTF_16_BOX_DRAWINGS_HEAVY_HORIZONTAL	0x2501
#define T_UTF_16_BOX_DRAWINGS_LIGHT_VERTICAL	0x2502
#define T_UTF_16_BOX_DRAWINGS_HEAVY_VERTICAL	0x2503
#define T_UTF_16_BOX_DRAWINGS_LIGHT_TRIPLE_DASH_HORIZONTAL	0x2504
#define T_UTF_16_BOX_DRAWINGS_HEAVY_TRIPLE_DASH_HORIZONTAL	0x2505
#define T_UTF_16_BOX_DRAWINGS_LIGHT_TRIPLE_DASH_VERTICAL	0x2506
#define T_UTF_16_BOX_DRAWINGS_HEAVY_TRIPLE_DASH_VERTICAL	0x2507
#define T_UTF_16_BOX_DRAWINGS_LIGHT_QUADRUPLE_DASH_HORIZONTAL	0x2508
#define T_UTF_16_BOX_DRAWINGS_HEAVY_QUADRUPLE_DASH_HORIZONTAL	0x2509
#define T_UTF_16_BOX_DRAWINGS_LIGHT_QUADRUPLE_DASH_VERTICAL	0x250A
#define T_UTF_16_BOX_DRAWINGS_HEAVY_QUADRUPLE_DASH_VERTICAL	0x250B
#define T_UTF_16_BOX_DRAWINGS_LIGHT_DOWN_AND_RIGHT	0x250C
#define T_UTF_16_BOX_DRAWINGS_DOWN_LIGHT_AND_RIGHT_HEAVY	0x250D
#define T_UTF_16_BOX_DRAWINGS_DOWN_HEAVY_AND_RIGHT_LIGHT	0x250E
#define T_UTF_16_BOX_DRAWINGS_HEAVY_DOWN_AND_RIGHT	0x250F
#define T_UTF_16_BOX_DRAWINGS_LIGHT_DOWN_AND_LEFT	0x2510
#define T_UTF_16_BOX_DRAWINGS_DOWN_LIGHT_AND_LEFT_HEAVY	0x2511
#define T_UTF_16_BOX_DRAWINGS_DOWN_HEAVY_AND_LEFT_LIGHT	0x2512
#define T_UTF_16_BOX_DRAWINGS_HEAVY_DOWN_AND_LEFT	0x2513
#define T_UTF_16_BOX_DRAWINGS_LIGHT_UP_AND_RIGHT	0x2514
#define T_UTF_16_BOX_DRAWINGS_UP_LIGHT_AND_RIGHT_HEAVY	0x2515
#define T_UTF_16_BOX_DRAWINGS_UP_HEAVY_AND_RIGHT_LIGHT	0x2516
#define T_UTF_16_BOX_DRAWINGS_HEAVY_UP_AND_RIGHT	0x2517
#define T_UTF_16_BOX_DRAWINGS_LIGHT_UP_AND_LEFT	0x2518
#define T_UTF_16_BOX_DRAWINGS_UP_LIGHT_AND_LEFT_HEAVY	0x2519
#define T_UTF_16_BOX_DRAWINGS_UP_HEAVY_AND_LEFT_LIGHT	0x251A
#define T_UTF_16_BOX_DRAWINGS_HEAVY_UP_AND_LEFT	0x251B
#define T_UTF_16_BOX_DRAWINGS_LIGHT_VERTICAL_AND_RIGHT	0x251C
#define T_UTF_16_BOX_DRAWINGS_VERTICAL_LIGHT_AND_RIGHT_HEAVY	0x251D
#define T_UTF_16_BOX_DRAWINGS_UP_HEAVY_AND_RIGHT_DOWN_LIGHT	0x251E
#define T_UTF_16_BOX_DRAWINGS_DOWN_HEAVY_AND_RIGHT_UP_LIGHT	0x251F
#define T_UTF_16_BOX_DRAWINGS_VERTICAL_HEAVY_AND_RIGHT_LIGHT	0x2520
#define T_UTF_16_BOX_DRAWINGS_DOWN_LIGHT_AND_RIGHT_UP_HEAVY	0x2521
#define T_UTF_16_BOX_DRAWINGS_UP_LIGHT_AND_RIGHT_DOWN_HEAVY	0x2522
#define T_UTF_16_BOX_DRAWINGS_HEAVY_VERTICAL_AND_RIGHT	0x2523
#define T_UTF_16_BOX_DRAWINGS_LIGHT_VERTICAL_AND_LEFT	0x2524
#define T_UTF_16_BOX_DRAWINGS_VERTICAL_LIGHT_AND_LEFT_HEAVY	0x2525
#define T_UTF_16_BOX_DRAWINGS_UP_HEAVY_AND_LEFT_DOWN_LIGHT	0x2526
#define T_UTF_16_BOX_DRAWINGS_DOWN_HEAVY_AND_LEFT_UP_LIGHT	0x2527
#define T_UTF_16_BOX_DRAWINGS_VERTICAL_HEAVY_AND_LEFT_LIGHT	0x2528
#define T_UTF_16_BOX_DRAWINGS_DOWN_LIGHT_AND_LEFT_UP_HEAVY	0x2529
#define T_UTF_16_BOX_DRAWINGS_UP_LIGHT_AND_LEFT_DOWN_HEAVY	0x252A
#define T_UTF_16_BOX_DRAWINGS_HEAVY_VERTICAL_AND_LEFT	0x252B
#define T_UTF_16_BOX_DRAWINGS_LIGHT_DOWN_AND_HORIZONTAL	0x252C
#define T_UTF_16_BOX_DRAWINGS_LEFT_HEAVY_AND_RIGHT_DOWN_LIGHT	0x252D
#define T_UTF_16_BOX_DRAWINGS_RIGHT_HEAVY_AND_LEFT_DOWN_LIGHT	0x252E
#define T_UTF_16_BOX_DRAWINGS_DOWN_LIGHT_AND_HORIZONTAL_HEAVY	0x252F
#define T_UTF_16_BOX_DRAWINGS_DOWN_HEAVY_AND_HORIZONTAL_LIGHT	0x2530
#define T_UTF_16_BOX_DRAWINGS_RIGHT_LIGHT_AND_LEFT_DOWN_HEAVY	0x2531
#define T_UTF_16_BOX_DRAWINGS_LEFT_LIGHT_AND_RIGHT_DOWN_HEAVY	0x2532
#define T_UTF_16_BOX_DRAWINGS_HEAVY_DOWN_AND_HORIZONTAL	0x2533
#define T_UTF_16_BOX_DRAWINGS_LIGHT_UP_AND_HORIZONTAL	0x2534
#define T_UTF_16_BOX_DRAWINGS_LEFT_HEAVY_AND_RIGHT_UP_LIGHT	0x2535
#define T_UTF_16_BOX_DRAWINGS_RIGHT_HEAVY_AND_LEFT_UP_LIGHT	0x2536
#define T_UTF_16_BOX_DRAWINGS_UP_LIGHT_AND_HORIZONTAL_HEAVY	0x2537
#define T_UTF_16_BOX_DRAWINGS_UP_HEAVY_AND_HORIZONTAL_LIGHT	0x2538
#define T_UTF_16_BOX_DRAWINGS_RIGHT_LIGHT_AND_LEFT_UP_HEAVY	0x2539
#define T_UTF_16_BOX_DRAWINGS_LEFT_LIGHT_AND_RIGHT_UP_HEAVY	0x253A
#define T_UTF_16_BOX_DRAWINGS_HEAVY_UP_AND_HORIZONTAL	0x253B
#define T_UTF_16_BOX_DRAWINGS_LIGHT_VERTICAL_AND_HORIZONTAL	0x253C
#define T_UTF_16_BOX_DRAWINGS_LEFT_HEAVY_AND_RIGHT_VERTICAL_LIGHT	0x253D
#define T_UTF_16_BOX_DRAWINGS_RIGHT_HEAVY_AND_LEFT_VERTICAL_LIGHT	0x253E
#define T_UTF_16_BOX_DRAWINGS_VERTICAL_LIGHT_AND_HORIZONTAL_HEAVY	0x253F
#define T_UTF_16_BOX_DRAWINGS_UP_HEAVY_AND_DOWN_HORIZONTAL_LIGHT	0x2540
#define T_UTF_16_BOX_DRAWINGS_DOWN_HEAVY_AND_UP_HORIZONTAL_LIGHT	0x2541
#define T_UTF_16_BOX_DRAWINGS_VERTICAL_HEAVY_AND_HORIZONTAL_LIGHT	0x2542
#define T_UTF_16_BOX_DRAWINGS_LEFT_UP_HEAVY_AND_RIGHT_DOWN_LIGHT	0x2543
#define T_UTF_16_BOX_DRAWINGS_RIGHT_UP_HEAVY_AND_LEFT_DOWN_LIGHT	0x2544
#define T_UTF_16_BOX_DRAWINGS_LEFT_DOWN_HEAVY_AND_RIGHT_UP_LIGHT	0x2545
#define T_UTF_16_BOX_DRAWINGS_RIGHT_DOWN_HEAVY_AND_LEFT_UP_LIGHT	0x2546
#define T_UTF_16_BOX_DRAWINGS_DOWN_LIGHT_AND_UP_HORIZONTAL_HEAVY	0x2547
#define T_UTF_16_BOX_DRAWINGS_UP_LIGHT_AND_DOWN_HORIZONTAL_HEAVY	0x2548
#define T_UTF_16_BOX_DRAWINGS_RIGHT_LIGHT_AND_LEFT_VERTICAL_HEAVY	0x2549
#define T_UTF_16_BOX_DRAWINGS_LEFT_LIGHT_AND_RIGHT_VERTICAL_HEAVY	0x254A
#define T_UTF_16_BOX_DRAWINGS_HEAVY_VERTICAL_AND_HORIZONTAL	0x254B
#define T_UTF_16_BOX_DRAWINGS_LIGHT_DOUBLE_DASH_HORIZONTAL	0x254C
#define T_UTF_16_BOX_DRAWINGS_HEAVY_DOUBLE_DASH_HORIZONTAL	0x254D
#define T_UTF_16_BOX_DRAWINGS_LIGHT_DOUBLE_DASH_VERTICAL	0x254E
#define T_UTF_16_BOX_DRAWINGS_HEAVY_DOUBLE_DASH_VERTICAL	0x254F
#define T_UTF_16_BOX_DRAWINGS_DOUBLE_HORIZONTAL	0x2550
#define T_UTF_16_BOX_DRAWINGS_DOUBLE_VERTICAL	0x2551
#define T_UTF_16_BOX_DRAWINGS_DOWN_SINGLE_AND_RIGHT_DOUBLE	0x2552
#define T_UTF_16_BOX_DRAWINGS_DOWN_DOUBLE_AND_RIGHT_SINGLE	0x2553
#define T_UTF_16_BOX_DRAWINGS_DOUBLE_DOWN_AND_RIGHT	0x2554
#define T_UTF_16_BOX_DRAWINGS_DOWN_SINGLE_AND_LEFT_DOUBLE	0x2555
#define T_UTF_16_BOX_DRAWINGS_DOWN_DOUBLE_AND_LEFT_SINGLE	0x2556
#define T_UTF_16_BOX_DRAWINGS_DOUBLE_DOWN_AND_LEFT	0x2557
#define T_UTF_16_BOX_DRAWINGS_UP_SINGLE_AND_RIGHT_DOUBLE	0x2558
#define T_UTF_16_BOX_DRAWINGS_UP_DOUBLE_AND_RIGHT_SINGLE	0x2559
#define T_UTF_16_BOX_DRAWINGS_DOUBLE_UP_AND_RIGHT	0x255A
#define T_UTF_16_BOX_DRAWINGS_UP_SINGLE_AND_LEFT_DOUBLE	0x255B
#define T_UTF_16_BOX_DRAWINGS_UP_DOUBLE_AND_LEFT_SINGLE	0x255C
#define T_UTF_16_BOX_DRAWINGS_DOUBLE_UP_AND_LEFT	0x255D
#define T_UTF_16_BOX_DRAWINGS_VERTICAL_SINGLE_AND_RIGHT_DOUBLE	0x255E
#define T_UTF_16_BOX_DRAWINGS_VERTICAL_DOUBLE_AND_RIGHT_SINGLE	0x255F
#define T_UTF_16_BOX_DRAWINGS_DOUBLE_VERTICAL_AND_RIGHT	0x2560
#define T_UTF_16_BOX_DRAWINGS_VERTICAL_SINGLE_AND_LEFT_DOUBLE	0x2561
#define T_UTF_16_BOX_DRAWINGS_VERTICAL_DOUBLE_AND_LEFT_SINGLE	0x2562
#define T_UTF_16_BOX_DRAWINGS_DOUBLE_VERTICAL_AND_LEFT	0x2563
#define T_UTF_16_BOX_DRAWINGS_DOWN_SINGLE_AND_HORIZONTAL_DOUBLE	0x2564
#define T_UTF_16_BOX_DRAWINGS_DOWN_DOUBLE_AND_HORIZONTAL_SINGLE	0x2565
#define T_UTF_16_BOX_DRAWINGS_DOUBLE_DOWN_AND_HORIZONTAL	0x2566
#define T_UTF_16_BOX_DRAWINGS_UP_SINGLE_AND_HORIZONTAL_DOUBLE	0x2567
#define T_UTF_16_BOX_DRAWINGS_UP_DOUBLE_AND_HORIZONTAL_SINGLE	0x2568
#define T_UTF_16_BOX_DRAWINGS_DOUBLE_UP_AND_HORIZONTAL	0x2569
#define T_UTF_16_BOX_DRAWINGS_VERTICAL_SINGLE_AND_HORIZONTAL_DOUBLE	0x256A
#define T_UTF_16_BOX_DRAWINGS_VERTICAL_DOUBLE_AND_HORIZONTAL_SINGLE	0x256B
#define T_UTF_16_BOX_DRAWINGS_DOUBLE_VERTICAL_AND_HORIZONTAL	0x256C
#define T_UTF_16_BOX_DRAWINGS_LIGHT_ARC_DOWN_AND_RIGHT	0x256D
#define T_UTF_16_BOX_DRAWINGS_LIGHT_ARC_DOWN_AND_LEFT	0x256E
#define T_UTF_16_BOX_DRAWINGS_LIGHT_ARC_UP_AND_LEFT	0x256F
#define T_UTF_16_BOX_DRAWINGS_LIGHT_ARC_UP_AND_RIGHT	0x2570
#define T_UTF_16_BOX_DRAWINGS_LIGHT_DIAGONAL_UPPER_RIGHT_TO_LOWER_LEFT	0x2571
#define T_UTF_16_BOX_DRAWINGS_LIGHT_DIAGONAL_UPPER_LEFT_TO_LOWER_RIGHT	0x2572
#define T_UTF_16_BOX_DRAWINGS_LIGHT_DIAGONAL_CROSS	0x2573
#define T_UTF_16_BOX_DRAWINGS_LIGHT_LEFT	0x2574
#define T_UTF_16_BOX_DRAWINGS_LIGHT_UP	0x2575
#define T_UTF_16_BOX_DRAWINGS_LIGHT_RIGHT	0x2576
#define T_UTF_16_BOX_DRAWINGS_LIGHT_DOWN	0x2577
#define T_UTF_16_BOX_DRAWINGS_HEAVY_LEFT	0x2578
#define T_UTF_16_BOX_DRAWINGS_HEAVY_UP	0x2579
#define T_UTF_16_BOX_DRAWINGS_HEAVY_RIGHT	0x257A
#define T_UTF_16_BOX_DRAWINGS_HEAVY_DOWN	0x257B
#define T_UTF_16_BOX_DRAWINGS_LIGHT_LEFT_AND_HEAVY_RIGHT	0x257C
#define T_UTF_16_BOX_DRAWINGS_LIGHT_UP_AND_HEAVY_DOWN	0x257D
#define T_UTF_16_BOX_DRAWINGS_HEAVY_LEFT_AND_LIGHT_RIGHT	0x257E
#define T_UTF_16_BOX_DRAWINGS_HEAVY_UP_AND_LIGHT_DOWN	0x257F
#define T_UTF_16_UPPER_HALF_BLOCK	0x2580
#define T_UTF_16_LOWER_ONE_EIGHTH_BLOCK	0x2581
#define T_UTF_16_LOWER_ONE_QUARTER_BLOCK	0x2582
#define T_UTF_16_LOWER_THREE_EIGHTHS_BLOCK	0x2583
#define T_UTF_16_LOWER_HALF_BLOCK	0x2584
#define T_UTF_16_LOWER_FIVE_EIGHTHS_BLOCK	0x2585
#define T_UTF_16_LOWER_THREE_QUARTERS_BLOCK	0x2586
#define T_UTF_16_LOWER_SEVEN_EIGHTHS_BLOCK	0x2587
#define T_UTF_16_FULL_BLOCK	0x2588
#define T_UTF_16_LEFT_SEVEN_EIGHTHS_BLOCK	0x2589
#define T_UTF_16_LEFT_THREE_QUARTERS_BLOCK	0x258A
#define T_UTF_16_LEFT_FIVE_EIGHTHS_BLOCK	0x258B
#define T_UTF_16_LEFT_HALF_BLOCK	0x258C
#define T_UTF_16_LEFT_THREE_EIGHTHS_BLOCK	0x258D
#define T_UTF_16_LEFT_ONE_QUARTER_BLOCK	0x258E
#define T_UTF_16_LEFT_ONE_EIGHTH_BLOCK	0x258F
#define T_UTF_16_RIGHT_HALF_BLOCK	0x2590
#define T_UTF_16_LIGHT_SHADE	0x2591
#define T_UTF_16_MEDIUM_SHADE	0x2592
#define T_UTF_16_DARK_SHADE	0x2593
#define T_UTF_16_UPPER_ONE_EIGHTH_BLOCK	0x2594
#define T_UTF_16_RIGHT_ONE_EIGHTH_BLOCK	0x2595
#define T_UTF_16_BLACK_SQUARE	0x25A0
#define T_UTF_16_WHITE_SQUARE	0x25A1
#define T_UTF_16_WHITE_SQUARE_WITH_ROUNDED_CORNERS	0x25A2
#define T_UTF_16_WHITE_SQUARE_CONTAINING_BLACK_SMALL_SQUARE	0x25A3
#define T_UTF_16_SQUARE_WITH_HORIZONTAL_FILL	0x25A4
#define T_UTF_16_SQUARE_WITH_VERTICAL_FILL	0x25A5
#define T_UTF_16_SQUARE_WITH_ORTHOGONAL_CROSSHATCH_FILL	0x25A6
#define T_UTF_16_SQUARE_WITH_UPPER_LEFT_TO_LOWER_RIGHT_FILL	0x25A7
#define T_UTF_16_SQUARE_WITH_UPPER_RIGHT_TO_LOWER_LEFT_FILL	0x25A8
#define T_UTF_16_SQUARE_WITH_DIAGONAL_CROSSHATCH_FILL	0x25A9
#define T_UTF_16_BLACK_SMALL_SQUARE	0x25AA
#define T_UTF_16_WHITE_SMALL_SQUARE	0x25AB
#define T_UTF_16_BLACK_RECTANGLE	0x25AC
#define T_UTF_16_WHITE_RECTANGLE	0x25AD
#define T_UTF_16_BLACK_VERTICAL_RECTANGLE	0x25AE
#define T_UTF_16_WHITE_VERTICAL_RECTANGLE	0x25AF
#define T_UTF_16_BLACK_PARALLELOGRAM	0x25B0
#define T_UTF_16_WHITE_PARALLELOGRAM	0x25B1
#define T_UTF_16_BLACK_UP_POINTING_TRIANGLE	0x25B2
#define T_UTF_16_WHITE_UP_POINTING_TRIANGLE	0x25B3
#define T_UTF_16_BLACK_UP_POINTING_SMALL_TRIANGLE	0x25B4
#define T_UTF_16_WHITE_UP_POINTING_SMALL_TRIANGLE	0x25B5
#define T_UTF_16_BLACK_RIGHT_POINTING_TRIANGLE	0x25B6
#define T_UTF_16_WHITE_RIGHT_POINTING_TRIANGLE	0x25B7
#define T_UTF_16_BLACK_RIGHT_POINTING_SMALL_TRIANGLE	0x25B8
#define T_UTF_16_WHITE_RIGHT_POINTING_SMALL_TRIANGLE	0x25B9
#define T_UTF_16_BLACK_RIGHT_POINTING_POINTER	0x25BA
#define T_UTF_16_WHITE_RIGHT_POINTING_POINTER	0x25BB
#define T_UTF_16_BLACK_DOWN_POINTING_TRIANGLE	0x25BC
#define T_UTF_16_WHITE_DOWN_POINTING_TRIANGLE	0x25BD
#define T_UTF_16_BLACK_DOWN_POINTING_SMALL_TRIANGLE	0x25BE
#define T_UTF_16_WHITE_DOWN_POINTING_SMALL_TRIANGLE	0x25BF
#define T_UTF_16_BLACK_LEFT_POINTING_TRIANGLE	0x25C0
#define T_UTF_16_WHITE_LEFT_POINTING_TRIANGLE	0x25C1
#define T_UTF_16_BLACK_LEFT_POINTING_SMALL_TRIANGLE	0x25C2
#define T_UTF_16_WHITE_LEFT_POINTING_SMALL_TRIANGLE	0x25C3
#define T_UTF_16_BLACK_LEFT_POINTING_POINTER	0x25C4
#define T_UTF_16_WHITE_LEFT_POINTING_POINTER	0x25C5
#define T_UTF_16_BLACK_DIAMOND	0x25C6
#define T_UTF_16_WHITE_DIAMOND	0x25C7
#define T_UTF_16_WHITE_DIAMOND_CONTAINING_BLACK_SMALL_DIAMOND	0x25C8
#define T_UTF_16_FISHEYE	0x25C9
#define T_UTF_16_LOZENGE	0x25CA
#define T_UTF_16_WHITE_CIRCLE	0x25CB
#define T_UTF_16_DOTTED_CIRCLE	0x25CC
#define T_UTF_16_CIRCLE_WITH_VERTICAL_FILL	0x25CD
#define T_UTF_16_BULLSEYE	0x25CE
#define T_UTF_16_BLACK_CIRCLE	0x25CF
#define T_UTF_16_CIRCLE_WITH_LEFT_HALF_BLACK	0x25D0
#define T_UTF_16_CIRCLE_WITH_RIGHT_HALF_BLACK	0x25D1
#define T_UTF_16_CIRCLE_WITH_LOWER_HALF_BLACK	0x25D2
#define T_UTF_16_CIRCLE_WITH_UPPER_HALF_BLACK	0x25D3
#define T_UTF_16_CIRCLE_WITH_UPPER_RIGHT_QUADRANT_BLACK	0x25D4
#define T_UTF_16_CIRCLE_WITH_ALL_BUT_UPPER_LEFT_QUADRANT_BLACK	0x25D5
#define T_UTF_16_LEFT_HALF_BLACK_CIRCLE	0x25D6
#define T_UTF_16_RIGHT_HALF_BLACK_CIRCLE	0x25D7
#define T_UTF_16_INVERSE_BULLET	0x25D8
#define T_UTF_16_INVERSE_WHITE_CIRCLE	0x25D9
#define T_UTF_16_UPPER_HALF_INVERSE_WHITE_CIRCLE	0x25DA
#define T_UTF_16_LOWER_HALF_INVERSE_WHITE_CIRCLE	0x25DB
#define T_UTF_16_UPPER_LEFT_QUADRANT_CIRCULAR_ARC	0x25DC
#define T_UTF_16_UPPER_RIGHT_QUADRANT_CIRCULAR_ARC	0x25DD
#define T_UTF_16_LOWER_RIGHT_QUADRANT_CIRCULAR_ARC	0x25DE
#define T_UTF_16_LOWER_LEFT_QUADRANT_CIRCULAR_ARC	0x25DF
#define T_UTF_16_UPPER_HALF_CIRCLE	0x25E0
#define T_UTF_16_LOWER_HALF_CIRCLE	0x25E1
#define T_UTF_16_BLACK_LOWER_RIGHT_TRIANGLE	0x25E2
#define T_UTF_16_BLACK_LOWER_LEFT_TRIANGLE	0x25E3
#define T_UTF_16_BLACK_UPPER_LEFT_TRIANGLE	0x25E4
#define T_UTF_16_BLACK_UPPER_RIGHT_TRIANGLE	0x25E5
#define T_UTF_16_WHITE_BULLET	0x25E6
#define T_UTF_16_SQUARE_WITH_LEFT_HALF_BLACK	0x25E7
#define T_UTF_16_SQUARE_WITH_RIGHT_HALF_BLACK	0x25E8
#define T_UTF_16_SQUARE_WITH_UPPER_LEFT_DIAGONAL_HALF_BLACK	0x25E9
#define T_UTF_16_SQUARE_WITH_LOWER_RIGHT_DIAGONAL_HALF_BLACK	0x25EA
#define T_UTF_16_WHITE_SQUARE_WITH_VERTICAL_BISECTING_LINE	0x25EB
#define T_UTF_16_WHITE_UP_POINTING_TRIANGLE_WITH_DOT	0x25EC
#define T_UTF_16_UP_POINTING_TRIANGLE_WITH_LEFT_HALF_BLACK	0x25ED
#define T_UTF_16_UP_POINTING_TRIANGLE_WITH_RIGHT_HALF_BLACK	0x25EE
#define T_UTF_16_LARGE_CIRCLE	0x25EF
#define T_UTF_16_WHITE_SQUARE_WITH_UPPER_LEFT_QUADRANT	0x25F0
#define T_UTF_16_WHITE_SQUARE_WITH_LOWER_LEFT_QUADRANT	0x25F1
#define T_UTF_16_WHITE_SQUARE_WITH_LOWER_RIGHT_QUADRANT	0x25F2
#define T_UTF_16_WHITE_SQUARE_WITH_UPPER_RIGHT_QUADRANT	0x25F3
#define T_UTF_16_WHITE_CIRCLE_WITH_UPPER_LEFT_QUADRANT	0x25F4
#define T_UTF_16_WHITE_CIRCLE_WITH_LOWER_LEFT_QUADRANT	0x25F5
#define T_UTF_16_WHITE_CIRCLE_WITH_LOWER_RIGHT_QUADRANT	0x25F6
#define T_UTF_16_WHITE_CIRCLE_WITH_UPPER_RIGHT_QUADRANT	0x25F7
#define T_UTF_16_BLACK_SUN_WITH_RAYS	0x2600
#define T_UTF_16_CLOUD	0x2601
#define T_UTF_16_UMBRELLA	0x2602
#define T_UTF_16_SNOWMAN	0x2603
#define T_UTF_16_COMET	0x2604
#define T_UTF_16_BLACK_STAR	0x2605
#define T_UTF_16_WHITE_STAR	0x2606
#define T_UTF_16_LIGHTNING	0x2607
#define T_UTF_16_THUNDERSTORM	0x2608
#define T_UTF_16_SUN	0x2609
#define T_UTF_16_ASCENDING_NODE	0x260A
#define T_UTF_16_DESCENDING_NODE	0x260B
#define T_UTF_16_CONJUNCTION	0x260C
#define T_UTF_16_OPPOSITION	0x260D
#define T_UTF_16_BLACK_TELEPHONE	0x260E
#define T_UTF_16_WHITE_TELEPHONE	0x260F
#define T_UTF_16_BALLOT_BOX	0x2610
#define T_UTF_16_BALLOT_BOX_WITH_CHECK	0x2611
#define T_UTF_16_BALLOT_BOX_WITH_X	0x2612
#define T_UTF_16_SALTIRE	0x2613
#define T_UTF_16_REVERSED_ROTATED_FLORAL_HEART_BULLET	0x2619
#define T_UTF_16_BLACK_LEFT_POINTING_INDEX	0x261A
#define T_UTF_16_BLACK_RIGHT_POINTING_INDEX	0x261B
#define T_UTF_16_WHITE_LEFT_POINTING_INDEX	0x261C
#define T_UTF_16_WHITE_UP_POINTING_INDEX	0x261D
#define T_UTF_16_WHITE_RIGHT_POINTING_INDEX	0x261E
#define T_UTF_16_WHITE_DOWN_POINTING_INDEX	0x261F
#define T_UTF_16_SKULL_AND_CROSSBONES	0x2620
#define T_UTF_16_CAUTION_SIGN	0x2621
#define T_UTF_16_RADIOACTIVE_SIGN	0x2622
#define T_UTF_16_BIOHAZARD_SIGN	0x2623
#define T_UTF_16_CADUCEUS	0x2624
#define T_UTF_16_ANKH	0x2625
#define T_UTF_16_ORTHODOX_CROSS	0x2626
#define T_UTF_16_CHI_RHO	0x2627
#define T_UTF_16_CROSS_OF_LORRAINE	0x2628
#define T_UTF_16_CROSS_OF_JERUSALEM	0x2629
#define T_UTF_16_STAR_AND_CRESCENT	0x262A
#define T_UTF_16_FARSI_SYMBOL	0x262B
#define T_UTF_16_ADI_SHAKTI	0x262C
#define T_UTF_16_HAMMER_AND_SICKLE	0x262D
#define T_UTF_16_PEACE_SYMBOL	0x262E
#define T_UTF_16_YIN_YANG	0x262F
#define T_UTF_16_TRIGRAM_FOR_HEAVEN	0x2630
#define T_UTF_16_TRIGRAM_FOR_LAKE	0x2631
#define T_UTF_16_TRIGRAM_FOR_FIRE	0x2632
#define T_UTF_16_TRIGRAM_FOR_THUNDER	0x2633
#define T_UTF_16_TRIGRAM_FOR_WIND	0x2634
#define T_UTF_16_TRIGRAM_FOR_WATER	0x2635
#define T_UTF_16_TRIGRAM_FOR_MOUNTAIN	0x2636
#define T_UTF_16_TRIGRAM_FOR_EARTH	0x2637
#define T_UTF_16_WHEEL_OF_DHARMA	0x2638
#define T_UTF_16_WHITE_FROWNING_FACE	0x2639
#define T_UTF_16_WHITE_SMILING_FACE	0x263A
#define T_UTF_16_BLACK_SMILING_FACE	0x263B
#define T_UTF_16_WHITE_SUN_WITH_RAYS	0x263C
#define T_UTF_16_FIRST_QUARTER_MOON	0x263D
#define T_UTF_16_LAST_QUARTER_MOON	0x263E
#define T_UTF_16_MERCURY	0x263F
#define T_UTF_16_FEMALE_SIGN	0x2640
#define T_UTF_16_EARTH	0x2641
#define T_UTF_16_MALE_SIGN	0x2642
#define T_UTF_16_JUPITER	0x2643
#define T_UTF_16_SATURN	0x2644
#define T_UTF_16_URANUS	0x2645
#define T_UTF_16_NEPTUNE	0x2646
#define T_UTF_16_PLUTO	0x2647
#define T_UTF_16_ARIES	0x2648
#define T_UTF_16_TAURUS	0x2649
#define T_UTF_16_GEMINI	0x264A
#define T_UTF_16_CANCER	0x264B
#define T_UTF_16_LEO	0x264C
#define T_UTF_16_VIRGO	0x264D
#define T_UTF_16_LIBRA	0x264E
#define T_UTF_16_SCORPIUS	0x264F
#define T_UTF_16_SAGITTARIUS	0x2650
#define T_UTF_16_CAPRICORN	0x2651
#define T_UTF_16_AQUARIUS	0x2652
#define T_UTF_16_PISCES	0x2653
#define T_UTF_16_WHITE_CHESS_KING	0x2654
#define T_UTF_16_WHITE_CHESS_QUEEN	0x2655
#define T_UTF_16_WHITE_CHESS_ROOK	0x2656
#define T_UTF_16_WHITE_CHESS_BISHOP	0x2657
#define T_UTF_16_WHITE_CHESS_KNIGHT	0x2658
#define T_UTF_16_WHITE_CHESS_PAWN	0x2659
#define T_UTF_16_BLACK_CHESS_KING	0x265A
#define T_UTF_16_BLACK_CHESS_QUEEN	0x265B
#define T_UTF_16_BLACK_CHESS_ROOK	0x265C
#define T_UTF_16_BLACK_CHESS_BISHOP	0x265D
#define T_UTF_16_BLACK_CHESS_KNIGHT	0x265E
#define T_UTF_16_BLACK_CHESS_PAWN	0x265F
#define T_UTF_16_BLACK_SPADE_SUIT	0x2660
#define T_UTF_16_WHITE_HEART_SUIT	0x2661
#define T_UTF_16_WHITE_DIAMOND_SUIT	0x2662
#define T_UTF_16_BLACK_CLUB_SUIT	0x2663
#define T_UTF_16_WHITE_SPADE_SUIT	0x2664
#define T_UTF_16_BLACK_HEART_SUIT	0x2665
#define T_UTF_16_BLACK_DIAMOND_SUIT	0x2666
#define T_UTF_16_WHITE_CLUB_SUIT	0x2667
#define T_UTF_16_HOT_SPRINGS	0x2668
#define T_UTF_16_QUARTER_NOTE	0x2669
#define T_UTF_16_EIGHTH_NOTE	0x266A
#define T_UTF_16_BEAMED_EIGHTH_NOTES	0x266B
#define T_UTF_16_BEAMED_SIXTEENTH_NOTES	0x266C
#define T_UTF_16_MUSIC_FLAT_SIGN	0x266D
#define T_UTF_16_MUSIC_NATURAL_SIGN	0x266E
#define T_UTF_16_MUSIC_SHARP_SIGN	0x266F
#define T_UTF_16_WEST_SYRIAC_CROSS	0x2670
#define T_UTF_16_EAST_SYRIAC_CROSS	0x2671
#define T_UTF_16_UPPER_BLADE_SCISSORS	0x2701
#define T_UTF_16_BLACK_SCISSORS	0x2702
#define T_UTF_16_LOWER_BLADE_SCISSORS	0x2703
#define T_UTF_16_WHITE_SCISSORS	0x2704
#define T_UTF_16_TELEPHONE_LOCATION_SIGN	0x2706
#define T_UTF_16_TAPE_DRIVE	0x2707
#define T_UTF_16_AIRPLANE	0x2708
#define T_UTF_16_ENVELOPE	0x2709
#define T_UTF_16_VICTORY_HAND	0x270C
#define T_UTF_16_WRITING_HAND	0x270D
#define T_UTF_16_LOWER_RIGHT_PENCIL	0x270E
#define T_UTF_16_PENCIL	0x270F
#define T_UTF_16_UPPER_RIGHT_PENCIL	0x2710
#define T_UTF_16_WHITE_NIB	0x2711
#define T_UTF_16_BLACK_NIB	0x2712
#define T_UTF_16_CHECK_MARK	0x2713
#define T_UTF_16_HEAVY_CHECK_MARK	0x2714
#define T_UTF_16_MULTIPLICATION_X	0x2715
#define T_UTF_16_HEAVY_MULTIPLICATION_X	0x2716
#define T_UTF_16_BALLOT_X	0x2717
#define T_UTF_16_HEAVY_BALLOT_X	0x2718
#define T_UTF_16_OUTLINED_GREEK_CROSS	0x2719
#define T_UTF_16_HEAVY_GREEK_CROSS	0x271A
#define T_UTF_16_OPEN_CENTRE_CROSS	0x271B
#define T_UTF_16_HEAVY_OPEN_CENTRE_CROSS	0x271C
#define T_UTF_16_LATIN_CROSS	0x271D
#define T_UTF_16_SHADOWED_WHITE_LATIN_CROSS	0x271E
#define T_UTF_16_OUTLINED_LATIN_CROSS	0x271F
#define T_UTF_16_MALTESE_CROSS	0x2720
#define T_UTF_16_STAR_OF_DAVID	0x2721
#define T_UTF_16_FOUR_TEARDROP_SPOKED_ASTERISK	0x2722
#define T_UTF_16_FOUR_BALLOON_SPOKED_ASTERISK	0x2723
#define T_UTF_16_HEAVY_FOUR_BALLOON_SPOKED_ASTERISK	0x2724
#define T_UTF_16_FOUR_CLUB_SPOKED_ASTERISK	0x2725
#define T_UTF_16_BLACK_FOUR_POINTED_STAR	0x2726
#define T_UTF_16_WHITE_FOUR_POINTED_STAR	0x2727
#define T_UTF_16_STRESS_OUTLINED_WHITE_STAR	0x2729
#define T_UTF_16_CIRCLED_WHITE_STAR	0x272A
#define T_UTF_16_OPEN_CENTRE_BLACK_STAR	0x272B
#define T_UTF_16_BLACK_CENTRE_WHITE_STAR	0x272C
#define T_UTF_16_OUTLINED_BLACK_STAR	0x272D
#define T_UTF_16_HEAVY_OUTLINED_BLACK_STAR	0x272E
#define T_UTF_16_PINWHEEL_STAR	0x272F
#define T_UTF_16_SHADOWED_WHITE_STAR	0x2730
#define T_UTF_16_HEAVY_ASTERISK	0x2731
#define T_UTF_16_OPEN_CENTRE_ASTERISK	0x2732
#define T_UTF_16_EIGHT_SPOKED_ASTERISK	0x2733
#define T_UTF_16_EIGHT_POINTED_BLACK_STAR	0x2734
#define T_UTF_16_EIGHT_POINTED_PINWHEEL_STAR	0x2735
#define T_UTF_16_SIX_POINTED_BLACK_STAR	0x2736
#define T_UTF_16_EIGHT_POINTED_RECTILINEAR_BLACK_STAR	0x2737
#define T_UTF_16_HEAVY_EIGHT_POINTED_RECTILINEAR_BLACK_STAR	0x2738
#define T_UTF_16_TWELVE_POINTED_BLACK_STAR	0x2739
#define T_UTF_16_SIXTEEN_POINTED_ASTERISK	0x273A
#define T_UTF_16_TEARDROP_SPOKED_ASTERISK	0x273B
#define T_UTF_16_OPEN_CENTRE_TEARDROP_SPOKED_ASTERISK	0x273C
#define T_UTF_16_HEAVY_TEARDROP_SPOKED_ASTERISK	0x273D
#define T_UTF_16_SIX_PETALLED_BLACK_AND_WHITE_FLORETTE	0x273E
#define T_UTF_16_BLACK_FLORETTE	0x273F
#define T_UTF_16_WHITE_FLORETTE	0x2740
#define T_UTF_16_EIGHT_PETALLED_OUTLINED_BLACK_FLORETTE	0x2741
#define T_UTF_16_CIRCLED_OPEN_CENTRE_EIGHT_POINTED_STAR	0x2742
#define T_UTF_16_HEAVY_TEARDROP_SPOKED_PINWHEEL_ASTERISK	0x2743
#define T_UTF_16_SNOWFLAKE	0x2744
#define T_UTF_16_TIGHT_TRIFOLIATE_SNOWFLAKE	0x2745
#define T_UTF_16_HEAVY_CHEVRON_SNOWFLAKE	0x2746
#define T_UTF_16_SPARKLE	0x2747
#define T_UTF_16_HEAVY_SPARKLE	0x2748
#define T_UTF_16_BALLOON_SPOKED_ASTERISK	0x2749
#define T_UTF_16_EIGHT_TEARDROP_SPOKED_PROPELLER_ASTERISK	0x274A
#define T_UTF_16_HEAVY_EIGHT_TEARDROP_SPOKED_PROPELLER_ASTERISK	0x274B
#define T_UTF_16_SHADOWED_WHITE_CIRCLE	0x274D
#define T_UTF_16_LOWER_RIGHT_DROP_SHADOWED_WHITE_SQUARE	0x274F
#define T_UTF_16_UPPER_RIGHT_DROP_SHADOWED_WHITE_SQUARE	0x2750
#define T_UTF_16_LOWER_RIGHT_SHADOWED_WHITE_SQUARE	0x2751
#define T_UTF_16_UPPER_RIGHT_SHADOWED_WHITE_SQUARE	0x2752
#define T_UTF_16_BLACK_DIAMOND_MINUS_WHITE_X	0x2756
#define T_UTF_16_LIGHT_VERTICAL_BAR	0x2758
#define T_UTF_16_MEDIUM_VERTICAL_BAR	0x2759
#define T_UTF_16_HEAVY_VERTICAL_BAR	0x275A
#define T_UTF_16_HEAVY_SINGLE_TURNED_COMMA_QUOTATION_MARK_ORNAMENT	0x275B
#define T_UTF_16_HEAVY_SINGLE_COMMA_QUOTATION_MARK_ORNAMENT	0x275C
#define T_UTF_16_HEAVY_DOUBLE_TURNED_COMMA_QUOTATION_MARK_ORNAMENT	0x275D
#define T_UTF_16_HEAVY_DOUBLE_COMMA_QUOTATION_MARK_ORNAMENT	0x275E
#define T_UTF_16_CURVED_STEM_PARAGRAPH_SIGN_ORNAMENT	0x2761
#define T_UTF_16_HEAVY_EXCLAMATION_MARK_ORNAMENT	0x2762
#define T_UTF_16_HEAVY_HEART_EXCLAMATION_MARK_ORNAMENT	0x2763
#define T_UTF_16_HEAVY_BLACK_HEART	0x2764
#define T_UTF_16_ROTATED_HEAVY_BLACK_HEART_BULLET	0x2765
#define T_UTF_16_FLORAL_HEART	0x2766
#define T_UTF_16_ROTATED_FLORAL_HEART_BULLET	0x2767
#define T_UTF_16_DINGBAT_NEGATIVE_CIRCLED_DIGIT_ONE	0x2776
#define T_UTF_16_DINGBAT_NEGATIVE_CIRCLED_DIGIT_TWO	0x2777
#define T_UTF_16_DINGBAT_NEGATIVE_CIRCLED_DIGIT_THREE	0x2778
#define T_UTF_16_DINGBAT_NEGATIVE_CIRCLED_DIGIT_FOUR	0x2779
#define T_UTF_16_DINGBAT_NEGATIVE_CIRCLED_DIGIT_FIVE	0x277A
#define T_UTF_16_DINGBAT_NEGATIVE_CIRCLED_DIGIT_SIX	0x277B
#define T_UTF_16_DINGBAT_NEGATIVE_CIRCLED_DIGIT_SEVEN	0x277C
#define T_UTF_16_DINGBAT_NEGATIVE_CIRCLED_DIGIT_EIGHT	0x277D
#define T_UTF_16_DINGBAT_NEGATIVE_CIRCLED_DIGIT_NINE	0x277E
#define T_UTF_16_DINGBAT_NEGATIVE_CIRCLED_NUMBER_TEN	0x277F
#define T_UTF_16_DINGBAT_CIRCLED_SANS_SERIF_DIGIT_ONE	0x2780
#define T_UTF_16_DINGBAT_CIRCLED_SANS_SERIF_DIGIT_TWO	0x2781
#define T_UTF_16_DINGBAT_CIRCLED_SANS_SERIF_DIGIT_THREE	0x2782
#define T_UTF_16_DINGBAT_CIRCLED_SANS_SERIF_DIGIT_FOUR	0x2783
#define T_UTF_16_DINGBAT_CIRCLED_SANS_SERIF_DIGIT_FIVE	0x2784
#define T_UTF_16_DINGBAT_CIRCLED_SANS_SERIF_DIGIT_SIX	0x2785
#define T_UTF_16_DINGBAT_CIRCLED_SANS_SERIF_DIGIT_SEVEN	0x2786
#define T_UTF_16_DINGBAT_CIRCLED_SANS_SERIF_DIGIT_EIGHT	0x2787
#define T_UTF_16_DINGBAT_CIRCLED_SANS_SERIF_DIGIT_NINE	0x2788
#define T_UTF_16_DINGBAT_CIRCLED_SANS_SERIF_NUMBER_TEN	0x2789
#define T_UTF_16_DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_ONE	0x278A
#define T_UTF_16_DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_TWO	0x278B
#define T_UTF_16_DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_THREE	0x278C
#define T_UTF_16_DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_FOUR	0x278D
#define T_UTF_16_DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_FIVE	0x278E
#define T_UTF_16_DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_SIX	0x278F
#define T_UTF_16_DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_SEVEN	0x2790
#define T_UTF_16_DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_EIGHT	0x2791
#define T_UTF_16_DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_NINE	0x2792
#define T_UTF_16_DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_NUMBER_TEN	0x2793
#define T_UTF_16_HEAVY_WIDE_HEADED_RIGHTWARDS_ARROW	0x2794
#define T_UTF_16_HEAVY_SOUTH_EAST_ARROW	0x2798
#define T_UTF_16_HEAVY_RIGHTWARDS_ARROW	0x2799
#define T_UTF_16_HEAVY_NORTH_EAST_ARROW	0x279A
#define T_UTF_16_DRAFTING_POINT_RIGHTWARDS_ARROW	0x279B
#define T_UTF_16_HEAVY_ROUND_TIPPED_RIGHTWARDS_ARROW	0x279C
#define T_UTF_16_TRIANGLE_HEADED_RIGHTWARDS_ARROW	0x279D
#define T_UTF_16_HEAVY_TRIANGLE_HEADED_RIGHTWARDS_ARROW	0x279E
#define T_UTF_16_DASHED_TRIANGLE_HEADED_RIGHTWARDS_ARROW	0x279F
#define T_UTF_16_HEAVY_DASHED_TRIANGLE_HEADED_RIGHTWARDS_ARROW	0x27A0
#define T_UTF_16_BLACK_RIGHTWARDS_ARROW	0x27A1
#define T_UTF_16_THREE_D_TOP_LIGHTED_RIGHTWARDS_ARROWHEAD	0x27A2
#define T_UTF_16_THREE_D_BOTTOM_LIGHTED_RIGHTWARDS_ARROWHEAD	0x27A3
#define T_UTF_16_BLACK_RIGHTWARDS_ARROWHEAD	0x27A4
#define T_UTF_16_HEAVY_BLACK_CURVED_DOWNWARDS_AND_RIGHTWARDS_ARROW	0x27A5
#define T_UTF_16_HEAVY_BLACK_CURVED_UPWARDS_AND_RIGHTWARDS_ARROW	0x27A6
#define T_UTF_16_SQUAT_BLACK_RIGHTWARDS_ARROW	0x27A7
#define T_UTF_16_HEAVY_CONCAVE_POINTED_BLACK_RIGHTWARDS_ARROW	0x27A8
#define T_UTF_16_RIGHT_SHADED_WHITE_RIGHTWARDS_ARROW	0x27A9
#define T_UTF_16_LEFT_SHADED_WHITE_RIGHTWARDS_ARROW	0x27AA
#define T_UTF_16_BACK_TILTED_SHADOWED_WHITE_RIGHTWARDS_ARROW	0x27AB
#define T_UTF_16_FRONT_TILTED_SHADOWED_WHITE_RIGHTWARDS_ARROW	0x27AC
#define T_UTF_16_HEAVY_LOWER_RIGHT_SHADOWED_WHITE_RIGHTWARDS_ARROW	0x27AD
#define T_UTF_16_HEAVY_UPPER_RIGHT_SHADOWED_WHITE_RIGHTWARDS_ARROW	0x27AE
#define T_UTF_16_NOTCHED_LOWER_RIGHT_SHADOWED_WHITE_RIGHTWARDS_ARROW	0x27AF
#define T_UTF_16_NOTCHED_UPPER_RIGHT_SHADOWED_WHITE_RIGHTWARDS_ARROW	0x27B1
#define T_UTF_16_CIRCLED_HEAVY_WHITE_RIGHTWARDS_ARROW	0x27B2
#define T_UTF_16_WHITE_FEATHERED_RIGHTWARDS_ARROW	0x27B3
#define T_UTF_16_BLACK_FEATHERED_SOUTH_EAST_ARROW	0x27B4
#define T_UTF_16_BLACK_FEATHERED_RIGHTWARDS_ARROW	0x27B5
#define T_UTF_16_BLACK_FEATHERED_NORTH_EAST_ARROW	0x27B6
#define T_UTF_16_HEAVY_BLACK_FEATHERED_SOUTH_EAST_ARROW	0x27B7
#define T_UTF_16_HEAVY_BLACK_FEATHERED_RIGHTWARDS_ARROW	0x27B8
#define T_UTF_16_HEAVY_BLACK_FEATHERED_NORTH_EAST_ARROW	0x27B9
#define T_UTF_16_TEARDROP_BARBED_RIGHTWARDS_ARROW	0x27BA
#define T_UTF_16_HEAVY_TEARDROP_SHANKED_RIGHTWARDS_ARROW	0x27BB
#define T_UTF_16_WEDGE_TAILED_RIGHTWARDS_ARROW	0x27BC
#define T_UTF_16_HEAVY_WEDGE_TAILED_RIGHTWARDS_ARROW	0x27BD
#define T_UTF_16_OPEN_OUTLINED_RIGHTWARDS_ARROW	0x27BE
#define T_UTF_16_BRAILLE_PATTERN_BLANK	0x2800
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1	0x2801
#define T_UTF_16_BRAILLE_PATTERN_DOTS_2	0x2802
#define T_UTF_16_BRAILLE_PATTERN_DOTS_12	0x2803
#define T_UTF_16_BRAILLE_PATTERN_DOTS_3	0x2804
#define T_UTF_16_BRAILLE_PATTERN_DOTS_13	0x2805
#define T_UTF_16_BRAILLE_PATTERN_DOTS_23	0x2806
#define T_UTF_16_BRAILLE_PATTERN_DOTS_123	0x2807
#define T_UTF_16_BRAILLE_PATTERN_DOTS_4	0x2808
#define T_UTF_16_BRAILLE_PATTERN_DOTS_14	0x2809
#define T_UTF_16_BRAILLE_PATTERN_DOTS_24	0x280A
#define T_UTF_16_BRAILLE_PATTERN_DOTS_124	0x280B
#define T_UTF_16_BRAILLE_PATTERN_DOTS_34	0x280C
#define T_UTF_16_BRAILLE_PATTERN_DOTS_134	0x280D
#define T_UTF_16_BRAILLE_PATTERN_DOTS_234	0x280E
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1234	0x280F
#define T_UTF_16_BRAILLE_PATTERN_DOTS_5	0x2810
#define T_UTF_16_BRAILLE_PATTERN_DOTS_15	0x2811
#define T_UTF_16_BRAILLE_PATTERN_DOTS_25	0x2812
#define T_UTF_16_BRAILLE_PATTERN_DOTS_125	0x2813
#define T_UTF_16_BRAILLE_PATTERN_DOTS_35	0x2814
#define T_UTF_16_BRAILLE_PATTERN_DOTS_135	0x2815
#define T_UTF_16_BRAILLE_PATTERN_DOTS_235	0x2816
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1235	0x2817
#define T_UTF_16_BRAILLE_PATTERN_DOTS_45	0x2818
#define T_UTF_16_BRAILLE_PATTERN_DOTS_145	0x2819
#define T_UTF_16_BRAILLE_PATTERN_DOTS_245	0x281A
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1245	0x281B
#define T_UTF_16_BRAILLE_PATTERN_DOTS_345	0x281C
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1345	0x281D
#define T_UTF_16_BRAILLE_PATTERN_DOTS_2345	0x281E
#define T_UTF_16_BRAILLE_PATTERN_DOTS_12345	0x281F
#define T_UTF_16_BRAILLE_PATTERN_DOTS_6	0x2820
#define T_UTF_16_BRAILLE_PATTERN_DOTS_16	0x2821
#define T_UTF_16_BRAILLE_PATTERN_DOTS_26	0x2822
#define T_UTF_16_BRAILLE_PATTERN_DOTS_126	0x2823
#define T_UTF_16_BRAILLE_PATTERN_DOTS_36	0x2824
#define T_UTF_16_BRAILLE_PATTERN_DOTS_136	0x2825
#define T_UTF_16_BRAILLE_PATTERN_DOTS_236	0x2826
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1236	0x2827
#define T_UTF_16_BRAILLE_PATTERN_DOTS_46	0x2828
#define T_UTF_16_BRAILLE_PATTERN_DOTS_146	0x2829
#define T_UTF_16_BRAILLE_PATTERN_DOTS_246	0x282A
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1246	0x282B
#define T_UTF_16_BRAILLE_PATTERN_DOTS_346	0x282C
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1346	0x282D
#define T_UTF_16_BRAILLE_PATTERN_DOTS_2346	0x282E
#define T_UTF_16_BRAILLE_PATTERN_DOTS_12346	0x282F
#define T_UTF_16_BRAILLE_PATTERN_DOTS_56	0x2830
#define T_UTF_16_BRAILLE_PATTERN_DOTS_156	0x2831
#define T_UTF_16_BRAILLE_PATTERN_DOTS_256	0x2832
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1256	0x2833
#define T_UTF_16_BRAILLE_PATTERN_DOTS_356	0x2834
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1356	0x2835
#define T_UTF_16_BRAILLE_PATTERN_DOTS_2356	0x2836
#define T_UTF_16_BRAILLE_PATTERN_DOTS_12356	0x2837
#define T_UTF_16_BRAILLE_PATTERN_DOTS_456	0x2838
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1456	0x2839
#define T_UTF_16_BRAILLE_PATTERN_DOTS_2456	0x283A
#define T_UTF_16_BRAILLE_PATTERN_DOTS_12456	0x283B
#define T_UTF_16_BRAILLE_PATTERN_DOTS_3456	0x283C
#define T_UTF_16_BRAILLE_PATTERN_DOTS_13456	0x283D
#define T_UTF_16_BRAILLE_PATTERN_DOTS_23456	0x283E
#define T_UTF_16_BRAILLE_PATTERN_DOTS_123456	0x283F
#define T_UTF_16_BRAILLE_PATTERN_DOTS_7	0x2840
#define T_UTF_16_BRAILLE_PATTERN_DOTS_17	0x2841
#define T_UTF_16_BRAILLE_PATTERN_DOTS_27	0x2842
#define T_UTF_16_BRAILLE_PATTERN_DOTS_127	0x2843
#define T_UTF_16_BRAILLE_PATTERN_DOTS_37	0x2844
#define T_UTF_16_BRAILLE_PATTERN_DOTS_137	0x2845
#define T_UTF_16_BRAILLE_PATTERN_DOTS_237	0x2846
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1237	0x2847
#define T_UTF_16_BRAILLE_PATTERN_DOTS_47	0x2848
#define T_UTF_16_BRAILLE_PATTERN_DOTS_147	0x2849
#define T_UTF_16_BRAILLE_PATTERN_DOTS_247	0x284A
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1247	0x284B
#define T_UTF_16_BRAILLE_PATTERN_DOTS_347	0x284C
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1347	0x284D
#define T_UTF_16_BRAILLE_PATTERN_DOTS_2347	0x284E
#define T_UTF_16_BRAILLE_PATTERN_DOTS_12347	0x284F
#define T_UTF_16_BRAILLE_PATTERN_DOTS_57	0x2850
#define T_UTF_16_BRAILLE_PATTERN_DOTS_157	0x2851
#define T_UTF_16_BRAILLE_PATTERN_DOTS_257	0x2852
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1257	0x2853
#define T_UTF_16_BRAILLE_PATTERN_DOTS_357	0x2854
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1357	0x2855
#define T_UTF_16_BRAILLE_PATTERN_DOTS_2357	0x2856
#define T_UTF_16_BRAILLE_PATTERN_DOTS_12357	0x2857
#define T_UTF_16_BRAILLE_PATTERN_DOTS_457	0x2858
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1457	0x2859
#define T_UTF_16_BRAILLE_PATTERN_DOTS_2457	0x285A
#define T_UTF_16_BRAILLE_PATTERN_DOTS_12457	0x285B
#define T_UTF_16_BRAILLE_PATTERN_DOTS_3457	0x285C
#define T_UTF_16_BRAILLE_PATTERN_DOTS_13457	0x285D
#define T_UTF_16_BRAILLE_PATTERN_DOTS_23457	0x285E
#define T_UTF_16_BRAILLE_PATTERN_DOTS_123457	0x285F
#define T_UTF_16_BRAILLE_PATTERN_DOTS_67	0x2860
#define T_UTF_16_BRAILLE_PATTERN_DOTS_167	0x2861
#define T_UTF_16_BRAILLE_PATTERN_DOTS_267	0x2862
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1267	0x2863
#define T_UTF_16_BRAILLE_PATTERN_DOTS_367	0x2864
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1367	0x2865
#define T_UTF_16_BRAILLE_PATTERN_DOTS_2367	0x2866
#define T_UTF_16_BRAILLE_PATTERN_DOTS_12367	0x2867
#define T_UTF_16_BRAILLE_PATTERN_DOTS_467	0x2868
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1467	0x2869
#define T_UTF_16_BRAILLE_PATTERN_DOTS_2467	0x286A
#define T_UTF_16_BRAILLE_PATTERN_DOTS_12467	0x286B
#define T_UTF_16_BRAILLE_PATTERN_DOTS_3467	0x286C
#define T_UTF_16_BRAILLE_PATTERN_DOTS_13467	0x286D
#define T_UTF_16_BRAILLE_PATTERN_DOTS_23467	0x286E
#define T_UTF_16_BRAILLE_PATTERN_DOTS_123467	0x286F
#define T_UTF_16_BRAILLE_PATTERN_DOTS_567	0x2870
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1567	0x2871
#define T_UTF_16_BRAILLE_PATTERN_DOTS_2567	0x2872
#define T_UTF_16_BRAILLE_PATTERN_DOTS_12567	0x2873
#define T_UTF_16_BRAILLE_PATTERN_DOTS_3567	0x2874
#define T_UTF_16_BRAILLE_PATTERN_DOTS_13567	0x2875
#define T_UTF_16_BRAILLE_PATTERN_DOTS_23567	0x2876
#define T_UTF_16_BRAILLE_PATTERN_DOTS_123567	0x2877
#define T_UTF_16_BRAILLE_PATTERN_DOTS_4567	0x2878
#define T_UTF_16_BRAILLE_PATTERN_DOTS_14567	0x2879
#define T_UTF_16_BRAILLE_PATTERN_DOTS_24567	0x287A
#define T_UTF_16_BRAILLE_PATTERN_DOTS_124567	0x287B
#define T_UTF_16_BRAILLE_PATTERN_DOTS_34567	0x287C
#define T_UTF_16_BRAILLE_PATTERN_DOTS_134567	0x287D
#define T_UTF_16_BRAILLE_PATTERN_DOTS_234567	0x287E
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1234567	0x287F
#define T_UTF_16_BRAILLE_PATTERN_DOTS_8	0x2880
#define T_UTF_16_BRAILLE_PATTERN_DOTS_18	0x2881
#define T_UTF_16_BRAILLE_PATTERN_DOTS_28	0x2882
#define T_UTF_16_BRAILLE_PATTERN_DOTS_128	0x2883
#define T_UTF_16_BRAILLE_PATTERN_DOTS_38	0x2884
#define T_UTF_16_BRAILLE_PATTERN_DOTS_138	0x2885
#define T_UTF_16_BRAILLE_PATTERN_DOTS_238	0x2886
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1238	0x2887
#define T_UTF_16_BRAILLE_PATTERN_DOTS_48	0x2888
#define T_UTF_16_BRAILLE_PATTERN_DOTS_148	0x2889
#define T_UTF_16_BRAILLE_PATTERN_DOTS_248	0x288A
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1248	0x288B
#define T_UTF_16_BRAILLE_PATTERN_DOTS_348	0x288C
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1348	0x288D
#define T_UTF_16_BRAILLE_PATTERN_DOTS_2348	0x288E
#define T_UTF_16_BRAILLE_PATTERN_DOTS_12348	0x288F
#define T_UTF_16_BRAILLE_PATTERN_DOTS_58	0x2890
#define T_UTF_16_BRAILLE_PATTERN_DOTS_158	0x2891
#define T_UTF_16_BRAILLE_PATTERN_DOTS_258	0x2892
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1258	0x2893
#define T_UTF_16_BRAILLE_PATTERN_DOTS_358	0x2894
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1358	0x2895
#define T_UTF_16_BRAILLE_PATTERN_DOTS_2358	0x2896
#define T_UTF_16_BRAILLE_PATTERN_DOTS_12358	0x2897
#define T_UTF_16_BRAILLE_PATTERN_DOTS_458	0x2898
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1458	0x2899
#define T_UTF_16_BRAILLE_PATTERN_DOTS_2458	0x289A
#define T_UTF_16_BRAILLE_PATTERN_DOTS_12458	0x289B
#define T_UTF_16_BRAILLE_PATTERN_DOTS_3458	0x289C
#define T_UTF_16_BRAILLE_PATTERN_DOTS_13458	0x289D
#define T_UTF_16_BRAILLE_PATTERN_DOTS_23458	0x289E
#define T_UTF_16_BRAILLE_PATTERN_DOTS_123458	0x289F
#define T_UTF_16_BRAILLE_PATTERN_DOTS_68	0x28A0
#define T_UTF_16_BRAILLE_PATTERN_DOTS_168	0x28A1
#define T_UTF_16_BRAILLE_PATTERN_DOTS_268	0x28A2
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1268	0x28A3
#define T_UTF_16_BRAILLE_PATTERN_DOTS_368	0x28A4
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1368	0x28A5
#define T_UTF_16_BRAILLE_PATTERN_DOTS_2368	0x28A6
#define T_UTF_16_BRAILLE_PATTERN_DOTS_12368	0x28A7
#define T_UTF_16_BRAILLE_PATTERN_DOTS_468	0x28A8
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1468	0x28A9
#define T_UTF_16_BRAILLE_PATTERN_DOTS_2468	0x28AA
#define T_UTF_16_BRAILLE_PATTERN_DOTS_12468	0x28AB
#define T_UTF_16_BRAILLE_PATTERN_DOTS_3468	0x28AC
#define T_UTF_16_BRAILLE_PATTERN_DOTS_13468	0x28AD
#define T_UTF_16_BRAILLE_PATTERN_DOTS_23468	0x28AE
#define T_UTF_16_BRAILLE_PATTERN_DOTS_123468	0x28AF
#define T_UTF_16_BRAILLE_PATTERN_DOTS_568	0x28B0
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1568	0x28B1
#define T_UTF_16_BRAILLE_PATTERN_DOTS_2568	0x28B2
#define T_UTF_16_BRAILLE_PATTERN_DOTS_12568	0x28B3
#define T_UTF_16_BRAILLE_PATTERN_DOTS_3568	0x28B4
#define T_UTF_16_BRAILLE_PATTERN_DOTS_13568	0x28B5
#define T_UTF_16_BRAILLE_PATTERN_DOTS_23568	0x28B6
#define T_UTF_16_BRAILLE_PATTERN_DOTS_123568	0x28B7
#define T_UTF_16_BRAILLE_PATTERN_DOTS_4568	0x28B8
#define T_UTF_16_BRAILLE_PATTERN_DOTS_14568	0x28B9
#define T_UTF_16_BRAILLE_PATTERN_DOTS_24568	0x28BA
#define T_UTF_16_BRAILLE_PATTERN_DOTS_124568	0x28BB
#define T_UTF_16_BRAILLE_PATTERN_DOTS_34568	0x28BC
#define T_UTF_16_BRAILLE_PATTERN_DOTS_134568	0x28BD
#define T_UTF_16_BRAILLE_PATTERN_DOTS_234568	0x28BE
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1234568	0x28BF
#define T_UTF_16_BRAILLE_PATTERN_DOTS_78	0x28C0
#define T_UTF_16_BRAILLE_PATTERN_DOTS_178	0x28C1
#define T_UTF_16_BRAILLE_PATTERN_DOTS_278	0x28C2
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1278	0x28C3
#define T_UTF_16_BRAILLE_PATTERN_DOTS_378	0x28C4
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1378	0x28C5
#define T_UTF_16_BRAILLE_PATTERN_DOTS_2378	0x28C6
#define T_UTF_16_BRAILLE_PATTERN_DOTS_12378	0x28C7
#define T_UTF_16_BRAILLE_PATTERN_DOTS_478	0x28C8
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1478	0x28C9
#define T_UTF_16_BRAILLE_PATTERN_DOTS_2478	0x28CA
#define T_UTF_16_BRAILLE_PATTERN_DOTS_12478	0x28CB
#define T_UTF_16_BRAILLE_PATTERN_DOTS_3478	0x28CC
#define T_UTF_16_BRAILLE_PATTERN_DOTS_13478	0x28CD
#define T_UTF_16_BRAILLE_PATTERN_DOTS_23478	0x28CE
#define T_UTF_16_BRAILLE_PATTERN_DOTS_123478	0x28CF
#define T_UTF_16_BRAILLE_PATTERN_DOTS_578	0x28D0
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1578	0x28D1
#define T_UTF_16_BRAILLE_PATTERN_DOTS_2578	0x28D2
#define T_UTF_16_BRAILLE_PATTERN_DOTS_12578	0x28D3
#define T_UTF_16_BRAILLE_PATTERN_DOTS_3578	0x28D4
#define T_UTF_16_BRAILLE_PATTERN_DOTS_13578	0x28D5
#define T_UTF_16_BRAILLE_PATTERN_DOTS_23578	0x28D6
#define T_UTF_16_BRAILLE_PATTERN_DOTS_123578	0x28D7
#define T_UTF_16_BRAILLE_PATTERN_DOTS_4578	0x28D8
#define T_UTF_16_BRAILLE_PATTERN_DOTS_14578	0x28D9
#define T_UTF_16_BRAILLE_PATTERN_DOTS_24578	0x28DA
#define T_UTF_16_BRAILLE_PATTERN_DOTS_124578	0x28DB
#define T_UTF_16_BRAILLE_PATTERN_DOTS_34578	0x28DC
#define T_UTF_16_BRAILLE_PATTERN_DOTS_134578	0x28DD
#define T_UTF_16_BRAILLE_PATTERN_DOTS_234578	0x28DE
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1234578	0x28DF
#define T_UTF_16_BRAILLE_PATTERN_DOTS_678	0x28E0
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1678	0x28E1
#define T_UTF_16_BRAILLE_PATTERN_DOTS_2678	0x28E2
#define T_UTF_16_BRAILLE_PATTERN_DOTS_12678	0x28E3
#define T_UTF_16_BRAILLE_PATTERN_DOTS_3678	0x28E4
#define T_UTF_16_BRAILLE_PATTERN_DOTS_13678	0x28E5
#define T_UTF_16_BRAILLE_PATTERN_DOTS_23678	0x28E6
#define T_UTF_16_BRAILLE_PATTERN_DOTS_123678	0x28E7
#define T_UTF_16_BRAILLE_PATTERN_DOTS_4678	0x28E8
#define T_UTF_16_BRAILLE_PATTERN_DOTS_14678	0x28E9
#define T_UTF_16_BRAILLE_PATTERN_DOTS_24678	0x28EA
#define T_UTF_16_BRAILLE_PATTERN_DOTS_124678	0x28EB
#define T_UTF_16_BRAILLE_PATTERN_DOTS_34678	0x28EC
#define T_UTF_16_BRAILLE_PATTERN_DOTS_134678	0x28ED
#define T_UTF_16_BRAILLE_PATTERN_DOTS_234678	0x28EE
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1234678	0x28EF
#define T_UTF_16_BRAILLE_PATTERN_DOTS_5678	0x28F0
#define T_UTF_16_BRAILLE_PATTERN_DOTS_15678	0x28F1
#define T_UTF_16_BRAILLE_PATTERN_DOTS_25678	0x28F2
#define T_UTF_16_BRAILLE_PATTERN_DOTS_125678	0x28F3
#define T_UTF_16_BRAILLE_PATTERN_DOTS_35678	0x28F4
#define T_UTF_16_BRAILLE_PATTERN_DOTS_135678	0x28F5
#define T_UTF_16_BRAILLE_PATTERN_DOTS_235678	0x28F6
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1235678	0x28F7
#define T_UTF_16_BRAILLE_PATTERN_DOTS_45678	0x28F8
#define T_UTF_16_BRAILLE_PATTERN_DOTS_145678	0x28F9
#define T_UTF_16_BRAILLE_PATTERN_DOTS_245678	0x28FA
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1245678	0x28FB
#define T_UTF_16_BRAILLE_PATTERN_DOTS_345678	0x28FC
#define T_UTF_16_BRAILLE_PATTERN_DOTS_1345678	0x28FD
#define T_UTF_16_BRAILLE_PATTERN_DOTS_2345678	0x28FE
#define T_UTF_16_BRAILLE_PATTERN_DOTS_12345678	0x28FF
#define T_UTF_16_CJK_RADICAL_REPEAT	0x2E80
#define T_UTF_16_CJK_RADICAL_CLIFF	0x2E81
#define T_UTF_16_CJK_RADICAL_SECOND_ONE	0x2E82
#define T_UTF_16_CJK_RADICAL_SECOND_TWO	0x2E83
#define T_UTF_16_CJK_RADICAL_SECOND_THREE	0x2E84
#define T_UTF_16_CJK_RADICAL_PERSON	0x2E85
#define T_UTF_16_CJK_RADICAL_BOX	0x2E86
#define T_UTF_16_CJK_RADICAL_TABLE	0x2E87
#define T_UTF_16_CJK_RADICAL_KNIFE_ONE	0x2E88
#define T_UTF_16_CJK_RADICAL_KNIFE_TWO	0x2E89
#define T_UTF_16_CJK_RADICAL_DIVINATION	0x2E8A
#define T_UTF_16_CJK_RADICAL_SEAL	0x2E8B
#define T_UTF_16_CJK_RADICAL_SMALL_ONE	0x2E8C
#define T_UTF_16_CJK_RADICAL_SMALL_TWO	0x2E8D
#define T_UTF_16_CJK_RADICAL_LAME_ONE	0x2E8E
#define T_UTF_16_CJK_RADICAL_LAME_TWO	0x2E8F
#define T_UTF_16_CJK_RADICAL_LAME_THREE	0x2E90
#define T_UTF_16_CJK_RADICAL_LAME_FOUR	0x2E91
#define T_UTF_16_CJK_RADICAL_SNAKE	0x2E92
#define T_UTF_16_CJK_RADICAL_THREAD	0x2E93
#define T_UTF_16_CJK_RADICAL_SNOUT_ONE	0x2E94
#define T_UTF_16_CJK_RADICAL_SNOUT_TWO	0x2E95
#define T_UTF_16_CJK_RADICAL_HEART_ONE	0x2E96
#define T_UTF_16_CJK_RADICAL_HEART_TWO	0x2E97
#define T_UTF_16_CJK_RADICAL_HAND	0x2E98
#define T_UTF_16_CJK_RADICAL_RAP	0x2E99
#define T_UTF_16_CJK_RADICAL_CHOKE	0x2E9B
#define T_UTF_16_CJK_RADICAL_SUN	0x2E9C
#define T_UTF_16_CJK_RADICAL_MOON	0x2E9D
#define T_UTF_16_CJK_RADICAL_DEATH	0x2E9E
#define T_UTF_16_CJK_RADICAL_MOTHER	0x2E9F
#define T_UTF_16_CJK_RADICAL_CIVILIAN	0x2EA0
#define T_UTF_16_CJK_RADICAL_WATER_ONE	0x2EA1
#define T_UTF_16_CJK_RADICAL_WATER_TWO	0x2EA2
#define T_UTF_16_CJK_RADICAL_FIRE	0x2EA3
#define T_UTF_16_CJK_RADICAL_PAW_ONE	0x2EA4
#define T_UTF_16_CJK_RADICAL_PAW_TWO	0x2EA5
#define T_UTF_16_CJK_RADICAL_SIMPLIFIED_HALF_TREE_TRUNK	0x2EA6
#define T_UTF_16_CJK_RADICAL_COW	0x2EA7
#define T_UTF_16_CJK_RADICAL_DOG	0x2EA8
#define T_UTF_16_CJK_RADICAL_JADE	0x2EA9
#define T_UTF_16_CJK_RADICAL_BOLT_OF_CLOTH	0x2EAA
#define T_UTF_16_CJK_RADICAL_EYE	0x2EAB
#define T_UTF_16_CJK_RADICAL_SPIRIT_ONE	0x2EAC
#define T_UTF_16_CJK_RADICAL_SPIRIT_TWO	0x2EAD
#define T_UTF_16_CJK_RADICAL_BAMBOO	0x2EAE
#define T_UTF_16_CJK_RADICAL_SILK	0x2EAF
#define T_UTF_16_CJK_RADICAL_C_SIMPLIFIED_SILK	0x2EB0
#define T_UTF_16_CJK_RADICAL_NET_ONE	0x2EB1
#define T_UTF_16_CJK_RADICAL_NET_TWO	0x2EB2
#define T_UTF_16_CJK_RADICAL_NET_THREE	0x2EB3
#define T_UTF_16_CJK_RADICAL_NET_FOUR	0x2EB4
#define T_UTF_16_CJK_RADICAL_MESH	0x2EB5
#define T_UTF_16_CJK_RADICAL_SHEEP	0x2EB6
#define T_UTF_16_CJK_RADICAL_RAM	0x2EB7
#define T_UTF_16_CJK_RADICAL_EWE	0x2EB8
#define T_UTF_16_CJK_RADICAL_OLD	0x2EB9
#define T_UTF_16_CJK_RADICAL_BRUSH_ONE	0x2EBA
#define T_UTF_16_CJK_RADICAL_BRUSH_TWO	0x2EBB
#define T_UTF_16_CJK_RADICAL_MEAT	0x2EBC
#define T_UTF_16_CJK_RADICAL_MORTAR	0x2EBD
#define T_UTF_16_CJK_RADICAL_GRASS_ONE	0x2EBE
#define T_UTF_16_CJK_RADICAL_GRASS_TWO	0x2EBF
#define T_UTF_16_CJK_RADICAL_GRASS_THREE	0x2EC0
#define T_UTF_16_CJK_RADICAL_TIGER	0x2EC1
#define T_UTF_16_CJK_RADICAL_CLOTHES	0x2EC2
#define T_UTF_16_CJK_RADICAL_WEST_ONE	0x2EC3
#define T_UTF_16_CJK_RADICAL_WEST_TWO	0x2EC4
#define T_UTF_16_CJK_RADICAL_C_SIMPLIFIED_SEE	0x2EC5
#define T_UTF_16_CJK_RADICAL_SIMPLIFIED_HORN	0x2EC6
#define T_UTF_16_CJK_RADICAL_HORN	0x2EC7
#define T_UTF_16_CJK_RADICAL_C_SIMPLIFIED_SPEECH	0x2EC8
#define T_UTF_16_CJK_RADICAL_C_SIMPLIFIED_SHELL	0x2EC9
#define T_UTF_16_CJK_RADICAL_FOOT	0x2ECA
#define T_UTF_16_CJK_RADICAL_C_SIMPLIFIED_CART	0x2ECB
#define T_UTF_16_CJK_RADICAL_SIMPLIFIED_WALK	0x2ECC
#define T_UTF_16_CJK_RADICAL_WALK_ONE	0x2ECD
#define T_UTF_16_CJK_RADICAL_WALK_TWO	0x2ECE
#define T_UTF_16_CJK_RADICAL_CITY	0x2ECF
#define T_UTF_16_CJK_RADICAL_C_SIMPLIFIED_GOLD	0x2ED0
#define T_UTF_16_CJK_RADICAL_LONG_ONE	0x2ED1
#define T_UTF_16_CJK_RADICAL_LONG_TWO	0x2ED2
#define T_UTF_16_CJK_RADICAL_C_SIMPLIFIED_LONG	0x2ED3
#define T_UTF_16_CJK_RADICAL_C_SIMPLIFIED_GATE	0x2ED4
#define T_UTF_16_CJK_RADICAL_MOUND_ONE	0x2ED5
#define T_UTF_16_CJK_RADICAL_MOUND_TWO	0x2ED6
#define T_UTF_16_CJK_RADICAL_RAIN	0x2ED7
#define T_UTF_16_CJK_RADICAL_BLUE	0x2ED8
#define T_UTF_16_CJK_RADICAL_C_SIMPLIFIED_TANNED_LEATHER	0x2ED9
#define T_UTF_16_CJK_RADICAL_C_SIMPLIFIED_LEAF	0x2EDA
#define T_UTF_16_CJK_RADICAL_C_SIMPLIFIED_WIND	0x2EDB
#define T_UTF_16_CJK_RADICAL_C_SIMPLIFIED_FLY	0x2EDC
#define T_UTF_16_CJK_RADICAL_EAT_ONE	0x2EDD
#define T_UTF_16_CJK_RADICAL_EAT_TWO	0x2EDE
#define T_UTF_16_CJK_RADICAL_EAT_THREE	0x2EDF
#define T_UTF_16_CJK_RADICAL_C_SIMPLIFIED_EAT	0x2EE0
#define T_UTF_16_CJK_RADICAL_HEAD	0x2EE1
#define T_UTF_16_CJK_RADICAL_C_SIMPLIFIED_HORSE	0x2EE2
#define T_UTF_16_CJK_RADICAL_BONE	0x2EE3
#define T_UTF_16_CJK_RADICAL_GHOST	0x2EE4
#define T_UTF_16_CJK_RADICAL_C_SIMPLIFIED_FISH	0x2EE5
#define T_UTF_16_CJK_RADICAL_C_SIMPLIFIED_BIRD	0x2EE6
#define T_UTF_16_CJK_RADICAL_C_SIMPLIFIED_SALT	0x2EE7
#define T_UTF_16_CJK_RADICAL_SIMPLIFIED_WHEAT	0x2EE8
#define T_UTF_16_CJK_RADICAL_SIMPLIFIED_YELLOW	0x2EE9
#define T_UTF_16_CJK_RADICAL_C_SIMPLIFIED_FROG	0x2EEA
#define T_UTF_16_CJK_RADICAL_J_SIMPLIFIED_EVEN	0x2EEB
#define T_UTF_16_CJK_RADICAL_C_SIMPLIFIED_EVEN	0x2EEC
#define T_UTF_16_CJK_RADICAL_J_SIMPLIFIED_TOOTH	0x2EED
#define T_UTF_16_CJK_RADICAL_C_SIMPLIFIED_TOOTH	0x2EEE
#define T_UTF_16_CJK_RADICAL_J_SIMPLIFIED_DRAGON	0x2EEF
#define T_UTF_16_CJK_RADICAL_C_SIMPLIFIED_DRAGON	0x2EF0
#define T_UTF_16_CJK_RADICAL_TURTLE	0x2EF1
#define T_UTF_16_CJK_RADICAL_J_SIMPLIFIED_TURTLE	0x2EF2
#define T_UTF_16_CJK_RADICAL_C_SIMPLIFIED_TURTLE	0x2EF3
#define T_UTF_16_KANGXI_RADICAL_ONE	0x2F00
#define T_UTF_16_KANGXI_RADICAL_LINE	0x2F01
#define T_UTF_16_KANGXI_RADICAL_DOT	0x2F02
#define T_UTF_16_KANGXI_RADICAL_SLASH	0x2F03
#define T_UTF_16_KANGXI_RADICAL_SECOND	0x2F04
#define T_UTF_16_KANGXI_RADICAL_HOOK	0x2F05
#define T_UTF_16_KANGXI_RADICAL_TWO	0x2F06
#define T_UTF_16_KANGXI_RADICAL_LID	0x2F07
#define T_UTF_16_KANGXI_RADICAL_MAN	0x2F08
#define T_UTF_16_KANGXI_RADICAL_LEGS	0x2F09
#define T_UTF_16_KANGXI_RADICAL_ENTER	0x2F0A
#define T_UTF_16_KANGXI_RADICAL_EIGHT	0x2F0B
#define T_UTF_16_KANGXI_RADICAL_DOWN_BOX	0x2F0C
#define T_UTF_16_KANGXI_RADICAL_COVER	0x2F0D
#define T_UTF_16_KANGXI_RADICAL_ICE	0x2F0E
#define T_UTF_16_KANGXI_RADICAL_TABLE	0x2F0F
#define T_UTF_16_KANGXI_RADICAL_OPEN_BOX	0x2F10
#define T_UTF_16_KANGXI_RADICAL_KNIFE	0x2F11
#define T_UTF_16_KANGXI_RADICAL_POWER	0x2F12
#define T_UTF_16_KANGXI_RADICAL_WRAP	0x2F13
#define T_UTF_16_KANGXI_RADICAL_SPOON	0x2F14
#define T_UTF_16_KANGXI_RADICAL_RIGHT_OPEN_BOX	0x2F15
#define T_UTF_16_KANGXI_RADICAL_HIDING_ENCLOSURE	0x2F16
#define T_UTF_16_KANGXI_RADICAL_TEN	0x2F17
#define T_UTF_16_KANGXI_RADICAL_DIVINATION	0x2F18
#define T_UTF_16_KANGXI_RADICAL_SEAL	0x2F19
#define T_UTF_16_KANGXI_RADICAL_CLIFF	0x2F1A
#define T_UTF_16_KANGXI_RADICAL_PRIVATE	0x2F1B
#define T_UTF_16_KANGXI_RADICAL_AGAIN	0x2F1C
#define T_UTF_16_KANGXI_RADICAL_MOUTH	0x2F1D
#define T_UTF_16_KANGXI_RADICAL_ENCLOSURE	0x2F1E
#define T_UTF_16_KANGXI_RADICAL_EARTH	0x2F1F
#define T_UTF_16_KANGXI_RADICAL_SCHOLAR	0x2F20
#define T_UTF_16_KANGXI_RADICAL_GO	0x2F21
#define T_UTF_16_KANGXI_RADICAL_GO_SLOWLY	0x2F22
#define T_UTF_16_KANGXI_RADICAL_EVENING	0x2F23
#define T_UTF_16_KANGXI_RADICAL_BIG	0x2F24
#define T_UTF_16_KANGXI_RADICAL_WOMAN	0x2F25
#define T_UTF_16_KANGXI_RADICAL_CHILD	0x2F26
#define T_UTF_16_KANGXI_RADICAL_ROOF	0x2F27
#define T_UTF_16_KANGXI_RADICAL_INCH	0x2F28
#define T_UTF_16_KANGXI_RADICAL_SMALL	0x2F29
#define T_UTF_16_KANGXI_RADICAL_LAME	0x2F2A
#define T_UTF_16_KANGXI_RADICAL_CORPSE	0x2F2B
#define T_UTF_16_KANGXI_RADICAL_SPROUT	0x2F2C
#define T_UTF_16_KANGXI_RADICAL_MOUNTAIN	0x2F2D
#define T_UTF_16_KANGXI_RADICAL_RIVER	0x2F2E
#define T_UTF_16_KANGXI_RADICAL_WORK	0x2F2F
#define T_UTF_16_KANGXI_RADICAL_ONESELF	0x2F30
#define T_UTF_16_KANGXI_RADICAL_TURBAN	0x2F31
#define T_UTF_16_KANGXI_RADICAL_DRY	0x2F32
#define T_UTF_16_KANGXI_RADICAL_SHORT_THREAD	0x2F33
#define T_UTF_16_KANGXI_RADICAL_DOTTED_CLIFF	0x2F34
#define T_UTF_16_KANGXI_RADICAL_LONG_STRIDE	0x2F35
#define T_UTF_16_KANGXI_RADICAL_TWO_HANDS	0x2F36
#define T_UTF_16_KANGXI_RADICAL_SHOOT	0x2F37
#define T_UTF_16_KANGXI_RADICAL_BOW	0x2F38
#define T_UTF_16_KANGXI_RADICAL_SNOUT	0x2F39
#define T_UTF_16_KANGXI_RADICAL_BRISTLE	0x2F3A
#define T_UTF_16_KANGXI_RADICAL_STEP	0x2F3B
#define T_UTF_16_KANGXI_RADICAL_HEART	0x2F3C
#define T_UTF_16_KANGXI_RADICAL_HALBERD	0x2F3D
#define T_UTF_16_KANGXI_RADICAL_DOOR	0x2F3E
#define T_UTF_16_KANGXI_RADICAL_HAND	0x2F3F
#define T_UTF_16_KANGXI_RADICAL_BRANCH	0x2F40
#define T_UTF_16_KANGXI_RADICAL_RAP	0x2F41
#define T_UTF_16_KANGXI_RADICAL_SCRIPT	0x2F42
#define T_UTF_16_KANGXI_RADICAL_DIPPER	0x2F43
#define T_UTF_16_KANGXI_RADICAL_AXE	0x2F44
#define T_UTF_16_KANGXI_RADICAL_SQUARE	0x2F45
#define T_UTF_16_KANGXI_RADICAL_NOT	0x2F46
#define T_UTF_16_KANGXI_RADICAL_SUN	0x2F47
#define T_UTF_16_KANGXI_RADICAL_SAY	0x2F48
#define T_UTF_16_KANGXI_RADICAL_MOON	0x2F49
#define T_UTF_16_KANGXI_RADICAL_TREE	0x2F4A
#define T_UTF_16_KANGXI_RADICAL_LACK	0x2F4B
#define T_UTF_16_KANGXI_RADICAL_STOP	0x2F4C
#define T_UTF_16_KANGXI_RADICAL_DEATH	0x2F4D
#define T_UTF_16_KANGXI_RADICAL_WEAPON	0x2F4E
#define T_UTF_16_KANGXI_RADICAL_DO_NOT	0x2F4F
#define T_UTF_16_KANGXI_RADICAL_COMPARE	0x2F50
#define T_UTF_16_KANGXI_RADICAL_FUR	0x2F51
#define T_UTF_16_KANGXI_RADICAL_CLAN	0x2F52
#define T_UTF_16_KANGXI_RADICAL_STEAM	0x2F53
#define T_UTF_16_KANGXI_RADICAL_WATER	0x2F54
#define T_UTF_16_KANGXI_RADICAL_FIRE	0x2F55
#define T_UTF_16_KANGXI_RADICAL_CLAW	0x2F56
#define T_UTF_16_KANGXI_RADICAL_FATHER	0x2F57
#define T_UTF_16_KANGXI_RADICAL_DOUBLE_X	0x2F58
#define T_UTF_16_KANGXI_RADICAL_HALF_TREE_TRUNK	0x2F59
#define T_UTF_16_KANGXI_RADICAL_SLICE	0x2F5A
#define T_UTF_16_KANGXI_RADICAL_FANG	0x2F5B
#define T_UTF_16_KANGXI_RADICAL_COW	0x2F5C
#define T_UTF_16_KANGXI_RADICAL_DOG	0x2F5D
#define T_UTF_16_KANGXI_RADICAL_PROFOUND	0x2F5E
#define T_UTF_16_KANGXI_RADICAL_JADE	0x2F5F
#define T_UTF_16_KANGXI_RADICAL_MELON	0x2F60
#define T_UTF_16_KANGXI_RADICAL_TILE	0x2F61
#define T_UTF_16_KANGXI_RADICAL_SWEET	0x2F62
#define T_UTF_16_KANGXI_RADICAL_LIFE	0x2F63
#define T_UTF_16_KANGXI_RADICAL_USE	0x2F64
#define T_UTF_16_KANGXI_RADICAL_FIELD	0x2F65
#define T_UTF_16_KANGXI_RADICAL_BOLT_OF_CLOTH	0x2F66
#define T_UTF_16_KANGXI_RADICAL_SICKNESS	0x2F67
#define T_UTF_16_KANGXI_RADICAL_DOTTED_TENT	0x2F68
#define T_UTF_16_KANGXI_RADICAL_WHITE	0x2F69
#define T_UTF_16_KANGXI_RADICAL_SKIN	0x2F6A
#define T_UTF_16_KANGXI_RADICAL_DISH	0x2F6B
#define T_UTF_16_KANGXI_RADICAL_EYE	0x2F6C
#define T_UTF_16_KANGXI_RADICAL_SPEAR	0x2F6D
#define T_UTF_16_KANGXI_RADICAL_ARROW	0x2F6E
#define T_UTF_16_KANGXI_RADICAL_STONE	0x2F6F
#define T_UTF_16_KANGXI_RADICAL_SPIRIT	0x2F70
#define T_UTF_16_KANGXI_RADICAL_TRACK	0x2F71
#define T_UTF_16_KANGXI_RADICAL_GRAIN	0x2F72
#define T_UTF_16_KANGXI_RADICAL_CAVE	0x2F73
#define T_UTF_16_KANGXI_RADICAL_STAND	0x2F74
#define T_UTF_16_KANGXI_RADICAL_BAMBOO	0x2F75
#define T_UTF_16_KANGXI_RADICAL_RICE	0x2F76
#define T_UTF_16_KANGXI_RADICAL_SILK	0x2F77
#define T_UTF_16_KANGXI_RADICAL_JAR	0x2F78
#define T_UTF_16_KANGXI_RADICAL_NET	0x2F79
#define T_UTF_16_KANGXI_RADICAL_SHEEP	0x2F7A
#define T_UTF_16_KANGXI_RADICAL_FEATHER	0x2F7B
#define T_UTF_16_KANGXI_RADICAL_OLD	0x2F7C
#define T_UTF_16_KANGXI_RADICAL_AND	0x2F7D
#define T_UTF_16_KANGXI_RADICAL_PLOW	0x2F7E
#define T_UTF_16_KANGXI_RADICAL_EAR	0x2F7F
#define T_UTF_16_KANGXI_RADICAL_BRUSH	0x2F80
#define T_UTF_16_KANGXI_RADICAL_MEAT	0x2F81
#define T_UTF_16_KANGXI_RADICAL_MINISTER	0x2F82
#define T_UTF_16_KANGXI_RADICAL_SELF	0x2F83
#define T_UTF_16_KANGXI_RADICAL_ARRIVE	0x2F84
#define T_UTF_16_KANGXI_RADICAL_MORTAR	0x2F85
#define T_UTF_16_KANGXI_RADICAL_TONGUE	0x2F86
#define T_UTF_16_KANGXI_RADICAL_OPPOSE	0x2F87
#define T_UTF_16_KANGXI_RADICAL_BOAT	0x2F88
#define T_UTF_16_KANGXI_RADICAL_STOPPING	0x2F89
#define T_UTF_16_KANGXI_RADICAL_COLOR	0x2F8A
#define T_UTF_16_KANGXI_RADICAL_GRASS	0x2F8B
#define T_UTF_16_KANGXI_RADICAL_TIGER	0x2F8C
#define T_UTF_16_KANGXI_RADICAL_INSECT	0x2F8D
#define T_UTF_16_KANGXI_RADICAL_BLOOD	0x2F8E
#define T_UTF_16_KANGXI_RADICAL_WALK_ENCLOSURE	0x2F8F
#define T_UTF_16_KANGXI_RADICAL_CLOTHES	0x2F90
#define T_UTF_16_KANGXI_RADICAL_WEST	0x2F91
#define T_UTF_16_KANGXI_RADICAL_SEE	0x2F92
#define T_UTF_16_KANGXI_RADICAL_HORN	0x2F93
#define T_UTF_16_KANGXI_RADICAL_SPEECH	0x2F94
#define T_UTF_16_KANGXI_RADICAL_VALLEY	0x2F95
#define T_UTF_16_KANGXI_RADICAL_BEAN	0x2F96
#define T_UTF_16_KANGXI_RADICAL_PIG	0x2F97
#define T_UTF_16_KANGXI_RADICAL_BADGER	0x2F98
#define T_UTF_16_KANGXI_RADICAL_SHELL	0x2F99
#define T_UTF_16_KANGXI_RADICAL_RED	0x2F9A
#define T_UTF_16_KANGXI_RADICAL_RUN	0x2F9B
#define T_UTF_16_KANGXI_RADICAL_FOOT	0x2F9C
#define T_UTF_16_KANGXI_RADICAL_BODY	0x2F9D
#define T_UTF_16_KANGXI_RADICAL_CART	0x2F9E
#define T_UTF_16_KANGXI_RADICAL_BITTER	0x2F9F
#define T_UTF_16_KANGXI_RADICAL_MORNING	0x2FA0
#define T_UTF_16_KANGXI_RADICAL_WALK	0x2FA1
#define T_UTF_16_KANGXI_RADICAL_CITY	0x2FA2
#define T_UTF_16_KANGXI_RADICAL_WINE	0x2FA3
#define T_UTF_16_KANGXI_RADICAL_DISTINGUISH	0x2FA4
#define T_UTF_16_KANGXI_RADICAL_VILLAGE	0x2FA5
#define T_UTF_16_KANGXI_RADICAL_GOLD	0x2FA6
#define T_UTF_16_KANGXI_RADICAL_LONG	0x2FA7
#define T_UTF_16_KANGXI_RADICAL_GATE	0x2FA8
#define T_UTF_16_KANGXI_RADICAL_MOUND	0x2FA9
#define T_UTF_16_KANGXI_RADICAL_SLAVE	0x2FAA
#define T_UTF_16_KANGXI_RADICAL_SHORT_TAILED_BIRD	0x2FAB
#define T_UTF_16_KANGXI_RADICAL_RAIN	0x2FAC
#define T_UTF_16_KANGXI_RADICAL_BLUE	0x2FAD
#define T_UTF_16_KANGXI_RADICAL_WRONG	0x2FAE
#define T_UTF_16_KANGXI_RADICAL_FACE	0x2FAF
#define T_UTF_16_KANGXI_RADICAL_LEATHER	0x2FB0
#define T_UTF_16_KANGXI_RADICAL_TANNED_LEATHER	0x2FB1
#define T_UTF_16_KANGXI_RADICAL_LEEK	0x2FB2
#define T_UTF_16_KANGXI_RADICAL_SOUND	0x2FB3
#define T_UTF_16_KANGXI_RADICAL_LEAF	0x2FB4
#define T_UTF_16_KANGXI_RADICAL_WIND	0x2FB5
#define T_UTF_16_KANGXI_RADICAL_FLY	0x2FB6
#define T_UTF_16_KANGXI_RADICAL_EAT	0x2FB7
#define T_UTF_16_KANGXI_RADICAL_HEAD	0x2FB8
#define T_UTF_16_KANGXI_RADICAL_FRAGRANT	0x2FB9
#define T_UTF_16_KANGXI_RADICAL_HORSE	0x2FBA
#define T_UTF_16_KANGXI_RADICAL_BONE	0x2FBB
#define T_UTF_16_KANGXI_RADICAL_TALL	0x2FBC
#define T_UTF_16_KANGXI_RADICAL_HAIR	0x2FBD
#define T_UTF_16_KANGXI_RADICAL_FIGHT	0x2FBE
#define T_UTF_16_KANGXI_RADICAL_SACRIFICIAL_WINE	0x2FBF
#define T_UTF_16_KANGXI_RADICAL_CAULDRON	0x2FC0
#define T_UTF_16_KANGXI_RADICAL_GHOST	0x2FC1
#define T_UTF_16_KANGXI_RADICAL_FISH	0x2FC2
#define T_UTF_16_KANGXI_RADICAL_BIRD	0x2FC3
#define T_UTF_16_KANGXI_RADICAL_SALT	0x2FC4
#define T_UTF_16_KANGXI_RADICAL_DEER	0x2FC5
#define T_UTF_16_KANGXI_RADICAL_WHEAT	0x2FC6
#define T_UTF_16_KANGXI_RADICAL_HEMP	0x2FC7
#define T_UTF_16_KANGXI_RADICAL_YELLOW	0x2FC8
#define T_UTF_16_KANGXI_RADICAL_MILLET	0x2FC9
#define T_UTF_16_KANGXI_RADICAL_BLACK	0x2FCA
#define T_UTF_16_KANGXI_RADICAL_EMBROIDERY	0x2FCB
#define T_UTF_16_KANGXI_RADICAL_FROG	0x2FCC
#define T_UTF_16_KANGXI_RADICAL_TRIPOD	0x2FCD
#define T_UTF_16_KANGXI_RADICAL_DRUM	0x2FCE
#define T_UTF_16_KANGXI_RADICAL_RAT	0x2FCF
#define T_UTF_16_KANGXI_RADICAL_NOSE	0x2FD0
#define T_UTF_16_KANGXI_RADICAL_EVEN	0x2FD1
#define T_UTF_16_KANGXI_RADICAL_TOOTH	0x2FD2
#define T_UTF_16_KANGXI_RADICAL_DRAGON	0x2FD3
#define T_UTF_16_KANGXI_RADICAL_TURTLE	0x2FD4
#define T_UTF_16_KANGXI_RADICAL_FLUTE	0x2FD5
#define T_UTF_16_IDEOGRAPHIC_DESCRIPTION_CHARACTER_LEFT_TO_RIGHT	0x2FF0
#define T_UTF_16_IDEOGRAPHIC_DESCRIPTION_CHARACTER_ABOVE_TO_BELOW	0x2FF1
#define T_UTF_16_IDEOGRAPHIC_DESCRIPTION_CHARACTER_LEFT_TO_MIDDLE_AND_RIGHT	0x2FF2
#define T_UTF_16_IDEOGRAPHIC_DESCRIPTION_CHARACTER_ABOVE_TO_MIDDLE_AND_BELOW	0x2FF3
#define T_UTF_16_IDEOGRAPHIC_DESCRIPTION_CHARACTER_FULL_SURROUND	0x2FF4
#define T_UTF_16_IDEOGRAPHIC_DESCRIPTION_CHARACTER_SURROUND_FROM_ABOVE	0x2FF5
#define T_UTF_16_IDEOGRAPHIC_DESCRIPTION_CHARACTER_SURROUND_FROM_BELOW	0x2FF6
#define T_UTF_16_IDEOGRAPHIC_DESCRIPTION_CHARACTER_SURROUND_FROM_LEFT	0x2FF7
#define T_UTF_16_IDEOGRAPHIC_DESCRIPTION_CHARACTER_SURROUND_FROM_UPPER_LEFT	0x2FF8
#define T_UTF_16_IDEOGRAPHIC_DESCRIPTION_CHARACTER_SURROUND_FROM_UPPER_RIGHT	0x2FF9
#define T_UTF_16_IDEOGRAPHIC_DESCRIPTION_CHARACTER_SURROUND_FROM_LOWER_LEFT	0x2FFA
#define T_UTF_16_IDEOGRAPHIC_DESCRIPTION_CHARACTER_OVERLAID	0x2FFB
#define T_UTF_16_IDEOGRAPHIC_SPACE	0x3000
#define T_UTF_16_IDEOGRAPHIC_COMMA	0x3001
#define T_UTF_16_IDEOGRAPHIC_FULL_STOP	0x3002
#define T_UTF_16_DITTO_MARK	0x3003
#define T_UTF_16_JAPANESE_INDUSTRIAL_STANDARD_SYMBOL	0x3004
#define T_UTF_16_IDEOGRAPHIC_ITERATION_MARK	0x3005
#define T_UTF_16_IDEOGRAPHIC_CLOSING_MARK	0x3006
#define T_UTF_16_IDEOGRAPHIC_NUMBER_ZERO	0x3007
#define T_UTF_16_LEFT_ANGLE_BRACKET	0x3008
#define T_UTF_16_RIGHT_ANGLE_BRACKET	0x3009
#define T_UTF_16_LEFT_DOUBLE_ANGLE_BRACKET	0x300A
#define T_UTF_16_RIGHT_DOUBLE_ANGLE_BRACKET	0x300B
#define T_UTF_16_LEFT_CORNER_BRACKET	0x300C
#define T_UTF_16_RIGHT_CORNER_BRACKET	0x300D
#define T_UTF_16_LEFT_WHITE_CORNER_BRACKET	0x300E
#define T_UTF_16_RIGHT_WHITE_CORNER_BRACKET	0x300F
#define T_UTF_16_LEFT_BLACK_LENTICULAR_BRACKET	0x3010
#define T_UTF_16_RIGHT_BLACK_LENTICULAR_BRACKET	0x3011
#define T_UTF_16_POSTAL_MARK	0x3012
#define T_UTF_16_GETA_MARK	0x3013
#define T_UTF_16_LEFT_TORTOISE_SHELL_BRACKET	0x3014
#define T_UTF_16_RIGHT_TORTOISE_SHELL_BRACKET	0x3015
#define T_UTF_16_LEFT_WHITE_LENTICULAR_BRACKET	0x3016
#define T_UTF_16_RIGHT_WHITE_LENTICULAR_BRACKET	0x3017
#define T_UTF_16_LEFT_WHITE_TORTOISE_SHELL_BRACKET	0x3018
#define T_UTF_16_RIGHT_WHITE_TORTOISE_SHELL_BRACKET	0x3019
#define T_UTF_16_LEFT_WHITE_SQUARE_BRACKET	0x301A
#define T_UTF_16_RIGHT_WHITE_SQUARE_BRACKET	0x301B
#define T_UTF_16_WAVE_DASH	0x301C
#define T_UTF_16_REVERSED_DOUBLE_PRIME_QUOTATION_MARK	0x301D
#define T_UTF_16_DOUBLE_PRIME_QUOTATION_MARK	0x301E
#define T_UTF_16_LOW_DOUBLE_PRIME_QUOTATION_MARK	0x301F
#define T_UTF_16_POSTAL_MARK_FACE	0x3020
#define T_UTF_16_HANGZHOU_NUMERAL_ONE	0x3021
#define T_UTF_16_HANGZHOU_NUMERAL_TWO	0x3022
#define T_UTF_16_HANGZHOU_NUMERAL_THREE	0x3023
#define T_UTF_16_HANGZHOU_NUMERAL_FOUR	0x3024
#define T_UTF_16_HANGZHOU_NUMERAL_FIVE	0x3025
#define T_UTF_16_HANGZHOU_NUMERAL_SIX	0x3026
#define T_UTF_16_HANGZHOU_NUMERAL_SEVEN	0x3027
#define T_UTF_16_HANGZHOU_NUMERAL_EIGHT	0x3028
#define T_UTF_16_HANGZHOU_NUMERAL_NINE	0x3029
#define T_UTF_16_IDEOGRAPHIC_LEVEL_TONE_MARK	0x302A
#define T_UTF_16_IDEOGRAPHIC_RISING_TONE_MARK	0x302B
#define T_UTF_16_IDEOGRAPHIC_DEPARTING_TONE_MARK	0x302C
#define T_UTF_16_IDEOGRAPHIC_ENTERING_TONE_MARK	0x302D
#define T_UTF_16_HANGUL_SINGLE_DOT_TONE_MARK	0x302E
#define T_UTF_16_HANGUL_DOUBLE_DOT_TONE_MARK	0x302F
#define T_UTF_16_WAVY_DASH	0x3030
#define T_UTF_16_VERTICAL_KANA_REPEAT_MARK	0x3031
#define T_UTF_16_VERTICAL_KANA_REPEAT_WITH_VOICED_SOUND_MARK	0x3032
#define T_UTF_16_VERTICAL_KANA_REPEAT_MARK_UPPER_HALF	0x3033
#define T_UTF_16_VERTICAL_KANA_REPEAT_WITH_VOICED_SOUND_MARK_UPPER_HALF	0x3034
#define T_UTF_16_VERTICAL_KANA_REPEAT_MARK_LOWER_HALF	0x3035
#define T_UTF_16_CIRCLED_POSTAL_MARK	0x3036
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_LINE_FEED_SEPARATOR_SYMBOL	0x3037
#define T_UTF_16_HANGZHOU_NUMERAL_TEN	0x3038
#define T_UTF_16_HANGZHOU_NUMERAL_TWENTY	0x3039
#define T_UTF_16_HANGZHOU_NUMERAL_THIRTY	0x303A
#define T_UTF_16_IDEOGRAPHIC_VARIATION_INDICATOR	0x303E
#define T_UTF_16_IDEOGRAPHIC_HALF_FILL_SPACE	0x303F
#define T_UTF_16_HIRAGANA_LETTER_SMALL_A	0x3041
#define T_UTF_16_HIRAGANA_LETTER_A	0x3042
#define T_UTF_16_HIRAGANA_LETTER_SMALL_I	0x3043
#define T_UTF_16_HIRAGANA_LETTER_I	0x3044
#define T_UTF_16_HIRAGANA_LETTER_SMALL_U	0x3045
#define T_UTF_16_HIRAGANA_LETTER_U	0x3046
#define T_UTF_16_HIRAGANA_LETTER_SMALL_E	0x3047
#define T_UTF_16_HIRAGANA_LETTER_E	0x3048
#define T_UTF_16_HIRAGANA_LETTER_SMALL_O	0x3049
#define T_UTF_16_HIRAGANA_LETTER_O	0x304A
#define T_UTF_16_HIRAGANA_LETTER_KA	0x304B
#define T_UTF_16_HIRAGANA_LETTER_GA	0x304C
#define T_UTF_16_HIRAGANA_LETTER_KI	0x304D
#define T_UTF_16_HIRAGANA_LETTER_GI	0x304E
#define T_UTF_16_HIRAGANA_LETTER_KU	0x304F
#define T_UTF_16_HIRAGANA_LETTER_GU	0x3050
#define T_UTF_16_HIRAGANA_LETTER_KE	0x3051
#define T_UTF_16_HIRAGANA_LETTER_GE	0x3052
#define T_UTF_16_HIRAGANA_LETTER_KO	0x3053
#define T_UTF_16_HIRAGANA_LETTER_GO	0x3054
#define T_UTF_16_HIRAGANA_LETTER_SA	0x3055
#define T_UTF_16_HIRAGANA_LETTER_ZA	0x3056
#define T_UTF_16_HIRAGANA_LETTER_SI	0x3057
#define T_UTF_16_HIRAGANA_LETTER_ZI	0x3058
#define T_UTF_16_HIRAGANA_LETTER_SU	0x3059
#define T_UTF_16_HIRAGANA_LETTER_ZU	0x305A
#define T_UTF_16_HIRAGANA_LETTER_SE	0x305B
#define T_UTF_16_HIRAGANA_LETTER_ZE	0x305C
#define T_UTF_16_HIRAGANA_LETTER_SO	0x305D
#define T_UTF_16_HIRAGANA_LETTER_ZO	0x305E
#define T_UTF_16_HIRAGANA_LETTER_TA	0x305F
#define T_UTF_16_HIRAGANA_LETTER_DA	0x3060
#define T_UTF_16_HIRAGANA_LETTER_TI	0x3061
#define T_UTF_16_HIRAGANA_LETTER_DI	0x3062
#define T_UTF_16_HIRAGANA_LETTER_SMALL_TU	0x3063
#define T_UTF_16_HIRAGANA_LETTER_TU	0x3064
#define T_UTF_16_HIRAGANA_LETTER_DU	0x3065
#define T_UTF_16_HIRAGANA_LETTER_TE	0x3066
#define T_UTF_16_HIRAGANA_LETTER_DE	0x3067
#define T_UTF_16_HIRAGANA_LETTER_TO	0x3068
#define T_UTF_16_HIRAGANA_LETTER_DO	0x3069
#define T_UTF_16_HIRAGANA_LETTER_NA	0x306A
#define T_UTF_16_HIRAGANA_LETTER_NI	0x306B
#define T_UTF_16_HIRAGANA_LETTER_NU	0x306C
#define T_UTF_16_HIRAGANA_LETTER_NE	0x306D
#define T_UTF_16_HIRAGANA_LETTER_NO	0x306E
#define T_UTF_16_HIRAGANA_LETTER_HA	0x306F
#define T_UTF_16_HIRAGANA_LETTER_BA	0x3070
#define T_UTF_16_HIRAGANA_LETTER_PA	0x3071
#define T_UTF_16_HIRAGANA_LETTER_HI	0x3072
#define T_UTF_16_HIRAGANA_LETTER_BI	0x3073
#define T_UTF_16_HIRAGANA_LETTER_PI	0x3074
#define T_UTF_16_HIRAGANA_LETTER_HU	0x3075
#define T_UTF_16_HIRAGANA_LETTER_BU	0x3076
#define T_UTF_16_HIRAGANA_LETTER_PU	0x3077
#define T_UTF_16_HIRAGANA_LETTER_HE	0x3078
#define T_UTF_16_HIRAGANA_LETTER_BE	0x3079
#define T_UTF_16_HIRAGANA_LETTER_PE	0x307A
#define T_UTF_16_HIRAGANA_LETTER_HO	0x307B
#define T_UTF_16_HIRAGANA_LETTER_BO	0x307C
#define T_UTF_16_HIRAGANA_LETTER_PO	0x307D
#define T_UTF_16_HIRAGANA_LETTER_MA	0x307E
#define T_UTF_16_HIRAGANA_LETTER_MI	0x307F
#define T_UTF_16_HIRAGANA_LETTER_MU	0x3080
#define T_UTF_16_HIRAGANA_LETTER_ME	0x3081
#define T_UTF_16_HIRAGANA_LETTER_MO	0x3082
#define T_UTF_16_HIRAGANA_LETTER_SMALL_YA	0x3083
#define T_UTF_16_HIRAGANA_LETTER_YA	0x3084
#define T_UTF_16_HIRAGANA_LETTER_SMALL_YU	0x3085
#define T_UTF_16_HIRAGANA_LETTER_YU	0x3086
#define T_UTF_16_HIRAGANA_LETTER_SMALL_YO	0x3087
#define T_UTF_16_HIRAGANA_LETTER_YO	0x3088
#define T_UTF_16_HIRAGANA_LETTER_RA	0x3089
#define T_UTF_16_HIRAGANA_LETTER_RI	0x308A
#define T_UTF_16_HIRAGANA_LETTER_RU	0x308B
#define T_UTF_16_HIRAGANA_LETTER_RE	0x308C
#define T_UTF_16_HIRAGANA_LETTER_RO	0x308D
#define T_UTF_16_HIRAGANA_LETTER_SMALL_WA	0x308E
#define T_UTF_16_HIRAGANA_LETTER_WA	0x308F
#define T_UTF_16_HIRAGANA_LETTER_WI	0x3090
#define T_UTF_16_HIRAGANA_LETTER_WE	0x3091
#define T_UTF_16_HIRAGANA_LETTER_WO	0x3092
#define T_UTF_16_HIRAGANA_LETTER_N	0x3093
#define T_UTF_16_HIRAGANA_LETTER_VU	0x3094
#define T_UTF_16_COMBINING_KATAKANA_HIRAGANA_VOICED_SOUND_MARK	0x3099
#define T_UTF_16_COMBINING_KATAKANA_HIRAGANA_SEMI_VOICED_SOUND_MARK	0x309A
#define T_UTF_16_KATAKANA_HIRAGANA_VOICED_SOUND_MARK	0x309B
#define T_UTF_16_KATAKANA_HIRAGANA_SEMI_VOICED_SOUND_MARK	0x309C
#define T_UTF_16_HIRAGANA_ITERATION_MARK	0x309D
#define T_UTF_16_HIRAGANA_VOICED_ITERATION_MARK	0x309E
#define T_UTF_16_KATAKANA_LETTER_SMALL_A	0x30A1
#define T_UTF_16_KATAKANA_LETTER_A	0x30A2
#define T_UTF_16_KATAKANA_LETTER_SMALL_I	0x30A3
#define T_UTF_16_KATAKANA_LETTER_I	0x30A4
#define T_UTF_16_KATAKANA_LETTER_SMALL_U	0x30A5
#define T_UTF_16_KATAKANA_LETTER_U	0x30A6
#define T_UTF_16_KATAKANA_LETTER_SMALL_E	0x30A7
#define T_UTF_16_KATAKANA_LETTER_E	0x30A8
#define T_UTF_16_KATAKANA_LETTER_SMALL_O	0x30A9
#define T_UTF_16_KATAKANA_LETTER_O	0x30AA
#define T_UTF_16_KATAKANA_LETTER_KA	0x30AB
#define T_UTF_16_KATAKANA_LETTER_GA	0x30AC
#define T_UTF_16_KATAKANA_LETTER_KI	0x30AD
#define T_UTF_16_KATAKANA_LETTER_GI	0x30AE
#define T_UTF_16_KATAKANA_LETTER_KU	0x30AF
#define T_UTF_16_KATAKANA_LETTER_GU	0x30B0
#define T_UTF_16_KATAKANA_LETTER_KE	0x30B1
#define T_UTF_16_KATAKANA_LETTER_GE	0x30B2
#define T_UTF_16_KATAKANA_LETTER_KO	0x30B3
#define T_UTF_16_KATAKANA_LETTER_GO	0x30B4
#define T_UTF_16_KATAKANA_LETTER_SA	0x30B5
#define T_UTF_16_KATAKANA_LETTER_ZA	0x30B6
#define T_UTF_16_KATAKANA_LETTER_SI	0x30B7
#define T_UTF_16_KATAKANA_LETTER_ZI	0x30B8
#define T_UTF_16_KATAKANA_LETTER_SU	0x30B9
#define T_UTF_16_KATAKANA_LETTER_ZU	0x30BA
#define T_UTF_16_KATAKANA_LETTER_SE	0x30BB
#define T_UTF_16_KATAKANA_LETTER_ZE	0x30BC
#define T_UTF_16_KATAKANA_LETTER_SO	0x30BD
#define T_UTF_16_KATAKANA_LETTER_ZO	0x30BE
#define T_UTF_16_KATAKANA_LETTER_TA	0x30BF
#define T_UTF_16_KATAKANA_LETTER_DA	0x30C0
#define T_UTF_16_KATAKANA_LETTER_TI	0x30C1
#define T_UTF_16_KATAKANA_LETTER_DI	0x30C2
#define T_UTF_16_KATAKANA_LETTER_SMALL_TU	0x30C3
#define T_UTF_16_KATAKANA_LETTER_TU	0x30C4
#define T_UTF_16_KATAKANA_LETTER_DU	0x30C5
#define T_UTF_16_KATAKANA_LETTER_TE	0x30C6
#define T_UTF_16_KATAKANA_LETTER_DE	0x30C7
#define T_UTF_16_KATAKANA_LETTER_TO	0x30C8
#define T_UTF_16_KATAKANA_LETTER_DO	0x30C9
#define T_UTF_16_KATAKANA_LETTER_NA	0x30CA
#define T_UTF_16_KATAKANA_LETTER_NI	0x30CB
#define T_UTF_16_KATAKANA_LETTER_NU	0x30CC
#define T_UTF_16_KATAKANA_LETTER_NE	0x30CD
#define T_UTF_16_KATAKANA_LETTER_NO	0x30CE
#define T_UTF_16_KATAKANA_LETTER_HA	0x30CF
#define T_UTF_16_KATAKANA_LETTER_BA	0x30D0
#define T_UTF_16_KATAKANA_LETTER_PA	0x30D1
#define T_UTF_16_KATAKANA_LETTER_HI	0x30D2
#define T_UTF_16_KATAKANA_LETTER_BI	0x30D3
#define T_UTF_16_KATAKANA_LETTER_PI	0x30D4
#define T_UTF_16_KATAKANA_LETTER_HU	0x30D5
#define T_UTF_16_KATAKANA_LETTER_BU	0x30D6
#define T_UTF_16_KATAKANA_LETTER_PU	0x30D7
#define T_UTF_16_KATAKANA_LETTER_HE	0x30D8
#define T_UTF_16_KATAKANA_LETTER_BE	0x30D9
#define T_UTF_16_KATAKANA_LETTER_PE	0x30DA
#define T_UTF_16_KATAKANA_LETTER_HO	0x30DB
#define T_UTF_16_KATAKANA_LETTER_BO	0x30DC
#define T_UTF_16_KATAKANA_LETTER_PO	0x30DD
#define T_UTF_16_KATAKANA_LETTER_MA	0x30DE
#define T_UTF_16_KATAKANA_LETTER_MI	0x30DF
#define T_UTF_16_KATAKANA_LETTER_MU	0x30E0
#define T_UTF_16_KATAKANA_LETTER_ME	0x30E1
#define T_UTF_16_KATAKANA_LETTER_MO	0x30E2
#define T_UTF_16_KATAKANA_LETTER_SMALL_YA	0x30E3
#define T_UTF_16_KATAKANA_LETTER_YA	0x30E4
#define T_UTF_16_KATAKANA_LETTER_SMALL_YU	0x30E5
#define T_UTF_16_KATAKANA_LETTER_YU	0x30E6
#define T_UTF_16_KATAKANA_LETTER_SMALL_YO	0x30E7
#define T_UTF_16_KATAKANA_LETTER_YO	0x30E8
#define T_UTF_16_KATAKANA_LETTER_RA	0x30E9
#define T_UTF_16_KATAKANA_LETTER_RI	0x30EA
#define T_UTF_16_KATAKANA_LETTER_RU	0x30EB
#define T_UTF_16_KATAKANA_LETTER_RE	0x30EC
#define T_UTF_16_KATAKANA_LETTER_RO	0x30ED
#define T_UTF_16_KATAKANA_LETTER_SMALL_WA	0x30EE
#define T_UTF_16_KATAKANA_LETTER_WA	0x30EF
#define T_UTF_16_KATAKANA_LETTER_WI	0x30F0
#define T_UTF_16_KATAKANA_LETTER_WE	0x30F1
#define T_UTF_16_KATAKANA_LETTER_WO	0x30F2
#define T_UTF_16_KATAKANA_LETTER_N	0x30F3
#define T_UTF_16_KATAKANA_LETTER_VU	0x30F4
#define T_UTF_16_KATAKANA_LETTER_SMALL_KA	0x30F5
#define T_UTF_16_KATAKANA_LETTER_SMALL_KE	0x30F6
#define T_UTF_16_KATAKANA_LETTER_VA	0x30F7
#define T_UTF_16_KATAKANA_LETTER_VI	0x30F8
#define T_UTF_16_KATAKANA_LETTER_VE	0x30F9
#define T_UTF_16_KATAKANA_LETTER_VO	0x30FA
#define T_UTF_16_KATAKANA_MIDDLE_DOT	0x30FB
#define T_UTF_16_KATAKANA_HIRAGANA_PROLONGED_SOUND_MARK	0x30FC
#define T_UTF_16_KATAKANA_ITERATION_MARK	0x30FD
#define T_UTF_16_KATAKANA_VOICED_ITERATION_MARK	0x30FE
#define T_UTF_16_BOPOMOFO_LETTER_B	0x3105
#define T_UTF_16_BOPOMOFO_LETTER_P	0x3106
#define T_UTF_16_BOPOMOFO_LETTER_M	0x3107
#define T_UTF_16_BOPOMOFO_LETTER_F	0x3108
#define T_UTF_16_BOPOMOFO_LETTER_D	0x3109
#define T_UTF_16_BOPOMOFO_LETTER_T	0x310A
#define T_UTF_16_BOPOMOFO_LETTER_N	0x310B
#define T_UTF_16_BOPOMOFO_LETTER_L	0x310C
#define T_UTF_16_BOPOMOFO_LETTER_G	0x310D
#define T_UTF_16_BOPOMOFO_LETTER_K	0x310E
#define T_UTF_16_BOPOMOFO_LETTER_H	0x310F
#define T_UTF_16_BOPOMOFO_LETTER_J	0x3110
#define T_UTF_16_BOPOMOFO_LETTER_Q	0x3111
#define T_UTF_16_BOPOMOFO_LETTER_X	0x3112
#define T_UTF_16_BOPOMOFO_LETTER_ZH	0x3113
#define T_UTF_16_BOPOMOFO_LETTER_CH	0x3114
#define T_UTF_16_BOPOMOFO_LETTER_SH	0x3115
#define T_UTF_16_BOPOMOFO_LETTER_R	0x3116
#define T_UTF_16_BOPOMOFO_LETTER_Z	0x3117
#define T_UTF_16_BOPOMOFO_LETTER_C	0x3118
#define T_UTF_16_BOPOMOFO_LETTER_S	0x3119
#define T_UTF_16_BOPOMOFO_LETTER_A	0x311A
#define T_UTF_16_BOPOMOFO_LETTER_O	0x311B
#define T_UTF_16_BOPOMOFO_LETTER_E	0x311C
#define T_UTF_16_BOPOMOFO_LETTER_EH	0x311D
#define T_UTF_16_BOPOMOFO_LETTER_AI	0x311E
#define T_UTF_16_BOPOMOFO_LETTER_EI	0x311F
#define T_UTF_16_BOPOMOFO_LETTER_AU	0x3120
#define T_UTF_16_BOPOMOFO_LETTER_OU	0x3121
#define T_UTF_16_BOPOMOFO_LETTER_AN	0x3122
#define T_UTF_16_BOPOMOFO_LETTER_EN	0x3123
#define T_UTF_16_BOPOMOFO_LETTER_ANG	0x3124
#define T_UTF_16_BOPOMOFO_LETTER_ENG	0x3125
#define T_UTF_16_BOPOMOFO_LETTER_ER	0x3126
#define T_UTF_16_BOPOMOFO_LETTER_I	0x3127
#define T_UTF_16_BOPOMOFO_LETTER_U	0x3128
#define T_UTF_16_BOPOMOFO_LETTER_IU	0x3129
#define T_UTF_16_BOPOMOFO_LETTER_V	0x312A
#define T_UTF_16_BOPOMOFO_LETTER_NG	0x312B
#define T_UTF_16_BOPOMOFO_LETTER_GN	0x312C
#define T_UTF_16_HANGUL_LETTER_KIYEOK	0x3131
#define T_UTF_16_HANGUL_LETTER_SSANGKIYEOK	0x3132
#define T_UTF_16_HANGUL_LETTER_KIYEOK_SIOS	0x3133
#define T_UTF_16_HANGUL_LETTER_NIEUN	0x3134
#define T_UTF_16_HANGUL_LETTER_NIEUN_CIEUC	0x3135
#define T_UTF_16_HANGUL_LETTER_NIEUN_HIEUH	0x3136
#define T_UTF_16_HANGUL_LETTER_TIKEUT	0x3137
#define T_UTF_16_HANGUL_LETTER_SSANGTIKEUT	0x3138
#define T_UTF_16_HANGUL_LETTER_RIEUL	0x3139
#define T_UTF_16_HANGUL_LETTER_RIEUL_KIYEOK	0x313A
#define T_UTF_16_HANGUL_LETTER_RIEUL_MIEUM	0x313B
#define T_UTF_16_HANGUL_LETTER_RIEUL_PIEUP	0x313C
#define T_UTF_16_HANGUL_LETTER_RIEUL_SIOS	0x313D
#define T_UTF_16_HANGUL_LETTER_RIEUL_THIEUTH	0x313E
#define T_UTF_16_HANGUL_LETTER_RIEUL_PHIEUPH	0x313F
#define T_UTF_16_HANGUL_LETTER_RIEUL_HIEUH	0x3140
#define T_UTF_16_HANGUL_LETTER_MIEUM	0x3141
#define T_UTF_16_HANGUL_LETTER_PIEUP	0x3142
#define T_UTF_16_HANGUL_LETTER_SSANGPIEUP	0x3143
#define T_UTF_16_HANGUL_LETTER_PIEUP_SIOS	0x3144
#define T_UTF_16_HANGUL_LETTER_SIOS	0x3145
#define T_UTF_16_HANGUL_LETTER_SSANGSIOS	0x3146
#define T_UTF_16_HANGUL_LETTER_IEUNG	0x3147
#define T_UTF_16_HANGUL_LETTER_CIEUC	0x3148
#define T_UTF_16_HANGUL_LETTER_SSANGCIEUC	0x3149
#define T_UTF_16_HANGUL_LETTER_CHIEUCH	0x314A
#define T_UTF_16_HANGUL_LETTER_KHIEUKH	0x314B
#define T_UTF_16_HANGUL_LETTER_THIEUTH	0x314C
#define T_UTF_16_HANGUL_LETTER_PHIEUPH	0x314D
#define T_UTF_16_HANGUL_LETTER_HIEUH	0x314E
#define T_UTF_16_HANGUL_LETTER_A	0x314F
#define T_UTF_16_HANGUL_LETTER_AE	0x3150
#define T_UTF_16_HANGUL_LETTER_YA	0x3151
#define T_UTF_16_HANGUL_LETTER_YAE	0x3152
#define T_UTF_16_HANGUL_LETTER_EO	0x3153
#define T_UTF_16_HANGUL_LETTER_E	0x3154
#define T_UTF_16_HANGUL_LETTER_YEO	0x3155
#define T_UTF_16_HANGUL_LETTER_YE	0x3156
#define T_UTF_16_HANGUL_LETTER_O	0x3157
#define T_UTF_16_HANGUL_LETTER_WA	0x3158
#define T_UTF_16_HANGUL_LETTER_WAE	0x3159
#define T_UTF_16_HANGUL_LETTER_OE	0x315A
#define T_UTF_16_HANGUL_LETTER_YO	0x315B
#define T_UTF_16_HANGUL_LETTER_U	0x315C
#define T_UTF_16_HANGUL_LETTER_WEO	0x315D
#define T_UTF_16_HANGUL_LETTER_WE	0x315E
#define T_UTF_16_HANGUL_LETTER_WI	0x315F
#define T_UTF_16_HANGUL_LETTER_YU	0x3160
#define T_UTF_16_HANGUL_LETTER_EU	0x3161
#define T_UTF_16_HANGUL_LETTER_YI	0x3162
#define T_UTF_16_HANGUL_LETTER_I	0x3163
#define T_UTF_16_HANGUL_FILLER	0x3164
#define T_UTF_16_HANGUL_LETTER_SSANGNIEUN	0x3165
#define T_UTF_16_HANGUL_LETTER_NIEUN_TIKEUT	0x3166
#define T_UTF_16_HANGUL_LETTER_NIEUN_SIOS	0x3167
#define T_UTF_16_HANGUL_LETTER_NIEUN_PANSIOS	0x3168
#define T_UTF_16_HANGUL_LETTER_RIEUL_KIYEOK_SIOS	0x3169
#define T_UTF_16_HANGUL_LETTER_RIEUL_TIKEUT	0x316A
#define T_UTF_16_HANGUL_LETTER_RIEUL_PIEUP_SIOS	0x316B
#define T_UTF_16_HANGUL_LETTER_RIEUL_PANSIOS	0x316C
#define T_UTF_16_HANGUL_LETTER_RIEUL_YEORINHIEUH	0x316D
#define T_UTF_16_HANGUL_LETTER_MIEUM_PIEUP	0x316E
#define T_UTF_16_HANGUL_LETTER_MIEUM_SIOS	0x316F
#define T_UTF_16_HANGUL_LETTER_MIEUM_PANSIOS	0x3170
#define T_UTF_16_HANGUL_LETTER_KAPYEOUNMIEUM	0x3171
#define T_UTF_16_HANGUL_LETTER_PIEUP_KIYEOK	0x3172
#define T_UTF_16_HANGUL_LETTER_PIEUP_TIKEUT	0x3173
#define T_UTF_16_HANGUL_LETTER_PIEUP_SIOS_KIYEOK	0x3174
#define T_UTF_16_HANGUL_LETTER_PIEUP_SIOS_TIKEUT	0x3175
#define T_UTF_16_HANGUL_LETTER_PIEUP_CIEUC	0x3176
#define T_UTF_16_HANGUL_LETTER_PIEUP_THIEUTH	0x3177
#define T_UTF_16_HANGUL_LETTER_KAPYEOUNPIEUP	0x3178
#define T_UTF_16_HANGUL_LETTER_KAPYEOUNSSANGPIEUP	0x3179
#define T_UTF_16_HANGUL_LETTER_SIOS_KIYEOK	0x317A
#define T_UTF_16_HANGUL_LETTER_SIOS_NIEUN	0x317B
#define T_UTF_16_HANGUL_LETTER_SIOS_TIKEUT	0x317C
#define T_UTF_16_HANGUL_LETTER_SIOS_PIEUP	0x317D
#define T_UTF_16_HANGUL_LETTER_SIOS_CIEUC	0x317E
#define T_UTF_16_HANGUL_LETTER_PANSIOS	0x317F
#define T_UTF_16_HANGUL_LETTER_SSANGIEUNG	0x3180
#define T_UTF_16_HANGUL_LETTER_YESIEUNG	0x3181
#define T_UTF_16_HANGUL_LETTER_YESIEUNG_SIOS	0x3182
#define T_UTF_16_HANGUL_LETTER_YESIEUNG_PANSIOS	0x3183
#define T_UTF_16_HANGUL_LETTER_KAPYEOUNPHIEUPH	0x3184
#define T_UTF_16_HANGUL_LETTER_SSANGHIEUH	0x3185
#define T_UTF_16_HANGUL_LETTER_YEORINHIEUH	0x3186
#define T_UTF_16_HANGUL_LETTER_YO_YA	0x3187
#define T_UTF_16_HANGUL_LETTER_YO_YAE	0x3188
#define T_UTF_16_HANGUL_LETTER_YO_I	0x3189
#define T_UTF_16_HANGUL_LETTER_YU_YEO	0x318A
#define T_UTF_16_HANGUL_LETTER_YU_YE	0x318B
#define T_UTF_16_HANGUL_LETTER_YU_I	0x318C
#define T_UTF_16_HANGUL_LETTER_ARAEA	0x318D
#define T_UTF_16_HANGUL_LETTER_ARAEAE	0x318E
#define T_UTF_16_IDEOGRAPHIC_ANNOTATION_LINKING_MARK	0x3190
#define T_UTF_16_IDEOGRAPHIC_ANNOTATION_REVERSE_MARK	0x3191
#define T_UTF_16_IDEOGRAPHIC_ANNOTATION_ONE_MARK	0x3192
#define T_UTF_16_IDEOGRAPHIC_ANNOTATION_TWO_MARK	0x3193
#define T_UTF_16_IDEOGRAPHIC_ANNOTATION_THREE_MARK	0x3194
#define T_UTF_16_IDEOGRAPHIC_ANNOTATION_FOUR_MARK	0x3195
#define T_UTF_16_IDEOGRAPHIC_ANNOTATION_TOP_MARK	0x3196
#define T_UTF_16_IDEOGRAPHIC_ANNOTATION_MIDDLE_MARK	0x3197
#define T_UTF_16_IDEOGRAPHIC_ANNOTATION_BOTTOM_MARK	0x3198
#define T_UTF_16_IDEOGRAPHIC_ANNOTATION_FIRST_MARK	0x3199
#define T_UTF_16_IDEOGRAPHIC_ANNOTATION_SECOND_MARK	0x319A
#define T_UTF_16_IDEOGRAPHIC_ANNOTATION_THIRD_MARK	0x319B
#define T_UTF_16_IDEOGRAPHIC_ANNOTATION_FOURTH_MARK	0x319C
#define T_UTF_16_IDEOGRAPHIC_ANNOTATION_HEAVEN_MARK	0x319D
#define T_UTF_16_IDEOGRAPHIC_ANNOTATION_EARTH_MARK	0x319E
#define T_UTF_16_IDEOGRAPHIC_ANNOTATION_MAN_MARK	0x319F
#define T_UTF_16_BOPOMOFO_LETTER_BU	0x31A0
#define T_UTF_16_BOPOMOFO_LETTER_ZI	0x31A1
#define T_UTF_16_BOPOMOFO_LETTER_JI	0x31A2
#define T_UTF_16_BOPOMOFO_LETTER_GU	0x31A3
#define T_UTF_16_BOPOMOFO_LETTER_EE	0x31A4
#define T_UTF_16_BOPOMOFO_LETTER_ENN	0x31A5
#define T_UTF_16_BOPOMOFO_LETTER_OO	0x31A6
#define T_UTF_16_BOPOMOFO_LETTER_ONN	0x31A7
#define T_UTF_16_BOPOMOFO_LETTER_IR	0x31A8
#define T_UTF_16_BOPOMOFO_LETTER_ANN	0x31A9
#define T_UTF_16_BOPOMOFO_LETTER_INN	0x31AA
#define T_UTF_16_BOPOMOFO_LETTER_UNN	0x31AB
#define T_UTF_16_BOPOMOFO_LETTER_IM	0x31AC
#define T_UTF_16_BOPOMOFO_LETTER_NGG	0x31AD
#define T_UTF_16_BOPOMOFO_LETTER_AINN	0x31AE
#define T_UTF_16_BOPOMOFO_LETTER_AUNN	0x31AF
#define T_UTF_16_BOPOMOFO_LETTER_AM	0x31B0
#define T_UTF_16_BOPOMOFO_LETTER_OM	0x31B1
#define T_UTF_16_BOPOMOFO_LETTER_ONG	0x31B2
#define T_UTF_16_BOPOMOFO_LETTER_INNN	0x31B3
#define T_UTF_16_BOPOMOFO_FINAL_LETTER_P	0x31B4
#define T_UTF_16_BOPOMOFO_FINAL_LETTER_T	0x31B5
#define T_UTF_16_BOPOMOFO_FINAL_LETTER_K	0x31B6
#define T_UTF_16_BOPOMOFO_FINAL_LETTER_H	0x31B7
#define T_UTF_16_PARENTHESIZED_HANGUL_KIYEOK	0x3200
#define T_UTF_16_PARENTHESIZED_HANGUL_NIEUN	0x3201
#define T_UTF_16_PARENTHESIZED_HANGUL_TIKEUT	0x3202
#define T_UTF_16_PARENTHESIZED_HANGUL_RIEUL	0x3203
#define T_UTF_16_PARENTHESIZED_HANGUL_MIEUM	0x3204
#define T_UTF_16_PARENTHESIZED_HANGUL_PIEUP	0x3205
#define T_UTF_16_PARENTHESIZED_HANGUL_SIOS	0x3206
#define T_UTF_16_PARENTHESIZED_HANGUL_IEUNG	0x3207
#define T_UTF_16_PARENTHESIZED_HANGUL_CIEUC	0x3208
#define T_UTF_16_PARENTHESIZED_HANGUL_CHIEUCH	0x3209
#define T_UTF_16_PARENTHESIZED_HANGUL_KHIEUKH	0x320A
#define T_UTF_16_PARENTHESIZED_HANGUL_THIEUTH	0x320B
#define T_UTF_16_PARENTHESIZED_HANGUL_PHIEUPH	0x320C
#define T_UTF_16_PARENTHESIZED_HANGUL_HIEUH	0x320D
#define T_UTF_16_PARENTHESIZED_HANGUL_KIYEOK_A	0x320E
#define T_UTF_16_PARENTHESIZED_HANGUL_NIEUN_A	0x320F
#define T_UTF_16_PARENTHESIZED_HANGUL_TIKEUT_A	0x3210
#define T_UTF_16_PARENTHESIZED_HANGUL_RIEUL_A	0x3211
#define T_UTF_16_PARENTHESIZED_HANGUL_MIEUM_A	0x3212
#define T_UTF_16_PARENTHESIZED_HANGUL_PIEUP_A	0x3213
#define T_UTF_16_PARENTHESIZED_HANGUL_SIOS_A	0x3214
#define T_UTF_16_PARENTHESIZED_HANGUL_IEUNG_A	0x3215
#define T_UTF_16_PARENTHESIZED_HANGUL_CIEUC_A	0x3216
#define T_UTF_16_PARENTHESIZED_HANGUL_CHIEUCH_A	0x3217
#define T_UTF_16_PARENTHESIZED_HANGUL_KHIEUKH_A	0x3218
#define T_UTF_16_PARENTHESIZED_HANGUL_THIEUTH_A	0x3219
#define T_UTF_16_PARENTHESIZED_HANGUL_PHIEUPH_A	0x321A
#define T_UTF_16_PARENTHESIZED_HANGUL_HIEUH_A	0x321B
#define T_UTF_16_PARENTHESIZED_HANGUL_CIEUC_U	0x321C
#define T_UTF_16_PARENTHESIZED_IDEOGRAPH_ONE	0x3220
#define T_UTF_16_PARENTHESIZED_IDEOGRAPH_TWO	0x3221
#define T_UTF_16_PARENTHESIZED_IDEOGRAPH_THREE	0x3222
#define T_UTF_16_PARENTHESIZED_IDEOGRAPH_FOUR	0x3223
#define T_UTF_16_PARENTHESIZED_IDEOGRAPH_FIVE	0x3224
#define T_UTF_16_PARENTHESIZED_IDEOGRAPH_SIX	0x3225
#define T_UTF_16_PARENTHESIZED_IDEOGRAPH_SEVEN	0x3226
#define T_UTF_16_PARENTHESIZED_IDEOGRAPH_EIGHT	0x3227
#define T_UTF_16_PARENTHESIZED_IDEOGRAPH_NINE	0x3228
#define T_UTF_16_PARENTHESIZED_IDEOGRAPH_TEN	0x3229
#define T_UTF_16_PARENTHESIZED_IDEOGRAPH_MOON	0x322A
#define T_UTF_16_PARENTHESIZED_IDEOGRAPH_FIRE	0x322B
#define T_UTF_16_PARENTHESIZED_IDEOGRAPH_WATER	0x322C
#define T_UTF_16_PARENTHESIZED_IDEOGRAPH_WOOD	0x322D
#define T_UTF_16_PARENTHESIZED_IDEOGRAPH_METAL	0x322E
#define T_UTF_16_PARENTHESIZED_IDEOGRAPH_EARTH	0x322F
#define T_UTF_16_PARENTHESIZED_IDEOGRAPH_SUN	0x3230
#define T_UTF_16_PARENTHESIZED_IDEOGRAPH_STOCK	0x3231
#define T_UTF_16_PARENTHESIZED_IDEOGRAPH_HAVE	0x3232
#define T_UTF_16_PARENTHESIZED_IDEOGRAPH_SOCIETY	0x3233
#define T_UTF_16_PARENTHESIZED_IDEOGRAPH_NAME	0x3234
#define T_UTF_16_PARENTHESIZED_IDEOGRAPH_SPECIAL	0x3235
#define T_UTF_16_PARENTHESIZED_IDEOGRAPH_FINANCIAL	0x3236
#define T_UTF_16_PARENTHESIZED_IDEOGRAPH_CONGRATULATION	0x3237
#define T_UTF_16_PARENTHESIZED_IDEOGRAPH_LABOR	0x3238
#define T_UTF_16_PARENTHESIZED_IDEOGRAPH_REPRESENT	0x3239
#define T_UTF_16_PARENTHESIZED_IDEOGRAPH_CALL	0x323A
#define T_UTF_16_PARENTHESIZED_IDEOGRAPH_STUDY	0x323B
#define T_UTF_16_PARENTHESIZED_IDEOGRAPH_SUPERVISE	0x323C
#define T_UTF_16_PARENTHESIZED_IDEOGRAPH_ENTERPRISE	0x323D
#define T_UTF_16_PARENTHESIZED_IDEOGRAPH_RESOURCE	0x323E
#define T_UTF_16_PARENTHESIZED_IDEOGRAPH_ALLIANCE	0x323F
#define T_UTF_16_PARENTHESIZED_IDEOGRAPH_FESTIVAL	0x3240
#define T_UTF_16_PARENTHESIZED_IDEOGRAPH_REST	0x3241
#define T_UTF_16_PARENTHESIZED_IDEOGRAPH_SELF	0x3242
#define T_UTF_16_PARENTHESIZED_IDEOGRAPH_REACH	0x3243
#define T_UTF_16_CIRCLED_HANGUL_KIYEOK	0x3260
#define T_UTF_16_CIRCLED_HANGUL_NIEUN	0x3261
#define T_UTF_16_CIRCLED_HANGUL_TIKEUT	0x3262
#define T_UTF_16_CIRCLED_HANGUL_RIEUL	0x3263
#define T_UTF_16_CIRCLED_HANGUL_MIEUM	0x3264
#define T_UTF_16_CIRCLED_HANGUL_PIEUP	0x3265
#define T_UTF_16_CIRCLED_HANGUL_SIOS	0x3266
#define T_UTF_16_CIRCLED_HANGUL_IEUNG	0x3267
#define T_UTF_16_CIRCLED_HANGUL_CIEUC	0x3268
#define T_UTF_16_CIRCLED_HANGUL_CHIEUCH	0x3269
#define T_UTF_16_CIRCLED_HANGUL_KHIEUKH	0x326A
#define T_UTF_16_CIRCLED_HANGUL_THIEUTH	0x326B
#define T_UTF_16_CIRCLED_HANGUL_PHIEUPH	0x326C
#define T_UTF_16_CIRCLED_HANGUL_HIEUH	0x326D
#define T_UTF_16_CIRCLED_HANGUL_KIYEOK_A	0x326E
#define T_UTF_16_CIRCLED_HANGUL_NIEUN_A	0x326F
#define T_UTF_16_CIRCLED_HANGUL_TIKEUT_A	0x3270
#define T_UTF_16_CIRCLED_HANGUL_RIEUL_A	0x3271
#define T_UTF_16_CIRCLED_HANGUL_MIEUM_A	0x3272
#define T_UTF_16_CIRCLED_HANGUL_PIEUP_A	0x3273
#define T_UTF_16_CIRCLED_HANGUL_SIOS_A	0x3274
#define T_UTF_16_CIRCLED_HANGUL_IEUNG_A	0x3275
#define T_UTF_16_CIRCLED_HANGUL_CIEUC_A	0x3276
#define T_UTF_16_CIRCLED_HANGUL_CHIEUCH_A	0x3277
#define T_UTF_16_CIRCLED_HANGUL_KHIEUKH_A	0x3278
#define T_UTF_16_CIRCLED_HANGUL_THIEUTH_A	0x3279
#define T_UTF_16_CIRCLED_HANGUL_PHIEUPH_A	0x327A
#define T_UTF_16_CIRCLED_HANGUL_HIEUH_A	0x327B
#define T_UTF_16_KOREAN_STANDARD_SYMBOL	0x327F
#define T_UTF_16_CIRCLED_IDEOGRAPH_ONE	0x3280
#define T_UTF_16_CIRCLED_IDEOGRAPH_TWO	0x3281
#define T_UTF_16_CIRCLED_IDEOGRAPH_THREE	0x3282
#define T_UTF_16_CIRCLED_IDEOGRAPH_FOUR	0x3283
#define T_UTF_16_CIRCLED_IDEOGRAPH_FIVE	0x3284
#define T_UTF_16_CIRCLED_IDEOGRAPH_SIX	0x3285
#define T_UTF_16_CIRCLED_IDEOGRAPH_SEVEN	0x3286
#define T_UTF_16_CIRCLED_IDEOGRAPH_EIGHT	0x3287
#define T_UTF_16_CIRCLED_IDEOGRAPH_NINE	0x3288
#define T_UTF_16_CIRCLED_IDEOGRAPH_TEN	0x3289
#define T_UTF_16_CIRCLED_IDEOGRAPH_MOON	0x328A
#define T_UTF_16_CIRCLED_IDEOGRAPH_FIRE	0x328B
#define T_UTF_16_CIRCLED_IDEOGRAPH_WATER	0x328C
#define T_UTF_16_CIRCLED_IDEOGRAPH_WOOD	0x328D
#define T_UTF_16_CIRCLED_IDEOGRAPH_METAL	0x328E
#define T_UTF_16_CIRCLED_IDEOGRAPH_EARTH	0x328F
#define T_UTF_16_CIRCLED_IDEOGRAPH_SUN	0x3290
#define T_UTF_16_CIRCLED_IDEOGRAPH_STOCK	0x3291
#define T_UTF_16_CIRCLED_IDEOGRAPH_HAVE	0x3292
#define T_UTF_16_CIRCLED_IDEOGRAPH_SOCIETY	0x3293
#define T_UTF_16_CIRCLED_IDEOGRAPH_NAME	0x3294
#define T_UTF_16_CIRCLED_IDEOGRAPH_SPECIAL	0x3295
#define T_UTF_16_CIRCLED_IDEOGRAPH_FINANCIAL	0x3296
#define T_UTF_16_CIRCLED_IDEOGRAPH_CONGRATULATION	0x3297
#define T_UTF_16_CIRCLED_IDEOGRAPH_LABOR	0x3298
#define T_UTF_16_CIRCLED_IDEOGRAPH_SECRET	0x3299
#define T_UTF_16_CIRCLED_IDEOGRAPH_MALE	0x329A
#define T_UTF_16_CIRCLED_IDEOGRAPH_FEMALE	0x329B
#define T_UTF_16_CIRCLED_IDEOGRAPH_SUITABLE	0x329C
#define T_UTF_16_CIRCLED_IDEOGRAPH_EXCELLENT	0x329D
#define T_UTF_16_CIRCLED_IDEOGRAPH_PRINT	0x329E
#define T_UTF_16_CIRCLED_IDEOGRAPH_ATTENTION	0x329F
#define T_UTF_16_CIRCLED_IDEOGRAPH_ITEM	0x32A0
#define T_UTF_16_CIRCLED_IDEOGRAPH_REST	0x32A1
#define T_UTF_16_CIRCLED_IDEOGRAPH_COPY	0x32A2
#define T_UTF_16_CIRCLED_IDEOGRAPH_CORRECT	0x32A3
#define T_UTF_16_CIRCLED_IDEOGRAPH_HIGH	0x32A4
#define T_UTF_16_CIRCLED_IDEOGRAPH_CENTRE	0x32A5
#define T_UTF_16_CIRCLED_IDEOGRAPH_LOW	0x32A6
#define T_UTF_16_CIRCLED_IDEOGRAPH_LEFT	0x32A7
#define T_UTF_16_CIRCLED_IDEOGRAPH_RIGHT	0x32A8
#define T_UTF_16_CIRCLED_IDEOGRAPH_MEDICINE	0x32A9
#define T_UTF_16_CIRCLED_IDEOGRAPH_RELIGION	0x32AA
#define T_UTF_16_CIRCLED_IDEOGRAPH_STUDY	0x32AB
#define T_UTF_16_CIRCLED_IDEOGRAPH_SUPERVISE	0x32AC
#define T_UTF_16_CIRCLED_IDEOGRAPH_ENTERPRISE	0x32AD
#define T_UTF_16_CIRCLED_IDEOGRAPH_RESOURCE	0x32AE
#define T_UTF_16_CIRCLED_IDEOGRAPH_ALLIANCE	0x32AF
#define T_UTF_16_CIRCLED_IDEOGRAPH_NIGHT	0x32B0
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_JANUARY	0x32C0
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_FEBRUARY	0x32C1
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_MARCH	0x32C2
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_APRIL	0x32C3
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_MAY	0x32C4
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_JUNE	0x32C5
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_JULY	0x32C6
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_AUGUST	0x32C7
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_SEPTEMBER	0x32C8
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_OCTOBER	0x32C9
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_NOVEMBER	0x32CA
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DECEMBER	0x32CB
#define T_UTF_16_CIRCLED_KATAKANA_A	0x32D0
#define T_UTF_16_CIRCLED_KATAKANA_I	0x32D1
#define T_UTF_16_CIRCLED_KATAKANA_U	0x32D2
#define T_UTF_16_CIRCLED_KATAKANA_E	0x32D3
#define T_UTF_16_CIRCLED_KATAKANA_O	0x32D4
#define T_UTF_16_CIRCLED_KATAKANA_KA	0x32D5
#define T_UTF_16_CIRCLED_KATAKANA_KI	0x32D6
#define T_UTF_16_CIRCLED_KATAKANA_KU	0x32D7
#define T_UTF_16_CIRCLED_KATAKANA_KE	0x32D8
#define T_UTF_16_CIRCLED_KATAKANA_KO	0x32D9
#define T_UTF_16_CIRCLED_KATAKANA_SA	0x32DA
#define T_UTF_16_CIRCLED_KATAKANA_SI	0x32DB
#define T_UTF_16_CIRCLED_KATAKANA_SU	0x32DC
#define T_UTF_16_CIRCLED_KATAKANA_SE	0x32DD
#define T_UTF_16_CIRCLED_KATAKANA_SO	0x32DE
#define T_UTF_16_CIRCLED_KATAKANA_TA	0x32DF
#define T_UTF_16_CIRCLED_KATAKANA_TI	0x32E0
#define T_UTF_16_CIRCLED_KATAKANA_TU	0x32E1
#define T_UTF_16_CIRCLED_KATAKANA_TE	0x32E2
#define T_UTF_16_CIRCLED_KATAKANA_TO	0x32E3
#define T_UTF_16_CIRCLED_KATAKANA_NA	0x32E4
#define T_UTF_16_CIRCLED_KATAKANA_NI	0x32E5
#define T_UTF_16_CIRCLED_KATAKANA_NU	0x32E6
#define T_UTF_16_CIRCLED_KATAKANA_NE	0x32E7
#define T_UTF_16_CIRCLED_KATAKANA_NO	0x32E8
#define T_UTF_16_CIRCLED_KATAKANA_HA	0x32E9
#define T_UTF_16_CIRCLED_KATAKANA_HI	0x32EA
#define T_UTF_16_CIRCLED_KATAKANA_HU	0x32EB
#define T_UTF_16_CIRCLED_KATAKANA_HE	0x32EC
#define T_UTF_16_CIRCLED_KATAKANA_HO	0x32ED
#define T_UTF_16_CIRCLED_KATAKANA_MA	0x32EE
#define T_UTF_16_CIRCLED_KATAKANA_MI	0x32EF
#define T_UTF_16_CIRCLED_KATAKANA_MU	0x32F0
#define T_UTF_16_CIRCLED_KATAKANA_ME	0x32F1
#define T_UTF_16_CIRCLED_KATAKANA_MO	0x32F2
#define T_UTF_16_CIRCLED_KATAKANA_YA	0x32F3
#define T_UTF_16_CIRCLED_KATAKANA_YU	0x32F4
#define T_UTF_16_CIRCLED_KATAKANA_YO	0x32F5
#define T_UTF_16_CIRCLED_KATAKANA_RA	0x32F6
#define T_UTF_16_CIRCLED_KATAKANA_RI	0x32F7
#define T_UTF_16_CIRCLED_KATAKANA_RU	0x32F8
#define T_UTF_16_CIRCLED_KATAKANA_RE	0x32F9
#define T_UTF_16_CIRCLED_KATAKANA_RO	0x32FA
#define T_UTF_16_CIRCLED_KATAKANA_WA	0x32FB
#define T_UTF_16_CIRCLED_KATAKANA_WI	0x32FC
#define T_UTF_16_CIRCLED_KATAKANA_WE	0x32FD
#define T_UTF_16_CIRCLED_KATAKANA_WO	0x32FE
#define T_UTF_16_SQUARE_APAATO	0x3300
#define T_UTF_16_SQUARE_ARUHUA	0x3301
#define T_UTF_16_SQUARE_ANPEA	0x3302
#define T_UTF_16_SQUARE_AARU	0x3303
#define T_UTF_16_SQUARE_ININGU	0x3304
#define T_UTF_16_SQUARE_INTI	0x3305
#define T_UTF_16_SQUARE_UON	0x3306
#define T_UTF_16_SQUARE_ESUKUUDO	0x3307
#define T_UTF_16_SQUARE_EEKAA	0x3308
#define T_UTF_16_SQUARE_ONSU	0x3309
#define T_UTF_16_SQUARE_OOMU	0x330A
#define T_UTF_16_SQUARE_KAIRI	0x330B
#define T_UTF_16_SQUARE_KARATTO	0x330C
#define T_UTF_16_SQUARE_KARORII	0x330D
#define T_UTF_16_SQUARE_GARON	0x330E
#define T_UTF_16_SQUARE_GANMA	0x330F
#define T_UTF_16_SQUARE_GIGA	0x3310
#define T_UTF_16_SQUARE_GINII	0x3311
#define T_UTF_16_SQUARE_KYURII	0x3312
#define T_UTF_16_SQUARE_GIRUDAA	0x3313
#define T_UTF_16_SQUARE_KIRO	0x3314
#define T_UTF_16_SQUARE_KIROGURAMU	0x3315
#define T_UTF_16_SQUARE_KIROMEETORU	0x3316
#define T_UTF_16_SQUARE_KIROWATTO	0x3317
#define T_UTF_16_SQUARE_GURAMU	0x3318
#define T_UTF_16_SQUARE_GURAMUTON	0x3319
#define T_UTF_16_SQUARE_KURUZEIRO	0x331A
#define T_UTF_16_SQUARE_KUROONE	0x331B
#define T_UTF_16_SQUARE_KEESU	0x331C
#define T_UTF_16_SQUARE_KORUNA	0x331D
#define T_UTF_16_SQUARE_KOOPO	0x331E
#define T_UTF_16_SQUARE_SAIKURU	0x331F
#define T_UTF_16_SQUARE_SANTIIMU	0x3320
#define T_UTF_16_SQUARE_SIRINGU	0x3321
#define T_UTF_16_SQUARE_SENTI	0x3322
#define T_UTF_16_SQUARE_SENTO	0x3323
#define T_UTF_16_SQUARE_DAASU	0x3324
#define T_UTF_16_SQUARE_DESI	0x3325
#define T_UTF_16_SQUARE_DORU	0x3326
#define T_UTF_16_SQUARE_TON	0x3327
#define T_UTF_16_SQUARE_NANO	0x3328
#define T_UTF_16_SQUARE_NOTTO	0x3329
#define T_UTF_16_SQUARE_HAITU	0x332A
#define T_UTF_16_SQUARE_PAASENTO	0x332B
#define T_UTF_16_SQUARE_PAATU	0x332C
#define T_UTF_16_SQUARE_BAARERU	0x332D
#define T_UTF_16_SQUARE_PIASUTORU	0x332E
#define T_UTF_16_SQUARE_PIKURU	0x332F
#define T_UTF_16_SQUARE_PIKO	0x3330
#define T_UTF_16_SQUARE_BIRU	0x3331
#define T_UTF_16_SQUARE_HUARADDO	0x3332
#define T_UTF_16_SQUARE_HUIITO	0x3333
#define T_UTF_16_SQUARE_BUSSYERU	0x3334
#define T_UTF_16_SQUARE_HURAN	0x3335
#define T_UTF_16_SQUARE_HEKUTAARU	0x3336
#define T_UTF_16_SQUARE_PESO	0x3337
#define T_UTF_16_SQUARE_PENIHI	0x3338
#define T_UTF_16_SQUARE_HERUTU	0x3339
#define T_UTF_16_SQUARE_PENSU	0x333A
#define T_UTF_16_SQUARE_PEEZI	0x333B
#define T_UTF_16_SQUARE_BEETA	0x333C
#define T_UTF_16_SQUARE_POINTO	0x333D
#define T_UTF_16_SQUARE_BORUTO	0x333E
#define T_UTF_16_SQUARE_HON	0x333F
#define T_UTF_16_SQUARE_PONDO	0x3340
#define T_UTF_16_SQUARE_HOORU	0x3341
#define T_UTF_16_SQUARE_HOON	0x3342
#define T_UTF_16_SQUARE_MAIKURO	0x3343
#define T_UTF_16_SQUARE_MAIRU	0x3344
#define T_UTF_16_SQUARE_MAHHA	0x3345
#define T_UTF_16_SQUARE_MARUKU	0x3346
#define T_UTF_16_SQUARE_MANSYON	0x3347
#define T_UTF_16_SQUARE_MIKURON	0x3348
#define T_UTF_16_SQUARE_MIRI	0x3349
#define T_UTF_16_SQUARE_MIRIBAARU	0x334A
#define T_UTF_16_SQUARE_MEGA	0x334B
#define T_UTF_16_SQUARE_MEGATON	0x334C
#define T_UTF_16_SQUARE_MEETORU	0x334D
#define T_UTF_16_SQUARE_YAADO	0x334E
#define T_UTF_16_SQUARE_YAARU	0x334F
#define T_UTF_16_SQUARE_YUAN	0x3350
#define T_UTF_16_SQUARE_RITTORU	0x3351
#define T_UTF_16_SQUARE_RIRA	0x3352
#define T_UTF_16_SQUARE_RUPII	0x3353
#define T_UTF_16_SQUARE_RUUBURU	0x3354
#define T_UTF_16_SQUARE_REMU	0x3355
#define T_UTF_16_SQUARE_RENTOGEN	0x3356
#define T_UTF_16_SQUARE_WATTO	0x3357
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_ZERO	0x3358
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_ONE	0x3359
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_TWO	0x335A
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_THREE	0x335B
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_FOUR	0x335C
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_FIVE	0x335D
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_SIX	0x335E
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_SEVEN	0x335F
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_EIGHT	0x3360
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_NINE	0x3361
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_TEN	0x3362
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_ELEVEN	0x3363
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_TWELVE	0x3364
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_THIRTEEN	0x3365
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_FOURTEEN	0x3366
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_FIFTEEN	0x3367
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_SIXTEEN	0x3368
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_SEVENTEEN	0x3369
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_EIGHTEEN	0x336A
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_NINETEEN	0x336B
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_TWENTY	0x336C
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_TWENTY_ONE	0x336D
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_TWENTY_TWO	0x336E
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_TWENTY_THREE	0x336F
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_TWENTY_FOUR	0x3370
#define T_UTF_16_SQUARE_HPA	0x3371
#define T_UTF_16_SQUARE_DA	0x3372
#define T_UTF_16_SQUARE_AU	0x3373
#define T_UTF_16_SQUARE_BAR	0x3374
#define T_UTF_16_SQUARE_OV	0x3375
#define T_UTF_16_SQUARE_PC	0x3376
#define T_UTF_16_SQUARE_ERA_NAME_HEISEI	0x337B
#define T_UTF_16_SQUARE_ERA_NAME_SYOUWA	0x337C
#define T_UTF_16_SQUARE_ERA_NAME_TAISYOU	0x337D
#define T_UTF_16_SQUARE_ERA_NAME_MEIZI	0x337E
#define T_UTF_16_SQUARE_CORPORATION	0x337F
#define T_UTF_16_SQUARE_PA_AMPS	0x3380
#define T_UTF_16_SQUARE_NA	0x3381
#define T_UTF_16_SQUARE_MU_A	0x3382
#define T_UTF_16_SQUARE_MA	0x3383
#define T_UTF_16_SQUARE_KA	0x3384
#define T_UTF_16_SQUARE_KB	0x3385
#define T_UTF_16_SQUARE_MB	0x3386
#define T_UTF_16_SQUARE_GB	0x3387
#define T_UTF_16_SQUARE_CAL	0x3388
#define T_UTF_16_SQUARE_KCAL	0x3389
#define T_UTF_16_SQUARE_PF	0x338A
#define T_UTF_16_SQUARE_NF	0x338B
#define T_UTF_16_SQUARE_MU_F	0x338C
#define T_UTF_16_SQUARE_MU_G	0x338D
#define T_UTF_16_SQUARE_MG	0x338E
#define T_UTF_16_SQUARE_KG	0x338F
#define T_UTF_16_SQUARE_HZ	0x3390
#define T_UTF_16_SQUARE_KHZ	0x3391
#define T_UTF_16_SQUARE_MHZ	0x3392
#define T_UTF_16_SQUARE_GHZ	0x3393
#define T_UTF_16_SQUARE_THZ	0x3394
#define T_UTF_16_SQUARE_MU_L	0x3395
#define T_UTF_16_SQUARE_ML	0x3396
#define T_UTF_16_SQUARE_DL	0x3397
#define T_UTF_16_SQUARE_KL	0x3398
#define T_UTF_16_SQUARE_FM	0x3399
#define T_UTF_16_SQUARE_NM	0x339A
#define T_UTF_16_SQUARE_MU_M	0x339B
#define T_UTF_16_SQUARE_MM	0x339C
#define T_UTF_16_SQUARE_CM	0x339D
#define T_UTF_16_SQUARE_KM	0x339E
#define T_UTF_16_SQUARE_MM_SQUARED	0x339F
#define T_UTF_16_SQUARE_CM_SQUARED	0x33A0
#define T_UTF_16_SQUARE_M_SQUARED	0x33A1
#define T_UTF_16_SQUARE_KM_SQUARED	0x33A2
#define T_UTF_16_SQUARE_MM_CUBED	0x33A3
#define T_UTF_16_SQUARE_CM_CUBED	0x33A4
#define T_UTF_16_SQUARE_M_CUBED	0x33A5
#define T_UTF_16_SQUARE_KM_CUBED	0x33A6
#define T_UTF_16_SQUARE_M_OVER_S	0x33A7
#define T_UTF_16_SQUARE_M_OVER_S_SQUARED	0x33A8
#define T_UTF_16_SQUARE_PA	0x33A9
#define T_UTF_16_SQUARE_KPA	0x33AA
#define T_UTF_16_SQUARE_MPA	0x33AB
#define T_UTF_16_SQUARE_GPA	0x33AC
#define T_UTF_16_SQUARE_RAD	0x33AD
#define T_UTF_16_SQUARE_RAD_OVER_S	0x33AE
#define T_UTF_16_SQUARE_RAD_OVER_S_SQUARED	0x33AF
#define T_UTF_16_SQUARE_PS	0x33B0
#define T_UTF_16_SQUARE_NS	0x33B1
#define T_UTF_16_SQUARE_MU_S	0x33B2
#define T_UTF_16_SQUARE_MS	0x33B3
#define T_UTF_16_SQUARE_PV	0x33B4
#define T_UTF_16_SQUARE_NV	0x33B5
#define T_UTF_16_SQUARE_MU_V	0x33B6
#define T_UTF_16_SQUARE_MV	0x33B7
#define T_UTF_16_SQUARE_KV	0x33B8
#define T_UTF_16_SQUARE_MV_MEGA	0x33B9
#define T_UTF_16_SQUARE_PW	0x33BA
#define T_UTF_16_SQUARE_NW	0x33BB
#define T_UTF_16_SQUARE_MU_W	0x33BC
#define T_UTF_16_SQUARE_MW	0x33BD
#define T_UTF_16_SQUARE_KW	0x33BE
#define T_UTF_16_SQUARE_MW_MEGA	0x33BF
#define T_UTF_16_SQUARE_K_OHM	0x33C0
#define T_UTF_16_SQUARE_M_OHM	0x33C1
#define T_UTF_16_SQUARE_AM	0x33C2
#define T_UTF_16_SQUARE_BQ	0x33C3
#define T_UTF_16_SQUARE_CC	0x33C4
#define T_UTF_16_SQUARE_CD	0x33C5
#define T_UTF_16_SQUARE_C_OVER_KG	0x33C6
#define T_UTF_16_SQUARE_CO	0x33C7
#define T_UTF_16_SQUARE_DB	0x33C8
#define T_UTF_16_SQUARE_GY	0x33C9
#define T_UTF_16_SQUARE_HA	0x33CA
#define T_UTF_16_SQUARE_HP	0x33CB
#define T_UTF_16_SQUARE_IN	0x33CC
#define T_UTF_16_SQUARE_KK	0x33CD
#define T_UTF_16_SQUARE_KM_CAPITAL	0x33CE
#define T_UTF_16_SQUARE_KT	0x33CF
#define T_UTF_16_SQUARE_LM	0x33D0
#define T_UTF_16_SQUARE_LN	0x33D1
#define T_UTF_16_SQUARE_LOG	0x33D2
#define T_UTF_16_SQUARE_LX	0x33D3
#define T_UTF_16_SQUARE_MB_SMALL	0x33D4
#define T_UTF_16_SQUARE_MIL	0x33D5
#define T_UTF_16_SQUARE_MOL	0x33D6
#define T_UTF_16_SQUARE_PH	0x33D7
#define T_UTF_16_SQUARE_PM	0x33D8
#define T_UTF_16_SQUARE_PPM	0x33D9
#define T_UTF_16_SQUARE_PR	0x33DA
#define T_UTF_16_SQUARE_SR	0x33DB
#define T_UTF_16_SQUARE_SV	0x33DC
#define T_UTF_16_SQUARE_WB	0x33DD
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_ONE	0x33E0
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWO	0x33E1
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_THREE	0x33E2
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_FOUR	0x33E3
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_FIVE	0x33E4
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_SIX	0x33E5
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_SEVEN	0x33E6
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_EIGHT	0x33E7
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_NINE	0x33E8
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TEN	0x33E9
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_ELEVEN	0x33EA
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWELVE	0x33EB
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_THIRTEEN	0x33EC
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_FOURTEEN	0x33ED
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_FIFTEEN	0x33EE
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_SIXTEEN	0x33EF
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_SEVENTEEN	0x33F0
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_EIGHTEEN	0x33F1
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_NINETEEN	0x33F2
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY	0x33F3
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY_ONE	0x33F4
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY_TWO	0x33F5
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY_THREE	0x33F6
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY_FOUR	0x33F7
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY_FIVE	0x33F8
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY_SIX	0x33F9
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY_SEVEN	0x33FA
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY_EIGHT	0x33FB
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY_NINE	0x33FC
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_THIRTY	0x33FD
#define T_UTF_16_IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_THIRTY_ONE	0x33FE
#define T_UTF_16_CJK_Ideograph_Extension_A_First	0x3400
#define T_UTF_16_CJK_Ideograph_Extension_A_Last	0x4DB5
#define T_UTF_16_CJK_Ideograph_First	0x4E00
#define T_UTF_16_CJK_Ideograph_Last	0x9FA5
#define T_UTF_16_YI_SYLLABLE_IT	0xA000
#define T_UTF_16_YI_SYLLABLE_IX	0xA001
#define T_UTF_16_YI_SYLLABLE_I	0xA002
#define T_UTF_16_YI_SYLLABLE_IP	0xA003
#define T_UTF_16_YI_SYLLABLE_IET	0xA004
#define T_UTF_16_YI_SYLLABLE_IEX	0xA005
#define T_UTF_16_YI_SYLLABLE_IE	0xA006
#define T_UTF_16_YI_SYLLABLE_IEP	0xA007
#define T_UTF_16_YI_SYLLABLE_AT	0xA008
#define T_UTF_16_YI_SYLLABLE_AX	0xA009
#define T_UTF_16_YI_SYLLABLE_A	0xA00A
#define T_UTF_16_YI_SYLLABLE_AP	0xA00B
#define T_UTF_16_YI_SYLLABLE_UOX	0xA00C
#define T_UTF_16_YI_SYLLABLE_UO	0xA00D
#define T_UTF_16_YI_SYLLABLE_UOP	0xA00E
#define T_UTF_16_YI_SYLLABLE_OT	0xA00F
#define T_UTF_16_YI_SYLLABLE_OX	0xA010
#define T_UTF_16_YI_SYLLABLE_O	0xA011
#define T_UTF_16_YI_SYLLABLE_OP	0xA012
#define T_UTF_16_YI_SYLLABLE_EX	0xA013
#define T_UTF_16_YI_SYLLABLE_E	0xA014
#define T_UTF_16_YI_SYLLABLE_WU	0xA015
#define T_UTF_16_YI_SYLLABLE_BIT	0xA016
#define T_UTF_16_YI_SYLLABLE_BIX	0xA017
#define T_UTF_16_YI_SYLLABLE_BI	0xA018
#define T_UTF_16_YI_SYLLABLE_BIP	0xA019
#define T_UTF_16_YI_SYLLABLE_BIET	0xA01A
#define T_UTF_16_YI_SYLLABLE_BIEX	0xA01B
#define T_UTF_16_YI_SYLLABLE_BIE	0xA01C
#define T_UTF_16_YI_SYLLABLE_BIEP	0xA01D
#define T_UTF_16_YI_SYLLABLE_BAT	0xA01E
#define T_UTF_16_YI_SYLLABLE_BAX	0xA01F
#define T_UTF_16_YI_SYLLABLE_BA	0xA020
#define T_UTF_16_YI_SYLLABLE_BAP	0xA021
#define T_UTF_16_YI_SYLLABLE_BUOX	0xA022
#define T_UTF_16_YI_SYLLABLE_BUO	0xA023
#define T_UTF_16_YI_SYLLABLE_BUOP	0xA024
#define T_UTF_16_YI_SYLLABLE_BOT	0xA025
#define T_UTF_16_YI_SYLLABLE_BOX	0xA026
#define T_UTF_16_YI_SYLLABLE_BO	0xA027
#define T_UTF_16_YI_SYLLABLE_BOP	0xA028
#define T_UTF_16_YI_SYLLABLE_BEX	0xA029
#define T_UTF_16_YI_SYLLABLE_BE	0xA02A
#define T_UTF_16_YI_SYLLABLE_BEP	0xA02B
#define T_UTF_16_YI_SYLLABLE_BUT	0xA02C
#define T_UTF_16_YI_SYLLABLE_BUX	0xA02D
#define T_UTF_16_YI_SYLLABLE_BU	0xA02E
#define T_UTF_16_YI_SYLLABLE_BUP	0xA02F
#define T_UTF_16_YI_SYLLABLE_BURX	0xA030
#define T_UTF_16_YI_SYLLABLE_BUR	0xA031
#define T_UTF_16_YI_SYLLABLE_BYT	0xA032
#define T_UTF_16_YI_SYLLABLE_BYX	0xA033
#define T_UTF_16_YI_SYLLABLE_BY	0xA034
#define T_UTF_16_YI_SYLLABLE_BYP	0xA035
#define T_UTF_16_YI_SYLLABLE_BYRX	0xA036
#define T_UTF_16_YI_SYLLABLE_BYR	0xA037
#define T_UTF_16_YI_SYLLABLE_PIT	0xA038
#define T_UTF_16_YI_SYLLABLE_PIX	0xA039
#define T_UTF_16_YI_SYLLABLE_PI	0xA03A
#define T_UTF_16_YI_SYLLABLE_PIP	0xA03B
#define T_UTF_16_YI_SYLLABLE_PIEX	0xA03C
#define T_UTF_16_YI_SYLLABLE_PIE	0xA03D
#define T_UTF_16_YI_SYLLABLE_PIEP	0xA03E
#define T_UTF_16_YI_SYLLABLE_PAT	0xA03F
#define T_UTF_16_YI_SYLLABLE_PAX	0xA040
#define T_UTF_16_YI_SYLLABLE_PA	0xA041
#define T_UTF_16_YI_SYLLABLE_PAP	0xA042
#define T_UTF_16_YI_SYLLABLE_PUOX	0xA043
#define T_UTF_16_YI_SYLLABLE_PUO	0xA044
#define T_UTF_16_YI_SYLLABLE_PUOP	0xA045
#define T_UTF_16_YI_SYLLABLE_POT	0xA046
#define T_UTF_16_YI_SYLLABLE_POX	0xA047
#define T_UTF_16_YI_SYLLABLE_PO	0xA048
#define T_UTF_16_YI_SYLLABLE_POP	0xA049
#define T_UTF_16_YI_SYLLABLE_PUT	0xA04A
#define T_UTF_16_YI_SYLLABLE_PUX	0xA04B
#define T_UTF_16_YI_SYLLABLE_PU	0xA04C
#define T_UTF_16_YI_SYLLABLE_PUP	0xA04D
#define T_UTF_16_YI_SYLLABLE_PURX	0xA04E
#define T_UTF_16_YI_SYLLABLE_PUR	0xA04F
#define T_UTF_16_YI_SYLLABLE_PYT	0xA050
#define T_UTF_16_YI_SYLLABLE_PYX	0xA051
#define T_UTF_16_YI_SYLLABLE_PY	0xA052
#define T_UTF_16_YI_SYLLABLE_PYP	0xA053
#define T_UTF_16_YI_SYLLABLE_PYRX	0xA054
#define T_UTF_16_YI_SYLLABLE_PYR	0xA055
#define T_UTF_16_YI_SYLLABLE_BBIT	0xA056
#define T_UTF_16_YI_SYLLABLE_BBIX	0xA057
#define T_UTF_16_YI_SYLLABLE_BBI	0xA058
#define T_UTF_16_YI_SYLLABLE_BBIP	0xA059
#define T_UTF_16_YI_SYLLABLE_BBIET	0xA05A
#define T_UTF_16_YI_SYLLABLE_BBIEX	0xA05B
#define T_UTF_16_YI_SYLLABLE_BBIE	0xA05C
#define T_UTF_16_YI_SYLLABLE_BBIEP	0xA05D
#define T_UTF_16_YI_SYLLABLE_BBAT	0xA05E
#define T_UTF_16_YI_SYLLABLE_BBAX	0xA05F
#define T_UTF_16_YI_SYLLABLE_BBA	0xA060
#define T_UTF_16_YI_SYLLABLE_BBAP	0xA061
#define T_UTF_16_YI_SYLLABLE_BBUOX	0xA062
#define T_UTF_16_YI_SYLLABLE_BBUO	0xA063
#define T_UTF_16_YI_SYLLABLE_BBUOP	0xA064
#define T_UTF_16_YI_SYLLABLE_BBOT	0xA065
#define T_UTF_16_YI_SYLLABLE_BBOX	0xA066
#define T_UTF_16_YI_SYLLABLE_BBO	0xA067
#define T_UTF_16_YI_SYLLABLE_BBOP	0xA068
#define T_UTF_16_YI_SYLLABLE_BBEX	0xA069
#define T_UTF_16_YI_SYLLABLE_BBE	0xA06A
#define T_UTF_16_YI_SYLLABLE_BBEP	0xA06B
#define T_UTF_16_YI_SYLLABLE_BBUT	0xA06C
#define T_UTF_16_YI_SYLLABLE_BBUX	0xA06D
#define T_UTF_16_YI_SYLLABLE_BBU	0xA06E
#define T_UTF_16_YI_SYLLABLE_BBUP	0xA06F
#define T_UTF_16_YI_SYLLABLE_BBURX	0xA070
#define T_UTF_16_YI_SYLLABLE_BBUR	0xA071
#define T_UTF_16_YI_SYLLABLE_BBYT	0xA072
#define T_UTF_16_YI_SYLLABLE_BBYX	0xA073
#define T_UTF_16_YI_SYLLABLE_BBY	0xA074
#define T_UTF_16_YI_SYLLABLE_BBYP	0xA075
#define T_UTF_16_YI_SYLLABLE_NBIT	0xA076
#define T_UTF_16_YI_SYLLABLE_NBIX	0xA077
#define T_UTF_16_YI_SYLLABLE_NBI	0xA078
#define T_UTF_16_YI_SYLLABLE_NBIP	0xA079
#define T_UTF_16_YI_SYLLABLE_NBIEX	0xA07A
#define T_UTF_16_YI_SYLLABLE_NBIE	0xA07B
#define T_UTF_16_YI_SYLLABLE_NBIEP	0xA07C
#define T_UTF_16_YI_SYLLABLE_NBAT	0xA07D
#define T_UTF_16_YI_SYLLABLE_NBAX	0xA07E
#define T_UTF_16_YI_SYLLABLE_NBA	0xA07F
#define T_UTF_16_YI_SYLLABLE_NBAP	0xA080
#define T_UTF_16_YI_SYLLABLE_NBOT	0xA081
#define T_UTF_16_YI_SYLLABLE_NBOX	0xA082
#define T_UTF_16_YI_SYLLABLE_NBO	0xA083
#define T_UTF_16_YI_SYLLABLE_NBOP	0xA084
#define T_UTF_16_YI_SYLLABLE_NBUT	0xA085
#define T_UTF_16_YI_SYLLABLE_NBUX	0xA086
#define T_UTF_16_YI_SYLLABLE_NBU	0xA087
#define T_UTF_16_YI_SYLLABLE_NBUP	0xA088
#define T_UTF_16_YI_SYLLABLE_NBURX	0xA089
#define T_UTF_16_YI_SYLLABLE_NBUR	0xA08A
#define T_UTF_16_YI_SYLLABLE_NBYT	0xA08B
#define T_UTF_16_YI_SYLLABLE_NBYX	0xA08C
#define T_UTF_16_YI_SYLLABLE_NBY	0xA08D
#define T_UTF_16_YI_SYLLABLE_NBYP	0xA08E
#define T_UTF_16_YI_SYLLABLE_NBYRX	0xA08F
#define T_UTF_16_YI_SYLLABLE_NBYR	0xA090
#define T_UTF_16_YI_SYLLABLE_HMIT	0xA091
#define T_UTF_16_YI_SYLLABLE_HMIX	0xA092
#define T_UTF_16_YI_SYLLABLE_HMI	0xA093
#define T_UTF_16_YI_SYLLABLE_HMIP	0xA094
#define T_UTF_16_YI_SYLLABLE_HMIEX	0xA095
#define T_UTF_16_YI_SYLLABLE_HMIE	0xA096
#define T_UTF_16_YI_SYLLABLE_HMIEP	0xA097
#define T_UTF_16_YI_SYLLABLE_HMAT	0xA098
#define T_UTF_16_YI_SYLLABLE_HMAX	0xA099
#define T_UTF_16_YI_SYLLABLE_HMA	0xA09A
#define T_UTF_16_YI_SYLLABLE_HMAP	0xA09B
#define T_UTF_16_YI_SYLLABLE_HMUOX	0xA09C
#define T_UTF_16_YI_SYLLABLE_HMUO	0xA09D
#define T_UTF_16_YI_SYLLABLE_HMUOP	0xA09E
#define T_UTF_16_YI_SYLLABLE_HMOT	0xA09F
#define T_UTF_16_YI_SYLLABLE_HMOX	0xA0A0
#define T_UTF_16_YI_SYLLABLE_HMO	0xA0A1
#define T_UTF_16_YI_SYLLABLE_HMOP	0xA0A2
#define T_UTF_16_YI_SYLLABLE_HMUT	0xA0A3
#define T_UTF_16_YI_SYLLABLE_HMUX	0xA0A4
#define T_UTF_16_YI_SYLLABLE_HMU	0xA0A5
#define T_UTF_16_YI_SYLLABLE_HMUP	0xA0A6
#define T_UTF_16_YI_SYLLABLE_HMURX	0xA0A7
#define T_UTF_16_YI_SYLLABLE_HMUR	0xA0A8
#define T_UTF_16_YI_SYLLABLE_HMYX	0xA0A9
#define T_UTF_16_YI_SYLLABLE_HMY	0xA0AA
#define T_UTF_16_YI_SYLLABLE_HMYP	0xA0AB
#define T_UTF_16_YI_SYLLABLE_HMYRX	0xA0AC
#define T_UTF_16_YI_SYLLABLE_HMYR	0xA0AD
#define T_UTF_16_YI_SYLLABLE_MIT	0xA0AE
#define T_UTF_16_YI_SYLLABLE_MIX	0xA0AF
#define T_UTF_16_YI_SYLLABLE_MI	0xA0B0
#define T_UTF_16_YI_SYLLABLE_MIP	0xA0B1
#define T_UTF_16_YI_SYLLABLE_MIEX	0xA0B2
#define T_UTF_16_YI_SYLLABLE_MIE	0xA0B3
#define T_UTF_16_YI_SYLLABLE_MIEP	0xA0B4
#define T_UTF_16_YI_SYLLABLE_MAT	0xA0B5
#define T_UTF_16_YI_SYLLABLE_MAX	0xA0B6
#define T_UTF_16_YI_SYLLABLE_MA	0xA0B7
#define T_UTF_16_YI_SYLLABLE_MAP	0xA0B8
#define T_UTF_16_YI_SYLLABLE_MUOT	0xA0B9
#define T_UTF_16_YI_SYLLABLE_MUOX	0xA0BA
#define T_UTF_16_YI_SYLLABLE_MUO	0xA0BB
#define T_UTF_16_YI_SYLLABLE_MUOP	0xA0BC
#define T_UTF_16_YI_SYLLABLE_MOT	0xA0BD
#define T_UTF_16_YI_SYLLABLE_MOX	0xA0BE
#define T_UTF_16_YI_SYLLABLE_MO	0xA0BF
#define T_UTF_16_YI_SYLLABLE_MOP	0xA0C0
#define T_UTF_16_YI_SYLLABLE_MEX	0xA0C1
#define T_UTF_16_YI_SYLLABLE_ME	0xA0C2
#define T_UTF_16_YI_SYLLABLE_MUT	0xA0C3
#define T_UTF_16_YI_SYLLABLE_MUX	0xA0C4
#define T_UTF_16_YI_SYLLABLE_MU	0xA0C5
#define T_UTF_16_YI_SYLLABLE_MUP	0xA0C6
#define T_UTF_16_YI_SYLLABLE_MURX	0xA0C7
#define T_UTF_16_YI_SYLLABLE_MUR	0xA0C8
#define T_UTF_16_YI_SYLLABLE_MYT	0xA0C9
#define T_UTF_16_YI_SYLLABLE_MYX	0xA0CA
#define T_UTF_16_YI_SYLLABLE_MY	0xA0CB
#define T_UTF_16_YI_SYLLABLE_MYP	0xA0CC
#define T_UTF_16_YI_SYLLABLE_FIT	0xA0CD
#define T_UTF_16_YI_SYLLABLE_FIX	0xA0CE
#define T_UTF_16_YI_SYLLABLE_FI	0xA0CF
#define T_UTF_16_YI_SYLLABLE_FIP	0xA0D0
#define T_UTF_16_YI_SYLLABLE_FAT	0xA0D1
#define T_UTF_16_YI_SYLLABLE_FAX	0xA0D2
#define T_UTF_16_YI_SYLLABLE_FA	0xA0D3
#define T_UTF_16_YI_SYLLABLE_FAP	0xA0D4
#define T_UTF_16_YI_SYLLABLE_FOX	0xA0D5
#define T_UTF_16_YI_SYLLABLE_FO	0xA0D6
#define T_UTF_16_YI_SYLLABLE_FOP	0xA0D7
#define T_UTF_16_YI_SYLLABLE_FUT	0xA0D8
#define T_UTF_16_YI_SYLLABLE_FUX	0xA0D9
#define T_UTF_16_YI_SYLLABLE_FU	0xA0DA
#define T_UTF_16_YI_SYLLABLE_FUP	0xA0DB
#define T_UTF_16_YI_SYLLABLE_FURX	0xA0DC
#define T_UTF_16_YI_SYLLABLE_FUR	0xA0DD
#define T_UTF_16_YI_SYLLABLE_FYT	0xA0DE
#define T_UTF_16_YI_SYLLABLE_FYX	0xA0DF
#define T_UTF_16_YI_SYLLABLE_FY	0xA0E0
#define T_UTF_16_YI_SYLLABLE_FYP	0xA0E1
#define T_UTF_16_YI_SYLLABLE_VIT	0xA0E2
#define T_UTF_16_YI_SYLLABLE_VIX	0xA0E3
#define T_UTF_16_YI_SYLLABLE_VI	0xA0E4
#define T_UTF_16_YI_SYLLABLE_VIP	0xA0E5
#define T_UTF_16_YI_SYLLABLE_VIET	0xA0E6
#define T_UTF_16_YI_SYLLABLE_VIEX	0xA0E7
#define T_UTF_16_YI_SYLLABLE_VIE	0xA0E8
#define T_UTF_16_YI_SYLLABLE_VIEP	0xA0E9
#define T_UTF_16_YI_SYLLABLE_VAT	0xA0EA
#define T_UTF_16_YI_SYLLABLE_VAX	0xA0EB
#define T_UTF_16_YI_SYLLABLE_VA	0xA0EC
#define T_UTF_16_YI_SYLLABLE_VAP	0xA0ED
#define T_UTF_16_YI_SYLLABLE_VOT	0xA0EE
#define T_UTF_16_YI_SYLLABLE_VOX	0xA0EF
#define T_UTF_16_YI_SYLLABLE_VO	0xA0F0
#define T_UTF_16_YI_SYLLABLE_VOP	0xA0F1
#define T_UTF_16_YI_SYLLABLE_VEX	0xA0F2
#define T_UTF_16_YI_SYLLABLE_VEP	0xA0F3
#define T_UTF_16_YI_SYLLABLE_VUT	0xA0F4
#define T_UTF_16_YI_SYLLABLE_VUX	0xA0F5
#define T_UTF_16_YI_SYLLABLE_VU	0xA0F6
#define T_UTF_16_YI_SYLLABLE_VUP	0xA0F7
#define T_UTF_16_YI_SYLLABLE_VURX	0xA0F8
#define T_UTF_16_YI_SYLLABLE_VUR	0xA0F9
#define T_UTF_16_YI_SYLLABLE_VYT	0xA0FA
#define T_UTF_16_YI_SYLLABLE_VYX	0xA0FB
#define T_UTF_16_YI_SYLLABLE_VY	0xA0FC
#define T_UTF_16_YI_SYLLABLE_VYP	0xA0FD
#define T_UTF_16_YI_SYLLABLE_VYRX	0xA0FE
#define T_UTF_16_YI_SYLLABLE_VYR	0xA0FF
#define T_UTF_16_YI_SYLLABLE_DIT	0xA100
#define T_UTF_16_YI_SYLLABLE_DIX	0xA101
#define T_UTF_16_YI_SYLLABLE_DI	0xA102
#define T_UTF_16_YI_SYLLABLE_DIP	0xA103
#define T_UTF_16_YI_SYLLABLE_DIEX	0xA104
#define T_UTF_16_YI_SYLLABLE_DIE	0xA105
#define T_UTF_16_YI_SYLLABLE_DIEP	0xA106
#define T_UTF_16_YI_SYLLABLE_DAT	0xA107
#define T_UTF_16_YI_SYLLABLE_DAX	0xA108
#define T_UTF_16_YI_SYLLABLE_DA	0xA109
#define T_UTF_16_YI_SYLLABLE_DAP	0xA10A
#define T_UTF_16_YI_SYLLABLE_DUOX	0xA10B
#define T_UTF_16_YI_SYLLABLE_DUO	0xA10C
#define T_UTF_16_YI_SYLLABLE_DOT	0xA10D
#define T_UTF_16_YI_SYLLABLE_DOX	0xA10E
#define T_UTF_16_YI_SYLLABLE_DO	0xA10F
#define T_UTF_16_YI_SYLLABLE_DOP	0xA110
#define T_UTF_16_YI_SYLLABLE_DEX	0xA111
#define T_UTF_16_YI_SYLLABLE_DE	0xA112
#define T_UTF_16_YI_SYLLABLE_DEP	0xA113
#define T_UTF_16_YI_SYLLABLE_DUT	0xA114
#define T_UTF_16_YI_SYLLABLE_DUX	0xA115
#define T_UTF_16_YI_SYLLABLE_DU	0xA116
#define T_UTF_16_YI_SYLLABLE_DUP	0xA117
#define T_UTF_16_YI_SYLLABLE_DURX	0xA118
#define T_UTF_16_YI_SYLLABLE_DUR	0xA119
#define T_UTF_16_YI_SYLLABLE_TIT	0xA11A
#define T_UTF_16_YI_SYLLABLE_TIX	0xA11B
#define T_UTF_16_YI_SYLLABLE_TI	0xA11C
#define T_UTF_16_YI_SYLLABLE_TIP	0xA11D
#define T_UTF_16_YI_SYLLABLE_TIEX	0xA11E
#define T_UTF_16_YI_SYLLABLE_TIE	0xA11F
#define T_UTF_16_YI_SYLLABLE_TIEP	0xA120
#define T_UTF_16_YI_SYLLABLE_TAT	0xA121
#define T_UTF_16_YI_SYLLABLE_TAX	0xA122
#define T_UTF_16_YI_SYLLABLE_TA	0xA123
#define T_UTF_16_YI_SYLLABLE_TAP	0xA124
#define T_UTF_16_YI_SYLLABLE_TUOT	0xA125
#define T_UTF_16_YI_SYLLABLE_TUOX	0xA126
#define T_UTF_16_YI_SYLLABLE_TUO	0xA127
#define T_UTF_16_YI_SYLLABLE_TUOP	0xA128
#define T_UTF_16_YI_SYLLABLE_TOT	0xA129
#define T_UTF_16_YI_SYLLABLE_TOX	0xA12A
#define T_UTF_16_YI_SYLLABLE_TO	0xA12B
#define T_UTF_16_YI_SYLLABLE_TOP	0xA12C
#define T_UTF_16_YI_SYLLABLE_TEX	0xA12D
#define T_UTF_16_YI_SYLLABLE_TE	0xA12E
#define T_UTF_16_YI_SYLLABLE_TEP	0xA12F
#define T_UTF_16_YI_SYLLABLE_TUT	0xA130
#define T_UTF_16_YI_SYLLABLE_TUX	0xA131
#define T_UTF_16_YI_SYLLABLE_TU	0xA132
#define T_UTF_16_YI_SYLLABLE_TUP	0xA133
#define T_UTF_16_YI_SYLLABLE_TURX	0xA134
#define T_UTF_16_YI_SYLLABLE_TUR	0xA135
#define T_UTF_16_YI_SYLLABLE_DDIT	0xA136
#define T_UTF_16_YI_SYLLABLE_DDIX	0xA137
#define T_UTF_16_YI_SYLLABLE_DDI	0xA138
#define T_UTF_16_YI_SYLLABLE_DDIP	0xA139
#define T_UTF_16_YI_SYLLABLE_DDIEX	0xA13A
#define T_UTF_16_YI_SYLLABLE_DDIE	0xA13B
#define T_UTF_16_YI_SYLLABLE_DDIEP	0xA13C
#define T_UTF_16_YI_SYLLABLE_DDAT	0xA13D
#define T_UTF_16_YI_SYLLABLE_DDAX	0xA13E
#define T_UTF_16_YI_SYLLABLE_DDA	0xA13F
#define T_UTF_16_YI_SYLLABLE_DDAP	0xA140
#define T_UTF_16_YI_SYLLABLE_DDUOX	0xA141
#define T_UTF_16_YI_SYLLABLE_DDUO	0xA142
#define T_UTF_16_YI_SYLLABLE_DDUOP	0xA143
#define T_UTF_16_YI_SYLLABLE_DDOT	0xA144
#define T_UTF_16_YI_SYLLABLE_DDOX	0xA145
#define T_UTF_16_YI_SYLLABLE_DDO	0xA146
#define T_UTF_16_YI_SYLLABLE_DDOP	0xA147
#define T_UTF_16_YI_SYLLABLE_DDEX	0xA148
#define T_UTF_16_YI_SYLLABLE_DDE	0xA149
#define T_UTF_16_YI_SYLLABLE_DDEP	0xA14A
#define T_UTF_16_YI_SYLLABLE_DDUT	0xA14B
#define T_UTF_16_YI_SYLLABLE_DDUX	0xA14C
#define T_UTF_16_YI_SYLLABLE_DDU	0xA14D
#define T_UTF_16_YI_SYLLABLE_DDUP	0xA14E
#define T_UTF_16_YI_SYLLABLE_DDURX	0xA14F
#define T_UTF_16_YI_SYLLABLE_DDUR	0xA150
#define T_UTF_16_YI_SYLLABLE_NDIT	0xA151
#define T_UTF_16_YI_SYLLABLE_NDIX	0xA152
#define T_UTF_16_YI_SYLLABLE_NDI	0xA153
#define T_UTF_16_YI_SYLLABLE_NDIP	0xA154
#define T_UTF_16_YI_SYLLABLE_NDIEX	0xA155
#define T_UTF_16_YI_SYLLABLE_NDIE	0xA156
#define T_UTF_16_YI_SYLLABLE_NDAT	0xA157
#define T_UTF_16_YI_SYLLABLE_NDAX	0xA158
#define T_UTF_16_YI_SYLLABLE_NDA	0xA159
#define T_UTF_16_YI_SYLLABLE_NDAP	0xA15A
#define T_UTF_16_YI_SYLLABLE_NDOT	0xA15B
#define T_UTF_16_YI_SYLLABLE_NDOX	0xA15C
#define T_UTF_16_YI_SYLLABLE_NDO	0xA15D
#define T_UTF_16_YI_SYLLABLE_NDOP	0xA15E
#define T_UTF_16_YI_SYLLABLE_NDEX	0xA15F
#define T_UTF_16_YI_SYLLABLE_NDE	0xA160
#define T_UTF_16_YI_SYLLABLE_NDEP	0xA161
#define T_UTF_16_YI_SYLLABLE_NDUT	0xA162
#define T_UTF_16_YI_SYLLABLE_NDUX	0xA163
#define T_UTF_16_YI_SYLLABLE_NDU	0xA164
#define T_UTF_16_YI_SYLLABLE_NDUP	0xA165
#define T_UTF_16_YI_SYLLABLE_NDURX	0xA166
#define T_UTF_16_YI_SYLLABLE_NDUR	0xA167
#define T_UTF_16_YI_SYLLABLE_HNIT	0xA168
#define T_UTF_16_YI_SYLLABLE_HNIX	0xA169
#define T_UTF_16_YI_SYLLABLE_HNI	0xA16A
#define T_UTF_16_YI_SYLLABLE_HNIP	0xA16B
#define T_UTF_16_YI_SYLLABLE_HNIET	0xA16C
#define T_UTF_16_YI_SYLLABLE_HNIEX	0xA16D
#define T_UTF_16_YI_SYLLABLE_HNIE	0xA16E
#define T_UTF_16_YI_SYLLABLE_HNIEP	0xA16F
#define T_UTF_16_YI_SYLLABLE_HNAT	0xA170
#define T_UTF_16_YI_SYLLABLE_HNAX	0xA171
#define T_UTF_16_YI_SYLLABLE_HNA	0xA172
#define T_UTF_16_YI_SYLLABLE_HNAP	0xA173
#define T_UTF_16_YI_SYLLABLE_HNUOX	0xA174
#define T_UTF_16_YI_SYLLABLE_HNUO	0xA175
#define T_UTF_16_YI_SYLLABLE_HNOT	0xA176
#define T_UTF_16_YI_SYLLABLE_HNOX	0xA177
#define T_UTF_16_YI_SYLLABLE_HNOP	0xA178
#define T_UTF_16_YI_SYLLABLE_HNEX	0xA179
#define T_UTF_16_YI_SYLLABLE_HNE	0xA17A
#define T_UTF_16_YI_SYLLABLE_HNEP	0xA17B
#define T_UTF_16_YI_SYLLABLE_HNUT	0xA17C
#define T_UTF_16_YI_SYLLABLE_NIT	0xA17D
#define T_UTF_16_YI_SYLLABLE_NIX	0xA17E
#define T_UTF_16_YI_SYLLABLE_NI	0xA17F
#define T_UTF_16_YI_SYLLABLE_NIP	0xA180
#define T_UTF_16_YI_SYLLABLE_NIEX	0xA181
#define T_UTF_16_YI_SYLLABLE_NIE	0xA182
#define T_UTF_16_YI_SYLLABLE_NIEP	0xA183
#define T_UTF_16_YI_SYLLABLE_NAX	0xA184
#define T_UTF_16_YI_SYLLABLE_NA	0xA185
#define T_UTF_16_YI_SYLLABLE_NAP	0xA186
#define T_UTF_16_YI_SYLLABLE_NUOX	0xA187
#define T_UTF_16_YI_SYLLABLE_NUO	0xA188
#define T_UTF_16_YI_SYLLABLE_NUOP	0xA189
#define T_UTF_16_YI_SYLLABLE_NOT	0xA18A
#define T_UTF_16_YI_SYLLABLE_NOX	0xA18B
#define T_UTF_16_YI_SYLLABLE_NO	0xA18C
#define T_UTF_16_YI_SYLLABLE_NOP	0xA18D
#define T_UTF_16_YI_SYLLABLE_NEX	0xA18E
#define T_UTF_16_YI_SYLLABLE_NE	0xA18F
#define T_UTF_16_YI_SYLLABLE_NEP	0xA190
#define T_UTF_16_YI_SYLLABLE_NUT	0xA191
#define T_UTF_16_YI_SYLLABLE_NUX	0xA192
#define T_UTF_16_YI_SYLLABLE_NU	0xA193
#define T_UTF_16_YI_SYLLABLE_NUP	0xA194
#define T_UTF_16_YI_SYLLABLE_NURX	0xA195
#define T_UTF_16_YI_SYLLABLE_NUR	0xA196
#define T_UTF_16_YI_SYLLABLE_HLIT	0xA197
#define T_UTF_16_YI_SYLLABLE_HLIX	0xA198
#define T_UTF_16_YI_SYLLABLE_HLI	0xA199
#define T_UTF_16_YI_SYLLABLE_HLIP	0xA19A
#define T_UTF_16_YI_SYLLABLE_HLIEX	0xA19B
#define T_UTF_16_YI_SYLLABLE_HLIE	0xA19C
#define T_UTF_16_YI_SYLLABLE_HLIEP	0xA19D
#define T_UTF_16_YI_SYLLABLE_HLAT	0xA19E
#define T_UTF_16_YI_SYLLABLE_HLAX	0xA19F
#define T_UTF_16_YI_SYLLABLE_HLA	0xA1A0
#define T_UTF_16_YI_SYLLABLE_HLAP	0xA1A1
#define T_UTF_16_YI_SYLLABLE_HLUOX	0xA1A2
#define T_UTF_16_YI_SYLLABLE_HLUO	0xA1A3
#define T_UTF_16_YI_SYLLABLE_HLUOP	0xA1A4
#define T_UTF_16_YI_SYLLABLE_HLOX	0xA1A5
#define T_UTF_16_YI_SYLLABLE_HLO	0xA1A6
#define T_UTF_16_YI_SYLLABLE_HLOP	0xA1A7
#define T_UTF_16_YI_SYLLABLE_HLEX	0xA1A8
#define T_UTF_16_YI_SYLLABLE_HLE	0xA1A9
#define T_UTF_16_YI_SYLLABLE_HLEP	0xA1AA
#define T_UTF_16_YI_SYLLABLE_HLUT	0xA1AB
#define T_UTF_16_YI_SYLLABLE_HLUX	0xA1AC
#define T_UTF_16_YI_SYLLABLE_HLU	0xA1AD
#define T_UTF_16_YI_SYLLABLE_HLUP	0xA1AE
#define T_UTF_16_YI_SYLLABLE_HLURX	0xA1AF
#define T_UTF_16_YI_SYLLABLE_HLUR	0xA1B0
#define T_UTF_16_YI_SYLLABLE_HLYT	0xA1B1
#define T_UTF_16_YI_SYLLABLE_HLYX	0xA1B2
#define T_UTF_16_YI_SYLLABLE_HLY	0xA1B3
#define T_UTF_16_YI_SYLLABLE_HLYP	0xA1B4
#define T_UTF_16_YI_SYLLABLE_HLYRX	0xA1B5
#define T_UTF_16_YI_SYLLABLE_HLYR	0xA1B6
#define T_UTF_16_YI_SYLLABLE_LIT	0xA1B7
#define T_UTF_16_YI_SYLLABLE_LIX	0xA1B8
#define T_UTF_16_YI_SYLLABLE_LI	0xA1B9
#define T_UTF_16_YI_SYLLABLE_LIP	0xA1BA
#define T_UTF_16_YI_SYLLABLE_LIET	0xA1BB
#define T_UTF_16_YI_SYLLABLE_LIEX	0xA1BC
#define T_UTF_16_YI_SYLLABLE_LIE	0xA1BD
#define T_UTF_16_YI_SYLLABLE_LIEP	0xA1BE
#define T_UTF_16_YI_SYLLABLE_LAT	0xA1BF
#define T_UTF_16_YI_SYLLABLE_LAX	0xA1C0
#define T_UTF_16_YI_SYLLABLE_LA	0xA1C1
#define T_UTF_16_YI_SYLLABLE_LAP	0xA1C2
#define T_UTF_16_YI_SYLLABLE_LUOT	0xA1C3
#define T_UTF_16_YI_SYLLABLE_LUOX	0xA1C4
#define T_UTF_16_YI_SYLLABLE_LUO	0xA1C5
#define T_UTF_16_YI_SYLLABLE_LUOP	0xA1C6
#define T_UTF_16_YI_SYLLABLE_LOT	0xA1C7
#define T_UTF_16_YI_SYLLABLE_LOX	0xA1C8
#define T_UTF_16_YI_SYLLABLE_LO	0xA1C9
#define T_UTF_16_YI_SYLLABLE_LOP	0xA1CA
#define T_UTF_16_YI_SYLLABLE_LEX	0xA1CB
#define T_UTF_16_YI_SYLLABLE_LE	0xA1CC
#define T_UTF_16_YI_SYLLABLE_LEP	0xA1CD
#define T_UTF_16_YI_SYLLABLE_LUT	0xA1CE
#define T_UTF_16_YI_SYLLABLE_LUX	0xA1CF
#define T_UTF_16_YI_SYLLABLE_LU	0xA1D0
#define T_UTF_16_YI_SYLLABLE_LUP	0xA1D1
#define T_UTF_16_YI_SYLLABLE_LURX	0xA1D2
#define T_UTF_16_YI_SYLLABLE_LUR	0xA1D3
#define T_UTF_16_YI_SYLLABLE_LYT	0xA1D4
#define T_UTF_16_YI_SYLLABLE_LYX	0xA1D5
#define T_UTF_16_YI_SYLLABLE_LY	0xA1D6
#define T_UTF_16_YI_SYLLABLE_LYP	0xA1D7
#define T_UTF_16_YI_SYLLABLE_LYRX	0xA1D8
#define T_UTF_16_YI_SYLLABLE_LYR	0xA1D9
#define T_UTF_16_YI_SYLLABLE_GIT	0xA1DA
#define T_UTF_16_YI_SYLLABLE_GIX	0xA1DB
#define T_UTF_16_YI_SYLLABLE_GI	0xA1DC
#define T_UTF_16_YI_SYLLABLE_GIP	0xA1DD
#define T_UTF_16_YI_SYLLABLE_GIET	0xA1DE
#define T_UTF_16_YI_SYLLABLE_GIEX	0xA1DF
#define T_UTF_16_YI_SYLLABLE_GIE	0xA1E0
#define T_UTF_16_YI_SYLLABLE_GIEP	0xA1E1
#define T_UTF_16_YI_SYLLABLE_GAT	0xA1E2
#define T_UTF_16_YI_SYLLABLE_GAX	0xA1E3
#define T_UTF_16_YI_SYLLABLE_GA	0xA1E4
#define T_UTF_16_YI_SYLLABLE_GAP	0xA1E5
#define T_UTF_16_YI_SYLLABLE_GUOT	0xA1E6
#define T_UTF_16_YI_SYLLABLE_GUOX	0xA1E7
#define T_UTF_16_YI_SYLLABLE_GUO	0xA1E8
#define T_UTF_16_YI_SYLLABLE_GUOP	0xA1E9
#define T_UTF_16_YI_SYLLABLE_GOT	0xA1EA
#define T_UTF_16_YI_SYLLABLE_GOX	0xA1EB
#define T_UTF_16_YI_SYLLABLE_GO	0xA1EC
#define T_UTF_16_YI_SYLLABLE_GOP	0xA1ED
#define T_UTF_16_YI_SYLLABLE_GET	0xA1EE
#define T_UTF_16_YI_SYLLABLE_GEX	0xA1EF
#define T_UTF_16_YI_SYLLABLE_GE	0xA1F0
#define T_UTF_16_YI_SYLLABLE_GEP	0xA1F1
#define T_UTF_16_YI_SYLLABLE_GUT	0xA1F2
#define T_UTF_16_YI_SYLLABLE_GUX	0xA1F3
#define T_UTF_16_YI_SYLLABLE_GU	0xA1F4
#define T_UTF_16_YI_SYLLABLE_GUP	0xA1F5
#define T_UTF_16_YI_SYLLABLE_GURX	0xA1F6
#define T_UTF_16_YI_SYLLABLE_GUR	0xA1F7
#define T_UTF_16_YI_SYLLABLE_KIT	0xA1F8
#define T_UTF_16_YI_SYLLABLE_KIX	0xA1F9
#define T_UTF_16_YI_SYLLABLE_KI	0xA1FA
#define T_UTF_16_YI_SYLLABLE_KIP	0xA1FB
#define T_UTF_16_YI_SYLLABLE_KIEX	0xA1FC
#define T_UTF_16_YI_SYLLABLE_KIE	0xA1FD
#define T_UTF_16_YI_SYLLABLE_KIEP	0xA1FE
#define T_UTF_16_YI_SYLLABLE_KAT	0xA1FF
#define T_UTF_16_YI_SYLLABLE_KAX	0xA200
#define T_UTF_16_YI_SYLLABLE_KA	0xA201
#define T_UTF_16_YI_SYLLABLE_KAP	0xA202
#define T_UTF_16_YI_SYLLABLE_KUOX	0xA203
#define T_UTF_16_YI_SYLLABLE_KUO	0xA204
#define T_UTF_16_YI_SYLLABLE_KUOP	0xA205
#define T_UTF_16_YI_SYLLABLE_KOT	0xA206
#define T_UTF_16_YI_SYLLABLE_KOX	0xA207
#define T_UTF_16_YI_SYLLABLE_KO	0xA208
#define T_UTF_16_YI_SYLLABLE_KOP	0xA209
#define T_UTF_16_YI_SYLLABLE_KET	0xA20A
#define T_UTF_16_YI_SYLLABLE_KEX	0xA20B
#define T_UTF_16_YI_SYLLABLE_KE	0xA20C
#define T_UTF_16_YI_SYLLABLE_KEP	0xA20D
#define T_UTF_16_YI_SYLLABLE_KUT	0xA20E
#define T_UTF_16_YI_SYLLABLE_KUX	0xA20F
#define T_UTF_16_YI_SYLLABLE_KU	0xA210
#define T_UTF_16_YI_SYLLABLE_KUP	0xA211
#define T_UTF_16_YI_SYLLABLE_KURX	0xA212
#define T_UTF_16_YI_SYLLABLE_KUR	0xA213
#define T_UTF_16_YI_SYLLABLE_GGIT	0xA214
#define T_UTF_16_YI_SYLLABLE_GGIX	0xA215
#define T_UTF_16_YI_SYLLABLE_GGI	0xA216
#define T_UTF_16_YI_SYLLABLE_GGIEX	0xA217
#define T_UTF_16_YI_SYLLABLE_GGIE	0xA218
#define T_UTF_16_YI_SYLLABLE_GGIEP	0xA219
#define T_UTF_16_YI_SYLLABLE_GGAT	0xA21A
#define T_UTF_16_YI_SYLLABLE_GGAX	0xA21B
#define T_UTF_16_YI_SYLLABLE_GGA	0xA21C
#define T_UTF_16_YI_SYLLABLE_GGAP	0xA21D
#define T_UTF_16_YI_SYLLABLE_GGUOT	0xA21E
#define T_UTF_16_YI_SYLLABLE_GGUOX	0xA21F
#define T_UTF_16_YI_SYLLABLE_GGUO	0xA220
#define T_UTF_16_YI_SYLLABLE_GGUOP	0xA221
#define T_UTF_16_YI_SYLLABLE_GGOT	0xA222
#define T_UTF_16_YI_SYLLABLE_GGOX	0xA223
#define T_UTF_16_YI_SYLLABLE_GGO	0xA224
#define T_UTF_16_YI_SYLLABLE_GGOP	0xA225
#define T_UTF_16_YI_SYLLABLE_GGET	0xA226
#define T_UTF_16_YI_SYLLABLE_GGEX	0xA227
#define T_UTF_16_YI_SYLLABLE_GGE	0xA228
#define T_UTF_16_YI_SYLLABLE_GGEP	0xA229
#define T_UTF_16_YI_SYLLABLE_GGUT	0xA22A
#define T_UTF_16_YI_SYLLABLE_GGUX	0xA22B
#define T_UTF_16_YI_SYLLABLE_GGU	0xA22C
#define T_UTF_16_YI_SYLLABLE_GGUP	0xA22D
#define T_UTF_16_YI_SYLLABLE_GGURX	0xA22E
#define T_UTF_16_YI_SYLLABLE_GGUR	0xA22F
#define T_UTF_16_YI_SYLLABLE_MGIEX	0xA230
#define T_UTF_16_YI_SYLLABLE_MGIE	0xA231
#define T_UTF_16_YI_SYLLABLE_MGAT	0xA232
#define T_UTF_16_YI_SYLLABLE_MGAX	0xA233
#define T_UTF_16_YI_SYLLABLE_MGA	0xA234
#define T_UTF_16_YI_SYLLABLE_MGAP	0xA235
#define T_UTF_16_YI_SYLLABLE_MGUOX	0xA236
#define T_UTF_16_YI_SYLLABLE_MGUO	0xA237
#define T_UTF_16_YI_SYLLABLE_MGUOP	0xA238
#define T_UTF_16_YI_SYLLABLE_MGOT	0xA239
#define T_UTF_16_YI_SYLLABLE_MGOX	0xA23A
#define T_UTF_16_YI_SYLLABLE_MGO	0xA23B
#define T_UTF_16_YI_SYLLABLE_MGOP	0xA23C
#define T_UTF_16_YI_SYLLABLE_MGEX	0xA23D
#define T_UTF_16_YI_SYLLABLE_MGE	0xA23E
#define T_UTF_16_YI_SYLLABLE_MGEP	0xA23F
#define T_UTF_16_YI_SYLLABLE_MGUT	0xA240
#define T_UTF_16_YI_SYLLABLE_MGUX	0xA241
#define T_UTF_16_YI_SYLLABLE_MGU	0xA242
#define T_UTF_16_YI_SYLLABLE_MGUP	0xA243
#define T_UTF_16_YI_SYLLABLE_MGURX	0xA244
#define T_UTF_16_YI_SYLLABLE_MGUR	0xA245
#define T_UTF_16_YI_SYLLABLE_HXIT	0xA246
#define T_UTF_16_YI_SYLLABLE_HXIX	0xA247
#define T_UTF_16_YI_SYLLABLE_HXI	0xA248
#define T_UTF_16_YI_SYLLABLE_HXIP	0xA249
#define T_UTF_16_YI_SYLLABLE_HXIET	0xA24A
#define T_UTF_16_YI_SYLLABLE_HXIEX	0xA24B
#define T_UTF_16_YI_SYLLABLE_HXIE	0xA24C
#define T_UTF_16_YI_SYLLABLE_HXIEP	0xA24D
#define T_UTF_16_YI_SYLLABLE_HXAT	0xA24E
#define T_UTF_16_YI_SYLLABLE_HXAX	0xA24F
#define T_UTF_16_YI_SYLLABLE_HXA	0xA250
#define T_UTF_16_YI_SYLLABLE_HXAP	0xA251
#define T_UTF_16_YI_SYLLABLE_HXUOT	0xA252
#define T_UTF_16_YI_SYLLABLE_HXUOX	0xA253
#define T_UTF_16_YI_SYLLABLE_HXUO	0xA254
#define T_UTF_16_YI_SYLLABLE_HXUOP	0xA255
#define T_UTF_16_YI_SYLLABLE_HXOT	0xA256
#define T_UTF_16_YI_SYLLABLE_HXOX	0xA257
#define T_UTF_16_YI_SYLLABLE_HXO	0xA258
#define T_UTF_16_YI_SYLLABLE_HXOP	0xA259
#define T_UTF_16_YI_SYLLABLE_HXEX	0xA25A
#define T_UTF_16_YI_SYLLABLE_HXE	0xA25B
#define T_UTF_16_YI_SYLLABLE_HXEP	0xA25C
#define T_UTF_16_YI_SYLLABLE_NGIEX	0xA25D
#define T_UTF_16_YI_SYLLABLE_NGIE	0xA25E
#define T_UTF_16_YI_SYLLABLE_NGIEP	0xA25F
#define T_UTF_16_YI_SYLLABLE_NGAT	0xA260
#define T_UTF_16_YI_SYLLABLE_NGAX	0xA261
#define T_UTF_16_YI_SYLLABLE_NGA	0xA262
#define T_UTF_16_YI_SYLLABLE_NGAP	0xA263
#define T_UTF_16_YI_SYLLABLE_NGUOT	0xA264
#define T_UTF_16_YI_SYLLABLE_NGUOX	0xA265
#define T_UTF_16_YI_SYLLABLE_NGUO	0xA266
#define T_UTF_16_YI_SYLLABLE_NGOT	0xA267
#define T_UTF_16_YI_SYLLABLE_NGOX	0xA268
#define T_UTF_16_YI_SYLLABLE_NGO	0xA269
#define T_UTF_16_YI_SYLLABLE_NGOP	0xA26A
#define T_UTF_16_YI_SYLLABLE_NGEX	0xA26B
#define T_UTF_16_YI_SYLLABLE_NGE	0xA26C
#define T_UTF_16_YI_SYLLABLE_NGEP	0xA26D
#define T_UTF_16_YI_SYLLABLE_HIT	0xA26E
#define T_UTF_16_YI_SYLLABLE_HIEX	0xA26F
#define T_UTF_16_YI_SYLLABLE_HIE	0xA270
#define T_UTF_16_YI_SYLLABLE_HAT	0xA271
#define T_UTF_16_YI_SYLLABLE_HAX	0xA272
#define T_UTF_16_YI_SYLLABLE_HA	0xA273
#define T_UTF_16_YI_SYLLABLE_HAP	0xA274
#define T_UTF_16_YI_SYLLABLE_HUOT	0xA275
#define T_UTF_16_YI_SYLLABLE_HUOX	0xA276
#define T_UTF_16_YI_SYLLABLE_HUO	0xA277
#define T_UTF_16_YI_SYLLABLE_HUOP	0xA278
#define T_UTF_16_YI_SYLLABLE_HOT	0xA279
#define T_UTF_16_YI_SYLLABLE_HOX	0xA27A
#define T_UTF_16_YI_SYLLABLE_HO	0xA27B
#define T_UTF_16_YI_SYLLABLE_HOP	0xA27C
#define T_UTF_16_YI_SYLLABLE_HEX	0xA27D
#define T_UTF_16_YI_SYLLABLE_HE	0xA27E
#define T_UTF_16_YI_SYLLABLE_HEP	0xA27F
#define T_UTF_16_YI_SYLLABLE_WAT	0xA280
#define T_UTF_16_YI_SYLLABLE_WAX	0xA281
#define T_UTF_16_YI_SYLLABLE_WA	0xA282
#define T_UTF_16_YI_SYLLABLE_WAP	0xA283
#define T_UTF_16_YI_SYLLABLE_WUOX	0xA284
#define T_UTF_16_YI_SYLLABLE_WUO	0xA285
#define T_UTF_16_YI_SYLLABLE_WUOP	0xA286
#define T_UTF_16_YI_SYLLABLE_WOX	0xA287
#define T_UTF_16_YI_SYLLABLE_WO	0xA288
#define T_UTF_16_YI_SYLLABLE_WOP	0xA289
#define T_UTF_16_YI_SYLLABLE_WEX	0xA28A
#define T_UTF_16_YI_SYLLABLE_WE	0xA28B
#define T_UTF_16_YI_SYLLABLE_WEP	0xA28C
#define T_UTF_16_YI_SYLLABLE_ZIT	0xA28D
#define T_UTF_16_YI_SYLLABLE_ZIX	0xA28E
#define T_UTF_16_YI_SYLLABLE_ZI	0xA28F
#define T_UTF_16_YI_SYLLABLE_ZIP	0xA290
#define T_UTF_16_YI_SYLLABLE_ZIEX	0xA291
#define T_UTF_16_YI_SYLLABLE_ZIE	0xA292
#define T_UTF_16_YI_SYLLABLE_ZIEP	0xA293
#define T_UTF_16_YI_SYLLABLE_ZAT	0xA294
#define T_UTF_16_YI_SYLLABLE_ZAX	0xA295
#define T_UTF_16_YI_SYLLABLE_ZA	0xA296
#define T_UTF_16_YI_SYLLABLE_ZAP	0xA297
#define T_UTF_16_YI_SYLLABLE_ZUOX	0xA298
#define T_UTF_16_YI_SYLLABLE_ZUO	0xA299
#define T_UTF_16_YI_SYLLABLE_ZUOP	0xA29A
#define T_UTF_16_YI_SYLLABLE_ZOT	0xA29B
#define T_UTF_16_YI_SYLLABLE_ZOX	0xA29C
#define T_UTF_16_YI_SYLLABLE_ZO	0xA29D
#define T_UTF_16_YI_SYLLABLE_ZOP	0xA29E
#define T_UTF_16_YI_SYLLABLE_ZEX	0xA29F
#define T_UTF_16_YI_SYLLABLE_ZE	0xA2A0
#define T_UTF_16_YI_SYLLABLE_ZEP	0xA2A1
#define T_UTF_16_YI_SYLLABLE_ZUT	0xA2A2
#define T_UTF_16_YI_SYLLABLE_ZUX	0xA2A3
#define T_UTF_16_YI_SYLLABLE_ZU	0xA2A4
#define T_UTF_16_YI_SYLLABLE_ZUP	0xA2A5
#define T_UTF_16_YI_SYLLABLE_ZURX	0xA2A6
#define T_UTF_16_YI_SYLLABLE_ZUR	0xA2A7
#define T_UTF_16_YI_SYLLABLE_ZYT	0xA2A8
#define T_UTF_16_YI_SYLLABLE_ZYX	0xA2A9
#define T_UTF_16_YI_SYLLABLE_ZY	0xA2AA
#define T_UTF_16_YI_SYLLABLE_ZYP	0xA2AB
#define T_UTF_16_YI_SYLLABLE_ZYRX	0xA2AC
#define T_UTF_16_YI_SYLLABLE_ZYR	0xA2AD
#define T_UTF_16_YI_SYLLABLE_CIT	0xA2AE
#define T_UTF_16_YI_SYLLABLE_CIX	0xA2AF
#define T_UTF_16_YI_SYLLABLE_CI	0xA2B0
#define T_UTF_16_YI_SYLLABLE_CIP	0xA2B1
#define T_UTF_16_YI_SYLLABLE_CIET	0xA2B2
#define T_UTF_16_YI_SYLLABLE_CIEX	0xA2B3
#define T_UTF_16_YI_SYLLABLE_CIE	0xA2B4
#define T_UTF_16_YI_SYLLABLE_CIEP	0xA2B5
#define T_UTF_16_YI_SYLLABLE_CAT	0xA2B6
#define T_UTF_16_YI_SYLLABLE_CAX	0xA2B7
#define T_UTF_16_YI_SYLLABLE_CA	0xA2B8
#define T_UTF_16_YI_SYLLABLE_CAP	0xA2B9
#define T_UTF_16_YI_SYLLABLE_CUOX	0xA2BA
#define T_UTF_16_YI_SYLLABLE_CUO	0xA2BB
#define T_UTF_16_YI_SYLLABLE_CUOP	0xA2BC
#define T_UTF_16_YI_SYLLABLE_COT	0xA2BD
#define T_UTF_16_YI_SYLLABLE_COX	0xA2BE
#define T_UTF_16_YI_SYLLABLE_CO	0xA2BF
#define T_UTF_16_YI_SYLLABLE_COP	0xA2C0
#define T_UTF_16_YI_SYLLABLE_CEX	0xA2C1
#define T_UTF_16_YI_SYLLABLE_CE	0xA2C2
#define T_UTF_16_YI_SYLLABLE_CEP	0xA2C3
#define T_UTF_16_YI_SYLLABLE_CUT	0xA2C4
#define T_UTF_16_YI_SYLLABLE_CUX	0xA2C5
#define T_UTF_16_YI_SYLLABLE_CU	0xA2C6
#define T_UTF_16_YI_SYLLABLE_CUP	0xA2C7
#define T_UTF_16_YI_SYLLABLE_CURX	0xA2C8
#define T_UTF_16_YI_SYLLABLE_CUR	0xA2C9
#define T_UTF_16_YI_SYLLABLE_CYT	0xA2CA
#define T_UTF_16_YI_SYLLABLE_CYX	0xA2CB
#define T_UTF_16_YI_SYLLABLE_CY	0xA2CC
#define T_UTF_16_YI_SYLLABLE_CYP	0xA2CD
#define T_UTF_16_YI_SYLLABLE_CYRX	0xA2CE
#define T_UTF_16_YI_SYLLABLE_CYR	0xA2CF
#define T_UTF_16_YI_SYLLABLE_ZZIT	0xA2D0
#define T_UTF_16_YI_SYLLABLE_ZZIX	0xA2D1
#define T_UTF_16_YI_SYLLABLE_ZZI	0xA2D2
#define T_UTF_16_YI_SYLLABLE_ZZIP	0xA2D3
#define T_UTF_16_YI_SYLLABLE_ZZIET	0xA2D4
#define T_UTF_16_YI_SYLLABLE_ZZIEX	0xA2D5
#define T_UTF_16_YI_SYLLABLE_ZZIE	0xA2D6
#define T_UTF_16_YI_SYLLABLE_ZZIEP	0xA2D7
#define T_UTF_16_YI_SYLLABLE_ZZAT	0xA2D8
#define T_UTF_16_YI_SYLLABLE_ZZAX	0xA2D9
#define T_UTF_16_YI_SYLLABLE_ZZA	0xA2DA
#define T_UTF_16_YI_SYLLABLE_ZZAP	0xA2DB
#define T_UTF_16_YI_SYLLABLE_ZZOX	0xA2DC
#define T_UTF_16_YI_SYLLABLE_ZZO	0xA2DD
#define T_UTF_16_YI_SYLLABLE_ZZOP	0xA2DE
#define T_UTF_16_YI_SYLLABLE_ZZEX	0xA2DF
#define T_UTF_16_YI_SYLLABLE_ZZE	0xA2E0
#define T_UTF_16_YI_SYLLABLE_ZZEP	0xA2E1
#define T_UTF_16_YI_SYLLABLE_ZZUX	0xA2E2
#define T_UTF_16_YI_SYLLABLE_ZZU	0xA2E3
#define T_UTF_16_YI_SYLLABLE_ZZUP	0xA2E4
#define T_UTF_16_YI_SYLLABLE_ZZURX	0xA2E5
#define T_UTF_16_YI_SYLLABLE_ZZUR	0xA2E6
#define T_UTF_16_YI_SYLLABLE_ZZYT	0xA2E7
#define T_UTF_16_YI_SYLLABLE_ZZYX	0xA2E8
#define T_UTF_16_YI_SYLLABLE_ZZY	0xA2E9
#define T_UTF_16_YI_SYLLABLE_ZZYP	0xA2EA
#define T_UTF_16_YI_SYLLABLE_ZZYRX	0xA2EB
#define T_UTF_16_YI_SYLLABLE_ZZYR	0xA2EC
#define T_UTF_16_YI_SYLLABLE_NZIT	0xA2ED
#define T_UTF_16_YI_SYLLABLE_NZIX	0xA2EE
#define T_UTF_16_YI_SYLLABLE_NZI	0xA2EF
#define T_UTF_16_YI_SYLLABLE_NZIP	0xA2F0
#define T_UTF_16_YI_SYLLABLE_NZIEX	0xA2F1
#define T_UTF_16_YI_SYLLABLE_NZIE	0xA2F2
#define T_UTF_16_YI_SYLLABLE_NZIEP	0xA2F3
#define T_UTF_16_YI_SYLLABLE_NZAT	0xA2F4
#define T_UTF_16_YI_SYLLABLE_NZAX	0xA2F5
#define T_UTF_16_YI_SYLLABLE_NZA	0xA2F6
#define T_UTF_16_YI_SYLLABLE_NZAP	0xA2F7
#define T_UTF_16_YI_SYLLABLE_NZUOX	0xA2F8
#define T_UTF_16_YI_SYLLABLE_NZUO	0xA2F9
#define T_UTF_16_YI_SYLLABLE_NZOX	0xA2FA
#define T_UTF_16_YI_SYLLABLE_NZOP	0xA2FB
#define T_UTF_16_YI_SYLLABLE_NZEX	0xA2FC
#define T_UTF_16_YI_SYLLABLE_NZE	0xA2FD
#define T_UTF_16_YI_SYLLABLE_NZUX	0xA2FE
#define T_UTF_16_YI_SYLLABLE_NZU	0xA2FF
#define T_UTF_16_YI_SYLLABLE_NZUP	0xA300
#define T_UTF_16_YI_SYLLABLE_NZURX	0xA301
#define T_UTF_16_YI_SYLLABLE_NZUR	0xA302
#define T_UTF_16_YI_SYLLABLE_NZYT	0xA303
#define T_UTF_16_YI_SYLLABLE_NZYX	0xA304
#define T_UTF_16_YI_SYLLABLE_NZY	0xA305
#define T_UTF_16_YI_SYLLABLE_NZYP	0xA306
#define T_UTF_16_YI_SYLLABLE_NZYRX	0xA307
#define T_UTF_16_YI_SYLLABLE_NZYR	0xA308
#define T_UTF_16_YI_SYLLABLE_SIT	0xA309
#define T_UTF_16_YI_SYLLABLE_SIX	0xA30A
#define T_UTF_16_YI_SYLLABLE_SI	0xA30B
#define T_UTF_16_YI_SYLLABLE_SIP	0xA30C
#define T_UTF_16_YI_SYLLABLE_SIEX	0xA30D
#define T_UTF_16_YI_SYLLABLE_SIE	0xA30E
#define T_UTF_16_YI_SYLLABLE_SIEP	0xA30F
#define T_UTF_16_YI_SYLLABLE_SAT	0xA310
#define T_UTF_16_YI_SYLLABLE_SAX	0xA311
#define T_UTF_16_YI_SYLLABLE_SA	0xA312
#define T_UTF_16_YI_SYLLABLE_SAP	0xA313
#define T_UTF_16_YI_SYLLABLE_SUOX	0xA314
#define T_UTF_16_YI_SYLLABLE_SUO	0xA315
#define T_UTF_16_YI_SYLLABLE_SUOP	0xA316
#define T_UTF_16_YI_SYLLABLE_SOT	0xA317
#define T_UTF_16_YI_SYLLABLE_SOX	0xA318
#define T_UTF_16_YI_SYLLABLE_SO	0xA319
#define T_UTF_16_YI_SYLLABLE_SOP	0xA31A
#define T_UTF_16_YI_SYLLABLE_SEX	0xA31B
#define T_UTF_16_YI_SYLLABLE_SE	0xA31C
#define T_UTF_16_YI_SYLLABLE_SEP	0xA31D
#define T_UTF_16_YI_SYLLABLE_SUT	0xA31E
#define T_UTF_16_YI_SYLLABLE_SUX	0xA31F
#define T_UTF_16_YI_SYLLABLE_SU	0xA320
#define T_UTF_16_YI_SYLLABLE_SUP	0xA321
#define T_UTF_16_YI_SYLLABLE_SURX	0xA322
#define T_UTF_16_YI_SYLLABLE_SUR	0xA323
#define T_UTF_16_YI_SYLLABLE_SYT	0xA324
#define T_UTF_16_YI_SYLLABLE_SYX	0xA325
#define T_UTF_16_YI_SYLLABLE_SY	0xA326
#define T_UTF_16_YI_SYLLABLE_SYP	0xA327
#define T_UTF_16_YI_SYLLABLE_SYRX	0xA328
#define T_UTF_16_YI_SYLLABLE_SYR	0xA329
#define T_UTF_16_YI_SYLLABLE_SSIT	0xA32A
#define T_UTF_16_YI_SYLLABLE_SSIX	0xA32B
#define T_UTF_16_YI_SYLLABLE_SSI	0xA32C
#define T_UTF_16_YI_SYLLABLE_SSIP	0xA32D
#define T_UTF_16_YI_SYLLABLE_SSIEX	0xA32E
#define T_UTF_16_YI_SYLLABLE_SSIE	0xA32F
#define T_UTF_16_YI_SYLLABLE_SSIEP	0xA330
#define T_UTF_16_YI_SYLLABLE_SSAT	0xA331
#define T_UTF_16_YI_SYLLABLE_SSAX	0xA332
#define T_UTF_16_YI_SYLLABLE_SSA	0xA333
#define T_UTF_16_YI_SYLLABLE_SSAP	0xA334
#define T_UTF_16_YI_SYLLABLE_SSOT	0xA335
#define T_UTF_16_YI_SYLLABLE_SSOX	0xA336
#define T_UTF_16_YI_SYLLABLE_SSO	0xA337
#define T_UTF_16_YI_SYLLABLE_SSOP	0xA338
#define T_UTF_16_YI_SYLLABLE_SSEX	0xA339
#define T_UTF_16_YI_SYLLABLE_SSE	0xA33A
#define T_UTF_16_YI_SYLLABLE_SSEP	0xA33B
#define T_UTF_16_YI_SYLLABLE_SSUT	0xA33C
#define T_UTF_16_YI_SYLLABLE_SSUX	0xA33D
#define T_UTF_16_YI_SYLLABLE_SSU	0xA33E
#define T_UTF_16_YI_SYLLABLE_SSUP	0xA33F
#define T_UTF_16_YI_SYLLABLE_SSYT	0xA340
#define T_UTF_16_YI_SYLLABLE_SSYX	0xA341
#define T_UTF_16_YI_SYLLABLE_SSY	0xA342
#define T_UTF_16_YI_SYLLABLE_SSYP	0xA343
#define T_UTF_16_YI_SYLLABLE_SSYRX	0xA344
#define T_UTF_16_YI_SYLLABLE_SSYR	0xA345
#define T_UTF_16_YI_SYLLABLE_ZHAT	0xA346
#define T_UTF_16_YI_SYLLABLE_ZHAX	0xA347
#define T_UTF_16_YI_SYLLABLE_ZHA	0xA348
#define T_UTF_16_YI_SYLLABLE_ZHAP	0xA349
#define T_UTF_16_YI_SYLLABLE_ZHUOX	0xA34A
#define T_UTF_16_YI_SYLLABLE_ZHUO	0xA34B
#define T_UTF_16_YI_SYLLABLE_ZHUOP	0xA34C
#define T_UTF_16_YI_SYLLABLE_ZHOT	0xA34D
#define T_UTF_16_YI_SYLLABLE_ZHOX	0xA34E
#define T_UTF_16_YI_SYLLABLE_ZHO	0xA34F
#define T_UTF_16_YI_SYLLABLE_ZHOP	0xA350
#define T_UTF_16_YI_SYLLABLE_ZHET	0xA351
#define T_UTF_16_YI_SYLLABLE_ZHEX	0xA352
#define T_UTF_16_YI_SYLLABLE_ZHE	0xA353
#define T_UTF_16_YI_SYLLABLE_ZHEP	0xA354
#define T_UTF_16_YI_SYLLABLE_ZHUT	0xA355
#define T_UTF_16_YI_SYLLABLE_ZHUX	0xA356
#define T_UTF_16_YI_SYLLABLE_ZHU	0xA357
#define T_UTF_16_YI_SYLLABLE_ZHUP	0xA358
#define T_UTF_16_YI_SYLLABLE_ZHURX	0xA359
#define T_UTF_16_YI_SYLLABLE_ZHUR	0xA35A
#define T_UTF_16_YI_SYLLABLE_ZHYT	0xA35B
#define T_UTF_16_YI_SYLLABLE_ZHYX	0xA35C
#define T_UTF_16_YI_SYLLABLE_ZHY	0xA35D
#define T_UTF_16_YI_SYLLABLE_ZHYP	0xA35E
#define T_UTF_16_YI_SYLLABLE_ZHYRX	0xA35F
#define T_UTF_16_YI_SYLLABLE_ZHYR	0xA360
#define T_UTF_16_YI_SYLLABLE_CHAT	0xA361
#define T_UTF_16_YI_SYLLABLE_CHAX	0xA362
#define T_UTF_16_YI_SYLLABLE_CHA	0xA363
#define T_UTF_16_YI_SYLLABLE_CHAP	0xA364
#define T_UTF_16_YI_SYLLABLE_CHUOT	0xA365
#define T_UTF_16_YI_SYLLABLE_CHUOX	0xA366
#define T_UTF_16_YI_SYLLABLE_CHUO	0xA367
#define T_UTF_16_YI_SYLLABLE_CHUOP	0xA368
#define T_UTF_16_YI_SYLLABLE_CHOT	0xA369
#define T_UTF_16_YI_SYLLABLE_CHOX	0xA36A
#define T_UTF_16_YI_SYLLABLE_CHO	0xA36B
#define T_UTF_16_YI_SYLLABLE_CHOP	0xA36C
#define T_UTF_16_YI_SYLLABLE_CHET	0xA36D
#define T_UTF_16_YI_SYLLABLE_CHEX	0xA36E
#define T_UTF_16_YI_SYLLABLE_CHE	0xA36F
#define T_UTF_16_YI_SYLLABLE_CHEP	0xA370
#define T_UTF_16_YI_SYLLABLE_CHUX	0xA371
#define T_UTF_16_YI_SYLLABLE_CHU	0xA372
#define T_UTF_16_YI_SYLLABLE_CHUP	0xA373
#define T_UTF_16_YI_SYLLABLE_CHURX	0xA374
#define T_UTF_16_YI_SYLLABLE_CHUR	0xA375
#define T_UTF_16_YI_SYLLABLE_CHYT	0xA376
#define T_UTF_16_YI_SYLLABLE_CHYX	0xA377
#define T_UTF_16_YI_SYLLABLE_CHY	0xA378
#define T_UTF_16_YI_SYLLABLE_CHYP	0xA379
#define T_UTF_16_YI_SYLLABLE_CHYRX	0xA37A
#define T_UTF_16_YI_SYLLABLE_CHYR	0xA37B
#define T_UTF_16_YI_SYLLABLE_RRAX	0xA37C
#define T_UTF_16_YI_SYLLABLE_RRA	0xA37D
#define T_UTF_16_YI_SYLLABLE_RRUOX	0xA37E
#define T_UTF_16_YI_SYLLABLE_RRUO	0xA37F
#define T_UTF_16_YI_SYLLABLE_RROT	0xA380
#define T_UTF_16_YI_SYLLABLE_RROX	0xA381
#define T_UTF_16_YI_SYLLABLE_RRO	0xA382
#define T_UTF_16_YI_SYLLABLE_RROP	0xA383
#define T_UTF_16_YI_SYLLABLE_RRET	0xA384
#define T_UTF_16_YI_SYLLABLE_RREX	0xA385
#define T_UTF_16_YI_SYLLABLE_RRE	0xA386
#define T_UTF_16_YI_SYLLABLE_RREP	0xA387
#define T_UTF_16_YI_SYLLABLE_RRUT	0xA388
#define T_UTF_16_YI_SYLLABLE_RRUX	0xA389
#define T_UTF_16_YI_SYLLABLE_RRU	0xA38A
#define T_UTF_16_YI_SYLLABLE_RRUP	0xA38B
#define T_UTF_16_YI_SYLLABLE_RRURX	0xA38C
#define T_UTF_16_YI_SYLLABLE_RRUR	0xA38D
#define T_UTF_16_YI_SYLLABLE_RRYT	0xA38E
#define T_UTF_16_YI_SYLLABLE_RRYX	0xA38F
#define T_UTF_16_YI_SYLLABLE_RRY	0xA390
#define T_UTF_16_YI_SYLLABLE_RRYP	0xA391
#define T_UTF_16_YI_SYLLABLE_RRYRX	0xA392
#define T_UTF_16_YI_SYLLABLE_RRYR	0xA393
#define T_UTF_16_YI_SYLLABLE_NRAT	0xA394
#define T_UTF_16_YI_SYLLABLE_NRAX	0xA395
#define T_UTF_16_YI_SYLLABLE_NRA	0xA396
#define T_UTF_16_YI_SYLLABLE_NRAP	0xA397
#define T_UTF_16_YI_SYLLABLE_NROX	0xA398
#define T_UTF_16_YI_SYLLABLE_NRO	0xA399
#define T_UTF_16_YI_SYLLABLE_NROP	0xA39A
#define T_UTF_16_YI_SYLLABLE_NRET	0xA39B
#define T_UTF_16_YI_SYLLABLE_NREX	0xA39C
#define T_UTF_16_YI_SYLLABLE_NRE	0xA39D
#define T_UTF_16_YI_SYLLABLE_NREP	0xA39E
#define T_UTF_16_YI_SYLLABLE_NRUT	0xA39F
#define T_UTF_16_YI_SYLLABLE_NRUX	0xA3A0
#define T_UTF_16_YI_SYLLABLE_NRU	0xA3A1
#define T_UTF_16_YI_SYLLABLE_NRUP	0xA3A2
#define T_UTF_16_YI_SYLLABLE_NRURX	0xA3A3
#define T_UTF_16_YI_SYLLABLE_NRUR	0xA3A4
#define T_UTF_16_YI_SYLLABLE_NRYT	0xA3A5
#define T_UTF_16_YI_SYLLABLE_NRYX	0xA3A6
#define T_UTF_16_YI_SYLLABLE_NRY	0xA3A7
#define T_UTF_16_YI_SYLLABLE_NRYP	0xA3A8
#define T_UTF_16_YI_SYLLABLE_NRYRX	0xA3A9
#define T_UTF_16_YI_SYLLABLE_NRYR	0xA3AA
#define T_UTF_16_YI_SYLLABLE_SHAT	0xA3AB
#define T_UTF_16_YI_SYLLABLE_SHAX	0xA3AC
#define T_UTF_16_YI_SYLLABLE_SHA	0xA3AD
#define T_UTF_16_YI_SYLLABLE_SHAP	0xA3AE
#define T_UTF_16_YI_SYLLABLE_SHUOX	0xA3AF
#define T_UTF_16_YI_SYLLABLE_SHUO	0xA3B0
#define T_UTF_16_YI_SYLLABLE_SHUOP	0xA3B1
#define T_UTF_16_YI_SYLLABLE_SHOT	0xA3B2
#define T_UTF_16_YI_SYLLABLE_SHOX	0xA3B3
#define T_UTF_16_YI_SYLLABLE_SHO	0xA3B4
#define T_UTF_16_YI_SYLLABLE_SHOP	0xA3B5
#define T_UTF_16_YI_SYLLABLE_SHET	0xA3B6
#define T_UTF_16_YI_SYLLABLE_SHEX	0xA3B7
#define T_UTF_16_YI_SYLLABLE_SHE	0xA3B8
#define T_UTF_16_YI_SYLLABLE_SHEP	0xA3B9
#define T_UTF_16_YI_SYLLABLE_SHUT	0xA3BA
#define T_UTF_16_YI_SYLLABLE_SHUX	0xA3BB
#define T_UTF_16_YI_SYLLABLE_SHU	0xA3BC
#define T_UTF_16_YI_SYLLABLE_SHUP	0xA3BD
#define T_UTF_16_YI_SYLLABLE_SHURX	0xA3BE
#define T_UTF_16_YI_SYLLABLE_SHUR	0xA3BF
#define T_UTF_16_YI_SYLLABLE_SHYT	0xA3C0
#define T_UTF_16_YI_SYLLABLE_SHYX	0xA3C1
#define T_UTF_16_YI_SYLLABLE_SHY	0xA3C2
#define T_UTF_16_YI_SYLLABLE_SHYP	0xA3C3
#define T_UTF_16_YI_SYLLABLE_SHYRX	0xA3C4
#define T_UTF_16_YI_SYLLABLE_SHYR	0xA3C5
#define T_UTF_16_YI_SYLLABLE_RAT	0xA3C6
#define T_UTF_16_YI_SYLLABLE_RAX	0xA3C7
#define T_UTF_16_YI_SYLLABLE_RA	0xA3C8
#define T_UTF_16_YI_SYLLABLE_RAP	0xA3C9
#define T_UTF_16_YI_SYLLABLE_RUOX	0xA3CA
#define T_UTF_16_YI_SYLLABLE_RUO	0xA3CB
#define T_UTF_16_YI_SYLLABLE_RUOP	0xA3CC
#define T_UTF_16_YI_SYLLABLE_ROT	0xA3CD
#define T_UTF_16_YI_SYLLABLE_ROX	0xA3CE
#define T_UTF_16_YI_SYLLABLE_RO	0xA3CF
#define T_UTF_16_YI_SYLLABLE_ROP	0xA3D0
#define T_UTF_16_YI_SYLLABLE_REX	0xA3D1
#define T_UTF_16_YI_SYLLABLE_RE	0xA3D2
#define T_UTF_16_YI_SYLLABLE_REP	0xA3D3
#define T_UTF_16_YI_SYLLABLE_RUT	0xA3D4
#define T_UTF_16_YI_SYLLABLE_RUX	0xA3D5
#define T_UTF_16_YI_SYLLABLE_RU	0xA3D6
#define T_UTF_16_YI_SYLLABLE_RUP	0xA3D7
#define T_UTF_16_YI_SYLLABLE_RURX	0xA3D8
#define T_UTF_16_YI_SYLLABLE_RUR	0xA3D9
#define T_UTF_16_YI_SYLLABLE_RYT	0xA3DA
#define T_UTF_16_YI_SYLLABLE_RYX	0xA3DB
#define T_UTF_16_YI_SYLLABLE_RY	0xA3DC
#define T_UTF_16_YI_SYLLABLE_RYP	0xA3DD
#define T_UTF_16_YI_SYLLABLE_RYRX	0xA3DE
#define T_UTF_16_YI_SYLLABLE_RYR	0xA3DF
#define T_UTF_16_YI_SYLLABLE_JIT	0xA3E0
#define T_UTF_16_YI_SYLLABLE_JIX	0xA3E1
#define T_UTF_16_YI_SYLLABLE_JI	0xA3E2
#define T_UTF_16_YI_SYLLABLE_JIP	0xA3E3
#define T_UTF_16_YI_SYLLABLE_JIET	0xA3E4
#define T_UTF_16_YI_SYLLABLE_JIEX	0xA3E5
#define T_UTF_16_YI_SYLLABLE_JIE	0xA3E6
#define T_UTF_16_YI_SYLLABLE_JIEP	0xA3E7
#define T_UTF_16_YI_SYLLABLE_JUOT	0xA3E8
#define T_UTF_16_YI_SYLLABLE_JUOX	0xA3E9
#define T_UTF_16_YI_SYLLABLE_JUO	0xA3EA
#define T_UTF_16_YI_SYLLABLE_JUOP	0xA3EB
#define T_UTF_16_YI_SYLLABLE_JOT	0xA3EC
#define T_UTF_16_YI_SYLLABLE_JOX	0xA3ED
#define T_UTF_16_YI_SYLLABLE_JO	0xA3EE
#define T_UTF_16_YI_SYLLABLE_JOP	0xA3EF
#define T_UTF_16_YI_SYLLABLE_JUT	0xA3F0
#define T_UTF_16_YI_SYLLABLE_JUX	0xA3F1
#define T_UTF_16_YI_SYLLABLE_JU	0xA3F2
#define T_UTF_16_YI_SYLLABLE_JUP	0xA3F3
#define T_UTF_16_YI_SYLLABLE_JURX	0xA3F4
#define T_UTF_16_YI_SYLLABLE_JUR	0xA3F5
#define T_UTF_16_YI_SYLLABLE_JYT	0xA3F6
#define T_UTF_16_YI_SYLLABLE_JYX	0xA3F7
#define T_UTF_16_YI_SYLLABLE_JY	0xA3F8
#define T_UTF_16_YI_SYLLABLE_JYP	0xA3F9
#define T_UTF_16_YI_SYLLABLE_JYRX	0xA3FA
#define T_UTF_16_YI_SYLLABLE_JYR	0xA3FB
#define T_UTF_16_YI_SYLLABLE_QIT	0xA3FC
#define T_UTF_16_YI_SYLLABLE_QIX	0xA3FD
#define T_UTF_16_YI_SYLLABLE_QI	0xA3FE
#define T_UTF_16_YI_SYLLABLE_QIP	0xA3FF
#define T_UTF_16_YI_SYLLABLE_QIET	0xA400
#define T_UTF_16_YI_SYLLABLE_QIEX	0xA401
#define T_UTF_16_YI_SYLLABLE_QIE	0xA402
#define T_UTF_16_YI_SYLLABLE_QIEP	0xA403
#define T_UTF_16_YI_SYLLABLE_QUOT	0xA404
#define T_UTF_16_YI_SYLLABLE_QUOX	0xA405
#define T_UTF_16_YI_SYLLABLE_QUO	0xA406
#define T_UTF_16_YI_SYLLABLE_QUOP	0xA407
#define T_UTF_16_YI_SYLLABLE_QOT	0xA408
#define T_UTF_16_YI_SYLLABLE_QOX	0xA409
#define T_UTF_16_YI_SYLLABLE_QO	0xA40A
#define T_UTF_16_YI_SYLLABLE_QOP	0xA40B
#define T_UTF_16_YI_SYLLABLE_QUT	0xA40C
#define T_UTF_16_YI_SYLLABLE_QUX	0xA40D
#define T_UTF_16_YI_SYLLABLE_QU	0xA40E
#define T_UTF_16_YI_SYLLABLE_QUP	0xA40F
#define T_UTF_16_YI_SYLLABLE_QURX	0xA410
#define T_UTF_16_YI_SYLLABLE_QUR	0xA411
#define T_UTF_16_YI_SYLLABLE_QYT	0xA412
#define T_UTF_16_YI_SYLLABLE_QYX	0xA413
#define T_UTF_16_YI_SYLLABLE_QY	0xA414
#define T_UTF_16_YI_SYLLABLE_QYP	0xA415
#define T_UTF_16_YI_SYLLABLE_QYRX	0xA416
#define T_UTF_16_YI_SYLLABLE_QYR	0xA417
#define T_UTF_16_YI_SYLLABLE_JJIT	0xA418
#define T_UTF_16_YI_SYLLABLE_JJIX	0xA419
#define T_UTF_16_YI_SYLLABLE_JJI	0xA41A
#define T_UTF_16_YI_SYLLABLE_JJIP	0xA41B
#define T_UTF_16_YI_SYLLABLE_JJIET	0xA41C
#define T_UTF_16_YI_SYLLABLE_JJIEX	0xA41D
#define T_UTF_16_YI_SYLLABLE_JJIE	0xA41E
#define T_UTF_16_YI_SYLLABLE_JJIEP	0xA41F
#define T_UTF_16_YI_SYLLABLE_JJUOX	0xA420
#define T_UTF_16_YI_SYLLABLE_JJUO	0xA421
#define T_UTF_16_YI_SYLLABLE_JJUOP	0xA422
#define T_UTF_16_YI_SYLLABLE_JJOT	0xA423
#define T_UTF_16_YI_SYLLABLE_JJOX	0xA424
#define T_UTF_16_YI_SYLLABLE_JJO	0xA425
#define T_UTF_16_YI_SYLLABLE_JJOP	0xA426
#define T_UTF_16_YI_SYLLABLE_JJUT	0xA427
#define T_UTF_16_YI_SYLLABLE_JJUX	0xA428
#define T_UTF_16_YI_SYLLABLE_JJU	0xA429
#define T_UTF_16_YI_SYLLABLE_JJUP	0xA42A
#define T_UTF_16_YI_SYLLABLE_JJURX	0xA42B
#define T_UTF_16_YI_SYLLABLE_JJUR	0xA42C
#define T_UTF_16_YI_SYLLABLE_JJYT	0xA42D
#define T_UTF_16_YI_SYLLABLE_JJYX	0xA42E
#define T_UTF_16_YI_SYLLABLE_JJY	0xA42F
#define T_UTF_16_YI_SYLLABLE_JJYP	0xA430
#define T_UTF_16_YI_SYLLABLE_NJIT	0xA431
#define T_UTF_16_YI_SYLLABLE_NJIX	0xA432
#define T_UTF_16_YI_SYLLABLE_NJI	0xA433
#define T_UTF_16_YI_SYLLABLE_NJIP	0xA434
#define T_UTF_16_YI_SYLLABLE_NJIET	0xA435
#define T_UTF_16_YI_SYLLABLE_NJIEX	0xA436
#define T_UTF_16_YI_SYLLABLE_NJIE	0xA437
#define T_UTF_16_YI_SYLLABLE_NJIEP	0xA438
#define T_UTF_16_YI_SYLLABLE_NJUOX	0xA439
#define T_UTF_16_YI_SYLLABLE_NJUO	0xA43A
#define T_UTF_16_YI_SYLLABLE_NJOT	0xA43B
#define T_UTF_16_YI_SYLLABLE_NJOX	0xA43C
#define T_UTF_16_YI_SYLLABLE_NJO	0xA43D
#define T_UTF_16_YI_SYLLABLE_NJOP	0xA43E
#define T_UTF_16_YI_SYLLABLE_NJUX	0xA43F
#define T_UTF_16_YI_SYLLABLE_NJU	0xA440
#define T_UTF_16_YI_SYLLABLE_NJUP	0xA441
#define T_UTF_16_YI_SYLLABLE_NJURX	0xA442
#define T_UTF_16_YI_SYLLABLE_NJUR	0xA443
#define T_UTF_16_YI_SYLLABLE_NJYT	0xA444
#define T_UTF_16_YI_SYLLABLE_NJYX	0xA445
#define T_UTF_16_YI_SYLLABLE_NJY	0xA446
#define T_UTF_16_YI_SYLLABLE_NJYP	0xA447
#define T_UTF_16_YI_SYLLABLE_NJYRX	0xA448
#define T_UTF_16_YI_SYLLABLE_NJYR	0xA449
#define T_UTF_16_YI_SYLLABLE_NYIT	0xA44A
#define T_UTF_16_YI_SYLLABLE_NYIX	0xA44B
#define T_UTF_16_YI_SYLLABLE_NYI	0xA44C
#define T_UTF_16_YI_SYLLABLE_NYIP	0xA44D
#define T_UTF_16_YI_SYLLABLE_NYIET	0xA44E
#define T_UTF_16_YI_SYLLABLE_NYIEX	0xA44F
#define T_UTF_16_YI_SYLLABLE_NYIE	0xA450
#define T_UTF_16_YI_SYLLABLE_NYIEP	0xA451
#define T_UTF_16_YI_SYLLABLE_NYUOX	0xA452
#define T_UTF_16_YI_SYLLABLE_NYUO	0xA453
#define T_UTF_16_YI_SYLLABLE_NYUOP	0xA454
#define T_UTF_16_YI_SYLLABLE_NYOT	0xA455
#define T_UTF_16_YI_SYLLABLE_NYOX	0xA456
#define T_UTF_16_YI_SYLLABLE_NYO	0xA457
#define T_UTF_16_YI_SYLLABLE_NYOP	0xA458
#define T_UTF_16_YI_SYLLABLE_NYUT	0xA459
#define T_UTF_16_YI_SYLLABLE_NYUX	0xA45A
#define T_UTF_16_YI_SYLLABLE_NYU	0xA45B
#define T_UTF_16_YI_SYLLABLE_NYUP	0xA45C
#define T_UTF_16_YI_SYLLABLE_XIT	0xA45D
#define T_UTF_16_YI_SYLLABLE_XIX	0xA45E
#define T_UTF_16_YI_SYLLABLE_XI	0xA45F
#define T_UTF_16_YI_SYLLABLE_XIP	0xA460
#define T_UTF_16_YI_SYLLABLE_XIET	0xA461
#define T_UTF_16_YI_SYLLABLE_XIEX	0xA462
#define T_UTF_16_YI_SYLLABLE_XIE	0xA463
#define T_UTF_16_YI_SYLLABLE_XIEP	0xA464
#define T_UTF_16_YI_SYLLABLE_XUOX	0xA465
#define T_UTF_16_YI_SYLLABLE_XUO	0xA466
#define T_UTF_16_YI_SYLLABLE_XOT	0xA467
#define T_UTF_16_YI_SYLLABLE_XOX	0xA468
#define T_UTF_16_YI_SYLLABLE_XO	0xA469
#define T_UTF_16_YI_SYLLABLE_XOP	0xA46A
#define T_UTF_16_YI_SYLLABLE_XYT	0xA46B
#define T_UTF_16_YI_SYLLABLE_XYX	0xA46C
#define T_UTF_16_YI_SYLLABLE_XY	0xA46D
#define T_UTF_16_YI_SYLLABLE_XYP	0xA46E
#define T_UTF_16_YI_SYLLABLE_XYRX	0xA46F
#define T_UTF_16_YI_SYLLABLE_XYR	0xA470
#define T_UTF_16_YI_SYLLABLE_YIT	0xA471
#define T_UTF_16_YI_SYLLABLE_YIX	0xA472
#define T_UTF_16_YI_SYLLABLE_YI	0xA473
#define T_UTF_16_YI_SYLLABLE_YIP	0xA474
#define T_UTF_16_YI_SYLLABLE_YIET	0xA475
#define T_UTF_16_YI_SYLLABLE_YIEX	0xA476
#define T_UTF_16_YI_SYLLABLE_YIE	0xA477
#define T_UTF_16_YI_SYLLABLE_YIEP	0xA478
#define T_UTF_16_YI_SYLLABLE_YUOT	0xA479
#define T_UTF_16_YI_SYLLABLE_YUOX	0xA47A
#define T_UTF_16_YI_SYLLABLE_YUO	0xA47B
#define T_UTF_16_YI_SYLLABLE_YUOP	0xA47C
#define T_UTF_16_YI_SYLLABLE_YOT	0xA47D
#define T_UTF_16_YI_SYLLABLE_YOX	0xA47E
#define T_UTF_16_YI_SYLLABLE_YO	0xA47F
#define T_UTF_16_YI_SYLLABLE_YOP	0xA480
#define T_UTF_16_YI_SYLLABLE_YUT	0xA481
#define T_UTF_16_YI_SYLLABLE_YUX	0xA482
#define T_UTF_16_YI_SYLLABLE_YU	0xA483
#define T_UTF_16_YI_SYLLABLE_YUP	0xA484
#define T_UTF_16_YI_SYLLABLE_YURX	0xA485
#define T_UTF_16_YI_SYLLABLE_YUR	0xA486
#define T_UTF_16_YI_SYLLABLE_YYT	0xA487
#define T_UTF_16_YI_SYLLABLE_YYX	0xA488
#define T_UTF_16_YI_SYLLABLE_YY	0xA489
#define T_UTF_16_YI_SYLLABLE_YYP	0xA48A
#define T_UTF_16_YI_SYLLABLE_YYRX	0xA48B
#define T_UTF_16_YI_SYLLABLE_YYR	0xA48C
#define T_UTF_16_YI_RADICAL_QOT	0xA490
#define T_UTF_16_YI_RADICAL_LI	0xA491
#define T_UTF_16_YI_RADICAL_KIT	0xA492
#define T_UTF_16_YI_RADICAL_NYIP	0xA493
#define T_UTF_16_YI_RADICAL_CYP	0xA494
#define T_UTF_16_YI_RADICAL_SSI	0xA495
#define T_UTF_16_YI_RADICAL_GGOP	0xA496
#define T_UTF_16_YI_RADICAL_GEP	0xA497
#define T_UTF_16_YI_RADICAL_MI	0xA498
#define T_UTF_16_YI_RADICAL_HXIT	0xA499
#define T_UTF_16_YI_RADICAL_LYR	0xA49A
#define T_UTF_16_YI_RADICAL_BBUT	0xA49B
#define T_UTF_16_YI_RADICAL_MOP	0xA49C
#define T_UTF_16_YI_RADICAL_YO	0xA49D
#define T_UTF_16_YI_RADICAL_PUT	0xA49E
#define T_UTF_16_YI_RADICAL_HXUO	0xA49F
#define T_UTF_16_YI_RADICAL_TAT	0xA4A0
#define T_UTF_16_YI_RADICAL_GA	0xA4A1
#define T_UTF_16_YI_RADICAL_DDUR	0xA4A4
#define T_UTF_16_YI_RADICAL_BUR	0xA4A5
#define T_UTF_16_YI_RADICAL_GGUO	0xA4A6
#define T_UTF_16_YI_RADICAL_NYOP	0xA4A7
#define T_UTF_16_YI_RADICAL_TU	0xA4A8
#define T_UTF_16_YI_RADICAL_OP	0xA4A9
#define T_UTF_16_YI_RADICAL_JJUT	0xA4AA
#define T_UTF_16_YI_RADICAL_ZOT	0xA4AB
#define T_UTF_16_YI_RADICAL_PYT	0xA4AC
#define T_UTF_16_YI_RADICAL_HMO	0xA4AD
#define T_UTF_16_YI_RADICAL_YIT	0xA4AE
#define T_UTF_16_YI_RADICAL_VUR	0xA4AF
#define T_UTF_16_YI_RADICAL_SHY	0xA4B0
#define T_UTF_16_YI_RADICAL_VEP	0xA4B1
#define T_UTF_16_YI_RADICAL_ZA	0xA4B2
#define T_UTF_16_YI_RADICAL_JO	0xA4B3
#define T_UTF_16_YI_RADICAL_JJY	0xA4B5
#define T_UTF_16_YI_RADICAL_GOT	0xA4B6
#define T_UTF_16_YI_RADICAL_JJIE	0xA4B7
#define T_UTF_16_YI_RADICAL_WO	0xA4B8
#define T_UTF_16_YI_RADICAL_DU	0xA4B9
#define T_UTF_16_YI_RADICAL_SHUR	0xA4BA
#define T_UTF_16_YI_RADICAL_LIE	0xA4BB
#define T_UTF_16_YI_RADICAL_CY	0xA4BC
#define T_UTF_16_YI_RADICAL_CUOP	0xA4BD
#define T_UTF_16_YI_RADICAL_CIP	0xA4BE
#define T_UTF_16_YI_RADICAL_HXOP	0xA4BF
#define T_UTF_16_YI_RADICAL_SHAT	0xA4C0
#define T_UTF_16_YI_RADICAL_SHOP	0xA4C2
#define T_UTF_16_YI_RADICAL_CHE	0xA4C3
#define T_UTF_16_YI_RADICAL_ZZIET	0xA4C4
#define T_UTF_16_YI_RADICAL_KE	0xA4C6
#define T_UTF_16_Hangul_Syllable_First	0xAC00
#define T_UTF_16_Hangul_Syllable_Last	0xD7A3
#define T_UTF_16_Non_Private_Use_High_Surrogate_First	0xD800
#define T_UTF_16_Non_Private_Use_High_Surrogate_Last	0xDB7F
#define T_UTF_16_Private_Use_High_Surrogate_First	0xDB80
#define T_UTF_16_Private_Use_High_Surrogate_Last	0xDBFF
#define T_UTF_16_Low_Surrogate_First	0xDC00
#define T_UTF_16_Low_Surrogate_Last	0xDFFF
#define T_UTF_16_Private_Use_First	0xE000
#define T_UTF_16_Private_Use_Last	0xF8FF
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F900	0xF900
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F901	0xF901
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F902	0xF902
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F903	0xF903
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F904	0xF904
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F905	0xF905
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F906	0xF906
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F907	0xF907
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F908	0xF908
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F909	0xF909
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F90A	0xF90A
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F90B	0xF90B
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F90C	0xF90C
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F90D	0xF90D
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F90E	0xF90E
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F90F	0xF90F
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F910	0xF910
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F911	0xF911
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F912	0xF912
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F913	0xF913
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F914	0xF914
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F915	0xF915
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F916	0xF916
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F917	0xF917
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F918	0xF918
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F919	0xF919
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F91A	0xF91A
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F91B	0xF91B
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F91C	0xF91C
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F91D	0xF91D
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F91E	0xF91E
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F91F	0xF91F
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F920	0xF920
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F921	0xF921
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F922	0xF922
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F923	0xF923
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F924	0xF924
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F925	0xF925
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F926	0xF926
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F927	0xF927
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F928	0xF928
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F929	0xF929
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F92A	0xF92A
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F92B	0xF92B
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F92C	0xF92C
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F92D	0xF92D
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F92E	0xF92E
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F92F	0xF92F
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F930	0xF930
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F931	0xF931
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F932	0xF932
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F933	0xF933
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F934	0xF934
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F935	0xF935
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F936	0xF936
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F937	0xF937
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F938	0xF938
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F939	0xF939
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F93A	0xF93A
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F93B	0xF93B
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F93C	0xF93C
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F93D	0xF93D
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F93E	0xF93E
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F93F	0xF93F
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F940	0xF940
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F941	0xF941
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F942	0xF942
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F943	0xF943
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F944	0xF944
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F945	0xF945
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F946	0xF946
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F947	0xF947
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F948	0xF948
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F949	0xF949
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F94A	0xF94A
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F94B	0xF94B
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F94C	0xF94C
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F94D	0xF94D
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F94E	0xF94E
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F94F	0xF94F
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F950	0xF950
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F951	0xF951
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F952	0xF952
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F953	0xF953
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F954	0xF954
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F955	0xF955
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F956	0xF956
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F957	0xF957
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F958	0xF958
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F959	0xF959
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F95A	0xF95A
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F95B	0xF95B
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F95C	0xF95C
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F95D	0xF95D
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F95E	0xF95E
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F95F	0xF95F
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F960	0xF960
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F961	0xF961
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F962	0xF962
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F963	0xF963
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F964	0xF964
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F965	0xF965
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F966	0xF966
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F967	0xF967
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F968	0xF968
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F969	0xF969
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F96A	0xF96A
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F96B	0xF96B
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F96C	0xF96C
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F96D	0xF96D
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F96E	0xF96E
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F96F	0xF96F
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F970	0xF970
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F971	0xF971
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F972	0xF972
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F973	0xF973
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F974	0xF974
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F975	0xF975
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F976	0xF976
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F977	0xF977
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F978	0xF978
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F979	0xF979
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F97A	0xF97A
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F97B	0xF97B
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F97C	0xF97C
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F97D	0xF97D
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F97E	0xF97E
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F97F	0xF97F
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F980	0xF980
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F981	0xF981
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F982	0xF982
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F983	0xF983
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F984	0xF984
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F985	0xF985
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F986	0xF986
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F987	0xF987
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F988	0xF988
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F989	0xF989
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F98A	0xF98A
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F98B	0xF98B
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F98C	0xF98C
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F98D	0xF98D
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F98E	0xF98E
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F98F	0xF98F
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F990	0xF990
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F991	0xF991
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F992	0xF992
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F993	0xF993
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F994	0xF994
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F995	0xF995
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F996	0xF996
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F997	0xF997
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F998	0xF998
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F999	0xF999
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F99A	0xF99A
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F99B	0xF99B
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F99C	0xF99C
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F99D	0xF99D
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F99E	0xF99E
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F99F	0xF99F
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9A0	0xF9A0
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9A1	0xF9A1
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9A2	0xF9A2
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9A3	0xF9A3
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9A4	0xF9A4
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9A5	0xF9A5
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9A6	0xF9A6
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9A7	0xF9A7
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9A8	0xF9A8
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9A9	0xF9A9
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9AA	0xF9AA
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9AB	0xF9AB
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9AC	0xF9AC
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9AD	0xF9AD
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9AE	0xF9AE
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9AF	0xF9AF
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9B0	0xF9B0
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9B1	0xF9B1
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9B2	0xF9B2
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9B3	0xF9B3
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9B4	0xF9B4
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9B5	0xF9B5
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9B6	0xF9B6
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9B7	0xF9B7
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9B8	0xF9B8
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9B9	0xF9B9
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9BA	0xF9BA
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9BB	0xF9BB
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9BC	0xF9BC
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9BD	0xF9BD
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9BE	0xF9BE
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9BF	0xF9BF
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9C0	0xF9C0
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9C1	0xF9C1
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9C2	0xF9C2
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9C3	0xF9C3
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9C4	0xF9C4
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9C5	0xF9C5
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9C6	0xF9C6
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9C7	0xF9C7
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9C8	0xF9C8
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9C9	0xF9C9
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9CA	0xF9CA
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9CB	0xF9CB
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9CC	0xF9CC
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9CD	0xF9CD
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9CE	0xF9CE
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9CF	0xF9CF
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9D0	0xF9D0
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9D1	0xF9D1
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9D2	0xF9D2
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9D3	0xF9D3
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9D4	0xF9D4
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9D5	0xF9D5
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9D6	0xF9D6
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9D7	0xF9D7
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9D8	0xF9D8
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9D9	0xF9D9
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9DA	0xF9DA
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9DB	0xF9DB
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9DC	0xF9DC
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9DD	0xF9DD
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9DE	0xF9DE
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9DF	0xF9DF
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9E0	0xF9E0
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9E1	0xF9E1
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9E2	0xF9E2
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9E3	0xF9E3
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9E4	0xF9E4
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9E5	0xF9E5
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9E6	0xF9E6
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9E7	0xF9E7
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9E8	0xF9E8
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9E9	0xF9E9
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9EA	0xF9EA
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9EB	0xF9EB
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9EC	0xF9EC
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9ED	0xF9ED
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9EE	0xF9EE
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9EF	0xF9EF
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9F0	0xF9F0
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9F1	0xF9F1
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9F2	0xF9F2
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9F3	0xF9F3
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9F4	0xF9F4
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9F5	0xF9F5
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9F6	0xF9F6
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9F7	0xF9F7
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9F8	0xF9F8
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9F9	0xF9F9
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9FA	0xF9FA
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9FB	0xF9FB
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9FC	0xF9FC
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9FD	0xF9FD
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9FE	0xF9FE
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_F9FF	0xF9FF
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA00	0xFA00
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA01	0xFA01
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA02	0xFA02
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA03	0xFA03
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA04	0xFA04
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA05	0xFA05
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA06	0xFA06
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA07	0xFA07
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA08	0xFA08
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA09	0xFA09
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA0A	0xFA0A
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA0B	0xFA0B
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA0C	0xFA0C
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA0D	0xFA0D
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA0E	0xFA0E
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA0F	0xFA0F
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA10	0xFA10
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA11	0xFA11
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA12	0xFA12
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA13	0xFA13
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA14	0xFA14
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA15	0xFA15
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA16	0xFA16
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA17	0xFA17
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA18	0xFA18
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA19	0xFA19
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA1A	0xFA1A
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA1B	0xFA1B
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA1C	0xFA1C
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA1D	0xFA1D
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA1E	0xFA1E
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA1F	0xFA1F
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA20	0xFA20
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA21	0xFA21
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA22	0xFA22
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA23	0xFA23
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA24	0xFA24
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA25	0xFA25
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA26	0xFA26
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA27	0xFA27
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA28	0xFA28
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA29	0xFA29
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA2A	0xFA2A
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA2B	0xFA2B
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA2C	0xFA2C
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_FA2D	0xFA2D
#define T_UTF_16_LATIN_SMALL_LIGATURE_FF	0xFB00
#define T_UTF_16_LATIN_SMALL_LIGATURE_FI	0xFB01
#define T_UTF_16_LATIN_SMALL_LIGATURE_FL	0xFB02
#define T_UTF_16_LATIN_SMALL_LIGATURE_FFI	0xFB03
#define T_UTF_16_LATIN_SMALL_LIGATURE_FFL	0xFB04
#define T_UTF_16_LATIN_SMALL_LIGATURE_LONG_S_T	0xFB05
#define T_UTF_16_LATIN_SMALL_LIGATURE_ST	0xFB06
#define T_UTF_16_ARMENIAN_SMALL_LIGATURE_MEN_NOW	0xFB13
#define T_UTF_16_ARMENIAN_SMALL_LIGATURE_MEN_ECH	0xFB14
#define T_UTF_16_ARMENIAN_SMALL_LIGATURE_MEN_INI	0xFB15
#define T_UTF_16_ARMENIAN_SMALL_LIGATURE_VEW_NOW	0xFB16
#define T_UTF_16_ARMENIAN_SMALL_LIGATURE_MEN_XEH	0xFB17
#define T_UTF_16_HEBREW_LETTER_YOD_WITH_HIRIQ	0xFB1D
#define T_UTF_16_HEBREW_POINT_JUDEO_SPANISH_VARIKA	0xFB1E
#define T_UTF_16_HEBREW_LIGATURE_YIDDISH_YOD_YOD_PATAH	0xFB1F
#define T_UTF_16_HEBREW_LETTER_ALTERNATIVE_AYIN	0xFB20
#define T_UTF_16_HEBREW_LETTER_WIDE_ALEF	0xFB21
#define T_UTF_16_HEBREW_LETTER_WIDE_DALET	0xFB22
#define T_UTF_16_HEBREW_LETTER_WIDE_HE	0xFB23
#define T_UTF_16_HEBREW_LETTER_WIDE_KAF	0xFB24
#define T_UTF_16_HEBREW_LETTER_WIDE_LAMED	0xFB25
#define T_UTF_16_HEBREW_LETTER_WIDE_FINAL_MEM	0xFB26
#define T_UTF_16_HEBREW_LETTER_WIDE_RESH	0xFB27
#define T_UTF_16_HEBREW_LETTER_WIDE_TAV	0xFB28
#define T_UTF_16_HEBREW_LETTER_ALTERNATIVE_PLUS_SIGN	0xFB29
#define T_UTF_16_HEBREW_LETTER_SHIN_WITH_SHIN_DOT	0xFB2A
#define T_UTF_16_HEBREW_LETTER_SHIN_WITH_SIN_DOT	0xFB2B
#define T_UTF_16_HEBREW_LETTER_SHIN_WITH_DAGESH_AND_SHIN_DOT	0xFB2C
#define T_UTF_16_HEBREW_LETTER_SHIN_WITH_DAGESH_AND_SIN_DOT	0xFB2D
#define T_UTF_16_HEBREW_LETTER_ALEF_WITH_PATAH	0xFB2E
#define T_UTF_16_HEBREW_LETTER_ALEF_WITH_QAMATS	0xFB2F
#define T_UTF_16_HEBREW_LETTER_ALEF_WITH_MAPIQ	0xFB30
#define T_UTF_16_HEBREW_LETTER_BET_WITH_DAGESH	0xFB31
#define T_UTF_16_HEBREW_LETTER_GIMEL_WITH_DAGESH	0xFB32
#define T_UTF_16_HEBREW_LETTER_DALET_WITH_DAGESH	0xFB33
#define T_UTF_16_HEBREW_LETTER_HE_WITH_MAPIQ	0xFB34
#define T_UTF_16_HEBREW_LETTER_VAV_WITH_DAGESH	0xFB35
#define T_UTF_16_HEBREW_LETTER_ZAYIN_WITH_DAGESH	0xFB36
#define T_UTF_16_HEBREW_LETTER_TET_WITH_DAGESH	0xFB38
#define T_UTF_16_HEBREW_LETTER_YOD_WITH_DAGESH	0xFB39
#define T_UTF_16_HEBREW_LETTER_FINAL_KAF_WITH_DAGESH	0xFB3A
#define T_UTF_16_HEBREW_LETTER_KAF_WITH_DAGESH	0xFB3B
#define T_UTF_16_HEBREW_LETTER_LAMED_WITH_DAGESH	0xFB3C
#define T_UTF_16_HEBREW_LETTER_MEM_WITH_DAGESH	0xFB3E
#define T_UTF_16_HEBREW_LETTER_NUN_WITH_DAGESH	0xFB40
#define T_UTF_16_HEBREW_LETTER_SAMEKH_WITH_DAGESH	0xFB41
#define T_UTF_16_HEBREW_LETTER_FINAL_PE_WITH_DAGESH	0xFB43
#define T_UTF_16_HEBREW_LETTER_PE_WITH_DAGESH	0xFB44
#define T_UTF_16_HEBREW_LETTER_TSADI_WITH_DAGESH	0xFB46
#define T_UTF_16_HEBREW_LETTER_QOF_WITH_DAGESH	0xFB47
#define T_UTF_16_HEBREW_LETTER_RESH_WITH_DAGESH	0xFB48
#define T_UTF_16_HEBREW_LETTER_SHIN_WITH_DAGESH	0xFB49
#define T_UTF_16_HEBREW_LETTER_TAV_WITH_DAGESH	0xFB4A
#define T_UTF_16_HEBREW_LETTER_VAV_WITH_HOLAM	0xFB4B
#define T_UTF_16_HEBREW_LETTER_BET_WITH_RAFE	0xFB4C
#define T_UTF_16_HEBREW_LETTER_KAF_WITH_RAFE	0xFB4D
#define T_UTF_16_HEBREW_LETTER_PE_WITH_RAFE	0xFB4E
#define T_UTF_16_HEBREW_LIGATURE_ALEF_LAMED	0xFB4F
#define T_UTF_16_ARABIC_LETTER_ALEF_WASLA_ISOLATED_FORM	0xFB50
#define T_UTF_16_ARABIC_LETTER_ALEF_WASLA_FINAL_FORM	0xFB51
#define T_UTF_16_ARABIC_LETTER_BEEH_ISOLATED_FORM	0xFB52
#define T_UTF_16_ARABIC_LETTER_BEEH_FINAL_FORM	0xFB53
#define T_UTF_16_ARABIC_LETTER_BEEH_INITIAL_FORM	0xFB54
#define T_UTF_16_ARABIC_LETTER_BEEH_MEDIAL_FORM	0xFB55
#define T_UTF_16_ARABIC_LETTER_PEH_ISOLATED_FORM	0xFB56
#define T_UTF_16_ARABIC_LETTER_PEH_FINAL_FORM	0xFB57
#define T_UTF_16_ARABIC_LETTER_PEH_INITIAL_FORM	0xFB58
#define T_UTF_16_ARABIC_LETTER_PEH_MEDIAL_FORM	0xFB59
#define T_UTF_16_ARABIC_LETTER_BEHEH_ISOLATED_FORM	0xFB5A
#define T_UTF_16_ARABIC_LETTER_BEHEH_FINAL_FORM	0xFB5B
#define T_UTF_16_ARABIC_LETTER_BEHEH_INITIAL_FORM	0xFB5C
#define T_UTF_16_ARABIC_LETTER_BEHEH_MEDIAL_FORM	0xFB5D
#define T_UTF_16_ARABIC_LETTER_TTEHEH_ISOLATED_FORM	0xFB5E
#define T_UTF_16_ARABIC_LETTER_TTEHEH_FINAL_FORM	0xFB5F
#define T_UTF_16_ARABIC_LETTER_TTEHEH_INITIAL_FORM	0xFB60
#define T_UTF_16_ARABIC_LETTER_TTEHEH_MEDIAL_FORM	0xFB61
#define T_UTF_16_ARABIC_LETTER_TEHEH_ISOLATED_FORM	0xFB62
#define T_UTF_16_ARABIC_LETTER_TEHEH_FINAL_FORM	0xFB63
#define T_UTF_16_ARABIC_LETTER_TEHEH_INITIAL_FORM	0xFB64
#define T_UTF_16_ARABIC_LETTER_TEHEH_MEDIAL_FORM	0xFB65
#define T_UTF_16_ARABIC_LETTER_TTEH_ISOLATED_FORM	0xFB66
#define T_UTF_16_ARABIC_LETTER_TTEH_FINAL_FORM	0xFB67
#define T_UTF_16_ARABIC_LETTER_TTEH_INITIAL_FORM	0xFB68
#define T_UTF_16_ARABIC_LETTER_TTEH_MEDIAL_FORM	0xFB69
#define T_UTF_16_ARABIC_LETTER_VEH_ISOLATED_FORM	0xFB6A
#define T_UTF_16_ARABIC_LETTER_VEH_FINAL_FORM	0xFB6B
#define T_UTF_16_ARABIC_LETTER_VEH_INITIAL_FORM	0xFB6C
#define T_UTF_16_ARABIC_LETTER_VEH_MEDIAL_FORM	0xFB6D
#define T_UTF_16_ARABIC_LETTER_PEHEH_ISOLATED_FORM	0xFB6E
#define T_UTF_16_ARABIC_LETTER_PEHEH_FINAL_FORM	0xFB6F
#define T_UTF_16_ARABIC_LETTER_PEHEH_INITIAL_FORM	0xFB70
#define T_UTF_16_ARABIC_LETTER_PEHEH_MEDIAL_FORM	0xFB71
#define T_UTF_16_ARABIC_LETTER_DYEH_ISOLATED_FORM	0xFB72
#define T_UTF_16_ARABIC_LETTER_DYEH_FINAL_FORM	0xFB73
#define T_UTF_16_ARABIC_LETTER_DYEH_INITIAL_FORM	0xFB74
#define T_UTF_16_ARABIC_LETTER_DYEH_MEDIAL_FORM	0xFB75
#define T_UTF_16_ARABIC_LETTER_NYEH_ISOLATED_FORM	0xFB76
#define T_UTF_16_ARABIC_LETTER_NYEH_FINAL_FORM	0xFB77
#define T_UTF_16_ARABIC_LETTER_NYEH_INITIAL_FORM	0xFB78
#define T_UTF_16_ARABIC_LETTER_NYEH_MEDIAL_FORM	0xFB79
#define T_UTF_16_ARABIC_LETTER_TCHEH_ISOLATED_FORM	0xFB7A
#define T_UTF_16_ARABIC_LETTER_TCHEH_FINAL_FORM	0xFB7B
#define T_UTF_16_ARABIC_LETTER_TCHEH_INITIAL_FORM	0xFB7C
#define T_UTF_16_ARABIC_LETTER_TCHEH_MEDIAL_FORM	0xFB7D
#define T_UTF_16_ARABIC_LETTER_TCHEHEH_ISOLATED_FORM	0xFB7E
#define T_UTF_16_ARABIC_LETTER_TCHEHEH_FINAL_FORM	0xFB7F
#define T_UTF_16_ARABIC_LETTER_TCHEHEH_INITIAL_FORM	0xFB80
#define T_UTF_16_ARABIC_LETTER_TCHEHEH_MEDIAL_FORM	0xFB81
#define T_UTF_16_ARABIC_LETTER_DDAHAL_ISOLATED_FORM	0xFB82
#define T_UTF_16_ARABIC_LETTER_DDAHAL_FINAL_FORM	0xFB83
#define T_UTF_16_ARABIC_LETTER_DAHAL_ISOLATED_FORM	0xFB84
#define T_UTF_16_ARABIC_LETTER_DAHAL_FINAL_FORM	0xFB85
#define T_UTF_16_ARABIC_LETTER_DUL_ISOLATED_FORM	0xFB86
#define T_UTF_16_ARABIC_LETTER_DUL_FINAL_FORM	0xFB87
#define T_UTF_16_ARABIC_LETTER_DDAL_ISOLATED_FORM	0xFB88
#define T_UTF_16_ARABIC_LETTER_DDAL_FINAL_FORM	0xFB89
#define T_UTF_16_ARABIC_LETTER_JEH_ISOLATED_FORM	0xFB8A
#define T_UTF_16_ARABIC_LETTER_JEH_FINAL_FORM	0xFB8B
#define T_UTF_16_ARABIC_LETTER_RREH_ISOLATED_FORM	0xFB8C
#define T_UTF_16_ARABIC_LETTER_RREH_FINAL_FORM	0xFB8D
#define T_UTF_16_ARABIC_LETTER_KEHEH_ISOLATED_FORM	0xFB8E
#define T_UTF_16_ARABIC_LETTER_KEHEH_FINAL_FORM	0xFB8F
#define T_UTF_16_ARABIC_LETTER_KEHEH_INITIAL_FORM	0xFB90
#define T_UTF_16_ARABIC_LETTER_KEHEH_MEDIAL_FORM	0xFB91
#define T_UTF_16_ARABIC_LETTER_GAF_ISOLATED_FORM	0xFB92
#define T_UTF_16_ARABIC_LETTER_GAF_FINAL_FORM	0xFB93
#define T_UTF_16_ARABIC_LETTER_GAF_INITIAL_FORM	0xFB94
#define T_UTF_16_ARABIC_LETTER_GAF_MEDIAL_FORM	0xFB95
#define T_UTF_16_ARABIC_LETTER_GUEH_ISOLATED_FORM	0xFB96
#define T_UTF_16_ARABIC_LETTER_GUEH_FINAL_FORM	0xFB97
#define T_UTF_16_ARABIC_LETTER_GUEH_INITIAL_FORM	0xFB98
#define T_UTF_16_ARABIC_LETTER_GUEH_MEDIAL_FORM	0xFB99
#define T_UTF_16_ARABIC_LETTER_NGOEH_ISOLATED_FORM	0xFB9A
#define T_UTF_16_ARABIC_LETTER_NGOEH_FINAL_FORM	0xFB9B
#define T_UTF_16_ARABIC_LETTER_NGOEH_INITIAL_FORM	0xFB9C
#define T_UTF_16_ARABIC_LETTER_NGOEH_MEDIAL_FORM	0xFB9D
#define T_UTF_16_ARABIC_LETTER_NOON_GHUNNA_ISOLATED_FORM	0xFB9E
#define T_UTF_16_ARABIC_LETTER_NOON_GHUNNA_FINAL_FORM	0xFB9F
#define T_UTF_16_ARABIC_LETTER_RNOON_ISOLATED_FORM	0xFBA0
#define T_UTF_16_ARABIC_LETTER_RNOON_FINAL_FORM	0xFBA1
#define T_UTF_16_ARABIC_LETTER_RNOON_INITIAL_FORM	0xFBA2
#define T_UTF_16_ARABIC_LETTER_RNOON_MEDIAL_FORM	0xFBA3
#define T_UTF_16_ARABIC_LETTER_HEH_WITH_YEH_ABOVE_ISOLATED_FORM	0xFBA4
#define T_UTF_16_ARABIC_LETTER_HEH_WITH_YEH_ABOVE_FINAL_FORM	0xFBA5
#define T_UTF_16_ARABIC_LETTER_HEH_GOAL_ISOLATED_FORM	0xFBA6
#define T_UTF_16_ARABIC_LETTER_HEH_GOAL_FINAL_FORM	0xFBA7
#define T_UTF_16_ARABIC_LETTER_HEH_GOAL_INITIAL_FORM	0xFBA8
#define T_UTF_16_ARABIC_LETTER_HEH_GOAL_MEDIAL_FORM	0xFBA9
#define T_UTF_16_ARABIC_LETTER_HEH_DOACHASHMEE_ISOLATED_FORM	0xFBAA
#define T_UTF_16_ARABIC_LETTER_HEH_DOACHASHMEE_FINAL_FORM	0xFBAB
#define T_UTF_16_ARABIC_LETTER_HEH_DOACHASHMEE_INITIAL_FORM	0xFBAC
#define T_UTF_16_ARABIC_LETTER_HEH_DOACHASHMEE_MEDIAL_FORM	0xFBAD
#define T_UTF_16_ARABIC_LETTER_YEH_BARREE_ISOLATED_FORM	0xFBAE
#define T_UTF_16_ARABIC_LETTER_YEH_BARREE_FINAL_FORM	0xFBAF
#define T_UTF_16_ARABIC_LETTER_YEH_BARREE_WITH_HAMZA_ABOVE_ISOLATED_FORM	0xFBB0
#define T_UTF_16_ARABIC_LETTER_YEH_BARREE_WITH_HAMZA_ABOVE_FINAL_FORM	0xFBB1
#define T_UTF_16_ARABIC_LETTER_NG_ISOLATED_FORM	0xFBD3
#define T_UTF_16_ARABIC_LETTER_NG_FINAL_FORM	0xFBD4
#define T_UTF_16_ARABIC_LETTER_NG_INITIAL_FORM	0xFBD5
#define T_UTF_16_ARABIC_LETTER_NG_MEDIAL_FORM	0xFBD6
#define T_UTF_16_ARABIC_LETTER_U_ISOLATED_FORM	0xFBD7
#define T_UTF_16_ARABIC_LETTER_U_FINAL_FORM	0xFBD8
#define T_UTF_16_ARABIC_LETTER_OE_ISOLATED_FORM	0xFBD9
#define T_UTF_16_ARABIC_LETTER_OE_FINAL_FORM	0xFBDA
#define T_UTF_16_ARABIC_LETTER_YU_ISOLATED_FORM	0xFBDB
#define T_UTF_16_ARABIC_LETTER_YU_FINAL_FORM	0xFBDC
#define T_UTF_16_ARABIC_LETTER_U_WITH_HAMZA_ABOVE_ISOLATED_FORM	0xFBDD
#define T_UTF_16_ARABIC_LETTER_VE_ISOLATED_FORM	0xFBDE
#define T_UTF_16_ARABIC_LETTER_VE_FINAL_FORM	0xFBDF
#define T_UTF_16_ARABIC_LETTER_KIRGHIZ_OE_ISOLATED_FORM	0xFBE0
#define T_UTF_16_ARABIC_LETTER_KIRGHIZ_OE_FINAL_FORM	0xFBE1
#define T_UTF_16_ARABIC_LETTER_KIRGHIZ_YU_ISOLATED_FORM	0xFBE2
#define T_UTF_16_ARABIC_LETTER_KIRGHIZ_YU_FINAL_FORM	0xFBE3
#define T_UTF_16_ARABIC_LETTER_E_ISOLATED_FORM	0xFBE4
#define T_UTF_16_ARABIC_LETTER_E_FINAL_FORM	0xFBE5
#define T_UTF_16_ARABIC_LETTER_E_INITIAL_FORM	0xFBE6
#define T_UTF_16_ARABIC_LETTER_E_MEDIAL_FORM	0xFBE7
#define T_UTF_16_ARABIC_LETTER_UIGHUR_KAZAKH_KIRGHIZ_ALEF_MAKSURA_INITIAL_FORM	0xFBE8
#define T_UTF_16_ARABIC_LETTER_UIGHUR_KAZAKH_KIRGHIZ_ALEF_MAKSURA_MEDIAL_FORM	0xFBE9
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_ALEF_ISOLATED_FORM	0xFBEA
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_ALEF_FINAL_FORM	0xFBEB
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_AE_ISOLATED_FORM	0xFBEC
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_AE_FINAL_FORM	0xFBED
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_WAW_ISOLATED_FORM	0xFBEE
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_WAW_FINAL_FORM	0xFBEF
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_U_ISOLATED_FORM	0xFBF0
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_U_FINAL_FORM	0xFBF1
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_OE_ISOLATED_FORM	0xFBF2
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_OE_FINAL_FORM	0xFBF3
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_YU_ISOLATED_FORM	0xFBF4
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_YU_FINAL_FORM	0xFBF5
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_E_ISOLATED_FORM	0xFBF6
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_E_FINAL_FORM	0xFBF7
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_E_INITIAL_FORM	0xFBF8
#define T_UTF_16_ARABIC_LIGATURE_UIGHUR_KIRGHIZ_YEH_WITH_HAMZA_ABOVE_WITH_ALEF_MAKSURA_ISOLATED_FORM	0xFBF9
#define T_UTF_16_ARABIC_LIGATURE_UIGHUR_KIRGHIZ_YEH_WITH_HAMZA_ABOVE_WITH_ALEF_MAKSURA_FINAL_FORM	0xFBFA
#define T_UTF_16_ARABIC_LIGATURE_UIGHUR_KIRGHIZ_YEH_WITH_HAMZA_ABOVE_WITH_ALEF_MAKSURA_INITIAL_FORM	0xFBFB
#define T_UTF_16_ARABIC_LETTER_FARSI_YEH_ISOLATED_FORM	0xFBFC
#define T_UTF_16_ARABIC_LETTER_FARSI_YEH_FINAL_FORM	0xFBFD
#define T_UTF_16_ARABIC_LETTER_FARSI_YEH_INITIAL_FORM	0xFBFE
#define T_UTF_16_ARABIC_LETTER_FARSI_YEH_MEDIAL_FORM	0xFBFF
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_JEEM_ISOLATED_FORM	0xFC00
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_HAH_ISOLATED_FORM	0xFC01
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_MEEM_ISOLATED_FORM	0xFC02
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_ALEF_MAKSURA_ISOLATED_FORM	0xFC03
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_YEH_ISOLATED_FORM	0xFC04
#define T_UTF_16_ARABIC_LIGATURE_BEH_WITH_JEEM_ISOLATED_FORM	0xFC05
#define T_UTF_16_ARABIC_LIGATURE_BEH_WITH_HAH_ISOLATED_FORM	0xFC06
#define T_UTF_16_ARABIC_LIGATURE_BEH_WITH_KHAH_ISOLATED_FORM	0xFC07
#define T_UTF_16_ARABIC_LIGATURE_BEH_WITH_MEEM_ISOLATED_FORM	0xFC08
#define T_UTF_16_ARABIC_LIGATURE_BEH_WITH_ALEF_MAKSURA_ISOLATED_FORM	0xFC09
#define T_UTF_16_ARABIC_LIGATURE_BEH_WITH_YEH_ISOLATED_FORM	0xFC0A
#define T_UTF_16_ARABIC_LIGATURE_TEH_WITH_JEEM_ISOLATED_FORM	0xFC0B
#define T_UTF_16_ARABIC_LIGATURE_TEH_WITH_HAH_ISOLATED_FORM	0xFC0C
#define T_UTF_16_ARABIC_LIGATURE_TEH_WITH_KHAH_ISOLATED_FORM	0xFC0D
#define T_UTF_16_ARABIC_LIGATURE_TEH_WITH_MEEM_ISOLATED_FORM	0xFC0E
#define T_UTF_16_ARABIC_LIGATURE_TEH_WITH_ALEF_MAKSURA_ISOLATED_FORM	0xFC0F
#define T_UTF_16_ARABIC_LIGATURE_TEH_WITH_YEH_ISOLATED_FORM	0xFC10
#define T_UTF_16_ARABIC_LIGATURE_THEH_WITH_JEEM_ISOLATED_FORM	0xFC11
#define T_UTF_16_ARABIC_LIGATURE_THEH_WITH_MEEM_ISOLATED_FORM	0xFC12
#define T_UTF_16_ARABIC_LIGATURE_THEH_WITH_ALEF_MAKSURA_ISOLATED_FORM	0xFC13
#define T_UTF_16_ARABIC_LIGATURE_THEH_WITH_YEH_ISOLATED_FORM	0xFC14
#define T_UTF_16_ARABIC_LIGATURE_JEEM_WITH_HAH_ISOLATED_FORM	0xFC15
#define T_UTF_16_ARABIC_LIGATURE_JEEM_WITH_MEEM_ISOLATED_FORM	0xFC16
#define T_UTF_16_ARABIC_LIGATURE_HAH_WITH_JEEM_ISOLATED_FORM	0xFC17
#define T_UTF_16_ARABIC_LIGATURE_HAH_WITH_MEEM_ISOLATED_FORM	0xFC18
#define T_UTF_16_ARABIC_LIGATURE_KHAH_WITH_JEEM_ISOLATED_FORM	0xFC19
#define T_UTF_16_ARABIC_LIGATURE_KHAH_WITH_HAH_ISOLATED_FORM	0xFC1A
#define T_UTF_16_ARABIC_LIGATURE_KHAH_WITH_MEEM_ISOLATED_FORM	0xFC1B
#define T_UTF_16_ARABIC_LIGATURE_SEEN_WITH_JEEM_ISOLATED_FORM	0xFC1C
#define T_UTF_16_ARABIC_LIGATURE_SEEN_WITH_HAH_ISOLATED_FORM	0xFC1D
#define T_UTF_16_ARABIC_LIGATURE_SEEN_WITH_KHAH_ISOLATED_FORM	0xFC1E
#define T_UTF_16_ARABIC_LIGATURE_SEEN_WITH_MEEM_ISOLATED_FORM	0xFC1F
#define T_UTF_16_ARABIC_LIGATURE_SAD_WITH_HAH_ISOLATED_FORM	0xFC20
#define T_UTF_16_ARABIC_LIGATURE_SAD_WITH_MEEM_ISOLATED_FORM	0xFC21
#define T_UTF_16_ARABIC_LIGATURE_DAD_WITH_JEEM_ISOLATED_FORM	0xFC22
#define T_UTF_16_ARABIC_LIGATURE_DAD_WITH_HAH_ISOLATED_FORM	0xFC23
#define T_UTF_16_ARABIC_LIGATURE_DAD_WITH_KHAH_ISOLATED_FORM	0xFC24
#define T_UTF_16_ARABIC_LIGATURE_DAD_WITH_MEEM_ISOLATED_FORM	0xFC25
#define T_UTF_16_ARABIC_LIGATURE_TAH_WITH_HAH_ISOLATED_FORM	0xFC26
#define T_UTF_16_ARABIC_LIGATURE_TAH_WITH_MEEM_ISOLATED_FORM	0xFC27
#define T_UTF_16_ARABIC_LIGATURE_ZAH_WITH_MEEM_ISOLATED_FORM	0xFC28
#define T_UTF_16_ARABIC_LIGATURE_AIN_WITH_JEEM_ISOLATED_FORM	0xFC29
#define T_UTF_16_ARABIC_LIGATURE_AIN_WITH_MEEM_ISOLATED_FORM	0xFC2A
#define T_UTF_16_ARABIC_LIGATURE_GHAIN_WITH_JEEM_ISOLATED_FORM	0xFC2B
#define T_UTF_16_ARABIC_LIGATURE_GHAIN_WITH_MEEM_ISOLATED_FORM	0xFC2C
#define T_UTF_16_ARABIC_LIGATURE_FEH_WITH_JEEM_ISOLATED_FORM	0xFC2D
#define T_UTF_16_ARABIC_LIGATURE_FEH_WITH_HAH_ISOLATED_FORM	0xFC2E
#define T_UTF_16_ARABIC_LIGATURE_FEH_WITH_KHAH_ISOLATED_FORM	0xFC2F
#define T_UTF_16_ARABIC_LIGATURE_FEH_WITH_MEEM_ISOLATED_FORM	0xFC30
#define T_UTF_16_ARABIC_LIGATURE_FEH_WITH_ALEF_MAKSURA_ISOLATED_FORM	0xFC31
#define T_UTF_16_ARABIC_LIGATURE_FEH_WITH_YEH_ISOLATED_FORM	0xFC32
#define T_UTF_16_ARABIC_LIGATURE_QAF_WITH_HAH_ISOLATED_FORM	0xFC33
#define T_UTF_16_ARABIC_LIGATURE_QAF_WITH_MEEM_ISOLATED_FORM	0xFC34
#define T_UTF_16_ARABIC_LIGATURE_QAF_WITH_ALEF_MAKSURA_ISOLATED_FORM	0xFC35
#define T_UTF_16_ARABIC_LIGATURE_QAF_WITH_YEH_ISOLATED_FORM	0xFC36
#define T_UTF_16_ARABIC_LIGATURE_KAF_WITH_ALEF_ISOLATED_FORM	0xFC37
#define T_UTF_16_ARABIC_LIGATURE_KAF_WITH_JEEM_ISOLATED_FORM	0xFC38
#define T_UTF_16_ARABIC_LIGATURE_KAF_WITH_HAH_ISOLATED_FORM	0xFC39
#define T_UTF_16_ARABIC_LIGATURE_KAF_WITH_KHAH_ISOLATED_FORM	0xFC3A
#define T_UTF_16_ARABIC_LIGATURE_KAF_WITH_LAM_ISOLATED_FORM	0xFC3B
#define T_UTF_16_ARABIC_LIGATURE_KAF_WITH_MEEM_ISOLATED_FORM	0xFC3C
#define T_UTF_16_ARABIC_LIGATURE_KAF_WITH_ALEF_MAKSURA_ISOLATED_FORM	0xFC3D
#define T_UTF_16_ARABIC_LIGATURE_KAF_WITH_YEH_ISOLATED_FORM	0xFC3E
#define T_UTF_16_ARABIC_LIGATURE_LAM_WITH_JEEM_ISOLATED_FORM	0xFC3F
#define T_UTF_16_ARABIC_LIGATURE_LAM_WITH_HAH_ISOLATED_FORM	0xFC40
#define T_UTF_16_ARABIC_LIGATURE_LAM_WITH_KHAH_ISOLATED_FORM	0xFC41
#define T_UTF_16_ARABIC_LIGATURE_LAM_WITH_MEEM_ISOLATED_FORM	0xFC42
#define T_UTF_16_ARABIC_LIGATURE_LAM_WITH_ALEF_MAKSURA_ISOLATED_FORM	0xFC43
#define T_UTF_16_ARABIC_LIGATURE_LAM_WITH_YEH_ISOLATED_FORM	0xFC44
#define T_UTF_16_ARABIC_LIGATURE_MEEM_WITH_JEEM_ISOLATED_FORM	0xFC45
#define T_UTF_16_ARABIC_LIGATURE_MEEM_WITH_HAH_ISOLATED_FORM	0xFC46
#define T_UTF_16_ARABIC_LIGATURE_MEEM_WITH_KHAH_ISOLATED_FORM	0xFC47
#define T_UTF_16_ARABIC_LIGATURE_MEEM_WITH_MEEM_ISOLATED_FORM	0xFC48
#define T_UTF_16_ARABIC_LIGATURE_MEEM_WITH_ALEF_MAKSURA_ISOLATED_FORM	0xFC49
#define T_UTF_16_ARABIC_LIGATURE_MEEM_WITH_YEH_ISOLATED_FORM	0xFC4A
#define T_UTF_16_ARABIC_LIGATURE_NOON_WITH_JEEM_ISOLATED_FORM	0xFC4B
#define T_UTF_16_ARABIC_LIGATURE_NOON_WITH_HAH_ISOLATED_FORM	0xFC4C
#define T_UTF_16_ARABIC_LIGATURE_NOON_WITH_KHAH_ISOLATED_FORM	0xFC4D
#define T_UTF_16_ARABIC_LIGATURE_NOON_WITH_MEEM_ISOLATED_FORM	0xFC4E
#define T_UTF_16_ARABIC_LIGATURE_NOON_WITH_ALEF_MAKSURA_ISOLATED_FORM	0xFC4F
#define T_UTF_16_ARABIC_LIGATURE_NOON_WITH_YEH_ISOLATED_FORM	0xFC50
#define T_UTF_16_ARABIC_LIGATURE_HEH_WITH_JEEM_ISOLATED_FORM	0xFC51
#define T_UTF_16_ARABIC_LIGATURE_HEH_WITH_MEEM_ISOLATED_FORM	0xFC52
#define T_UTF_16_ARABIC_LIGATURE_HEH_WITH_ALEF_MAKSURA_ISOLATED_FORM	0xFC53
#define T_UTF_16_ARABIC_LIGATURE_HEH_WITH_YEH_ISOLATED_FORM	0xFC54
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_JEEM_ISOLATED_FORM	0xFC55
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_HAH_ISOLATED_FORM	0xFC56
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_KHAH_ISOLATED_FORM	0xFC57
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_MEEM_ISOLATED_FORM	0xFC58
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_ALEF_MAKSURA_ISOLATED_FORM	0xFC59
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_YEH_ISOLATED_FORM	0xFC5A
#define T_UTF_16_ARABIC_LIGATURE_THAL_WITH_SUPERSCRIPT_ALEF_ISOLATED_FORM	0xFC5B
#define T_UTF_16_ARABIC_LIGATURE_REH_WITH_SUPERSCRIPT_ALEF_ISOLATED_FORM	0xFC5C
#define T_UTF_16_ARABIC_LIGATURE_ALEF_MAKSURA_WITH_SUPERSCRIPT_ALEF_ISOLATED_FORM	0xFC5D
#define T_UTF_16_ARABIC_LIGATURE_SHADDA_WITH_DAMMATAN_ISOLATED_FORM	0xFC5E
#define T_UTF_16_ARABIC_LIGATURE_SHADDA_WITH_KASRATAN_ISOLATED_FORM	0xFC5F
#define T_UTF_16_ARABIC_LIGATURE_SHADDA_WITH_FATHA_ISOLATED_FORM	0xFC60
#define T_UTF_16_ARABIC_LIGATURE_SHADDA_WITH_DAMMA_ISOLATED_FORM	0xFC61
#define T_UTF_16_ARABIC_LIGATURE_SHADDA_WITH_KASRA_ISOLATED_FORM	0xFC62
#define T_UTF_16_ARABIC_LIGATURE_SHADDA_WITH_SUPERSCRIPT_ALEF_ISOLATED_FORM	0xFC63
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_REH_FINAL_FORM	0xFC64
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_ZAIN_FINAL_FORM	0xFC65
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_MEEM_FINAL_FORM	0xFC66
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_NOON_FINAL_FORM	0xFC67
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_ALEF_MAKSURA_FINAL_FORM	0xFC68
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_YEH_FINAL_FORM	0xFC69
#define T_UTF_16_ARABIC_LIGATURE_BEH_WITH_REH_FINAL_FORM	0xFC6A
#define T_UTF_16_ARABIC_LIGATURE_BEH_WITH_ZAIN_FINAL_FORM	0xFC6B
#define T_UTF_16_ARABIC_LIGATURE_BEH_WITH_MEEM_FINAL_FORM	0xFC6C
#define T_UTF_16_ARABIC_LIGATURE_BEH_WITH_NOON_FINAL_FORM	0xFC6D
#define T_UTF_16_ARABIC_LIGATURE_BEH_WITH_ALEF_MAKSURA_FINAL_FORM	0xFC6E
#define T_UTF_16_ARABIC_LIGATURE_BEH_WITH_YEH_FINAL_FORM	0xFC6F
#define T_UTF_16_ARABIC_LIGATURE_TEH_WITH_REH_FINAL_FORM	0xFC70
#define T_UTF_16_ARABIC_LIGATURE_TEH_WITH_ZAIN_FINAL_FORM	0xFC71
#define T_UTF_16_ARABIC_LIGATURE_TEH_WITH_MEEM_FINAL_FORM	0xFC72
#define T_UTF_16_ARABIC_LIGATURE_TEH_WITH_NOON_FINAL_FORM	0xFC73
#define T_UTF_16_ARABIC_LIGATURE_TEH_WITH_ALEF_MAKSURA_FINAL_FORM	0xFC74
#define T_UTF_16_ARABIC_LIGATURE_TEH_WITH_YEH_FINAL_FORM	0xFC75
#define T_UTF_16_ARABIC_LIGATURE_THEH_WITH_REH_FINAL_FORM	0xFC76
#define T_UTF_16_ARABIC_LIGATURE_THEH_WITH_ZAIN_FINAL_FORM	0xFC77
#define T_UTF_16_ARABIC_LIGATURE_THEH_WITH_MEEM_FINAL_FORM	0xFC78
#define T_UTF_16_ARABIC_LIGATURE_THEH_WITH_NOON_FINAL_FORM	0xFC79
#define T_UTF_16_ARABIC_LIGATURE_THEH_WITH_ALEF_MAKSURA_FINAL_FORM	0xFC7A
#define T_UTF_16_ARABIC_LIGATURE_THEH_WITH_YEH_FINAL_FORM	0xFC7B
#define T_UTF_16_ARABIC_LIGATURE_FEH_WITH_ALEF_MAKSURA_FINAL_FORM	0xFC7C
#define T_UTF_16_ARABIC_LIGATURE_FEH_WITH_YEH_FINAL_FORM	0xFC7D
#define T_UTF_16_ARABIC_LIGATURE_QAF_WITH_ALEF_MAKSURA_FINAL_FORM	0xFC7E
#define T_UTF_16_ARABIC_LIGATURE_QAF_WITH_YEH_FINAL_FORM	0xFC7F
#define T_UTF_16_ARABIC_LIGATURE_KAF_WITH_ALEF_FINAL_FORM	0xFC80
#define T_UTF_16_ARABIC_LIGATURE_KAF_WITH_LAM_FINAL_FORM	0xFC81
#define T_UTF_16_ARABIC_LIGATURE_KAF_WITH_MEEM_FINAL_FORM	0xFC82
#define T_UTF_16_ARABIC_LIGATURE_KAF_WITH_ALEF_MAKSURA_FINAL_FORM	0xFC83
#define T_UTF_16_ARABIC_LIGATURE_KAF_WITH_YEH_FINAL_FORM	0xFC84
#define T_UTF_16_ARABIC_LIGATURE_LAM_WITH_MEEM_FINAL_FORM	0xFC85
#define T_UTF_16_ARABIC_LIGATURE_LAM_WITH_ALEF_MAKSURA_FINAL_FORM	0xFC86
#define T_UTF_16_ARABIC_LIGATURE_LAM_WITH_YEH_FINAL_FORM	0xFC87
#define T_UTF_16_ARABIC_LIGATURE_MEEM_WITH_ALEF_FINAL_FORM	0xFC88
#define T_UTF_16_ARABIC_LIGATURE_MEEM_WITH_MEEM_FINAL_FORM	0xFC89
#define T_UTF_16_ARABIC_LIGATURE_NOON_WITH_REH_FINAL_FORM	0xFC8A
#define T_UTF_16_ARABIC_LIGATURE_NOON_WITH_ZAIN_FINAL_FORM	0xFC8B
#define T_UTF_16_ARABIC_LIGATURE_NOON_WITH_MEEM_FINAL_FORM	0xFC8C
#define T_UTF_16_ARABIC_LIGATURE_NOON_WITH_NOON_FINAL_FORM	0xFC8D
#define T_UTF_16_ARABIC_LIGATURE_NOON_WITH_ALEF_MAKSURA_FINAL_FORM	0xFC8E
#define T_UTF_16_ARABIC_LIGATURE_NOON_WITH_YEH_FINAL_FORM	0xFC8F
#define T_UTF_16_ARABIC_LIGATURE_ALEF_MAKSURA_WITH_SUPERSCRIPT_ALEF_FINAL_FORM	0xFC90
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_REH_FINAL_FORM	0xFC91
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_ZAIN_FINAL_FORM	0xFC92
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_MEEM_FINAL_FORM	0xFC93
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_NOON_FINAL_FORM	0xFC94
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_ALEF_MAKSURA_FINAL_FORM	0xFC95
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_YEH_FINAL_FORM	0xFC96
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_JEEM_INITIAL_FORM	0xFC97
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_HAH_INITIAL_FORM	0xFC98
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_KHAH_INITIAL_FORM	0xFC99
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_MEEM_INITIAL_FORM	0xFC9A
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_HEH_INITIAL_FORM	0xFC9B
#define T_UTF_16_ARABIC_LIGATURE_BEH_WITH_JEEM_INITIAL_FORM	0xFC9C
#define T_UTF_16_ARABIC_LIGATURE_BEH_WITH_HAH_INITIAL_FORM	0xFC9D
#define T_UTF_16_ARABIC_LIGATURE_BEH_WITH_KHAH_INITIAL_FORM	0xFC9E
#define T_UTF_16_ARABIC_LIGATURE_BEH_WITH_MEEM_INITIAL_FORM	0xFC9F
#define T_UTF_16_ARABIC_LIGATURE_BEH_WITH_HEH_INITIAL_FORM	0xFCA0
#define T_UTF_16_ARABIC_LIGATURE_TEH_WITH_JEEM_INITIAL_FORM	0xFCA1
#define T_UTF_16_ARABIC_LIGATURE_TEH_WITH_HAH_INITIAL_FORM	0xFCA2
#define T_UTF_16_ARABIC_LIGATURE_TEH_WITH_KHAH_INITIAL_FORM	0xFCA3
#define T_UTF_16_ARABIC_LIGATURE_TEH_WITH_MEEM_INITIAL_FORM	0xFCA4
#define T_UTF_16_ARABIC_LIGATURE_TEH_WITH_HEH_INITIAL_FORM	0xFCA5
#define T_UTF_16_ARABIC_LIGATURE_THEH_WITH_MEEM_INITIAL_FORM	0xFCA6
#define T_UTF_16_ARABIC_LIGATURE_JEEM_WITH_HAH_INITIAL_FORM	0xFCA7
#define T_UTF_16_ARABIC_LIGATURE_JEEM_WITH_MEEM_INITIAL_FORM	0xFCA8
#define T_UTF_16_ARABIC_LIGATURE_HAH_WITH_JEEM_INITIAL_FORM	0xFCA9
#define T_UTF_16_ARABIC_LIGATURE_HAH_WITH_MEEM_INITIAL_FORM	0xFCAA
#define T_UTF_16_ARABIC_LIGATURE_KHAH_WITH_JEEM_INITIAL_FORM	0xFCAB
#define T_UTF_16_ARABIC_LIGATURE_KHAH_WITH_MEEM_INITIAL_FORM	0xFCAC
#define T_UTF_16_ARABIC_LIGATURE_SEEN_WITH_JEEM_INITIAL_FORM	0xFCAD
#define T_UTF_16_ARABIC_LIGATURE_SEEN_WITH_HAH_INITIAL_FORM	0xFCAE
#define T_UTF_16_ARABIC_LIGATURE_SEEN_WITH_KHAH_INITIAL_FORM	0xFCAF
#define T_UTF_16_ARABIC_LIGATURE_SEEN_WITH_MEEM_INITIAL_FORM	0xFCB0
#define T_UTF_16_ARABIC_LIGATURE_SAD_WITH_HAH_INITIAL_FORM	0xFCB1
#define T_UTF_16_ARABIC_LIGATURE_SAD_WITH_KHAH_INITIAL_FORM	0xFCB2
#define T_UTF_16_ARABIC_LIGATURE_SAD_WITH_MEEM_INITIAL_FORM	0xFCB3
#define T_UTF_16_ARABIC_LIGATURE_DAD_WITH_JEEM_INITIAL_FORM	0xFCB4
#define T_UTF_16_ARABIC_LIGATURE_DAD_WITH_HAH_INITIAL_FORM	0xFCB5
#define T_UTF_16_ARABIC_LIGATURE_DAD_WITH_KHAH_INITIAL_FORM	0xFCB6
#define T_UTF_16_ARABIC_LIGATURE_DAD_WITH_MEEM_INITIAL_FORM	0xFCB7
#define T_UTF_16_ARABIC_LIGATURE_TAH_WITH_HAH_INITIAL_FORM	0xFCB8
#define T_UTF_16_ARABIC_LIGATURE_ZAH_WITH_MEEM_INITIAL_FORM	0xFCB9
#define T_UTF_16_ARABIC_LIGATURE_AIN_WITH_JEEM_INITIAL_FORM	0xFCBA
#define T_UTF_16_ARABIC_LIGATURE_AIN_WITH_MEEM_INITIAL_FORM	0xFCBB
#define T_UTF_16_ARABIC_LIGATURE_GHAIN_WITH_JEEM_INITIAL_FORM	0xFCBC
#define T_UTF_16_ARABIC_LIGATURE_GHAIN_WITH_MEEM_INITIAL_FORM	0xFCBD
#define T_UTF_16_ARABIC_LIGATURE_FEH_WITH_JEEM_INITIAL_FORM	0xFCBE
#define T_UTF_16_ARABIC_LIGATURE_FEH_WITH_HAH_INITIAL_FORM	0xFCBF
#define T_UTF_16_ARABIC_LIGATURE_FEH_WITH_KHAH_INITIAL_FORM	0xFCC0
#define T_UTF_16_ARABIC_LIGATURE_FEH_WITH_MEEM_INITIAL_FORM	0xFCC1
#define T_UTF_16_ARABIC_LIGATURE_QAF_WITH_HAH_INITIAL_FORM	0xFCC2
#define T_UTF_16_ARABIC_LIGATURE_QAF_WITH_MEEM_INITIAL_FORM	0xFCC3
#define T_UTF_16_ARABIC_LIGATURE_KAF_WITH_JEEM_INITIAL_FORM	0xFCC4
#define T_UTF_16_ARABIC_LIGATURE_KAF_WITH_HAH_INITIAL_FORM	0xFCC5
#define T_UTF_16_ARABIC_LIGATURE_KAF_WITH_KHAH_INITIAL_FORM	0xFCC6
#define T_UTF_16_ARABIC_LIGATURE_KAF_WITH_LAM_INITIAL_FORM	0xFCC7
#define T_UTF_16_ARABIC_LIGATURE_KAF_WITH_MEEM_INITIAL_FORM	0xFCC8
#define T_UTF_16_ARABIC_LIGATURE_LAM_WITH_JEEM_INITIAL_FORM	0xFCC9
#define T_UTF_16_ARABIC_LIGATURE_LAM_WITH_HAH_INITIAL_FORM	0xFCCA
#define T_UTF_16_ARABIC_LIGATURE_LAM_WITH_KHAH_INITIAL_FORM	0xFCCB
#define T_UTF_16_ARABIC_LIGATURE_LAM_WITH_MEEM_INITIAL_FORM	0xFCCC
#define T_UTF_16_ARABIC_LIGATURE_LAM_WITH_HEH_INITIAL_FORM	0xFCCD
#define T_UTF_16_ARABIC_LIGATURE_MEEM_WITH_JEEM_INITIAL_FORM	0xFCCE
#define T_UTF_16_ARABIC_LIGATURE_MEEM_WITH_HAH_INITIAL_FORM	0xFCCF
#define T_UTF_16_ARABIC_LIGATURE_MEEM_WITH_KHAH_INITIAL_FORM	0xFCD0
#define T_UTF_16_ARABIC_LIGATURE_MEEM_WITH_MEEM_INITIAL_FORM	0xFCD1
#define T_UTF_16_ARABIC_LIGATURE_NOON_WITH_JEEM_INITIAL_FORM	0xFCD2
#define T_UTF_16_ARABIC_LIGATURE_NOON_WITH_HAH_INITIAL_FORM	0xFCD3
#define T_UTF_16_ARABIC_LIGATURE_NOON_WITH_KHAH_INITIAL_FORM	0xFCD4
#define T_UTF_16_ARABIC_LIGATURE_NOON_WITH_MEEM_INITIAL_FORM	0xFCD5
#define T_UTF_16_ARABIC_LIGATURE_NOON_WITH_HEH_INITIAL_FORM	0xFCD6
#define T_UTF_16_ARABIC_LIGATURE_HEH_WITH_JEEM_INITIAL_FORM	0xFCD7
#define T_UTF_16_ARABIC_LIGATURE_HEH_WITH_MEEM_INITIAL_FORM	0xFCD8
#define T_UTF_16_ARABIC_LIGATURE_HEH_WITH_SUPERSCRIPT_ALEF_INITIAL_FORM	0xFCD9
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_JEEM_INITIAL_FORM	0xFCDA
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_HAH_INITIAL_FORM	0xFCDB
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_KHAH_INITIAL_FORM	0xFCDC
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_MEEM_INITIAL_FORM	0xFCDD
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_HEH_INITIAL_FORM	0xFCDE
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_MEEM_MEDIAL_FORM	0xFCDF
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_HEH_MEDIAL_FORM	0xFCE0
#define T_UTF_16_ARABIC_LIGATURE_BEH_WITH_MEEM_MEDIAL_FORM	0xFCE1
#define T_UTF_16_ARABIC_LIGATURE_BEH_WITH_HEH_MEDIAL_FORM	0xFCE2
#define T_UTF_16_ARABIC_LIGATURE_TEH_WITH_MEEM_MEDIAL_FORM	0xFCE3
#define T_UTF_16_ARABIC_LIGATURE_TEH_WITH_HEH_MEDIAL_FORM	0xFCE4
#define T_UTF_16_ARABIC_LIGATURE_THEH_WITH_MEEM_MEDIAL_FORM	0xFCE5
#define T_UTF_16_ARABIC_LIGATURE_THEH_WITH_HEH_MEDIAL_FORM	0xFCE6
#define T_UTF_16_ARABIC_LIGATURE_SEEN_WITH_MEEM_MEDIAL_FORM	0xFCE7
#define T_UTF_16_ARABIC_LIGATURE_SEEN_WITH_HEH_MEDIAL_FORM	0xFCE8
#define T_UTF_16_ARABIC_LIGATURE_SHEEN_WITH_MEEM_MEDIAL_FORM	0xFCE9
#define T_UTF_16_ARABIC_LIGATURE_SHEEN_WITH_HEH_MEDIAL_FORM	0xFCEA
#define T_UTF_16_ARABIC_LIGATURE_KAF_WITH_LAM_MEDIAL_FORM	0xFCEB
#define T_UTF_16_ARABIC_LIGATURE_KAF_WITH_MEEM_MEDIAL_FORM	0xFCEC
#define T_UTF_16_ARABIC_LIGATURE_LAM_WITH_MEEM_MEDIAL_FORM	0xFCED
#define T_UTF_16_ARABIC_LIGATURE_NOON_WITH_MEEM_MEDIAL_FORM	0xFCEE
#define T_UTF_16_ARABIC_LIGATURE_NOON_WITH_HEH_MEDIAL_FORM	0xFCEF
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_MEEM_MEDIAL_FORM	0xFCF0
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_HEH_MEDIAL_FORM	0xFCF1
#define T_UTF_16_ARABIC_LIGATURE_SHADDA_WITH_FATHA_MEDIAL_FORM	0xFCF2
#define T_UTF_16_ARABIC_LIGATURE_SHADDA_WITH_DAMMA_MEDIAL_FORM	0xFCF3
#define T_UTF_16_ARABIC_LIGATURE_SHADDA_WITH_KASRA_MEDIAL_FORM	0xFCF4
#define T_UTF_16_ARABIC_LIGATURE_TAH_WITH_ALEF_MAKSURA_ISOLATED_FORM	0xFCF5
#define T_UTF_16_ARABIC_LIGATURE_TAH_WITH_YEH_ISOLATED_FORM	0xFCF6
#define T_UTF_16_ARABIC_LIGATURE_AIN_WITH_ALEF_MAKSURA_ISOLATED_FORM	0xFCF7
#define T_UTF_16_ARABIC_LIGATURE_AIN_WITH_YEH_ISOLATED_FORM	0xFCF8
#define T_UTF_16_ARABIC_LIGATURE_GHAIN_WITH_ALEF_MAKSURA_ISOLATED_FORM	0xFCF9
#define T_UTF_16_ARABIC_LIGATURE_GHAIN_WITH_YEH_ISOLATED_FORM	0xFCFA
#define T_UTF_16_ARABIC_LIGATURE_SEEN_WITH_ALEF_MAKSURA_ISOLATED_FORM	0xFCFB
#define T_UTF_16_ARABIC_LIGATURE_SEEN_WITH_YEH_ISOLATED_FORM	0xFCFC
#define T_UTF_16_ARABIC_LIGATURE_SHEEN_WITH_ALEF_MAKSURA_ISOLATED_FORM	0xFCFD
#define T_UTF_16_ARABIC_LIGATURE_SHEEN_WITH_YEH_ISOLATED_FORM	0xFCFE
#define T_UTF_16_ARABIC_LIGATURE_HAH_WITH_ALEF_MAKSURA_ISOLATED_FORM	0xFCFF
#define T_UTF_16_ARABIC_LIGATURE_HAH_WITH_YEH_ISOLATED_FORM	0xFD00
#define T_UTF_16_ARABIC_LIGATURE_JEEM_WITH_ALEF_MAKSURA_ISOLATED_FORM	0xFD01
#define T_UTF_16_ARABIC_LIGATURE_JEEM_WITH_YEH_ISOLATED_FORM	0xFD02
#define T_UTF_16_ARABIC_LIGATURE_KHAH_WITH_ALEF_MAKSURA_ISOLATED_FORM	0xFD03
#define T_UTF_16_ARABIC_LIGATURE_KHAH_WITH_YEH_ISOLATED_FORM	0xFD04
#define T_UTF_16_ARABIC_LIGATURE_SAD_WITH_ALEF_MAKSURA_ISOLATED_FORM	0xFD05
#define T_UTF_16_ARABIC_LIGATURE_SAD_WITH_YEH_ISOLATED_FORM	0xFD06
#define T_UTF_16_ARABIC_LIGATURE_DAD_WITH_ALEF_MAKSURA_ISOLATED_FORM	0xFD07
#define T_UTF_16_ARABIC_LIGATURE_DAD_WITH_YEH_ISOLATED_FORM	0xFD08
#define T_UTF_16_ARABIC_LIGATURE_SHEEN_WITH_JEEM_ISOLATED_FORM	0xFD09
#define T_UTF_16_ARABIC_LIGATURE_SHEEN_WITH_HAH_ISOLATED_FORM	0xFD0A
#define T_UTF_16_ARABIC_LIGATURE_SHEEN_WITH_KHAH_ISOLATED_FORM	0xFD0B
#define T_UTF_16_ARABIC_LIGATURE_SHEEN_WITH_MEEM_ISOLATED_FORM	0xFD0C
#define T_UTF_16_ARABIC_LIGATURE_SHEEN_WITH_REH_ISOLATED_FORM	0xFD0D
#define T_UTF_16_ARABIC_LIGATURE_SEEN_WITH_REH_ISOLATED_FORM	0xFD0E
#define T_UTF_16_ARABIC_LIGATURE_SAD_WITH_REH_ISOLATED_FORM	0xFD0F
#define T_UTF_16_ARABIC_LIGATURE_DAD_WITH_REH_ISOLATED_FORM	0xFD10
#define T_UTF_16_ARABIC_LIGATURE_TAH_WITH_ALEF_MAKSURA_FINAL_FORM	0xFD11
#define T_UTF_16_ARABIC_LIGATURE_TAH_WITH_YEH_FINAL_FORM	0xFD12
#define T_UTF_16_ARABIC_LIGATURE_AIN_WITH_ALEF_MAKSURA_FINAL_FORM	0xFD13
#define T_UTF_16_ARABIC_LIGATURE_AIN_WITH_YEH_FINAL_FORM	0xFD14
#define T_UTF_16_ARABIC_LIGATURE_GHAIN_WITH_ALEF_MAKSURA_FINAL_FORM	0xFD15
#define T_UTF_16_ARABIC_LIGATURE_GHAIN_WITH_YEH_FINAL_FORM	0xFD16
#define T_UTF_16_ARABIC_LIGATURE_SEEN_WITH_ALEF_MAKSURA_FINAL_FORM	0xFD17
#define T_UTF_16_ARABIC_LIGATURE_SEEN_WITH_YEH_FINAL_FORM	0xFD18
#define T_UTF_16_ARABIC_LIGATURE_SHEEN_WITH_ALEF_MAKSURA_FINAL_FORM	0xFD19
#define T_UTF_16_ARABIC_LIGATURE_SHEEN_WITH_YEH_FINAL_FORM	0xFD1A
#define T_UTF_16_ARABIC_LIGATURE_HAH_WITH_ALEF_MAKSURA_FINAL_FORM	0xFD1B
#define T_UTF_16_ARABIC_LIGATURE_HAH_WITH_YEH_FINAL_FORM	0xFD1C
#define T_UTF_16_ARABIC_LIGATURE_JEEM_WITH_ALEF_MAKSURA_FINAL_FORM	0xFD1D
#define T_UTF_16_ARABIC_LIGATURE_JEEM_WITH_YEH_FINAL_FORM	0xFD1E
#define T_UTF_16_ARABIC_LIGATURE_KHAH_WITH_ALEF_MAKSURA_FINAL_FORM	0xFD1F
#define T_UTF_16_ARABIC_LIGATURE_KHAH_WITH_YEH_FINAL_FORM	0xFD20
#define T_UTF_16_ARABIC_LIGATURE_SAD_WITH_ALEF_MAKSURA_FINAL_FORM	0xFD21
#define T_UTF_16_ARABIC_LIGATURE_SAD_WITH_YEH_FINAL_FORM	0xFD22
#define T_UTF_16_ARABIC_LIGATURE_DAD_WITH_ALEF_MAKSURA_FINAL_FORM	0xFD23
#define T_UTF_16_ARABIC_LIGATURE_DAD_WITH_YEH_FINAL_FORM	0xFD24
#define T_UTF_16_ARABIC_LIGATURE_SHEEN_WITH_JEEM_FINAL_FORM	0xFD25
#define T_UTF_16_ARABIC_LIGATURE_SHEEN_WITH_HAH_FINAL_FORM	0xFD26
#define T_UTF_16_ARABIC_LIGATURE_SHEEN_WITH_KHAH_FINAL_FORM	0xFD27
#define T_UTF_16_ARABIC_LIGATURE_SHEEN_WITH_MEEM_FINAL_FORM	0xFD28
#define T_UTF_16_ARABIC_LIGATURE_SHEEN_WITH_REH_FINAL_FORM	0xFD29
#define T_UTF_16_ARABIC_LIGATURE_SEEN_WITH_REH_FINAL_FORM	0xFD2A
#define T_UTF_16_ARABIC_LIGATURE_SAD_WITH_REH_FINAL_FORM	0xFD2B
#define T_UTF_16_ARABIC_LIGATURE_DAD_WITH_REH_FINAL_FORM	0xFD2C
#define T_UTF_16_ARABIC_LIGATURE_SHEEN_WITH_JEEM_INITIAL_FORM	0xFD2D
#define T_UTF_16_ARABIC_LIGATURE_SHEEN_WITH_HAH_INITIAL_FORM	0xFD2E
#define T_UTF_16_ARABIC_LIGATURE_SHEEN_WITH_KHAH_INITIAL_FORM	0xFD2F
#define T_UTF_16_ARABIC_LIGATURE_SHEEN_WITH_MEEM_INITIAL_FORM	0xFD30
#define T_UTF_16_ARABIC_LIGATURE_SEEN_WITH_HEH_INITIAL_FORM	0xFD31
#define T_UTF_16_ARABIC_LIGATURE_SHEEN_WITH_HEH_INITIAL_FORM	0xFD32
#define T_UTF_16_ARABIC_LIGATURE_TAH_WITH_MEEM_INITIAL_FORM	0xFD33
#define T_UTF_16_ARABIC_LIGATURE_SEEN_WITH_JEEM_MEDIAL_FORM	0xFD34
#define T_UTF_16_ARABIC_LIGATURE_SEEN_WITH_HAH_MEDIAL_FORM	0xFD35
#define T_UTF_16_ARABIC_LIGATURE_SEEN_WITH_KHAH_MEDIAL_FORM	0xFD36
#define T_UTF_16_ARABIC_LIGATURE_SHEEN_WITH_JEEM_MEDIAL_FORM	0xFD37
#define T_UTF_16_ARABIC_LIGATURE_SHEEN_WITH_HAH_MEDIAL_FORM	0xFD38
#define T_UTF_16_ARABIC_LIGATURE_SHEEN_WITH_KHAH_MEDIAL_FORM	0xFD39
#define T_UTF_16_ARABIC_LIGATURE_TAH_WITH_MEEM_MEDIAL_FORM	0xFD3A
#define T_UTF_16_ARABIC_LIGATURE_ZAH_WITH_MEEM_MEDIAL_FORM	0xFD3B
#define T_UTF_16_ARABIC_LIGATURE_ALEF_WITH_FATHATAN_FINAL_FORM	0xFD3C
#define T_UTF_16_ARABIC_LIGATURE_ALEF_WITH_FATHATAN_ISOLATED_FORM	0xFD3D
#define T_UTF_16_ORNATE_LEFT_PARENTHESIS	0xFD3E
#define T_UTF_16_ORNATE_RIGHT_PARENTHESIS	0xFD3F
#define T_UTF_16_ARABIC_LIGATURE_TEH_WITH_JEEM_WITH_MEEM_INITIAL_FORM	0xFD50
#define T_UTF_16_ARABIC_LIGATURE_TEH_WITH_HAH_WITH_JEEM_FINAL_FORM	0xFD51
#define T_UTF_16_ARABIC_LIGATURE_TEH_WITH_HAH_WITH_JEEM_INITIAL_FORM	0xFD52
#define T_UTF_16_ARABIC_LIGATURE_TEH_WITH_HAH_WITH_MEEM_INITIAL_FORM	0xFD53
#define T_UTF_16_ARABIC_LIGATURE_TEH_WITH_KHAH_WITH_MEEM_INITIAL_FORM	0xFD54
#define T_UTF_16_ARABIC_LIGATURE_TEH_WITH_MEEM_WITH_JEEM_INITIAL_FORM	0xFD55
#define T_UTF_16_ARABIC_LIGATURE_TEH_WITH_MEEM_WITH_HAH_INITIAL_FORM	0xFD56
#define T_UTF_16_ARABIC_LIGATURE_TEH_WITH_MEEM_WITH_KHAH_INITIAL_FORM	0xFD57
#define T_UTF_16_ARABIC_LIGATURE_JEEM_WITH_MEEM_WITH_HAH_FINAL_FORM	0xFD58
#define T_UTF_16_ARABIC_LIGATURE_JEEM_WITH_MEEM_WITH_HAH_INITIAL_FORM	0xFD59
#define T_UTF_16_ARABIC_LIGATURE_HAH_WITH_MEEM_WITH_YEH_FINAL_FORM	0xFD5A
#define T_UTF_16_ARABIC_LIGATURE_HAH_WITH_MEEM_WITH_ALEF_MAKSURA_FINAL_FORM	0xFD5B
#define T_UTF_16_ARABIC_LIGATURE_SEEN_WITH_HAH_WITH_JEEM_INITIAL_FORM	0xFD5C
#define T_UTF_16_ARABIC_LIGATURE_SEEN_WITH_JEEM_WITH_HAH_INITIAL_FORM	0xFD5D
#define T_UTF_16_ARABIC_LIGATURE_SEEN_WITH_JEEM_WITH_ALEF_MAKSURA_FINAL_FORM	0xFD5E
#define T_UTF_16_ARABIC_LIGATURE_SEEN_WITH_MEEM_WITH_HAH_FINAL_FORM	0xFD5F
#define T_UTF_16_ARABIC_LIGATURE_SEEN_WITH_MEEM_WITH_HAH_INITIAL_FORM	0xFD60
#define T_UTF_16_ARABIC_LIGATURE_SEEN_WITH_MEEM_WITH_JEEM_INITIAL_FORM	0xFD61
#define T_UTF_16_ARABIC_LIGATURE_SEEN_WITH_MEEM_WITH_MEEM_FINAL_FORM	0xFD62
#define T_UTF_16_ARABIC_LIGATURE_SEEN_WITH_MEEM_WITH_MEEM_INITIAL_FORM	0xFD63
#define T_UTF_16_ARABIC_LIGATURE_SAD_WITH_HAH_WITH_HAH_FINAL_FORM	0xFD64
#define T_UTF_16_ARABIC_LIGATURE_SAD_WITH_HAH_WITH_HAH_INITIAL_FORM	0xFD65
#define T_UTF_16_ARABIC_LIGATURE_SAD_WITH_MEEM_WITH_MEEM_FINAL_FORM	0xFD66
#define T_UTF_16_ARABIC_LIGATURE_SHEEN_WITH_HAH_WITH_MEEM_FINAL_FORM	0xFD67
#define T_UTF_16_ARABIC_LIGATURE_SHEEN_WITH_HAH_WITH_MEEM_INITIAL_FORM	0xFD68
#define T_UTF_16_ARABIC_LIGATURE_SHEEN_WITH_JEEM_WITH_YEH_FINAL_FORM	0xFD69
#define T_UTF_16_ARABIC_LIGATURE_SHEEN_WITH_MEEM_WITH_KHAH_FINAL_FORM	0xFD6A
#define T_UTF_16_ARABIC_LIGATURE_SHEEN_WITH_MEEM_WITH_KHAH_INITIAL_FORM	0xFD6B
#define T_UTF_16_ARABIC_LIGATURE_SHEEN_WITH_MEEM_WITH_MEEM_FINAL_FORM	0xFD6C
#define T_UTF_16_ARABIC_LIGATURE_SHEEN_WITH_MEEM_WITH_MEEM_INITIAL_FORM	0xFD6D
#define T_UTF_16_ARABIC_LIGATURE_DAD_WITH_HAH_WITH_ALEF_MAKSURA_FINAL_FORM	0xFD6E
#define T_UTF_16_ARABIC_LIGATURE_DAD_WITH_KHAH_WITH_MEEM_FINAL_FORM	0xFD6F
#define T_UTF_16_ARABIC_LIGATURE_DAD_WITH_KHAH_WITH_MEEM_INITIAL_FORM	0xFD70
#define T_UTF_16_ARABIC_LIGATURE_TAH_WITH_MEEM_WITH_HAH_FINAL_FORM	0xFD71
#define T_UTF_16_ARABIC_LIGATURE_TAH_WITH_MEEM_WITH_HAH_INITIAL_FORM	0xFD72
#define T_UTF_16_ARABIC_LIGATURE_TAH_WITH_MEEM_WITH_MEEM_INITIAL_FORM	0xFD73
#define T_UTF_16_ARABIC_LIGATURE_TAH_WITH_MEEM_WITH_YEH_FINAL_FORM	0xFD74
#define T_UTF_16_ARABIC_LIGATURE_AIN_WITH_JEEM_WITH_MEEM_FINAL_FORM	0xFD75
#define T_UTF_16_ARABIC_LIGATURE_AIN_WITH_MEEM_WITH_MEEM_FINAL_FORM	0xFD76
#define T_UTF_16_ARABIC_LIGATURE_AIN_WITH_MEEM_WITH_MEEM_INITIAL_FORM	0xFD77
#define T_UTF_16_ARABIC_LIGATURE_AIN_WITH_MEEM_WITH_ALEF_MAKSURA_FINAL_FORM	0xFD78
#define T_UTF_16_ARABIC_LIGATURE_GHAIN_WITH_MEEM_WITH_MEEM_FINAL_FORM	0xFD79
#define T_UTF_16_ARABIC_LIGATURE_GHAIN_WITH_MEEM_WITH_YEH_FINAL_FORM	0xFD7A
#define T_UTF_16_ARABIC_LIGATURE_GHAIN_WITH_MEEM_WITH_ALEF_MAKSURA_FINAL_FORM	0xFD7B
#define T_UTF_16_ARABIC_LIGATURE_FEH_WITH_KHAH_WITH_MEEM_FINAL_FORM	0xFD7C
#define T_UTF_16_ARABIC_LIGATURE_FEH_WITH_KHAH_WITH_MEEM_INITIAL_FORM	0xFD7D
#define T_UTF_16_ARABIC_LIGATURE_QAF_WITH_MEEM_WITH_HAH_FINAL_FORM	0xFD7E
#define T_UTF_16_ARABIC_LIGATURE_QAF_WITH_MEEM_WITH_MEEM_FINAL_FORM	0xFD7F
#define T_UTF_16_ARABIC_LIGATURE_LAM_WITH_HAH_WITH_MEEM_FINAL_FORM	0xFD80
#define T_UTF_16_ARABIC_LIGATURE_LAM_WITH_HAH_WITH_YEH_FINAL_FORM	0xFD81
#define T_UTF_16_ARABIC_LIGATURE_LAM_WITH_HAH_WITH_ALEF_MAKSURA_FINAL_FORM	0xFD82
#define T_UTF_16_ARABIC_LIGATURE_LAM_WITH_JEEM_WITH_JEEM_INITIAL_FORM	0xFD83
#define T_UTF_16_ARABIC_LIGATURE_LAM_WITH_JEEM_WITH_JEEM_FINAL_FORM	0xFD84
#define T_UTF_16_ARABIC_LIGATURE_LAM_WITH_KHAH_WITH_MEEM_FINAL_FORM	0xFD85
#define T_UTF_16_ARABIC_LIGATURE_LAM_WITH_KHAH_WITH_MEEM_INITIAL_FORM	0xFD86
#define T_UTF_16_ARABIC_LIGATURE_LAM_WITH_MEEM_WITH_HAH_FINAL_FORM	0xFD87
#define T_UTF_16_ARABIC_LIGATURE_LAM_WITH_MEEM_WITH_HAH_INITIAL_FORM	0xFD88
#define T_UTF_16_ARABIC_LIGATURE_MEEM_WITH_HAH_WITH_JEEM_INITIAL_FORM	0xFD89
#define T_UTF_16_ARABIC_LIGATURE_MEEM_WITH_HAH_WITH_MEEM_INITIAL_FORM	0xFD8A
#define T_UTF_16_ARABIC_LIGATURE_MEEM_WITH_HAH_WITH_YEH_FINAL_FORM	0xFD8B
#define T_UTF_16_ARABIC_LIGATURE_MEEM_WITH_JEEM_WITH_HAH_INITIAL_FORM	0xFD8C
#define T_UTF_16_ARABIC_LIGATURE_MEEM_WITH_JEEM_WITH_MEEM_INITIAL_FORM	0xFD8D
#define T_UTF_16_ARABIC_LIGATURE_MEEM_WITH_KHAH_WITH_JEEM_INITIAL_FORM	0xFD8E
#define T_UTF_16_ARABIC_LIGATURE_MEEM_WITH_KHAH_WITH_MEEM_INITIAL_FORM	0xFD8F
#define T_UTF_16_ARABIC_LIGATURE_MEEM_WITH_JEEM_WITH_KHAH_INITIAL_FORM	0xFD92
#define T_UTF_16_ARABIC_LIGATURE_HEH_WITH_MEEM_WITH_JEEM_INITIAL_FORM	0xFD93
#define T_UTF_16_ARABIC_LIGATURE_HEH_WITH_MEEM_WITH_MEEM_INITIAL_FORM	0xFD94
#define T_UTF_16_ARABIC_LIGATURE_NOON_WITH_HAH_WITH_MEEM_INITIAL_FORM	0xFD95
#define T_UTF_16_ARABIC_LIGATURE_NOON_WITH_HAH_WITH_ALEF_MAKSURA_FINAL_FORM	0xFD96
#define T_UTF_16_ARABIC_LIGATURE_NOON_WITH_JEEM_WITH_MEEM_FINAL_FORM	0xFD97
#define T_UTF_16_ARABIC_LIGATURE_NOON_WITH_JEEM_WITH_MEEM_INITIAL_FORM	0xFD98
#define T_UTF_16_ARABIC_LIGATURE_NOON_WITH_JEEM_WITH_ALEF_MAKSURA_FINAL_FORM	0xFD99
#define T_UTF_16_ARABIC_LIGATURE_NOON_WITH_MEEM_WITH_YEH_FINAL_FORM	0xFD9A
#define T_UTF_16_ARABIC_LIGATURE_NOON_WITH_MEEM_WITH_ALEF_MAKSURA_FINAL_FORM	0xFD9B
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_MEEM_WITH_MEEM_FINAL_FORM	0xFD9C
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_MEEM_WITH_MEEM_INITIAL_FORM	0xFD9D
#define T_UTF_16_ARABIC_LIGATURE_BEH_WITH_KHAH_WITH_YEH_FINAL_FORM	0xFD9E
#define T_UTF_16_ARABIC_LIGATURE_TEH_WITH_JEEM_WITH_YEH_FINAL_FORM	0xFD9F
#define T_UTF_16_ARABIC_LIGATURE_TEH_WITH_JEEM_WITH_ALEF_MAKSURA_FINAL_FORM	0xFDA0
#define T_UTF_16_ARABIC_LIGATURE_TEH_WITH_KHAH_WITH_YEH_FINAL_FORM	0xFDA1
#define T_UTF_16_ARABIC_LIGATURE_TEH_WITH_KHAH_WITH_ALEF_MAKSURA_FINAL_FORM	0xFDA2
#define T_UTF_16_ARABIC_LIGATURE_TEH_WITH_MEEM_WITH_YEH_FINAL_FORM	0xFDA3
#define T_UTF_16_ARABIC_LIGATURE_TEH_WITH_MEEM_WITH_ALEF_MAKSURA_FINAL_FORM	0xFDA4
#define T_UTF_16_ARABIC_LIGATURE_JEEM_WITH_MEEM_WITH_YEH_FINAL_FORM	0xFDA5
#define T_UTF_16_ARABIC_LIGATURE_JEEM_WITH_HAH_WITH_ALEF_MAKSURA_FINAL_FORM	0xFDA6
#define T_UTF_16_ARABIC_LIGATURE_JEEM_WITH_MEEM_WITH_ALEF_MAKSURA_FINAL_FORM	0xFDA7
#define T_UTF_16_ARABIC_LIGATURE_SEEN_WITH_KHAH_WITH_ALEF_MAKSURA_FINAL_FORM	0xFDA8
#define T_UTF_16_ARABIC_LIGATURE_SAD_WITH_HAH_WITH_YEH_FINAL_FORM	0xFDA9
#define T_UTF_16_ARABIC_LIGATURE_SHEEN_WITH_HAH_WITH_YEH_FINAL_FORM	0xFDAA
#define T_UTF_16_ARABIC_LIGATURE_DAD_WITH_HAH_WITH_YEH_FINAL_FORM	0xFDAB
#define T_UTF_16_ARABIC_LIGATURE_LAM_WITH_JEEM_WITH_YEH_FINAL_FORM	0xFDAC
#define T_UTF_16_ARABIC_LIGATURE_LAM_WITH_MEEM_WITH_YEH_FINAL_FORM	0xFDAD
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_HAH_WITH_YEH_FINAL_FORM	0xFDAE
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_JEEM_WITH_YEH_FINAL_FORM	0xFDAF
#define T_UTF_16_ARABIC_LIGATURE_YEH_WITH_MEEM_WITH_YEH_FINAL_FORM	0xFDB0
#define T_UTF_16_ARABIC_LIGATURE_MEEM_WITH_MEEM_WITH_YEH_FINAL_FORM	0xFDB1
#define T_UTF_16_ARABIC_LIGATURE_QAF_WITH_MEEM_WITH_YEH_FINAL_FORM	0xFDB2
#define T_UTF_16_ARABIC_LIGATURE_NOON_WITH_HAH_WITH_YEH_FINAL_FORM	0xFDB3
#define T_UTF_16_ARABIC_LIGATURE_QAF_WITH_MEEM_WITH_HAH_INITIAL_FORM	0xFDB4
#define T_UTF_16_ARABIC_LIGATURE_LAM_WITH_HAH_WITH_MEEM_INITIAL_FORM	0xFDB5
#define T_UTF_16_ARABIC_LIGATURE_AIN_WITH_MEEM_WITH_YEH_FINAL_FORM	0xFDB6
#define T_UTF_16_ARABIC_LIGATURE_KAF_WITH_MEEM_WITH_YEH_FINAL_FORM	0xFDB7
#define T_UTF_16_ARABIC_LIGATURE_NOON_WITH_JEEM_WITH_HAH_INITIAL_FORM	0xFDB8
#define T_UTF_16_ARABIC_LIGATURE_MEEM_WITH_KHAH_WITH_YEH_FINAL_FORM	0xFDB9
#define T_UTF_16_ARABIC_LIGATURE_LAM_WITH_JEEM_WITH_MEEM_INITIAL_FORM	0xFDBA
#define T_UTF_16_ARABIC_LIGATURE_KAF_WITH_MEEM_WITH_MEEM_FINAL_FORM	0xFDBB
#define T_UTF_16_ARABIC_LIGATURE_LAM_WITH_JEEM_WITH_MEEM_FINAL_FORM	0xFDBC
#define T_UTF_16_ARABIC_LIGATURE_NOON_WITH_JEEM_WITH_HAH_FINAL_FORM	0xFDBD
#define T_UTF_16_ARABIC_LIGATURE_JEEM_WITH_HAH_WITH_YEH_FINAL_FORM	0xFDBE
#define T_UTF_16_ARABIC_LIGATURE_HAH_WITH_JEEM_WITH_YEH_FINAL_FORM	0xFDBF
#define T_UTF_16_ARABIC_LIGATURE_MEEM_WITH_JEEM_WITH_YEH_FINAL_FORM	0xFDC0
#define T_UTF_16_ARABIC_LIGATURE_FEH_WITH_MEEM_WITH_YEH_FINAL_FORM	0xFDC1
#define T_UTF_16_ARABIC_LIGATURE_BEH_WITH_HAH_WITH_YEH_FINAL_FORM	0xFDC2
#define T_UTF_16_ARABIC_LIGATURE_KAF_WITH_MEEM_WITH_MEEM_INITIAL_FORM	0xFDC3
#define T_UTF_16_ARABIC_LIGATURE_AIN_WITH_JEEM_WITH_MEEM_INITIAL_FORM	0xFDC4
#define T_UTF_16_ARABIC_LIGATURE_SAD_WITH_MEEM_WITH_MEEM_INITIAL_FORM	0xFDC5
#define T_UTF_16_ARABIC_LIGATURE_SEEN_WITH_KHAH_WITH_YEH_FINAL_FORM	0xFDC6
#define T_UTF_16_ARABIC_LIGATURE_NOON_WITH_JEEM_WITH_YEH_FINAL_FORM	0xFDC7
#define T_UTF_16_ARABIC_LIGATURE_SALLA_USED_AS_KORANIC_STOP_SIGN_ISOLATED_FORM	0xFDF0
#define T_UTF_16_ARABIC_LIGATURE_QALA_USED_AS_KORANIC_STOP_SIGN_ISOLATED_FORM	0xFDF1
#define T_UTF_16_ARABIC_LIGATURE_ALLAH_ISOLATED_FORM	0xFDF2
#define T_UTF_16_ARABIC_LIGATURE_AKBAR_ISOLATED_FORM	0xFDF3
#define T_UTF_16_ARABIC_LIGATURE_MOHAMMAD_ISOLATED_FORM	0xFDF4
#define T_UTF_16_ARABIC_LIGATURE_SALAM_ISOLATED_FORM	0xFDF5
#define T_UTF_16_ARABIC_LIGATURE_RASOUL_ISOLATED_FORM	0xFDF6
#define T_UTF_16_ARABIC_LIGATURE_ALAYHE_ISOLATED_FORM	0xFDF7
#define T_UTF_16_ARABIC_LIGATURE_WASALLAM_ISOLATED_FORM	0xFDF8
#define T_UTF_16_ARABIC_LIGATURE_SALLA_ISOLATED_FORM	0xFDF9
#define T_UTF_16_ARABIC_LIGATURE_SALLALLAHOU_ALAYHE_WASALLAM	0xFDFA
#define T_UTF_16_ARABIC_LIGATURE_JALLAJALALOUHOU	0xFDFB
#define T_UTF_16_COMBINING_LIGATURE_LEFT_HALF	0xFE20
#define T_UTF_16_COMBINING_LIGATURE_RIGHT_HALF	0xFE21
#define T_UTF_16_COMBINING_DOUBLE_TILDE_LEFT_HALF	0xFE22
#define T_UTF_16_COMBINING_DOUBLE_TILDE_RIGHT_HALF	0xFE23
#define T_UTF_16_PRESENTATION_FORM_FOR_VERTICAL_TWO_DOT_LEADER	0xFE30
#define T_UTF_16_PRESENTATION_FORM_FOR_VERTICAL_EM_DASH	0xFE31
#define T_UTF_16_PRESENTATION_FORM_FOR_VERTICAL_EN_DASH	0xFE32
#define T_UTF_16_PRESENTATION_FORM_FOR_VERTICAL_LOW_LINE	0xFE33
#define T_UTF_16_PRESENTATION_FORM_FOR_VERTICAL_WAVY_LOW_LINE	0xFE34
#define T_UTF_16_PRESENTATION_FORM_FOR_VERTICAL_LEFT_PARENTHESIS	0xFE35
#define T_UTF_16_PRESENTATION_FORM_FOR_VERTICAL_RIGHT_PARENTHESIS	0xFE36
#define T_UTF_16_PRESENTATION_FORM_FOR_VERTICAL_LEFT_CURLY_BRACKET	0xFE37
#define T_UTF_16_PRESENTATION_FORM_FOR_VERTICAL_RIGHT_CURLY_BRACKET	0xFE38
#define T_UTF_16_PRESENTATION_FORM_FOR_VERTICAL_LEFT_TORTOISE_SHELL_BRACKET	0xFE39
#define T_UTF_16_PRESENTATION_FORM_FOR_VERTICAL_RIGHT_TORTOISE_SHELL_BRACKET	0xFE3A
#define T_UTF_16_PRESENTATION_FORM_FOR_VERTICAL_LEFT_BLACK_LENTICULAR_BRACKET	0xFE3B
#define T_UTF_16_PRESENTATION_FORM_FOR_VERTICAL_RIGHT_BLACK_LENTICULAR_BRACKET	0xFE3C
#define T_UTF_16_PRESENTATION_FORM_FOR_VERTICAL_LEFT_DOUBLE_ANGLE_BRACKET	0xFE3D
#define T_UTF_16_PRESENTATION_FORM_FOR_VERTICAL_RIGHT_DOUBLE_ANGLE_BRACKET	0xFE3E
#define T_UTF_16_PRESENTATION_FORM_FOR_VERTICAL_LEFT_ANGLE_BRACKET	0xFE3F
#define T_UTF_16_PRESENTATION_FORM_FOR_VERTICAL_RIGHT_ANGLE_BRACKET	0xFE40
#define T_UTF_16_PRESENTATION_FORM_FOR_VERTICAL_LEFT_CORNER_BRACKET	0xFE41
#define T_UTF_16_PRESENTATION_FORM_FOR_VERTICAL_RIGHT_CORNER_BRACKET	0xFE42
#define T_UTF_16_PRESENTATION_FORM_FOR_VERTICAL_LEFT_WHITE_CORNER_BRACKET	0xFE43
#define T_UTF_16_PRESENTATION_FORM_FOR_VERTICAL_RIGHT_WHITE_CORNER_BRACKET	0xFE44
#define T_UTF_16_DASHED_OVERLINE	0xFE49
#define T_UTF_16_CENTRELINE_OVERLINE	0xFE4A
#define T_UTF_16_WAVY_OVERLINE	0xFE4B
#define T_UTF_16_DOUBLE_WAVY_OVERLINE	0xFE4C
#define T_UTF_16_DASHED_LOW_LINE	0xFE4D
#define T_UTF_16_CENTRELINE_LOW_LINE	0xFE4E
#define T_UTF_16_WAVY_LOW_LINE	0xFE4F
#define T_UTF_16_SMALL_COMMA	0xFE50
#define T_UTF_16_SMALL_IDEOGRAPHIC_COMMA	0xFE51
#define T_UTF_16_SMALL_FULL_STOP	0xFE52
#define T_UTF_16_SMALL_SEMICOLON	0xFE54
#define T_UTF_16_SMALL_COLON	0xFE55
#define T_UTF_16_SMALL_QUESTION_MARK	0xFE56
#define T_UTF_16_SMALL_EXCLAMATION_MARK	0xFE57
#define T_UTF_16_SMALL_EM_DASH	0xFE58
#define T_UTF_16_SMALL_LEFT_PARENTHESIS	0xFE59
#define T_UTF_16_SMALL_RIGHT_PARENTHESIS	0xFE5A
#define T_UTF_16_SMALL_LEFT_CURLY_BRACKET	0xFE5B
#define T_UTF_16_SMALL_RIGHT_CURLY_BRACKET	0xFE5C
#define T_UTF_16_SMALL_LEFT_TORTOISE_SHELL_BRACKET	0xFE5D
#define T_UTF_16_SMALL_RIGHT_TORTOISE_SHELL_BRACKET	0xFE5E
#define T_UTF_16_SMALL_NUMBER_SIGN	0xFE5F
#define T_UTF_16_SMALL_AMPERSAND	0xFE60
#define T_UTF_16_SMALL_ASTERISK	0xFE61
#define T_UTF_16_SMALL_PLUS_SIGN	0xFE62
#define T_UTF_16_SMALL_HYPHEN_MINUS	0xFE63
#define T_UTF_16_SMALL_LESS_THAN_SIGN	0xFE64
#define T_UTF_16_SMALL_GREATER_THAN_SIGN	0xFE65
#define T_UTF_16_SMALL_EQUALS_SIGN	0xFE66
#define T_UTF_16_SMALL_REVERSE_SOLIDUS	0xFE68
#define T_UTF_16_SMALL_DOLLAR_SIGN	0xFE69
#define T_UTF_16_SMALL_PERCENT_SIGN	0xFE6A
#define T_UTF_16_SMALL_COMMERCIAL_AT	0xFE6B
#define T_UTF_16_ARABIC_FATHATAN_ISOLATED_FORM	0xFE70
#define T_UTF_16_ARABIC_TATWEEL_WITH_FATHATAN_ABOVE	0xFE71
#define T_UTF_16_ARABIC_DAMMATAN_ISOLATED_FORM	0xFE72
#define T_UTF_16_ARABIC_KASRATAN_ISOLATED_FORM	0xFE74
#define T_UTF_16_ARABIC_FATHA_ISOLATED_FORM	0xFE76
#define T_UTF_16_ARABIC_FATHA_MEDIAL_FORM	0xFE77
#define T_UTF_16_ARABIC_DAMMA_ISOLATED_FORM	0xFE78
#define T_UTF_16_ARABIC_DAMMA_MEDIAL_FORM	0xFE79
#define T_UTF_16_ARABIC_KASRA_ISOLATED_FORM	0xFE7A
#define T_UTF_16_ARABIC_KASRA_MEDIAL_FORM	0xFE7B
#define T_UTF_16_ARABIC_SHADDA_ISOLATED_FORM	0xFE7C
#define T_UTF_16_ARABIC_SHADDA_MEDIAL_FORM	0xFE7D
#define T_UTF_16_ARABIC_SUKUN_ISOLATED_FORM	0xFE7E
#define T_UTF_16_ARABIC_SUKUN_MEDIAL_FORM	0xFE7F
#define T_UTF_16_ARABIC_LETTER_HAMZA_ISOLATED_FORM	0xFE80
#define T_UTF_16_ARABIC_LETTER_ALEF_WITH_MADDA_ABOVE_ISOLATED_FORM	0xFE81
#define T_UTF_16_ARABIC_LETTER_ALEF_WITH_MADDA_ABOVE_FINAL_FORM	0xFE82
#define T_UTF_16_ARABIC_LETTER_ALEF_WITH_HAMZA_ABOVE_ISOLATED_FORM	0xFE83
#define T_UTF_16_ARABIC_LETTER_ALEF_WITH_HAMZA_ABOVE_FINAL_FORM	0xFE84
#define T_UTF_16_ARABIC_LETTER_WAW_WITH_HAMZA_ABOVE_ISOLATED_FORM	0xFE85
#define T_UTF_16_ARABIC_LETTER_WAW_WITH_HAMZA_ABOVE_FINAL_FORM	0xFE86
#define T_UTF_16_ARABIC_LETTER_ALEF_WITH_HAMZA_BELOW_ISOLATED_FORM	0xFE87
#define T_UTF_16_ARABIC_LETTER_ALEF_WITH_HAMZA_BELOW_FINAL_FORM	0xFE88
#define T_UTF_16_ARABIC_LETTER_YEH_WITH_HAMZA_ABOVE_ISOLATED_FORM	0xFE89
#define T_UTF_16_ARABIC_LETTER_YEH_WITH_HAMZA_ABOVE_FINAL_FORM	0xFE8A
#define T_UTF_16_ARABIC_LETTER_YEH_WITH_HAMZA_ABOVE_INITIAL_FORM	0xFE8B
#define T_UTF_16_ARABIC_LETTER_YEH_WITH_HAMZA_ABOVE_MEDIAL_FORM	0xFE8C
#define T_UTF_16_ARABIC_LETTER_ALEF_ISOLATED_FORM	0xFE8D
#define T_UTF_16_ARABIC_LETTER_ALEF_FINAL_FORM	0xFE8E
#define T_UTF_16_ARABIC_LETTER_BEH_ISOLATED_FORM	0xFE8F
#define T_UTF_16_ARABIC_LETTER_BEH_FINAL_FORM	0xFE90
#define T_UTF_16_ARABIC_LETTER_BEH_INITIAL_FORM	0xFE91
#define T_UTF_16_ARABIC_LETTER_BEH_MEDIAL_FORM	0xFE92
#define T_UTF_16_ARABIC_LETTER_TEH_MARBUTA_ISOLATED_FORM	0xFE93
#define T_UTF_16_ARABIC_LETTER_TEH_MARBUTA_FINAL_FORM	0xFE94
#define T_UTF_16_ARABIC_LETTER_TEH_ISOLATED_FORM	0xFE95
#define T_UTF_16_ARABIC_LETTER_TEH_FINAL_FORM	0xFE96
#define T_UTF_16_ARABIC_LETTER_TEH_INITIAL_FORM	0xFE97
#define T_UTF_16_ARABIC_LETTER_TEH_MEDIAL_FORM	0xFE98
#define T_UTF_16_ARABIC_LETTER_THEH_ISOLATED_FORM	0xFE99
#define T_UTF_16_ARABIC_LETTER_THEH_FINAL_FORM	0xFE9A
#define T_UTF_16_ARABIC_LETTER_THEH_INITIAL_FORM	0xFE9B
#define T_UTF_16_ARABIC_LETTER_THEH_MEDIAL_FORM	0xFE9C
#define T_UTF_16_ARABIC_LETTER_JEEM_ISOLATED_FORM	0xFE9D
#define T_UTF_16_ARABIC_LETTER_JEEM_FINAL_FORM	0xFE9E
#define T_UTF_16_ARABIC_LETTER_JEEM_INITIAL_FORM	0xFE9F
#define T_UTF_16_ARABIC_LETTER_JEEM_MEDIAL_FORM	0xFEA0
#define T_UTF_16_ARABIC_LETTER_HAH_ISOLATED_FORM	0xFEA1
#define T_UTF_16_ARABIC_LETTER_HAH_FINAL_FORM	0xFEA2
#define T_UTF_16_ARABIC_LETTER_HAH_INITIAL_FORM	0xFEA3
#define T_UTF_16_ARABIC_LETTER_HAH_MEDIAL_FORM	0xFEA4
#define T_UTF_16_ARABIC_LETTER_KHAH_ISOLATED_FORM	0xFEA5
#define T_UTF_16_ARABIC_LETTER_KHAH_FINAL_FORM	0xFEA6
#define T_UTF_16_ARABIC_LETTER_KHAH_INITIAL_FORM	0xFEA7
#define T_UTF_16_ARABIC_LETTER_KHAH_MEDIAL_FORM	0xFEA8
#define T_UTF_16_ARABIC_LETTER_DAL_ISOLATED_FORM	0xFEA9
#define T_UTF_16_ARABIC_LETTER_DAL_FINAL_FORM	0xFEAA
#define T_UTF_16_ARABIC_LETTER_THAL_ISOLATED_FORM	0xFEAB
#define T_UTF_16_ARABIC_LETTER_THAL_FINAL_FORM	0xFEAC
#define T_UTF_16_ARABIC_LETTER_REH_ISOLATED_FORM	0xFEAD
#define T_UTF_16_ARABIC_LETTER_REH_FINAL_FORM	0xFEAE
#define T_UTF_16_ARABIC_LETTER_ZAIN_ISOLATED_FORM	0xFEAF
#define T_UTF_16_ARABIC_LETTER_ZAIN_FINAL_FORM	0xFEB0
#define T_UTF_16_ARABIC_LETTER_SEEN_ISOLATED_FORM	0xFEB1
#define T_UTF_16_ARABIC_LETTER_SEEN_FINAL_FORM	0xFEB2
#define T_UTF_16_ARABIC_LETTER_SEEN_INITIAL_FORM	0xFEB3
#define T_UTF_16_ARABIC_LETTER_SEEN_MEDIAL_FORM	0xFEB4
#define T_UTF_16_ARABIC_LETTER_SHEEN_ISOLATED_FORM	0xFEB5
#define T_UTF_16_ARABIC_LETTER_SHEEN_FINAL_FORM	0xFEB6
#define T_UTF_16_ARABIC_LETTER_SHEEN_INITIAL_FORM	0xFEB7
#define T_UTF_16_ARABIC_LETTER_SHEEN_MEDIAL_FORM	0xFEB8
#define T_UTF_16_ARABIC_LETTER_SAD_ISOLATED_FORM	0xFEB9
#define T_UTF_16_ARABIC_LETTER_SAD_FINAL_FORM	0xFEBA
#define T_UTF_16_ARABIC_LETTER_SAD_INITIAL_FORM	0xFEBB
#define T_UTF_16_ARABIC_LETTER_SAD_MEDIAL_FORM	0xFEBC
#define T_UTF_16_ARABIC_LETTER_DAD_ISOLATED_FORM	0xFEBD
#define T_UTF_16_ARABIC_LETTER_DAD_FINAL_FORM	0xFEBE
#define T_UTF_16_ARABIC_LETTER_DAD_INITIAL_FORM	0xFEBF
#define T_UTF_16_ARABIC_LETTER_DAD_MEDIAL_FORM	0xFEC0
#define T_UTF_16_ARABIC_LETTER_TAH_ISOLATED_FORM	0xFEC1
#define T_UTF_16_ARABIC_LETTER_TAH_FINAL_FORM	0xFEC2
#define T_UTF_16_ARABIC_LETTER_TAH_INITIAL_FORM	0xFEC3
#define T_UTF_16_ARABIC_LETTER_TAH_MEDIAL_FORM	0xFEC4
#define T_UTF_16_ARABIC_LETTER_ZAH_ISOLATED_FORM	0xFEC5
#define T_UTF_16_ARABIC_LETTER_ZAH_FINAL_FORM	0xFEC6
#define T_UTF_16_ARABIC_LETTER_ZAH_INITIAL_FORM	0xFEC7
#define T_UTF_16_ARABIC_LETTER_ZAH_MEDIAL_FORM	0xFEC8
#define T_UTF_16_ARABIC_LETTER_AIN_ISOLATED_FORM	0xFEC9
#define T_UTF_16_ARABIC_LETTER_AIN_FINAL_FORM	0xFECA
#define T_UTF_16_ARABIC_LETTER_AIN_INITIAL_FORM	0xFECB
#define T_UTF_16_ARABIC_LETTER_AIN_MEDIAL_FORM	0xFECC
#define T_UTF_16_ARABIC_LETTER_GHAIN_ISOLATED_FORM	0xFECD
#define T_UTF_16_ARABIC_LETTER_GHAIN_FINAL_FORM	0xFECE
#define T_UTF_16_ARABIC_LETTER_GHAIN_INITIAL_FORM	0xFECF
#define T_UTF_16_ARABIC_LETTER_GHAIN_MEDIAL_FORM	0xFED0
#define T_UTF_16_ARABIC_LETTER_FEH_ISOLATED_FORM	0xFED1
#define T_UTF_16_ARABIC_LETTER_FEH_FINAL_FORM	0xFED2
#define T_UTF_16_ARABIC_LETTER_FEH_INITIAL_FORM	0xFED3
#define T_UTF_16_ARABIC_LETTER_FEH_MEDIAL_FORM	0xFED4
#define T_UTF_16_ARABIC_LETTER_QAF_ISOLATED_FORM	0xFED5
#define T_UTF_16_ARABIC_LETTER_QAF_FINAL_FORM	0xFED6
#define T_UTF_16_ARABIC_LETTER_QAF_INITIAL_FORM	0xFED7
#define T_UTF_16_ARABIC_LETTER_QAF_MEDIAL_FORM	0xFED8
#define T_UTF_16_ARABIC_LETTER_KAF_ISOLATED_FORM	0xFED9
#define T_UTF_16_ARABIC_LETTER_KAF_FINAL_FORM	0xFEDA
#define T_UTF_16_ARABIC_LETTER_KAF_INITIAL_FORM	0xFEDB
#define T_UTF_16_ARABIC_LETTER_KAF_MEDIAL_FORM	0xFEDC
#define T_UTF_16_ARABIC_LETTER_LAM_ISOLATED_FORM	0xFEDD
#define T_UTF_16_ARABIC_LETTER_LAM_FINAL_FORM	0xFEDE
#define T_UTF_16_ARABIC_LETTER_LAM_INITIAL_FORM	0xFEDF
#define T_UTF_16_ARABIC_LETTER_LAM_MEDIAL_FORM	0xFEE0
#define T_UTF_16_ARABIC_LETTER_MEEM_ISOLATED_FORM	0xFEE1
#define T_UTF_16_ARABIC_LETTER_MEEM_FINAL_FORM	0xFEE2
#define T_UTF_16_ARABIC_LETTER_MEEM_INITIAL_FORM	0xFEE3
#define T_UTF_16_ARABIC_LETTER_MEEM_MEDIAL_FORM	0xFEE4
#define T_UTF_16_ARABIC_LETTER_NOON_ISOLATED_FORM	0xFEE5
#define T_UTF_16_ARABIC_LETTER_NOON_FINAL_FORM	0xFEE6
#define T_UTF_16_ARABIC_LETTER_NOON_INITIAL_FORM	0xFEE7
#define T_UTF_16_ARABIC_LETTER_NOON_MEDIAL_FORM	0xFEE8
#define T_UTF_16_ARABIC_LETTER_HEH_ISOLATED_FORM	0xFEE9
#define T_UTF_16_ARABIC_LETTER_HEH_FINAL_FORM	0xFEEA
#define T_UTF_16_ARABIC_LETTER_HEH_INITIAL_FORM	0xFEEB
#define T_UTF_16_ARABIC_LETTER_HEH_MEDIAL_FORM	0xFEEC
#define T_UTF_16_ARABIC_LETTER_WAW_ISOLATED_FORM	0xFEED
#define T_UTF_16_ARABIC_LETTER_WAW_FINAL_FORM	0xFEEE
#define T_UTF_16_ARABIC_LETTER_ALEF_MAKSURA_ISOLATED_FORM	0xFEEF
#define T_UTF_16_ARABIC_LETTER_ALEF_MAKSURA_FINAL_FORM	0xFEF0
#define T_UTF_16_ARABIC_LETTER_YEH_ISOLATED_FORM	0xFEF1
#define T_UTF_16_ARABIC_LETTER_YEH_FINAL_FORM	0xFEF2
#define T_UTF_16_ARABIC_LETTER_YEH_INITIAL_FORM	0xFEF3
#define T_UTF_16_ARABIC_LETTER_YEH_MEDIAL_FORM	0xFEF4
#define T_UTF_16_ARABIC_LIGATURE_LAM_WITH_ALEF_WITH_MADDA_ABOVE_ISOLATED_FORM	0xFEF5
#define T_UTF_16_ARABIC_LIGATURE_LAM_WITH_ALEF_WITH_MADDA_ABOVE_FINAL_FORM	0xFEF6
#define T_UTF_16_ARABIC_LIGATURE_LAM_WITH_ALEF_WITH_HAMZA_ABOVE_ISOLATED_FORM	0xFEF7
#define T_UTF_16_ARABIC_LIGATURE_LAM_WITH_ALEF_WITH_HAMZA_ABOVE_FINAL_FORM	0xFEF8
#define T_UTF_16_ARABIC_LIGATURE_LAM_WITH_ALEF_WITH_HAMZA_BELOW_ISOLATED_FORM	0xFEF9
#define T_UTF_16_ARABIC_LIGATURE_LAM_WITH_ALEF_WITH_HAMZA_BELOW_FINAL_FORM	0xFEFA
#define T_UTF_16_ARABIC_LIGATURE_LAM_WITH_ALEF_ISOLATED_FORM	0xFEFB
#define T_UTF_16_ARABIC_LIGATURE_LAM_WITH_ALEF_FINAL_FORM	0xFEFC
#define T_UTF_16_ZERO_WIDTH_NO_BREAK_SPACE	0xFEFF
#define T_UTF_16_FULLWIDTH_EXCLAMATION_MARK	0xFF01
#define T_UTF_16_FULLWIDTH_QUOTATION_MARK	0xFF02
#define T_UTF_16_FULLWIDTH_NUMBER_SIGN	0xFF03
#define T_UTF_16_FULLWIDTH_DOLLAR_SIGN	0xFF04
#define T_UTF_16_FULLWIDTH_PERCENT_SIGN	0xFF05
#define T_UTF_16_FULLWIDTH_AMPERSAND	0xFF06
#define T_UTF_16_FULLWIDTH_APOSTROPHE	0xFF07
#define T_UTF_16_FULLWIDTH_LEFT_PARENTHESIS	0xFF08
#define T_UTF_16_FULLWIDTH_RIGHT_PARENTHESIS	0xFF09
#define T_UTF_16_FULLWIDTH_ASTERISK	0xFF0A
#define T_UTF_16_FULLWIDTH_PLUS_SIGN	0xFF0B
#define T_UTF_16_FULLWIDTH_COMMA	0xFF0C
#define T_UTF_16_FULLWIDTH_HYPHEN_MINUS	0xFF0D
#define T_UTF_16_FULLWIDTH_FULL_STOP	0xFF0E
#define T_UTF_16_FULLWIDTH_SOLIDUS	0xFF0F
#define T_UTF_16_FULLWIDTH_DIGIT_ZERO	0xFF10
#define T_UTF_16_FULLWIDTH_DIGIT_ONE	0xFF11
#define T_UTF_16_FULLWIDTH_DIGIT_TWO	0xFF12
#define T_UTF_16_FULLWIDTH_DIGIT_THREE	0xFF13
#define T_UTF_16_FULLWIDTH_DIGIT_FOUR	0xFF14
#define T_UTF_16_FULLWIDTH_DIGIT_FIVE	0xFF15
#define T_UTF_16_FULLWIDTH_DIGIT_SIX	0xFF16
#define T_UTF_16_FULLWIDTH_DIGIT_SEVEN	0xFF17
#define T_UTF_16_FULLWIDTH_DIGIT_EIGHT	0xFF18
#define T_UTF_16_FULLWIDTH_DIGIT_NINE	0xFF19
#define T_UTF_16_FULLWIDTH_COLON	0xFF1A
#define T_UTF_16_FULLWIDTH_SEMICOLON	0xFF1B
#define T_UTF_16_FULLWIDTH_LESS_THAN_SIGN	0xFF1C
#define T_UTF_16_FULLWIDTH_EQUALS_SIGN	0xFF1D
#define T_UTF_16_FULLWIDTH_GREATER_THAN_SIGN	0xFF1E
#define T_UTF_16_FULLWIDTH_QUESTION_MARK	0xFF1F
#define T_UTF_16_FULLWIDTH_COMMERCIAL_AT	0xFF20
#define T_UTF_16_FULLWIDTH_LATIN_CAPITAL_LETTER_A	0xFF21
#define T_UTF_16_FULLWIDTH_LATIN_CAPITAL_LETTER_B	0xFF22
#define T_UTF_16_FULLWIDTH_LATIN_CAPITAL_LETTER_C	0xFF23
#define T_UTF_16_FULLWIDTH_LATIN_CAPITAL_LETTER_D	0xFF24
#define T_UTF_16_FULLWIDTH_LATIN_CAPITAL_LETTER_E	0xFF25
#define T_UTF_16_FULLWIDTH_LATIN_CAPITAL_LETTER_F	0xFF26
#define T_UTF_16_FULLWIDTH_LATIN_CAPITAL_LETTER_G	0xFF27
#define T_UTF_16_FULLWIDTH_LATIN_CAPITAL_LETTER_H	0xFF28
#define T_UTF_16_FULLWIDTH_LATIN_CAPITAL_LETTER_I	0xFF29
#define T_UTF_16_FULLWIDTH_LATIN_CAPITAL_LETTER_J	0xFF2A
#define T_UTF_16_FULLWIDTH_LATIN_CAPITAL_LETTER_K	0xFF2B
#define T_UTF_16_FULLWIDTH_LATIN_CAPITAL_LETTER_L	0xFF2C
#define T_UTF_16_FULLWIDTH_LATIN_CAPITAL_LETTER_M	0xFF2D
#define T_UTF_16_FULLWIDTH_LATIN_CAPITAL_LETTER_N	0xFF2E
#define T_UTF_16_FULLWIDTH_LATIN_CAPITAL_LETTER_O	0xFF2F
#define T_UTF_16_FULLWIDTH_LATIN_CAPITAL_LETTER_P	0xFF30
#define T_UTF_16_FULLWIDTH_LATIN_CAPITAL_LETTER_Q	0xFF31
#define T_UTF_16_FULLWIDTH_LATIN_CAPITAL_LETTER_R	0xFF32
#define T_UTF_16_FULLWIDTH_LATIN_CAPITAL_LETTER_S	0xFF33
#define T_UTF_16_FULLWIDTH_LATIN_CAPITAL_LETTER_T	0xFF34
#define T_UTF_16_FULLWIDTH_LATIN_CAPITAL_LETTER_U	0xFF35
#define T_UTF_16_FULLWIDTH_LATIN_CAPITAL_LETTER_V	0xFF36
#define T_UTF_16_FULLWIDTH_LATIN_CAPITAL_LETTER_W	0xFF37
#define T_UTF_16_FULLWIDTH_LATIN_CAPITAL_LETTER_X	0xFF38
#define T_UTF_16_FULLWIDTH_LATIN_CAPITAL_LETTER_Y	0xFF39
#define T_UTF_16_FULLWIDTH_LATIN_CAPITAL_LETTER_Z	0xFF3A
#define T_UTF_16_FULLWIDTH_LEFT_SQUARE_BRACKET	0xFF3B
#define T_UTF_16_FULLWIDTH_REVERSE_SOLIDUS	0xFF3C
#define T_UTF_16_FULLWIDTH_RIGHT_SQUARE_BRACKET	0xFF3D
#define T_UTF_16_FULLWIDTH_CIRCUMFLEX_ACCENT	0xFF3E
#define T_UTF_16_FULLWIDTH_LOW_LINE	0xFF3F
#define T_UTF_16_FULLWIDTH_GRAVE_ACCENT	0xFF40
#define T_UTF_16_FULLWIDTH_LATIN_SMALL_LETTER_A	0xFF41
#define T_UTF_16_FULLWIDTH_LATIN_SMALL_LETTER_B	0xFF42
#define T_UTF_16_FULLWIDTH_LATIN_SMALL_LETTER_C	0xFF43
#define T_UTF_16_FULLWIDTH_LATIN_SMALL_LETTER_D	0xFF44
#define T_UTF_16_FULLWIDTH_LATIN_SMALL_LETTER_E	0xFF45
#define T_UTF_16_FULLWIDTH_LATIN_SMALL_LETTER_F	0xFF46
#define T_UTF_16_FULLWIDTH_LATIN_SMALL_LETTER_G	0xFF47
#define T_UTF_16_FULLWIDTH_LATIN_SMALL_LETTER_H	0xFF48
#define T_UTF_16_FULLWIDTH_LATIN_SMALL_LETTER_I	0xFF49
#define T_UTF_16_FULLWIDTH_LATIN_SMALL_LETTER_J	0xFF4A
#define T_UTF_16_FULLWIDTH_LATIN_SMALL_LETTER_K	0xFF4B
#define T_UTF_16_FULLWIDTH_LATIN_SMALL_LETTER_L	0xFF4C
#define T_UTF_16_FULLWIDTH_LATIN_SMALL_LETTER_M	0xFF4D
#define T_UTF_16_FULLWIDTH_LATIN_SMALL_LETTER_N	0xFF4E
#define T_UTF_16_FULLWIDTH_LATIN_SMALL_LETTER_O	0xFF4F
#define T_UTF_16_FULLWIDTH_LATIN_SMALL_LETTER_P	0xFF50
#define T_UTF_16_FULLWIDTH_LATIN_SMALL_LETTER_Q	0xFF51
#define T_UTF_16_FULLWIDTH_LATIN_SMALL_LETTER_R	0xFF52
#define T_UTF_16_FULLWIDTH_LATIN_SMALL_LETTER_S	0xFF53
#define T_UTF_16_FULLWIDTH_LATIN_SMALL_LETTER_T	0xFF54
#define T_UTF_16_FULLWIDTH_LATIN_SMALL_LETTER_U	0xFF55
#define T_UTF_16_FULLWIDTH_LATIN_SMALL_LETTER_V	0xFF56
#define T_UTF_16_FULLWIDTH_LATIN_SMALL_LETTER_W	0xFF57
#define T_UTF_16_FULLWIDTH_LATIN_SMALL_LETTER_X	0xFF58
#define T_UTF_16_FULLWIDTH_LATIN_SMALL_LETTER_Y	0xFF59
#define T_UTF_16_FULLWIDTH_LATIN_SMALL_LETTER_Z	0xFF5A
#define T_UTF_16_FULLWIDTH_LEFT_CURLY_BRACKET	0xFF5B
#define T_UTF_16_FULLWIDTH_VERTICAL_LINE	0xFF5C
#define T_UTF_16_FULLWIDTH_RIGHT_CURLY_BRACKET	0xFF5D
#define T_UTF_16_FULLWIDTH_TILDE	0xFF5E
#define T_UTF_16_HALFWIDTH_IDEOGRAPHIC_FULL_STOP	0xFF61
#define T_UTF_16_HALFWIDTH_LEFT_CORNER_BRACKET	0xFF62
#define T_UTF_16_HALFWIDTH_RIGHT_CORNER_BRACKET	0xFF63
#define T_UTF_16_HALFWIDTH_IDEOGRAPHIC_COMMA	0xFF64
#define T_UTF_16_HALFWIDTH_KATAKANA_MIDDLE_DOT	0xFF65
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_WO	0xFF66
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_SMALL_A	0xFF67
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_SMALL_I	0xFF68
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_SMALL_U	0xFF69
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_SMALL_E	0xFF6A
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_SMALL_O	0xFF6B
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_SMALL_YA	0xFF6C
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_SMALL_YU	0xFF6D
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_SMALL_YO	0xFF6E
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_SMALL_TU	0xFF6F
#define T_UTF_16_HALFWIDTH_KATAKANA_HIRAGANA_PROLONGED_SOUND_MARK	0xFF70
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_A	0xFF71
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_I	0xFF72
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_U	0xFF73
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_E	0xFF74
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_O	0xFF75
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_KA	0xFF76
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_KI	0xFF77
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_KU	0xFF78
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_KE	0xFF79
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_KO	0xFF7A
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_SA	0xFF7B
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_SI	0xFF7C
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_SU	0xFF7D
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_SE	0xFF7E
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_SO	0xFF7F
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_TA	0xFF80
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_TI	0xFF81
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_TU	0xFF82
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_TE	0xFF83
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_TO	0xFF84
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_NA	0xFF85
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_NI	0xFF86
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_NU	0xFF87
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_NE	0xFF88
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_NO	0xFF89
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_HA	0xFF8A
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_HI	0xFF8B
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_HU	0xFF8C
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_HE	0xFF8D
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_HO	0xFF8E
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_MA	0xFF8F
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_MI	0xFF90
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_MU	0xFF91
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_ME	0xFF92
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_MO	0xFF93
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_YA	0xFF94
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_YU	0xFF95
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_YO	0xFF96
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_RA	0xFF97
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_RI	0xFF98
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_RU	0xFF99
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_RE	0xFF9A
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_RO	0xFF9B
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_WA	0xFF9C
#define T_UTF_16_HALFWIDTH_KATAKANA_LETTER_N	0xFF9D
#define T_UTF_16_HALFWIDTH_KATAKANA_VOICED_SOUND_MARK	0xFF9E
#define T_UTF_16_HALFWIDTH_KATAKANA_SEMI_VOICED_SOUND_MARK	0xFF9F
#define T_UTF_16_HALFWIDTH_HANGUL_FILLER	0xFFA0
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_KIYEOK	0xFFA1
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_SSANGKIYEOK	0xFFA2
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_KIYEOK_SIOS	0xFFA3
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_NIEUN	0xFFA4
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_NIEUN_CIEUC	0xFFA5
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_NIEUN_HIEUH	0xFFA6
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_TIKEUT	0xFFA7
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_SSANGTIKEUT	0xFFA8
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_RIEUL	0xFFA9
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_RIEUL_KIYEOK	0xFFAA
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_RIEUL_MIEUM	0xFFAB
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_RIEUL_PIEUP	0xFFAC
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_RIEUL_SIOS	0xFFAD
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_RIEUL_THIEUTH	0xFFAE
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_RIEUL_PHIEUPH	0xFFAF
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_RIEUL_HIEUH	0xFFB0
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_MIEUM	0xFFB1
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_PIEUP	0xFFB2
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_SSANGPIEUP	0xFFB3
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_PIEUP_SIOS	0xFFB4
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_SIOS	0xFFB5
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_SSANGSIOS	0xFFB6
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_IEUNG	0xFFB7
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_CIEUC	0xFFB8
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_SSANGCIEUC	0xFFB9
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_CHIEUCH	0xFFBA
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_KHIEUKH	0xFFBB
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_THIEUTH	0xFFBC
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_PHIEUPH	0xFFBD
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_HIEUH	0xFFBE
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_A	0xFFC2
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_AE	0xFFC3
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_YA	0xFFC4
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_YAE	0xFFC5
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_EO	0xFFC6
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_E	0xFFC7
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_YEO	0xFFCA
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_YE	0xFFCB
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_O	0xFFCC
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_WA	0xFFCD
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_WAE	0xFFCE
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_OE	0xFFCF
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_YO	0xFFD2
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_U	0xFFD3
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_WEO	0xFFD4
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_WE	0xFFD5
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_WI	0xFFD6
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_YU	0xFFD7
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_EU	0xFFDA
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_YI	0xFFDB
#define T_UTF_16_HALFWIDTH_HANGUL_LETTER_I	0xFFDC
#define T_UTF_16_FULLWIDTH_CENT_SIGN	0xFFE0
#define T_UTF_16_FULLWIDTH_POUND_SIGN	0xFFE1
#define T_UTF_16_FULLWIDTH_NOT_SIGN	0xFFE2
#define T_UTF_16_FULLWIDTH_MACRON	0xFFE3
#define T_UTF_16_FULLWIDTH_BROKEN_BAR	0xFFE4
#define T_UTF_16_FULLWIDTH_YEN_SIGN	0xFFE5
#define T_UTF_16_FULLWIDTH_WON_SIGN	0xFFE6
#define T_UTF_16_HALFWIDTH_FORMS_LIGHT_VERTICAL	0xFFE8
#define T_UTF_16_HALFWIDTH_LEFTWARDS_ARROW	0xFFE9
#define T_UTF_16_HALFWIDTH_UPWARDS_ARROW	0xFFEA
#define T_UTF_16_HALFWIDTH_RIGHTWARDS_ARROW	0xFFEB
#define T_UTF_16_HALFWIDTH_DOWNWARDS_ARROW	0xFFEC
#define T_UTF_16_HALFWIDTH_BLACK_SQUARE	0xFFED
#define T_UTF_16_HALFWIDTH_WHITE_CIRCLE	0xFFEE
#define T_UTF_16_INTERLINEAR_ANNOTATION_ANCHOR	0xFFF9
#define T_UTF_16_INTERLINEAR_ANNOTATION_SEPARATOR	0xFFFA
#define T_UTF_16_INTERLINEAR_ANNOTATION_TERMINATOR	0xFFFB
#define T_UTF_16_OBJECT_REPLACEMENT_CHARACTER	0xFFFC
#define T_UTF_16_REPLACEMENT_CHARACTER	0xFFFD
#define T_UTF_16_OLD_ITALIC_LETTER_A	0x10300
#define T_UTF_16_OLD_ITALIC_LETTER_BE	0x10301
#define T_UTF_16_OLD_ITALIC_LETTER_KE	0x10302
#define T_UTF_16_OLD_ITALIC_LETTER_DE	0x10303
#define T_UTF_16_OLD_ITALIC_LETTER_E	0x10304
#define T_UTF_16_OLD_ITALIC_LETTER_VE	0x10305
#define T_UTF_16_OLD_ITALIC_LETTER_ZE	0x10306
#define T_UTF_16_OLD_ITALIC_LETTER_HE	0x10307
#define T_UTF_16_OLD_ITALIC_LETTER_THE	0x10308
#define T_UTF_16_OLD_ITALIC_LETTER_I	0x10309
#define T_UTF_16_OLD_ITALIC_LETTER_KA	0x1030A
#define T_UTF_16_OLD_ITALIC_LETTER_EL	0x1030B
#define T_UTF_16_OLD_ITALIC_LETTER_EM	0x1030C
#define T_UTF_16_OLD_ITALIC_LETTER_EN	0x1030D
#define T_UTF_16_OLD_ITALIC_LETTER_ESH	0x1030E
#define T_UTF_16_OLD_ITALIC_LETTER_O	0x1030F
#define T_UTF_16_OLD_ITALIC_LETTER_PE	0x10310
#define T_UTF_16_OLD_ITALIC_LETTER_SHE	0x10311
#define T_UTF_16_OLD_ITALIC_LETTER_KU	0x10312
#define T_UTF_16_OLD_ITALIC_LETTER_ER	0x10313
#define T_UTF_16_OLD_ITALIC_LETTER_ES	0x10314
#define T_UTF_16_OLD_ITALIC_LETTER_TE	0x10315
#define T_UTF_16_OLD_ITALIC_LETTER_U	0x10316
#define T_UTF_16_OLD_ITALIC_LETTER_EKS	0x10317
#define T_UTF_16_OLD_ITALIC_LETTER_PHE	0x10318
#define T_UTF_16_OLD_ITALIC_LETTER_KHE	0x10319
#define T_UTF_16_OLD_ITALIC_LETTER_EF	0x1031A
#define T_UTF_16_OLD_ITALIC_LETTER_ERS	0x1031B
#define T_UTF_16_OLD_ITALIC_LETTER_CHE	0x1031C
#define T_UTF_16_OLD_ITALIC_LETTER_II	0x1031D
#define T_UTF_16_OLD_ITALIC_LETTER_UU	0x1031E
#define T_UTF_16_OLD_ITALIC_NUMERAL_ONE	0x10320
#define T_UTF_16_OLD_ITALIC_NUMERAL_FIVE	0x10321
#define T_UTF_16_OLD_ITALIC_NUMERAL_TEN	0x10322
#define T_UTF_16_OLD_ITALIC_NUMERAL_FIFTY	0x10323
#define T_UTF_16_GOTHIC_LETTER_AHSA	0x10330
#define T_UTF_16_GOTHIC_LETTER_BAIRKAN	0x10331
#define T_UTF_16_GOTHIC_LETTER_GIBA	0x10332
#define T_UTF_16_GOTHIC_LETTER_DAGS	0x10333
#define T_UTF_16_GOTHIC_LETTER_AIHVUS	0x10334
#define T_UTF_16_GOTHIC_LETTER_QAIRTHRA	0x10335
#define T_UTF_16_GOTHIC_LETTER_IUJA	0x10336
#define T_UTF_16_GOTHIC_LETTER_HAGL	0x10337
#define T_UTF_16_GOTHIC_LETTER_THIUTH	0x10338
#define T_UTF_16_GOTHIC_LETTER_EIS	0x10339
#define T_UTF_16_GOTHIC_LETTER_KUSMA	0x1033A
#define T_UTF_16_GOTHIC_LETTER_LAGUS	0x1033B
#define T_UTF_16_GOTHIC_LETTER_MANNA	0x1033C
#define T_UTF_16_GOTHIC_LETTER_NAUTHS	0x1033D
#define T_UTF_16_GOTHIC_LETTER_JER	0x1033E
#define T_UTF_16_GOTHIC_LETTER_URUS	0x1033F
#define T_UTF_16_GOTHIC_LETTER_PAIRTHRA	0x10340
#define T_UTF_16_GOTHIC_LETTER_NINETY	0x10341
#define T_UTF_16_GOTHIC_LETTER_RAIDA	0x10342
#define T_UTF_16_GOTHIC_LETTER_SAUIL	0x10343
#define T_UTF_16_GOTHIC_LETTER_TEIWS	0x10344
#define T_UTF_16_GOTHIC_LETTER_WINJA	0x10345
#define T_UTF_16_GOTHIC_LETTER_FAIHU	0x10346
#define T_UTF_16_GOTHIC_LETTER_IGGWS	0x10347
#define T_UTF_16_GOTHIC_LETTER_HWAIR	0x10348
#define T_UTF_16_GOTHIC_LETTER_OTHAL	0x10349
#define T_UTF_16_GOTHIC_LETTER_NINE_HUNDRED	0x1034A
#define T_UTF_16_DESERET_CAPITAL_LETTER_LONG_I	0x10400
#define T_UTF_16_DESERET_CAPITAL_LETTER_LONG_E	0x10401
#define T_UTF_16_DESERET_CAPITAL_LETTER_LONG_A	0x10402
#define T_UTF_16_DESERET_CAPITAL_LETTER_LONG_AH	0x10403
#define T_UTF_16_DESERET_CAPITAL_LETTER_LONG_O	0x10404
#define T_UTF_16_DESERET_CAPITAL_LETTER_LONG_OO	0x10405
#define T_UTF_16_DESERET_CAPITAL_LETTER_SHORT_I	0x10406
#define T_UTF_16_DESERET_CAPITAL_LETTER_SHORT_E	0x10407
#define T_UTF_16_DESERET_CAPITAL_LETTER_SHORT_A	0x10408
#define T_UTF_16_DESERET_CAPITAL_LETTER_SHORT_AH	0x10409
#define T_UTF_16_DESERET_CAPITAL_LETTER_SHORT_O	0x1040A
#define T_UTF_16_DESERET_CAPITAL_LETTER_SHORT_OO	0x1040B
#define T_UTF_16_DESERET_CAPITAL_LETTER_AY	0x1040C
#define T_UTF_16_DESERET_CAPITAL_LETTER_OW	0x1040D
#define T_UTF_16_DESERET_CAPITAL_LETTER_WU	0x1040E
#define T_UTF_16_DESERET_CAPITAL_LETTER_YEE	0x1040F
#define T_UTF_16_DESERET_CAPITAL_LETTER_H	0x10410
#define T_UTF_16_DESERET_CAPITAL_LETTER_PEE	0x10411
#define T_UTF_16_DESERET_CAPITAL_LETTER_BEE	0x10412
#define T_UTF_16_DESERET_CAPITAL_LETTER_TEE	0x10413
#define T_UTF_16_DESERET_CAPITAL_LETTER_DEE	0x10414
#define T_UTF_16_DESERET_CAPITAL_LETTER_CHEE	0x10415
#define T_UTF_16_DESERET_CAPITAL_LETTER_JEE	0x10416
#define T_UTF_16_DESERET_CAPITAL_LETTER_KAY	0x10417
#define T_UTF_16_DESERET_CAPITAL_LETTER_GAY	0x10418
#define T_UTF_16_DESERET_CAPITAL_LETTER_EF	0x10419
#define T_UTF_16_DESERET_CAPITAL_LETTER_VEE	0x1041A
#define T_UTF_16_DESERET_CAPITAL_LETTER_ETH	0x1041B
#define T_UTF_16_DESERET_CAPITAL_LETTER_THEE	0x1041C
#define T_UTF_16_DESERET_CAPITAL_LETTER_ES	0x1041D
#define T_UTF_16_DESERET_CAPITAL_LETTER_ZEE	0x1041E
#define T_UTF_16_DESERET_CAPITAL_LETTER_ESH	0x1041F
#define T_UTF_16_DESERET_CAPITAL_LETTER_ZHEE	0x10420
#define T_UTF_16_DESERET_CAPITAL_LETTER_ER	0x10421
#define T_UTF_16_DESERET_CAPITAL_LETTER_EL	0x10422
#define T_UTF_16_DESERET_CAPITAL_LETTER_EM	0x10423
#define T_UTF_16_DESERET_CAPITAL_LETTER_EN	0x10424
#define T_UTF_16_DESERET_CAPITAL_LETTER_ENG	0x10425
#define T_UTF_16_DESERET_SMALL_LETTER_LONG_I	0x10428
#define T_UTF_16_DESERET_SMALL_LETTER_LONG_E	0x10429
#define T_UTF_16_DESERET_SMALL_LETTER_LONG_A	0x1042A
#define T_UTF_16_DESERET_SMALL_LETTER_LONG_AH	0x1042B
#define T_UTF_16_DESERET_SMALL_LETTER_LONG_O	0x1042C
#define T_UTF_16_DESERET_SMALL_LETTER_LONG_OO	0x1042D
#define T_UTF_16_DESERET_SMALL_LETTER_SHORT_I	0x1042E
#define T_UTF_16_DESERET_SMALL_LETTER_SHORT_E	0x1042F
#define T_UTF_16_DESERET_SMALL_LETTER_SHORT_A	0x10430
#define T_UTF_16_DESERET_SMALL_LETTER_SHORT_AH	0x10431
#define T_UTF_16_DESERET_SMALL_LETTER_SHORT_O	0x10432
#define T_UTF_16_DESERET_SMALL_LETTER_SHORT_OO	0x10433
#define T_UTF_16_DESERET_SMALL_LETTER_AY	0x10434
#define T_UTF_16_DESERET_SMALL_LETTER_OW	0x10435
#define T_UTF_16_DESERET_SMALL_LETTER_WU	0x10436
#define T_UTF_16_DESERET_SMALL_LETTER_YEE	0x10437
#define T_UTF_16_DESERET_SMALL_LETTER_H	0x10438
#define T_UTF_16_DESERET_SMALL_LETTER_PEE	0x10439
#define T_UTF_16_DESERET_SMALL_LETTER_BEE	0x1043A
#define T_UTF_16_DESERET_SMALL_LETTER_TEE	0x1043B
#define T_UTF_16_DESERET_SMALL_LETTER_DEE	0x1043C
#define T_UTF_16_DESERET_SMALL_LETTER_CHEE	0x1043D
#define T_UTF_16_DESERET_SMALL_LETTER_JEE	0x1043E
#define T_UTF_16_DESERET_SMALL_LETTER_KAY	0x1043F
#define T_UTF_16_DESERET_SMALL_LETTER_GAY	0x10440
#define T_UTF_16_DESERET_SMALL_LETTER_EF	0x10441
#define T_UTF_16_DESERET_SMALL_LETTER_VEE	0x10442
#define T_UTF_16_DESERET_SMALL_LETTER_ETH	0x10443
#define T_UTF_16_DESERET_SMALL_LETTER_THEE	0x10444
#define T_UTF_16_DESERET_SMALL_LETTER_ES	0x10445
#define T_UTF_16_DESERET_SMALL_LETTER_ZEE	0x10446
#define T_UTF_16_DESERET_SMALL_LETTER_ESH	0x10447
#define T_UTF_16_DESERET_SMALL_LETTER_ZHEE	0x10448
#define T_UTF_16_DESERET_SMALL_LETTER_ER	0x10449
#define T_UTF_16_DESERET_SMALL_LETTER_EL	0x1044A
#define T_UTF_16_DESERET_SMALL_LETTER_EM	0x1044B
#define T_UTF_16_DESERET_SMALL_LETTER_EN	0x1044C
#define T_UTF_16_DESERET_SMALL_LETTER_ENG	0x1044D
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_PSILI	0x1D000
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_DASEIA	0x1D001
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_PERISPOMENI	0x1D002
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_OXEIA_EKFONITIKON	0x1D003
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_OXEIA_DIPLI	0x1D004
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_VAREIA_EKFONITIKON	0x1D005
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_VAREIA_DIPLI	0x1D006
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_KATHISTI	0x1D007
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_SYRMATIKI	0x1D008
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_PARAKLITIKI	0x1D009
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_YPOKRISIS	0x1D00A
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_YPOKRISIS_DIPLI	0x1D00B
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_KREMASTI	0x1D00C
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_APESO_EKFONITIKON	0x1D00D
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_EXO_EKFONITIKON	0x1D00E
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_TELEIA	0x1D00F
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_KENTIMATA	0x1D010
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_APOSTROFOS	0x1D011
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_APOSTROFOS_DIPLI	0x1D012
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_SYNEVMA	0x1D013
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_THITA	0x1D014
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_OLIGON_ARCHAION	0x1D015
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_GORGON_ARCHAION	0x1D016
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_PSILON	0x1D017
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_CHAMILON	0x1D018
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_VATHY	0x1D019
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_ISON_ARCHAION	0x1D01A
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_KENTIMA_ARCHAION	0x1D01B
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_KENTIMATA_ARCHAION	0x1D01C
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_SAXIMATA	0x1D01D
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_PARICHON	0x1D01E
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_STAVROS_APODEXIA	0x1D01F
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_OXEIAI_ARCHAION	0x1D020
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_VAREIAI_ARCHAION	0x1D021
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_APODERMA_ARCHAION	0x1D022
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_APOTHEMA	0x1D023
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_KLASMA	0x1D024
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_REVMA	0x1D025
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_PIASMA_ARCHAION	0x1D026
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_TINAGMA	0x1D027
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_ANATRICHISMA	0x1D028
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_SEISMA	0x1D029
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_SYNAGMA_ARCHAION	0x1D02A
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_SYNAGMA_META_STAVROU	0x1D02B
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_OYRANISMA_ARCHAION	0x1D02C
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_THEMA	0x1D02D
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_LEMOI	0x1D02E
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_DYO	0x1D02F
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_TRIA	0x1D030
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_TESSERA	0x1D031
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_KRATIMATA	0x1D032
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_APESO_EXO_NEO	0x1D033
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_FTHORA_ARCHAION	0x1D034
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_IMIFTHORA	0x1D035
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_TROMIKON_ARCHAION	0x1D036
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_KATAVA_TROMIKON	0x1D037
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_PELASTON	0x1D038
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_PSIFISTON	0x1D039
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_KONTEVMA	0x1D03A
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_CHOREVMA_ARCHAION	0x1D03B
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_RAPISMA	0x1D03C
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_PARAKALESMA_ARCHAION	0x1D03D
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_PARAKLITIKI_ARCHAION	0x1D03E
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_ICHADIN	0x1D03F
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_NANA	0x1D040
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_PETASMA	0x1D041
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_KONTEVMA_ALLO	0x1D042
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_TROMIKON_ALLO	0x1D043
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_STRAGGISMATA	0x1D044
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_GRONTHISMATA	0x1D045
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_ISON_NEO	0x1D046
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_OLIGON_NEO	0x1D047
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_OXEIA_NEO	0x1D048
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_PETASTI	0x1D049
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_KOUFISMA	0x1D04A
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_PETASTOKOUFISMA	0x1D04B
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_KRATIMOKOUFISMA	0x1D04C
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_PELASTON_NEO	0x1D04D
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_KENTIMATA_NEO_ANO	0x1D04E
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_KENTIMA_NEO_ANO	0x1D04F
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_YPSILI	0x1D050
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_APOSTROFOS_NEO	0x1D051
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_APOSTROFOI_SYNDESMOS_NEO	0x1D052
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_YPORROI	0x1D053
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_KRATIMOYPORROON	0x1D054
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_ELAFRON	0x1D055
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_CHAMILI	0x1D056
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_MIKRON_ISON	0x1D057
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_VAREIA_NEO	0x1D058
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_PIASMA_NEO	0x1D059
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_PSIFISTON_NEO	0x1D05A
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_OMALON	0x1D05B
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_ANTIKENOMA	0x1D05C
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_LYGISMA	0x1D05D
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_PARAKLITIKI_NEO	0x1D05E
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_PARAKALESMA_NEO	0x1D05F
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_ETERON_PARAKALESMA	0x1D060
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_KYLISMA	0x1D061
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_ANTIKENOKYLISMA	0x1D062
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_TROMIKON_NEO	0x1D063
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_EKSTREPTON	0x1D064
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_SYNAGMA_NEO	0x1D065
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_SYRMA	0x1D066
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_CHOREVMA_NEO	0x1D067
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_EPEGERMA	0x1D068
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_SEISMA_NEO	0x1D069
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_XIRON_KLASMA	0x1D06A
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_TROMIKOPSIFISTON	0x1D06B
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_PSIFISTOLYGISMA	0x1D06C
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_TROMIKOLYGISMA	0x1D06D
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_TROMIKOPARAKALESMA	0x1D06E
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_PSIFISTOPARAKALESMA	0x1D06F
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_TROMIKOSYNAGMA	0x1D070
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_PSIFISTOSYNAGMA	0x1D071
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_GORGOSYNTHETON	0x1D072
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_ARGOSYNTHETON	0x1D073
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_ETERON_ARGOSYNTHETON	0x1D074
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_OYRANISMA_NEO	0x1D075
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_THEMATISMOS_ESO	0x1D076
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_THEMATISMOS_EXO	0x1D077
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_THEMA_APLOUN	0x1D078
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_THES_KAI_APOTHES	0x1D079
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_KATAVASMA	0x1D07A
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_ENDOFONON	0x1D07B
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_YFEN_KATO	0x1D07C
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_YFEN_ANO	0x1D07D
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_STAVROS	0x1D07E
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_KLASMA_ANO	0x1D07F
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_DIPLI_ARCHAION	0x1D080
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_KRATIMA_ARCHAION	0x1D081
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_KRATIMA_ALLO	0x1D082
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_KRATIMA_NEO	0x1D083
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_APODERMA_NEO	0x1D084
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_APLI	0x1D085
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_DIPLI	0x1D086
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_TRIPLI	0x1D087
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_TETRAPLI	0x1D088
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_KORONIS	0x1D089
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_LEIMMA_ENOS_CHRONOU	0x1D08A
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_LEIMMA_DYO_CHRONON	0x1D08B
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_LEIMMA_TRION_CHRONON	0x1D08C
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_LEIMMA_TESSARON_CHRONON	0x1D08D
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_LEIMMA_IMISEOS_CHRONOU	0x1D08E
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_GORGON_NEO_ANO	0x1D08F
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_GORGON_PARESTIGMENON_ARISTERA	0x1D090
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_GORGON_PARESTIGMENON_DEXIA	0x1D091
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_DIGORGON	0x1D092
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_DIGORGON_PARESTIGMENON_ARISTERA_KATO	0x1D093
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_DIGORGON_PARESTIGMENON_ARISTERA_ANO	0x1D094
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_DIGORGON_PARESTIGMENON_DEXIA	0x1D095
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_TRIGORGON	0x1D096
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_ARGON	0x1D097
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_IMIDIARGON	0x1D098
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_DIARGON	0x1D099
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_AGOGI_POLI_ARGI	0x1D09A
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_AGOGI_ARGOTERI	0x1D09B
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_AGOGI_ARGI	0x1D09C
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_AGOGI_METRIA	0x1D09D
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_AGOGI_MESI	0x1D09E
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_AGOGI_GORGI	0x1D09F
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_AGOGI_GORGOTERI	0x1D0A0
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_AGOGI_POLI_GORGI	0x1D0A1
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_MARTYRIA_PROTOS_ICHOS	0x1D0A2
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_MARTYRIA_ALLI_PROTOS_ICHOS	0x1D0A3
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_MARTYRIA_DEYTEROS_ICHOS	0x1D0A4
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_MARTYRIA_ALLI_DEYTEROS_ICHOS	0x1D0A5
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_MARTYRIA_TRITOS_ICHOS	0x1D0A6
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_MARTYRIA_TRIFONIAS	0x1D0A7
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_MARTYRIA_TETARTOS_ICHOS	0x1D0A8
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_MARTYRIA_TETARTOS_LEGETOS_ICHOS	0x1D0A9
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_MARTYRIA_LEGETOS_ICHOS	0x1D0AA
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_MARTYRIA_PLAGIOS_ICHOS	0x1D0AB
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_ISAKIA_TELOUS_ICHIMATOS	0x1D0AC
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_APOSTROFOI_TELOUS_ICHIMATOS	0x1D0AD
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_FANEROSIS_TETRAFONIAS	0x1D0AE
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_FANEROSIS_MONOFONIAS	0x1D0AF
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_FANEROSIS_DIFONIAS	0x1D0B0
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_MARTYRIA_VARYS_ICHOS	0x1D0B1
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_MARTYRIA_PROTOVARYS_ICHOS	0x1D0B2
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_MARTYRIA_PLAGIOS_TETARTOS_ICHOS	0x1D0B3
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_GORTHMIKON_N_APLOUN	0x1D0B4
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_GORTHMIKON_N_DIPLOUN	0x1D0B5
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_ENARXIS_KAI_FTHORA_VOU	0x1D0B6
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_IMIFONON	0x1D0B7
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_IMIFTHORON	0x1D0B8
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_FTHORA_ARCHAION_DEYTEROU_ICHOU	0x1D0B9
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_FTHORA_DIATONIKI_PA	0x1D0BA
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_FTHORA_DIATONIKI_NANA	0x1D0BB
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_FTHORA_NAOS_ICHOS	0x1D0BC
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_FTHORA_DIATONIKI_DI	0x1D0BD
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_FTHORA_SKLIRON_DIATONON_DI	0x1D0BE
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_FTHORA_DIATONIKI_KE	0x1D0BF
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_FTHORA_DIATONIKI_ZO	0x1D0C0
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_FTHORA_DIATONIKI_NI_KATO	0x1D0C1
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_FTHORA_DIATONIKI_NI_ANO	0x1D0C2
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_FTHORA_MALAKON_CHROMA_DIFONIAS	0x1D0C3
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_FTHORA_MALAKON_CHROMA_MONOFONIAS	0x1D0C4
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_FHTORA_SKLIRON_CHROMA_VASIS	0x1D0C5
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_FTHORA_SKLIRON_CHROMA_SYNAFI	0x1D0C6
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_FTHORA_NENANO	0x1D0C7
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_CHROA_ZYGOS	0x1D0C8
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_CHROA_KLITON	0x1D0C9
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_CHROA_SPATHI	0x1D0CA
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_FTHORA_I_YFESIS_TETARTIMORION	0x1D0CB
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_FTHORA_ENARMONIOS_ANTIFONIA	0x1D0CC
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_YFESIS_TRITIMORION	0x1D0CD
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_DIESIS_TRITIMORION	0x1D0CE
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_DIESIS_TETARTIMORION	0x1D0CF
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_DIESIS_APLI_DYO_DODEKATA	0x1D0D0
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_DIESIS_MONOGRAMMOS_TESSERA_DODEKATA	0x1D0D1
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_DIESIS_DIGRAMMOS_EX_DODEKATA	0x1D0D2
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_DIESIS_TRIGRAMMOS_OKTO_DODEKATA	0x1D0D3
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_YFESIS_APLI_DYO_DODEKATA	0x1D0D4
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_YFESIS_MONOGRAMMOS_TESSERA_DODEKATA	0x1D0D5
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_YFESIS_DIGRAMMOS_EX_DODEKATA	0x1D0D6
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_YFESIS_TRIGRAMMOS_OKTO_DODEKATA	0x1D0D7
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_GENIKI_DIESIS	0x1D0D8
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_GENIKI_YFESIS	0x1D0D9
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_DIASTOLI_APLI_MIKRI	0x1D0DA
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_DIASTOLI_APLI_MEGALI	0x1D0DB
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_DIASTOLI_DIPLI	0x1D0DC
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_DIASTOLI_THESEOS	0x1D0DD
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_SIMANSIS_THESEOS	0x1D0DE
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_SIMANSIS_THESEOS_DISIMOU	0x1D0DF
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_SIMANSIS_THESEOS_TRISIMOU	0x1D0E0
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_SIMANSIS_THESEOS_TETRASIMOU	0x1D0E1
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_SIMANSIS_ARSEOS	0x1D0E2
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_SIMANSIS_ARSEOS_DISIMOU	0x1D0E3
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_SIMANSIS_ARSEOS_TRISIMOU	0x1D0E4
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_SIMANSIS_ARSEOS_TETRASIMOU	0x1D0E5
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_DIGRAMMA_GG	0x1D0E6
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_DIFTOGGOS_OU	0x1D0E7
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_STIGMA	0x1D0E8
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_ARKTIKO_PA	0x1D0E9
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_ARKTIKO_VOU	0x1D0EA
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_ARKTIKO_GA	0x1D0EB
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_ARKTIKO_DI	0x1D0EC
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_ARKTIKO_KE	0x1D0ED
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_ARKTIKO_ZO	0x1D0EE
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_ARKTIKO_NI	0x1D0EF
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_KENTIMATA_NEO_MESO	0x1D0F0
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_KENTIMA_NEO_MESO	0x1D0F1
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_KENTIMATA_NEO_KATO	0x1D0F2
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_KENTIMA_NEO_KATO	0x1D0F3
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_KLASMA_KATO	0x1D0F4
#define T_UTF_16_BYZANTINE_MUSICAL_SYMBOL_GORGON_NEO_KATO	0x1D0F5
#define T_UTF_16_MUSICAL_SYMBOL_SINGLE_BARLINE	0x1D100
#define T_UTF_16_MUSICAL_SYMBOL_DOUBLE_BARLINE	0x1D101
#define T_UTF_16_MUSICAL_SYMBOL_FINAL_BARLINE	0x1D102
#define T_UTF_16_MUSICAL_SYMBOL_REVERSE_FINAL_BARLINE	0x1D103
#define T_UTF_16_MUSICAL_SYMBOL_DASHED_BARLINE	0x1D104
#define T_UTF_16_MUSICAL_SYMBOL_SHORT_BARLINE	0x1D105
#define T_UTF_16_MUSICAL_SYMBOL_LEFT_REPEAT_SIGN	0x1D106
#define T_UTF_16_MUSICAL_SYMBOL_RIGHT_REPEAT_SIGN	0x1D107
#define T_UTF_16_MUSICAL_SYMBOL_REPEAT_DOTS	0x1D108
#define T_UTF_16_MUSICAL_SYMBOL_DAL_SEGNO	0x1D109
#define T_UTF_16_MUSICAL_SYMBOL_DA_CAPO	0x1D10A
#define T_UTF_16_MUSICAL_SYMBOL_SEGNO	0x1D10B
#define T_UTF_16_MUSICAL_SYMBOL_CODA	0x1D10C
#define T_UTF_16_MUSICAL_SYMBOL_REPEATED_FIGURE_1	0x1D10D
#define T_UTF_16_MUSICAL_SYMBOL_REPEATED_FIGURE_2	0x1D10E
#define T_UTF_16_MUSICAL_SYMBOL_REPEATED_FIGURE_3	0x1D10F
#define T_UTF_16_MUSICAL_SYMBOL_FERMATA	0x1D110
#define T_UTF_16_MUSICAL_SYMBOL_FERMATA_BELOW	0x1D111
#define T_UTF_16_MUSICAL_SYMBOL_BREATH_MARK	0x1D112
#define T_UTF_16_MUSICAL_SYMBOL_CAESURA	0x1D113
#define T_UTF_16_MUSICAL_SYMBOL_BRACE	0x1D114
#define T_UTF_16_MUSICAL_SYMBOL_BRACKET	0x1D115
#define T_UTF_16_MUSICAL_SYMBOL_ONE_LINE_STAFF	0x1D116
#define T_UTF_16_MUSICAL_SYMBOL_TWO_LINE_STAFF	0x1D117
#define T_UTF_16_MUSICAL_SYMBOL_THREE_LINE_STAFF	0x1D118
#define T_UTF_16_MUSICAL_SYMBOL_FOUR_LINE_STAFF	0x1D119
#define T_UTF_16_MUSICAL_SYMBOL_FIVE_LINE_STAFF	0x1D11A
#define T_UTF_16_MUSICAL_SYMBOL_SIX_LINE_STAFF	0x1D11B
#define T_UTF_16_MUSICAL_SYMBOL_SIX_STRING_FRETBOARD	0x1D11C
#define T_UTF_16_MUSICAL_SYMBOL_FOUR_STRING_FRETBOARD	0x1D11D
#define T_UTF_16_MUSICAL_SYMBOL_G_CLEF	0x1D11E
#define T_UTF_16_MUSICAL_SYMBOL_G_CLEF_OTTAVA_ALTA	0x1D11F
#define T_UTF_16_MUSICAL_SYMBOL_G_CLEF_OTTAVA_BASSA	0x1D120
#define T_UTF_16_MUSICAL_SYMBOL_C_CLEF	0x1D121
#define T_UTF_16_MUSICAL_SYMBOL_F_CLEF	0x1D122
#define T_UTF_16_MUSICAL_SYMBOL_F_CLEF_OTTAVA_ALTA	0x1D123
#define T_UTF_16_MUSICAL_SYMBOL_F_CLEF_OTTAVA_BASSA	0x1D124
#define T_UTF_16_MUSICAL_SYMBOL_DRUM_CLEF_1	0x1D125
#define T_UTF_16_MUSICAL_SYMBOL_DRUM_CLEF_2	0x1D126
#define T_UTF_16_MUSICAL_SYMBOL_DOUBLE_SHARP	0x1D12A
#define T_UTF_16_MUSICAL_SYMBOL_DOUBLE_FLAT	0x1D12B
#define T_UTF_16_MUSICAL_SYMBOL_FLAT_UP	0x1D12C
#define T_UTF_16_MUSICAL_SYMBOL_FLAT_DOWN	0x1D12D
#define T_UTF_16_MUSICAL_SYMBOL_NATURAL_UP	0x1D12E
#define T_UTF_16_MUSICAL_SYMBOL_NATURAL_DOWN	0x1D12F
#define T_UTF_16_MUSICAL_SYMBOL_SHARP_UP	0x1D130
#define T_UTF_16_MUSICAL_SYMBOL_SHARP_DOWN	0x1D131
#define T_UTF_16_MUSICAL_SYMBOL_QUARTER_TONE_SHARP	0x1D132
#define T_UTF_16_MUSICAL_SYMBOL_QUARTER_TONE_FLAT	0x1D133
#define T_UTF_16_MUSICAL_SYMBOL_COMMON_TIME	0x1D134
#define T_UTF_16_MUSICAL_SYMBOL_CUT_TIME	0x1D135
#define T_UTF_16_MUSICAL_SYMBOL_OTTAVA_ALTA	0x1D136
#define T_UTF_16_MUSICAL_SYMBOL_OTTAVA_BASSA	0x1D137
#define T_UTF_16_MUSICAL_SYMBOL_QUINDICESIMA_ALTA	0x1D138
#define T_UTF_16_MUSICAL_SYMBOL_QUINDICESIMA_BASSA	0x1D139
#define T_UTF_16_MUSICAL_SYMBOL_MULTI_REST	0x1D13A
#define T_UTF_16_MUSICAL_SYMBOL_WHOLE_REST	0x1D13B
#define T_UTF_16_MUSICAL_SYMBOL_HALF_REST	0x1D13C
#define T_UTF_16_MUSICAL_SYMBOL_QUARTER_REST	0x1D13D
#define T_UTF_16_MUSICAL_SYMBOL_EIGHTH_REST	0x1D13E
#define T_UTF_16_MUSICAL_SYMBOL_SIXTEENTH_REST	0x1D13F
#define T_UTF_16_MUSICAL_SYMBOL_THIRTY_SECOND_REST	0x1D140
#define T_UTF_16_MUSICAL_SYMBOL_SIXTY_FOURTH_REST	0x1D141
#define T_UTF_16_MUSICAL_SYMBOL_ONE_HUNDRED_TWENTY_EIGHTH_REST	0x1D142
#define T_UTF_16_MUSICAL_SYMBOL_X_NOTEHEAD	0x1D143
#define T_UTF_16_MUSICAL_SYMBOL_PLUS_NOTEHEAD	0x1D144
#define T_UTF_16_MUSICAL_SYMBOL_CIRCLE_X_NOTEHEAD	0x1D145
#define T_UTF_16_MUSICAL_SYMBOL_SQUARE_NOTEHEAD_WHITE	0x1D146
#define T_UTF_16_MUSICAL_SYMBOL_SQUARE_NOTEHEAD_BLACK	0x1D147
#define T_UTF_16_MUSICAL_SYMBOL_TRIANGLE_NOTEHEAD_UP_WHITE	0x1D148
#define T_UTF_16_MUSICAL_SYMBOL_TRIANGLE_NOTEHEAD_UP_BLACK	0x1D149
#define T_UTF_16_MUSICAL_SYMBOL_TRIANGLE_NOTEHEAD_LEFT_WHITE	0x1D14A
#define T_UTF_16_MUSICAL_SYMBOL_TRIANGLE_NOTEHEAD_LEFT_BLACK	0x1D14B
#define T_UTF_16_MUSICAL_SYMBOL_TRIANGLE_NOTEHEAD_RIGHT_WHITE	0x1D14C
#define T_UTF_16_MUSICAL_SYMBOL_TRIANGLE_NOTEHEAD_RIGHT_BLACK	0x1D14D
#define T_UTF_16_MUSICAL_SYMBOL_TRIANGLE_NOTEHEAD_DOWN_WHITE	0x1D14E
#define T_UTF_16_MUSICAL_SYMBOL_TRIANGLE_NOTEHEAD_DOWN_BLACK	0x1D14F
#define T_UTF_16_MUSICAL_SYMBOL_TRIANGLE_NOTEHEAD_UP_RIGHT_WHITE	0x1D150
#define T_UTF_16_MUSICAL_SYMBOL_TRIANGLE_NOTEHEAD_UP_RIGHT_BLACK	0x1D151
#define T_UTF_16_MUSICAL_SYMBOL_MOON_NOTEHEAD_WHITE	0x1D152
#define T_UTF_16_MUSICAL_SYMBOL_MOON_NOTEHEAD_BLACK	0x1D153
#define T_UTF_16_MUSICAL_SYMBOL_TRIANGLE_ROUND_NOTEHEAD_DOWN_WHITE	0x1D154
#define T_UTF_16_MUSICAL_SYMBOL_TRIANGLE_ROUND_NOTEHEAD_DOWN_BLACK	0x1D155
#define T_UTF_16_MUSICAL_SYMBOL_PARENTHESIS_NOTEHEAD	0x1D156
#define T_UTF_16_MUSICAL_SYMBOL_VOID_NOTEHEAD	0x1D157
#define T_UTF_16_MUSICAL_SYMBOL_NOTEHEAD_BLACK	0x1D158
#define T_UTF_16_MUSICAL_SYMBOL_NULL_NOTEHEAD	0x1D159
#define T_UTF_16_MUSICAL_SYMBOL_CLUSTER_NOTEHEAD_WHITE	0x1D15A
#define T_UTF_16_MUSICAL_SYMBOL_CLUSTER_NOTEHEAD_BLACK	0x1D15B
#define T_UTF_16_MUSICAL_SYMBOL_BREVE	0x1D15C
#define T_UTF_16_MUSICAL_SYMBOL_WHOLE_NOTE	0x1D15D
#define T_UTF_16_MUSICAL_SYMBOL_HALF_NOTE	0x1D15E
#define T_UTF_16_MUSICAL_SYMBOL_QUARTER_NOTE	0x1D15F
#define T_UTF_16_MUSICAL_SYMBOL_EIGHTH_NOTE	0x1D160
#define T_UTF_16_MUSICAL_SYMBOL_SIXTEENTH_NOTE	0x1D161
#define T_UTF_16_MUSICAL_SYMBOL_THIRTY_SECOND_NOTE	0x1D162
#define T_UTF_16_MUSICAL_SYMBOL_SIXTY_FOURTH_NOTE	0x1D163
#define T_UTF_16_MUSICAL_SYMBOL_ONE_HUNDRED_TWENTY_EIGHTH_NOTE	0x1D164
#define T_UTF_16_MUSICAL_SYMBOL_COMBINING_STEM	0x1D165
#define T_UTF_16_MUSICAL_SYMBOL_COMBINING_SPRECHGESANG_STEM	0x1D166
#define T_UTF_16_MUSICAL_SYMBOL_COMBINING_TREMOLO_1	0x1D167
#define T_UTF_16_MUSICAL_SYMBOL_COMBINING_TREMOLO_2	0x1D168
#define T_UTF_16_MUSICAL_SYMBOL_COMBINING_TREMOLO_3	0x1D169
#define T_UTF_16_MUSICAL_SYMBOL_FINGERED_TREMOLO_1	0x1D16A
#define T_UTF_16_MUSICAL_SYMBOL_FINGERED_TREMOLO_2	0x1D16B
#define T_UTF_16_MUSICAL_SYMBOL_FINGERED_TREMOLO_3	0x1D16C
#define T_UTF_16_MUSICAL_SYMBOL_COMBINING_AUGMENTATION_DOT	0x1D16D
#define T_UTF_16_MUSICAL_SYMBOL_COMBINING_FLAG_1	0x1D16E
#define T_UTF_16_MUSICAL_SYMBOL_COMBINING_FLAG_2	0x1D16F
#define T_UTF_16_MUSICAL_SYMBOL_COMBINING_FLAG_3	0x1D170
#define T_UTF_16_MUSICAL_SYMBOL_COMBINING_FLAG_4	0x1D171
#define T_UTF_16_MUSICAL_SYMBOL_COMBINING_FLAG_5	0x1D172
#define T_UTF_16_MUSICAL_SYMBOL_BEGIN_BEAM	0x1D173
#define T_UTF_16_MUSICAL_SYMBOL_END_BEAM	0x1D174
#define T_UTF_16_MUSICAL_SYMBOL_BEGIN_TIE	0x1D175
#define T_UTF_16_MUSICAL_SYMBOL_END_TIE	0x1D176
#define T_UTF_16_MUSICAL_SYMBOL_BEGIN_SLUR	0x1D177
#define T_UTF_16_MUSICAL_SYMBOL_END_SLUR	0x1D178
#define T_UTF_16_MUSICAL_SYMBOL_BEGIN_PHRASE	0x1D179
#define T_UTF_16_MUSICAL_SYMBOL_END_PHRASE	0x1D17A
#define T_UTF_16_MUSICAL_SYMBOL_COMBINING_ACCENT	0x1D17B
#define T_UTF_16_MUSICAL_SYMBOL_COMBINING_STACCATO	0x1D17C
#define T_UTF_16_MUSICAL_SYMBOL_COMBINING_TENUTO	0x1D17D
#define T_UTF_16_MUSICAL_SYMBOL_COMBINING_STACCATISSIMO	0x1D17E
#define T_UTF_16_MUSICAL_SYMBOL_COMBINING_MARCATO	0x1D17F
#define T_UTF_16_MUSICAL_SYMBOL_COMBINING_MARCATO_STACCATO	0x1D180
#define T_UTF_16_MUSICAL_SYMBOL_COMBINING_ACCENT_STACCATO	0x1D181
#define T_UTF_16_MUSICAL_SYMBOL_COMBINING_LOURE	0x1D182
#define T_UTF_16_MUSICAL_SYMBOL_ARPEGGIATO_UP	0x1D183
#define T_UTF_16_MUSICAL_SYMBOL_ARPEGGIATO_DOWN	0x1D184
#define T_UTF_16_MUSICAL_SYMBOL_COMBINING_DOIT	0x1D185
#define T_UTF_16_MUSICAL_SYMBOL_COMBINING_RIP	0x1D186
#define T_UTF_16_MUSICAL_SYMBOL_COMBINING_FLIP	0x1D187
#define T_UTF_16_MUSICAL_SYMBOL_COMBINING_SMEAR	0x1D188
#define T_UTF_16_MUSICAL_SYMBOL_COMBINING_BEND	0x1D189
#define T_UTF_16_MUSICAL_SYMBOL_COMBINING_DOUBLE_TONGUE	0x1D18A
#define T_UTF_16_MUSICAL_SYMBOL_COMBINING_TRIPLE_TONGUE	0x1D18B
#define T_UTF_16_MUSICAL_SYMBOL_RINFORZANDO	0x1D18C
#define T_UTF_16_MUSICAL_SYMBOL_SUBITO	0x1D18D
#define T_UTF_16_MUSICAL_SYMBOL_Z	0x1D18E
#define T_UTF_16_MUSICAL_SYMBOL_PIANO	0x1D18F
#define T_UTF_16_MUSICAL_SYMBOL_MEZZO	0x1D190
#define T_UTF_16_MUSICAL_SYMBOL_FORTE	0x1D191
#define T_UTF_16_MUSICAL_SYMBOL_CRESCENDO	0x1D192
#define T_UTF_16_MUSICAL_SYMBOL_DECRESCENDO	0x1D193
#define T_UTF_16_MUSICAL_SYMBOL_GRACE_NOTE_SLASH	0x1D194
#define T_UTF_16_MUSICAL_SYMBOL_GRACE_NOTE_NO_SLASH	0x1D195
#define T_UTF_16_MUSICAL_SYMBOL_TR	0x1D196
#define T_UTF_16_MUSICAL_SYMBOL_TURN	0x1D197
#define T_UTF_16_MUSICAL_SYMBOL_INVERTED_TURN	0x1D198
#define T_UTF_16_MUSICAL_SYMBOL_TURN_SLASH	0x1D199
#define T_UTF_16_MUSICAL_SYMBOL_TURN_UP	0x1D19A
#define T_UTF_16_MUSICAL_SYMBOL_ORNAMENT_STROKE_1	0x1D19B
#define T_UTF_16_MUSICAL_SYMBOL_ORNAMENT_STROKE_2	0x1D19C
#define T_UTF_16_MUSICAL_SYMBOL_ORNAMENT_STROKE_3	0x1D19D
#define T_UTF_16_MUSICAL_SYMBOL_ORNAMENT_STROKE_4	0x1D19E
#define T_UTF_16_MUSICAL_SYMBOL_ORNAMENT_STROKE_5	0x1D19F
#define T_UTF_16_MUSICAL_SYMBOL_ORNAMENT_STROKE_6	0x1D1A0
#define T_UTF_16_MUSICAL_SYMBOL_ORNAMENT_STROKE_7	0x1D1A1
#define T_UTF_16_MUSICAL_SYMBOL_ORNAMENT_STROKE_8	0x1D1A2
#define T_UTF_16_MUSICAL_SYMBOL_ORNAMENT_STROKE_9	0x1D1A3
#define T_UTF_16_MUSICAL_SYMBOL_ORNAMENT_STROKE_10	0x1D1A4
#define T_UTF_16_MUSICAL_SYMBOL_ORNAMENT_STROKE_11	0x1D1A5
#define T_UTF_16_MUSICAL_SYMBOL_HAUPTSTIMME	0x1D1A6
#define T_UTF_16_MUSICAL_SYMBOL_NEBENSTIMME	0x1D1A7
#define T_UTF_16_MUSICAL_SYMBOL_END_OF_STIMME	0x1D1A8
#define T_UTF_16_MUSICAL_SYMBOL_DEGREE_SLASH	0x1D1A9
#define T_UTF_16_MUSICAL_SYMBOL_COMBINING_DOWN_BOW	0x1D1AA
#define T_UTF_16_MUSICAL_SYMBOL_COMBINING_UP_BOW	0x1D1AB
#define T_UTF_16_MUSICAL_SYMBOL_COMBINING_HARMONIC	0x1D1AC
#define T_UTF_16_MUSICAL_SYMBOL_COMBINING_SNAP_PIZZICATO	0x1D1AD
#define T_UTF_16_MUSICAL_SYMBOL_PEDAL_MARK	0x1D1AE
#define T_UTF_16_MUSICAL_SYMBOL_PEDAL_UP_MARK	0x1D1AF
#define T_UTF_16_MUSICAL_SYMBOL_HALF_PEDAL_MARK	0x1D1B0
#define T_UTF_16_MUSICAL_SYMBOL_GLISSANDO_UP	0x1D1B1
#define T_UTF_16_MUSICAL_SYMBOL_GLISSANDO_DOWN	0x1D1B2
#define T_UTF_16_MUSICAL_SYMBOL_WITH_FINGERNAILS	0x1D1B3
#define T_UTF_16_MUSICAL_SYMBOL_DAMP	0x1D1B4
#define T_UTF_16_MUSICAL_SYMBOL_DAMP_ALL	0x1D1B5
#define T_UTF_16_MUSICAL_SYMBOL_MAXIMA	0x1D1B6
#define T_UTF_16_MUSICAL_SYMBOL_LONGA	0x1D1B7
#define T_UTF_16_MUSICAL_SYMBOL_BREVIS	0x1D1B8
#define T_UTF_16_MUSICAL_SYMBOL_SEMIBREVIS_WHITE	0x1D1B9
#define T_UTF_16_MUSICAL_SYMBOL_SEMIBREVIS_BLACK	0x1D1BA
#define T_UTF_16_MUSICAL_SYMBOL_MINIMA	0x1D1BB
#define T_UTF_16_MUSICAL_SYMBOL_MINIMA_BLACK	0x1D1BC
#define T_UTF_16_MUSICAL_SYMBOL_SEMIMINIMA_WHITE	0x1D1BD
#define T_UTF_16_MUSICAL_SYMBOL_SEMIMINIMA_BLACK	0x1D1BE
#define T_UTF_16_MUSICAL_SYMBOL_FUSA_WHITE	0x1D1BF
#define T_UTF_16_MUSICAL_SYMBOL_FUSA_BLACK	0x1D1C0
#define T_UTF_16_MUSICAL_SYMBOL_LONGA_PERFECTA_REST	0x1D1C1
#define T_UTF_16_MUSICAL_SYMBOL_LONGA_IMPERFECTA_REST	0x1D1C2
#define T_UTF_16_MUSICAL_SYMBOL_BREVIS_REST	0x1D1C3
#define T_UTF_16_MUSICAL_SYMBOL_SEMIBREVIS_REST	0x1D1C4
#define T_UTF_16_MUSICAL_SYMBOL_MINIMA_REST	0x1D1C5
#define T_UTF_16_MUSICAL_SYMBOL_SEMIMINIMA_REST	0x1D1C6
#define T_UTF_16_MUSICAL_SYMBOL_TEMPUS_PERFECTUM_CUM_PROLATIONE_PERFECTA	0x1D1C7
#define T_UTF_16_MUSICAL_SYMBOL_TEMPUS_PERFECTUM_CUM_PROLATIONE_IMPERFECTA	0x1D1C8
#define T_UTF_16_MUSICAL_SYMBOL_TEMPUS_PERFECTUM_CUM_PROLATIONE_PERFECTA_DIMINUTION_1	0x1D1C9
#define T_UTF_16_MUSICAL_SYMBOL_TEMPUS_IMPERFECTUM_CUM_PROLATIONE_PERFECTA	0x1D1CA
#define T_UTF_16_MUSICAL_SYMBOL_TEMPUS_IMPERFECTUM_CUM_PROLATIONE_IMPERFECTA	0x1D1CB
#define T_UTF_16_MUSICAL_SYMBOL_TEMPUS_IMPERFECTUM_CUM_PROLATIONE_IMPERFECTA_DIMINUTION_1	0x1D1CC
#define T_UTF_16_MUSICAL_SYMBOL_TEMPUS_IMPERFECTUM_CUM_PROLATIONE_IMPERFECTA_DIMINUTION_2	0x1D1CD
#define T_UTF_16_MUSICAL_SYMBOL_TEMPUS_IMPERFECTUM_CUM_PROLATIONE_IMPERFECTA_DIMINUTION_3	0x1D1CE
#define T_UTF_16_MUSICAL_SYMBOL_CROIX	0x1D1CF
#define T_UTF_16_MUSICAL_SYMBOL_GREGORIAN_C_CLEF	0x1D1D0
#define T_UTF_16_MUSICAL_SYMBOL_GREGORIAN_F_CLEF	0x1D1D1
#define T_UTF_16_MUSICAL_SYMBOL_SQUARE_B	0x1D1D2
#define T_UTF_16_MUSICAL_SYMBOL_VIRGA	0x1D1D3
#define T_UTF_16_MUSICAL_SYMBOL_PODATUS	0x1D1D4
#define T_UTF_16_MUSICAL_SYMBOL_CLIVIS	0x1D1D5
#define T_UTF_16_MUSICAL_SYMBOL_SCANDICUS	0x1D1D6
#define T_UTF_16_MUSICAL_SYMBOL_CLIMACUS	0x1D1D7
#define T_UTF_16_MUSICAL_SYMBOL_TORCULUS	0x1D1D8
#define T_UTF_16_MUSICAL_SYMBOL_PORRECTUS	0x1D1D9
#define T_UTF_16_MUSICAL_SYMBOL_PORRECTUS_FLEXUS	0x1D1DA
#define T_UTF_16_MUSICAL_SYMBOL_SCANDICUS_FLEXUS	0x1D1DB
#define T_UTF_16_MUSICAL_SYMBOL_TORCULUS_RESUPINUS	0x1D1DC
#define T_UTF_16_MUSICAL_SYMBOL_PES_SUBPUNCTIS	0x1D1DD
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_A	0x1D400
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_B	0x1D401
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_C	0x1D402
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_D	0x1D403
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_E	0x1D404
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_F	0x1D405
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_G	0x1D406
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_H	0x1D407
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_I	0x1D408
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_J	0x1D409
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_K	0x1D40A
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_L	0x1D40B
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_M	0x1D40C
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_N	0x1D40D
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_O	0x1D40E
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_P	0x1D40F
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_Q	0x1D410
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_R	0x1D411
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_S	0x1D412
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_T	0x1D413
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_U	0x1D414
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_V	0x1D415
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_W	0x1D416
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_X	0x1D417
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_Y	0x1D418
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_Z	0x1D419
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_A	0x1D41A
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_B	0x1D41B
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_C	0x1D41C
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_D	0x1D41D
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_E	0x1D41E
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_F	0x1D41F
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_G	0x1D420
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_H	0x1D421
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_I	0x1D422
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_J	0x1D423
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_K	0x1D424
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_L	0x1D425
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_M	0x1D426
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_N	0x1D427
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_O	0x1D428
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_P	0x1D429
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_Q	0x1D42A
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_R	0x1D42B
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_S	0x1D42C
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_T	0x1D42D
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_U	0x1D42E
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_V	0x1D42F
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_W	0x1D430
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_X	0x1D431
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_Y	0x1D432
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_Z	0x1D433
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_A	0x1D434
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_B	0x1D435
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_C	0x1D436
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_D	0x1D437
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_E	0x1D438
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_F	0x1D439
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_G	0x1D43A
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_H	0x1D43B
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_I	0x1D43C
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_J	0x1D43D
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_K	0x1D43E
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_L	0x1D43F
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_M	0x1D440
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_N	0x1D441
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_O	0x1D442
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_P	0x1D443
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_Q	0x1D444
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_R	0x1D445
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_S	0x1D446
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_T	0x1D447
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_U	0x1D448
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_V	0x1D449
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_W	0x1D44A
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_X	0x1D44B
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_Y	0x1D44C
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_Z	0x1D44D
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_A	0x1D44E
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_B	0x1D44F
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_C	0x1D450
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_D	0x1D451
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_E	0x1D452
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_F	0x1D453
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_G	0x1D454
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_I	0x1D456
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_J	0x1D457
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_K	0x1D458
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_L	0x1D459
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_M	0x1D45A
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_N	0x1D45B
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_O	0x1D45C
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_P	0x1D45D
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_Q	0x1D45E
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_R	0x1D45F
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_S	0x1D460
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_T	0x1D461
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_U	0x1D462
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_V	0x1D463
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_W	0x1D464
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_X	0x1D465
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_Y	0x1D466
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_Z	0x1D467
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_A	0x1D468
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_B	0x1D469
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_C	0x1D46A
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_D	0x1D46B
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_E	0x1D46C
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_F	0x1D46D
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_G	0x1D46E
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_H	0x1D46F
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_I	0x1D470
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_J	0x1D471
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_K	0x1D472
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_L	0x1D473
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_M	0x1D474
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_N	0x1D475
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_O	0x1D476
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_P	0x1D477
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_Q	0x1D478
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_R	0x1D479
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_S	0x1D47A
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_T	0x1D47B
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_U	0x1D47C
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_V	0x1D47D
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_W	0x1D47E
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_X	0x1D47F
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_Y	0x1D480
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_Z	0x1D481
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_A	0x1D482
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_B	0x1D483
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_C	0x1D484
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_D	0x1D485
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_E	0x1D486
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_F	0x1D487
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_G	0x1D488
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_H	0x1D489
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_I	0x1D48A
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_J	0x1D48B
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_K	0x1D48C
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_L	0x1D48D
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_M	0x1D48E
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_N	0x1D48F
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_O	0x1D490
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_P	0x1D491
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_Q	0x1D492
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_R	0x1D493
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_S	0x1D494
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_T	0x1D495
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_U	0x1D496
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_V	0x1D497
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_W	0x1D498
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_X	0x1D499
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_Y	0x1D49A
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_Z	0x1D49B
#define T_UTF_16_MATHEMATICAL_SCRIPT_CAPITAL_A	0x1D49C
#define T_UTF_16_MATHEMATICAL_SCRIPT_CAPITAL_C	0x1D49E
#define T_UTF_16_MATHEMATICAL_SCRIPT_CAPITAL_D	0x1D49F
#define T_UTF_16_MATHEMATICAL_SCRIPT_CAPITAL_G	0x1D4A2
#define T_UTF_16_MATHEMATICAL_SCRIPT_CAPITAL_J	0x1D4A5
#define T_UTF_16_MATHEMATICAL_SCRIPT_CAPITAL_K	0x1D4A6
#define T_UTF_16_MATHEMATICAL_SCRIPT_CAPITAL_N	0x1D4A9
#define T_UTF_16_MATHEMATICAL_SCRIPT_CAPITAL_O	0x1D4AA
#define T_UTF_16_MATHEMATICAL_SCRIPT_CAPITAL_P	0x1D4AB
#define T_UTF_16_MATHEMATICAL_SCRIPT_CAPITAL_Q	0x1D4AC
#define T_UTF_16_MATHEMATICAL_SCRIPT_CAPITAL_S	0x1D4AE
#define T_UTF_16_MATHEMATICAL_SCRIPT_CAPITAL_T	0x1D4AF
#define T_UTF_16_MATHEMATICAL_SCRIPT_CAPITAL_U	0x1D4B0
#define T_UTF_16_MATHEMATICAL_SCRIPT_CAPITAL_V	0x1D4B1
#define T_UTF_16_MATHEMATICAL_SCRIPT_CAPITAL_W	0x1D4B2
#define T_UTF_16_MATHEMATICAL_SCRIPT_CAPITAL_X	0x1D4B3
#define T_UTF_16_MATHEMATICAL_SCRIPT_CAPITAL_Y	0x1D4B4
#define T_UTF_16_MATHEMATICAL_SCRIPT_CAPITAL_Z	0x1D4B5
#define T_UTF_16_MATHEMATICAL_SCRIPT_SMALL_A	0x1D4B6
#define T_UTF_16_MATHEMATICAL_SCRIPT_SMALL_B	0x1D4B7
#define T_UTF_16_MATHEMATICAL_SCRIPT_SMALL_C	0x1D4B8
#define T_UTF_16_MATHEMATICAL_SCRIPT_SMALL_D	0x1D4B9
#define T_UTF_16_MATHEMATICAL_SCRIPT_SMALL_F	0x1D4BB
#define T_UTF_16_MATHEMATICAL_SCRIPT_SMALL_H	0x1D4BD
#define T_UTF_16_MATHEMATICAL_SCRIPT_SMALL_I	0x1D4BE
#define T_UTF_16_MATHEMATICAL_SCRIPT_SMALL_J	0x1D4BF
#define T_UTF_16_MATHEMATICAL_SCRIPT_SMALL_K	0x1D4C0
#define T_UTF_16_MATHEMATICAL_SCRIPT_SMALL_M	0x1D4C2
#define T_UTF_16_MATHEMATICAL_SCRIPT_SMALL_N	0x1D4C3
#define T_UTF_16_MATHEMATICAL_SCRIPT_SMALL_P	0x1D4C5
#define T_UTF_16_MATHEMATICAL_SCRIPT_SMALL_Q	0x1D4C6
#define T_UTF_16_MATHEMATICAL_SCRIPT_SMALL_R	0x1D4C7
#define T_UTF_16_MATHEMATICAL_SCRIPT_SMALL_S	0x1D4C8
#define T_UTF_16_MATHEMATICAL_SCRIPT_SMALL_T	0x1D4C9
#define T_UTF_16_MATHEMATICAL_SCRIPT_SMALL_U	0x1D4CA
#define T_UTF_16_MATHEMATICAL_SCRIPT_SMALL_V	0x1D4CB
#define T_UTF_16_MATHEMATICAL_SCRIPT_SMALL_W	0x1D4CC
#define T_UTF_16_MATHEMATICAL_SCRIPT_SMALL_X	0x1D4CD
#define T_UTF_16_MATHEMATICAL_SCRIPT_SMALL_Y	0x1D4CE
#define T_UTF_16_MATHEMATICAL_SCRIPT_SMALL_Z	0x1D4CF
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_CAPITAL_A	0x1D4D0
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_CAPITAL_B	0x1D4D1
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_CAPITAL_C	0x1D4D2
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_CAPITAL_D	0x1D4D3
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_CAPITAL_E	0x1D4D4
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_CAPITAL_F	0x1D4D5
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_CAPITAL_G	0x1D4D6
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_CAPITAL_H	0x1D4D7
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_CAPITAL_I	0x1D4D8
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_CAPITAL_J	0x1D4D9
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_CAPITAL_K	0x1D4DA
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_CAPITAL_L	0x1D4DB
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_CAPITAL_M	0x1D4DC
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_CAPITAL_N	0x1D4DD
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_CAPITAL_O	0x1D4DE
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_CAPITAL_P	0x1D4DF
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_CAPITAL_Q	0x1D4E0
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_CAPITAL_R	0x1D4E1
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_CAPITAL_S	0x1D4E2
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_CAPITAL_T	0x1D4E3
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_CAPITAL_U	0x1D4E4
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_CAPITAL_V	0x1D4E5
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_CAPITAL_W	0x1D4E6
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_CAPITAL_X	0x1D4E7
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_CAPITAL_Y	0x1D4E8
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_CAPITAL_Z	0x1D4E9
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_SMALL_A	0x1D4EA
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_SMALL_B	0x1D4EB
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_SMALL_C	0x1D4EC
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_SMALL_D	0x1D4ED
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_SMALL_E	0x1D4EE
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_SMALL_F	0x1D4EF
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_SMALL_G	0x1D4F0
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_SMALL_H	0x1D4F1
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_SMALL_I	0x1D4F2
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_SMALL_J	0x1D4F3
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_SMALL_K	0x1D4F4
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_SMALL_L	0x1D4F5
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_SMALL_M	0x1D4F6
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_SMALL_N	0x1D4F7
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_SMALL_O	0x1D4F8
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_SMALL_P	0x1D4F9
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_SMALL_Q	0x1D4FA
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_SMALL_R	0x1D4FB
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_SMALL_S	0x1D4FC
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_SMALL_T	0x1D4FD
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_SMALL_U	0x1D4FE
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_SMALL_V	0x1D4FF
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_SMALL_W	0x1D500
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_SMALL_X	0x1D501
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_SMALL_Y	0x1D502
#define T_UTF_16_MATHEMATICAL_BOLD_SCRIPT_SMALL_Z	0x1D503
#define T_UTF_16_MATHEMATICAL_FRAKTUR_CAPITAL_A	0x1D504
#define T_UTF_16_MATHEMATICAL_FRAKTUR_CAPITAL_B	0x1D505
#define T_UTF_16_MATHEMATICAL_FRAKTUR_CAPITAL_D	0x1D507
#define T_UTF_16_MATHEMATICAL_FRAKTUR_CAPITAL_E	0x1D508
#define T_UTF_16_MATHEMATICAL_FRAKTUR_CAPITAL_F	0x1D509
#define T_UTF_16_MATHEMATICAL_FRAKTUR_CAPITAL_G	0x1D50A
#define T_UTF_16_MATHEMATICAL_FRAKTUR_CAPITAL_J	0x1D50D
#define T_UTF_16_MATHEMATICAL_FRAKTUR_CAPITAL_K	0x1D50E
#define T_UTF_16_MATHEMATICAL_FRAKTUR_CAPITAL_L	0x1D50F
#define T_UTF_16_MATHEMATICAL_FRAKTUR_CAPITAL_M	0x1D510
#define T_UTF_16_MATHEMATICAL_FRAKTUR_CAPITAL_N	0x1D511
#define T_UTF_16_MATHEMATICAL_FRAKTUR_CAPITAL_O	0x1D512
#define T_UTF_16_MATHEMATICAL_FRAKTUR_CAPITAL_P	0x1D513
#define T_UTF_16_MATHEMATICAL_FRAKTUR_CAPITAL_Q	0x1D514
#define T_UTF_16_MATHEMATICAL_FRAKTUR_CAPITAL_S	0x1D516
#define T_UTF_16_MATHEMATICAL_FRAKTUR_CAPITAL_T	0x1D517
#define T_UTF_16_MATHEMATICAL_FRAKTUR_CAPITAL_U	0x1D518
#define T_UTF_16_MATHEMATICAL_FRAKTUR_CAPITAL_V	0x1D519
#define T_UTF_16_MATHEMATICAL_FRAKTUR_CAPITAL_W	0x1D51A
#define T_UTF_16_MATHEMATICAL_FRAKTUR_CAPITAL_X	0x1D51B
#define T_UTF_16_MATHEMATICAL_FRAKTUR_CAPITAL_Y	0x1D51C
#define T_UTF_16_MATHEMATICAL_FRAKTUR_SMALL_A	0x1D51E
#define T_UTF_16_MATHEMATICAL_FRAKTUR_SMALL_B	0x1D51F
#define T_UTF_16_MATHEMATICAL_FRAKTUR_SMALL_C	0x1D520
#define T_UTF_16_MATHEMATICAL_FRAKTUR_SMALL_D	0x1D521
#define T_UTF_16_MATHEMATICAL_FRAKTUR_SMALL_E	0x1D522
#define T_UTF_16_MATHEMATICAL_FRAKTUR_SMALL_F	0x1D523
#define T_UTF_16_MATHEMATICAL_FRAKTUR_SMALL_G	0x1D524
#define T_UTF_16_MATHEMATICAL_FRAKTUR_SMALL_H	0x1D525
#define T_UTF_16_MATHEMATICAL_FRAKTUR_SMALL_I	0x1D526
#define T_UTF_16_MATHEMATICAL_FRAKTUR_SMALL_J	0x1D527
#define T_UTF_16_MATHEMATICAL_FRAKTUR_SMALL_K	0x1D528
#define T_UTF_16_MATHEMATICAL_FRAKTUR_SMALL_L	0x1D529
#define T_UTF_16_MATHEMATICAL_FRAKTUR_SMALL_M	0x1D52A
#define T_UTF_16_MATHEMATICAL_FRAKTUR_SMALL_N	0x1D52B
#define T_UTF_16_MATHEMATICAL_FRAKTUR_SMALL_O	0x1D52C
#define T_UTF_16_MATHEMATICAL_FRAKTUR_SMALL_P	0x1D52D
#define T_UTF_16_MATHEMATICAL_FRAKTUR_SMALL_Q	0x1D52E
#define T_UTF_16_MATHEMATICAL_FRAKTUR_SMALL_R	0x1D52F
#define T_UTF_16_MATHEMATICAL_FRAKTUR_SMALL_S	0x1D530
#define T_UTF_16_MATHEMATICAL_FRAKTUR_SMALL_T	0x1D531
#define T_UTF_16_MATHEMATICAL_FRAKTUR_SMALL_U	0x1D532
#define T_UTF_16_MATHEMATICAL_FRAKTUR_SMALL_V	0x1D533
#define T_UTF_16_MATHEMATICAL_FRAKTUR_SMALL_W	0x1D534
#define T_UTF_16_MATHEMATICAL_FRAKTUR_SMALL_X	0x1D535
#define T_UTF_16_MATHEMATICAL_FRAKTUR_SMALL_Y	0x1D536
#define T_UTF_16_MATHEMATICAL_FRAKTUR_SMALL_Z	0x1D537
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_CAPITAL_A	0x1D538
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_CAPITAL_B	0x1D539
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_CAPITAL_D	0x1D53B
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_CAPITAL_E	0x1D53C
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_CAPITAL_F	0x1D53D
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_CAPITAL_G	0x1D53E
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_CAPITAL_I	0x1D540
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_CAPITAL_J	0x1D541
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_CAPITAL_K	0x1D542
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_CAPITAL_L	0x1D543
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_CAPITAL_M	0x1D544
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_CAPITAL_O	0x1D546
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_CAPITAL_S	0x1D54A
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_CAPITAL_T	0x1D54B
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_CAPITAL_U	0x1D54C
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_CAPITAL_V	0x1D54D
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_CAPITAL_W	0x1D54E
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_CAPITAL_X	0x1D54F
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_CAPITAL_Y	0x1D550
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_SMALL_A	0x1D552
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_SMALL_B	0x1D553
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_SMALL_C	0x1D554
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_SMALL_D	0x1D555
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_SMALL_E	0x1D556
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_SMALL_F	0x1D557
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_SMALL_G	0x1D558
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_SMALL_H	0x1D559
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_SMALL_I	0x1D55A
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_SMALL_J	0x1D55B
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_SMALL_K	0x1D55C
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_SMALL_L	0x1D55D
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_SMALL_M	0x1D55E
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_SMALL_N	0x1D55F
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_SMALL_O	0x1D560
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_SMALL_P	0x1D561
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_SMALL_Q	0x1D562
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_SMALL_R	0x1D563
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_SMALL_S	0x1D564
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_SMALL_T	0x1D565
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_SMALL_U	0x1D566
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_SMALL_V	0x1D567
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_SMALL_W	0x1D568
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_SMALL_X	0x1D569
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_SMALL_Y	0x1D56A
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_SMALL_Z	0x1D56B
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_CAPITAL_A	0x1D56C
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_CAPITAL_B	0x1D56D
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_CAPITAL_C	0x1D56E
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_CAPITAL_D	0x1D56F
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_CAPITAL_E	0x1D570
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_CAPITAL_F	0x1D571
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_CAPITAL_G	0x1D572
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_CAPITAL_H	0x1D573
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_CAPITAL_I	0x1D574
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_CAPITAL_J	0x1D575
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_CAPITAL_K	0x1D576
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_CAPITAL_L	0x1D577
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_CAPITAL_M	0x1D578
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_CAPITAL_N	0x1D579
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_CAPITAL_O	0x1D57A
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_CAPITAL_P	0x1D57B
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_CAPITAL_Q	0x1D57C
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_CAPITAL_R	0x1D57D
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_CAPITAL_S	0x1D57E
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_CAPITAL_T	0x1D57F
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_CAPITAL_U	0x1D580
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_CAPITAL_V	0x1D581
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_CAPITAL_W	0x1D582
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_CAPITAL_X	0x1D583
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_CAPITAL_Y	0x1D584
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_CAPITAL_Z	0x1D585
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_SMALL_A	0x1D586
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_SMALL_B	0x1D587
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_SMALL_C	0x1D588
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_SMALL_D	0x1D589
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_SMALL_E	0x1D58A
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_SMALL_F	0x1D58B
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_SMALL_G	0x1D58C
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_SMALL_H	0x1D58D
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_SMALL_I	0x1D58E
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_SMALL_J	0x1D58F
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_SMALL_K	0x1D590
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_SMALL_L	0x1D591
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_SMALL_M	0x1D592
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_SMALL_N	0x1D593
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_SMALL_O	0x1D594
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_SMALL_P	0x1D595
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_SMALL_Q	0x1D596
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_SMALL_R	0x1D597
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_SMALL_S	0x1D598
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_SMALL_T	0x1D599
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_SMALL_U	0x1D59A
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_SMALL_V	0x1D59B
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_SMALL_W	0x1D59C
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_SMALL_X	0x1D59D
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_SMALL_Y	0x1D59E
#define T_UTF_16_MATHEMATICAL_BOLD_FRAKTUR_SMALL_Z	0x1D59F
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_CAPITAL_A	0x1D5A0
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_CAPITAL_B	0x1D5A1
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_CAPITAL_C	0x1D5A2
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_CAPITAL_D	0x1D5A3
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_CAPITAL_E	0x1D5A4
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_CAPITAL_F	0x1D5A5
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_CAPITAL_G	0x1D5A6
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_CAPITAL_H	0x1D5A7
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_CAPITAL_I	0x1D5A8
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_CAPITAL_J	0x1D5A9
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_CAPITAL_K	0x1D5AA
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_CAPITAL_L	0x1D5AB
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_CAPITAL_M	0x1D5AC
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_CAPITAL_N	0x1D5AD
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_CAPITAL_O	0x1D5AE
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_CAPITAL_P	0x1D5AF
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_CAPITAL_Q	0x1D5B0
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_CAPITAL_R	0x1D5B1
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_CAPITAL_S	0x1D5B2
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_CAPITAL_T	0x1D5B3
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_CAPITAL_U	0x1D5B4
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_CAPITAL_V	0x1D5B5
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_CAPITAL_W	0x1D5B6
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_CAPITAL_X	0x1D5B7
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_CAPITAL_Y	0x1D5B8
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_CAPITAL_Z	0x1D5B9
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_SMALL_A	0x1D5BA
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_SMALL_B	0x1D5BB
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_SMALL_C	0x1D5BC
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_SMALL_D	0x1D5BD
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_SMALL_E	0x1D5BE
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_SMALL_F	0x1D5BF
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_SMALL_G	0x1D5C0
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_SMALL_H	0x1D5C1
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_SMALL_I	0x1D5C2
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_SMALL_J	0x1D5C3
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_SMALL_K	0x1D5C4
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_SMALL_L	0x1D5C5
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_SMALL_M	0x1D5C6
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_SMALL_N	0x1D5C7
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_SMALL_O	0x1D5C8
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_SMALL_P	0x1D5C9
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_SMALL_Q	0x1D5CA
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_SMALL_R	0x1D5CB
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_SMALL_S	0x1D5CC
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_SMALL_T	0x1D5CD
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_SMALL_U	0x1D5CE
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_SMALL_V	0x1D5CF
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_SMALL_W	0x1D5D0
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_SMALL_X	0x1D5D1
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_SMALL_Y	0x1D5D2
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_SMALL_Z	0x1D5D3
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_A	0x1D5D4
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_B	0x1D5D5
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_C	0x1D5D6
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_D	0x1D5D7
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_E	0x1D5D8
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_F	0x1D5D9
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_G	0x1D5DA
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_H	0x1D5DB
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_I	0x1D5DC
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_J	0x1D5DD
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_K	0x1D5DE
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_L	0x1D5DF
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_M	0x1D5E0
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_N	0x1D5E1
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_O	0x1D5E2
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_P	0x1D5E3
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_Q	0x1D5E4
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_R	0x1D5E5
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_S	0x1D5E6
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_T	0x1D5E7
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_U	0x1D5E8
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_V	0x1D5E9
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_W	0x1D5EA
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_X	0x1D5EB
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_Y	0x1D5EC
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_Z	0x1D5ED
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_A	0x1D5EE
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_B	0x1D5EF
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_C	0x1D5F0
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_D	0x1D5F1
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_E	0x1D5F2
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_F	0x1D5F3
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_G	0x1D5F4
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_H	0x1D5F5
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_I	0x1D5F6
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_J	0x1D5F7
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_K	0x1D5F8
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_L	0x1D5F9
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_M	0x1D5FA
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_N	0x1D5FB
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_O	0x1D5FC
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_P	0x1D5FD
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_Q	0x1D5FE
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_R	0x1D5FF
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_S	0x1D600
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_T	0x1D601
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_U	0x1D602
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_V	0x1D603
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_W	0x1D604
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_X	0x1D605
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_Y	0x1D606
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_Z	0x1D607
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_CAPITAL_A	0x1D608
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_CAPITAL_B	0x1D609
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_CAPITAL_C	0x1D60A
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_CAPITAL_D	0x1D60B
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_CAPITAL_E	0x1D60C
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_CAPITAL_F	0x1D60D
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_CAPITAL_G	0x1D60E
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_CAPITAL_H	0x1D60F
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_CAPITAL_I	0x1D610
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_CAPITAL_J	0x1D611
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_CAPITAL_K	0x1D612
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_CAPITAL_L	0x1D613
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_CAPITAL_M	0x1D614
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_CAPITAL_N	0x1D615
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_CAPITAL_O	0x1D616
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_CAPITAL_P	0x1D617
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_CAPITAL_Q	0x1D618
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_CAPITAL_R	0x1D619
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_CAPITAL_S	0x1D61A
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_CAPITAL_T	0x1D61B
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_CAPITAL_U	0x1D61C
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_CAPITAL_V	0x1D61D
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_CAPITAL_W	0x1D61E
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_CAPITAL_X	0x1D61F
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_CAPITAL_Y	0x1D620
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_CAPITAL_Z	0x1D621
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_SMALL_A	0x1D622
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_SMALL_B	0x1D623
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_SMALL_C	0x1D624
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_SMALL_D	0x1D625
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_SMALL_E	0x1D626
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_SMALL_F	0x1D627
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_SMALL_G	0x1D628
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_SMALL_H	0x1D629
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_SMALL_I	0x1D62A
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_SMALL_J	0x1D62B
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_SMALL_K	0x1D62C
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_SMALL_L	0x1D62D
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_SMALL_M	0x1D62E
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_SMALL_N	0x1D62F
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_SMALL_O	0x1D630
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_SMALL_P	0x1D631
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_SMALL_Q	0x1D632
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_SMALL_R	0x1D633
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_SMALL_S	0x1D634
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_SMALL_T	0x1D635
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_SMALL_U	0x1D636
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_SMALL_V	0x1D637
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_SMALL_W	0x1D638
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_SMALL_X	0x1D639
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_SMALL_Y	0x1D63A
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_ITALIC_SMALL_Z	0x1D63B
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_A	0x1D63C
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_B	0x1D63D
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_C	0x1D63E
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_D	0x1D63F
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_E	0x1D640
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_F	0x1D641
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_G	0x1D642
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_H	0x1D643
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_I	0x1D644
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_J	0x1D645
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_K	0x1D646
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_L	0x1D647
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_M	0x1D648
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_N	0x1D649
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_O	0x1D64A
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_P	0x1D64B
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_Q	0x1D64C
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_R	0x1D64D
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_S	0x1D64E
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_T	0x1D64F
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_U	0x1D650
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_V	0x1D651
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_W	0x1D652
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_X	0x1D653
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_Y	0x1D654
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_Z	0x1D655
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_A	0x1D656
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_B	0x1D657
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_C	0x1D658
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_D	0x1D659
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_E	0x1D65A
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_F	0x1D65B
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_G	0x1D65C
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_H	0x1D65D
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_I	0x1D65E
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_J	0x1D65F
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_K	0x1D660
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_L	0x1D661
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_M	0x1D662
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_N	0x1D663
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_O	0x1D664
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_P	0x1D665
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_Q	0x1D666
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_R	0x1D667
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_S	0x1D668
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_T	0x1D669
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_U	0x1D66A
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_V	0x1D66B
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_W	0x1D66C
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_X	0x1D66D
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_Y	0x1D66E
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_Z	0x1D66F
#define T_UTF_16_MATHEMATICAL_MONOSPACE_CAPITAL_A	0x1D670
#define T_UTF_16_MATHEMATICAL_MONOSPACE_CAPITAL_B	0x1D671
#define T_UTF_16_MATHEMATICAL_MONOSPACE_CAPITAL_C	0x1D672
#define T_UTF_16_MATHEMATICAL_MONOSPACE_CAPITAL_D	0x1D673
#define T_UTF_16_MATHEMATICAL_MONOSPACE_CAPITAL_E	0x1D674
#define T_UTF_16_MATHEMATICAL_MONOSPACE_CAPITAL_F	0x1D675
#define T_UTF_16_MATHEMATICAL_MONOSPACE_CAPITAL_G	0x1D676
#define T_UTF_16_MATHEMATICAL_MONOSPACE_CAPITAL_H	0x1D677
#define T_UTF_16_MATHEMATICAL_MONOSPACE_CAPITAL_I	0x1D678
#define T_UTF_16_MATHEMATICAL_MONOSPACE_CAPITAL_J	0x1D679
#define T_UTF_16_MATHEMATICAL_MONOSPACE_CAPITAL_K	0x1D67A
#define T_UTF_16_MATHEMATICAL_MONOSPACE_CAPITAL_L	0x1D67B
#define T_UTF_16_MATHEMATICAL_MONOSPACE_CAPITAL_M	0x1D67C
#define T_UTF_16_MATHEMATICAL_MONOSPACE_CAPITAL_N	0x1D67D
#define T_UTF_16_MATHEMATICAL_MONOSPACE_CAPITAL_O	0x1D67E
#define T_UTF_16_MATHEMATICAL_MONOSPACE_CAPITAL_P	0x1D67F
#define T_UTF_16_MATHEMATICAL_MONOSPACE_CAPITAL_Q	0x1D680
#define T_UTF_16_MATHEMATICAL_MONOSPACE_CAPITAL_R	0x1D681
#define T_UTF_16_MATHEMATICAL_MONOSPACE_CAPITAL_S	0x1D682
#define T_UTF_16_MATHEMATICAL_MONOSPACE_CAPITAL_T	0x1D683
#define T_UTF_16_MATHEMATICAL_MONOSPACE_CAPITAL_U	0x1D684
#define T_UTF_16_MATHEMATICAL_MONOSPACE_CAPITAL_V	0x1D685
#define T_UTF_16_MATHEMATICAL_MONOSPACE_CAPITAL_W	0x1D686
#define T_UTF_16_MATHEMATICAL_MONOSPACE_CAPITAL_X	0x1D687
#define T_UTF_16_MATHEMATICAL_MONOSPACE_CAPITAL_Y	0x1D688
#define T_UTF_16_MATHEMATICAL_MONOSPACE_CAPITAL_Z	0x1D689
#define T_UTF_16_MATHEMATICAL_MONOSPACE_SMALL_A	0x1D68A
#define T_UTF_16_MATHEMATICAL_MONOSPACE_SMALL_B	0x1D68B
#define T_UTF_16_MATHEMATICAL_MONOSPACE_SMALL_C	0x1D68C
#define T_UTF_16_MATHEMATICAL_MONOSPACE_SMALL_D	0x1D68D
#define T_UTF_16_MATHEMATICAL_MONOSPACE_SMALL_E	0x1D68E
#define T_UTF_16_MATHEMATICAL_MONOSPACE_SMALL_F	0x1D68F
#define T_UTF_16_MATHEMATICAL_MONOSPACE_SMALL_G	0x1D690
#define T_UTF_16_MATHEMATICAL_MONOSPACE_SMALL_H	0x1D691
#define T_UTF_16_MATHEMATICAL_MONOSPACE_SMALL_I	0x1D692
#define T_UTF_16_MATHEMATICAL_MONOSPACE_SMALL_J	0x1D693
#define T_UTF_16_MATHEMATICAL_MONOSPACE_SMALL_K	0x1D694
#define T_UTF_16_MATHEMATICAL_MONOSPACE_SMALL_L	0x1D695
#define T_UTF_16_MATHEMATICAL_MONOSPACE_SMALL_M	0x1D696
#define T_UTF_16_MATHEMATICAL_MONOSPACE_SMALL_N	0x1D697
#define T_UTF_16_MATHEMATICAL_MONOSPACE_SMALL_O	0x1D698
#define T_UTF_16_MATHEMATICAL_MONOSPACE_SMALL_P	0x1D699
#define T_UTF_16_MATHEMATICAL_MONOSPACE_SMALL_Q	0x1D69A
#define T_UTF_16_MATHEMATICAL_MONOSPACE_SMALL_R	0x1D69B
#define T_UTF_16_MATHEMATICAL_MONOSPACE_SMALL_S	0x1D69C
#define T_UTF_16_MATHEMATICAL_MONOSPACE_SMALL_T	0x1D69D
#define T_UTF_16_MATHEMATICAL_MONOSPACE_SMALL_U	0x1D69E
#define T_UTF_16_MATHEMATICAL_MONOSPACE_SMALL_V	0x1D69F
#define T_UTF_16_MATHEMATICAL_MONOSPACE_SMALL_W	0x1D6A0
#define T_UTF_16_MATHEMATICAL_MONOSPACE_SMALL_X	0x1D6A1
#define T_UTF_16_MATHEMATICAL_MONOSPACE_SMALL_Y	0x1D6A2
#define T_UTF_16_MATHEMATICAL_MONOSPACE_SMALL_Z	0x1D6A3
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_ALPHA	0x1D6A8
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_BETA	0x1D6A9
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_GAMMA	0x1D6AA
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_DELTA	0x1D6AB
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_EPSILON	0x1D6AC
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_ZETA	0x1D6AD
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_ETA	0x1D6AE
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_THETA	0x1D6AF
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_IOTA	0x1D6B0
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_KAPPA	0x1D6B1
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_LAMDA	0x1D6B2
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_MU	0x1D6B3
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_NU	0x1D6B4
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_XI	0x1D6B5
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_OMICRON	0x1D6B6
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_PI	0x1D6B7
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_RHO	0x1D6B8
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_THETA_SYMBOL	0x1D6B9
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_SIGMA	0x1D6BA
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_TAU	0x1D6BB
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_UPSILON	0x1D6BC
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_PHI	0x1D6BD
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_CHI	0x1D6BE
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_PSI	0x1D6BF
#define T_UTF_16_MATHEMATICAL_BOLD_CAPITAL_OMEGA	0x1D6C0
#define T_UTF_16_MATHEMATICAL_BOLD_NABLA	0x1D6C1
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_ALPHA	0x1D6C2
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_BETA	0x1D6C3
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_GAMMA	0x1D6C4
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_DELTA	0x1D6C5
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_EPSILON	0x1D6C6
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_ZETA	0x1D6C7
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_ETA	0x1D6C8
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_THETA	0x1D6C9
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_IOTA	0x1D6CA
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_KAPPA	0x1D6CB
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_LAMDA	0x1D6CC
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_MU	0x1D6CD
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_NU	0x1D6CE
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_XI	0x1D6CF
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_OMICRON	0x1D6D0
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_PI	0x1D6D1
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_RHO	0x1D6D2
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_FINAL_SIGMA	0x1D6D3
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_SIGMA	0x1D6D4
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_TAU	0x1D6D5
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_UPSILON	0x1D6D6
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_PHI	0x1D6D7
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_CHI	0x1D6D8
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_PSI	0x1D6D9
#define T_UTF_16_MATHEMATICAL_BOLD_SMALL_OMEGA	0x1D6DA
#define T_UTF_16_MATHEMATICAL_BOLD_PARTIAL_DIFFERENTIAL	0x1D6DB
#define T_UTF_16_MATHEMATICAL_BOLD_EPSILON_SYMBOL	0x1D6DC
#define T_UTF_16_MATHEMATICAL_BOLD_THETA_SYMBOL	0x1D6DD
#define T_UTF_16_MATHEMATICAL_BOLD_KAPPA_SYMBOL	0x1D6DE
#define T_UTF_16_MATHEMATICAL_BOLD_PHI_SYMBOL	0x1D6DF
#define T_UTF_16_MATHEMATICAL_BOLD_RHO_SYMBOL	0x1D6E0
#define T_UTF_16_MATHEMATICAL_BOLD_PI_SYMBOL	0x1D6E1
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_ALPHA	0x1D6E2
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_BETA	0x1D6E3
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_GAMMA	0x1D6E4
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_DELTA	0x1D6E5
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_EPSILON	0x1D6E6
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_ZETA	0x1D6E7
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_ETA	0x1D6E8
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_THETA	0x1D6E9
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_IOTA	0x1D6EA
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_KAPPA	0x1D6EB
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_LAMDA	0x1D6EC
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_MU	0x1D6ED
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_NU	0x1D6EE
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_XI	0x1D6EF
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_OMICRON	0x1D6F0
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_PI	0x1D6F1
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_RHO	0x1D6F2
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_THETA_SYMBOL	0x1D6F3
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_SIGMA	0x1D6F4
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_TAU	0x1D6F5
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_UPSILON	0x1D6F6
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_PHI	0x1D6F7
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_CHI	0x1D6F8
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_PSI	0x1D6F9
#define T_UTF_16_MATHEMATICAL_ITALIC_CAPITAL_OMEGA	0x1D6FA
#define T_UTF_16_MATHEMATICAL_ITALIC_NABLA	0x1D6FB
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_ALPHA	0x1D6FC
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_BETA	0x1D6FD
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_GAMMA	0x1D6FE
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_DELTA	0x1D6FF
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_EPSILON	0x1D700
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_ZETA	0x1D701
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_ETA	0x1D702
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_THETA	0x1D703
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_IOTA	0x1D704
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_KAPPA	0x1D705
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_LAMDA	0x1D706
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_MU	0x1D707
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_NU	0x1D708
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_XI	0x1D709
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_OMICRON	0x1D70A
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_PI	0x1D70B
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_RHO	0x1D70C
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_FINAL_SIGMA	0x1D70D
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_SIGMA	0x1D70E
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_TAU	0x1D70F
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_UPSILON	0x1D710
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_PHI	0x1D711
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_CHI	0x1D712
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_PSI	0x1D713
#define T_UTF_16_MATHEMATICAL_ITALIC_SMALL_OMEGA	0x1D714
#define T_UTF_16_MATHEMATICAL_ITALIC_PARTIAL_DIFFERENTIAL	0x1D715
#define T_UTF_16_MATHEMATICAL_ITALIC_EPSILON_SYMBOL	0x1D716
#define T_UTF_16_MATHEMATICAL_ITALIC_THETA_SYMBOL	0x1D717
#define T_UTF_16_MATHEMATICAL_ITALIC_KAPPA_SYMBOL	0x1D718
#define T_UTF_16_MATHEMATICAL_ITALIC_PHI_SYMBOL	0x1D719
#define T_UTF_16_MATHEMATICAL_ITALIC_RHO_SYMBOL	0x1D71A
#define T_UTF_16_MATHEMATICAL_ITALIC_PI_SYMBOL	0x1D71B
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_ALPHA	0x1D71C
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_BETA	0x1D71D
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_GAMMA	0x1D71E
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_DELTA	0x1D71F
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_EPSILON	0x1D720
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_ZETA	0x1D721
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_ETA	0x1D722
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_THETA	0x1D723
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_IOTA	0x1D724
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_KAPPA	0x1D725
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_LAMDA	0x1D726
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_MU	0x1D727
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_NU	0x1D728
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_XI	0x1D729
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_OMICRON	0x1D72A
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_PI	0x1D72B
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_RHO	0x1D72C
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_THETA_SYMBOL	0x1D72D
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_SIGMA	0x1D72E
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_TAU	0x1D72F
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_UPSILON	0x1D730
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_PHI	0x1D731
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_CHI	0x1D732
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_PSI	0x1D733
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_CAPITAL_OMEGA	0x1D734
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_NABLA	0x1D735
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_ALPHA	0x1D736
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_BETA	0x1D737
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_GAMMA	0x1D738
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_DELTA	0x1D739
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_EPSILON	0x1D73A
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_ZETA	0x1D73B
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_ETA	0x1D73C
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_THETA	0x1D73D
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_IOTA	0x1D73E
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_KAPPA	0x1D73F
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_LAMDA	0x1D740
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_MU	0x1D741
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_NU	0x1D742
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_XI	0x1D743
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_OMICRON	0x1D744
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_PI	0x1D745
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_RHO	0x1D746
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_FINAL_SIGMA	0x1D747
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_SIGMA	0x1D748
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_TAU	0x1D749
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_UPSILON	0x1D74A
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_PHI	0x1D74B
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_CHI	0x1D74C
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_PSI	0x1D74D
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_SMALL_OMEGA	0x1D74E
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_PARTIAL_DIFFERENTIAL	0x1D74F
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_EPSILON_SYMBOL	0x1D750
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_THETA_SYMBOL	0x1D751
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_KAPPA_SYMBOL	0x1D752
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_PHI_SYMBOL	0x1D753
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_RHO_SYMBOL	0x1D754
#define T_UTF_16_MATHEMATICAL_BOLD_ITALIC_PI_SYMBOL	0x1D755
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_ALPHA	0x1D756
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_BETA	0x1D757
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_GAMMA	0x1D758
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_DELTA	0x1D759
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_EPSILON	0x1D75A
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_ZETA	0x1D75B
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_ETA	0x1D75C
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_THETA	0x1D75D
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_IOTA	0x1D75E
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_KAPPA	0x1D75F
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_LAMDA	0x1D760
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_MU	0x1D761
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_NU	0x1D762
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_XI	0x1D763
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_OMICRON	0x1D764
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_PI	0x1D765
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_RHO	0x1D766
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_THETA_SYMBOL	0x1D767
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_SIGMA	0x1D768
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_TAU	0x1D769
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_UPSILON	0x1D76A
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_PHI	0x1D76B
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_CHI	0x1D76C
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_PSI	0x1D76D
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_CAPITAL_OMEGA	0x1D76E
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_NABLA	0x1D76F
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_ALPHA	0x1D770
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_BETA	0x1D771
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_GAMMA	0x1D772
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_DELTA	0x1D773
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_EPSILON	0x1D774
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_ZETA	0x1D775
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_ETA	0x1D776
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_THETA	0x1D777
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_IOTA	0x1D778
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_KAPPA	0x1D779
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_LAMDA	0x1D77A
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_MU	0x1D77B
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_NU	0x1D77C
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_XI	0x1D77D
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_OMICRON	0x1D77E
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_PI	0x1D77F
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_RHO	0x1D780
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_FINAL_SIGMA	0x1D781
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_SIGMA	0x1D782
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_TAU	0x1D783
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_UPSILON	0x1D784
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_PHI	0x1D785
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_CHI	0x1D786
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_PSI	0x1D787
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_SMALL_OMEGA	0x1D788
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_PARTIAL_DIFFERENTIAL	0x1D789
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_EPSILON_SYMBOL	0x1D78A
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_THETA_SYMBOL	0x1D78B
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_KAPPA_SYMBOL	0x1D78C
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_PHI_SYMBOL	0x1D78D
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_RHO_SYMBOL	0x1D78E
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_PI_SYMBOL	0x1D78F
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_ALPHA	0x1D790
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_BETA	0x1D791
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_GAMMA	0x1D792
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_DELTA	0x1D793
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_EPSILON	0x1D794
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_ZETA	0x1D795
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_ETA	0x1D796
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_THETA	0x1D797
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_IOTA	0x1D798
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_KAPPA	0x1D799
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_LAMDA	0x1D79A
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_MU	0x1D79B
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_NU	0x1D79C
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_XI	0x1D79D
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_OMICRON	0x1D79E
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_PI	0x1D79F
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_RHO	0x1D7A0
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_THETA_SYMBOL	0x1D7A1
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_SIGMA	0x1D7A2
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_TAU	0x1D7A3
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_UPSILON	0x1D7A4
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_PHI	0x1D7A5
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_CHI	0x1D7A6
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_PSI	0x1D7A7
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_CAPITAL_OMEGA	0x1D7A8
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_NABLA	0x1D7A9
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_ALPHA	0x1D7AA
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_BETA	0x1D7AB
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_GAMMA	0x1D7AC
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_DELTA	0x1D7AD
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_EPSILON	0x1D7AE
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_ZETA	0x1D7AF
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_ETA	0x1D7B0
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_THETA	0x1D7B1
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_IOTA	0x1D7B2
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_KAPPA	0x1D7B3
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_LAMDA	0x1D7B4
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_MU	0x1D7B5
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_NU	0x1D7B6
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_XI	0x1D7B7
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_OMICRON	0x1D7B8
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_PI	0x1D7B9
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_RHO	0x1D7BA
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_FINAL_SIGMA	0x1D7BB
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_SIGMA	0x1D7BC
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_TAU	0x1D7BD
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_UPSILON	0x1D7BE
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_PHI	0x1D7BF
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_CHI	0x1D7C0
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_PSI	0x1D7C1
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_SMALL_OMEGA	0x1D7C2
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_PARTIAL_DIFFERENTIAL	0x1D7C3
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_EPSILON_SYMBOL	0x1D7C4
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_THETA_SYMBOL	0x1D7C5
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_KAPPA_SYMBOL	0x1D7C6
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_PHI_SYMBOL	0x1D7C7
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_RHO_SYMBOL	0x1D7C8
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_ITALIC_PI_SYMBOL	0x1D7C9
#define T_UTF_16_MATHEMATICAL_BOLD_DIGIT_ZERO	0x1D7CE
#define T_UTF_16_MATHEMATICAL_BOLD_DIGIT_ONE	0x1D7CF
#define T_UTF_16_MATHEMATICAL_BOLD_DIGIT_TWO	0x1D7D0
#define T_UTF_16_MATHEMATICAL_BOLD_DIGIT_THREE	0x1D7D1
#define T_UTF_16_MATHEMATICAL_BOLD_DIGIT_FOUR	0x1D7D2
#define T_UTF_16_MATHEMATICAL_BOLD_DIGIT_FIVE	0x1D7D3
#define T_UTF_16_MATHEMATICAL_BOLD_DIGIT_SIX	0x1D7D4
#define T_UTF_16_MATHEMATICAL_BOLD_DIGIT_SEVEN	0x1D7D5
#define T_UTF_16_MATHEMATICAL_BOLD_DIGIT_EIGHT	0x1D7D6
#define T_UTF_16_MATHEMATICAL_BOLD_DIGIT_NINE	0x1D7D7
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_DIGIT_ZERO	0x1D7D8
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_DIGIT_ONE	0x1D7D9
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_DIGIT_TWO	0x1D7DA
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_DIGIT_THREE	0x1D7DB
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_DIGIT_FOUR	0x1D7DC
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_DIGIT_FIVE	0x1D7DD
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_DIGIT_SIX	0x1D7DE
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_DIGIT_SEVEN	0x1D7DF
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_DIGIT_EIGHT	0x1D7E0
#define T_UTF_16_MATHEMATICAL_DOUBLE_STRUCK_DIGIT_NINE	0x1D7E1
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_DIGIT_ZERO	0x1D7E2
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_DIGIT_ONE	0x1D7E3
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_DIGIT_TWO	0x1D7E4
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_DIGIT_THREE	0x1D7E5
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_DIGIT_FOUR	0x1D7E6
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_DIGIT_FIVE	0x1D7E7
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_DIGIT_SIX	0x1D7E8
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_DIGIT_SEVEN	0x1D7E9
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_DIGIT_EIGHT	0x1D7EA
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_DIGIT_NINE	0x1D7EB
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_DIGIT_ZERO	0x1D7EC
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_DIGIT_ONE	0x1D7ED
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_DIGIT_TWO	0x1D7EE
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_DIGIT_THREE	0x1D7EF
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_DIGIT_FOUR	0x1D7F0
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_DIGIT_FIVE	0x1D7F1
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_DIGIT_SIX	0x1D7F2
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_DIGIT_SEVEN	0x1D7F3
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_DIGIT_EIGHT	0x1D7F4
#define T_UTF_16_MATHEMATICAL_SANS_SERIF_BOLD_DIGIT_NINE	0x1D7F5
#define T_UTF_16_MATHEMATICAL_MONOSPACE_DIGIT_ZERO	0x1D7F6
#define T_UTF_16_MATHEMATICAL_MONOSPACE_DIGIT_ONE	0x1D7F7
#define T_UTF_16_MATHEMATICAL_MONOSPACE_DIGIT_TWO	0x1D7F8
#define T_UTF_16_MATHEMATICAL_MONOSPACE_DIGIT_THREE	0x1D7F9
#define T_UTF_16_MATHEMATICAL_MONOSPACE_DIGIT_FOUR	0x1D7FA
#define T_UTF_16_MATHEMATICAL_MONOSPACE_DIGIT_FIVE	0x1D7FB
#define T_UTF_16_MATHEMATICAL_MONOSPACE_DIGIT_SIX	0x1D7FC
#define T_UTF_16_MATHEMATICAL_MONOSPACE_DIGIT_SEVEN	0x1D7FD
#define T_UTF_16_MATHEMATICAL_MONOSPACE_DIGIT_EIGHT	0x1D7FE
#define T_UTF_16_MATHEMATICAL_MONOSPACE_DIGIT_NINE	0x1D7FF
#define T_UTF_16_CJK_Ideograph_Extension_B_First	0x20000
#define T_UTF_16_CJK_Ideograph_Extension_B_Last	0x2A6D6
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F800	0x2F800
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F801	0x2F801
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F802	0x2F802
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F803	0x2F803
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F804	0x2F804
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F805	0x2F805
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F806	0x2F806
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F807	0x2F807
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F808	0x2F808
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F809	0x2F809
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F80A	0x2F80A
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F80B	0x2F80B
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F80C	0x2F80C
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F80D	0x2F80D
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F80E	0x2F80E
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F80F	0x2F80F
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F810	0x2F810
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F811	0x2F811
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F812	0x2F812
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F813	0x2F813
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F814	0x2F814
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F815	0x2F815
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F816	0x2F816
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F817	0x2F817
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F818	0x2F818
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F819	0x2F819
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F81A	0x2F81A
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F81B	0x2F81B
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F81C	0x2F81C
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F81D	0x2F81D
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F81E	0x2F81E
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F81F	0x2F81F
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F820	0x2F820
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F821	0x2F821
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F822	0x2F822
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F823	0x2F823
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F824	0x2F824
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F825	0x2F825
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F826	0x2F826
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F827	0x2F827
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F828	0x2F828
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F829	0x2F829
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F82A	0x2F82A
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F82B	0x2F82B
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F82C	0x2F82C
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F82D	0x2F82D
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F82E	0x2F82E
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F82F	0x2F82F
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F830	0x2F830
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F831	0x2F831
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F832	0x2F832
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F833	0x2F833
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F834	0x2F834
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F835	0x2F835
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F836	0x2F836
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F837	0x2F837
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F838	0x2F838
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F839	0x2F839
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F83A	0x2F83A
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F83B	0x2F83B
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F83C	0x2F83C
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F83D	0x2F83D
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F83E	0x2F83E
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F83F	0x2F83F
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F840	0x2F840
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F841	0x2F841
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F842	0x2F842
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F843	0x2F843
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F844	0x2F844
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F845	0x2F845
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F846	0x2F846
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F847	0x2F847
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F848	0x2F848
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F849	0x2F849
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F84A	0x2F84A
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F84B	0x2F84B
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F84C	0x2F84C
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F84D	0x2F84D
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F84E	0x2F84E
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F84F	0x2F84F
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F850	0x2F850
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F851	0x2F851
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F852	0x2F852
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F853	0x2F853
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F854	0x2F854
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F855	0x2F855
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F856	0x2F856
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F857	0x2F857
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F858	0x2F858
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F859	0x2F859
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F85A	0x2F85A
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F85B	0x2F85B
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F85C	0x2F85C
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F85D	0x2F85D
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F85E	0x2F85E
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F85F	0x2F85F
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F860	0x2F860
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F861	0x2F861
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F862	0x2F862
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F863	0x2F863
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F864	0x2F864
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F865	0x2F865
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F866	0x2F866
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F867	0x2F867
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F868	0x2F868
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F869	0x2F869
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F86A	0x2F86A
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F86B	0x2F86B
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F86C	0x2F86C
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F86D	0x2F86D
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F86E	0x2F86E
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F86F	0x2F86F
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F870	0x2F870
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F871	0x2F871
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F872	0x2F872
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F873	0x2F873
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F874	0x2F874
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F875	0x2F875
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F876	0x2F876
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F877	0x2F877
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F878	0x2F878
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F879	0x2F879
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F87A	0x2F87A
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F87B	0x2F87B
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F87C	0x2F87C
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F87D	0x2F87D
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F87E	0x2F87E
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F87F	0x2F87F
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F880	0x2F880
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F881	0x2F881
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F882	0x2F882
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F883	0x2F883
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F884	0x2F884
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F885	0x2F885
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F886	0x2F886
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F887	0x2F887
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F888	0x2F888
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F889	0x2F889
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F88A	0x2F88A
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F88B	0x2F88B
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F88C	0x2F88C
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F88D	0x2F88D
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F88E	0x2F88E
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F88F	0x2F88F
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F890	0x2F890
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F891	0x2F891
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F892	0x2F892
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F893	0x2F893
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F894	0x2F894
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F895	0x2F895
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F896	0x2F896
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F897	0x2F897
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F898	0x2F898
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F899	0x2F899
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F89A	0x2F89A
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F89B	0x2F89B
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F89C	0x2F89C
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F89D	0x2F89D
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F89E	0x2F89E
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F89F	0x2F89F
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8A0	0x2F8A0
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8A1	0x2F8A1
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8A2	0x2F8A2
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8A3	0x2F8A3
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8A4	0x2F8A4
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8A5	0x2F8A5
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8A6	0x2F8A6
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8A7	0x2F8A7
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8A8	0x2F8A8
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8A9	0x2F8A9
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8AA	0x2F8AA
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8AB	0x2F8AB
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8AC	0x2F8AC
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8AD	0x2F8AD
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8AE	0x2F8AE
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8AF	0x2F8AF
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8B0	0x2F8B0
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8B1	0x2F8B1
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8B2	0x2F8B2
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8B3	0x2F8B3
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8B4	0x2F8B4
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8B5	0x2F8B5
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8B6	0x2F8B6
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8B7	0x2F8B7
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8B8	0x2F8B8
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8B9	0x2F8B9
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8BA	0x2F8BA
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8BB	0x2F8BB
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8BC	0x2F8BC
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8BD	0x2F8BD
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8BE	0x2F8BE
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8BF	0x2F8BF
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8C0	0x2F8C0
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8C1	0x2F8C1
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8C2	0x2F8C2
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8C3	0x2F8C3
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8C4	0x2F8C4
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8C5	0x2F8C5
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8C6	0x2F8C6
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8C7	0x2F8C7
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8C8	0x2F8C8
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8C9	0x2F8C9
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8CA	0x2F8CA
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8CB	0x2F8CB
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8CC	0x2F8CC
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8CD	0x2F8CD
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8CE	0x2F8CE
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8CF	0x2F8CF
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8D0	0x2F8D0
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8D1	0x2F8D1
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8D2	0x2F8D2
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8D3	0x2F8D3
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8D4	0x2F8D4
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8D5	0x2F8D5
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8D6	0x2F8D6
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8D7	0x2F8D7
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8D8	0x2F8D8
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8D9	0x2F8D9
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8DA	0x2F8DA
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8DB	0x2F8DB
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8DC	0x2F8DC
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8DD	0x2F8DD
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8DE	0x2F8DE
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8DF	0x2F8DF
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8E0	0x2F8E0
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8E1	0x2F8E1
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8E2	0x2F8E2
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8E3	0x2F8E3
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8E4	0x2F8E4
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8E5	0x2F8E5
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8E6	0x2F8E6
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8E7	0x2F8E7
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8E8	0x2F8E8
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8E9	0x2F8E9
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8EA	0x2F8EA
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8EB	0x2F8EB
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8EC	0x2F8EC
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8ED	0x2F8ED
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8EE	0x2F8EE
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8EF	0x2F8EF
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8F0	0x2F8F0
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8F1	0x2F8F1
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8F2	0x2F8F2
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8F3	0x2F8F3
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8F4	0x2F8F4
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8F5	0x2F8F5
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8F6	0x2F8F6
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8F7	0x2F8F7
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8F8	0x2F8F8
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8F9	0x2F8F9
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8FA	0x2F8FA
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8FB	0x2F8FB
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8FC	0x2F8FC
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8FD	0x2F8FD
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8FE	0x2F8FE
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F8FF	0x2F8FF
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F900	0x2F900
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F901	0x2F901
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F902	0x2F902
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F903	0x2F903
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F904	0x2F904
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F905	0x2F905
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F906	0x2F906
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F907	0x2F907
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F908	0x2F908
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F909	0x2F909
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F90A	0x2F90A
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F90B	0x2F90B
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F90C	0x2F90C
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F90D	0x2F90D
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F90E	0x2F90E
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F90F	0x2F90F
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F910	0x2F910
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F911	0x2F911
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F912	0x2F912
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F913	0x2F913
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F914	0x2F914
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F915	0x2F915
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F916	0x2F916
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F917	0x2F917
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F918	0x2F918
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F919	0x2F919
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F91A	0x2F91A
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F91B	0x2F91B
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F91C	0x2F91C
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F91D	0x2F91D
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F91E	0x2F91E
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F91F	0x2F91F
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F920	0x2F920
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F921	0x2F921
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F922	0x2F922
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F923	0x2F923
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F924	0x2F924
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F925	0x2F925
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F926	0x2F926
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F927	0x2F927
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F928	0x2F928
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F929	0x2F929
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F92A	0x2F92A
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F92B	0x2F92B
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F92C	0x2F92C
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F92D	0x2F92D
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F92E	0x2F92E
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F92F	0x2F92F
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F930	0x2F930
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F931	0x2F931
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F932	0x2F932
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F933	0x2F933
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F934	0x2F934
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F935	0x2F935
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F936	0x2F936
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F937	0x2F937
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F938	0x2F938
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F939	0x2F939
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F93A	0x2F93A
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F93B	0x2F93B
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F93C	0x2F93C
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F93D	0x2F93D
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F93E	0x2F93E
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F93F	0x2F93F
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F940	0x2F940
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F941	0x2F941
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F942	0x2F942
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F943	0x2F943
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F944	0x2F944
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F945	0x2F945
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F946	0x2F946
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F947	0x2F947
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F948	0x2F948
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F949	0x2F949
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F94A	0x2F94A
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F94B	0x2F94B
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F94C	0x2F94C
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F94D	0x2F94D
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F94E	0x2F94E
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F94F	0x2F94F
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F950	0x2F950
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F951	0x2F951
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F952	0x2F952
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F953	0x2F953
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F954	0x2F954
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F955	0x2F955
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F956	0x2F956
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F957	0x2F957
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F958	0x2F958
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F959	0x2F959
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F95A	0x2F95A
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F95B	0x2F95B
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F95C	0x2F95C
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F95D	0x2F95D
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F95E	0x2F95E
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F95F	0x2F95F
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F960	0x2F960
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F961	0x2F961
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F962	0x2F962
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F963	0x2F963
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F964	0x2F964
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F965	0x2F965
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F966	0x2F966
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F967	0x2F967
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F968	0x2F968
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F969	0x2F969
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F96A	0x2F96A
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F96B	0x2F96B
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F96C	0x2F96C
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F96D	0x2F96D
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F96E	0x2F96E
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F96F	0x2F96F
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F970	0x2F970
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F971	0x2F971
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F972	0x2F972
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F973	0x2F973
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F974	0x2F974
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F975	0x2F975
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F976	0x2F976
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F977	0x2F977
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F978	0x2F978
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F979	0x2F979
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F97A	0x2F97A
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F97B	0x2F97B
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F97C	0x2F97C
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F97D	0x2F97D
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F97E	0x2F97E
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F97F	0x2F97F
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F980	0x2F980
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F981	0x2F981
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F982	0x2F982
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F983	0x2F983
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F984	0x2F984
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F985	0x2F985
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F986	0x2F986
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F987	0x2F987
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F988	0x2F988
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F989	0x2F989
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F98A	0x2F98A
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F98B	0x2F98B
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F98C	0x2F98C
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F98D	0x2F98D
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F98E	0x2F98E
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F98F	0x2F98F
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F990	0x2F990
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F991	0x2F991
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F992	0x2F992
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F993	0x2F993
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F994	0x2F994
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F995	0x2F995
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F996	0x2F996
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F997	0x2F997
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F998	0x2F998
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F999	0x2F999
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F99A	0x2F99A
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F99B	0x2F99B
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F99C	0x2F99C
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F99D	0x2F99D
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F99E	0x2F99E
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F99F	0x2F99F
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9A0	0x2F9A0
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9A1	0x2F9A1
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9A2	0x2F9A2
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9A3	0x2F9A3
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9A4	0x2F9A4
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9A5	0x2F9A5
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9A6	0x2F9A6
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9A7	0x2F9A7
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9A8	0x2F9A8
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9A9	0x2F9A9
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9AA	0x2F9AA
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9AB	0x2F9AB
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9AC	0x2F9AC
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9AD	0x2F9AD
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9AE	0x2F9AE
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9AF	0x2F9AF
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9B0	0x2F9B0
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9B1	0x2F9B1
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9B2	0x2F9B2
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9B3	0x2F9B3
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9B4	0x2F9B4
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9B5	0x2F9B5
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9B6	0x2F9B6
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9B7	0x2F9B7
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9B8	0x2F9B8
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9B9	0x2F9B9
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9BA	0x2F9BA
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9BB	0x2F9BB
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9BC	0x2F9BC
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9BD	0x2F9BD
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9BE	0x2F9BE
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9BF	0x2F9BF
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9C0	0x2F9C0
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9C1	0x2F9C1
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9C2	0x2F9C2
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9C3	0x2F9C3
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9C4	0x2F9C4
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9C5	0x2F9C5
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9C6	0x2F9C6
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9C7	0x2F9C7
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9C8	0x2F9C8
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9C9	0x2F9C9
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9CA	0x2F9CA
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9CB	0x2F9CB
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9CC	0x2F9CC
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9CD	0x2F9CD
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9CE	0x2F9CE
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9CF	0x2F9CF
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9D0	0x2F9D0
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9D1	0x2F9D1
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9D2	0x2F9D2
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9D3	0x2F9D3
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9D4	0x2F9D4
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9D5	0x2F9D5
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9D6	0x2F9D6
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9D7	0x2F9D7
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9D8	0x2F9D8
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9D9	0x2F9D9
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9DA	0x2F9DA
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9DB	0x2F9DB
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9DC	0x2F9DC
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9DD	0x2F9DD
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9DE	0x2F9DE
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9DF	0x2F9DF
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9E0	0x2F9E0
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9E1	0x2F9E1
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9E2	0x2F9E2
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9E3	0x2F9E3
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9E4	0x2F9E4
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9E5	0x2F9E5
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9E6	0x2F9E6
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9E7	0x2F9E7
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9E8	0x2F9E8
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9E9	0x2F9E9
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9EA	0x2F9EA
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9EB	0x2F9EB
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9EC	0x2F9EC
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9ED	0x2F9ED
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9EE	0x2F9EE
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9EF	0x2F9EF
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9F0	0x2F9F0
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9F1	0x2F9F1
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9F2	0x2F9F2
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9F3	0x2F9F3
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9F4	0x2F9F4
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9F5	0x2F9F5
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9F6	0x2F9F6
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9F7	0x2F9F7
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9F8	0x2F9F8
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9F9	0x2F9F9
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9FA	0x2F9FA
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9FB	0x2F9FB
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9FC	0x2F9FC
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9FD	0x2F9FD
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9FE	0x2F9FE
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2F9FF	0x2F9FF
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2FA00	0x2FA00
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2FA01	0x2FA01
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2FA02	0x2FA02
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2FA03	0x2FA03
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2FA04	0x2FA04
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2FA05	0x2FA05
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2FA06	0x2FA06
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2FA07	0x2FA07
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2FA08	0x2FA08
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2FA09	0x2FA09
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2FA0A	0x2FA0A
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2FA0B	0x2FA0B
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2FA0C	0x2FA0C
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2FA0D	0x2FA0D
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2FA0E	0x2FA0E
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2FA0F	0x2FA0F
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2FA10	0x2FA10
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2FA11	0x2FA11
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2FA12	0x2FA12
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2FA13	0x2FA13
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2FA14	0x2FA14
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2FA15	0x2FA15
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2FA16	0x2FA16
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2FA17	0x2FA17
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2FA18	0x2FA18
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2FA19	0x2FA19
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2FA1A	0x2FA1A
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2FA1B	0x2FA1B
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2FA1C	0x2FA1C
#define T_UTF_16_CJK_COMPATIBILITY_IDEOGRAPH_2FA1D	0x2FA1D
#define T_UTF_16_LANGUAGE_TAG	0xE0001
#define T_UTF_16_TAG_SPACE	0xE0020
#define T_UTF_16_TAG_EXCLAMATION_MARK	0xE0021
#define T_UTF_16_TAG_QUOTATION_MARK	0xE0022
#define T_UTF_16_TAG_NUMBER_SIGN	0xE0023
#define T_UTF_16_TAG_DOLLAR_SIGN	0xE0024
#define T_UTF_16_TAG_PERCENT_SIGN	0xE0025
#define T_UTF_16_TAG_AMPERSAND	0xE0026
#define T_UTF_16_TAG_APOSTROPHE	0xE0027
#define T_UTF_16_TAG_LEFT_PARENTHESIS	0xE0028
#define T_UTF_16_TAG_RIGHT_PARENTHESIS	0xE0029
#define T_UTF_16_TAG_ASTERISK	0xE002A
#define T_UTF_16_TAG_PLUS_SIGN	0xE002B
#define T_UTF_16_TAG_COMMA	0xE002C
#define T_UTF_16_TAG_HYPHEN_MINUS	0xE002D
#define T_UTF_16_TAG_FULL_STOP	0xE002E
#define T_UTF_16_TAG_SOLIDUS	0xE002F
#define T_UTF_16_TAG_DIGIT_ZERO	0xE0030
#define T_UTF_16_TAG_DIGIT_ONE	0xE0031
#define T_UTF_16_TAG_DIGIT_TWO	0xE0032
#define T_UTF_16_TAG_DIGIT_THREE	0xE0033
#define T_UTF_16_TAG_DIGIT_FOUR	0xE0034
#define T_UTF_16_TAG_DIGIT_FIVE	0xE0035
#define T_UTF_16_TAG_DIGIT_SIX	0xE0036
#define T_UTF_16_TAG_DIGIT_SEVEN	0xE0037
#define T_UTF_16_TAG_DIGIT_EIGHT	0xE0038
#define T_UTF_16_TAG_DIGIT_NINE	0xE0039
#define T_UTF_16_TAG_COLON	0xE003A
#define T_UTF_16_TAG_SEMICOLON	0xE003B
#define T_UTF_16_TAG_LESS_THAN_SIGN	0xE003C
#define T_UTF_16_TAG_EQUALS_SIGN	0xE003D
#define T_UTF_16_TAG_GREATER_THAN_SIGN	0xE003E
#define T_UTF_16_TAG_QUESTION_MARK	0xE003F
#define T_UTF_16_TAG_COMMERCIAL_AT	0xE0040
#define T_UTF_16_TAG_LATIN_CAPITAL_LETTER_A	0xE0041
#define T_UTF_16_TAG_LATIN_CAPITAL_LETTER_B	0xE0042
#define T_UTF_16_TAG_LATIN_CAPITAL_LETTER_C	0xE0043
#define T_UTF_16_TAG_LATIN_CAPITAL_LETTER_D	0xE0044
#define T_UTF_16_TAG_LATIN_CAPITAL_LETTER_E	0xE0045
#define T_UTF_16_TAG_LATIN_CAPITAL_LETTER_F	0xE0046
#define T_UTF_16_TAG_LATIN_CAPITAL_LETTER_G	0xE0047
#define T_UTF_16_TAG_LATIN_CAPITAL_LETTER_H	0xE0048
#define T_UTF_16_TAG_LATIN_CAPITAL_LETTER_I	0xE0049
#define T_UTF_16_TAG_LATIN_CAPITAL_LETTER_J	0xE004A
#define T_UTF_16_TAG_LATIN_CAPITAL_LETTER_K	0xE004B
#define T_UTF_16_TAG_LATIN_CAPITAL_LETTER_L	0xE004C
#define T_UTF_16_TAG_LATIN_CAPITAL_LETTER_M	0xE004D
#define T_UTF_16_TAG_LATIN_CAPITAL_LETTER_N	0xE004E
#define T_UTF_16_TAG_LATIN_CAPITAL_LETTER_O	0xE004F
#define T_UTF_16_TAG_LATIN_CAPITAL_LETTER_P	0xE0050
#define T_UTF_16_TAG_LATIN_CAPITAL_LETTER_Q	0xE0051
#define T_UTF_16_TAG_LATIN_CAPITAL_LETTER_R	0xE0052
#define T_UTF_16_TAG_LATIN_CAPITAL_LETTER_S	0xE0053
#define T_UTF_16_TAG_LATIN_CAPITAL_LETTER_T	0xE0054
#define T_UTF_16_TAG_LATIN_CAPITAL_LETTER_U	0xE0055
#define T_UTF_16_TAG_LATIN_CAPITAL_LETTER_V	0xE0056
#define T_UTF_16_TAG_LATIN_CAPITAL_LETTER_W	0xE0057
#define T_UTF_16_TAG_LATIN_CAPITAL_LETTER_X	0xE0058
#define T_UTF_16_TAG_LATIN_CAPITAL_LETTER_Y	0xE0059
#define T_UTF_16_TAG_LATIN_CAPITAL_LETTER_Z	0xE005A
#define T_UTF_16_TAG_LEFT_SQUARE_BRACKET	0xE005B
#define T_UTF_16_TAG_REVERSE_SOLIDUS	0xE005C
#define T_UTF_16_TAG_RIGHT_SQUARE_BRACKET	0xE005D
#define T_UTF_16_TAG_CIRCUMFLEX_ACCENT	0xE005E
#define T_UTF_16_TAG_LOW_LINE	0xE005F
#define T_UTF_16_TAG_GRAVE_ACCENT	0xE0060
#define T_UTF_16_TAG_LATIN_SMALL_LETTER_A	0xE0061
#define T_UTF_16_TAG_LATIN_SMALL_LETTER_B	0xE0062
#define T_UTF_16_TAG_LATIN_SMALL_LETTER_C	0xE0063
#define T_UTF_16_TAG_LATIN_SMALL_LETTER_D	0xE0064
#define T_UTF_16_TAG_LATIN_SMALL_LETTER_E	0xE0065
#define T_UTF_16_TAG_LATIN_SMALL_LETTER_F	0xE0066
#define T_UTF_16_TAG_LATIN_SMALL_LETTER_G	0xE0067
#define T_UTF_16_TAG_LATIN_SMALL_LETTER_H	0xE0068
#define T_UTF_16_TAG_LATIN_SMALL_LETTER_I	0xE0069
#define T_UTF_16_TAG_LATIN_SMALL_LETTER_J	0xE006A
#define T_UTF_16_TAG_LATIN_SMALL_LETTER_K	0xE006B
#define T_UTF_16_TAG_LATIN_SMALL_LETTER_L	0xE006C
#define T_UTF_16_TAG_LATIN_SMALL_LETTER_M	0xE006D
#define T_UTF_16_TAG_LATIN_SMALL_LETTER_N	0xE006E
#define T_UTF_16_TAG_LATIN_SMALL_LETTER_O	0xE006F
#define T_UTF_16_TAG_LATIN_SMALL_LETTER_P	0xE0070
#define T_UTF_16_TAG_LATIN_SMALL_LETTER_Q	0xE0071
#define T_UTF_16_TAG_LATIN_SMALL_LETTER_R	0xE0072
#define T_UTF_16_TAG_LATIN_SMALL_LETTER_S	0xE0073
#define T_UTF_16_TAG_LATIN_SMALL_LETTER_T	0xE0074
#define T_UTF_16_TAG_LATIN_SMALL_LETTER_U	0xE0075
#define T_UTF_16_TAG_LATIN_SMALL_LETTER_V	0xE0076
#define T_UTF_16_TAG_LATIN_SMALL_LETTER_W	0xE0077
#define T_UTF_16_TAG_LATIN_SMALL_LETTER_X	0xE0078
#define T_UTF_16_TAG_LATIN_SMALL_LETTER_Y	0xE0079
#define T_UTF_16_TAG_LATIN_SMALL_LETTER_Z	0xE007A
#define T_UTF_16_TAG_LEFT_CURLY_BRACKET	0xE007B
#define T_UTF_16_TAG_VERTICAL_LINE	0xE007C
#define T_UTF_16_TAG_RIGHT_CURLY_BRACKET	0xE007D
#define T_UTF_16_TAG_TILDE	0xE007E
#define T_UTF_16_CANCEL_TAG	0xE007F


#endif /* _TUTF_UTF_16_H */

