/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.history;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.AbstractDialog;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.utils.ZapTextArea;

public class NotesAddDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jPanel = null;
    private ZapTextArea txtDisplay = null;
    private JButton btnOk = null;
    private JButton btnCancel = null;
    private ExtensionHistory extension = null;
    private HistoryReference historyRef;
    private JScrollPane jScrollPane = null;

    public NotesAddDialog() throws HeadlessException {
        this.initialize();
    }

    public NotesAddDialog(Frame frame, boolean bl) throws HeadlessException {
        super(frame, bl);
        this.initialize();
    }

    private void initialize() {
        this.setTitle(Constant.messages.getString("history.addnote.title"));
        this.setContentPane(this.getJPanel());
        if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
            this.setSize(407, 407);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                NotesAddDialog.this.btnCancel.doClick();
            }
        });
        this.pack();
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            JLabel jLabel = new JLabel();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.setPreferredSize(new Dimension(400, 400));
            this.jPanel.setMinimumSize(new Dimension(400, 400));
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.gridy = 5;
            gridBagConstraints4.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints4.anchor = 13;
            gridBagConstraints3.gridx = 2;
            gridBagConstraints3.gridy = 5;
            gridBagConstraints3.insets = new Insets(2, 2, 2, 10);
            gridBagConstraints3.anchor = 13;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 5;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(2, 10, 2, 5);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 10;
            this.jPanel.add((Component)this.getJScrollPane(), gridBagConstraints);
            this.jPanel.add((Component)jLabel, gridBagConstraints2);
            this.jPanel.add((Component)this.getBtnCancel(), gridBagConstraints4);
            this.jPanel.add((Component)this.getBtnOk(), gridBagConstraints3);
        }
        return this.jPanel;
    }

    private ZapTextArea getTxtDisplay() {
        if (this.txtDisplay == null) {
            this.txtDisplay = new ZapTextArea("");
        }
        return this.txtDisplay;
    }

    private JButton getBtnOk() {
        if (this.btnOk == null) {
            this.btnOk = new JButton();
            this.btnOk.setText(Constant.messages.getString("all.button.save"));
            this.btnOk.setMinimumSize(new Dimension(75, 30));
            this.btnOk.setPreferredSize(new Dimension(75, 30));
            this.btnOk.setMaximumSize(new Dimension(100, 40));
            this.btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NotesAddDialog.this.historyRef.setNote(NotesAddDialog.this.getTxtDisplay().getText());
                    NotesAddDialog.this.getTxtDisplay().discardAllEdits();
                    NotesAddDialog.this.extension.notifyHistoryItemChanged(NotesAddDialog.this.historyRef);
                    NotesAddDialog.this.extension.hideNotesAddDialog();
                }
            });
        }
        return this.btnOk;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setText(Constant.messages.getString("all.button.cancel"));
            this.btnCancel.setMaximumSize(new Dimension(100, 40));
            this.btnCancel.setMinimumSize(new Dimension(70, 30));
            this.btnCancel.setPreferredSize(new Dimension(70, 30));
            this.btnCancel.setEnabled(true);
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NotesAddDialog.this.getTxtDisplay().discardAllEdits();
                    NotesAddDialog.this.extension.hideNotesAddDialog();
                }
            });
        }
        return this.btnCancel;
    }

    public void setPlugin(ExtensionHistory extensionHistory) {
        this.extension = extensionHistory;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setHorizontalScrollBarPolicy(31);
            this.jScrollPane.setVerticalScrollBarPolicy(20);
            this.jScrollPane.setViewportView(this.getTxtDisplay());
        }
        return this.jScrollPane;
    }

    public HistoryReference getHistoryRef() {
        return this.historyRef;
    }

    public void setHistoryRef(HistoryReference historyReference) {
        this.historyRef = historyReference;
    }

    public void setNote(String string) {
        this.getTxtDisplay().setText(string);
        this.getTxtDisplay().discardAllEdits();
    }
}

