/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.component.split.request;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import org.apache.commons.configuration.FileConfiguration;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.extension.httppanel.component.HttpPanelComponentInterface;
import org.zaproxy.zap.extension.httppanel.component.HttpPanelComponentViewsManager;
import org.zaproxy.zap.extension.httppanel.component.split.request.HttpRequestBodyPanelTextView;
import org.zaproxy.zap.extension.httppanel.component.split.request.HttpRequestHeaderPanelTextView;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelDefaultViewSelector;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelView;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.request.RequestBodyStringHttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.request.RequestHeaderStringHttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.text.HttpPanelTextView;
import org.zaproxy.zap.extension.search.SearchMatch;
import org.zaproxy.zap.extension.search.SearchableHttpPanelComponent;
import org.zaproxy.zap.model.HttpMessageLocation;
import org.zaproxy.zap.model.MessageLocation;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlight;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlighter;

public class RequestSplitComponent<T extends Message>
implements HttpPanelComponentInterface,
SearchableHttpPanelComponent,
MessageLocationHighlighter {
    public static final String NAME = "RequestSplit";
    private static final String DIVIDER_LOCATION_CONFIG_KEY = "dividerLocation";
    private static final String BUTTON_TOOL_TIP = Constant.messages.getString("http.panel.component.split.tooltip");
    private static final String HEADER_LABEL = Constant.messages.getString("http.panel.component.split.header");
    private static final String BODY_LABEL = Constant.messages.getString("http.panel.component.split.body");
    protected JToggleButton buttonShowView;
    protected JPanel panelOptions;
    protected JPanel panelMain;
    protected JSplitPane splitMain;
    protected HttpMessage httpMessage;
    protected boolean isEditable;
    protected HttpPanelComponentViewsManager headerViews = new HttpPanelComponentViewsManager("split.header", HEADER_LABEL);
    protected HttpPanelComponentViewsManager bodyViews = new HttpPanelComponentViewsManager("split.body", BODY_LABEL);
    private String configurationKey = "";

    public RequestSplitComponent() {
        this.initUi();
    }

    protected void initUi() {
        this.buttonShowView = new JToggleButton(DisplayUtils.getScaledIcon(new ImageIcon(RequestSplitComponent.class.getResource("/resource/icon/view_split.png"))));
        this.buttonShowView.setToolTipText(BUTTON_TOOL_TIP);
        this.panelOptions = new JPanel();
        this.panelOptions.add(this.headerViews.getSelectableViewsComponent());
        this.panelOptions.add(this.bodyViews.getSelectableViewsComponent());
        this.headerViews.addView(this.createHttpPanelHeaderTextView());
        this.splitMain = new JSplitPane();
        this.splitMain.setDividerSize(3);
        this.splitMain.setResizeWeight(0.5);
        this.splitMain.setContinuousLayout(false);
        this.splitMain.setOrientation(0);
        this.splitMain.setTopComponent(this.headerViews.getViewsPanel());
        this.splitMain.setBottomComponent(this.bodyViews.getViewsPanel());
        this.initViews();
        this.panelMain = new JPanel(new BorderLayout());
        this.panelMain.add((Component)this.splitMain, "Center");
        this.setSelected(false);
    }

    @Override
    public JToggleButton getButton() {
        return this.buttonShowView;
    }

    @Override
    public JPanel getOptionsPanel() {
        return this.panelOptions;
    }

    @Override
    public JPanel getMoreOptionsPanel() {
        return null;
    }

    @Override
    public JPanel getMainPanel() {
        return this.panelMain;
    }

    @Override
    public void setSelected(boolean bl) {
        this.buttonShowView.setSelected(bl);
        this.headerViews.setSelected(bl);
    }

    protected HttpPanelTextView createHttpPanelHeaderTextView() {
        return new HttpRequestHeaderPanelTextView(new RequestHeaderStringHttpPanelViewModel());
    }

    protected void initViews() {
        this.bodyViews.addView(new HttpRequestBodyPanelTextView(new RequestBodyStringHttpPanelViewModel()));
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getPosition() {
        return 1;
    }

    @Override
    public boolean isEnabled(Message message) {
        if (message == null) {
            return true;
        }
        return message instanceof HttpMessage;
    }

    @Override
    public void setMessage(Message message) {
        this.httpMessage = (HttpMessage)message;
        this.headerViews.setMessage(this.httpMessage);
        this.bodyViews.setMessage(this.httpMessage);
    }

    @Override
    public void save() {
        if (this.httpMessage == null) {
            return;
        }
        this.headerViews.save();
        this.bodyViews.save();
    }

    @Override
    public void addView(HttpPanelView httpPanelView, Object object, FileConfiguration fileConfiguration) {
        if (object != null) {
            if (ViewComponent.HEADER.equals(object)) {
                this.headerViews.addView(httpPanelView, fileConfiguration);
            } else if (ViewComponent.BODY.equals(object)) {
                this.bodyViews.addView(httpPanelView, fileConfiguration);
            }
        }
    }

    @Override
    public void removeView(String string, Object object) {
        if (object != null) {
            if (ViewComponent.HEADER.equals(object)) {
                this.headerViews.removeView(string);
            } else if (ViewComponent.BODY.equals(object)) {
                this.bodyViews.removeView(string);
            }
        }
    }

    @Override
    public void clearView() {
        this.httpMessage = null;
        this.headerViews.clearView();
        this.bodyViews.clearView();
    }

    @Override
    public void clearView(boolean bl) {
        this.clearView();
        this.setEnableViewSelect(bl);
    }

    @Override
    public void setEnableViewSelect(boolean bl) {
        this.headerViews.setEnableViewSelect(bl);
        this.bodyViews.setEnableViewSelect(bl);
    }

    @Override
    public void addDefaultViewSelector(HttpPanelDefaultViewSelector httpPanelDefaultViewSelector, Object object) {
        if (object != null) {
            if (ViewComponent.HEADER.equals(object)) {
                this.headerViews.addDefaultViewSelector(httpPanelDefaultViewSelector);
            } else if (ViewComponent.BODY.equals(object)) {
                this.bodyViews.addDefaultViewSelector(httpPanelDefaultViewSelector);
            }
        }
    }

    @Override
    public void removeDefaultViewSelector(String string, Object object) {
        if (object != null) {
            if (ViewComponent.HEADER.equals(object)) {
                this.headerViews.removeDefaultViewSelector(string);
            } else if (ViewComponent.BODY.equals(object)) {
                this.bodyViews.removeDefaultViewSelector(string);
            }
        }
    }

    @Override
    public void setParentConfigurationKey(String string) {
        this.configurationKey = string;
        this.headerViews.setConfigurationKey(string);
        this.bodyViews.setConfigurationKey(string);
    }

    @Override
    public void loadConfig(FileConfiguration fileConfiguration) {
        this.splitMain.setDividerLocation(Model.getSingleton().getOptionsParam().getConfig().getInt(this.configurationKey + DIVIDER_LOCATION_CONFIG_KEY, -1));
        this.headerViews.loadConfig(fileConfiguration);
        this.bodyViews.loadConfig(fileConfiguration);
    }

    @Override
    public void saveConfig(FileConfiguration fileConfiguration) {
        Model.getSingleton().getOptionsParam().getConfig().setProperty(this.configurationKey + DIVIDER_LOCATION_CONFIG_KEY, (Object)this.splitMain.getDividerLocation());
        this.headerViews.saveConfig(fileConfiguration);
        this.bodyViews.saveConfig(fileConfiguration);
    }

    @Override
    public void setEditable(boolean bl) {
        if (this.isEditable != bl) {
            this.isEditable = bl;
            this.headerViews.setEditable(bl);
            this.bodyViews.setEditable(bl);
        }
    }

    @Override
    public void highlightHeader(SearchMatch searchMatch) {
        this.headerViews.highlight(searchMatch);
    }

    @Override
    public void highlightBody(SearchMatch searchMatch) {
        this.bodyViews.highlight(searchMatch);
    }

    @Override
    public void searchHeader(Pattern pattern, List<SearchMatch> list) {
        this.headerViews.search(pattern, list);
    }

    @Override
    public void searchBody(Pattern pattern, List<SearchMatch> list) {
        this.bodyViews.search(pattern, list);
    }

    @Override
    public boolean supports(MessageLocation messageLocation) {
        if (!(messageLocation instanceof HttpMessageLocation)) {
            return false;
        }
        HttpMessageLocation httpMessageLocation = (HttpMessageLocation)messageLocation;
        switch (httpMessageLocation.getLocation()) {
            case REQUEST_HEADER: 
            case RESPONSE_HEADER: {
                return this.headerViews.supports(httpMessageLocation);
            }
            case REQUEST_BODY: 
            case RESPONSE_BODY: {
                return this.bodyViews.supports(httpMessageLocation);
            }
        }
        return false;
    }

    @Override
    public boolean supports(Class<? extends MessageLocation> clazz) {
        return !HttpMessageLocation.class.isAssignableFrom(clazz);
    }

    @Override
    public MessageLocationHighlight highlight(MessageLocation messageLocation) {
        if (!(messageLocation instanceof HttpMessageLocation)) {
            return null;
        }
        HttpMessageLocation httpMessageLocation = (HttpMessageLocation)messageLocation;
        switch (httpMessageLocation.getLocation()) {
            case REQUEST_HEADER: 
            case RESPONSE_HEADER: {
                return this.headerViews.highlight(httpMessageLocation);
            }
            case REQUEST_BODY: 
            case RESPONSE_BODY: {
                return this.bodyViews.highlight(httpMessageLocation);
            }
        }
        return null;
    }

    @Override
    public MessageLocationHighlight highlight(MessageLocation messageLocation, MessageLocationHighlight messageLocationHighlight) {
        if (!(messageLocation instanceof HttpMessageLocation)) {
            return null;
        }
        HttpMessageLocation httpMessageLocation = (HttpMessageLocation)messageLocation;
        switch (httpMessageLocation.getLocation()) {
            case REQUEST_HEADER: 
            case RESPONSE_HEADER: {
                return this.headerViews.highlight(httpMessageLocation, messageLocationHighlight);
            }
            case REQUEST_BODY: 
            case RESPONSE_BODY: {
                return this.bodyViews.highlight(httpMessageLocation, messageLocationHighlight);
            }
        }
        return null;
    }

    @Override
    public void removeHighlight(MessageLocation messageLocation, MessageLocationHighlight messageLocationHighlight) {
        if (!(messageLocation instanceof HttpMessageLocation)) {
            return;
        }
        HttpMessageLocation httpMessageLocation = (HttpMessageLocation)messageLocation;
        switch (httpMessageLocation.getLocation()) {
            case REQUEST_HEADER: 
            case RESPONSE_HEADER: {
                this.headerViews.removeHighlight(httpMessageLocation, messageLocationHighlight);
                break;
            }
            case REQUEST_BODY: 
            case RESPONSE_BODY: {
                this.bodyViews.removeHighlight(httpMessageLocation, messageLocationHighlight);
                break;
            }
        }
    }

    @Override
    public HttpPanelView setSelectedView(String string) {
        HttpPanelView httpPanelView = this.headerViews.setSelectedView(string);
        if (httpPanelView != null) {
            return httpPanelView;
        }
        return this.bodyViews.setSelectedView(string);
    }

    public static enum ViewComponent {
        HEADER,
        BODY;

    }
}

