/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.components.all.response;

import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.response.ResponseStringHttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.AutoDetectSyntaxHttpPanelTextArea;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextArea;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextView;
import org.zaproxy.zap.extension.httppanel.view.util.HttpTextViewUtils;
import org.zaproxy.zap.extension.search.SearchMatch;

public class HttpResponseAllPanelSyntaxHighlightTextView
extends HttpPanelSyntaxHighlightTextView {
    private static final String CSS = Constant.messages.getString("http.panel.view.syntaxtext.syntax.css");
    private static final String HTML = Constant.messages.getString("http.panel.view.syntaxtext.syntax.html");
    private static final String JAVASCRIPT = Constant.messages.getString("http.panel.view.syntaxtext.syntax.javascript");
    private static final String JSON = Constant.messages.getString("http.panel.view.syntaxtext.syntax.json");
    private static final String XML = Constant.messages.getString("http.panel.view.syntaxtext.syntax.xml");

    public HttpResponseAllPanelSyntaxHighlightTextView(ResponseStringHttpPanelViewModel responseStringHttpPanelViewModel) {
        super(responseStringHttpPanelViewModel);
    }

    @Override
    protected HttpPanelSyntaxHighlightTextArea createHttpPanelTextArea() {
        return new HttpResponseAllPanelSyntaxHighlightTextArea();
    }

    private static class HttpResponseAllPanelSyntaxHighlightTextArea
    extends AutoDetectSyntaxHttpPanelTextArea {
        private static final long serialVersionUID = 3665478428546560762L;
        private static final Logger log = Logger.getLogger(HttpResponseAllPanelSyntaxHighlightTextArea.class);
        private static ResponseAllTokenMakerFactory tokenMakerFactory = null;

        public HttpResponseAllPanelSyntaxHighlightTextArea() {
            this.addSyntaxStyle(CSS, "text/css");
            this.addSyntaxStyle(HTML, "text/html");
            this.addSyntaxStyle(JAVASCRIPT, "text/javascript");
            this.addSyntaxStyle(JSON, "text/json");
            this.addSyntaxStyle(XML, "text/xml");
        }

        @Override
        public void search(Pattern pattern, List<SearchMatch> list) {
            String string = ((HttpMessage)this.getMessage()).getResponseHeader().toString();
            Matcher matcher = pattern.matcher(this.getText());
            while (matcher.find()) {
                int[] nArray = HttpTextViewUtils.getViewToHeaderBodyPosition((JTextArea)((Object)this), string, matcher.start(), matcher.end());
                if (nArray.length == 0) {
                    return;
                }
                SearchMatch.Location location = nArray.length == 2 ? SearchMatch.Location.RESPONSE_HEAD : SearchMatch.Location.RESPONSE_BODY;
                list.add(new SearchMatch(location, nArray[0], nArray[1]));
            }
        }

        @Override
        public void highlight(SearchMatch searchMatch) {
            if (!SearchMatch.Location.RESPONSE_HEAD.equals((Object)searchMatch.getLocation()) && !SearchMatch.Location.RESPONSE_BODY.equals((Object)searchMatch.getLocation())) {
                return;
            }
            int[] nArray = SearchMatch.Location.RESPONSE_HEAD.equals((Object)searchMatch.getLocation()) ? HttpTextViewUtils.getHeaderToViewPosition((JTextArea)((Object)this), searchMatch.getMessage().getResponseHeader().toString(), searchMatch.getStart(), searchMatch.getEnd()) : HttpTextViewUtils.getBodyToViewPosition((JTextArea)((Object)this), searchMatch.getMessage().getResponseHeader().toString(), searchMatch.getStart(), searchMatch.getEnd());
            if (nArray.length == 0) {
                return;
            }
            this.highlight(nArray[0], nArray[1]);
        }

        @Override
        protected String detectSyntax(HttpMessage httpMessage) {
            String string;
            String string2 = null;
            if (httpMessage != null && (string = httpMessage.getResponseHeader().getHeader("Content-Type")) != null && !string.isEmpty()) {
                int n = (string = string.toLowerCase(Locale.ENGLISH)).indexOf(59);
                if (n != -1) {
                    string = string.substring(0, n).trim();
                }
                string2 = string.contains("javascript") ? "text/javascript" : (string.contains("json") ? "text/json" : (string.contains("xhtml") ? "text/html" : (string.contains("xml") ? "text/xml" : string)));
            }
            return string2;
        }

        @Override
        protected synchronized HttpPanelSyntaxHighlightTextArea.CustomTokenMakerFactory getTokenMakerFactory() {
            if (tokenMakerFactory == null) {
                tokenMakerFactory = new ResponseAllTokenMakerFactory();
            }
            return tokenMakerFactory;
        }

        private static class ResponseAllTokenMakerFactory
        extends HttpPanelSyntaxHighlightTextArea.CustomTokenMakerFactory {
            public ResponseAllTokenMakerFactory() {
                String string = "org.fife.ui.rsyntaxtextarea.modes.";
                this.putMapping("text/css", string + "CSSTokenMaker");
                this.putMapping("text/html", string + "HTMLTokenMaker");
                this.putMapping("text/javascript", string + "JavaScriptTokenMaker");
                this.putMapping("text/json", string + "JsonTokenMaker");
                this.putMapping("text/xml", string + "XMLTokenMaker");
            }
        }
    }
}

