/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.spider;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.table.TableModel;
import org.apache.commons.httpclient.URI;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.parosproxy.paros.network.HttpResponseHeader;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.spider.ExtensionSpider;
import org.zaproxy.zap.extension.spider.SpiderMessagesTableModel;
import org.zaproxy.zap.extension.spider.SpiderResource;
import org.zaproxy.zap.extension.spider.SpiderThread;
import org.zaproxy.zap.model.GenericScanner2;
import org.zaproxy.zap.model.ScanListenner;
import org.zaproxy.zap.model.ScanListenner2;
import org.zaproxy.zap.model.Target;
import org.zaproxy.zap.spider.SpiderListener;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.spider.filters.FetchFilter;
import org.zaproxy.zap.spider.filters.ParseFilter;
import org.zaproxy.zap.spider.parser.SpiderParser;
import org.zaproxy.zap.users.User;

public class SpiderScan
implements ScanListenner,
SpiderListener,
GenericScanner2 {
    private static final EnumSet<FetchFilter.FetchStatus> FETCH_STATUS_IN_SCOPE = EnumSet.of(FetchFilter.FetchStatus.VALID, FetchFilter.FetchStatus.SEED);
    private static final EnumSet<FetchFilter.FetchStatus> FETCH_STATUS_OUT_OF_SCOPE = EnumSet.of(FetchFilter.FetchStatus.OUT_OF_SCOPE, FetchFilter.FetchStatus.OUT_OF_CONTEXT, FetchFilter.FetchStatus.USER_RULES);
    private final Lock lock = new ReentrantLock();
    private int scanId;
    private String displayName = "";
    private AtomicInteger numberOfURIsFound;
    private Set<String> foundURIs;
    private List<SpiderResource> resourcesFound;
    private List<SpiderResource> resourcesIoErrors;
    private Set<String> foundURIsOutOfScope;
    private SpiderThread spiderThread = null;
    private State state;
    private int progress;
    private ScanListenner2 listener = null;
    private volatile boolean cleared;
    private SpiderMessagesTableModel messagesTableModel;

    @Deprecated
    public SpiderScan(ExtensionSpider extensionSpider, SpiderParam spiderParam, Target target, URI uRI, User user, int n) {
        this(extensionSpider, spiderParam, target, uRI, user, n, "SpiderScan" + n);
    }

    public SpiderScan(ExtensionSpider extensionSpider, SpiderParam spiderParam, Target target, URI uRI, User user, int n, String string) {
        this.scanId = n;
        this.setDisplayName(string);
        this.numberOfURIsFound = new AtomicInteger();
        this.foundURIs = Collections.synchronizedSet(new HashSet());
        this.resourcesFound = Collections.synchronizedList(new ArrayList());
        this.resourcesIoErrors = Collections.synchronizedList(new ArrayList());
        this.foundURIsOutOfScope = Collections.synchronizedSet(new HashSet());
        this.state = State.NOT_STARTED;
        this.spiderThread = new SpiderThread(Integer.toString(n), extensionSpider, spiderParam, string, this);
        this.spiderThread.setStartURI(uRI);
        this.spiderThread.setStartNode(target.getStartNode());
        this.spiderThread.setScanContext(target.getContext());
        this.spiderThread.setScanAsUser(user);
        this.spiderThread.setJustScanInScope(target.isInScopeOnly());
        this.spiderThread.setScanChildren(target.isRecurse());
    }

    @Override
    public int getScanId() {
        return this.scanId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getState() {
        this.lock.lock();
        try {
            String string = this.state.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.lock.lock();
        try {
            if (State.NOT_STARTED.equals((Object)this.state)) {
                this.spiderThread.addSpiderListener(this);
                this.spiderThread.start();
                this.state = State.RUNNING;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pauseScan() {
        this.lock.lock();
        try {
            if (State.RUNNING.equals((Object)this.state)) {
                this.spiderThread.pauseScan();
                this.state = State.PAUSED;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeScan() {
        this.lock.lock();
        try {
            if (State.PAUSED.equals((Object)this.state)) {
                this.spiderThread.resumeScan();
                this.state = State.RUNNING;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopScan() {
        this.lock.lock();
        try {
            if (!State.NOT_STARTED.equals((Object)this.state) && !State.FINISHED.equals((Object)this.state)) {
                this.spiderThread.stopScan();
                this.state = State.FINISHED;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public Set<String> getResults() {
        return this.foundURIs;
    }

    public List<SpiderResource> getResourcesFound() {
        return this.resourcesFound;
    }

    public List<SpiderResource> getResourcesIoErrors() {
        return this.resourcesIoErrors;
    }

    public Set<String> getResultsOutOfScope() {
        return this.foundURIsOutOfScope;
    }

    @Override
    public void readURI(HttpMessage httpMessage) {
        HttpRequestHeader httpRequestHeader = httpMessage.getRequestHeader();
        HttpResponseHeader httpResponseHeader = httpMessage.getResponseHeader();
        SpiderResource spiderResource = new SpiderResource(httpMessage.getHistoryRef().getHistoryId(), httpRequestHeader.getMethod(), httpRequestHeader.getURI().toString(), httpResponseHeader.getStatusCode(), httpResponseHeader.getReasonPhrase());
        if (httpMessage.isResponseFromTargetHost()) {
            this.resourcesFound.add(spiderResource);
        } else {
            this.resourcesIoErrors.add(spiderResource);
        }
        if (View.isInitialised()) {
            this.addMessageToMessagesTableModel(httpMessage);
        }
    }

    private void addMessageToMessagesTableModel(final HttpMessage httpMessage) {
        if (EventQueue.isDispatchThread() || this.cleared) {
            if (this.cleared) {
                return;
            }
            if (this.messagesTableModel == null) {
                this.messagesTableModel = new SpiderMessagesTableModel();
            }
            this.messagesTableModel.addHistoryReference(httpMessage.getHistoryRef(), !httpMessage.isResponseFromTargetHost());
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SpiderScan.this.addMessageToMessagesTableModel(httpMessage);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void spiderComplete(boolean bl) {
        this.lock.lock();
        try {
            this.state = State.FINISHED;
        }
        finally {
            this.lock.unlock();
        }
        if (this.listener != null) {
            this.listener.scanFinshed(this.getScanId(), this.getDisplayName());
        }
    }

    @Override
    public void spiderProgress(int n, int n2, int n3) {
        this.progress = n;
        if (this.listener != null) {
            this.listener.scanProgress(this.getScanId(), this.getDisplayName(), n, 100);
        }
    }

    @Override
    public void foundURI(String string, String string2, FetchFilter.FetchStatus fetchStatus) {
        this.numberOfURIsFound.incrementAndGet();
        if (FETCH_STATUS_IN_SCOPE.contains((Object)fetchStatus)) {
            this.foundURIs.add(string);
        } else if (FETCH_STATUS_OUT_OF_SCOPE.contains((Object)fetchStatus)) {
            this.foundURIsOutOfScope.add(string);
        }
    }

    @Override
    public void run() {
    }

    @Override
    public void setScanId(int n) {
        this.scanId = n;
    }

    @Override
    public void setDisplayName(String string) {
        this.displayName = string;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public boolean isStopped() {
        return this.spiderThread.isStopped();
    }

    @Override
    public int getMaximum() {
        return 100;
    }

    public int getNumberOfURIsFound() {
        return this.numberOfURIsFound.get();
    }

    @Override
    public boolean isPaused() {
        return this.spiderThread.isPaused();
    }

    @Override
    public boolean isRunning() {
        return this.spiderThread.isRunning();
    }

    @Override
    public void scanFinshed(String string) {
        this.spiderComplete(true);
    }

    @Override
    public void scanProgress(String string, int n, int n2) {
    }

    public TableModel getResultsTableModel() {
        return this.spiderThread.getResultsTableModel();
    }

    TableModel getMessagesTableModel() {
        if (this.messagesTableModel == null) {
            this.messagesTableModel = new SpiderMessagesTableModel();
        }
        return this.messagesTableModel;
    }

    public void setListener(ScanListenner2 scanListenner2) {
        this.listener = scanListenner2;
    }

    public void setCustomSpiderParsers(List<SpiderParser> list) {
        this.spiderThread.setCustomSpiderParsers(list);
    }

    public void setCustomFetchFilters(List<FetchFilter> list) {
        this.spiderThread.setCustomFetchFilters(list);
    }

    public void setCustomParseFilters(List<ParseFilter> list) {
        this.spiderThread.setCustomParseFilters(list);
    }

    void clear() {
        this.cleared = true;
        if (this.messagesTableModel != null) {
            this.messagesTableModel.clear();
            this.messagesTableModel = null;
        }
    }

    private static enum State {
        NOT_STARTED,
        RUNNING,
        PAUSED,
        FINISHED;

    }
}

