/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.misc.tablemodel;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.table.DefaultTableModel;
import org.jfree.report.JFreeReportBoot;
import org.jfree.report.modules.misc.tablemodel.CloseableTableModel;
import org.jfree.report.modules.misc.tablemodel.ScrollableResultSetTableModel;
import org.pentaho.reporting.libraries.base.util.DebugLog;

public final class ResultSetTableModelFactory {
    public static final String COLUMN_NAME_MAPPING_KEY = "org.jfree.report.modules.misc.tablemodel.ColumnNameMapping";
    public static final String RESULTSET_FACTORY_MODE = "org.jfree.report.modules.misc.tablemodel.TableFactoryMode";
    private static ResultSetTableModelFactory defaultInstance;

    private ResultSetTableModelFactory() {
    }

    public CloseableTableModel createTableModel(ResultSet resultSet) throws SQLException {
        return this.createTableModel(resultSet, JFreeReportBoot.getInstance().getGlobalConfig().getConfigProperty(COLUMN_NAME_MAPPING_KEY, "Label").equals("Label"));
    }

    public CloseableTableModel createTableModel(ResultSet resultSet, boolean bl) throws SQLException {
        String string = JFreeReportBoot.getInstance().getGlobalConfig().getConfigProperty(RESULTSET_FACTORY_MODE, "");
        if (string.equalsIgnoreCase("simple")) {
            return this.generateDefaultTableModel(resultSet, bl);
        }
        int n = 1003;
        try {
            n = resultSet.getType();
        }
        catch (SQLException sQLException) {
            DebugLog.log((Object)"ResultSet type could not be determined, assuming default table model.");
        }
        if (n == 1003) {
            return this.generateDefaultTableModel(resultSet, bl);
        }
        return new ScrollableResultSetTableModel(resultSet, bl);
    }

    public CloseableTableModel generateDefaultTableModel(ResultSet resultSet) throws SQLException {
        return this.generateDefaultTableModel(resultSet, JFreeReportBoot.getInstance().getGlobalConfig().getConfigProperty(COLUMN_NAME_MAPPING_KEY, "Label").equals("Label"));
    }

    public CloseableTableModel generateDefaultTableModel(ResultSet resultSet, boolean bl) throws SQLException {
        Object[] objectArray;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(n);
        for (int i = 0; i < n; ++i) {
            if (bl) {
                objectArray = resultSetMetaData.getColumnLabel(i + 1);
                arrayList.add(objectArray);
                continue;
            }
            objectArray = resultSetMetaData.getColumnName(i + 1);
            arrayList.add(objectArray);
        }
        ArrayList<Object[]> arrayList2 = new ArrayList<Object[]>();
        while (resultSet.next()) {
            objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                Object object;
                objectArray[i] = object = resultSet.getObject(i + 1);
            }
            arrayList2.add(objectArray);
        }
        objectArray = arrayList2.toArray();
        Object[][] objectArray2 = new Object[objectArray.length][];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = (Object[])objectArray[i];
        }
        CloseableDefaultTableModel closeableDefaultTableModel = new CloseableDefaultTableModel(objectArray2, arrayList.toArray(), resultSet);
        for (int i = 0; i < n; ++i) {
        }
        return closeableDefaultTableModel;
    }

    public static synchronized ResultSetTableModelFactory getInstance() {
        if (defaultInstance == null) {
            defaultInstance = new ResultSetTableModelFactory();
        }
        return defaultInstance;
    }

    private static final class CloseableDefaultTableModel
    extends DefaultTableModel
    implements CloseableTableModel {
        private final ResultSet res;

        private CloseableDefaultTableModel(Object[][] objectArray, Object[] objectArray2, ResultSet resultSet) {
            super(objectArray, objectArray2);
            this.res = resultSet;
        }

        public void close() {
            this.setDataVector(new Object[0][0], new Object[0]);
            try {
                this.res.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

