/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.deletebydate;

import java.text.DateFormat;
import javax.swing.table.AbstractTableModel;
import tim.prune.I18nManager;
import tim.prune.function.deletebydate.DateInfo;
import tim.prune.function.deletebydate.DateInfoList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeletionTableModel
extends AbstractTableModel {
    private DateInfoList _infoList = null;
    private static final DateFormat DEFAULT_DATE_FORMAT = DateFormat.getDateInstance();
    private static final String COLUMN_HEADING_DATE = I18nManager.getText("fieldname.date");
    private static final String COLUMN_HEADING_NUMPOINTS = I18nManager.getText("details.track.points");
    private static final String COLUMN_HEADING_KEEP = I18nManager.getText("dialog.deletebydate.column.keep");
    private static final String COLUMN_HEADING_DELETE = I18nManager.getText("dialog.deletebydate.column.delete");

    public DeletionTableModel(DateInfoList dateInfoList) {
        this._infoList = dateInfoList;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public int getRowCount() {
        if (this._infoList == null) {
            return 0;
        }
        return this._infoList.getNumEntries();
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return COLUMN_HEADING_DATE;
        }
        if (n == 1) {
            return COLUMN_HEADING_NUMPOINTS;
        }
        if (n == 2) {
            return COLUMN_HEADING_KEEP;
        }
        if (n == 3) {
            return COLUMN_HEADING_DELETE;
        }
        return "unknown column!";
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == 1) {
            return Integer.class;
        }
        if (n > 1) {
            return Boolean.class;
        }
        return super.getColumnClass(n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 > 1;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        boolean bl;
        boolean bl2 = n2 == 2;
        boolean bl3 = bl = n2 == 3;
        if (bl2 || bl) {
            try {
                boolean bl4 = (Boolean)object;
                if (bl4) {
                    this._infoList.getDateInfo(n).setDeleteFlag(bl);
                    this.fireTableCellUpdated(n, 5 - n2);
                }
            }
            catch (ClassCastException classCastException) {}
        }
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            DateInfo dateInfo = this._infoList.getDateInfo(n);
            if (dateInfo != null) {
                switch (n2) {
                    case 0: {
                        if (dateInfo.isDateless()) {
                            return I18nManager.getText("dialog.deletebydate.nodate");
                        }
                        return DEFAULT_DATE_FORMAT.format(dateInfo.getDate());
                    }
                    case 1: {
                        return dateInfo.getPointCount();
                    }
                    case 2: {
                        return !dateInfo.getDeleteFlag();
                    }
                    case 3: {
                        return dateInfo.getDeleteFlag();
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        return null;
    }
}

