/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnchor;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPointerAnchorProvider;

public class WrappedElementAnchor
extends PsiAnchor {
    private final SmartPointerAnchorProvider myAnchorProvider;
    private final PsiAnchor myBaseAnchor;

    public WrappedElementAnchor(@NotNull SmartPointerAnchorProvider provider, @NotNull PsiAnchor anchor2) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/kotlin/com/intellij/psi/WrappedElementAnchor", "<init>"));
        }
        if (anchor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "org/jetbrains/kotlin/com/intellij/psi/WrappedElementAnchor", "<init>"));
        }
        this.myAnchorProvider = provider;
        this.myBaseAnchor = anchor2;
    }

    @Override
    @Nullable
    public PsiElement retrieve() {
        PsiElement baseElement = this.myBaseAnchor.retrieve();
        return baseElement == null ? null : this.myAnchorProvider.restoreElement(baseElement);
    }

    @Override
    public PsiFile getFile() {
        PsiElement element = this.retrieve();
        return element == null ? null : element.getContainingFile();
    }

    @Override
    public int getStartOffset() {
        PsiElement element = this.retrieve();
        return element == null || element.getTextRange() == null ? -1 : element.getTextRange().getStartOffset();
    }

    @Override
    public int getEndOffset() {
        PsiElement element = this.retrieve();
        return element == null || element.getTextRange() == null ? -1 : element.getTextRange().getEndOffset();
    }

    public String toString() {
        return "WrappedElementAnchor(" + this.myBaseAnchor + "; provider=" + this.myAnchorProvider + ")";
    }
}

