/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.js.util.AstUtil;

public final class JsInvocation
extends JsExpression.JsExpressionHasArguments {
    @NotNull
    private JsExpression qualifier;

    public JsInvocation(@NotNull JsExpression qualifier, @NotNull List<? extends JsExpression> arguments2) {
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/kotlin/js/backend/ast/JsInvocation", "<init>"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/js/backend/ast/JsInvocation", "<init>"));
        }
        super(new SmartList<JsExpression>((Collection<JsExpression>)arguments2));
        this.qualifier = qualifier;
    }

    public JsInvocation(@NotNull JsExpression qualifier, JsExpression ... arguments2) {
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/kotlin/js/backend/ast/JsInvocation", "<init>"));
        }
        this(qualifier, new SmartList<JsExpression>(arguments2));
    }

    @Override
    @NotNull
    public List<JsExpression> getArguments() {
        List list2 = this.arguments;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsInvocation", "getArguments"));
        }
        return list2;
    }

    @NotNull
    public JsExpression getQualifier() {
        JsExpression jsExpression = this.qualifier;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsInvocation", "getQualifier"));
        }
        return jsExpression;
    }

    public void setQualifier(@NotNull JsExpression qualifier) {
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/kotlin/js/backend/ast/JsInvocation", "setQualifier"));
        }
        this.qualifier = qualifier;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitInvocation(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        visitor2.accept(this.qualifier);
        visitor2.acceptList(this.arguments);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            this.qualifier = v.accept(this.qualifier);
            v.acceptList(this.arguments);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsInvocation deepCopy() {
        JsExpression qualifierCopy = AstUtil.deepCopy(this.qualifier);
        List argumentsCopy = AstUtil.deepCopy(this.arguments);
        JsInvocation jsInvocation = new JsInvocation(qualifierCopy, argumentsCopy).withMetadataFrom(this);
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsInvocation", "deepCopy"));
        }
        return jsInvocation;
    }
}

