/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.dataflow.analyses;

import java.util.BitSet;
import java.util.Set;
import org.jruby.dirgra.Edge;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRFlags;
import org.jruby.ir.dataflow.FlowGraphNode;
import org.jruby.ir.dataflow.analyses.DefinedVariablesProblem;
import org.jruby.ir.instructions.ClosureAcceptingInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.TemporaryLocalVariable;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.representations.BasicBlock;

public class DefinedVariableNode
extends FlowGraphNode<DefinedVariablesProblem, DefinedVariableNode> {
    private BitSet in;
    private BitSet out;
    private BitSet tmp;
    private int setSize;

    public DefinedVariableNode(DefinedVariablesProblem prob, BasicBlock n) {
        super(prob, n);
    }

    @Override
    public void init() {
        this.out = null;
    }

    private void addDFVar(Variable v) {
        if (!((DefinedVariablesProblem)this.problem).dfVarExists(v)) {
            ((DefinedVariablesProblem)this.problem).addDFVar(v);
        }
    }

    @Override
    public void buildDataFlowVars(Instr i2) {
        if (i2 instanceof ResultInstr) {
            this.addDFVar(((ResultInstr)((Object)i2)).getResult());
        }
        for (Variable x : i2.getUsedVariables()) {
            this.addDFVar(x);
        }
    }

    @Override
    public void applyPreMeetHandler() {
        this.setSize = ((DefinedVariablesProblem)this.problem).getDFVarsCount();
        this.in = null;
    }

    @Override
    public void compute_MEET(Edge e, DefinedVariableNode pred2) {
        BitSet predState;
        BitSet bitSet = predState = this.basicBlock.isRescueEntry() ? pred2.in : pred2.out;
        if (predState != null) {
            if (this.in == null) {
                int n = predState.size();
                this.in = new BitSet(n);
                this.in.set(0, n);
            }
            this.in.and(predState);
        }
    }

    @Override
    public void initSolution() {
        this.tmp = this.in == null ? new BitSet(this.setSize) : (BitSet)this.in.clone();
    }

    @Override
    public void applyTransferFunction(Instr i2) {
        if (i2 instanceof ResultInstr) {
            this.tmp.set(((DefinedVariablesProblem)this.problem).getDFVar(((ResultInstr)((Object)i2)).getResult()));
        }
        for (Variable v : i2.getUsedVariables()) {
            if (!(v instanceof LocalVariable) || ((LocalVariable)v).getScopeDepth() <= 0) continue;
            this.tmp.set(((DefinedVariablesProblem)this.problem).getDFVar(v));
        }
    }

    private void identifyUndefinedVarsInClosure(Set<Variable> undefinedVars, IRClosure cl, int nestingLevel) {
        int clBaseDepth = nestingLevel + (cl.getFlags().contains((Object)IRFlags.REUSE_PARENT_DYNSCOPE) ? 0 : 1);
        cl.setUpUseDefLocalVarMaps();
        for (LocalVariable lv : cl.getUsedLocalVariables()) {
            if (((DefinedVariablesProblem)this.problem).getDFVar(lv) == null || lv.getScopeDepth() != clBaseDepth || this.tmp.get(((DefinedVariablesProblem)this.problem).getDFVar(lv))) continue;
            undefinedVars.add(lv.getScopeDepth() == 0 ? lv : lv.cloneForDepth(0));
            this.tmp.set(((DefinedVariablesProblem)this.problem).getDFVar(lv));
        }
        for (IRClosure nestedCl : cl.getClosures()) {
            this.identifyUndefinedVarsInClosure(undefinedVars, nestedCl, nestingLevel + 1);
        }
    }

    public void identifyInits(Set<Variable> undefinedVars) {
        int parentScopeDepth = ((DefinedVariablesProblem)this.problem).getScope().getFlags().contains((Object)IRFlags.REUSE_PARENT_DYNSCOPE) ? 0 : 1;
        this.initSolution();
        for (Instr i2 : this.basicBlock.getInstrs()) {
            Operand o;
            for (Variable v : i2.getUsedVariables()) {
                if (v.isSelf()) continue;
                if (v instanceof LocalVariable) {
                    LocalVariable lv = (LocalVariable)v;
                    if (lv.getScopeDepth() < parentScopeDepth && !this.tmp.get(((DefinedVariablesProblem)this.problem).getDFVar(v))) {
                        undefinedVars.add(lv.getScopeDepth() == 0 ? lv : lv.cloneForDepth(0));
                    }
                    this.tmp.set(((DefinedVariablesProblem)this.problem).getDFVar(lv));
                    continue;
                }
                if (!(v instanceof TemporaryLocalVariable)) continue;
                TemporaryLocalVariable tlv = (TemporaryLocalVariable)v;
                if (!this.tmp.get(((DefinedVariablesProblem)this.problem).getDFVar(v))) {
                    undefinedVars.add(tlv);
                }
                this.tmp.set(((DefinedVariablesProblem)this.problem).getDFVar(tlv));
            }
            if (i2 instanceof ClosureAcceptingInstr && (o = ((ClosureAcceptingInstr)((Object)i2)).getClosureArg()) != null && o instanceof WrappedIRClosure) {
                this.identifyUndefinedVarsInClosure(undefinedVars, ((WrappedIRClosure)o).getClosure(), 0);
            }
            if (!(i2 instanceof ResultInstr)) continue;
            this.tmp.set(((DefinedVariablesProblem)this.problem).getDFVar(((ResultInstr)((Object)i2)).getResult()));
        }
    }

    @Override
    public boolean solutionChanged() {
        return !this.tmp.equals(this.out);
    }

    @Override
    public void finalizeSolution() {
        this.out = this.tmp;
    }

    private String printSet(BitSet set) {
        StringBuilder buf = new StringBuilder();
        int count2 = 0;
        for (int i2 = 0; i2 < set.size(); ++i2) {
            if (!set.get(i2)) continue;
            buf.append(' ').append(((DefinedVariablesProblem)this.problem).getVariable(i2));
            if (++count2 % 10 != 0) continue;
            buf.append("\t\n");
        }
        if (count2 % 10 != 0) {
            buf.append("\t\t");
        }
        return buf.append('\n').toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("\tVars defined on Entry: ");
        if (this.in == null) {
            System.out.println("-- NO in!");
        } else {
            buf.append(this.printSet(this.in));
        }
        buf.append("\n\tVars defined on Exit: ");
        if (this.out == null) {
            System.out.println("-- NO out!");
        } else {
            buf.append(this.printSet(this.out));
        }
        return buf.append('\n').toString();
    }
}

