/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConcurrentFactoryMap<T, V>
extends FactoryMap<T, V> {
    @Override
    protected Map<T, V> createMap() {
        return ContainerUtil.newConcurrentMap();
    }

    @NotNull
    public static <T, V> ConcurrentFactoryMap<T, V> createConcurrentMap(final @NotNull Function<T, V> computeValue) {
        if (computeValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computeValue", "com/intellij/util/containers/ConcurrentFactoryMap", "createConcurrentMap"));
        }
        ConcurrentFactoryMap concurrentFactoryMap = new ConcurrentFactoryMap<T, V>(){

            @Override
            @Nullable
            protected V create(T key) {
                return computeValue.fun(key);
            }
        };
        if (concurrentFactoryMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentFactoryMap", "createConcurrentMap"));
        }
        return concurrentFactoryMap;
    }
}

