/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import java.io.PrintStream;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class SimpleClassPrinter
implements ClassVisitor,
MemberVisitor {
    private final boolean printAccessModifiers;
    private final PrintStream ps;

    public SimpleClassPrinter() {
        this(true);
    }

    public SimpleClassPrinter(boolean bl) {
        this(bl, System.out);
    }

    public SimpleClassPrinter(boolean bl, PrintStream printStream) {
        this.printAccessModifiers = bl;
        this.ps = printStream;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        this.ps.println(ClassUtil.externalFullClassDescription(this.printAccessModifiers ? programClass.getAccessFlags() : 0, programClass.getName()));
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        this.ps.println(ClassUtil.externalFullClassDescription(this.printAccessModifiers ? libraryClass.getAccessFlags() : 0, libraryClass.getName()));
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        this.ps.println(ClassUtil.externalFullClassDescription(this.printAccessModifiers ? programClass.getAccessFlags() : 0, programClass.getName()) + ": " + ClassUtil.externalFullFieldDescription(this.printAccessModifiers ? programField.getAccessFlags() : 0, programField.getName(programClass), programField.getDescriptor(programClass)));
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        this.ps.println(ClassUtil.externalFullClassDescription(this.printAccessModifiers ? programClass.getAccessFlags() : 0, programClass.getName()) + ": " + ClassUtil.externalFullMethodDescription(programClass.getName(), this.printAccessModifiers ? programMethod.getAccessFlags() : 0, programMethod.getName(programClass), programMethod.getDescriptor(programClass)));
    }

    @Override
    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        this.ps.println(ClassUtil.externalFullClassDescription(this.printAccessModifiers ? libraryClass.getAccessFlags() : 0, libraryClass.getName()) + ": " + ClassUtil.externalFullFieldDescription(this.printAccessModifiers ? libraryField.getAccessFlags() : 0, libraryField.getName(libraryClass), libraryField.getDescriptor(libraryClass)));
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        this.ps.println(ClassUtil.externalFullClassDescription(this.printAccessModifiers ? libraryClass.getAccessFlags() : 0, libraryClass.getName()) + ": " + ClassUtil.externalFullMethodDescription(libraryClass.getName(), this.printAccessModifiers ? libraryMethod.getAccessFlags() : 0, libraryMethod.getName(libraryClass), libraryMethod.getDescriptor(libraryClass)));
    }
}

