/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.vncviewer;

import com.tigervnc.rfb.PixelFormat;
import com.tigervnc.rfb.Rect;
import com.tigervnc.vncviewer.PlatformPixelBuffer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class JavaPixelBuffer
extends PlatformPixelBuffer {
    public JavaPixelBuffer(int n, int n2) {
        super(JavaPixelBuffer.getPreferredPF(), n, n2, JavaPixelBuffer.getPreferredPF().getColorModel().createCompatibleWritableRaster(n, n2));
        this.image = new BufferedImage(JavaPixelBuffer.getPreferredPF().getColorModel(), this.getBufferRW(new Rect(0, 0, n, n2)), true, null);
        this.image.setAccelerationPriority(1.0f);
    }

    @Override
    public synchronized void fillRect(Rect rect, byte[] byArray) {
        ColorModel colorModel = this.format.getColorModel();
        int n = ByteBuffer.wrap(byArray).order(this.format.getByteOrder()).asIntBuffer().get(0);
        Color color = new Color(colorModel.getRGB(n));
        Graphics2D graphics2D = ((BufferedImage)this.image).createGraphics();
        graphics2D.setColor(color);
        graphics2D.fillRect(rect.tl.x, rect.tl.y, rect.width(), rect.height());
        graphics2D.dispose();
        this.commitBufferRW(rect);
    }

    private static PixelFormat getPreferredPF() {
        int n;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        ColorModel colorModel = graphicsConfiguration.getColorModel();
        int n2 = n = colorModel.getPixelSize() > 24 ? 24 : colorModel.getPixelSize();
        int n3 = n > 16 ? 32 : (n > 8 ? 16 : 8);
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        boolean bl = byteOrder == ByteOrder.BIG_ENDIAN;
        boolean bl2 = true;
        int n4 = colorModel.getComponentSize()[0] + colorModel.getComponentSize()[1];
        int n5 = colorModel.getComponentSize()[0];
        int n6 = 0;
        int n7 = (int)Math.pow(2.0, colorModel.getComponentSize()[2]) - 1;
        int n8 = (int)Math.pow(2.0, colorModel.getComponentSize()[1]) - 1;
        int n9 = (int)Math.pow(2.0, colorModel.getComponentSize()[0]) - 1;
        return new PixelFormat(n3, n, bl, bl2, n7, n8, n9, n4, n5, n6);
    }
}

