#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: statistics
version: 0.14.0.2
id: statistics-0.14.0.2-DwTksDozTf84s3a0u9j38y
key: statistics-0.14.0.2-DwTksDozTf84s3a0u9j38y
license: BSD2
copyright: 2009-2014 Bryan O'\''Sullivan
maintainer: Bryan O'\''Sullivan <bos@serpentine.com>
homepage: https://github.com/bos/statistics
synopsis: A library of statistical types, data, and functions
description:
    This library provides a number of common functions and types useful
    in statistics.  We focus on high performance, numerical robustness,
    and use of good algorithms.  Where possible, we provide
    references to the statistical literature.
    .
    The library'\''s facilities can be divided into four broad categories:
    .
    * Working with widely used discrete and continuous probability
    distributions.  (There are dozens of exotic distributions in use;
    we focus on the most common.)
    .
    * Computing with sample data: quantile estimation, kernel density
    estimation, histograms, bootstrap methods, significance testing,
    and regression and autocorrelation analysis.
    .
    * Random variate generation under several different distributions.
    .
    * Common statistical tests for significant differences between
    samples.
category: Math, Statistics
author: Bryan O'\''Sullivan <bos@serpentine.com>
exposed: True
exposed-modules:
    Statistics.Autocorrelation Statistics.ConfidenceInt
    Statistics.Correlation Statistics.Correlation.Kendall
    Statistics.Distribution Statistics.Distribution.Beta
    Statistics.Distribution.Binomial
    Statistics.Distribution.CauchyLorentz
    Statistics.Distribution.ChiSquared
    Statistics.Distribution.DiscreteUniform
    Statistics.Distribution.Exponential
    Statistics.Distribution.FDistribution Statistics.Distribution.Gamma
    Statistics.Distribution.Geometric
    Statistics.Distribution.Hypergeometric
    Statistics.Distribution.Laplace Statistics.Distribution.Normal
    Statistics.Distribution.Poisson Statistics.Distribution.StudentT
    Statistics.Distribution.Transform Statistics.Distribution.Uniform
    Statistics.Function Statistics.Math.RootFinding Statistics.Matrix
    Statistics.Matrix.Algorithms Statistics.Matrix.Mutable
    Statistics.Matrix.Types Statistics.Quantile Statistics.Regression
    Statistics.Resampling Statistics.Resampling.Bootstrap
    Statistics.Sample Statistics.Sample.Histogram
    Statistics.Sample.KernelDensity
    Statistics.Sample.KernelDensity.Simple Statistics.Sample.Powers
    Statistics.Test.ChiSquared Statistics.Test.KolmogorovSmirnov
    Statistics.Test.KruskalWallis Statistics.Test.MannWhitneyU
    Statistics.Test.StudentT Statistics.Test.Types
    Statistics.Test.WilcoxonT Statistics.Transform Statistics.Types
hidden-modules: Statistics.Distribution.Poisson.Internal
                Statistics.Function.Comparison Statistics.Internal
                Statistics.Sample.Internal Statistics.Test.Internal
                Statistics.Types.Internal
abi: c92a70c511b69543771185233e965cb2
trusted: False
import-dirs: /usr/lib/ghc-8.0.2/site-local/statistics-0.14.0.2
library-dirs: /usr/lib/ghc-8.0.2/site-local/statistics-0.14.0.2
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.0.2/statistics-0.14.0.2
hs-libraries: HSstatistics-0.14.0.2-DwTksDozTf84s3a0u9j38y
depends:
    aeson-1.1.2.0-3Yc3xmkAyKHC7Vn5OXDFOk base-4.9.1.0
    base-orphans-0.6-AbJ3lKVXygDCG0eeQEv8Iu binary-0.8.3.0
    deepseq-1.4.2.0 erf-2.0.0.0-IIRFGBpxAWtA7x6vFkIoaV
    math-functions-0.2.1.0-F0c8wUJFuGnIPpddl5zobd
    monad-par-0.3.4.8-6k4Aw33MS7Z5Fcws7vaHyh
    mwc-random-0.13.6.0-K5ePRTjCwYQ3u7Qp4sh2LR
    primitive-0.6.2.0-4578caNkWQ54Gt1mxLF2Yh
    vector-0.12.0.1-692PQMDMB6pIQ1uGwefDcQ
    vector-algorithms-0.7.0.1-CyLxDfJFRkcBZ53a4eh1Bl
    vector-binary-instances-0.2.3.5-Do2uVjLEGQcAMYmorIf1G3
    vector-th-unbox-0.2.1.6-46ifXx3IRXQF8ghjmDE5S
haddock-interfaces: /usr/share/doc/haskell-statistics/html/statistics.haddock
haddock-html: /usr/share/doc/haskell-statistics/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
