/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.java.BS;
import org.jmol.minimize.Minimizer;
import org.jmol.minimize.forcefield.CalculationsUFF;
import org.jmol.minimize.forcefield.FFParam;
import org.jmol.minimize.forcefield.ForceField;
import org.jmol.script.T;
import org.jmol.util.Elements;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolAsyncException;

public class ForceFieldUFF
extends ForceField {
    private static Lst<String[]> atomTypes;
    private static Map<Object, Object> ffParams;
    private BS bsAromatic;
    private static final int TOKEN_ELEMENT_ONLY = 0;
    private static final int TOKEN_ELEMENT_CHARGED = 1;
    private static final int TOKEN_ELEMENT_CONNECTED = 2;
    private static final int TOKEN_AROMATIC = 3;
    private static final int TOKEN_ELEMENT_SP = 4;
    private static final int TOKEN_ELEMENT_ALLYLIC = 6;
    private static final int PT_ELEMENT = 2;
    private static final int PT_CHARGE = 5;
    private static final int PT_CONNECT = 6;
    private static final T[][] tokenTypes;

    public ForceFieldUFF(Minimizer minimizer) {
        this.minimizer = minimizer;
        this.name = "UFF";
    }

    @Override
    public void clear() {
        this.bsAromatic = null;
    }

    @Override
    public boolean setModel(BS bsElements, int elemnoMax) throws JmolAsyncException {
        this.setModelFields();
        Logger.info("minimize: setting atom types...");
        if (atomTypes == null && (atomTypes = this.getAtomTypes()) == null) {
            return false;
        }
        if (ffParams == null && (ffParams = this.getFFParameters()) == null) {
            return false;
        }
        this.setAtomTypes(bsElements, elemnoMax);
        this.calc = new CalculationsUFF(this, ffParams, this.minAtoms, this.minBonds, this.minAngles, this.minTorsions, this.minPositions, this.minimizer.constraints);
        return this.calc.setupCalculations();
    }

    private void setAtomTypes(BS bsElements, int elemnoMax) {
        int nTypes = atomTypes.size();
        bsElements.clear(0);
        for (int i = 0; i < nTypes; ++i) {
            String[] data = (String[])atomTypes.get(i);
            String smarts = data[0];
            if (smarts == null) continue;
            BS search = this.getSearch(smarts, elemnoMax, bsElements);
            if (bsElements.get(0)) {
                bsElements.clear(0);
                continue;
            }
            if (search == null) break;
            int j = this.minimizer.bsAtoms.nextSetBit(0);
            int pt = 0;
            while (j < this.minimizer.atoms.length && j >= 0) {
                if (search.get(j)) {
                    this.minAtoms[pt].sType = data[1].intern();
                }
                j = this.minimizer.bsAtoms.nextSetBit(j + 1);
                ++pt;
            }
        }
    }

    private BS getSearch(String smarts, int elemnoMax, BS bsElements) {
        T[] search = null;
        int len = smarts.length();
        search = tokenTypes[0];
        int n = smarts.charAt(len - 2) - 48;
        int elemNo = 0;
        if (n >= 10) {
            n = 0;
        }
        boolean isAromatic = false;
        if (smarts.charAt(1) == '#') {
            elemNo = PT.parseInt(smarts.substring(2, len - 1));
        } else {
            String s = smarts.substring(1, n > 0 ? len - 3 : len - 1);
            if (s.equals(s.toLowerCase())) {
                s = s.toUpperCase();
                isAromatic = true;
            }
            elemNo = Elements.elementNumberFromSymbol(s, false);
        }
        if (elemNo > elemnoMax) {
            return null;
        }
        if (!bsElements.get(elemNo)) {
            bsElements.set(0);
            return null;
        }
        switch (smarts.charAt(len - 3)) {
            case 'D': {
                search = tokenTypes[2];
                search[6].intValue = n;
                break;
            }
            case '^': {
                search = tokenTypes[4 + (n - 1)];
                break;
            }
            case '+': {
                search = tokenTypes[1];
                search[5].intValue = n;
                break;
            }
            case '-': {
                search = tokenTypes[1];
                search[5].intValue = -n;
                break;
            }
            case 'A': {
                search = tokenTypes[6];
            }
        }
        search[2].intValue = elemNo;
        Object v = this.minimizer.vwr.evaluateExpression(search);
        if (!(v instanceof BS)) {
            return null;
        }
        BS bs = (BS)v;
        if (isAromatic && bs.nextSetBit(0) >= 0) {
            if (this.bsAromatic == null) {
                this.bsAromatic = (BS)this.minimizer.vwr.evaluateExpression(tokenTypes[3]);
            }
            bs.and(this.bsAromatic);
        }
        if (Logger.debugging && bs.nextSetBit(0) >= 0) {
            Logger.debug(smarts + " minimize atoms=" + bs);
        }
        return bs;
    }

    private Map<Object, Object> getFFParameters() {
        Hashtable<Object, Object> temp = new Hashtable<Object, Object>();
        String resourceName = "UFF.txt";
        BufferedReader br = null;
        try {
            String line;
            br = this.getBufferedReader(resourceName);
            while ((line = br.readLine()) != null) {
                String[] vs = PT.getTokens(line);
                if (vs.length < 13) continue;
                if (Logger.debugging) {
                    Logger.debug(line);
                }
                if (!line.substring(0, 5).equals("param")) continue;
                FFParam ffParam = new FFParam();
                temp.put(vs[1], ffParam);
                ffParam.dVal = new double[11];
                ffParam.sVal = new String[1];
                ffParam.sVal[0] = vs[1];
                ffParam.dVal[0] = PT.parseFloat(vs[2]);
                ffParam.dVal[1] = (double)PT.parseFloat(vs[3]) * (Math.PI / 180);
                ffParam.dVal[2] = PT.parseFloat(vs[4]);
                ffParam.dVal[3] = PT.parseFloat(vs[5]);
                ffParam.dVal[4] = PT.parseFloat(vs[6]);
                ffParam.dVal[5] = PT.parseFloat(vs[7]);
                ffParam.dVal[6] = PT.parseFloat(vs[8]);
                ffParam.dVal[7] = PT.parseFloat(vs[9]);
                ffParam.dVal[8] = PT.parseFloat(vs[10]);
                ffParam.dVal[9] = PT.parseFloat(vs[11]);
                ffParam.dVal[10] = PT.parseFloat(vs[12]);
                ffParam.iVal = new int[1];
                int coord = vs[1].length() > 2 ? (int)vs[1].charAt(2) : 49;
                switch (coord) {
                    case 82: {
                        coord = 50;
                        break;
                    }
                    default: {
                        coord = 49;
                    }
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                }
                ffParam.iVal[0] = coord - 48;
            }
            br.close();
        }
        catch (Exception e) {
            System.err.println("Exception " + e.toString() + " in getResource " + resourceName);
            try {
                br.close();
            }
            catch (Exception ee) {
                // empty catch block
            }
            return null;
        }
        Logger.info(temp.size() + " atom types read from " + resourceName);
        return temp;
    }

    private Lst<String[]> getAtomTypes() throws JmolAsyncException {
        Lst<String[]> types = new Lst<String[]>();
        String fileName = "UFF.txt";
        try {
            String line;
            BufferedReader br = this.getBufferedReader(fileName);
            while ((line = br.readLine()) != null) {
                if (line.length() <= 4 || !line.substring(0, 4).equals("atom")) continue;
                String[] vs = PT.getTokens(line);
                String[] info = new String[]{vs[1], vs[2]};
                types.addLast(info);
            }
            br.close();
        }
        catch (JmolAsyncException e) {
            throw new JmolAsyncException(e.getFileName());
        }
        catch (Exception e) {
            System.err.println("Exception " + e.toString() + " in getResource " + fileName);
        }
        Logger.info(types.size() + " UFF parameters read");
        return types.size() > 0 ? types : null;
    }

    static {
        tokenTypes = new T[][]{{T.tokenExpressionBegin, T.n(268435860, 1094715402), T.i(0), T.tokenExpressionEnd}, {T.tokenExpressionBegin, T.n(268435860, 1094715402), T.i(0), T.tokenAnd, T.n(268435860, 1631586315), T.i(0), T.tokenExpressionEnd}, {T.tokenExpressionBegin, T.n(268435860, 1094715402), T.i(0), T.tokenAnd, T.tokenConnected, T.tokenLeftParen, T.i(0), T.tokenRightParen, T.tokenExpressionEnd}, {T.tokenExpressionBegin, T.o(0x40000000, "flatring"), T.tokenExpressionEnd}, {T.tokenExpressionBegin, T.n(268435860, 1094715402), T.i(0), T.tokenAnd, T.tokenLeftParen, T.tokenConnected, T.tokenLeftParen, T.i(1), T.tokenComma, T.o(4, "triple"), T.tokenRightParen, T.tokenOr, T.tokenConnected, T.tokenLeftParen, T.i(2), T.tokenComma, T.o(4, "double"), T.tokenRightParen, T.tokenRightParen, T.tokenExpressionEnd}, {T.tokenExpressionBegin, T.n(268435860, 1094715402), T.i(0), T.tokenAnd, T.o(0x8000008, "connected"), T.tokenLeftParen, T.i(1), T.tokenComma, T.o(4, "double"), T.tokenRightParen, T.tokenExpressionEnd}, {T.tokenExpressionBegin, T.n(268435860, 1094715402), T.i(0), T.tokenAnd, T.tokenConnected, T.tokenLeftParen, T.i(3), T.tokenRightParen, T.tokenAnd, T.tokenConnected, T.tokenLeftParen, T.tokenConnected, T.tokenLeftParen, T.o(4, "double"), T.tokenRightParen, T.tokenRightParen, T.tokenExpressionEnd}};
    }
}

