/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.alert;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.httpclient.URI;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.model.HistoryReference;
import org.zaproxy.zap.extension.alert.PopupMenuShowAlert;
import org.zaproxy.zap.view.messagecontainer.http.HttpMessageContainer;
import org.zaproxy.zap.view.popup.ExtensionPopupMenuComponent;
import org.zaproxy.zap.view.popup.PopupMenuHistoryReferenceContainer;
import org.zaproxy.zap.view.popup.PopupMenuHttpMessageContainer;

public class PopupMenuShowAlerts
extends PopupMenuHistoryReferenceContainer {
    private static final long serialVersionUID = 1L;

    public PopupMenuShowAlerts(String string) {
        super(string);
        this.setProcessExtensionPopupChildren(false);
    }

    @Override
    public boolean isEnableForInvoker(PopupMenuHttpMessageContainer.Invoker invoker, HttpMessageContainer httpMessageContainer) {
        switch (invoker) {
            case SITES_PANEL: 
            case SPIDER_PANEL: 
            case HISTORY_PANEL: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isButtonEnabledForHistoryReference(HistoryReference historyReference) {
        List<Alert> list = historyReference.getSiteNode() != null ? historyReference.getSiteNode().getAlerts() : historyReference.getAlerts();
        URI uRI = historyReference.getURI();
        ArrayList<PopupMenuShowAlert> arrayList = new ArrayList<PopupMenuShowAlert>(list.size());
        for (Alert comparable : list) {
            if (uRI != null && !comparable.getUri().equals(uRI.toString())) continue;
            PopupMenuShowAlert popupMenuShowAlert = new PopupMenuShowAlert(comparable.getName(), comparable);
            popupMenuShowAlert.setIcon(comparable.getIcon());
            arrayList.add(popupMenuShowAlert);
        }
        Collections.sort(arrayList);
        for (PopupMenuShowAlert popupMenuShowAlert : arrayList) {
            this.add(popupMenuShowAlert);
        }
        return arrayList.size() > 0;
    }

    @Override
    public void dismissed(ExtensionPopupMenuComponent extensionPopupMenuComponent) {
        if (this.getMenuComponentCount() > 0) {
            this.removeAll();
        }
    }

    @Override
    public boolean isSafe() {
        return true;
    }
}

