/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.keyboard;

import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.keyboard.KeyboardAPI;
import org.zaproxy.zap.extension.keyboard.KeyboardMapping;
import org.zaproxy.zap.extension.keyboard.KeyboardParam;
import org.zaproxy.zap.extension.keyboard.KeyboardShortcut;
import org.zaproxy.zap.extension.keyboard.OptionsKeyboardShortcutPanel;
import org.zaproxy.zap.utils.DesktopUtils;
import org.zaproxy.zap.view.ZapMenuItem;

public class ExtensionKeyboard
extends ExtensionAdaptor {
    private static final Logger logger = Logger.getLogger(ExtensionKeyboard.class);
    public static final String NAME = "ExtensionKeyboard";
    private OptionsKeyboardShortcutPanel optionsKeyboardPanel = null;
    private KeyboardParam keyboardParam = null;
    private ReferenceMap map = new ReferenceMap();
    private KeyboardAPI api = null;

    public ExtensionKeyboard() {
        this.initialize();
    }

    private void initialize() {
        this.setName(NAME);
        this.setOrder(2000);
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        if (this.getView() != null) {
            extensionHook.addOptionsParamSet(this.getKeyboardParam());
            extensionHook.getHookView().addOptionPanel(this.getOptionsKeyboardPanel());
            this.api = new KeyboardAPI(this);
            extensionHook.addApiImplementor(this.api);
        }
    }

    protected KeyboardParam getKeyboardParam() {
        if (this.keyboardParam == null) {
            this.keyboardParam = new KeyboardParam();
        }
        return this.keyboardParam;
    }

    @Override
    public void optionsLoaded() {
        if (View.isInitialised()) {
            logger.info((Object)"Initializing keyboard shortcuts");
            this.initAllMenuItems(View.getSingleton().getMainFrame().getMainMenuBar().getMenuFile());
            this.initAllMenuItems(View.getSingleton().getMainFrame().getMainMenuBar().getMenuEdit());
            this.initAllMenuItems(View.getSingleton().getMainFrame().getMainMenuBar().getMenuAnalyse());
            this.initAllMenuItems(View.getSingleton().getMainFrame().getMainMenuBar().getMenuReport());
            this.initAllMenuItems(View.getSingleton().getMainFrame().getMainMenuBar().getMenuTools());
            this.initAllMenuItems(View.getSingleton().getMainFrame().getMainMenuBar().getMenuView());
            this.initAllMenuItems(View.getSingleton().getMainFrame().getMainMenuBar().getMenuHelp());
        }
    }

    public void registerMenuItem(ZapMenuItem zapMenuItem) {
        KeyboardMapping keyboardMapping = this.menuToMapping(zapMenuItem);
        String string = keyboardMapping.getIdentifier();
        if (string != null) {
            this.map.put((Object)string, (Object)keyboardMapping);
        } else {
            logger.warn((Object)("ZapMenuItem \"" + keyboardMapping.getName() + "\" has a null identifier."));
        }
    }

    private void initAllMenuItems(JMenu jMenu) {
        for (Component component : jMenu.getMenuComponents()) {
            if (component instanceof ZapMenuItem) {
                this.registerMenuItem((ZapMenuItem)component);
                continue;
            }
            if (component instanceof JMenu) {
                this.initAllMenuItems((JMenu)component);
                continue;
            }
            if (!(component instanceof JMenuItem)) continue;
            JMenuItem jMenuItem = (JMenuItem)component;
            logger.debug((Object)("Unable to set accelerators on menu " + jMenuItem.getText()));
        }
    }

    private KeyboardMapping menuToMapping(ZapMenuItem zapMenuItem) {
        KeyStroke keyStroke = this.getKeyboardParam().getShortcut(zapMenuItem.getIdenfifier());
        if (keyStroke != null) {
            if (keyStroke.getKeyCode() == 0) {
                logger.debug((Object)("Cleaning menu " + zapMenuItem.getIdenfifier() + " accelerator"));
                zapMenuItem.setAccelerator(null);
            } else {
                logger.debug((Object)("Setting menu " + zapMenuItem.getIdenfifier() + " accelerator to " + keyStroke.toString()));
                zapMenuItem.setAccelerator(keyStroke);
            }
        }
        return new KeyboardMapping(zapMenuItem);
    }

    public List<KeyboardShortcut> getShortcuts() {
        return this.getShortcuts(false);
    }

    public List<KeyboardShortcut> getShortcuts(boolean bl) {
        if (View.isInitialised()) {
            ArrayList<KeyboardShortcut> arrayList = new ArrayList<KeyboardShortcut>();
            this.addAllMenuItems(arrayList, View.getSingleton().getMainFrame().getMainMenuBar().getMenuFile(), bl);
            this.addAllMenuItems(arrayList, View.getSingleton().getMainFrame().getMainMenuBar().getMenuEdit(), bl);
            this.addAllMenuItems(arrayList, View.getSingleton().getMainFrame().getMainMenuBar().getMenuAnalyse(), bl);
            this.addAllMenuItems(arrayList, View.getSingleton().getMainFrame().getMainMenuBar().getMenuReport(), bl);
            this.addAllMenuItems(arrayList, View.getSingleton().getMainFrame().getMainMenuBar().getMenuTools(), bl);
            this.addAllMenuItems(arrayList, View.getSingleton().getMainFrame().getMainMenuBar().getMenuView(), bl);
            this.addAllMenuItems(arrayList, View.getSingleton().getMainFrame().getMainMenuBar().getMenuHelp(), bl);
            return arrayList;
        }
        return null;
    }

    private void addAllMenuItems(List<KeyboardShortcut> list, JMenu jMenu, boolean bl) {
        for (Component component : jMenu.getMenuComponents()) {
            if (component instanceof ZapMenuItem) {
                list.add(this.menuToShortcut((ZapMenuItem)component, bl));
                continue;
            }
            if (component instanceof JMenu) {
                this.addAllMenuItems(list, (JMenu)component, bl);
                continue;
            }
            if (!(component instanceof JMenuItem)) continue;
            JMenuItem jMenuItem = (JMenuItem)component;
            logger.debug((Object)("Unable to set accelerators on menu " + jMenuItem.getText()));
        }
    }

    private KeyboardShortcut menuToShortcut(ZapMenuItem zapMenuItem, boolean bl) {
        if (bl) {
            return new KeyboardShortcut(zapMenuItem.getIdenfifier(), zapMenuItem.getText(), zapMenuItem.getDefaultAccelerator());
        }
        KeyStroke keyStroke = this.getKeyboardParam().getShortcut(zapMenuItem.getIdenfifier());
        if (keyStroke != null) {
            if (keyStroke.getKeyCode() == 0) {
                logger.debug((Object)("Cleaning menu " + zapMenuItem.getIdenfifier() + " accelerator"));
                zapMenuItem.setAccelerator(null);
            } else {
                logger.debug((Object)("Setting menu " + zapMenuItem.getIdenfifier() + " accelerator to " + keyStroke.toString()));
                zapMenuItem.setAccelerator(keyStroke);
            }
        }
        return new KeyboardShortcut(zapMenuItem.getIdenfifier(), zapMenuItem.getText(), zapMenuItem.getAccelerator());
    }

    public KeyStroke getShortcut(String string) {
        KeyboardMapping keyboardMapping = (KeyboardMapping)this.map.get((Object)string);
        if (keyboardMapping == null) {
            return null;
        }
        return keyboardMapping.getKeyStroke();
    }

    public void setShortcut(String string, KeyStroke keyStroke) {
        KeyboardMapping keyboardMapping = (KeyboardMapping)this.map.get((Object)string);
        if (keyboardMapping == null) {
            logger.error((Object)("No mapping found for keyboard shortcut: " + string));
            return;
        }
        keyboardMapping.setKeyStroke(keyStroke);
        this.getKeyboardParam().setShortcut(string, keyStroke);
    }

    private OptionsKeyboardShortcutPanel getOptionsKeyboardPanel() {
        if (this.optionsKeyboardPanel == null) {
            this.optionsKeyboardPanel = new OptionsKeyboardShortcutPanel(this);
        }
        return this.optionsKeyboardPanel;
    }

    public void displayCheatsheetSortedByAction() {
        try {
            DesktopUtils.openUrlInBrowser(this.api.getCheatSheetActionURI());
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    public void displayCheatsheetSortedByKey() {
        try {
            DesktopUtils.openUrlInBrowser(this.api.getCheatSheetKeyURI());
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("keyboard.desc");
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public boolean supportsDb(String string) {
        return true;
    }
}

