/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ruleconfig;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.parosproxy.paros.common.AbstractParam;
import org.zaproxy.zap.extension.ruleconfig.RuleConfig;

public class RuleConfigParam
extends AbstractParam {
    public static final String RULE_COMMON_SLEEP_TIME = "rules.common.sleep";
    public static final String RULE_CSRF_IGNORE_LIST = "rules.csrf.ignorelist";
    public static final String RULE_CSRF_IGNORE_ATT_NAME = "rules.csrf.ignore.attname";
    public static final String RULE_CSRF_IGNORE_ATT_VALUE = "rules.csrf.ignore.attvalue";
    public static final String RULE_COOKIE_IGNORE_LIST = "rules.cookie.ignorelist";
    public static final int RULE_DEFAULT_COMMON_SLEEP_TIME = 15;
    private static final String RULES_BASE_KEY = "rules";
    private static final String RULES_DEFAULT_KEY_EXT = ".default";
    private Map<String, RuleConfig> ruleConfigs = new HashMap<String, RuleConfig>();

    @Override
    protected void parse() {
        this.addRuleConfig(new RuleConfig(RULE_COMMON_SLEEP_TIME, Integer.toString(15)));
        this.addRuleConfig(new RuleConfig(RULE_CSRF_IGNORE_LIST, ""));
        this.addRuleConfig(new RuleConfig(RULE_CSRF_IGNORE_ATT_NAME, ""));
        this.addRuleConfig(new RuleConfig(RULE_CSRF_IGNORE_ATT_VALUE, ""));
        this.addRuleConfig(new RuleConfig(RULE_COOKIE_IGNORE_LIST, ""));
        Iterator iterator = this.getConfig().getKeys(RULES_BASE_KEY);
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.ruleConfigs.containsKey(string)) {
                this.ruleConfigs.get(string).setValue(this.getConfig().getString(string));
                continue;
            }
            RuleConfig ruleConfig = new RuleConfig(string, this.getConfig().getString(string + RULES_DEFAULT_KEY_EXT, ""), this.getConfig().getString(string));
            this.ruleConfigs.put(ruleConfig.getKey(), ruleConfig);
        }
    }

    public void addRuleConfig(RuleConfig ruleConfig) {
        this.ruleConfigs.put(ruleConfig.getKey(), ruleConfig);
        if (!this.getConfig().containsKey(ruleConfig.getKey())) {
            this.getConfig().setProperty(ruleConfig.getKey(), (Object)ruleConfig.getValue());
        }
    }

    public void addRuleConfig(String string, String string2, String string3) {
        this.ruleConfigs.put(string, new RuleConfig(string, string2, string3));
        if (!this.getConfig().containsKey(string)) {
            this.getConfig().setProperty(string, (Object)string3);
        }
    }

    public RuleConfig getRuleConfig(String string) {
        if (this.ruleConfigs.containsKey(string)) {
            return this.ruleConfigs.get(string).clone();
        }
        return null;
    }

    public List<RuleConfig> getAllRuleConfigs() {
        ArrayList<RuleConfig> arrayList = new ArrayList<RuleConfig>();
        for (RuleConfig ruleConfig : this.ruleConfigs.values()) {
            arrayList.add(ruleConfig.clone());
        }
        return arrayList;
    }

    public String getRuleConfigValue(String string) {
        if (this.ruleConfigs.containsKey(string)) {
            return this.ruleConfigs.get(string).getValue();
        }
        return null;
    }

    public String getRuleConfigDefaultValue(String string) {
        if (this.ruleConfigs.containsKey(string)) {
            return this.ruleConfigs.get(string).getDefaultValue();
        }
        return null;
    }

    public void setRuleConfigValue(String string, String string2) {
        if (!this.ruleConfigs.containsKey(string)) {
            throw new IllegalArgumentException("No such key");
        }
        this.ruleConfigs.get(string).setValue(string2);
        this.getConfig().setProperty(string, (Object)string2);
    }

    public void resetRuleConfigValue(String string) {
        if (!this.ruleConfigs.containsKey(string)) {
            throw new IllegalArgumentException("No such key");
        }
        String string2 = this.ruleConfigs.get(string).getDefaultValue();
        this.ruleConfigs.get(string).setValue(string2);
        this.getConfig().setProperty(string, (Object)string2);
    }

    public void resetAllRuleConfigValues() {
        for (RuleConfig ruleConfig : this.ruleConfigs.values()) {
            ruleConfig.reset();
            this.getConfig().setProperty(ruleConfig.getKey(), (Object)ruleConfig.getValue());
        }
    }
}

