/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.CombiningIterator;
import ch.interlis.ili2c.metamodel.Contract;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Function;
import ch.interlis.ili2c.metamodel.GraphicParameterDef;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.Importable;
import ch.interlis.ili2c.metamodel.LineForm;
import ch.interlis.ili2c.metamodel.MetaDataUseDef;
import ch.interlis.ili2c.metamodel.PredefinedModel;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TypeModel;
import ch.interlis.ili2c.metamodel.Unit;
import java.beans.PropertyVetoException;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class Model
extends Importable {
    protected List contents = new LinkedList();
    protected List runtimeParameters = new LinkedList();
    protected List qualifiedImports = new LinkedList();
    protected List unqualifiedImports = new LinkedList();
    private List contracts = new LinkedList();
    private String language = null;
    private boolean contracted = false;
    private String issuer = null;
    private String modelVersion = null;
    private String modelVersionExpl = null;
    private String iliVersion = "2.3";
    public static final String ILI1 = "1";
    public static final String ILI2_2 = "2.2";
    public static final String ILI2_3 = "2.3";
    private String filename = null;

    public void addPreLast(Object o) {
        if (!((ElementDelegate)this.elements).checkChildElement(o)) {
            return;
        }
        try {
            ((Element)o).setBeanContext(this);
        }
        catch (PropertyVetoException pve) {
            throw new IllegalArgumentException(pve.getLocalizedMessage());
        }
        if (o instanceof GraphicParameterDef) {
            this.runtimeParameters.add(o);
        }
        this.contents.add(this.contents.size() - 1, o);
    }

    public void addBefore(Object o, Object last) {
        int idx;
        if (!((ElementDelegate)this.elements).checkChildElement(o)) {
            return;
        }
        try {
            ((Element)o).setBeanContext(this);
        }
        catch (PropertyVetoException pve) {
            throw new IllegalArgumentException(pve.getLocalizedMessage());
        }
        if (o instanceof GraphicParameterDef) {
            this.runtimeParameters.add(o);
        }
        if ((idx = this.contents.indexOf(last)) > -1) {
            this.contents.add(idx, o);
        } else {
            this.contents.add(o);
        }
    }

    protected Model() {
        this.name = "";
    }

    protected Collection createElements() {
        return new ElementDelegate();
    }

    public Element getImportedElement(Class aclass, String name) {
        Element e = this.getElement(aclass, name);
        if (e != null) {
            return e;
        }
        Iterator it = this.unqualifiedImports.iterator();
        while (it.hasNext()) {
            Model i = (Model)it.next();
            e = i.getElement(aclass, name);
            if (e == null) continue;
            return e;
        }
        return null;
    }

    private Element getElement(String name) {
        if (name == null) {
            return null;
        }
        Iterator it = this.contents.iterator();
        while (it.hasNext()) {
            Element e = (Element)it.next();
            if (!name.equals(e.getName())) continue;
            return e;
        }
        return null;
    }

    private Element getRuntimeParameter(String name) {
        if (name == null) {
            return null;
        }
        Iterator it = this.runtimeParameters.iterator();
        while (it.hasNext()) {
            Element e = (Element)it.next();
            if (!name.equals(e.getName())) continue;
            return e;
        }
        return null;
    }

    public boolean isDependentOn(Element e) {
        if (e instanceof Model) {
            return this.isImporting((Model)e);
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) throws PropertyVetoException {
        String oldValue = this.name;
        String newValue = name;
        Model.checkNameSanity(newValue, false);
        this.fireVetoableChange("name", oldValue, newValue);
        this.name = newValue;
        this.firePropertyChange("name", oldValue, newValue);
    }

    public boolean isContracted() {
        return this.contracted || !this.contracts.isEmpty();
    }

    public void setContracted(boolean contracted1) {
        this.contracted = contracted1;
    }

    public void setIssuer(String issuer1) {
        this.issuer = issuer1;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setModelVersion(String modelVersion1) {
        this.modelVersion = modelVersion1;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public void setModelVersionExpl(String modelVersionExpl1) {
        this.modelVersionExpl = modelVersionExpl1;
    }

    public String getModelVersionExpl() {
        return this.modelVersionExpl;
    }

    public void addContract(Contract contract) {
        this.contracts.add(contract);
    }

    public Contract[] getContracts() {
        return this.contracts.toArray(new Contract[0]);
    }

    public Model[] getImporting() {
        LinkedList importing = new LinkedList();
        importing.addAll(this.qualifiedImports);
        importing.addAll(this.unqualifiedImports);
        return importing.toArray(new Model[0]);
    }

    public void addImport(Model importing, boolean unqualified) {
        if (unqualified) {
            this.unqualifiedImports.add(importing);
        } else {
            this.qualifiedImports.add(importing);
        }
        importing.importedBy.add(importing);
    }

    public boolean isImporting(Model importing) {
        return this.qualifiedImports.contains(importing) || this.unqualifiedImports.contains(importing);
    }

    public boolean isImporting(Model importing, boolean qualifiedImport) {
        if (qualifiedImport) {
            return this.qualifiedImports.contains(importing);
        }
        return this.unqualifiedImports.contains(importing);
    }

    public void setLanguage(String v) {
        this.language = v;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setFileName(String filename) {
        this.filename = filename;
    }

    public String getFileName() {
        return this.filename;
    }

    public String getIliVersion() {
        return this.iliVersion;
    }

    public void setIliVersion(String string) {
        this.iliVersion = string;
    }

    protected class ElementDelegate
    extends AbstractCollection {
        protected ElementDelegate() {
        }

        public Iterator iterator() {
            return new CombiningIterator(new Iterator[]{Model.this.runtimeParameters.iterator(), Model.this.contents.iterator()});
        }

        public int size() {
            return Model.this.runtimeParameters.size() + Model.this.contents.size();
        }

        public boolean add(Object o) {
            if (!this.checkChildElement(o)) {
                return false;
            }
            if (o instanceof GraphicParameterDef) {
                return Model.this.runtimeParameters.add(o);
            }
            return Model.this.contents.add(o);
        }

        public boolean checkChildElement(Object o) {
            Element e = (Element)o;
            if (o instanceof MetaDataUseDef) {
                Element conflicting = Model.this.getElement(e.getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(e.getSourceLine(), Model.formatMessage("err_nonuniqueMetaDataUseDefName", e.getName(), Model.this.toString()));
                }
                return true;
            }
            if (o instanceof Unit) {
                Element conflicting = Model.this.getElement(e.getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(e.getSourceLine(), Model.formatMessage("err_duplicateUnitName", e.getName(), Model.this.toString()));
                }
                return true;
            }
            if (o instanceof Function) {
                if (!Model.this.isContracted() && !(Model.this instanceof PredefinedModel)) {
                    throw new Ili2cSemanticException(e.getSourceLine(), Model.formatMessage("err_model_functionButNoContract", e.toString(), Model.this.toString()));
                }
                Element conflicting = Model.this.getElement(e.getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(e.getSourceLine(), Model.formatMessage("err_function_duplicateName", e.getName(), Model.this.toString(), conflicting.toString()));
                }
                return true;
            }
            if (o instanceof LineForm) {
                if (!Model.this.isContracted() && !(Model.this instanceof PredefinedModel)) {
                    throw new Ili2cSemanticException(e.getSourceLine(), Model.formatMessage("err_lineForm_inUnconctractedModel", Model.this.toString()));
                }
                Element conflicting = Model.this.getElement(e.getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(e.getSourceLine(), Model.formatMessage("err_lineForm_duplicateName", e.getName(), Model.this.toString(), conflicting.toString()));
                }
                return true;
            }
            if (o instanceof Domain) {
                Element conflicting = Model.this.getElement(e.getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(e.getSourceLine(), Model.formatMessage("err_duplicateDomainName", e.getName(), Model.this.toString()));
                }
                return true;
            }
            if (o instanceof GraphicParameterDef) {
                Element conflicting = Model.this.getRuntimeParameter(e.getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(e.getSourceLine(), Model.formatMessage("err_graphicparam_nonunique", e.getName(), Model.this.toString()));
                }
                return true;
            }
            if (o instanceof Topic) {
                if (Model.this instanceof TypeModel) {
                    throw new Ili2cSemanticException(e.getSourceLine(), Model.formatMessage("err_typeModel_addTopic", o.toString(), Model.this.toString()));
                }
                Element conflicting = Model.this.getElement(e.getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(e.getSourceLine(), Model.formatMessage("err_topic_nonunique", e.getName(), Model.this.toString()));
                }
                return true;
            }
            if (o instanceof Table) {
                Element conflicting = Model.this.getElement(e.getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(e.getSourceLine(), Model.formatMessage("err_table_nonunique", e.getName(), Model.this.toString()));
                }
                return true;
            }
            throw new ClassCastException(Model.formatMessage("err_container_cannotContain", Model.this.toString(), o.toString()));
        }
    }
}

