/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.plugin;

import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeApplication;
import com.eteks.sweethome3d.model.RecorderException;
import com.eteks.sweethome3d.plugin.Plugin;
import com.eteks.sweethome3d.plugin.PluginManager;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.HomeController;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HomePluginController
extends HomeController {
    private final Home home;
    private final HomeApplication application;
    private final PluginManager pluginManager;

    public HomePluginController(Home home, HomeApplication homeApplication, ViewFactory viewFactory, ContentManager contentManager, PluginManager pluginManager) {
        super(home, homeApplication, viewFactory, contentManager);
        this.home = home;
        this.application = homeApplication;
        this.pluginManager = pluginManager;
    }

    public List<Plugin> getPlugins() {
        if (this.application != null && this.pluginManager != null) {
            return this.pluginManager.getPlugins(this.application, this.home, this.application.getUserPreferences(), this, this.getUndoableEditSupport());
        }
        List<Plugin> list = Collections.emptyList();
        return list;
    }

    public void importPlugin(String string) {
        if (this.pluginManager != null) {
            try {
                if (!this.pluginManager.pluginExists(string) || this.getView().confirmReplacePlugin(string)) {
                    this.pluginManager.addPlugin(string);
                    this.getView().showMessage(this.application.getUserPreferences().getLocalizedString(HomeController.class, "importedPluginMessage", new Object[0]));
                }
            }
            catch (RecorderException recorderException) {
                String string2 = this.application.getUserPreferences().getLocalizedString(HomeController.class, "importPluginError", string);
                this.getView().showError(string2);
            }
        }
    }
}

