/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.store;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.BaseNodeRequest;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.gateway.AsyncShardFetch;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetaData;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportNodesListShardStoreMetaData
extends TransportNodesAction<Request, NodesStoreFilesMetaData, NodeRequest, NodeStoreFilesMetaData>
implements AsyncShardFetch.Lister<NodesStoreFilesMetaData, NodeStoreFilesMetaData> {
    public static final String ACTION_NAME = "internal:cluster/nodes/indices/shard/store";
    private final IndicesService indicesService;
    private final NodeEnvironment nodeEnv;

    @Inject
    public TransportNodesListShardStoreMetaData(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, IndicesService indicesService, NodeEnvironment nodeEnv, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, ACTION_NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, Request::new, NodeRequest::new, "fetch_shard_store", NodeStoreFilesMetaData.class);
        this.indicesService = indicesService;
        this.nodeEnv = nodeEnv;
    }

    @Override
    public void list(ShardId shardId, DiscoveryNode[] nodes, ActionListener<NodesStoreFilesMetaData> listener) {
        this.execute(new Request(shardId, nodes), listener);
    }

    @Override
    protected NodeRequest newNodeRequest(String nodeId, Request request) {
        return new NodeRequest(nodeId, request);
    }

    @Override
    protected NodeStoreFilesMetaData newNodeResponse() {
        return new NodeStoreFilesMetaData();
    }

    @Override
    protected NodesStoreFilesMetaData newResponse(Request request, List<NodeStoreFilesMetaData> responses, List<FailedNodeException> failures) {
        return new NodesStoreFilesMetaData(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeStoreFilesMetaData nodeOperation(NodeRequest request) {
        try {
            return new NodeStoreFilesMetaData(this.clusterService.localNode(), this.listStoreMetaData(request.shardId));
        }
        catch (IOException e) {
            throw new ElasticsearchException("Failed to list store metadata for shard [" + request.shardId + "]", (Throwable)e, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StoreFilesMetaData listStoreMetaData(ShardId shardId) throws IOException {
        this.logger.trace("listing store meta data for {}", (Object)shardId);
        long startTimeNS = System.nanoTime();
        boolean exists = false;
        try {
            IndexShard indexShard;
            IndexService indexService = this.indicesService.indexService(shardId.getIndex());
            if (indexService != null && (indexShard = indexService.getShardOrNull(shardId.id())) != null) {
                exists = true;
                StoreFilesMetaData storeFilesMetaData = new StoreFilesMetaData(shardId, indexShard.snapshotStoreMetadata());
                return storeFilesMetaData;
            }
            IndexMetaData metaData = this.clusterService.state().metaData().index(shardId.getIndex());
            if (metaData == null) {
                metaData = IndexMetaData.FORMAT.loadLatestState(this.logger, NamedXContentRegistry.EMPTY, this.nodeEnv.indexPaths(shardId.getIndex()));
            }
            if (metaData == null) {
                this.logger.trace("{} node doesn't have meta data for the requests index, responding with empty", (Object)shardId);
                StoreFilesMetaData storeFilesMetaData = new StoreFilesMetaData(shardId, Store.MetadataSnapshot.EMPTY);
                return storeFilesMetaData;
            }
            IndexSettings indexSettings = indexService != null ? indexService.getIndexSettings() : new IndexSettings(metaData, this.settings);
            ShardPath shardPath = ShardPath.loadShardPath(this.logger, this.nodeEnv, shardId, indexSettings);
            if (shardPath == null) {
                StoreFilesMetaData storeFilesMetaData = new StoreFilesMetaData(shardId, Store.MetadataSnapshot.EMPTY);
                return storeFilesMetaData;
            }
            StoreFilesMetaData storeFilesMetaData = new StoreFilesMetaData(shardId, Store.readMetadataSnapshot(shardPath.resolveIndex(), shardId, this.nodeEnv::shardLock, this.logger));
            return storeFilesMetaData;
        }
        finally {
            TimeValue took = new TimeValue(System.nanoTime() - startTimeNS, TimeUnit.NANOSECONDS);
            if (exists) {
                this.logger.debug("{} loaded store meta data (took [{}])", (Object)shardId, (Object)took);
            } else {
                this.logger.trace("{} didn't find any store meta data to load (took [{}])", (Object)shardId, (Object)took);
            }
        }
    }

    public static class NodeStoreFilesMetaData
    extends BaseNodeResponse {
        private StoreFilesMetaData storeFilesMetaData;

        NodeStoreFilesMetaData() {
        }

        public NodeStoreFilesMetaData(DiscoveryNode node, StoreFilesMetaData storeFilesMetaData) {
            super(node);
            this.storeFilesMetaData = storeFilesMetaData;
        }

        public StoreFilesMetaData storeFilesMetaData() {
            return this.storeFilesMetaData;
        }

        public static NodeStoreFilesMetaData readListShardStoreNodeOperationResponse(StreamInput in) throws IOException {
            NodeStoreFilesMetaData resp = new NodeStoreFilesMetaData();
            resp.readFrom(in);
            return resp;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.storeFilesMetaData = StoreFilesMetaData.readStoreFilesMetaData(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.storeFilesMetaData.writeTo(out);
        }

        public String toString() {
            return "[[" + this.getNode() + "][" + this.storeFilesMetaData + "]]";
        }
    }

    public static class NodeRequest
    extends BaseNodeRequest {
        private ShardId shardId;

        public NodeRequest() {
        }

        NodeRequest(String nodeId, Request request) {
            super(nodeId);
            this.shardId = request.shardId;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.shardId = ShardId.readShardId(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
        }
    }

    public static class NodesStoreFilesMetaData
    extends BaseNodesResponse<NodeStoreFilesMetaData> {
        NodesStoreFilesMetaData() {
        }

        public NodesStoreFilesMetaData(ClusterName clusterName, List<NodeStoreFilesMetaData> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        @Override
        protected List<NodeStoreFilesMetaData> readNodesFrom(StreamInput in) throws IOException {
            return in.readList(NodeStoreFilesMetaData::readListShardStoreNodeOperationResponse);
        }

        @Override
        protected void writeNodesTo(StreamOutput out, List<NodeStoreFilesMetaData> nodes) throws IOException {
            out.writeStreamableList(nodes);
        }
    }

    public static class Request
    extends BaseNodesRequest<Request> {
        private ShardId shardId;

        public Request() {
        }

        public Request(ShardId shardId, DiscoveryNode[] nodes) {
            super(nodes);
            this.shardId = shardId;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.shardId = ShardId.readShardId(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
        }
    }

    public static class StoreFilesMetaData
    implements Iterable<StoreFileMetaData>,
    Streamable {
        private ShardId shardId;
        Store.MetadataSnapshot metadataSnapshot;

        StoreFilesMetaData() {
        }

        public StoreFilesMetaData(ShardId shardId, Store.MetadataSnapshot metadataSnapshot) {
            this.shardId = shardId;
            this.metadataSnapshot = metadataSnapshot;
        }

        public ShardId shardId() {
            return this.shardId;
        }

        public boolean isEmpty() {
            return this.metadataSnapshot.size() == 0;
        }

        @Override
        public Iterator<StoreFileMetaData> iterator() {
            return this.metadataSnapshot.iterator();
        }

        public boolean fileExists(String name) {
            return this.metadataSnapshot.asMap().containsKey(name);
        }

        public StoreFileMetaData file(String name) {
            return this.metadataSnapshot.asMap().get(name);
        }

        public static StoreFilesMetaData readStoreFilesMetaData(StreamInput in) throws IOException {
            StoreFilesMetaData md = new StoreFilesMetaData();
            md.readFrom(in);
            return md;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.shardId = ShardId.readShardId(in);
            this.metadataSnapshot = new Store.MetadataSnapshot(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.shardId.writeTo(out);
            this.metadataSnapshot.writeTo(out);
        }

        public String syncId() {
            return this.metadataSnapshot.getSyncId();
        }

        public String toString() {
            return "StoreFilesMetaData{, shardId=" + this.shardId + ", metadataSnapshot{size=" + this.metadataSnapshot.size() + ", syncId=" + this.metadataSnapshot.getSyncId() + "}" + '}';
        }
    }
}

